/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.httpclient.URLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class MtaAuthHost
extends AttributeCallback {
    public void preModify(Map context, String attrName, Object value, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        AttributeCallback.MultiValueMod mod = this.multiValueMod(attrsToModify, "zimbraMtaAuthHost");
        Set<String> values = mod.valuesSet();
        if (mod.adding()) {
            ArrayList<String> urlsToAdd = new ArrayList<String>();
            for (String authHost : values) {
                String authUrl = URLUtil.getMtaAuthURL(authHost);
                urlsToAdd.add(authUrl);
            }
            if (urlsToAdd.size() > 0) {
                attrsToModify.put("+zimbraMtaAuthURL", urlsToAdd.toArray(new String[urlsToAdd.size()]));
            }
        } else if (mod.replacing()) {
            ArrayList<String> urls = new ArrayList<String>();
            for (String authHost : values) {
                String authUrl = URLUtil.getMtaAuthURL(authHost);
                urls.add(authUrl);
            }
            if (urls.size() > 0) {
                attrsToModify.put("zimbraMtaAuthURL", urls.toArray(new String[urls.size()]));
            }
        } else if (mod.removing()) {
            if (!isCreate && entry != null) {
                Set<String> curUrls = entry.getMultiAttrSet("zimbraMtaAuthURL");
                ArrayList<String> urlsToRemove = new ArrayList<String>();
                for (String authHost : values) {
                    try {
                        String authUrl = URLUtil.getMtaAuthURL(authHost);
                        if (!curUrls.contains(authUrl)) continue;
                        urlsToRemove.add(authUrl);
                    }
                    catch (ServiceException e) {
                        for (String curUrl : curUrls) {
                            try {
                                URL url = new URL(curUrl);
                                String urlHost = url.getHost();
                                if (!authHost.equals(urlHost)) continue;
                                urlsToRemove.add(curUrl);
                            }
                            catch (MalformedURLException mue) {
                                urlsToRemove.add(curUrl);
                            }
                        }
                    }
                }
                if (urlsToRemove.size() > 0) {
                    attrsToModify.put("-zimbraMtaAuthURL", urlsToRemove.toArray(new String[urlsToRemove.size()]));
                }
            }
        } else if (mod.deleting()) {
            attrsToModify.put("zimbraMtaAuthURL", null);
        }
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }
}

