/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.mailbox.PurgeThread;
import com.zimbra.cs.util.Zimbra;
import java.util.Map;

public class MailboxPurge
extends AttributeCallback {
    public void preModify(Map context, String attrName, Object attrValue, Map attrsToModify, Entry entry, boolean isCreate) {
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
        Server server;
        if (!"zimbraMailPurgeSleepInterval".equals(attrName)) {
            return;
        }
        if (!Zimbra.started()) {
            return;
        }
        Server localServer = null;
        try {
            localServer = Provisioning.getInstance().getLocalServer();
        }
        catch (ServiceException e) {
            ZimbraLog.misc.warn("unable to get local server");
            return;
        }
        boolean hasMailboxService = localServer.getMultiAttrSet("zimbraServiceEnabled").contains("mailbox");
        if (!hasMailboxService) {
            return;
        }
        if (entry instanceof Server && (server = (Server)entry).getId() != localServer.getId()) {
            return;
        }
        ZimbraLog.purge.info("Mailbox purge interval set to %s.", localServer.getAttr("zimbraMailPurgeSleepInterval", null));
        long interval = localServer.getTimeInterval("zimbraMailPurgeSleepInterval", 0L);
        if (interval > 0L && !PurgeThread.isRunning()) {
            PurgeThread.startup();
        }
        if (interval == 0L && PurgeThread.isRunning()) {
            PurgeThread.shutdown();
        }
    }
}

