/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.Signature;
import java.util.Map;

public class MailSignature
extends AttributeCallback {
    public static final String CALLBACK_KEY_MAX_SIGNATURE_LEN = "KEY_MAX_SIGNATURE_LEN";

    public void preModify(Map context, String attrName, Object value, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        AttributeCallback.SingleValueMod mod = this.singleValueMod(attrName, value);
        if (mod.unsetting()) {
            return;
        }
        if (!(entry == null || entry instanceof Account || entry instanceof Identity || entry instanceof Signature)) {
            return;
        }
        long maxLen = -1L;
        String maxInContext = (String)context.get(CALLBACK_KEY_MAX_SIGNATURE_LEN);
        if (maxInContext != null) {
            try {
                maxLen = Integer.parseInt(maxInContext);
            }
            catch (NumberFormatException e) {
                ZimbraLog.account.warn("encountered invalid KEY_MAX_SIGNATURE_LEN: " + maxInContext);
            }
        }
        if (maxLen == -1L) {
            Account account;
            if (entry == null) {
                return;
            }
            if (entry instanceof Account) {
                account = (Account)entry;
            } else if (entry instanceof Identity) {
                account = ((Identity)entry).getAccount();
            } else if (entry instanceof Signature) {
                account = ((Signature)entry).getAccount();
            } else {
                return;
            }
            maxLen = account.getMailSignatureMaxLength();
        }
        if (maxLen != 0L && (long)((String)value).length() > maxLen) {
            throw ServiceException.INVALID_REQUEST("zimbraPrefMailSignature is longer than the limited value " + maxLen, null);
        }
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }
}

