/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import java.util.Map;

public class MailHost
extends AttributeCallback {
    public void preModify(Map context, String attrName, Object value, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        if (!(value instanceof String)) {
            throw ServiceException.INVALID_REQUEST("zimbraMailHost is a single-valued attribute", null);
        }
        if (StringUtil.isNullOrEmpty((String)value) || attrsToModify.get("-zimbraMailHost") != null) {
            return;
        }
        String mailHost = (String)value;
        String mailTransport = (String)attrsToModify.get("zimbraMailTransport");
        if (!StringUtil.isNullOrEmpty(mailHost) && !StringUtil.isNullOrEmpty(mailTransport)) {
            throw ServiceException.INVALID_REQUEST("setting both zimbraMailHost and zimbraMailTransport in the same request is not allowed", null);
        }
        Provisioning prov = Provisioning.getInstance();
        Server server = prov.get(Provisioning.ServerBy.serviceHostname, mailHost);
        if (server == null) {
            throw ServiceException.INVALID_REQUEST("specified zimbraMailHost does not correspond to a valid server service hostname: " + mailHost, null);
        }
        boolean hasMailboxService = server.getMultiAttrSet("zimbraServiceEnabled").contains("mailbox");
        if (!hasMailboxService) {
            throw ServiceException.INVALID_REQUEST("specified zimbraMailHost does not correspond to a valid server with the mailbox service enabled: " + mailHost, null);
        }
        if (entry != null && !isCreate) {
            String curMailTransport;
            Server oldServer;
            if (MailHost.mailTransport(server).equals(entry.getAttr("zimbraMailTransport"))) {
                return;
            }
            String oldMailHost = entry.getAttr("zimbraMailHost");
            if (oldMailHost != null && (oldServer = prov.get(Provisioning.ServerBy.serviceHostname, oldMailHost)) != null && !MailHost.mailTransportMatch(oldServer, curMailTransport = entry.getAttr("zimbraMailTransport"))) {
                throw ServiceException.INVALID_REQUEST("current value of zimbraMailHost does not match zimbraMailTransport, computed mail transport from current zimbraMailHost=" + MailHost.mailTransport(oldServer) + ", current zimbraMailTransport=" + curMailTransport, null);
            }
        }
        String newMailTransport = MailHost.mailTransport(server);
        attrsToModify.put("zimbraMailTransport", newMailTransport);
    }

    private static String mailTransport(Server server) {
        String serviceName = server.getAttr("zimbraServiceHostname", null);
        int lmtpPort = server.getIntAttr("zimbraLmtpBindPort", 7025);
        String transport = "lmtp:" + serviceName + ":" + lmtpPort;
        return transport;
    }

    private static boolean mailTransportMatch(Server server, String mailTransport) {
        if (mailTransport == null) {
            return true;
        }
        String serviceName = server.getAttr("zimbraServiceHostname", null);
        String[] parts = mailTransport.split(":");
        return serviceName != null && parts.length == 3 && parts[0].equals("lmtp") && parts[1].equals(serviceName);
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }
}

