/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;

public class MailCharset
extends AttributeCallback {
    public void preModify(Map context, String attrName, Object value, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        String charset = null;
        AttributeCallback.SingleValueMod mod = this.singleValueMod(attrName, value);
        if (mod.unsetting()) {
            return;
        }
        charset = mod.value();
        try {
            Charset.forName(charset);
        }
        catch (IllegalCharsetNameException e) {
            throw ServiceException.INVALID_REQUEST("charset name " + charset + " is illegal", e);
        }
        catch (UnsupportedCharsetException e) {
            throw ServiceException.INVALID_REQUEST("no support for charset " + charset + " is available in this instance of the Java virtual machine", e);
        }
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }
}

