/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.IDNUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class IDNCallback
extends AttributeCallback {
    public void preModify(Map context, String attrName, Object value, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        AttributeCallback.MultiValueMod mod = this.multiValueMod(attrsToModify, attrName);
        AttributeManager.IDNType idnType = AttributeManager.idnType(AttributeManager.getInstance(), attrName);
        if (mod.adding() || mod.replacing()) {
            HashSet<String> asciiValues = new HashSet<String>();
            List<String> addrs = mod.values();
            for (String addr : addrs) {
                if (addr == null || addr.equals("")) continue;
                String asciiName = addr.charAt(0) == '@' ? "@" + IDNUtil.toAsciiDomainName(addr.substring(1)) : IDNUtil.toAscii(addr, idnType);
                asciiValues.add(asciiName);
            }
            String aName = (mod.adding() ? "+" : "") + attrName;
            attrsToModify.remove(aName);
            attrsToModify.put(aName, asciiValues.toArray(new String[asciiValues.size()]));
        }
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }
}

