/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import java.util.Map;

public class DomainStatus
extends AttributeCallback {
    public void preModify(Map context, String attrName, Object value, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        if (!(value instanceof String)) {
            throw ServiceException.INVALID_REQUEST("zimbraDomainStatus is a single-valued attribute", null);
        }
        String status = (String)value;
        if (status.equals("shutdown")) {
            throw ServiceException.INVALID_REQUEST("Setting zimbraDomainStatus to shutdown is not allowed.  It is an internal status and can only be set by server", null);
        }
        if (status.equals("closed")) {
            attrsToModify.put("zimbraMailStatus", "disabled");
        } else {
            Domain domain;
            if (entry != null && (domain = (Domain)entry).beingRenamed()) {
                throw ServiceException.INVALID_REQUEST("domain " + domain.getName() + " is being renamed, cannot change " + "zimbraDomainStatus", null);
            }
            String alsoModifyingMailStatus = (String)attrsToModify.get("zimbraMailStatus");
            if (alsoModifyingMailStatus == null) {
                if (entry != null) {
                    String curMailStatus = entry.getAttr("zimbraMailStatus");
                    if (status.equals("suspended") && curMailStatus != null && curMailStatus.equals("disabled")) {
                        return;
                    }
                }
                attrsToModify.put("zimbraMailStatus", "enabled");
            }
        }
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }
}

