/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainCOSMaxAccounts
extends AttributeCallback {
    @Override
    public void preModify(Map context, String attrName, Object attrValue, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        List<String> vals;
        String aName;
        Map.Entry keyVal;
        Map.Entry e;
        String attr = "zimbraDomainCOSMaxAccounts";
        String addAttr = "+" + attr;
        String delAttr = "-" + attr;
        HashMap<String, String> cur = new HashMap<String, String>();
        if (entry != null) {
            Set<String> curValues = entry.getMultiAttrSet(attr);
            for (String v : curValues) {
                Pair<String, String> parsed = this.parse(v, false);
                if (parsed == null) continue;
                cur.put(parsed.getFirst(), parsed.getSecond());
            }
        }
        Iterator i$ = attrsToModify.entrySet().iterator();
        while (i$.hasNext()) {
            keyVal = e = i$.next();
            aName = (String)keyVal.getKey();
            vals = this.getMultiValue(keyVal.getValue());
            if (!delAttr.equals(aName)) continue;
            for (String v : vals) {
                if (v.length() == 0) continue;
                Pair<String, String> parsed = this.parse(v, true);
                cur.remove(parsed.getFirst());
            }
        }
        i$ = attrsToModify.entrySet().iterator();
        while (i$.hasNext()) {
            keyVal = e = i$.next();
            aName = (String)keyVal.getKey();
            vals = this.getMultiValue(keyVal.getValue());
            if (attr.equals(aName)) {
                this.checkDup(new HashMap<String, String>(), vals);
                continue;
            }
            if (!addAttr.equals(aName)) continue;
            this.checkDup(cur, vals);
        }
    }

    private void checkDup(Map<String, String> curVals, List<String> newVals) throws ServiceException {
        for (String v : newVals) {
            if (v.length() == 0) continue;
            Pair<String, String> parsed = this.parse(v, true);
            String other = curVals.get(parsed.getFirst());
            if (other != null) {
                throw ServiceException.INVALID_REQUEST("cannot contain multiple values for the same cos " + parsed.getFirst() + ": " + parsed.getSecond() + ", " + other, null);
            }
            curVals.put(parsed.getFirst(), parsed.getSecond());
        }
    }

    private Pair<String, String> parse(String value, boolean throwOnError) throws ServiceException {
        String[] parts = value.split(":");
        if (parts.length != 2) {
            if (throwOnError) {
                throw ServiceException.INVALID_REQUEST("invalid format", null);
            }
            return null;
        }
        return new Pair<String, String>(parts[0], parts[1]);
    }

    @Override
    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }
}

