/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import java.util.Map;

public class DisplayName
extends AttributeCallback {
    public void preModify(Map context, String attrName, Object value, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        if (!(entry instanceof Account) && !(entry instanceof DistributionList)) {
            return;
        }
        AttributeCallback.SingleValueMod mod = this.singleValueMod(attrName, value);
        if (mod.unsetting()) {
            return;
        }
        String displayName = mod.value();
        String namingRdnAttr = null;
        Provisioning prov = Provisioning.getInstance();
        if (prov instanceof LdapProvisioning) {
            LdapProvisioning ldapProv = (LdapProvisioning)prov;
            namingRdnAttr = ldapProv.getNamingRdnAttr(entry);
        }
        if (!(namingRdnAttr != null && namingRdnAttr.equals("cn") || attrsToModify.containsKey("cn"))) {
            attrsToModify.put("cn", displayName);
        }
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }
}

