/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.util.Zimbra;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataSourceCallback
extends AttributeCallback {
    private static final String KEY_INTERVAL_CHANGED = "IntervalChanged";
    private static final Set<String> INTERVAL_ATTRS = new HashSet<String>();

    public void preModify(Map context, String attrName, Object attrValue, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        if (isCreate) {
            return;
        }
        if (!LC.data_source_scheduling_enabled.booleanValue()) {
            return;
        }
        if (INTERVAL_ATTRS.contains(attrName)) {
            context.put(KEY_INTERVAL_CHANGED, this.willIntervalChange(attrName, attrValue, entry));
        } else if (attrName.equals("zimbraDataSourceEnabled")) {
            String oldValue = entry.getAttr("zimbraDataSourceEnabled");
            context.put(KEY_INTERVAL_CHANGED, StringUtil.equal(oldValue, (String)attrValue));
        } else {
            context.put(KEY_INTERVAL_CHANGED, false);
        }
    }

    private boolean willIntervalChange(String attrName, Object attrValue, Entry entry) throws ServiceException {
        String newInterval = (String)attrValue;
        String oldInterval = "";
        if (entry != null) {
            oldInterval = entry.getAttr(attrName);
        }
        if (entry instanceof DataSource) {
            this.validateDataSource((DataSource)entry, newInterval);
        } else if (entry instanceof Account) {
            this.validateAccount((Account)entry, attrName, newInterval);
        } else if (entry instanceof Cos) {
            this.validateCos((Cos)entry, attrName, newInterval);
        }
        long lNewInterval = DateUtil.getTimeInterval(newInterval, 0L);
        long lOldInterval = DateUtil.getTimeInterval(oldInterval, 0L);
        return lNewInterval != lOldInterval;
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
        if (!Zimbra.started()) {
            return;
        }
        if ("zimbraDataSourcePollingInterval".equals(attrName) && LC.data_source_scheduling_enabled.booleanValue()) {
            this.postModifyPollingInterval(context, attrName, entry, isCreate);
        } else if (entry instanceof DataSource) {
            DataSourceManager.resetErrorStatus((DataSource)entry);
        }
    }

    private void postModifyPollingInterval(Map context, String attrName, Entry entry, boolean isCreate) {
        Boolean intervalChanged = isCreate || (Boolean)context.get(KEY_INTERVAL_CHANGED) != false;
        if (intervalChanged == null || !intervalChanged.booleanValue()) {
            ZimbraLog.datasource.debug("Polling interval did not change.  Not updating schedule.");
            return;
        }
        try {
            if (entry instanceof DataSource) {
                this.scheduleDataSource((DataSource)entry);
            } else if (entry instanceof Account) {
                this.scheduleAccount((Account)entry);
            } else if (entry instanceof Cos) {
                this.scheduleCos((Cos)entry);
            }
        }
        catch (ServiceException e) {
            ZimbraLog.datasource.warn("Unable to update schedule for %s", (Object)entry, e);
        }
    }

    private void validateDataSource(DataSource ds, String newInterval) throws ServiceException {
        Account account = ds.getAccount();
        if (account == null) {
            ZimbraLog.datasource.warn("Could not determine account for %s", ds);
            return;
        }
        this.validateInterval("zimbraDataSourcePollingInterval", newInterval, account.getAttr("zimbraDataSourceMinPollingInterval"));
    }

    private void scheduleDataSource(DataSource ds) throws ServiceException {
        Account account = ds.getAccount();
        if (account == null) {
            ZimbraLog.datasource.warn("Could not determine account for %s", ds);
            return;
        }
        DataSourceManager.updateSchedule(account.getId(), ds.getId());
    }

    private void validateAccount(Account account, String attrName, String newInterval) throws ServiceException {
        this.validateInterval(attrName, newInterval, account.getAttr("zimbraDataSourceMinPollingInterval"));
    }

    private void scheduleAccount(Account account) throws ServiceException {
        ZimbraLog.datasource.info("Updating schedule for all DataSources for account %s.", account.getName());
        List<DataSource> dataSources = Provisioning.getInstance().getAllDataSources(account);
        for (DataSource ds : dataSources) {
            DataSourceManager.updateSchedule(account.getId(), ds.getId());
        }
    }

    private void validateCos(Cos cos, String attrName, String newInterval) throws ServiceException {
        this.validateInterval(newInterval, attrName, cos.getAttr("zimbraDataSourceMinPollingInterval"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCos(Cos cos) throws ServiceException {
        ZimbraLog.datasource.info("Updating schedule for all DataSources for all accounts in COS %s.", cos.getName());
        Set<String> accountIds = null;
        Object object = DbMailbox.getSynchronizer();
        synchronized (object) {
            DbPool.Connection conn = null;
            try {
                conn = DbPool.getConnection();
                accountIds = DbMailbox.listAccountIds(conn);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                DbPool.quietClose(conn);
                throw throwable;
            }
            DbPool.quietClose(conn);
        }
        Provisioning prov = Provisioning.getInstance();
        for (String accountId : accountIds) {
            Cos accountCos;
            Account account = null;
            try {
                account = prov.get(Provisioning.AccountBy.id, accountId);
            }
            catch (ServiceException e) {
                ZimbraLog.datasource.debug("Unable to look up account for id %s: %s", accountId, e.toString());
            }
            if (account == null || !"active".equals(account.getAccountStatus(prov)) || (accountCos = prov.getCOS(account)) == null || !cos.getId().equals(accountCos.getId())) continue;
            this.scheduleAccount(account);
        }
    }

    private void validateInterval(String attrName, String newInterval, String minInterval) throws ServiceException {
        long interval = DateUtil.getTimeInterval(newInterval, 0L);
        if (interval == 0L) {
            return;
        }
        long lMinInterval = DateUtil.getTimeInterval(minInterval, 0L);
        if (interval < lMinInterval) {
            String msg = String.format("Polling interval %s for %s is shorter than the allowed minimum of %s.", newInterval, attrName, minInterval);
            throw ServiceException.INVALID_REQUEST(msg, null);
        }
    }

    static {
        INTERVAL_ATTRS.add("zimbraDataSourcePollingInterval");
        INTERVAL_ATTRS.add("zimbraDataSourcePop3PollingInterval");
        INTERVAL_ATTRS.add("zimbraDataSourceImapPollingInterval");
        INTERVAL_ATTRS.add("zimbraDataSourceLivePollingInterval");
        INTERVAL_ATTRS.add("zimbraDataSourceRssPollingInterval");
        INTERVAL_ATTRS.add("zimbraDataSourceCaldavPollingInterval");
        INTERVAL_ATTRS.add("zimbraDataSourceYabPollingInterval");
        INTERVAL_ATTRS.add("zimbraDataSourceCalendarPollingInterval");
    }
}

