/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import java.util.Map;

public class CosId
extends AttributeCallback {
    public void preModify(Map context, String attrName, Object attrValue, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        this.validateCosId(attrsToModify, attrName);
    }

    private void validateCosId(Map attrsToModify, String attrName) throws ServiceException {
        Cos cos;
        AttributeCallback.SingleValueMod mod = this.singleValueMod(attrsToModify, attrName);
        if (mod.unsetting()) {
            return;
        }
        String cosId = mod.value();
        Provisioning prov = Provisioning.getInstance();
        if (prov.idIsUUID() && (cos = prov.get(Provisioning.CosBy.id, cosId)) == null) {
            throw ServiceException.INVALID_REQUEST("cos id " + cosId + " does not point to a valid cos", null);
        }
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }
}

