/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ChildAccount
extends AttributeCallback {
    private static final String KEY = ChildAccount.class.getName();

    public void preModify(Map context, String attrName, Object value, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        Object done = context.get(KEY);
        if (done != null) {
            return;
        }
        context.put(KEY, KEY);
        AttributeCallback.MultiValueMod visibleChildrenMod = this.multiValueMod(attrsToModify, "zimbraPrefChildVisibleAccount");
        AttributeCallback.MultiValueMod allChildrenMod = this.multiValueMod(attrsToModify, "zimbraChildAccount");
        Set<String> visibleChildren = this.newValuesToBe(visibleChildrenMod, entry, "zimbraPrefChildVisibleAccount");
        Set<String> allChildren = this.newValuesToBe(allChildrenMod, entry, "zimbraChildAccount");
        if (allChildrenMod != null && allChildrenMod.deleting()) {
            attrsToModify.put("zimbraPrefChildVisibleAccount", "");
        } else {
            HashSet<String> vidsToRemove = new HashSet<String>();
            for (String vid : visibleChildren) {
                if (allChildren.contains(vid)) continue;
                if (allChildrenMod != null && allChildrenMod.removing() && visibleChildrenMod == null) {
                    vidsToRemove.add(vid);
                    continue;
                }
                throw ServiceException.INVALID_REQUEST("visible child id " + vid + " is not one of " + "zimbraChildAccount", null);
            }
            if (vidsToRemove.size() > 0) {
                attrsToModify.put("-zimbraPrefChildVisibleAccount", vidsToRemove.toArray(new String[vidsToRemove.size()]));
            }
        }
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }
}

