/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.bidimap.DualHashBidiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckPortConflict
extends AttributeCallback {
    private static final String KEY = CheckPortConflict.class.getName();
    private static final Set<String> sPortAttrs = new HashSet<String>();

    @Override
    public void preModify(Map context, String attrName, Object attrValue, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        if (entry != null && !(entry instanceof Server) && !(entry instanceof Config)) {
            return;
        }
        Object done = context.get(KEY);
        if (done != null) {
            return;
        }
        context.put(KEY, KEY);
        if (!sPortAttrs.contains(attrName) || !AttributeManager.getInstance().isServerInherited(attrName)) assert (false);
        if (entry == null || entry instanceof Server) {
            this.checkServer((Server)entry, attrsToModify);
        } else {
            this.checkConfig((Config)entry, attrsToModify);
        }
    }

    private void checkServer(Server server, Map<String, Object> serverAttrsToModify) throws ServiceException {
        HashMap<String, String> ports = new HashMap<String, String>();
        Map<String, Object> defaults = Provisioning.getInstance().getConfig().getServerDefaults();
        if (server != null) {
            for (String string : sPortAttrs) {
                if (serverAttrsToModify.containsKey(string)) continue;
                ports.put(server.getAttr(string), string);
            }
        }
        for (Map.Entry entry : serverAttrsToModify.entrySet()) {
            String attrName = (String)entry.getKey();
            if (!sPortAttrs.contains(attrName)) continue;
            AttributeCallback.SingleValueMod mod = this.singleValueMod(serverAttrsToModify, attrName);
            String newValue = null;
            if (mod.setting()) {
                newValue = mod.value();
            } else {
                Object defValue = defaults.get(attrName);
                if (defValue != null) {
                    if (defValue instanceof String) {
                        newValue = (String)defValue;
                    } else {
                        ZimbraLog.misc.info("default value for " + attrName + " should be a single-valued attribute, invalid default value ignored");
                    }
                }
            }
            if (this.conflict(ports, newValue)) {
                String serverInfo = server == null ? "" : " on server " + server.getName();
                throw ServiceException.INVALID_REQUEST("port " + newValue + " conflict between " + attrName + " and " + (String)ports.get(newValue) + serverInfo, null);
            }
            ports.put(newValue, attrName);
        }
    }

    private void checkConfig(Config config, Map<String, Object> configAttrsToModify) throws ServiceException {
        DualHashBidiMap newDefaults = new DualHashBidiMap();
        for (String string : sPortAttrs) {
            if (configAttrsToModify.containsKey(string)) continue;
            newDefaults.put((Object)config.getAttr(string), (Object)string);
        }
        for (Map.Entry entry : configAttrsToModify.entrySet()) {
            String attrName = (String)entry.getKey();
            if (!sPortAttrs.contains(attrName)) continue;
            AttributeCallback.SingleValueMod mod = this.singleValueMod(configAttrsToModify, attrName);
            String newValue = null;
            if (mod.setting()) {
                newValue = mod.value();
            }
            if (this.conflict((Map)newDefaults, newValue)) {
                throw ServiceException.INVALID_REQUEST("port " + newValue + " conflict between " + attrName + " and " + newDefaults.get((Object)newValue) + " on global config", null);
            }
            newDefaults.put((Object)newValue, (Object)attrName);
        }
        List<Server> servers = Provisioning.getInstance().getAllServers();
        for (Server server : servers) {
            this.checkServerWithNewDefaults(server, newDefaults, configAttrsToModify);
        }
    }

    private void checkServerWithNewDefaults(Server server, DualHashBidiMap newDefaults, Map<String, Object> configAttrsToModify) throws ServiceException {
        HashMap<String, String> ports = new HashMap<String, String>();
        for (String attrName : sPortAttrs) {
            String newValue = null;
            String curValue = server.getAttr(attrName, false);
            newValue = curValue == null ? (String)newDefaults.getKey((Object)attrName) : curValue;
            if (this.conflict(ports, newValue)) {
                String conflictWith = (String)ports.get(newValue);
                if (!configAttrsToModify.containsKey(attrName) && !configAttrsToModify.containsKey(conflictWith)) continue;
                throw ServiceException.INVALID_REQUEST("port " + newValue + " conflict between " + attrName + " and " + (String)ports.get(newValue) + " on server " + server.getName(), null);
            }
            ports.put(newValue, attrName);
        }
    }

    private boolean conflict(Map ports, String port) {
        if (StringUtil.isNullOrEmpty(port)) {
            return false;
        }
        if (port.equals("0")) {
            return false;
        }
        return ports.containsKey(port);
    }

    @Override
    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
    }

    static {
        sPortAttrs.add("zimbraAdminPort");
        sPortAttrs.add("zimbraImapBindPort");
        sPortAttrs.add("zimbraImapSSLBindPort");
        sPortAttrs.add("zimbraImapProxyBindPort");
        sPortAttrs.add("zimbraImapSSLProxyBindPort");
        sPortAttrs.add("zimbraLmtpBindPort");
        sPortAttrs.add("zimbraMailPort");
        sPortAttrs.add("zimbraMailSSLPort");
        sPortAttrs.add("zimbraPop3BindPort");
        sPortAttrs.add("zimbraPop3SSLBindPort");
        sPortAttrs.add("zimbraPop3ProxyBindPort");
        sPortAttrs.add("zimbraPop3SSLProxyBindPort");
        sPortAttrs.add("zimbraRemoteManagementPort");
        sPortAttrs.add("zimbraMemcachedBindPort");
        sPortAttrs.add("zimbraMailProxyPort");
        sPortAttrs.add("zimbraMailSSLProxyPort");
    }
}

