/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.callback;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeCallback;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import java.util.Map;

public class AccountStatus
extends AttributeCallback {
    private static final String KEY = AccountStatus.class.getName();

    public void preModify(Map context, String attrName, Object value, Map attrsToModify, Entry entry, boolean isCreate) throws ServiceException {
        AttributeCallback.SingleValueMod mod = this.singleValueMod(attrName, value);
        if (mod.unsetting()) {
            throw ServiceException.INVALID_REQUEST("zimbraAccountStatus is a required attribute", null);
        }
        String status = mod.value();
        if (status.equals("closed") || status.equals("pending")) {
            attrsToModify.put("zimbraMailStatus", "disabled");
        } else if (attrsToModify.get("zimbraMailStatus") == null) {
            attrsToModify.put("zimbraMailStatus", "enabled");
        }
        if (entry instanceof Account && status.equals("active")) {
            if (entry.getAttr("zimbraPasswordLockoutFailureTime", null) != null) {
                attrsToModify.put("zimbraPasswordLockoutFailureTime", "");
            }
            if (entry.getAttr("zimbraPasswordLockoutLockedTime", null) != null) {
                attrsToModify.put("zimbraPasswordLockoutLockedTime", "");
            }
        }
    }

    public void postModify(Map context, String attrName, Entry entry, boolean isCreate) {
        Object done;
        if (!isCreate && (done = context.get(KEY)) == null) {
            context.put(KEY, KEY);
            if (entry instanceof Account) {
                try {
                    this.handleAccountStatusClosed((Account)entry);
                }
                catch (ServiceException se) {
                    ZimbraLog.account.warn((Object)"unable to remove account address and aliases from all DLs for closed account", se);
                    return;
                }
            }
        }
    }

    private void handleAccountStatusClosed(Account account) throws ServiceException {
        LdapProvisioning prov = (LdapProvisioning)Provisioning.getInstance();
        String status = account.getAccountStatus(prov);
        if (status.equals("closed")) {
            ZimbraLog.misc.info("removing account address and all its aliases from all distribution lists");
            String[] aliases = account.getMailAlias();
            String[] addrs = new String[aliases.length + 1];
            addrs[0] = account.getName();
            if (aliases.length > 0) {
                System.arraycopy(aliases, 0, addrs, 1, aliases.length);
            }
            prov.removeAddressesFromAllDistributionLists(addrs);
        }
    }
}

