/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.auth;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.auth.HostedAuth;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ZimbraCustomAuth {
    private static Map<String, ZimbraCustomAuth> mHandlers;

    public static synchronized void register(String handlerName, ZimbraCustomAuth handler) {
        if (mHandlers == null) {
            mHandlers = new HashMap<String, ZimbraCustomAuth>();
        } else {
            ZimbraCustomAuth obj = mHandlers.get(handlerName);
            if (obj != null) {
                ZimbraLog.account.warn("handler name " + handlerName + " is already registered, " + "registering of " + obj.getClass().getCanonicalName() + " is ignored");
                return;
            }
        }
        mHandlers.put(handlerName, handler);
    }

    public static synchronized ZimbraCustomAuth getHandler(String handlerName) {
        if (mHandlers == null) {
            return null;
        }
        return mHandlers.get(handlerName);
    }

    public abstract void authenticate(Account var1, String var2, Map<String, Object> var3, List<String> var4) throws Exception;

    public boolean checkPasswordAging() {
        return false;
    }

    static {
        ZimbraCustomAuth.register("hosted", new HostedAuth());
    }
}

