/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.auth;

import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.account.auth.ZimbraCustomAuth;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostedAuth
extends ZimbraCustomAuth {
    public static String HEADER_AUTH_USER = "Auth-User";
    public static String HEADER_AUTH_PASSWORD = "Auth-Pass";
    public static String HEADER_AUTH_PROTOCOL = "Auth-Protocol";
    public static String HEADER_CLIENT_IP = "Client-IP";
    public static String HEADER_AUTH_STATUS = "Auth-Status";
    public static String HEADER_AUTH_USER_AGENT = "Auth-User-Agent";
    public static String AUTH_STATUS_OK = "OK";

    @Override
    public void authenticate(Account acct, String password, Map<String, Object> context, List<String> args) throws Exception {
        HttpClient client = ZimbraHttpConnectionManager.getExternalHttpConnMgr().newHttpClient();
        HttpMethodBase method = null;
        String targetURL = args.get(0);
        method = args.size() > 1 ? (args.get(1).equalsIgnoreCase("GET") ? new GetMethod(targetURL) : new PostMethod(targetURL)) : new GetMethod(targetURL);
        if (context.get("ocip") != null) {
            method.addRequestHeader(HEADER_CLIENT_IP, context.get("ocip").toString());
        }
        method.addRequestHeader(HEADER_AUTH_USER, acct.getName());
        method.addRequestHeader(HEADER_AUTH_PASSWORD, password);
        AuthContext.Protocol proto = (AuthContext.Protocol)((Object)context.get("proto"));
        if (proto != null) {
            method.addRequestHeader(HEADER_AUTH_PROTOCOL, proto.toString());
        }
        if (context.get("ua") != null) {
            method.addRequestHeader(HEADER_AUTH_USER_AGENT, context.get("ua").toString());
        }
        try {
            try {
                client.executeMethod(method);
            }
            catch (HttpException ex) {
                throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), acct.getName(), "HTTP request to remote authentication server failed", ex);
            }
            catch (IOException ex) {
                throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), acct.getName(), "HTTP request to remote authentication server failed", ex);
            }
            Object var11_9 = null;
            if (method != null) {
                method.releaseConnection();
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (method != null) {
                method.releaseConnection();
            }
            throw throwable;
        }
        int status = method.getStatusCode();
        if (status != 200) {
            throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), "HTTP request to remote authentication server failed. Remote response code: " + Integer.toString(status));
        }
        if (method.getResponseHeader(HEADER_AUTH_STATUS) == null) {
            throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), "Empty response from remote authentication server.");
        }
        String responseMessage = method.getResponseHeader(HEADER_AUTH_STATUS).getValue();
        if (responseMessage.equalsIgnoreCase(AUTH_STATUS_OK)) {
            return;
        }
        throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), responseMessage);
    }
}

