/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.auth;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.auth.PasswordUtil;
import com.zimbra.cs.account.auth.ZimbraCustomAuth;
import com.zimbra.cs.account.krb5.Krb5Login;
import com.zimbra.cs.account.krb5.Krb5Principal;
import com.zimbra.cs.account.ldap.LdapEntry;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.ZimbraLdapContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthMechanism {
    protected String mAuthMech;

    protected AuthMechanism(String authMech) {
        this.mAuthMech = authMech;
    }

    public static AuthMechanism makeInstance(Account acct) throws ServiceException {
        String am;
        String authMech = "zimbra";
        Provisioning prov = Provisioning.getInstance();
        Domain domain = prov.getDomain(acct);
        if (domain != null && (am = domain.getAttr("zimbraAuthMech")) != null) {
            authMech = am;
        }
        if (authMech.equals("zimbra")) {
            return new ZimbraAuth(authMech);
        }
        if (authMech.equals("ldap") || authMech.equals("ad")) {
            return new LdapAuth(authMech);
        }
        if (authMech.equals("kerberos5")) {
            return new Kerberos5Auth(authMech);
        }
        if (authMech.startsWith("custom:")) {
            return new CustomAuth(authMech);
        }
        ZimbraLog.account.warn("unknown value for zimbraAuthMech: " + authMech + ", falling back to default mech");
        return new ZimbraAuth(authMech);
    }

    public static void doZimbraAuth(LdapProvisioning prov, Domain domain, Account acct, String password, Map<String, Object> authCtxt) throws ServiceException {
        ZimbraAuth zimbraAuth = new ZimbraAuth("zimbra");
        zimbraAuth.doAuth(prov, domain, acct, password, authCtxt);
    }

    public boolean isZimbraAuth() {
        return false;
    }

    public abstract boolean checkPasswordAging() throws ServiceException;

    public abstract void doAuth(LdapProvisioning var1, Domain var2, Account var3, String var4, Map<String, Object> var5) throws ServiceException;

    public String getMechanism() {
        return this.mAuthMech;
    }

    public static String namePassedIn(Map<String, Object> authCtxt) {
        String npi;
        if (authCtxt != null) {
            npi = (String)authCtxt.get("anp");
            if (npi == null) {
                npi = "";
            }
        } else {
            npi = "";
        }
        return npi;
    }

    public static void main(String[] args) {
        QuotedStringParser parser = new QuotedStringParser("http://blah.com:123    green \" ocean blue   \"  \"\" yelllow \"\"");
        List<String> tokens = parser.parse();
        int i = 0;
        for (String s : tokens) {
            System.out.format("%d [%s]\n", ++i, s);
        }
        CustomAuth ca = new CustomAuth("custom:sample http://blah.com:123    green \" ocean blue   \"  \"\" yelllow \"\"");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QuotedStringParser {
        private String mInput;
        private static final String DELIM_WHITESPACE_AND_QUOTES = " \t\r\n\"";
        private static final String DELIM_QUOTES_ONLY = "\"";

        public QuotedStringParser(String input) {
            if (input == null) {
                throw new IllegalArgumentException("Search Text cannot be null.");
            }
            this.mInput = input;
        }

        public List<String> parse() {
            ArrayList<String> result = new ArrayList<String>();
            boolean returnTokens = true;
            String currentDelims = DELIM_WHITESPACE_AND_QUOTES;
            StringTokenizer parser = new StringTokenizer(this.mInput, currentDelims, returnTokens);
            boolean openDoubleQuote = false;
            boolean gotContent = false;
            String token = null;
            while (parser.hasMoreTokens()) {
                token = parser.nextToken(currentDelims);
                if (!this.isDoubleQuote(token)) {
                    if (currentDelims.contains(token)) continue;
                    result.add(token);
                    gotContent = true;
                    continue;
                }
                currentDelims = this.flipDelimiters(currentDelims);
                if (openDoubleQuote && !gotContent) {
                    result.add("");
                }
                openDoubleQuote = !openDoubleQuote;
                gotContent = false;
            }
            return result;
        }

        private boolean isDoubleQuote(String token) {
            return token.equals(DELIM_QUOTES_ONLY);
        }

        private String flipDelimiters(String curDelims) {
            if (curDelims.equals(DELIM_WHITESPACE_AND_QUOTES)) {
                return DELIM_QUOTES_ONLY;
            }
            return DELIM_WHITESPACE_AND_QUOTES;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CustomAuth
    extends AuthMechanism {
        private String mHandlerName = "";
        private ZimbraCustomAuth mHandler;
        List<String> mArgs;

        CustomAuth(String authMech) {
            super(authMech);
            int handlerNameStart = this.mAuthMech.indexOf(58);
            if (handlerNameStart != -1) {
                int handlerNameEnd = this.mAuthMech.indexOf(32);
                if (handlerNameEnd != -1) {
                    this.mHandlerName = this.mAuthMech.substring(handlerNameStart + 1, handlerNameEnd);
                    QuotedStringParser parser = new QuotedStringParser(this.mAuthMech.substring(handlerNameEnd + 1));
                    this.mArgs = parser.parse();
                    if (this.mArgs.size() == 0) {
                        this.mArgs = null;
                    }
                } else {
                    this.mHandlerName = this.mAuthMech.substring(handlerNameStart + 1);
                }
                if (!StringUtil.isNullOrEmpty(this.mHandlerName)) {
                    this.mHandler = ZimbraCustomAuth.getHandler(this.mHandlerName);
                }
            }
            if (ZimbraLog.account.isDebugEnabled()) {
                StringBuffer sb = null;
                if (this.mArgs != null) {
                    sb = new StringBuffer();
                    for (String s : this.mArgs) {
                        sb.append("[" + s + "] ");
                    }
                }
                ZimbraLog.account.debug("CustomAuth: handlerName=" + this.mHandlerName + ", args=" + sb);
            }
        }

        @Override
        public void doAuth(LdapProvisioning prov, Domain domain, Account acct, String password, Map<String, Object> authCtxt) throws ServiceException {
            if (this.mHandler == null) {
                throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), CustomAuth.namePassedIn(authCtxt), "handler " + this.mHandlerName + " for custom auth for domain " + domain.getName() + " not found");
            }
            try {
                this.mHandler.authenticate(acct, password, authCtxt, this.mArgs);
                return;
            }
            catch (Exception e) {
                if (e instanceof ServiceException) {
                    throw (ServiceException)e;
                }
                String msg = e.getMessage();
                msg = StringUtil.isNullOrEmpty(msg) ? "" : " (" + msg + ")";
                throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), CustomAuth.namePassedIn(authCtxt) + msg, msg, e);
            }
        }

        @Override
        public boolean checkPasswordAging() throws ServiceException {
            if (this.mHandler == null) {
                throw ServiceException.FAILURE("custom auth handler " + this.mHandlerName + " not found", null);
            }
            return this.mHandler.checkPasswordAging();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Kerberos5Auth
    extends AuthMechanism {
        Kerberos5Auth(String authMech) {
            super(authMech);
        }

        @Override
        public void doAuth(LdapProvisioning prov, Domain domain, Account acct, String password, Map<String, Object> authCtxt) throws ServiceException {
            String principal = Krb5Principal.getKrb5Principal(domain, acct);
            if (principal == null) {
                throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), Kerberos5Auth.namePassedIn(authCtxt), "cannot obtain principal for " + this.mAuthMech + " auth");
            }
            if (principal != null) {
                try {
                    Krb5Login.verifyPassword(principal, password);
                }
                catch (LoginException e) {
                    throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), Kerberos5Auth.namePassedIn(authCtxt) + "(kerberos5 principal: " + principal + ")", e.getMessage(), e);
                }
            }
        }

        @Override
        public boolean checkPasswordAging() throws ServiceException {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LdapAuth
    extends AuthMechanism {
        LdapAuth(String authMech) {
            super(authMech);
        }

        @Override
        public void doAuth(LdapProvisioning prov, Domain domain, Account acct, String password, Map<String, Object> authCtxt) throws ServiceException {
            prov.externalLdapAuth(domain, this.mAuthMech, acct, password, authCtxt);
        }

        @Override
        public boolean checkPasswordAging() throws ServiceException {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZimbraAuth
    extends AuthMechanism {
        ZimbraAuth(String authMech) {
            super(authMech);
        }

        @Override
        public boolean isZimbraAuth() {
            return true;
        }

        @Override
        public void doAuth(LdapProvisioning prov, Domain domain, Account acct, String password, Map<String, Object> authCtxt) throws ServiceException {
            String encodedPassword = acct.getAttr("userPassword");
            if (encodedPassword == null) {
                throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), ZimbraAuth.namePassedIn(authCtxt), "missing userPassword");
            }
            if (PasswordUtil.SSHA.isSSHA(encodedPassword)) {
                if (PasswordUtil.SSHA.verifySSHA(encodedPassword, password)) {
                    return;
                }
                throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), ZimbraAuth.namePassedIn(authCtxt), "invalid password");
            }
            if (acct instanceof LdapEntry) {
                try {
                    ZimbraLdapContext.ldapAuthenticate(((LdapEntry)((Object)acct)).getDN(), password);
                    return;
                }
                catch (AuthenticationException e) {
                    throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), ZimbraAuth.namePassedIn(authCtxt), e.getMessage(), e);
                }
                catch (AuthenticationNotSupportedException e) {
                    throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), ZimbraAuth.namePassedIn(authCtxt), e.getMessage(), e);
                }
                catch (NamingException e) {
                    throw ServiceException.FAILURE(e.getMessage(), e);
                }
                catch (IOException e) {
                    throw ServiceException.FAILURE(e.getMessage(), e);
                }
            }
            throw AccountServiceException.AuthFailedServiceException.AUTH_FAILED(acct.getName(), ZimbraAuth.namePassedIn(authCtxt));
        }

        @Override
        public boolean checkPasswordAging() throws ServiceException {
            return true;
        }
    }
}

