/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.accesscontrol.ZimbraACE;
import com.zimbra.cs.mailbox.ACL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimbraACL {
    private static final Log sLog = LogFactory.getLog(ZimbraACL.class);
    private List<ZimbraACE> mAces = new ArrayList<ZimbraACE>();
    private Set<ZimbraACE> mAllowedNotDelegable = new HashSet<ZimbraACE>();
    private Set<ZimbraACE> mAllowedDelegable = new HashSet<ZimbraACE>();
    private Set<ZimbraACE> mDenied = new HashSet<ZimbraACE>();
    private Set<Right> mContainsRight = new HashSet<Right>();

    ZimbraACL(String[] aces, TargetType targetType, String targetName) throws ServiceException {
        RightManager rm = RightManager.getInstance();
        for (String aceStr : aces) {
            try {
                ZimbraACE ace = new ZimbraACE(aceStr, rm, targetType, targetName);
                this.addACE(ace);
            }
            catch (ServiceException e) {
                ZimbraLog.acl.warn((Object)("cannot parse ACE: " + aceStr + ", skipped"), e);
            }
        }
    }

    ZimbraACL(Set<ZimbraACE> aces) throws ServiceException {
        this.grantAccess(aces);
    }

    private ZimbraACL(ZimbraACL other) {
        if (other.mAces != null) {
            for (ZimbraACE ace : other.mAces) {
                this.addACE(ace.clone());
            }
        }
    }

    public ZimbraACL clone() {
        return new ZimbraACL(this);
    }

    private void addACE(ZimbraACE aceToGrant) {
        if (aceToGrant.deny()) {
            this.mAces.add(0, aceToGrant);
            this.mDenied.add(aceToGrant);
        } else if (!aceToGrant.canDelegate()) {
            this.mAces.add(aceToGrant);
            this.mAllowedNotDelegable.add(aceToGrant);
        } else {
            this.mAces.add(this.mDenied.size(), aceToGrant);
            this.mAllowedDelegable.add(aceToGrant);
        }
        this.mContainsRight.add(aceToGrant.getRight());
    }

    private void removeACE(ZimbraACE aceToRevoke) {
        this.mAces.remove(aceToRevoke);
        if (aceToRevoke.deny()) {
            this.mDenied.remove(aceToRevoke);
        } else if (aceToRevoke.canDelegate()) {
            this.mAllowedDelegable.remove(aceToRevoke);
        } else {
            this.mAllowedNotDelegable.remove(aceToRevoke);
        }
        this.mContainsRight.remove(aceToRevoke.getRight());
    }

    private boolean grant(ZimbraACE aceToGrant) {
        for (ZimbraACE ace : this.mAces) {
            String newSecret;
            if (!ace.isGrantee(aceToGrant.getGrantee()) || !ace.getRight().isTheSameRight(aceToGrant.getRight())) continue;
            boolean changed = false;
            if (ace.getRightModifier() != aceToGrant.getRightModifier()) {
                ace.setRightModifier(aceToGrant.getRightModifier());
                changed = true;
            }
            if (!(aceToGrant.getGranteeType() != GranteeType.GT_GUEST && aceToGrant.getGranteeType() != GranteeType.GT_KEY || (newSecret = aceToGrant.getSecret()) == null || newSecret.equals(ace.getSecret()))) {
                ace.setSecret(newSecret);
                changed = true;
            }
            return changed;
        }
        if (aceToGrant.getGranteeType() == GranteeType.GT_KEY && aceToGrant.getSecret() == null) {
            aceToGrant.setSecret(ACL.generateAccessKey());
        }
        this.addACE(aceToGrant);
        return true;
    }

    private boolean revoke(ZimbraACE aceToRevoke) {
        for (ZimbraACE ace : this.mAces) {
            if (!ace.isGrantee(aceToRevoke.getGrantee()) || !ace.getRight().getName().equals(aceToRevoke.getRight().getName()) || ace.getRightModifier() != aceToRevoke.getRightModifier()) continue;
            this.removeACE(ace);
            return true;
        }
        return false;
    }

    List<ZimbraACE> grantAccess(Set<ZimbraACE> acesToGrant) {
        ArrayList<ZimbraACE> granted = new ArrayList<ZimbraACE>();
        for (ZimbraACE ace : acesToGrant) {
            if (!this.grant(ace)) continue;
            granted.add(ace);
        }
        return granted;
    }

    List<ZimbraACE> revokeAccess(Set<ZimbraACE> acesToRevoke) {
        ArrayList<ZimbraACE> revoked = new ArrayList<ZimbraACE>();
        for (ZimbraACE ace : acesToRevoke) {
            if (!this.revoke(ace)) continue;
            revoked.add(ace);
        }
        return revoked;
    }

    List<ZimbraACE> getAllACEs() {
        return this.mAces;
    }

    Set<ZimbraACE> getAllowedNotDelegableACEs() {
        return this.mAllowedNotDelegable;
    }

    Set<ZimbraACE> getAllowedDelegableACEs() {
        return this.mAllowedDelegable;
    }

    Set<ZimbraACE> getDeniedACEs() {
        return this.mDenied;
    }

    List<ZimbraACE> getACEs(Set<Right> rights) {
        ArrayList<ZimbraACE> result = new ArrayList<ZimbraACE>();
        for (ZimbraACE ace : this.mAces) {
            if (!rights.contains(ace.getRight())) continue;
            result.add(ace);
        }
        return result;
    }

    List<String> serialize() {
        ArrayList<String> aces = new ArrayList<String>();
        for (ZimbraACE ace : this.mAces) {
            aces.add(ace.serialize());
        }
        return aces;
    }

    private static String dump(Collection<ZimbraACE> aces) {
        StringBuffer sb = new StringBuffer();
        for (ZimbraACE ace : aces) {
            sb.append(ace.dump() + " ");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] aces = new String[]{"99999999-9999-9999-9999-999999999999 pub -invite", "f36fb465-c54b-4d1e-b2d5-5786078bf1d3 grp viewFreeBusy", "44d2b6b8-8001-4305-a9c0-419d04a44a9a usr -invite", "3b110e75-4003-4634-a3ec-fea456ad7d84 grp -invite"};
        try {
            ZimbraACL acl = new ZimbraACL(aces, TargetType.account, "user1@phoebe.mac");
            List<String> serialized = acl.serialize();
            for (String ace : serialized) {
                System.out.println(ace);
            }
        }
        catch (ServiceException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

