/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.RightModifier;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.mailbox.ACL;

public class ZimbraACE {
    private static final char S_DELIMITER = ' ';
    private static final String S_SECRET_DELIMITER = ":";
    private String mGrantee;
    private GranteeType mGranteeType;
    private Right mRight;
    private RightModifier mRightModifier;
    private String mSecret;
    private TargetType mTargetType;
    private String mTargetName;

    private String[] getParts(String ace) throws ServiceException {
        int p3 = ace.lastIndexOf(32);
        if (p3 == -1) {
            throw ServiceException.PARSE_ERROR("bad ACE: " + ace, null);
        }
        int p2 = ace.lastIndexOf(32, p3 - 1);
        if (p2 == -1) {
            throw ServiceException.PARSE_ERROR("bad ACE: " + ace, null);
        }
        String[] parts = new String[]{ace.substring(0, p2), ace.substring(p2 + 1, p3), ace.substring(p3 + 1)};
        return parts;
    }

    ZimbraACE(String ace, RightManager rm, TargetType targetType, String targetName) throws ServiceException {
        String[] parts = this.getParts(ace);
        String grantee = parts[0];
        this.mGranteeType = GranteeType.fromCode(parts[1]);
        String right = parts[2];
        switch (this.mGranteeType) {
            case GT_USER: 
            case GT_GROUP: 
            case GT_DOMAIN: 
            case GT_AUTHUSER: 
            case GT_PUBLIC: {
                if (!Provisioning.isUUID(grantee)) {
                    throw ServiceException.PARSE_ERROR("grantee ID [" + grantee + "] is not a UUID", null);
                }
                this.mGrantee = grantee;
                break;
            }
            case GT_GUEST: 
            case GT_KEY: {
                String[] externalParts = grantee.split(S_SECRET_DELIMITER);
                if (externalParts.length != 2) {
                    throw ServiceException.PARSE_ERROR("bad ACE(gurst/key grantee must have two sub parts): " + ace, null);
                }
                this.mGrantee = this.decodeGrantee(externalParts[0]);
                this.mSecret = this.decodeSecret(externalParts[1]);
                break;
            }
            default: {
                throw ServiceException.PARSE_ERROR("invalid grantee type " + (Object)((Object)this.mGranteeType), null);
            }
        }
        this.mRightModifier = RightModifier.fromChar(right.charAt(0));
        this.mRight = this.mRightModifier == null ? rm.getRight(right) : rm.getRight(right.substring(1));
        this.mTargetType = targetType;
        this.mTargetName = targetName;
    }

    public ZimbraACE(String granteeId, GranteeType granteeType, Right right, RightModifier rightModifier, String secret) throws ServiceException {
        this.mGrantee = granteeId;
        this.mGranteeType = granteeType;
        this.mRightModifier = rightModifier;
        this.mRight = right;
        this.mSecret = secret;
    }

    private ZimbraACE(ZimbraACE other) {
        this.mGrantee = new String(other.mGrantee);
        this.mGranteeType = other.mGranteeType;
        this.mRight = other.mRight;
        this.mRightModifier = other.mRightModifier;
        if (other.mSecret != null) {
            this.mSecret = new String(other.mSecret);
        }
        this.mTargetType = other.mTargetType;
        this.mTargetName = other.mTargetName;
    }

    public ZimbraACE clone() {
        return new ZimbraACE(this);
    }

    private String encodeGrantee(String granteeName) {
        return granteeName;
    }

    private String decodeGrantee(String granteeName) throws ServiceException {
        return granteeName;
    }

    private String encodeSecret(String secret) {
        return secret;
    }

    private String decodeSecret(String secret) throws ServiceException {
        return secret;
    }

    public boolean isGrantee(String principalId) {
        if (principalId == null || principalId.equals("99999999-9999-9999-9999-999999999999")) {
            return this.mGranteeType == GranteeType.GT_PUBLIC;
        }
        if (principalId.equals("00000000-0000-0000-0000-000000000000")) {
            return this.mGranteeType == GranteeType.GT_AUTHUSER;
        }
        return principalId.equals(this.mGrantee);
    }

    public String getGrantee() {
        return this.mGrantee;
    }

    public GranteeType getGranteeType() {
        return this.mGranteeType;
    }

    public Right getRight() {
        return this.mRight;
    }

    public boolean deny() {
        return this.mRightModifier == RightModifier.RM_DENY;
    }

    public boolean canDelegate() {
        return this.mRightModifier == RightModifier.RM_CAN_DELEGATE;
    }

    public boolean canExecuteOnly() {
        return !this.canDelegate() && !this.deny();
    }

    public String getSecret() {
        return this.mSecret;
    }

    public void setSecret(String secret) {
        this.mSecret = secret;
    }

    RightModifier getRightModifier() {
        return this.mRightModifier;
    }

    void setRightModifier(RightModifier rightModifier) {
        this.mRightModifier = rightModifier;
    }

    void setRight(Right right) {
        this.mRight = right;
    }

    TargetType getTargetType() {
        return this.mTargetType;
    }

    String getTargetName() {
        return this.mTargetName;
    }

    private boolean matches(Account acct) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        if (acct == null) {
            return this.mGranteeType == GranteeType.GT_PUBLIC;
        }
        switch (this.mGranteeType) {
            case GT_PUBLIC: {
                return true;
            }
            case GT_AUTHUSER: {
                return !(acct instanceof ACL.GuestAccount);
            }
            case GT_GROUP: {
                return prov.inDistributionList(acct, this.mGrantee);
            }
            case GT_USER: {
                return this.mGrantee.equals(acct.getId());
            }
            case GT_GUEST: {
                return this.matchesGuestAccount(acct);
            }
            case GT_KEY: {
                return this.matchesAccessKey(acct);
            }
        }
        throw ServiceException.FAILURE("unknown ACL grantee type: " + (Object)((Object)this.mGranteeType), null);
    }

    private boolean matchesGuestAccount(Account acct) {
        if (!(acct instanceof ACL.GuestAccount)) {
            return false;
        }
        return ((ACL.GuestAccount)acct).matches(this.mGrantee, this.mSecret);
    }

    private boolean matchesAccessKey(Account acct) {
        if (!(acct instanceof ACL.GuestAccount)) {
            return false;
        }
        return ((ACL.GuestAccount)acct).matchesAccessKey(this.mGrantee, this.mSecret);
    }

    boolean matchesGrantee(Account grantee) throws ServiceException {
        return this.matches(grantee);
    }

    public String getGranteeDisplayName() {
        try {
            switch (this.mGranteeType) {
                case GT_USER: {
                    Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, this.mGrantee);
                    if (acct != null) {
                        return acct.getName();
                    }
                    break;
                }
                case GT_GROUP: {
                    DistributionList group = Provisioning.getInstance().get(Provisioning.DistributionListBy.id, this.mGrantee);
                    if (group != null) {
                        return group.getName();
                    }
                    break;
                }
                case GT_DOMAIN: {
                    Domain domain = Provisioning.getInstance().get(Provisioning.DomainBy.id, this.mGrantee);
                    if (domain != null) {
                        return domain.getName();
                    }
                    break;
                }
                case GT_GUEST: 
                case GT_KEY: {
                    return this.mGrantee;
                }
                default: {
                    return null;
                }
            }
        }
        catch (ServiceException e) {
            ZimbraLog.acl.warn((Object)("cannot get grantee name for " + this.mGrantee), e);
        }
        return null;
    }

    public String serialize() {
        StringBuffer sb = new StringBuffer();
        if (this.mGranteeType == GranteeType.GT_GUEST || this.mGranteeType == GranteeType.GT_KEY) {
            sb.append(this.encodeGrantee(this.mGrantee) + S_SECRET_DELIMITER + this.encodeSecret(this.mSecret) + ' ');
        } else {
            sb.append(this.mGrantee + ' ');
        }
        sb.append(this.getGranteeType().getCode() + ' ');
        if (this.mRightModifier != null) {
            sb.append(this.mRightModifier.getModifier());
        }
        sb.append(this.getRight().getName());
        return sb.toString();
    }

    public String dump() {
        return "[(" + this.getGranteeDisplayName() + ") " + this.serialize() + "]";
    }

    public static void validate(ZimbraACE ace) throws ServiceException {
        if (ace.mGranteeType == GranteeType.GT_GUEST || ace.mGranteeType == GranteeType.GT_KEY) {
            if (ace.getGrantee().contains(S_SECRET_DELIMITER)) {
                throw ServiceException.INVALID_REQUEST("grantee cannot contain::", null);
            }
            if (ace.getSecret() != null && ace.getSecret().contains(S_SECRET_DELIMITER)) {
                throw ServiceException.INVALID_REQUEST("password/accesskey cannot contain::", null);
            }
        }
    }
}

