/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.GlobalGrant;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.ldap.LdapDIT;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TargetType {
    account(true, true, AttributeClass.account, "Account"),
    calresource(true, true, AttributeClass.calendarResource, "CalendarResource"),
    cos(true, false, AttributeClass.cos, "Cos"),
    dl(true, true, AttributeClass.distributionList, "DistributionList"),
    domain(true, false, AttributeClass.domain, "Domain"),
    server(true, false, AttributeClass.server, "Server"),
    xmppcomponent(true, false, AttributeClass.xmppComponent, "XMPPComponent"),
    zimlet(true, false, AttributeClass.zimletEntry, "Zimlet"),
    config(false, false, AttributeClass.globalConfig, "GlobalConfig"),
    global(false, false, AttributeClass.aclTarget, "GlobalGrant");

    private boolean mNeedsTargetIdentity;
    private boolean mIsDomained;
    private AttributeClass mAttrClass;
    private String mPrettyName;
    private Set<TargetType> mInheritedByTargetTypes;
    private Set<TargetType> mInheritFromTargetTypes;
    private Set<TargetType> mSubTargetTypes;

    private TargetType(boolean NeedsTargetIdentity, boolean isDomained, AttributeClass attrClass, String prettyName) {
        this.mNeedsTargetIdentity = NeedsTargetIdentity;
        this.mIsDomained = isDomained;
        this.mAttrClass = attrClass;
        this.mPrettyName = prettyName;
    }

    private void setInheritedByTargetTypes(TargetType[] targetTypes) {
        this.mInheritedByTargetTypes = new HashSet<TargetType>(Arrays.asList(targetTypes));
    }

    static void init() {
        account.setInheritedByTargetTypes(new TargetType[]{account});
        calresource.setInheritedByTargetTypes(new TargetType[]{account, calresource});
        dl.setInheritedByTargetTypes(new TargetType[]{account, calresource, dl});
        domain.setInheritedByTargetTypes(new TargetType[]{account, calresource, dl, domain});
        cos.setInheritedByTargetTypes(new TargetType[]{cos});
        server.setInheritedByTargetTypes(new TargetType[]{server});
        xmppcomponent.setInheritedByTargetTypes(new TargetType[]{xmppcomponent});
        zimlet.setInheritedByTargetTypes(new TargetType[]{zimlet});
        config.setInheritedByTargetTypes(new TargetType[]{config});
        global.setInheritedByTargetTypes(new TargetType[]{account, calresource, cos, dl, domain, server, xmppcomponent, zimlet, config, global});
        for (TargetType inheritFrom : TargetType.values()) {
            inheritFrom.mInheritFromTargetTypes = new HashSet<TargetType>();
            inheritFrom.mSubTargetTypes = new HashSet<TargetType>();
            for (TargetType inheritedBy : TargetType.values()) {
                if (!inheritedBy.mInheritedByTargetTypes.contains((Object)inheritFrom)) continue;
                inheritFrom.mInheritFromTargetTypes.add(inheritedBy);
            }
            for (TargetType tt : inheritFrom.mInheritedByTargetTypes) {
                if (inheritFrom == calresource) {
                    if (inheritFrom == tt || tt == account) continue;
                    inheritFrom.mSubTargetTypes.add(tt);
                    continue;
                }
                if (inheritFrom == tt) continue;
                inheritFrom.mSubTargetTypes.add(tt);
            }
        }
        for (TargetType tt : TargetType.values()) {
            tt.mInheritedByTargetTypes = Collections.unmodifiableSet(tt.mInheritedByTargetTypes);
            tt.mInheritFromTargetTypes = Collections.unmodifiableSet(tt.mInheritFromTargetTypes);
            tt.mSubTargetTypes = Collections.unmodifiableSet(tt.mSubTargetTypes);
        }
    }

    boolean isInheritedBy(TargetType targetType) {
        return this.mInheritedByTargetTypes.contains((Object)targetType);
    }

    Set<TargetType> subTargetTypes() {
        return this.mSubTargetTypes;
    }

    Set<TargetType> inheritFrom() {
        return this.mInheritFromTargetTypes;
    }

    public static TargetType fromCode(String s) throws ServiceException {
        try {
            return TargetType.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            throw ServiceException.INVALID_REQUEST("unknown target type: " + s, e);
        }
    }

    public String getCode() {
        return this.name();
    }

    public String getPrettyName() {
        return this.mPrettyName;
    }

    public boolean needsTargetIdentity() {
        return this.mNeedsTargetIdentity;
    }

    AttributeClass getAttributeClass() {
        return this.mAttrClass;
    }

    public static Entry lookupTarget(Provisioning prov, TargetType targetType, Provisioning.TargetBy targetBy, String target) throws ServiceException {
        return TargetType.lookupTarget(prov, targetType, targetBy, target, true);
    }

    static Entry lookupTarget(Provisioning prov, TargetType targetType, Provisioning.TargetBy targetBy, String target, boolean mustFind) throws ServiceException {
        Entry targetEntry = null;
        switch (targetType) {
            case account: {
                targetEntry = prov.get(Provisioning.AccountBy.fromString(targetBy.name()), target);
                if (targetEntry != null || !mustFind) break;
                throw AccountServiceException.NO_SUCH_ACCOUNT(target);
            }
            case calresource: {
                targetEntry = prov.get(Provisioning.CalendarResourceBy.fromString(targetBy.name()), target);
                if (targetEntry != null || !mustFind) break;
                throw AccountServiceException.NO_SUCH_CALENDAR_RESOURCE(target);
            }
            case dl: {
                targetEntry = prov.getAclGroup(Provisioning.DistributionListBy.fromString(targetBy.name()), target);
                if (targetEntry != null || !mustFind) break;
                throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(target);
            }
            case domain: {
                targetEntry = prov.get(Provisioning.DomainBy.fromString(targetBy.name()), target);
                if (targetEntry != null || !mustFind) break;
                throw AccountServiceException.NO_SUCH_DOMAIN(target);
            }
            case cos: {
                targetEntry = prov.get(Provisioning.CosBy.fromString(targetBy.name()), target);
                if (targetEntry != null || !mustFind) break;
                throw AccountServiceException.NO_SUCH_COS(target);
            }
            case server: {
                targetEntry = prov.get(Provisioning.ServerBy.fromString(targetBy.name()), target);
                if (targetEntry != null || !mustFind) break;
                throw AccountServiceException.NO_SUCH_SERVER(target);
            }
            case xmppcomponent: {
                targetEntry = prov.get(Provisioning.XMPPComponentBy.fromString(targetBy.name()), target);
                if (targetEntry != null || !mustFind) break;
                throw AccountServiceException.NO_SUCH_XMPP_COMPONENT(target);
            }
            case zimlet: {
                Provisioning.ZimletBy zimletBy = Provisioning.ZimletBy.fromString(targetBy.name());
                if (zimletBy != Provisioning.ZimletBy.name) {
                    throw ServiceException.INVALID_REQUEST("zimlet must be by name", null);
                }
                targetEntry = prov.getZimlet(target);
                if (targetEntry != null || !mustFind) break;
                throw AccountServiceException.NO_SUCH_ZIMLET(target);
            }
            case config: {
                targetEntry = prov.getConfig();
                break;
            }
            case global: {
                targetEntry = prov.getGlobalGrant();
                break;
            }
            default: {
                ServiceException.INVALID_REQUEST("invallid target type for lookupTarget:" + targetType.toString(), null);
            }
        }
        return targetEntry;
    }

    static Set<String> getAttrsInClass(Entry target) throws ServiceException {
        AttributeClass klass = TargetType.getAttributeClass(target);
        return AttributeManager.getInstance().getAllAttrsInClass(klass);
    }

    static AttributeClass getAttributeClass(Entry target) throws ServiceException {
        if (target instanceof CalendarResource) {
            return AttributeClass.calendarResource;
        }
        if (target instanceof Account) {
            return AttributeClass.account;
        }
        if (target instanceof Domain) {
            return AttributeClass.domain;
        }
        if (target instanceof Cos) {
            return AttributeClass.cos;
        }
        if (target instanceof DistributionList) {
            return AttributeClass.distributionList;
        }
        if (target instanceof Server) {
            return AttributeClass.server;
        }
        if (target instanceof Config) {
            return AttributeClass.globalConfig;
        }
        if (target instanceof GlobalGrant) {
            return AttributeClass.aclTarget;
        }
        if (target instanceof Zimlet) {
            return AttributeClass.zimletEntry;
        }
        if (target instanceof XMPPComponent) {
            return AttributeClass.xmppComponent;
        }
        throw ServiceException.FAILURE("internal error", null);
    }

    public static TargetType getTargetType(Entry target) throws ServiceException {
        if (target instanceof CalendarResource) {
            return calresource;
        }
        if (target instanceof Account) {
            return account;
        }
        if (target instanceof Domain) {
            return domain;
        }
        if (target instanceof Cos) {
            return cos;
        }
        if (target instanceof DistributionList) {
            return dl;
        }
        if (target instanceof Server) {
            return server;
        }
        if (target instanceof Config) {
            return config;
        }
        if (target instanceof GlobalGrant) {
            return global;
        }
        if (target instanceof Zimlet) {
            return zimlet;
        }
        if (target instanceof XMPPComponent) {
            return xmppcomponent;
        }
        throw ServiceException.FAILURE("internal error", null);
    }

    boolean isDomained() {
        return this.mIsDomained;
    }

    public static String getId(Entry target) {
        return target instanceof NamedEntry ? ((NamedEntry)target).getId() : null;
    }

    public static Domain getTargetDomain(Provisioning prov, Entry target) throws ServiceException {
        if (target instanceof CalendarResource) {
            CalendarResource cr = (CalendarResource)target;
            return prov.getDomain(cr);
        }
        if (target instanceof Account) {
            Account acct = (Account)target;
            return prov.getDomain(acct);
        }
        if (target instanceof DistributionList) {
            DistributionList dl = (DistributionList)target;
            return prov.getDomain(dl);
        }
        return null;
    }

    static Pair<String, Set<String>> getSearchBaseAndOCs(Provisioning prov, Set<TargetType> targetTypes) throws ServiceException {
        if (targetTypes.isEmpty()) {
            return null;
        }
        LdapDIT dit = ((LdapProvisioning)prov).getDIT();
        String[] curRnds = null;
        String base = null;
        HashSet<String> ocs = new HashSet<String>();
        for (TargetType tt : targetTypes) {
            String bs;
            switch (tt) {
                case account: 
                case calresource: 
                case dl: 
                case domain: {
                    bs = "";
                    break;
                }
                case cos: {
                    bs = dit.cosBaseDN();
                    break;
                }
                case server: {
                    bs = dit.serverBaseDN();
                    break;
                }
                case xmppcomponent: {
                    bs = dit.xmppcomponentBaseDN();
                    break;
                }
                case zimlet: {
                    bs = dit.zimletBaseDN();
                    break;
                }
                case config: {
                    bs = dit.configDN();
                    break;
                }
                case global: {
                    bs = dit.globalGrantDN();
                    break;
                }
                default: {
                    throw ServiceException.FAILURE("internal error", null);
                }
            }
            if (bs.equals("")) {
                base = bs;
            } else {
                String[] rdns = bs.split(",");
                if (curRnds == null) {
                    curRnds = rdns;
                } else {
                    int shorter = rdns.length < curRnds.length ? rdns.length : curRnds.length;
                    for (int i = 1; i <= shorter; ++i) {
                        if (rdns[rdns.length - i].equals(curRnds[curRnds.length - i])) continue;
                        if (i == 1) {
                            base = "";
                            break;
                        }
                        curRnds = new String[i - 1];
                        for (int j = 0; j < i - 1; ++j) {
                            curRnds[curRnds.length - 1 - j] = rdns[rdns.length - 1 - j];
                        }
                    }
                }
            }
            if (base == null) continue;
            break;
        }
        if (base == null) {
            boolean first = true;
            for (int i = 0; i < curRnds.length; ++i) {
                if (first) {
                    base = curRnds[i];
                    first = false;
                    continue;
                }
                base = base + "," + (String)curRnds[i];
            }
        }
        for (TargetType tt : targetTypes) {
            ocs.add(tt.getAttributeClass().getOCName());
        }
        return new Pair(base, ocs);
    }

    private static void doTest(Provisioning prov, Set<TargetType> ttInheritBy) throws ServiceException {
        Pair<String, Set<String>> baseAndOcs = TargetType.getSearchBaseAndOCs(prov, ttInheritBy);
        System.out.println("    base:" + baseAndOcs.getFirst());
        System.out.print("    OCs: ");
        for (String oc : baseAndOcs.getSecond()) {
            System.out.print(oc + " ");
        }
        System.out.println("\n");
    }

    public static void main(String[] args) throws ServiceException {
        Set<TargetType> ttInheritBy;
        Provisioning prov = Provisioning.getInstance();
        for (TargetType tt : TargetType.values()) {
            System.out.println("Target " + tt.name());
            ttInheritBy = new HashSet();
            ttInheritBy.add(tt);
            TargetType.doTest(prov, ttInheritBy);
            ttInheritBy = tt.subTargetTypes();
            System.out.print("    sub target types: ");
            for (TargetType ttib : ttInheritBy) {
                System.out.print(ttib.name() + " ");
            }
            System.out.println();
            if (ttInheritBy.isEmpty()) {
                System.out.println();
                continue;
            }
            TargetType.doTest(prov, ttInheritBy);
        }
        System.out.println("==========");
        System.out.println("Test");
        ttInheritBy = new HashSet<TargetType>();
        ttInheritBy.add(cos);
        ttInheritBy.add(server);
        ttInheritBy.add(zimlet);
        ttInheritBy.add(global);
        TargetType.doTest(prov, ttInheritBy);
    }

    static {
        TargetType.init();
    }
}

