/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.GlobalGrant;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.PseudoTarget;
import com.zimbra.cs.account.accesscontrol.TargetType;

public abstract class TargetIterator {
    protected Provisioning mProv;
    protected TargetType mCurTargetType;
    protected Entry mTarget;
    protected boolean mCheckedSelf;
    protected boolean mNoMore;

    Entry next() throws ServiceException {
        if (this.mNoMore) {
            return null;
        }
        Entry grantedOn = null;
        if (!this.mCheckedSelf) {
            this.mCurTargetType = TargetType.global;
            this.mCheckedSelf = true;
            grantedOn = this.mTarget;
        } else if (this.mCurTargetType == TargetType.global) {
            this.mNoMore = true;
            grantedOn = this.mProv.getGlobalGrant();
        }
        return grantedOn;
    }

    private TargetIterator(Provisioning prov, TargetType initialTargetType, Entry target) {
        this.mProv = prov;
        this.mCurTargetType = initialTargetType;
        this.mTarget = target;
    }

    static TargetIterator getTargetIeterator(Provisioning prov, Entry target) throws ServiceException {
        TargetIterator iter = null;
        if (target instanceof CalendarResource) {
            iter = new AccountTargetIterator(prov, target);
        } else if (target instanceof Account) {
            iter = new AccountTargetIterator(prov, target);
        } else if (target instanceof Domain) {
            iter = new DomainTargetIterator(prov, target);
        } else if (target instanceof Cos) {
            iter = new CosTargetIterator(prov, target);
        } else if (target instanceof DistributionList) {
            if (!((DistributionList)target).isAclGroup()) {
                target = prov.getAclGroup(Provisioning.DistributionListBy.id, ((DistributionList)target).getId());
            }
            iter = new DistributionListTargetIterator(prov, target);
        } else if (target instanceof Server) {
            iter = new ServerTargetIterator(prov, target);
        } else if (target instanceof Config) {
            iter = new ConfigTargetIterator(prov, target);
        } else if (target instanceof GlobalGrant) {
            iter = new GlobalGrantTargetIterator(prov, target);
        } else if (target instanceof Zimlet) {
            iter = new ZimletTargetIterator(prov, target);
        } else if (target instanceof XMPPComponent) {
            iter = new XMPPComponentTargetIterator(prov, target);
        } else {
            throw ServiceException.FAILURE("internal error", null);
        }
        ((TargetIterator)iter).next();
        return iter;
    }

    public static class GlobalGrantTargetIterator
    extends TargetIterator {
        GlobalGrantTargetIterator(Provisioning prov, Entry target) {
            super(prov, TargetType.account, target);
        }

        Entry next() throws ServiceException {
            if (this.mNoMore) {
                return null;
            }
            Entry grantedOn = null;
            if (!this.mCheckedSelf) {
                this.mCheckedSelf = true;
                this.mNoMore = true;
                grantedOn = this.mTarget;
            }
            return grantedOn;
        }
    }

    public static class ZimletTargetIterator
    extends TargetIterator {
        ZimletTargetIterator(Provisioning prov, Entry target) {
            super(prov, TargetType.account, target);
        }
    }

    public static class XMPPComponentTargetIterator
    extends TargetIterator {
        XMPPComponentTargetIterator(Provisioning prov, Entry target) {
            super(prov, TargetType.account, target);
        }
    }

    public static class ServerTargetIterator
    extends TargetIterator {
        ServerTargetIterator(Provisioning prov, Entry target) {
            super(prov, TargetType.account, target);
        }
    }

    public static class DomainTargetIterator
    extends TargetIterator {
        DomainTargetIterator(Provisioning prov, Entry target) {
            super(prov, TargetType.account, target);
        }
    }

    public static class CosTargetIterator
    extends TargetIterator {
        CosTargetIterator(Provisioning prov, Entry target) {
            super(prov, TargetType.account, target);
        }
    }

    public static class ConfigTargetIterator
    extends TargetIterator {
        ConfigTargetIterator(Provisioning prov, Entry target) {
            super(prov, TargetType.account, target);
        }
    }

    public static class DistributionListTargetIterator
    extends TargetIterator {
        private Provisioning.AclGroups mGroups = null;
        private int mIdxInGroups = 0;

        DistributionListTargetIterator(Provisioning prov, Entry target) {
            super(prov, TargetType.dl, target);
        }

        Entry next() throws ServiceException {
            if (this.mNoMore) {
                return null;
            }
            Entry grantedOn = null;
            if (!this.mCheckedSelf) {
                this.mCurTargetType = TargetType.dl;
                this.mCheckedSelf = true;
                grantedOn = this.mTarget;
            } else if (this.mCurTargetType == TargetType.dl) {
                if (this.mGroups == null) {
                    this.mGroups = this.mTarget instanceof PseudoTarget.PseudoDistributionList ? new Provisioning.AclGroups() : this.mProv.getAclGroups((DistributionList)this.mTarget, false);
                }
                if (this.mIdxInGroups < this.mGroups.groupIds().size()) {
                    grantedOn = this.mProv.getAclGroup(Provisioning.DistributionListBy.id, this.mGroups.groupIds().get(this.mIdxInGroups));
                    ++this.mIdxInGroups;
                } else {
                    this.mCurTargetType = TargetType.domain;
                    grantedOn = this.next();
                }
            } else if (this.mCurTargetType == TargetType.domain) {
                this.mCurTargetType = TargetType.global;
                Domain pseudoDomain = null;
                if (this.mTarget instanceof PseudoTarget.PseudoDistributionList) {
                    pseudoDomain = ((PseudoTarget.PseudoDistributionList)this.mTarget).getPseudoDomain();
                }
                grantedOn = pseudoDomain != null ? this.next() : this.mProv.getDomain((DistributionList)this.mTarget);
            } else if (this.mCurTargetType == TargetType.global) {
                this.mNoMore = true;
                grantedOn = this.mProv.getGlobalGrant();
            }
            return grantedOn;
        }
    }

    public static class AccountTargetIterator
    extends TargetIterator {
        private Provisioning.AclGroups mGroups = null;
        private int mIdxInGroups = 0;

        AccountTargetIterator(Provisioning prov, Entry target) {
            super(prov, TargetType.account, target);
        }

        Entry next() throws ServiceException {
            if (this.mNoMore) {
                return null;
            }
            Entry grantedOn = null;
            if (!this.mCheckedSelf) {
                this.mCurTargetType = TargetType.dl;
                this.mCheckedSelf = true;
                grantedOn = this.mTarget;
            } else if (this.mCurTargetType == TargetType.dl) {
                if (this.mGroups == null) {
                    this.mGroups = this.mTarget instanceof PseudoTarget.PseudoAccount ? new Provisioning.AclGroups() : this.mProv.getAclGroups((Account)this.mTarget, false);
                }
                if (this.mIdxInGroups < this.mGroups.groupIds().size()) {
                    grantedOn = this.mProv.getAclGroup(Provisioning.DistributionListBy.id, this.mGroups.groupIds().get(this.mIdxInGroups));
                    ++this.mIdxInGroups;
                } else {
                    this.mCurTargetType = TargetType.domain;
                    grantedOn = this.next();
                }
            } else if (this.mCurTargetType == TargetType.domain) {
                this.mCurTargetType = TargetType.global;
                Domain pseudoDomain = null;
                if (this.mTarget instanceof PseudoTarget.PseudoAccount) {
                    pseudoDomain = ((PseudoTarget.PseudoAccount)this.mTarget).getPseudoDomain();
                } else if (this.mTarget instanceof PseudoTarget.PseudoCalendarResource) {
                    pseudoDomain = ((PseudoTarget.PseudoCalendarResource)this.mTarget).getPseudoDomain();
                }
                grantedOn = pseudoDomain != null ? this.next() : this.mProv.getDomain((Account)this.mTarget);
            } else if (this.mCurTargetType == TargetType.global) {
                this.mNoMore = true;
                grantedOn = this.mProv.getGlobalGrant();
            }
            return grantedOn;
        }
    }
}

