/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.accesscontrol.ZimbraACL;
import com.zimbra.cs.account.ldap.LdapUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchGrants {
    private Provisioning mProv;
    private Set<TargetType> mTargetTypes;
    private Set<String> mGranteeIds;

    SearchGrants(Provisioning prov, Set<TargetType> targetTypes, Set<String> granteeIds) {
        this.mProv = prov;
        this.mTargetTypes = targetTypes;
        this.mGranteeIds = granteeIds;
    }

    SearchGrantsResults doSearch() throws ServiceException {
        Pair<String, Set<String>> baseAndOcs = TargetType.getSearchBaseAndOCs(this.mProv, this.mTargetTypes);
        String base = baseAndOcs.getFirst();
        StringBuilder ocQuery = new StringBuilder();
        ocQuery.append("(|");
        for (String oc : baseAndOcs.getSecond()) {
            ocQuery.append("(objectClass=" + oc + ")");
        }
        ocQuery.append(")");
        StringBuilder granteeQuery = new StringBuilder();
        granteeQuery.append("(|");
        for (String granteeId : this.mGranteeIds) {
            granteeQuery.append("(zimbraACE=" + granteeId + "*)");
        }
        granteeQuery.append(")");
        String query = "(&" + granteeQuery + ocQuery + ")";
        String[] returnAttrs = new String[]{"cn", "zimbraId", "objectClass", "zimbraACE"};
        SearchGrantsResults results = new SearchGrantsResults(this.mProv);
        SearchGrantVisitor visitor = new SearchGrantVisitor(results);
        LdapUtil.searchLdapOnMaster(base, query, returnAttrs, visitor);
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchGrantVisitor
    implements LdapUtil.SearchLdapVisitor {
        SearchGrantsResults mResults;

        SearchGrantVisitor(SearchGrantsResults results) {
            this.mResults = results;
        }

        @Override
        public void visit(String dn, Map<String, Object> attrs, Attributes ldapAttrs) {
            GrantsOnTargetRaw sgr = new GrantsOnTargetRaw(attrs);
            this.mResults.addResult(sgr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrantsOnTargetRaw {
        private String cn;
        private String zimbraId;
        private Set<String> objectClass;
        private String[] zimbraACE;

        private String dump() {
            StringBuilder sb = new StringBuilder();
            sb.append("SearchGrantResult: ");
            sb.append("cn=" + this.cn);
            sb.append("zimbraId=" + this.zimbraId);
            sb.append(", objectClass=[");
            for (String oc : this.objectClass) {
                sb.append(oc + ", ");
            }
            sb.append("]");
            sb.append(", zimbraACE=[");
            for (String ace : this.zimbraACE) {
                sb.append(ace + ", ");
            }
            return sb.toString();
        }

        private String[] getMultiAttrString(Map<String, Object> attrs, String attrName) {
            Object obj = attrs.get(attrName);
            if (obj instanceof String) {
                String[] values = new String[]{(String)obj};
                return values;
            }
            return (String[])obj;
        }

        private GrantsOnTargetRaw(Map<String, Object> attrs) {
            this.cn = (String)attrs.get("cn");
            this.zimbraId = (String)attrs.get("zimbraId");
            this.objectClass = new HashSet<String>(Arrays.asList(this.getMultiAttrString(attrs, "objectClass")));
            this.zimbraACE = this.getMultiAttrString(attrs, "zimbraACE");
        }

        private String getTargetId() {
            return this.zimbraId != null ? this.zimbraId : this.cn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SearchGrantsResults {
        private Provisioning mProv;
        private Map<String, GrantsOnTargetRaw> mRawResults = new HashMap<String, GrantsOnTargetRaw>();
        private Set<GrantsOnTarget> mResults;

        SearchGrantsResults(Provisioning prov) {
            this.mProv = prov;
        }

        private void addResult(GrantsOnTargetRaw result) {
            this.mRawResults.put(result.getTargetId(), result);
        }

        Set<GrantsOnTarget> getResults() throws ServiceException {
            if (this.mResults == null) {
                this.mResults = new HashSet<GrantsOnTarget>();
                for (GrantsOnTargetRaw grants : this.mRawResults.values()) {
                    GrantsOnTarget grantsOnTarget = this.getGrants(this.mProv, grants);
                    this.mResults.add(grantsOnTarget);
                }
            }
            return this.mResults;
        }

        private GrantsOnTarget getGrants(Provisioning prov, GrantsOnTargetRaw sgr) throws ServiceException {
            TargetType tt;
            if (sgr.objectClass.contains(AttributeClass.calendarResource.getOCName())) {
                tt = TargetType.calresource;
            } else if (sgr.objectClass.contains(AttributeClass.account.getOCName())) {
                tt = TargetType.account;
            } else if (sgr.objectClass.contains(AttributeClass.cos.getOCName())) {
                tt = TargetType.cos;
            } else if (sgr.objectClass.contains(AttributeClass.distributionList.getOCName())) {
                tt = TargetType.dl;
            } else if (sgr.objectClass.contains(AttributeClass.domain.getOCName())) {
                tt = TargetType.domain;
            } else if (sgr.objectClass.contains(AttributeClass.server.getOCName())) {
                tt = TargetType.server;
            } else if (sgr.objectClass.contains(AttributeClass.xmppComponent.getOCName())) {
                tt = TargetType.xmppcomponent;
            } else if (sgr.objectClass.contains(AttributeClass.zimletEntry.getOCName())) {
                tt = TargetType.zimlet;
            } else if (sgr.objectClass.contains(AttributeClass.globalConfig.getOCName())) {
                tt = TargetType.config;
            } else if (sgr.objectClass.contains(AttributeClass.aclTarget.getOCName())) {
                tt = TargetType.global;
            } else {
                throw ServiceException.FAILURE("cannot determine target type from SearchGrantResult. " + sgr.dump(), null);
            }
            Entry entry = null;
            try {
                entry = tt == TargetType.zimlet ? TargetType.lookupTarget(prov, tt, Provisioning.TargetBy.name, sgr.cn) : TargetType.lookupTarget(prov, tt, Provisioning.TargetBy.id, sgr.zimbraId);
                if (entry == null) {
                    ZimbraLog.acl.warn("canot find target by id " + sgr.zimbraId);
                    throw ServiceException.FAILURE("canot find target by id " + sgr.zimbraId + ". " + sgr.dump(), null);
                }
                ZimbraACL acl = new ZimbraACL(sgr.zimbraACE, tt, entry.getLabel());
                return new GrantsOnTarget(entry, acl);
            }
            catch (ServiceException e) {
                throw ServiceException.FAILURE("canot find target by id " + sgr.zimbraId + ". " + sgr.dump(), null);
            }
        }
    }

    static class GrantsOnTarget {
        private Entry mTargetEntry;
        private ZimbraACL mAcl;

        private GrantsOnTarget(Entry targetEntry, ZimbraACL acl) {
            this.mTargetEntry = targetEntry;
            this.mAcl = acl;
        }

        Entry getTargetEntry() {
            return this.mTargetEntry;
        }

        ZimbraACL getAcl() {
            return this.mAcl;
        }
    }
}

