/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.SetUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.FileGenUtil;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AttrRight;
import com.zimbra.cs.account.accesscontrol.ComboRight;
import com.zimbra.cs.account.accesscontrol.InlineAttrRight;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.accesscontrol.UserRight;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RightManager {
    private static final String E_A = "a";
    private static final String E_ATTRS = "attrs";
    private static final String E_DEFAULT = "default";
    private static final String E_DESC = "desc";
    private static final String E_DOC = "doc";
    private static final String E_INCLUDE = "include";
    private static final String E_R = "r";
    private static final String E_RIGHTS = "rights";
    private static final String E_RIGHT = "right";
    private static final String A_FILE = "file";
    private static final String A_LIMIT = "l";
    private static final String A_N = "n";
    private static final String A_NAME = "name";
    private static final String A_TARGET_TYPE = "targetType";
    private static final String A_TYPE = "type";
    private static final String A_USER_RIGHT = "userRight";
    private static final String TARGET_TYPE_DELIMITER = ",";
    private static RightManager mInstance;
    private Map<String, UserRight> sUserRights = new TreeMap<String, UserRight>();
    private Map<String, AdminRight> sAdminRights = new TreeMap<String, AdminRight>();

    public static synchronized RightManager getInstance() throws ServiceException {
        if (mInstance != null) {
            return mInstance;
        }
        String dir = LC.zimbra_rights_directory.value();
        mInstance = new RightManager(dir);
        try {
            Right.init(mInstance);
        }
        catch (ServiceException e) {
            ZimbraLog.acl.error((Object)("failed to initialize known right from: " + dir), e);
            throw e;
        }
        return mInstance;
    }

    private RightManager(String dir) throws ServiceException {
        File fdir = new File(dir);
        if (!fdir.exists()) {
            throw ServiceException.FAILURE("rights directory does not exists: " + dir, null);
        }
        if (!fdir.isDirectory()) {
            throw ServiceException.FAILURE("rights directory is not a directory: " + dir, null);
        }
        File[] files = fdir.listFiles();
        ArrayList<File> yetToProcess = new ArrayList<File>(Arrays.asList(files));
        ArrayList<File> processed = new ArrayList<File>();
        while (!yetToProcess.isEmpty()) {
            File file = (File)yetToProcess.get(0);
            if (!file.getPath().endsWith(".xml")) {
                ZimbraLog.acl.warn("while loading rights, ignoring none .xml file: " + file);
                yetToProcess.remove(file);
                continue;
            }
            if (!file.isFile()) {
                ZimbraLog.acl.warn("while loading rights, ignored non-file: " + file);
            }
            try {
                boolean done = this.loadSystemRights(file, processed);
                if (done) {
                    processed.add(file);
                    yetToProcess.remove(file);
                    continue;
                }
                yetToProcess.remove(file);
                yetToProcess.add(file);
            }
            catch (DocumentException de) {
                throw ServiceException.PARSE_ERROR("error loading rights file: " + file, de);
            }
        }
    }

    private boolean getBoolean(String value) throws ServiceException {
        if ("1".equals(value)) {
            return true;
        }
        if ("0".equals(value)) {
            return false;
        }
        throw ServiceException.PARSE_ERROR("invalid value:" + value, null);
    }

    private boolean getBooleanAttr(Element elem, String attr) throws ServiceException {
        String value = elem.attributeValue(attr);
        if (value == null) {
            throw ServiceException.PARSE_ERROR("missing required attribute: " + attr, null);
        }
        return this.getBoolean(value);
    }

    private boolean getBooleanAttr(Element elem, String attr, boolean defaultValue) throws ServiceException {
        String value = elem.attributeValue(attr);
        if (value == null) {
            return defaultValue;
        }
        return this.getBoolean(value);
    }

    private void parseDesc(Element eDesc, Right right) throws ServiceException {
        if (right.getDesc() != null) {
            throw ServiceException.PARSE_ERROR("multiple desc", null);
        }
        right.setDesc(eDesc.getText());
    }

    private void parseDoc(Element eDoc, Right right) throws ServiceException {
        if (right.getDoc() != null) {
            throw ServiceException.PARSE_ERROR("multiple doc", null);
        }
        right.setDoc(eDoc.getText());
    }

    private void parseDefault(Element eDefault, Right right) throws ServiceException {
        String defaultValue = eDefault.getText();
        if ("allow".equalsIgnoreCase(defaultValue)) {
            right.setDefault(Boolean.TRUE);
        } else if ("deny".equalsIgnoreCase(defaultValue)) {
            right.setDefault(Boolean.FALSE);
        } else {
            throw ServiceException.PARSE_ERROR("invalid default value: " + defaultValue, null);
        }
    }

    private void parseAttr(Element eAttr, AttrRight right) throws ServiceException {
        String attrName = eAttr.attributeValue(A_N);
        if (attrName == null) {
            throw ServiceException.PARSE_ERROR("missing attr name", null);
        }
        right.validateAttr(attrName);
        right.addAttr(attrName);
    }

    private void parseAttrs(Element eAttrs, Right right) throws ServiceException {
        if (!(right instanceof AttrRight)) {
            throw ServiceException.PARSE_ERROR("attrs is only allowed for admin getAttrs or setAttrs right", null);
        }
        AttrRight attrRight = (AttrRight)right;
        Iterator elemIter = eAttrs.elementIterator();
        while (elemIter.hasNext()) {
            Element elem = (Element)elemIter.next();
            if (elem.getName().equals(E_A)) {
                this.parseAttr(elem, attrRight);
                continue;
            }
            throw ServiceException.PARSE_ERROR("invalid element: " + elem.getName(), null);
        }
    }

    private void parseRight(Element eAttr, ComboRight right) throws ServiceException {
        String rightName = eAttr.attributeValue(A_N);
        if (rightName == null) {
            throw ServiceException.PARSE_ERROR("missing right name", null);
        }
        Right r = this.getRight(rightName);
        right.addRight(r);
    }

    private void parseRights(Element eAttrs, Right right) throws ServiceException {
        if (!(right instanceof ComboRight)) {
            throw ServiceException.PARSE_ERROR("rights is only allowed for admin combo right", null);
        }
        ComboRight comboRight = (ComboRight)right;
        Iterator elemIter = eAttrs.elementIterator();
        while (elemIter.hasNext()) {
            Element elem = (Element)elemIter.next();
            if (elem.getName().equals(E_R)) {
                this.parseRight(elem, comboRight);
                continue;
            }
            throw ServiceException.PARSE_ERROR("invalid element: " + elem.getName(), null);
        }
    }

    private Right parseRight(Element eRight) throws ServiceException {
        Right right;
        String name = eRight.attributeValue(A_NAME);
        if (name.contains(".")) {
            throw ServiceException.PARSE_ERROR("righ name cannot contain dot(.): " + name, null);
        }
        boolean userRight = this.getBooleanAttr(eRight, A_USER_RIGHT, false);
        Right.RightType rightType = null;
        String targetTypeStr = eRight.attributeValue(A_TARGET_TYPE, null);
        if (userRight) {
            if (targetTypeStr != null) {
                throw ServiceException.PARSE_ERROR("targetType is not allowed for user right", null);
            }
            right = new UserRight(name);
            right.setTargetType(TargetType.account);
        } else {
            String rt = eRight.attributeValue(A_TYPE);
            if (rt == null) {
                throw ServiceException.PARSE_ERROR("missing attribute [type]", null);
            }
            rightType = Right.RightType.fromString(rt);
            right = AdminRight.newAdminSystemRight(name, rightType);
            if (targetTypeStr != null) {
                String[] taregtTypes;
                for (String tt : taregtTypes = targetTypeStr.split(TARGET_TYPE_DELIMITER)) {
                    TargetType targetType = TargetType.fromCode(tt);
                    right.setTargetType(targetType);
                }
            }
        }
        Iterator elemIter = eRight.elementIterator();
        while (elemIter.hasNext()) {
            Element elem = (Element)elemIter.next();
            if (elem.getName().equals(E_DESC)) {
                this.parseDesc(elem, right);
                continue;
            }
            if (elem.getName().equals(E_DOC)) {
                this.parseDoc(elem, right);
                continue;
            }
            if (elem.getName().equals(E_DEFAULT)) {
                this.parseDefault(elem, right);
                continue;
            }
            if (elem.getName().equals(E_ATTRS)) {
                this.parseAttrs(elem, right);
                continue;
            }
            if (elem.getName().equals(E_RIGHTS)) {
                this.parseRights(elem, right);
                continue;
            }
            throw ServiceException.PARSE_ERROR("invalid element: " + elem.getName(), null);
        }
        right.completeRight();
        return right;
    }

    private boolean loadSystemRights(File file, List<File> processedFiles) throws DocumentException, ServiceException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(file);
        Element root = doc.getRootElement();
        if (!root.getName().equals(E_RIGHTS)) {
            throw ServiceException.PARSE_ERROR("root tag is not rights", null);
        }
        boolean seenRight = false;
        Iterator iter = root.elementIterator();
        while (iter.hasNext()) {
            String name;
            Element elem = (Element)iter.next();
            if (elem.getName().equals(E_INCLUDE)) {
                if (seenRight) {
                    throw ServiceException.PARSE_ERROR("include cannot appear after any right definition: " + elem.getName(), null);
                }
                String includeFile = elem.attributeValue(A_FILE);
                boolean processed = false;
                for (File f : processedFiles) {
                    if (!f.getName().equals(includeFile)) continue;
                    processed = true;
                    break;
                }
                if (processed) continue;
                return false;
            }
            Element eRight = elem;
            if (!eRight.getName().equals(E_RIGHT)) {
                throw ServiceException.PARSE_ERROR("unknown element: " + eRight.getName(), null);
            }
            if (!seenRight) {
                seenRight = true;
                ZimbraLog.acl.debug("Loading " + file.getName());
            }
            if ((name = eRight.attributeValue(A_NAME)) == null) {
                throw ServiceException.PARSE_ERROR("no name specified", null);
            }
            if (this.sUserRights.get(name) != null || this.sAdminRights.get(name) != null) {
                throw ServiceException.PARSE_ERROR("right " + name + " is already defined", null);
            }
            try {
                Right right = this.parseRight(eRight);
                if (right instanceof UserRight) {
                    this.sUserRights.put(name, (UserRight)right);
                    continue;
                }
                this.sAdminRights.put(name, (AdminRight)right);
            }
            catch (ServiceException e) {
                throw ServiceException.PARSE_ERROR("unable to parse right: [" + name + "]", e);
            }
        }
        return true;
    }

    public UserRight getUserRight(String right) throws ServiceException {
        UserRight r = this.sUserRights.get(right);
        if (r == null) {
            throw ServiceException.FAILURE("invalid right " + right, null);
        }
        return r;
    }

    public AdminRight getAdminRight(String right) throws ServiceException {
        AdminRight r = this.sAdminRights.get(right);
        if (r == null) {
            throw ServiceException.FAILURE("invalid right " + right, null);
        }
        return r;
    }

    public Right getRight(String right) throws ServiceException {
        if (InlineAttrRight.looksLikeOne(right)) {
            return InlineAttrRight.newInlineAttrRight(right);
        }
        return this.getRight(right, true);
    }

    private Right getRight(String right, boolean mustFind) throws ServiceException {
        Right r = this.sUserRights.get(right);
        if (r == null) {
            r = this.sAdminRights.get(right);
        }
        if (mustFind && r == null) {
            throw AccountServiceException.NO_SUCH_RIGHT("invalid right " + right);
        }
        return r;
    }

    public Map<String, UserRight> getAllUserRights() {
        return this.sUserRights;
    }

    public Map<String, AdminRight> getAllAdminRights() {
        return this.sAdminRights;
    }

    private String dump(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("============\n");
        sb.append("user rights:\n");
        sb.append("============\n");
        for (Map.Entry<String, UserRight> entry : this.getAllUserRights().entrySet()) {
            sb.append("\n------------------------------\n");
            entry.getValue().dump(sb);
        }
        sb.append("\n");
        sb.append("\n");
        sb.append("=============\n");
        sb.append("admin rights:\n");
        sb.append("=============\n");
        for (Map.Entry<String, Right> entry : this.getAllAdminRights().entrySet()) {
            sb.append("\n------------------------------\n");
            ((AdminRight)entry.getValue()).dump(sb);
        }
        return sb.toString();
    }

    void genRightConst(Right r, StringBuilder sb) {
        sb.append("\n    /**\n");
        if (r.getDesc() != null) {
            sb.append(FileGenUtil.wrapComments(StringUtil.escapeHtml(r.getDesc()), 70, "     * "));
            sb.append("\n");
        }
        sb.append("     */\n");
        sb.append("    public static final String RT_" + r.getName() + " = \"" + r.getName() + "\";" + "\n");
    }

    private String genRightConsts() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        sb.append("    /*\n");
        sb.append("    ============\n");
        sb.append("    user rights:\n");
        sb.append("    ============\n");
        sb.append("    */\n\n");
        for (Map.Entry<String, UserRight> entry : this.getAllUserRights().entrySet()) {
            this.genRightConst(entry.getValue(), sb);
        }
        sb.append("\n\n");
        sb.append("    /*\n");
        sb.append("    =============\n");
        sb.append("    admin rights:\n");
        sb.append("    =============\n");
        sb.append("    */\n\n");
        for (Map.Entry<String, Right> entry : this.getAllAdminRights().entrySet()) {
            this.genRightConst(entry.getValue(), sb);
        }
        return sb.toString();
    }

    private String genAdminRights() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        for (AdminRight r : this.getAllAdminRights().values()) {
            sb.append("    public static AdminRight R_" + r.getName() + ";" + "\n");
        }
        sb.append("\n\n");
        sb.append("    public static void init(RightManager rm) throws ServiceException {\n");
        for (AdminRight r : this.getAllAdminRights().values()) {
            String s = String.format("        R_%-36s = rm.getAdminRight(Right.RT_%s);\n", r.getName(), r.getName());
            sb.append(s);
        }
        sb.append("    }\n");
        return sb.toString();
    }

    private String genUserRights() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        for (UserRight r : this.getAllUserRights().values()) {
            sb.append("    public static UserRight R_" + r.getName() + ";" + "\n");
        }
        sb.append("\n\n");
        sb.append("    public static void init(RightManager rm) throws ServiceException {\n");
        for (UserRight r : this.getAllUserRights().values()) {
            String s = String.format("        R_%-36s = rm.getUserRight(Right.RT_%s);\n", r.getName(), r.getName());
            sb.append(s);
        }
        sb.append("    }\n");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        CL.main(args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CL {
        private static Options sOptions = new Options();

        private CL() {
        }

        private static void check() throws ServiceException {
            ZimbraLog.toolSetupLog4j("DEBUG", "/Users/pshao/sandbox/conf/log4j.properties.phoebe");
            RightManager rm = new RightManager("/Users/pshao/p4/main/ZimbraServer/conf/rights");
            System.out.println(rm.dump(null));
        }

        private static void genDomainAdminSetAttrsRights(String outFile, String templateFile) throws Exception {
            Set<String> acctAttrs = CL.getDomainAdminModifiableAttrs(AttributeClass.account);
            Set<String> crAttrs = CL.getDomainAdminModifiableAttrs(AttributeClass.calendarResource);
            Set<String> dlAttrs = CL.getDomainAdminModifiableAttrs(AttributeClass.distributionList);
            Set<String> domainAttrs = CL.getDomainAdminModifiableAttrs(AttributeClass.domain);
            Set<String> acctAndCrAttrs = SetUtil.intersect(acctAttrs, crAttrs);
            Set<String> acctOnlyAttrs = SetUtil.subtract(acctAttrs, crAttrs);
            Set<String> crOnlyAttrs = SetUtil.subtract(crAttrs, acctAttrs);
            if (acctOnlyAttrs.size() != 0) {
                throw ServiceException.FAILURE("account only attrs is not empty???", null);
            }
            String acctAndCrAttrsFiller = CL.genAttrs(acctAndCrAttrs);
            String crOnlyAttrsFiller = CL.genAttrs(crOnlyAttrs);
            String dlAttrsFiller = CL.genAttrs(dlAttrs);
            String domainAttrsFiller = CL.genAttrs(domainAttrs);
            HashMap<String, String> templateFillers = new HashMap<String, String>();
            templateFillers.put("ACCOUNT_AND_CALENDAR_RESOURCE_ATTRS", acctAndCrAttrsFiller);
            templateFillers.put("CALENDAR_RESOURCE_ATTRS", crOnlyAttrsFiller);
            templateFillers.put("DISTRIBUTION_LIST_ATTRS", dlAttrsFiller);
            templateFillers.put("DOMAIN_ATTRS", domainAttrsFiller);
            CL.genFile(outFile, templateFile, templateFillers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void genFile(String outFile, String templateFile, Map<String, String> templateFillers) throws Exception {
            byte[] templateBytes = ByteUtil.getContent(new File(templateFile));
            String templateString = new String(templateBytes, "utf-8");
            String content = StringUtil.fillTemplate(templateString, templateFillers);
            File oldFile = new File(outFile);
            if (!oldFile.canWrite()) {
                System.err.println("============================================");
                System.err.println("Unable to write to: " + outFile);
                System.err.println("============================================");
                System.exit(1);
            }
            BufferedWriter out = null;
            File newFile = new File(outFile + "-autogen");
            try {
                out = new BufferedWriter(new FileWriter(newFile));
                out.write(content);
                out.close();
                out = null;
                if (!newFile.renameTo(oldFile)) {
                    System.err.println("============================================");
                    System.err.format("Unable to rename(%s) to (%s)%n", newFile.getName(), oldFile);
                    System.err.println("============================================");
                    System.exit(1);
                }
                System.out.println("======================================");
                System.out.println("generated: " + outFile);
                System.out.println("======================================");
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }

        private static Set<String> getDomainAdminModifiableAttrs(AttributeClass klass) throws ServiceException {
            AttributeManager am = AttributeManager.getInstance();
            Set<String> allAttrs = am.getAllAttrsInClass(klass);
            HashSet<String> domainAdminModifiableAttrs = new HashSet<String>();
            for (String attr : allAttrs) {
                if (!am.isDomainAdminModifiable(attr, klass)) continue;
                domainAdminModifiableAttrs.add(attr);
            }
            return domainAdminModifiableAttrs;
        }

        private static String genAttrs(Set<String> attrs) {
            TreeSet<String> sortedAttrs = new TreeSet<String>(attrs);
            StringBuilder sb = new StringBuilder();
            for (String attr : sortedAttrs) {
                sb.append("    <a n=\"" + attr + "\"/>\n");
            }
            return sb.toString();
        }

        private static void usage(String errmsg) {
            if (errmsg != null) {
                System.out.println(errmsg);
            }
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("AttributeManager [options] where [options] are one of:", sOptions);
            System.exit(errmsg == null ? 0 : 1);
        }

        private static CommandLine parseArgs(String[] args) {
            StringBuffer gotCL = new StringBuffer("cmdline: ");
            for (int i = 0; i < args.length; ++i) {
                gotCL.append("'").append(args[i]).append("' ");
            }
            System.out.println(gotCL);
            GnuParser parser = new GnuParser();
            CommandLine cl = null;
            try {
                cl = parser.parse(sOptions, args);
            }
            catch (ParseException pe) {
                CL.usage(pe.getMessage());
            }
            if (cl.hasOption('h')) {
                CL.usage(null);
            }
            return cl;
        }

        private static void main(String[] args) throws Exception {
            String action;
            CliUtil.toolSetup();
            CommandLine cl = CL.parseArgs(args);
            if (!cl.hasOption('a')) {
                CL.usage("no action specified");
            }
            if (!"validate".equals(action = cl.getOptionValue('a')) && !cl.hasOption('r')) {
                CL.usage("no regenerate file specified");
            }
            String regenFile = cl.getOptionValue('r');
            String inputDir = null;
            RightManager rm = null;
            if (!"genDomainAdminSetAttrsRights".equals(action)) {
                if (!cl.hasOption('i')) {
                    CL.usage("no input dir specified");
                }
                inputDir = cl.getOptionValue('i');
                rm = new RightManager(inputDir);
            }
            if ("genRightConsts".equals(action)) {
                FileGenUtil.replaceJavaFile(regenFile, rm.genRightConsts());
            } else if ("genAdminRights".equals(action)) {
                FileGenUtil.replaceJavaFile(regenFile, rm.genAdminRights());
            } else if ("genUserRights".equals(action)) {
                FileGenUtil.replaceJavaFile(regenFile, rm.genUserRights());
            } else if ("genDomainAdminSetAttrsRights".equals(action)) {
                String templateFile = cl.getOptionValue('t');
                CL.genDomainAdminSetAttrsRights(regenFile, templateFile);
            } else if (!"validate".equals(action)) {
                CL.usage("invalid action");
            }
        }

        static {
            sOptions.addOption("h", "help", false, "display this  usage info");
            sOptions.addOption(RightManager.E_A, "action", true, "action, one of genRightConsts, genAdminRights, genUserRights");
            sOptions.addOption("i", "input", true, "rights definition xml input directory");
            sOptions.addOption(RightManager.E_R, "regenerateFile", true, "file file to regenerate");
            sOptions.addOption("t", "templateFile", true, "template file");
        }
    }
}

