/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.ACLAccessManager;
import com.zimbra.cs.account.accesscontrol.ACLUtil;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AttrRight;
import com.zimbra.cs.account.accesscontrol.AttributeConstraint;
import com.zimbra.cs.account.accesscontrol.ComboRight;
import com.zimbra.cs.account.accesscontrol.CrossDomain;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.PseudoTarget;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightBearer;
import com.zimbra.cs.account.accesscontrol.RightChecker;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.RightModifier;
import com.zimbra.cs.account.accesscontrol.SearchGrants;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.accesscontrol.ZimbraACE;
import com.zimbra.cs.account.accesscontrol.ZimbraACL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RightCommand {
    public static Right getRight(String rightName) throws ServiceException {
        RightCommand.verifyAccessManager();
        return RightManager.getInstance().getRight(rightName);
    }

    private static void verifyAccessManager() throws ServiceException {
        if (!(AccessManager.getInstance() instanceof ACLAccessManager)) {
            throw ServiceException.FAILURE("method is not supported by the current AccessManager: " + AccessManager.getInstance().getClass().getCanonicalName() + ", check localonfig key " + LC.zimbra_class_accessmanager.key() + ", this method requires " + ACLAccessManager.class.getCanonicalName(), null);
        }
    }

    public static List<Right> getAllRights(String targetType) throws ServiceException {
        RightCommand.verifyAccessManager();
        Map<String, AdminRight> allRights = RightManager.getInstance().getAllAdminRights();
        ArrayList<Right> rights = new ArrayList<Right>();
        TargetType tt = targetType == null ? null : TargetType.fromCode(targetType);
        for (Map.Entry<String, AdminRight> right : allRights.entrySet()) {
            Right r = right.getValue();
            if (tt != null && !r.grantableOnTargetType(tt)) continue;
            rights.add(r);
        }
        return rights;
    }

    public static boolean checkRight(Provisioning prov, String targetType, Provisioning.TargetBy targetBy, String target, Provisioning.GranteeBy granteeBy, String grantee, String right, Map<String, Object> attrs, AccessManager.ViaGrant via) throws ServiceException {
        RightCommand.verifyAccessManager();
        TargetType tt = TargetType.fromCode(targetType);
        Entry targetEntry = TargetType.lookupTarget(prov, tt, targetBy, target);
        GranteeType gt = GranteeType.GT_USER;
        NamedEntry granteeEntry = GranteeType.lookupGrantee(prov, gt, granteeBy, grantee);
        Right r = RightManager.getInstance().getRight(right);
        if (r.getRightType() != Right.RightType.setAttrs && attrs != null && !attrs.isEmpty()) {
            throw ServiceException.INVALID_REQUEST("attr map is not allowed for checking a non-setAttrs right: " + r.getName(), null);
        }
        AccessManager am = AccessManager.getInstance();
        return am.canPerform((Account)granteeEntry, targetEntry, r, false, attrs, true, via);
    }

    public static AllEffectiveRights getAllEffectiveRights(Provisioning prov, String granteeType, Provisioning.GranteeBy granteeBy, String grantee, boolean expandSetAttrs, boolean expandGetAttrs) throws ServiceException {
        RightCommand.verifyAccessManager();
        GranteeType gt = GranteeType.fromCode(granteeType);
        NamedEntry granteeEntry = GranteeType.lookupGrantee(prov, gt, granteeBy, grantee);
        RightBearer rightBearer = RightBearer.newRightBearer(granteeEntry);
        AllEffectiveRights aer = new AllEffectiveRights(gt.getCode(), granteeEntry.getId(), granteeEntry.getName());
        RightChecker.getAllEffectiveRights(rightBearer, expandSetAttrs, expandGetAttrs, aer);
        return aer;
    }

    public static EffectiveRights getEffectiveRights(Provisioning prov, String targetType, Provisioning.TargetBy targetBy, String target, Provisioning.GranteeBy granteeBy, String grantee, boolean expandSetAttrs, boolean expandGetAttrs) throws ServiceException {
        RightCommand.verifyAccessManager();
        TargetType tt = TargetType.fromCode(targetType);
        Entry targetEntry = TargetType.lookupTarget(prov, tt, targetBy, target);
        GranteeType gt = GranteeType.GT_USER;
        NamedEntry granteeEntry = GranteeType.lookupGrantee(prov, gt, granteeBy, grantee);
        Account granteeAcct = (Account)granteeEntry;
        RightBearer rightBearer = RightBearer.newRightBearer(granteeEntry);
        EffectiveRights er = new EffectiveRights(targetType, TargetType.getId(targetEntry), targetEntry.getLabel(), granteeAcct.getId(), granteeAcct.getName());
        RightChecker.getEffectiveRights(rightBearer, targetEntry, expandSetAttrs, expandGetAttrs, er);
        return er;
    }

    public static EffectiveRights getCreateObjectAttrs(Provisioning prov, String targetType, Provisioning.DomainBy domainBy, String domainStr, Provisioning.CosBy cosBy, String cosStr, Provisioning.GranteeBy granteeBy, String grantee) throws ServiceException {
        RightCommand.verifyAccessManager();
        TargetType tt = TargetType.fromCode(targetType);
        Entry targetEntry = PseudoTarget.createPseudoTarget(prov, tt, domainBy, domainStr, false, cosBy, cosStr);
        GranteeType gt = GranteeType.GT_USER;
        NamedEntry granteeEntry = GranteeType.lookupGrantee(prov, gt, granteeBy, grantee);
        Account granteeAcct = (Account)granteeEntry;
        RightBearer rightBearer = RightBearer.newRightBearer(granteeEntry);
        EffectiveRights er = new EffectiveRights(targetType, TargetType.getId(targetEntry), targetEntry.getLabel(), granteeAcct.getId(), granteeAcct.getName());
        RightChecker.getEffectiveRights(rightBearer, targetEntry, true, true, er);
        return er;
    }

    public static Grants getGrants(Provisioning prov, String targetType, Provisioning.TargetBy targetBy, String target, String granteeType, Provisioning.GranteeBy granteeBy, String grantee, boolean granteeIncludeGroupsGranteeBelongs) throws ServiceException {
        RightCommand.verifyAccessManager();
        if (targetType == null && granteeType == null) {
            throw ServiceException.INVALID_REQUEST("at least one of target or grantee must be specified", null);
        }
        TargetType tt = null;
        Entry targetEntry = null;
        if (targetType != null) {
            tt = TargetType.fromCode(targetType);
            targetEntry = TargetType.lookupTarget(prov, tt, targetBy, target);
        }
        GranteeType gt = null;
        NamedEntry granteeEntry = null;
        Set<String> granteeFilter = null;
        if (granteeType != null) {
            gt = GranteeType.fromCode(granteeType);
            granteeEntry = GranteeType.lookupGrantee(prov, gt, granteeBy, grantee);
            RightBearer.Grantee theGrantee = new RightBearer.Grantee(granteeEntry);
            if (granteeIncludeGroupsGranteeBelongs) {
                granteeFilter = theGrantee.getIdAndGroupIds();
            } else {
                granteeFilter = new HashSet<String>();
                granteeFilter.add(granteeEntry.getId());
            }
        }
        Grants grants = new Grants();
        if (targetEntry != null) {
            ZimbraACL zimbraAcl = ACLUtil.getACL(targetEntry);
            grants.addGrants(tt, targetEntry, zimbraAcl, granteeFilter);
        } else {
            HashSet<TargetType> targetTypesToSearch = new HashSet<TargetType>(Arrays.asList(TargetType.values()));
            SearchGrants searchGrants = new SearchGrants(prov, targetTypesToSearch, granteeFilter);
            Set<SearchGrants.GrantsOnTarget> grantsOnTargets = searchGrants.doSearch().getResults();
            for (SearchGrants.GrantsOnTarget grantsOnTarget : grantsOnTargets) {
                Entry grantedOnEntry = grantsOnTarget.getTargetEntry();
                ZimbraACL acl = grantsOnTarget.getAcl();
                TargetType grantedOnTargetType = TargetType.getTargetType(grantedOnEntry);
                grants.addGrants(grantedOnTargetType, grantedOnEntry, acl, granteeFilter);
            }
        }
        return grants;
    }

    private static void verifyGrant(Account authedAcct, TargetType targetType, Entry targetEntry, GranteeType granteeType, NamedEntry granteeEntry, Right right, boolean revoking) throws ServiceException {
        if (!right.isUserRight()) {
            boolean isCDARight;
            RightCommand.verifyAccessManager();
            if (!(revoking || (isCDARight = CrossDomain.validateCrossDomainAdminGrant(right, granteeType)) || RightChecker.isValidGranteeForAdminRights(granteeType, granteeEntry))) {
                throw ServiceException.INVALID_REQUEST("grantee must be a delegated admin account or admin group, it cannot be a global admin account.", null);
            }
        }
        if (!right.grantableOnTargetType(targetType)) {
            throw ServiceException.INVALID_REQUEST("right " + right.getName() + " cannot be granted on a " + targetType.getCode() + " entry. " + "It can only be granted on target types: " + right.reportGrantableTargetTypes(), null);
        }
        if (authedAcct != null) {
            AccessManager am = AccessManager.getInstance();
            boolean canGrant = am.canPerform(authedAcct, targetEntry, right, true, null, true, null);
            if (!canGrant) {
                throw ServiceException.PERM_DENIED("insuffcient right to " + (revoking ? "revoke" : "grant"));
            }
            RightChecker.checkPartiallyDenied(authedAcct, targetType, targetEntry, right);
        }
    }

    public static void grantRight(Provisioning prov, Account authedAcct, String targetType, Provisioning.TargetBy targetBy, String target, String granteeType, Provisioning.GranteeBy granteeBy, String grantee, String right, RightModifier rightModifier) throws ServiceException {
        RightCommand.verifyAccessManager();
        TargetType tt = TargetType.fromCode(targetType);
        Entry targetEntry = TargetType.lookupTarget(prov, tt, targetBy, target);
        GranteeType gt = GranteeType.fromCode(granteeType);
        NamedEntry granteeEntry = GranteeType.lookupGrantee(prov, gt, granteeBy, grantee);
        Right r = RightManager.getInstance().getRight(right);
        RightCommand.verifyGrant(authedAcct, tt, targetEntry, gt, granteeEntry, r, false);
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        ZimbraACE ace = new ZimbraACE(granteeEntry.getId(), gt, r, rightModifier, null);
        aces.add(ace);
        ACLUtil.grantRight(prov, targetEntry, aces);
    }

    public static void revokeRight(Provisioning prov, Account authedAcct, String targetType, Provisioning.TargetBy targetBy, String target, String granteeType, Provisioning.GranteeBy granteeBy, String grantee, String right, RightModifier rightModifier) throws ServiceException {
        RightCommand.verifyAccessManager();
        TargetType tt = TargetType.fromCode(targetType);
        Entry targetEntry = TargetType.lookupTarget(prov, tt, targetBy, target);
        GranteeType gt = GranteeType.fromCode(granteeType);
        NamedEntry granteeEntry = null;
        String granteeId = null;
        try {
            granteeEntry = GranteeType.lookupGrantee(prov, gt, granteeBy, grantee);
            granteeId = granteeEntry.getId();
        }
        catch (AccountServiceException e) {
            String code = e.getCode();
            if ("account.NO_SUCH_ACCOUNT".equals(code) || "account.NO_SUCH_DISTRIBUTION_LIST".equals(code) || "account.NO_SUCH_DOMAIN".equals(code)) {
                ZimbraLog.acl.warn("revokeRight: no such grantee " + grantee);
                if (granteeBy == Provisioning.GranteeBy.id) {
                    granteeId = grantee;
                }
                throw ServiceException.INVALID_REQUEST("cannot find grantee by name: " + grantee + ", try revoke by grantee id if you want to remove the orphan grant", e);
            }
            throw e;
        }
        Right r = RightManager.getInstance().getRight(right);
        if (granteeEntry != null) {
            RightCommand.verifyGrant(authedAcct, tt, targetEntry, gt, granteeEntry, r, true);
        }
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        ZimbraACE ace = new ZimbraACE(granteeId, gt, r, rightModifier, null);
        aces.add(ace);
        List<ZimbraACE> revoked = ACLUtil.revokeRight(prov, targetEntry, aces);
        if (revoked.isEmpty()) {
            throw AccountServiceException.NO_SUCH_GRANT(ace.dump());
        }
    }

    public static void revokeAllRights(Provisioning prov, GranteeType granteeType, String granteeId) throws ServiceException {
        RightCommand.verifyAccessManager();
        HashSet<TargetType> targetTypesToSearch = new HashSet<TargetType>(Arrays.asList(TargetType.values()));
        HashSet<String> granteeIdsToSearch = new HashSet<String>();
        granteeIdsToSearch.add(granteeId);
        SearchGrants searchGrants = new SearchGrants(prov, targetTypesToSearch, granteeIdsToSearch);
        Set<SearchGrants.GrantsOnTarget> grantsOnTargets = searchGrants.doSearch().getResults();
        for (SearchGrants.GrantsOnTarget grantsOnTarget : grantsOnTargets) {
            Entry targetEntry = grantsOnTarget.getTargetEntry();
            HashSet<ZimbraACE> acesToRevoke = new HashSet<ZimbraACE>();
            for (ZimbraACE ace : grantsOnTarget.getAcl().getAllACEs()) {
                if (!granteeId.equals(ace.getGrantee())) continue;
                acesToRevoke.add(ace);
            }
            List<ZimbraACE> revoked = ACLUtil.revokeRight(prov, targetEntry, acesToRevoke);
        }
    }

    public static Element rightToXML(Element parent, Right right, boolean expandAllAtrts) throws ServiceException {
        Element eRight;
        block4: {
            block5: {
                AttrRight attrRight;
                Element eAttrs;
                block6: {
                    eRight = parent.addElement("right");
                    eRight.addAttribute("name", right.getName());
                    eRight.addAttribute("type", right.getRightType().name());
                    eRight.addAttribute("targetType", right.getTargetTypeStr());
                    eRight.addElement("desc").setText(right.getDesc());
                    if (right.isPresetRight()) break block4;
                    if (!right.isAttrRight()) break block5;
                    eAttrs = eRight.addElement("attrs");
                    attrRight = (AttrRight)right;
                    if (!attrRight.allAttrs()) break block6;
                    eAttrs.addAttribute("all", true);
                    if (!expandAllAtrts) break block4;
                    Set<String> attrs = attrRight.getAllAttrs();
                    for (String attr : attrs) {
                        eAttrs.addElement("a").addAttribute("n", attr);
                    }
                    break block4;
                }
                for (String attrName : attrRight.getAttrs()) {
                    eAttrs.addElement(attrName);
                }
                break block4;
            }
            if (right.isComboRight()) {
                Element eRights = eRight.addElement("rights");
                ComboRight comboRight = (ComboRight)right;
                for (Right r : comboRight.getRights()) {
                    eRights.addElement("r").addAttribute("n", r.getName());
                }
            }
        }
        return eRight;
    }

    public static Right XMLToRight(Element eRight) throws ServiceException {
        String rightName = eRight.getAttribute("name");
        return RightManager.getInstance().getRight(rightName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllEffectiveRights {
        String mGranteeType;
        String mGranteeId;
        String mGranteeName;
        Map<TargetType, RightsByTargetType> mRightsByTargetType = new HashMap<TargetType, RightsByTargetType>();

        AllEffectiveRights(String granteeType, String granteeId, String granteeName) {
            this.mGranteeType = granteeType;
            this.mGranteeId = granteeId;
            this.mGranteeName = granteeName;
            for (TargetType tt : TargetType.values()) {
                if (tt.isDomained()) {
                    this.mRightsByTargetType.put(tt, new DomainedRightsByTargetType());
                    continue;
                }
                this.mRightsByTargetType.put(tt, new RightsByTargetType());
            }
        }

        public String granteeType() {
            return this.mGranteeType;
        }

        public String granteeId() {
            return this.mGranteeId;
        }

        public String granteeName() {
            return this.mGranteeName;
        }

        public Map<TargetType, RightsByTargetType> rightsByTargetType() {
            return this.mRightsByTargetType;
        }

        void setAll(TargetType targetType, EffectiveRights er) {
            if (er.hasNoRight()) {
                return;
            }
            this.mRightsByTargetType.get((Object)targetType).setAll(er);
        }

        void addEntry(TargetType targetType, String name, EffectiveRights er) {
            if (er.hasNoRight()) {
                return;
            }
            this.mRightsByTargetType.get((Object)targetType).addEntry(name, er);
        }

        void addAggregation(TargetType targetType, Set<String> names, EffectiveRights er) {
            if (er.hasNoRight()) {
                return;
            }
            this.mRightsByTargetType.get((Object)targetType).addAggregation(names, er);
        }

        void addDomainEntry(TargetType targetType, String domainName, EffectiveRights er) {
            if (er.hasNoRight()) {
                return;
            }
            DomainedRightsByTargetType drbtt = (DomainedRightsByTargetType)this.mRightsByTargetType.get((Object)targetType);
            drbtt.addDomainEntry(domainName, er);
        }

        public static AllEffectiveRights fromXML(Element parent) throws ServiceException {
            Element eGrantee = parent.getElement("grantee");
            String granteeType = eGrantee.getAttribute("type");
            String granteeId = eGrantee.getAttribute("id");
            String granteeName = eGrantee.getAttribute("name");
            AllEffectiveRights aer = new AllEffectiveRights(granteeType, granteeId, granteeName);
            for (Element eTarget : parent.listElements("target")) {
                TargetType targetType = TargetType.fromCode(eTarget.getAttribute("type"));
                RightsByTargetType rbtt = aer.mRightsByTargetType.get((Object)targetType);
                Element eAll = eTarget.getOptionalElement("all");
                if (eAll != null) {
                    rbtt.mAll = EffectiveRights.fromXML(null, eAll);
                }
                if (rbtt instanceof DomainedRightsByTargetType) {
                    DomainedRightsByTargetType drbtt = (DomainedRightsByTargetType)rbtt;
                    for (Element eInDomains : eTarget.listElements("inDomains")) {
                        HashSet<String> domains = new HashSet<String>();
                        for (Element eDomain : eInDomains.listElements("domain")) {
                            String domain = eDomain.getAttribute("name");
                            domains.add(domain);
                        }
                        Element eRights = eInDomains.getElement("rights");
                        EffectiveRights er = EffectiveRights.fromXML(null, eRights);
                        RightAggregation ra = new RightAggregation(domains, er);
                        drbtt.mDomains.add(ra);
                    }
                }
                for (Element eEntries : eTarget.listElements("entries")) {
                    HashSet<String> entries = new HashSet<String>();
                    for (Element eEntry : eEntries.listElements("entry")) {
                        String entry = eEntry.getAttribute("name");
                        entries.add(entry);
                    }
                    Element eRights = eEntries.getElement("rights");
                    EffectiveRights er = EffectiveRights.fromXML(null, eRights);
                    RightAggregation ra = new RightAggregation(entries, er);
                    rbtt.mEntries.add(ra);
                }
            }
            return aer;
        }

        public void toXML(Element parent) {
            Element eGrantee = parent.addElement("grantee");
            eGrantee.addAttribute("type", this.mGranteeType);
            eGrantee.addAttribute("id", this.mGranteeId);
            eGrantee.addAttribute("name", this.mGranteeName);
            for (Map.Entry<TargetType, RightsByTargetType> rightsByTargetType : this.mRightsByTargetType.entrySet()) {
                TargetType targetType = rightsByTargetType.getKey();
                RightsByTargetType rbtt = rightsByTargetType.getValue();
                Element eTarget = parent.addElement("target");
                eTarget.addAttribute("type", targetType.getCode());
                EffectiveRights er = rbtt.all();
                if (er != null) {
                    Element eAll = eTarget.addElement("all");
                    er.toXML(eAll);
                }
                if (rbtt instanceof DomainedRightsByTargetType) {
                    DomainedRightsByTargetType domainedRights = (DomainedRightsByTargetType)rbtt;
                    for (RightAggregation rightsByDomains : domainedRights.domains()) {
                        Element eInDomains = eTarget.addElement("inDomains");
                        for (String domain : rightsByDomains.entries()) {
                            Element eDomain = eInDomains.addElement("domain");
                            eDomain.addAttribute("name", domain);
                        }
                        Element eRights = eInDomains.addElement("rights");
                        er = rightsByDomains.getRights();
                        er.toXML(eRights);
                    }
                }
                for (RightAggregation rightsByEntries : rbtt.entries()) {
                    Element eEntries = eTarget.addElement("entries");
                    for (String entry : rightsByEntries.entries()) {
                        Element eEntry = eEntries.addElement("entry");
                        eEntry.addAttribute("name", entry);
                    }
                    Element eRights = eEntries.addElement("rights");
                    er = rightsByEntries.getRights();
                    er.toXML(eRights);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DomainedRightsByTargetType
    extends RightsByTargetType {
        Set<RightAggregation> mDomains = new HashSet<RightAggregation>();

        public Set<RightAggregation> domains() {
            return this.mDomains;
        }

        void addDomainEntry(String domainName, EffectiveRights er) {
            DomainedRightsByTargetType.add(this.mDomains, domainName, er);
        }

        @Override
        public boolean hasNoRight() {
            return super.hasNoRight() && this.mDomains.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RightsByTargetType {
        EffectiveRights mAll = null;
        Set<RightAggregation> mEntries = new HashSet<RightAggregation>();

        public EffectiveRights all() {
            return this.mAll;
        }

        public Set<RightAggregation> entries() {
            return this.mEntries;
        }

        void setAll(EffectiveRights er) {
            this.mAll = er;
        }

        protected static void add(Set<RightAggregation> entries, String name, EffectiveRights er) {
            for (RightAggregation ra : entries) {
                if (!ra.hasEntry(name)) continue;
                ra.removeEntry(name);
                break;
            }
            for (RightAggregation ra : entries) {
                if (!ra.hasSameRights(er)) continue;
                ra.addEntry(name);
                return;
            }
            entries.add(new RightAggregation(name, er));
        }

        protected static void addAggregation(Set<RightAggregation> entries, Set<String> names, EffectiveRights er) {
            for (RightAggregation ra : entries) {
                if (!ra.hasSameRights(er)) continue;
                ra.addEntries(names);
                return;
            }
            entries.add(new RightAggregation(names, er));
        }

        private void addEntry(String name, EffectiveRights er) {
            RightsByTargetType.add(this.mEntries, name, er);
        }

        private void addAggregation(Set<String> names, EffectiveRights er) {
            RightsByTargetType.addAggregation(this.mEntries, names, er);
        }

        public boolean hasNoRight() {
            return this.mAll == null && this.mEntries.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RightAggregation {
        Set<String> mEntries = new HashSet<String>();
        EffectiveRights mRights;

        public Set<String> entries() {
            return this.mEntries;
        }

        public EffectiveRights effectiveRights() {
            return this.mRights;
        }

        private RightAggregation(String name, EffectiveRights rights) {
            this.mEntries.add(name);
            this.mRights = rights;
        }

        private RightAggregation(Set<String> names, EffectiveRights rights) {
            this.mEntries.addAll(names);
            this.mRights = rights;
        }

        private EffectiveRights getRights() {
            return this.mRights;
        }

        private void addEntry(String name) {
            this.mEntries.add(name);
        }

        private void addEntries(Set<String> names) {
            this.mEntries.addAll(names);
        }

        private boolean hasEntry(String name) {
            return this.mEntries.contains(name);
        }

        private void removeEntry(String name) {
            this.mEntries.remove(name);
        }

        private boolean hasSameRights(EffectiveRights er) {
            return this.mRights.hasSameRights(er);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EffectiveRights {
        private static final SortedMap<String, EffectiveAttr> EMPTY_MAP = new TreeMap<String, EffectiveAttr>();
        String mTargetType;
        String mTargetId;
        String mTargetName;
        String mGranteeId;
        String mGranteeName;
        String mDigest;
        List<String> mPresetRights = new ArrayList<String>();
        boolean mCanSetAllAttrs = false;
        SortedMap<String, EffectiveAttr> mCanSetAttrs = EMPTY_MAP;
        boolean mCanGetAllAttrs = false;
        SortedMap<String, EffectiveAttr> mCanGetAttrs = EMPTY_MAP;

        EffectiveRights(String targetType, String targetId, String targetName, String granteeId, String granteeName) {
            this.mTargetType = targetType;
            this.mTargetId = targetId == null ? "" : targetId;
            this.mTargetName = targetName;
            this.mGranteeId = granteeId;
            this.mGranteeName = granteeName;
        }

        private EffectiveRights() {
        }

        private boolean hasSameRights(EffectiveRights other) {
            return this.getDigest().equals(other.getDigest());
        }

        private boolean hasNoRight() {
            return this.mPresetRights.isEmpty() && !this.mCanSetAllAttrs && this.mCanSetAttrs.isEmpty() && !this.mCanGetAllAttrs && this.mCanGetAttrs.isEmpty();
        }

        private String getDigest() {
            ArrayList<String> attrs;
            if (this.mDigest != null) {
                return this.mDigest;
            }
            StringBuilder rights = new StringBuilder();
            rights.append("preset:" + ((Object)this.mPresetRights).hashCode() + ";");
            rights.append("setAttrs:");
            if (this.mCanSetAllAttrs) {
                rights.append("all;");
            } else {
                attrs = new ArrayList<String>(this.mCanSetAttrs.keySet());
                rights.append(((Object)attrs).hashCode() + ";");
            }
            rights.append("getAttrs:");
            if (this.mCanGetAllAttrs) {
                rights.append("all;");
            } else {
                attrs = new ArrayList<String>(this.mCanGetAttrs.keySet());
                rights.append(((Object)attrs).hashCode() + ";");
            }
            this.mDigest = rights.toString();
            return this.mDigest;
        }

        public static EffectiveRights fromXML_EffectiveRights(Element parent) throws ServiceException {
            EffectiveRights er = new EffectiveRights();
            Element eGrantee = parent.getElement("grantee");
            er.mGranteeId = eGrantee.getAttribute("id");
            er.mGranteeName = eGrantee.getAttribute("name");
            Element eTarget = parent.getElement("target");
            er.mTargetType = eTarget.getAttribute("type");
            er.mTargetId = eTarget.getAttribute("id");
            er.mTargetName = eTarget.getAttribute("name");
            EffectiveRights.fromXML(er, eTarget);
            return er;
        }

        public static EffectiveRights fromXML_CreateObjectAttrs(Element parent) throws ServiceException {
            EffectiveRights er = new EffectiveRights();
            Element eSetAttrs = parent.getElement("setAttrs");
            if (eSetAttrs.getAttributeBool("all", false)) {
                er.mCanSetAllAttrs = true;
            }
            er.mCanSetAttrs = EffectiveRights.fromXML_attrs(eSetAttrs);
            return er;
        }

        private static EffectiveRights fromXML(EffectiveRights er, Element eParent) throws ServiceException {
            if (er == null) {
                er = new EffectiveRights();
            }
            er.mPresetRights = new ArrayList<String>();
            for (Element eRight : eParent.listElements("right")) {
                er.mPresetRights.add(eRight.getAttribute("n"));
            }
            Element eSetAttrs = eParent.getElement("setAttrs");
            if (eSetAttrs.getAttributeBool("all", false)) {
                er.mCanSetAllAttrs = true;
            }
            er.mCanSetAttrs = EffectiveRights.fromXML_attrs(eSetAttrs);
            Element eGetAttrs = eParent.getElement("getAttrs");
            if (eGetAttrs.getAttributeBool("all", false)) {
                er.mCanGetAllAttrs = true;
            }
            er.mCanGetAttrs = EffectiveRights.fromXML_attrs(eGetAttrs);
            return er;
        }

        private static TreeMap<String, EffectiveAttr> fromXML_attrs(Element eAttrs) throws ServiceException {
            TreeMap<String, EffectiveAttr> attrs = new TreeMap<String, EffectiveAttr>();
            AttributeManager am = AttributeManager.getInstance();
            for (Element eAttr : eAttrs.listElements("a")) {
                String attrName = eAttr.getAttribute("n");
                AttributeConstraint constraint = null;
                Element eConstraint = eAttr.getOptionalElement("constraint");
                if (eConstraint != null) {
                    constraint = AttributeConstraint.fromXML(am, attrName, eConstraint);
                }
                Element eDefault = eAttr.getOptionalElement("default");
                HashSet<String> defaultValues = null;
                if (eDefault != null) {
                    defaultValues = new HashSet<String>();
                    for (Element eValue : eDefault.listElements("v")) {
                        defaultValues.add(eValue.getText());
                    }
                }
                EffectiveAttr ea = new EffectiveAttr(attrName, defaultValues, null);
                attrs.put(attrName, ea);
            }
            return attrs;
        }

        public void toXML_getEffectiveRights(Element parent) {
            Element eGrantee = parent.addElement("grantee");
            eGrantee.addAttribute("id", this.mGranteeId);
            eGrantee.addAttribute("name", this.mGranteeName);
            Element eTarget = parent.addElement("target");
            eTarget.addAttribute("type", this.mTargetType);
            eTarget.addAttribute("id", this.mTargetId);
            eTarget.addAttribute("name", this.mTargetName);
            this.toXML(eTarget);
        }

        public void toXML_getCreateObjectAttrs(Element parent) {
            this.toXML(parent, "setAttrs", this.mCanSetAllAttrs, this.mCanSetAttrs);
        }

        private void toXML(Element eParent) {
            for (String r : this.mPresetRights) {
                Element eRight = eParent.addElement("right").addAttribute("n", r);
            }
            this.toXML(eParent, "setAttrs", this.mCanSetAllAttrs, this.mCanSetAttrs);
            this.toXML(eParent, "getAttrs", this.mCanGetAllAttrs, this.mCanGetAttrs);
        }

        private void toXML(Element parent, String elemName, boolean allAttrs, SortedMap<String, EffectiveAttr> attrs) {
            Element eAttrs = parent.addElement(elemName);
            if (allAttrs) {
                eAttrs.addAttribute("all", true);
            }
            for (EffectiveAttr ea : attrs.values()) {
                Element eAttr = eAttrs.addElement("a");
                eAttr.addAttribute("n", ea.getAttrName());
                AttributeConstraint constraint = ea.getConstraint();
                if (constraint != null) {
                    constraint.toXML(eAttr);
                }
                if (ea.getDefault().isEmpty()) continue;
                Element eDefault = eAttr.addElement("default");
                for (String v : ea.getDefault()) {
                    eDefault.addElement("v").setText(v);
                }
            }
        }

        void setPresetRights(List<String> presetRights) {
            this.mPresetRights = presetRights;
        }

        void setCanSetAllAttrs() {
            this.mCanSetAllAttrs = true;
        }

        void setCanSetAttrs(SortedMap<String, EffectiveAttr> canSetAttrs) {
            this.mCanSetAttrs = canSetAttrs;
        }

        void setCanGetAllAttrs() {
            this.mCanGetAllAttrs = true;
        }

        void setCanGetAttrs(SortedMap<String, EffectiveAttr> canGetAttrs) {
            this.mCanGetAttrs = canGetAttrs;
        }

        public String targetType() {
            return this.mTargetType;
        }

        public String targetId() {
            return this.mTargetId;
        }

        public String targetName() {
            return this.mTargetName;
        }

        public String granteeId() {
            return this.mGranteeId;
        }

        public String granteeName() {
            return this.mGranteeName;
        }

        public List<String> presetRights() {
            return this.mPresetRights;
        }

        public boolean canSetAllAttrs() {
            return this.mCanSetAllAttrs;
        }

        public SortedMap<String, EffectiveAttr> canSetAttrs() {
            return this.mCanSetAttrs;
        }

        public boolean canGetAllAttrs() {
            return this.mCanGetAllAttrs;
        }

        public SortedMap<String, EffectiveAttr> canGetAttrs() {
            return this.mCanGetAttrs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EffectiveAttr {
        private static final Set<String> EMPTY_SET = new HashSet<String>();
        String mAttrName;
        Set<String> mDefault;
        AttributeConstraint mConstraint;

        EffectiveAttr(String attrName, Set<String> defaultValue, AttributeConstraint constraint) {
            this.mAttrName = attrName;
            this.mDefault = defaultValue;
            this.mConstraint = constraint;
        }

        public String getAttrName() {
            return this.mAttrName;
        }

        public Set<String> getDefault() {
            if (this.mDefault == null) {
                return EMPTY_SET;
            }
            return this.mDefault;
        }

        AttributeConstraint getConstraint() {
            return this.mConstraint;
        }
    }

    public static class ACE {
        private String mTargetType;
        private String mTargetId;
        private String mTargetName;
        private String mGranteeType;
        private String mGranteeId;
        private String mGranteeName;
        private String mRight;
        private RightModifier mRightModifier;

        private ACE(String targetType, String targetId, String targetName, String granteeType, String granteeId, String granteeName, String right, RightModifier rightModifier) {
            this.mTargetType = targetType;
            this.mTargetId = targetId;
            this.mTargetName = targetName;
            this.mGranteeType = granteeType;
            this.mGranteeId = granteeId;
            this.mGranteeName = granteeName;
            this.mRight = right;
            this.mRightModifier = rightModifier;
        }

        private ACE(TargetType targetType, Entry target, ZimbraACE ace) {
            this.mTargetType = targetType.getCode();
            this.mTargetId = TargetType.getId(target);
            this.mTargetName = target.getLabel();
            this.mGranteeType = ace.getGranteeType().getCode();
            this.mGranteeId = ace.getGrantee();
            this.mGranteeName = ace.getGranteeDisplayName();
            this.mRight = ace.getRight().getName();
            this.mRightModifier = ace.getRightModifier();
        }

        public String targetType() {
            return this.mTargetType;
        }

        public String targetId() {
            return this.mTargetId != null ? this.mTargetId : "";
        }

        public String targetName() {
            return this.mTargetName;
        }

        public String granteeType() {
            return this.mGranteeType;
        }

        public String granteeId() {
            return this.mGranteeId;
        }

        public String granteeName() {
            return this.mGranteeName;
        }

        public String right() {
            return this.mRight;
        }

        public RightModifier rightModifier() {
            return this.mRightModifier;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Grants {
        Set<ACE> mACEs = new HashSet<ACE>();

        Grants() {
        }

        void addACE(ACE ace) {
            this.mACEs.add(ace);
        }

        public Set<ACE> getACEs() {
            return this.mACEs;
        }

        public Grants(Element parent) throws ServiceException {
            for (Element eGrant : parent.listElements("grant")) {
                Element eTarget = eGrant.getElement("target");
                String targetType = eTarget.getAttribute("type", "");
                String targetId = eTarget.getAttribute("id", "");
                String targetName = eTarget.getAttribute("name", "");
                Element eGrantee = eGrant.getElement("grantee");
                String granteeType = eGrantee.getAttribute("type", "");
                String granteeId = eGrantee.getAttribute("id", "");
                String granteeName = eGrantee.getAttribute("name", "");
                Element eRight = eGrant.getElement("right");
                String right = eRight.getText();
                boolean deny = eRight.getAttributeBool("deny", false);
                boolean canDelegate = eRight.getAttributeBool("canDelegate", false);
                RightModifier rightModifier = null;
                if (deny) {
                    rightModifier = RightModifier.RM_DENY;
                } else if (canDelegate) {
                    rightModifier = RightModifier.RM_CAN_DELEGATE;
                }
                ACE ace = new ACE(targetType, targetId, targetName, granteeType, granteeId, granteeName, right, rightModifier);
                this.addACE(ace);
            }
        }

        private void addGrants(TargetType targetType, Entry target, ZimbraACL acl, Set<String> granteeFilter) {
            if (acl == null) {
                return;
            }
            for (ZimbraACE ace : acl.getAllACEs()) {
                if (granteeFilter != null && !granteeFilter.contains(ace.getGrantee())) continue;
                this.addACE(new ACE(targetType, target, ace));
            }
        }

        public void toXML(Element parent) {
            for (ACE ace : this.mACEs) {
                Element eGrant = parent.addElement("grant");
                RightModifier rightModifier = ace.rightModifier();
                boolean deny = rightModifier == RightModifier.RM_DENY;
                boolean canDelegate = rightModifier == RightModifier.RM_CAN_DELEGATE;
                Element eTarget = eGrant.addElement("target");
                eTarget.addAttribute("type", ace.targetType());
                eTarget.addAttribute("id", ace.targetId());
                eTarget.addAttribute("name", ace.targetName());
                Element eGrantee = eGrant.addElement("grantee");
                eGrantee.addAttribute("type", ace.granteeType());
                eGrantee.addAttribute("id", ace.granteeId());
                eGrantee.addAttribute("name", ace.granteeName());
                Element eRight = eGrant.addElement("right");
                eRight.addAttribute("deny", deny);
                eRight.addAttribute("canDelegate", canDelegate);
                eRight.setText(ace.right());
            }
        }
    }
}

