/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.SetUtil;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.GlobalGrant;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.ACLUtil;
import com.zimbra.cs.account.accesscontrol.AccessControlUtil;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AllowedAttrs;
import com.zimbra.cs.account.accesscontrol.AttrRight;
import com.zimbra.cs.account.accesscontrol.AttributeConstraint;
import com.zimbra.cs.account.accesscontrol.ComboRight;
import com.zimbra.cs.account.accesscontrol.CrossDomain;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.PseudoTarget;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightBearer;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.SearchGrants;
import com.zimbra.cs.account.accesscontrol.TargetIterator;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.accesscontrol.ViaGrantImpl;
import com.zimbra.cs.account.accesscontrol.ZimbraACE;
import com.zimbra.cs.account.accesscontrol.ZimbraACL;
import com.zimbra.cs.account.ldap.LdapFilter;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.service.account.ToXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.naming.directory.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RightChecker {
    private static final Log sLog = LogFactory.getLog(RightChecker.class);

    private static boolean crossDomainOK(Provisioning prov, Account grantee, Domain granteeDomain, Domain targetDomain, DistributionList grantedOn) throws ServiceException {
        if (!CrossDomain.checkCrossDomain(prov, granteeDomain, targetDomain, grantedOn)) {
            sLog.info("No cross domain right for " + grantee.getName() + " on domain " + targetDomain.getName() + ", skipping positive grants on dl " + grantedOn.getName());
            return false;
        }
        return true;
    }

    static Boolean checkPresetRight(Account grantee, Entry target, Right rightNeeded, boolean canDelegateNeeded, AccessManager.ViaGrant via) throws ServiceException {
        Entry grantedOn;
        List<ZimbraACE> acl;
        if (!rightNeeded.isPresetRight()) {
            throw ServiceException.INVALID_REQUEST("RightChecker.canDo can only check preset right, right " + rightNeeded.getName() + " is a " + (Object)((Object)rightNeeded.getRightType()) + " right", null);
        }
        boolean adminRight = !rightNeeded.isUserRight();
        Provisioning prov = Provisioning.getInstance();
        Domain granteeDomain = null;
        if (adminRight) {
            if (!RightChecker.isValidGranteeForAdminRights(GranteeType.GT_USER, grantee)) {
                return null;
            }
            granteeDomain = prov.getDomain(grantee);
            if (granteeDomain == null) {
                throw ServiceException.FAILURE("internal error, cannot find domain for " + grantee.getName(), null);
            }
            if (rightNeeded == Rights.Admin.R_crossDomainAdmin) {
                return CrossDomain.checkCrossDomainAdminRight(prov, granteeDomain, target, canDelegateNeeded);
            }
        }
        Boolean result = null;
        SeenRight seenRight = new SeenRight();
        Provisioning.AclGroups granteeGroups = prov.getAclGroups(grantee, adminRight);
        TargetType targetType = TargetType.getTargetType(target);
        if (target instanceof DistributionList) {
            target = prov.getAclGroup(Provisioning.DistributionListBy.id, ((DistributionList)target).getId());
        }
        if ((acl = ACLUtil.getAllACEs(target)) != null && (result = RightChecker.checkTargetPresetRight(acl, targetType, grantee, granteeGroups, rightNeeded, canDelegateNeeded, via, seenRight)) != null) {
            return result;
        }
        Domain targetDomain = TargetType.getTargetDomain(prov, target);
        TargetIterator iter = TargetIterator.getTargetIeterator(Provisioning.getInstance(), target);
        GroupACLs groupACLs = null;
        while ((grantedOn = iter.next()) != null) {
            acl = ACLUtil.getAllACEs(grantedOn);
            if (grantedOn instanceof DistributionList) {
                if (acl == null) continue;
                boolean skipPositiveGrants = false;
                if (adminRight) {
                    boolean bl = skipPositiveGrants = !RightChecker.crossDomainOK(prov, grantee, granteeDomain, targetDomain, (DistributionList)grantedOn);
                }
                if (groupACLs == null) {
                    groupACLs = new GroupACLs();
                }
                groupACLs.collectACL(grantedOn, skipPositiveGrants);
                continue;
            }
            if (groupACLs != null) {
                List<ZimbraACE> aclsOnGroupTargets = groupACLs.getAllACLs();
                if (aclsOnGroupTargets != null) {
                    result = RightChecker.checkTargetPresetRight(aclsOnGroupTargets, targetType, grantee, granteeGroups, rightNeeded, canDelegateNeeded, via, seenRight);
                }
                if (result != null) {
                    return result;
                }
                groupACLs = null;
            }
            if (acl == null || (result = RightChecker.checkTargetPresetRight(acl, targetType, grantee, granteeGroups, rightNeeded, canDelegateNeeded, via, seenRight)) == null) continue;
            return result;
        }
        if (seenRight.seenRight()) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static Boolean checkTargetPresetRight(List<ZimbraACE> acl, TargetType targetType, Account grantee, Provisioning.AclGroups granteeGroups, Right rightNeeded, boolean canDelegateNeeded, AccessManager.ViaGrant via, SeenRight seenRight) throws ServiceException {
        Boolean result = null;
        int adminFlag = rightNeeded.isUserRight() ? 0 : 1;
        result = RightChecker.checkPresetRight(acl, targetType, grantee, rightNeeded, canDelegateNeeded, (short)(2 | adminFlag), via, seenRight);
        if (result != null) {
            return result;
        }
        result = RightChecker.checkGroupPresetRight(acl, targetType, granteeGroups, grantee, rightNeeded, canDelegateNeeded, (short)4, via, seenRight);
        if (result != null) {
            return result;
        }
        if (rightNeeded.isUserRight()) {
            result = RightChecker.checkPresetRight(acl, targetType, grantee, rightNeeded, canDelegateNeeded, (short)8, via, seenRight);
            if (result != null) {
                return result;
            }
            result = RightChecker.checkPresetRight(acl, targetType, grantee, rightNeeded, canDelegateNeeded, (short)16, via, seenRight);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    static boolean rightApplicableOnTargetType(TargetType targetType, Right rightNeeded, boolean canDelegateNeeded) {
        return !(canDelegateNeeded ? !rightNeeded.grantableOnTargetType(targetType) : !rightNeeded.executableOnTargetType(targetType));
    }

    private static boolean matchesPresetRight(ZimbraACE ace, TargetType targetType, Right rightNeeded, boolean canDelegateNeeded, short granteeFlags) throws ServiceException {
        GranteeType granteeType = ace.getGranteeType();
        if (!granteeType.hasFlags(granteeFlags)) {
            return false;
        }
        if (!RightChecker.rightApplicableOnTargetType(targetType, rightNeeded, canDelegateNeeded)) {
            return false;
        }
        if (canDelegateNeeded && ace.canExecuteOnly()) {
            return false;
        }
        Right rightGranted = ace.getRight();
        return rightGranted.isPresetRight() && rightGranted == rightNeeded || rightGranted.isComboRight() && ((ComboRight)rightGranted).containsPresetRight(rightNeeded);
    }

    private static Boolean checkPresetRight(List<ZimbraACE> acl, TargetType targetType, Account grantee, Right rightNeeded, boolean canDelegateNeeded, short granteeFlags, AccessManager.ViaGrant via, SeenRight seenRight) throws ServiceException {
        Boolean result = null;
        for (ZimbraACE ace : acl) {
            if (!RightChecker.matchesPresetRight(ace, targetType, rightNeeded, canDelegateNeeded, granteeFlags)) continue;
            seenRight.setSeenRight();
            if (!ace.matchesGrantee(grantee)) continue;
            return RightChecker.gotResult(ace, grantee, rightNeeded, canDelegateNeeded, via);
        }
        return result;
    }

    private static Boolean checkGroupPresetRight(List<ZimbraACE> acl, TargetType targetType, Provisioning.AclGroups granteeGroups, Account grantee, Right rightNeeded, boolean canDelegateNeeded, short granteeFlags, AccessManager.ViaGrant via, SeenRight seenRight) throws ServiceException {
        Boolean result = null;
        for (ZimbraACE ace : acl) {
            if (!RightChecker.matchesPresetRight(ace, targetType, rightNeeded, canDelegateNeeded, granteeFlags)) continue;
            seenRight.setSeenRight();
            if (!granteeGroups.groupIds().contains(ace.getGrantee())) continue;
            return RightChecker.gotResult(ace, grantee, rightNeeded, canDelegateNeeded, via);
        }
        return result;
    }

    private static Boolean gotResult(ZimbraACE ace, Account grantee, Right right, boolean canDelegateNeeded, AccessManager.ViaGrant via) throws ServiceException {
        if (ace.deny()) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("Right [" + right.getName() + "]" + " DENIED to " + grantee.getName() + " via grant: " + ace.dump() + " on: " + ace.getTargetType().getCode() + ace.getTargetName());
            }
            if (via != null) {
                via.setImpl(new ViaGrantImpl(ace.getTargetType(), ace.getTargetName(), ace.getGranteeType(), ace.getGranteeDisplayName(), ace.getRight(), ace.deny()));
            }
            return Boolean.FALSE;
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("Right [" + right.getName() + "]" + " ALLOWED to " + grantee.getName() + " via grant: " + ace.dump() + " on: " + ace.getTargetType().getCode() + ace.getTargetName());
        }
        if (via != null) {
            via.setImpl(new ViaGrantImpl(ace.getTargetType(), ace.getTargetName(), ace.getGranteeType(), ace.getGranteeDisplayName(), ace.getRight(), ace.deny()));
        }
        return Boolean.TRUE;
    }

    public static AllowedAttrs accessibleAttrs(RightBearer.Grantee grantee, Entry target, AttrRight rightNeeded, boolean canDelegateNeeded) throws ServiceException {
        AllowedAttrs result;
        if (grantee == null) {
            return AllowedAttrs.DENY_ALL_ATTRS();
        }
        Provisioning prov = Provisioning.getInstance();
        Set<String> granteeIds = grantee.getIdAndGroupIds();
        TargetType targetType = TargetType.getTargetType(target);
        HashMap<String, Integer> allowSome = new HashMap<String, Integer>();
        HashMap<String, Integer> denySome = new HashMap<String, Integer>();
        Integer relativity = 1;
        int granteeRanksPerTarget = 2;
        CollectAttrsResult car = CollectAttrsResult.SOME;
        List<ZimbraACE> acl = ACLUtil.getAllACEs(target);
        if (acl != null) {
            car = RightChecker.checkTargetAttrsRight(acl, targetType, granteeIds, rightNeeded, canDelegateNeeded, relativity, allowSome, denySome);
            relativity = relativity + granteeRanksPerTarget;
        }
        Domain targetDomain = TargetType.getTargetDomain(prov, target);
        if (!car.isAll()) {
            Entry grantedOn;
            TargetIterator iter = TargetIterator.getTargetIeterator(prov, target);
            GroupACLs groupACLs = null;
            while ((grantedOn = iter.next()) != null && !car.isAll()) {
                acl = ACLUtil.getAllACEs(grantedOn);
                if (grantedOn instanceof DistributionList) {
                    if (acl == null) continue;
                    boolean skipPositiveGrants = false;
                    if (grantee.isAccount()) {
                        boolean bl = skipPositiveGrants = !RightChecker.crossDomainOK(prov, grantee.getAccount(), grantee.getDomain(), targetDomain, (DistributionList)grantedOn);
                    }
                    if (groupACLs == null) {
                        groupACLs = new GroupACLs();
                    }
                    groupACLs.collectACL(grantedOn, skipPositiveGrants);
                    continue;
                }
                if (groupACLs != null) {
                    List<ZimbraACE> aclsOnGroupTargets = groupACLs.getAllACLs();
                    if (aclsOnGroupTargets != null) {
                        car = RightChecker.checkTargetAttrsRight(aclsOnGroupTargets, targetType, granteeIds, rightNeeded, canDelegateNeeded, relativity, allowSome, denySome);
                        relativity = relativity + granteeRanksPerTarget;
                        if (car.isAll()) break;
                    }
                    groupACLs = null;
                }
                if (acl == null) continue;
                car = RightChecker.checkTargetAttrsRight(acl, targetType, granteeIds, rightNeeded, canDelegateNeeded, relativity, allowSome, denySome);
                relativity = relativity + granteeRanksPerTarget;
            }
        }
        if (sLog.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Allowed: {");
            for (Map.Entry as : allowSome.entrySet()) {
                sb.append("(" + (String)as.getKey() + ", " + as.getValue() + ")");
            }
            sb.append("}");
            sb.append(" Denied: {");
            for (Map.Entry ds : denySome.entrySet()) {
                sb.append("(" + (String)ds.getKey() + ", " + ds.getValue() + ")");
            }
            sb.append("}");
            sLog.debug("accessibleAttrs: " + car.name() + ". " + sb.toString());
        }
        AttributeClass klass = TargetType.getAttributeClass(target);
        if (car == CollectAttrsResult.ALLOW_ALL) {
            result = RightChecker.processAllowAll(allowSome, denySome, klass);
        } else if (car == CollectAttrsResult.DENY_ALL) {
            result = RightChecker.processDenyAll(allowSome, denySome, klass);
        } else {
            Set<String> conflicts = SetUtil.intersect(allowSome.keySet(), denySome.keySet());
            if (!conflicts.isEmpty()) {
                for (String attr : conflicts) {
                    if ((Integer)denySome.get(attr) > (Integer)allowSome.get(attr)) continue;
                    allowSome.remove(attr);
                }
            }
            result = AllowedAttrs.ALLOW_SOME_ATTRS(allowSome.keySet());
        }
        return result;
    }

    private static AllowedAttrs processDenyAll(Map<String, Integer> allowSome, Map<String, Integer> denySome, AttributeClass klass) throws ServiceException {
        if (allowSome.isEmpty()) {
            return AllowedAttrs.DENY_ALL_ATTRS();
        }
        Set<String> allowed = allowSome.keySet();
        return AllowedAttrs.ALLOW_SOME_ATTRS(allowed);
    }

    private static AllowedAttrs processAllowAll(Map<String, Integer> allowSome, Map<String, Integer> denySome, AttributeClass klass) throws ServiceException {
        if (denySome.isEmpty()) {
            return AllowedAttrs.ALLOW_ALL_ATTRS();
        }
        HashSet<String> allowed = new HashSet<String>();
        allowed.addAll(AttributeManager.getInstance().getAllAttrsInClass(klass));
        for (String d : denySome.keySet()) {
            allowed.remove(d);
        }
        return AllowedAttrs.ALLOW_SOME_ATTRS(allowed);
    }

    private static CollectAttrsResult checkTargetAttrsRight(List<ZimbraACE> acl, TargetType targetType, Set<String> granteeIds, AttrRight rightNeeded, boolean canDelegateNeeded, Integer relativity, Map<String, Integer> allowSome, Map<String, Integer> denySome) throws ServiceException {
        CollectAttrsResult result = null;
        short granteeFlags = 3;
        result = RightChecker.expandACLToAttrs(acl, targetType, granteeIds, rightNeeded, canDelegateNeeded, granteeFlags, relativity, allowSome, denySome);
        if (result.isAll()) {
            return result;
        }
        granteeFlags = 4;
        result = RightChecker.expandACLToAttrs(acl, targetType, granteeIds, rightNeeded, canDelegateNeeded, granteeFlags, relativity + 1, allowSome, denySome);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CollectAttrsResult expandAttrsGrantToAttrs(ZimbraACE ace, TargetType targetType, AttrRight attrRightGranted, AttrRight rightNeeded, boolean canDelegateNeeded, Integer relativity, Map<String, Integer> allowSome, Map<String, Integer> denySome) throws ServiceException {
        Right.RightType rightTypeNeeded = rightNeeded.getRightType();
        if (!attrRightGranted.suitableFor(rightTypeNeeded)) {
            return null;
        }
        if (!RightChecker.rightApplicableOnTargetType(targetType, attrRightGranted, canDelegateNeeded)) {
            return null;
        }
        if (rightNeeded != AdminRight.PR_GET_ATTRS && rightNeeded != AdminRight.PR_SET_ATTRS && SetUtil.intersect(attrRightGranted.getTargetTypes(), rightNeeded.getTargetTypes()).isEmpty()) {
            return null;
        }
        if (attrRightGranted.allAttrs()) {
            if (!ace.deny()) return CollectAttrsResult.ALLOW_ALL;
            if (attrRightGranted.getRightType() != rightTypeNeeded) return null;
            return CollectAttrsResult.DENY_ALL;
        }
        if (ace.deny()) {
            if (attrRightGranted.getRightType() != rightTypeNeeded) return null;
            for (String attrName : attrRightGranted.getAttrs()) {
                denySome.put(attrName, relativity);
            }
            return CollectAttrsResult.SOME;
        } else {
            for (String attrName : attrRightGranted.getAttrs()) {
                allowSome.put(attrName, relativity);
            }
        }
        return CollectAttrsResult.SOME;
    }

    private static CollectAttrsResult expandACLToAttrs(List<ZimbraACE> acl, TargetType targetType, Set<String> granteeIds, AttrRight rightNeeded, boolean canDelegateNeeded, short granteeFlags, Integer relativity, Map<String, Integer> allowSome, Map<String, Integer> denySome) throws ServiceException {
        CollectAttrsResult result = null;
        for (ZimbraACE ace : acl) {
            Right rightGranted;
            GranteeType granteeType = ace.getGranteeType();
            if (!granteeType.hasFlags(granteeFlags) || !granteeIds.contains(ace.getGrantee()) || (rightGranted = ace.getRight()).isPresetRight() || canDelegateNeeded && ace.canExecuteOnly()) continue;
            if (rightGranted.isAttrRight()) {
                AttrRight attrRight = (AttrRight)rightGranted;
                result = RightChecker.expandAttrsGrantToAttrs(ace, targetType, attrRight, rightNeeded, canDelegateNeeded, relativity, allowSome, denySome);
                if (result == null || !result.isAll()) continue;
                return result;
            }
            if (!rightGranted.isComboRight()) continue;
            ComboRight comboRight = (ComboRight)rightGranted;
            for (AttrRight attrRight : comboRight.getAttrRights()) {
                result = RightChecker.expandAttrsGrantToAttrs(ace, targetType, attrRight, rightNeeded, canDelegateNeeded, relativity, allowSome, denySome);
                if (result == null || !result.isAll()) continue;
                return result;
            }
        }
        return CollectAttrsResult.SOME;
    }

    static void getEffectiveRights(RightBearer rightBearer, Entry target, boolean expandSetAttrs, boolean expandGetAttrs, RightCommand.EffectiveRights result) throws ServiceException {
        TargetType targetType = TargetType.getTargetType(target);
        RightChecker.getEffectiveRights(rightBearer, target, targetType, expandSetAttrs, expandGetAttrs, result);
    }

    private static void getEffectiveRights(RightBearer rightBearer, Entry target, TargetType targetType, boolean expandSetAttrs, boolean expandGetAttrs, RightCommand.EffectiveRights result) throws ServiceException {
        AllowedAttrs allowGetAttrs;
        AllowedAttrs allowSetAttrs;
        Set<Right> presetRights;
        if (rightBearer instanceof RightBearer.GlobalAdmin) {
            presetRights = RightChecker.getAllExecutablePresetRights(targetType);
            allowSetAttrs = AllowedAttrs.ALLOW_ALL_ATTRS();
            allowGetAttrs = AllowedAttrs.ALLOW_ALL_ATTRS();
        } else {
            RightBearer.Grantee grantee = (RightBearer.Grantee)rightBearer;
            presetRights = RightChecker.getEffectivePresetRights(grantee, target);
            allowSetAttrs = RightChecker.accessibleAttrs(grantee, target, AdminRight.PR_SET_ATTRS, false);
            allowGetAttrs = RightChecker.accessibleAttrs(grantee, target, AdminRight.PR_GET_ATTRS, false);
        }
        HashSet<String> rights = new HashSet<String>();
        for (Right r : presetRights) {
            rights.add(r.getName());
        }
        result.setPresetRights(RightChecker.setToSortedList(rights));
        if (allowSetAttrs.getResult() == AllowedAttrs.Result.ALLOW_ALL) {
            result.setCanSetAllAttrs();
            if (expandSetAttrs) {
                result.setCanSetAttrs(RightChecker.expandAttrs(target));
            }
        } else if (allowSetAttrs.getResult() == AllowedAttrs.Result.ALLOW_SOME) {
            result.setCanSetAttrs(RightChecker.fillDefault(target, allowSetAttrs));
        }
        if (allowGetAttrs.getResult() == AllowedAttrs.Result.ALLOW_ALL) {
            result.setCanGetAllAttrs();
            if (expandGetAttrs) {
                result.setCanGetAttrs(RightChecker.expandAttrs(target));
            }
        } else if (allowGetAttrs.getResult() == AllowedAttrs.Result.ALLOW_SOME) {
            result.setCanGetAttrs(RightChecker.fillDefault(target, allowGetAttrs));
        }
    }

    private static List<String> setToSortedList(Set<String> set) {
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        return list;
    }

    private static SortedMap<String, RightCommand.EffectiveAttr> fillDefault(Entry target, AllowedAttrs allowSetAttrs) throws ServiceException {
        return RightChecker.fillDefaultAndConstratint(target, allowSetAttrs.getAllowed());
    }

    private static SortedMap<String, RightCommand.EffectiveAttr> expandAttrs(Entry target) throws ServiceException {
        return RightChecker.fillDefaultAndConstratint(target, TargetType.getAttrsInClass(target));
    }

    private static SortedMap<String, RightCommand.EffectiveAttr> fillDefaultAndConstratint(Entry target, Set<String> attrs) throws ServiceException {
        TreeMap<String, RightCommand.EffectiveAttr> effAttrs = new TreeMap<String, RightCommand.EffectiveAttr>();
        Entry constraintEntry = AttributeConstraint.getConstraintEntry(target);
        Map<String, AttributeConstraint> constraints = constraintEntry == null ? null : AttributeConstraint.getConstraint(constraintEntry);
        boolean hasConstraints = constraints != null && !constraints.isEmpty();
        for (String attrName : attrs) {
            HashSet<String> defaultValues = null;
            Object defaultValue = target.getAttrDefault(attrName);
            if (defaultValue instanceof String) {
                defaultValue = ToXML.fixupZimbraPrefTimeZoneId(attrName, (String)defaultValue);
                defaultValues = new HashSet<String>();
                defaultValues.add((String)defaultValue);
            } else if (defaultValue instanceof String[]) {
                defaultValues = new HashSet<String>(Arrays.asList((String[])defaultValue));
            }
            AttributeConstraint constraint = hasConstraints ? constraints.get(attrName) : null;
            effAttrs.put(attrName, new RightCommand.EffectiveAttr(attrName, defaultValues, constraint));
        }
        return effAttrs;
    }

    private static Set<Right> getEffectivePresetRights(RightBearer.Grantee grantee, Entry target) throws ServiceException {
        Set<Right> conflicts;
        Entry grantedOn;
        Provisioning prov = Provisioning.getInstance();
        Set<String> granteeIds = grantee.getIdAndGroupIds();
        TargetType targetType = TargetType.getTargetType(target);
        HashMap<Right, Integer> allowed = new HashMap<Right, Integer>();
        HashMap<Right, Integer> denied = new HashMap<Right, Integer>();
        Integer relativity = 1;
        CollectAttrsResult car = CollectAttrsResult.SOME;
        List<ZimbraACE> acl = ACLUtil.getAllACEs(target);
        if (acl != null) {
            RightChecker.collectPresetRightOnTarget(acl, targetType, granteeIds, relativity, allowed, denied);
            relativity = relativity + 2;
        }
        Domain targetDomain = TargetType.getTargetDomain(prov, target);
        TargetIterator iter = TargetIterator.getTargetIeterator(prov, target);
        GroupACLs groupACLs = null;
        while ((grantedOn = iter.next()) != null && !car.isAll()) {
            acl = ACLUtil.getAllACEs(grantedOn);
            if (grantedOn instanceof DistributionList) {
                if (acl == null) continue;
                boolean skipPositiveGrants = false;
                if (grantee.isAccount()) {
                    boolean bl = skipPositiveGrants = !RightChecker.crossDomainOK(prov, grantee.getAccount(), grantee.getDomain(), targetDomain, (DistributionList)grantedOn);
                }
                if (groupACLs == null) {
                    groupACLs = new GroupACLs();
                }
                groupACLs.collectACL(grantedOn, skipPositiveGrants);
                continue;
            }
            if (groupACLs != null) {
                List<ZimbraACE> aclsOnGroupTargets = groupACLs.getAllACLs();
                if (aclsOnGroupTargets != null) {
                    RightChecker.collectPresetRightOnTarget(aclsOnGroupTargets, targetType, granteeIds, relativity, allowed, denied);
                    relativity = relativity + 2;
                }
                groupACLs = null;
            }
            if (acl == null) continue;
            RightChecker.collectPresetRightOnTarget(acl, targetType, granteeIds, relativity, allowed, denied);
            relativity = relativity + 2;
        }
        if (sLog.isDebugEnabled()) {
            StringBuilder sbAllowed = new StringBuilder();
            for (Map.Entry a : allowed.entrySet()) {
                sbAllowed.append("(" + ((Right)a.getKey()).getName() + ", " + a.getValue() + ") ");
            }
            sLog.debug("allowed: " + sbAllowed.toString());
            StringBuilder sbDenied = new StringBuilder();
            for (Map.Entry a : allowed.entrySet()) {
                sbDenied.append("(" + ((Right)a.getKey()).getName() + ", " + a.getValue() + ") ");
            }
            sLog.debug("denied: " + sbDenied.toString());
        }
        if (!(conflicts = SetUtil.intersect(allowed.keySet(), denied.keySet())).isEmpty()) {
            for (Right right : conflicts) {
                if ((Integer)denied.get(right) > (Integer)allowed.get(right)) continue;
                allowed.remove(right);
            }
        }
        return allowed.keySet();
    }

    private static void collectPresetRightOnTarget(List<ZimbraACE> acl, TargetType targeType, Set<String> granteeIds, Integer relativity, Map<Right, Integer> allowed, Map<Right, Integer> denied) throws ServiceException {
        short granteeFlags = 3;
        RightChecker.collectPresetRights(acl, targeType, granteeIds, granteeFlags, relativity, allowed, denied);
        granteeFlags = 4;
        RightChecker.collectPresetRights(acl, targeType, granteeIds, granteeFlags, relativity, allowed, denied);
    }

    private static void collectPresetRights(List<ZimbraACE> acl, TargetType targetType, Set<String> granteeIds, short granteeFlags, Integer relativity, Map<Right, Integer> allowed, Map<Right, Integer> denied) throws ServiceException {
        for (ZimbraACE ace : acl) {
            GranteeType granteeType = ace.getGranteeType();
            if (!granteeType.hasFlags(granteeFlags) || !granteeIds.contains(ace.getGrantee())) continue;
            Right right = ace.getRight();
            if (right.isComboRight()) {
                ComboRight comboRight = (ComboRight)right;
                for (Right r : comboRight.getPresetRights()) {
                    if (!r.executableOnTargetType(targetType)) continue;
                    if (ace.deny()) {
                        denied.put(r, relativity);
                        continue;
                    }
                    allowed.put(r, relativity);
                }
                continue;
            }
            if (!right.isPresetRight() || !right.executableOnTargetType(targetType)) continue;
            if (ace.deny()) {
                denied.put(right, relativity);
                continue;
            }
            allowed.put(right, relativity);
        }
    }

    private static Set<Right> getAllExecutablePresetRights(TargetType targetType) throws ServiceException {
        Map<String, AdminRight> allRights = RightManager.getInstance().getAllAdminRights();
        HashSet<Right> rights = new HashSet<Right>();
        for (Map.Entry<String, AdminRight> right : allRights.entrySet()) {
            Right r = right.getValue();
            if (r.isPresetRight()) {
                if (!r.executableOnTargetType(targetType)) continue;
                rights.add(r);
                continue;
            }
            if (!r.isComboRight()) continue;
            ComboRight comboRight = (ComboRight)r;
            for (Right rt : comboRight.getPresetRights()) {
                if (!rt.executableOnTargetType(targetType)) continue;
                rights.add(rt);
            }
        }
        return rights;
    }

    static boolean isValidGranteeForAdminRights(GranteeType gt, NamedEntry grantee) {
        if (gt == GranteeType.GT_USER) {
            return !grantee.getBooleanAttr("zimbraIsAdminAccount", false) && grantee.getBooleanAttr("zimbraIsDelegatedAdminAccount", false);
        }
        if (gt == GranteeType.GT_GROUP) {
            return grantee.getBooleanAttr("zimbraIsAdminGroup", false);
        }
        return false;
    }

    private static boolean isSubTarget(Provisioning prov, Entry targetSup, Entry targetSub) throws ServiceException {
        if (targetSup instanceof Domain) {
            Domain domain = (Domain)targetSup;
            Domain targetSubInDomain = TargetType.getTargetDomain(prov, targetSub);
            if (targetSubInDomain == null) {
                return false;
            }
            if (domain.getId().equals(targetSubInDomain.getId())) {
                return true;
            }
            Provisioning.AclGroups groups = null;
            if (targetSub instanceof Account) {
                groups = prov.getAclGroups((Account)targetSub, false);
            } else if (targetSub instanceof DistributionList) {
                groups = prov.getAclGroups((DistributionList)targetSub, false);
            } else {
                return false;
            }
            for (String groupId : groups.groupIds()) {
                DistributionList group = prov.getAclGroup(Provisioning.DistributionListBy.id, groupId);
                Domain groupInDomain = prov.getDomain(group);
                if (groupInDomain == null || !domain.getId().equals(groupInDomain.getId())) continue;
                return true;
            }
            return false;
        }
        if (targetSup instanceof DistributionList) {
            DistributionList dl = (DistributionList)targetSup;
            Object subId = null;
            if (targetSub instanceof Account) {
                return prov.inDistributionList((Account)targetSub, dl.getId());
            }
            if (targetSub instanceof DistributionList) {
                return prov.inDistributionList((DistributionList)targetSub, dl.getId());
            }
            return false;
        }
        if (targetSup instanceof GlobalGrant) {
            return true;
        }
        throw ServiceException.FAILURE("internal error, unexpected entry type: " + targetSup.getLabel(), null);
    }

    static void checkDenied(Provisioning prov, Entry targetToGrant, Right rightToGrant, Set<SearchGrants.GrantsOnTarget> grantsOnTargets, String granteeId, Set<String> granteeGroups) throws ServiceException {
        for (SearchGrants.GrantsOnTarget grantsOnTarget : grantsOnTargets) {
            Entry grantedOnEntry = grantsOnTarget.getTargetEntry();
            if (!RightChecker.isSubTarget(prov, targetToGrant, grantedOnEntry)) continue;
            ZimbraACL grants = grantsOnTarget.getAcl();
            for (ZimbraACE ace : grants.getDeniedACEs()) {
                if ((granteeId == null || !granteeId.equals(ace.getGrantee())) && (granteeGroups == null || !granteeGroups.contains(ace.getGrantee())) || !rightToGrant.overlaps(ace.getRight())) continue;
                throw ServiceException.PERM_DENIED("insuffcient right to grant. Right " + ace.getRight().getName() + " is denied to grp/usr " + ace.getGrantee() + " on target " + grantedOnEntry.getLabel());
            }
        }
    }

    static void getAllGrantableTargetTypes(Right right, Set<TargetType> result) throws ServiceException {
        if (right.isPresetRight() || right.isAttrRight()) {
            result.addAll(right.getGrantableTargetTypes());
        } else if (right.isComboRight()) {
            ComboRight cr = (ComboRight)right;
            for (Right r : cr.getAllRights()) {
                RightChecker.getAllGrantableTargetTypes(r, result);
            }
        }
    }

    static void checkPartiallyDenied(Account grantor, TargetType targetTypeToGrant, Entry targetToGrant, Right rightToGrant) throws ServiceException {
        if (AccessControlUtil.isGlobalAdmin(grantor, true)) {
            return;
        }
        Provisioning prov = Provisioning.getInstance();
        Set<TargetType> subTargetTypes = targetTypeToGrant.subTargetTypes();
        HashSet<TargetType> subRightsGrantableOnTargetTypes = new HashSet<TargetType>();
        RightChecker.getAllGrantableTargetTypes(rightToGrant, subRightsGrantableOnTargetTypes);
        Set<TargetType> targetTypesToSearch = SetUtil.intersect(subTargetTypes, subRightsGrantableOnTargetTypes);
        if (targetTypesToSearch.isEmpty()) {
            return;
        }
        RightBearer.Grantee grantee = new RightBearer.Grantee(grantor);
        Set<String> granteeIdsToSearch = grantee.getIdAndGroupIds();
        SearchGrants searchGrants = new SearchGrants(prov, targetTypesToSearch, granteeIdsToSearch);
        Set<SearchGrants.GrantsOnTarget> grantsOnTargets = searchGrants.doSearch().getResults();
        RightChecker.checkDenied(prov, targetToGrant, rightToGrant, grantsOnTargets, grantor.getId(), null);
        RightChecker.checkDenied(prov, targetToGrant, rightToGrant, grantsOnTargets, null, granteeIdsToSearch);
    }

    private static void computeRightsInheritedFromGlobalGrant(Provisioning prov, RightBearer.Grantee grantee, boolean expandSetAttrs, boolean expandGetAttrs, RightCommand.AllEffectiveRights aer) throws ServiceException {
        for (TargetType tt : TargetType.values()) {
            Entry targetEntry = tt == TargetType.global ? prov.getGlobalGrant() : (tt == TargetType.config ? prov.getConfig() : PseudoTarget.createPseudoTarget(prov, tt, null, null, true, null, null));
            RightCommand.EffectiveRights er = new RightCommand.EffectiveRights(tt.getCode(), TargetType.getId(targetEntry), targetEntry.getLabel(), grantee.getId(), grantee.getName());
            RightChecker.getEffectiveRights(grantee, targetEntry, expandSetAttrs, expandGetAttrs, er);
            aer.setAll(tt, er);
        }
    }

    private static void computeRightsInheritedFromDomain(Provisioning prov, RightBearer.Grantee grantee, TargetType targetType, Domain grantedOnDomain, boolean expandSetAttrs, boolean expandGetAttrs, RightCommand.AllEffectiveRights aer) throws ServiceException {
        String domainId = TargetType.getId(grantedOnDomain);
        String domainName = grantedOnDomain.getLabel();
        Entry pseudoTarget = PseudoTarget.createPseudoTarget(prov, targetType, Provisioning.DomainBy.id, grantedOnDomain.getId(), false, null, null);
        RightCommand.EffectiveRights er = new RightCommand.EffectiveRights(targetType.getCode(), TargetType.getId(pseudoTarget), pseudoTarget.getLabel(), grantee.getId(), grantee.getName());
        RightChecker.getEffectiveRights(grantee, pseudoTarget, expandSetAttrs, expandGetAttrs, er);
        aer.addDomainEntry(targetType, domainName, er);
    }

    private static void computeRightsInheritedFromDomain(Provisioning prov, RightBearer.Grantee grantee, Domain grantedOnDomain, boolean expandSetAttrs, boolean expandGetAttrs, RightCommand.AllEffectiveRights aer) throws ServiceException {
        RightChecker.computeRightsInheritedFromDomain(prov, grantee, TargetType.account, grantedOnDomain, expandSetAttrs, expandGetAttrs, aer);
        RightChecker.computeRightsInheritedFromDomain(prov, grantee, TargetType.calresource, grantedOnDomain, expandSetAttrs, expandGetAttrs, aer);
        RightChecker.computeRightsInheritedFromDomain(prov, grantee, TargetType.dl, grantedOnDomain, expandSetAttrs, expandGetAttrs, aer);
    }

    private static void computeRightsOnGroupShape(Provisioning prov, RightBearer.Grantee grantee, TargetType targetType, Set<GroupShape> groupShapes, boolean expandSetAttrs, boolean expandGetAttrs, RightCommand.AllEffectiveRights aer, Set<String> entryIdsHasGrants) throws ServiceException {
        for (GroupShape shape : groupShapes) {
            Entry target = null;
            RightCommand.EffectiveRights er = null;
            for (String memberName : shape.getMembers()) {
                String targetId;
                target = TargetType.lookupTarget(prov, targetType, Provisioning.TargetBy.name, memberName, false);
                if (target == null || entryIdsHasGrants.contains(targetId = TargetType.getId(target))) continue;
                er = new RightCommand.EffectiveRights(targetType.getCode(), targetId, target.getLabel(), grantee.getId(), grantee.getName());
                RightChecker.getEffectiveRights(grantee, target, expandSetAttrs, expandGetAttrs, er);
                break;
            }
            if (er == null) continue;
            aer.addAggregation(targetType, shape.getMembers(), er);
        }
    }

    private static void computeRightsOnEntry(Provisioning prov, RightBearer.Grantee grantee, TargetType grantedOnTargetType, Entry grantedOnEntry, boolean expandSetAttrs, boolean expandGetAttrs, RightCommand.AllEffectiveRights aer) throws ServiceException {
        String targetId = TargetType.getId(grantedOnEntry);
        String targetName = grantedOnEntry.getLabel();
        RightCommand.EffectiveRights er = new RightCommand.EffectiveRights(grantedOnTargetType.getCode(), targetId, targetName, grantee.getId(), grantee.getName());
        RightChecker.getEffectiveRights(grantee, grantedOnEntry, expandSetAttrs, expandGetAttrs, er);
        aer.addEntry(grantedOnTargetType, targetName, er);
    }

    private static Set<String> getAllGroups(Provisioning prov) throws ServiceException {
        String base = ((LdapProvisioning)prov).getDIT().mailBranchBaseDN();
        String query = LdapFilter.allDistributionLists();
        String[] returnAttrs = new String[]{"mail"};
        Visitor visitor = new Visitor("mail");
        LdapUtil.searchLdapOnMaster(base, query, returnAttrs, visitor);
        return visitor.getResult();
    }

    private static Set<String> getAllCalendarResources(Provisioning prov) throws ServiceException {
        String base = ((LdapProvisioning)prov).getDIT().mailBranchBaseDN();
        String query = LdapFilter.allCalendarResources();
        String[] returnAttrs = new String[]{"zimbraMailDeliveryAddress"};
        Visitor visitor = new Visitor("zimbraMailDeliveryAddress");
        LdapUtil.searchLdapOnMaster(base, query, returnAttrs, visitor);
        return visitor.getResult();
    }

    private static void getAllGroupMembers(Provisioning prov, DistributionList group, Set<String> allGroups, Set<String> allCalendarResources, AllGroupMembers result) throws ServiceException {
        Set<String> members = group.getAllMembersSet();
        HashSet<String> accountMembers = new HashSet<String>(members);
        for (String member : members) {
            if (allGroups.contains(member)) {
                accountMembers.remove(member);
                if (result.getMembers(TargetType.dl).contains(member)) continue;
                result.getMembers(TargetType.dl).add(member);
                DistributionList grp = prov.get(Provisioning.DistributionListBy.name, member);
                if (grp == null) continue;
                RightChecker.getAllGroupMembers(prov, grp, allGroups, allCalendarResources, result);
                continue;
            }
            if (!allCalendarResources.contains(member)) continue;
            accountMembers.remove(member);
            result.getMembers(TargetType.calresource).add(member);
        }
        result.getMembers(TargetType.account).addAll(accountMembers);
    }

    private static AllGroupMembers getAllGroupMembers(Provisioning prov, DistributionList group) throws ServiceException {
        Set<String> allGroups = RightChecker.getAllGroups(prov);
        Set<String> allCalendarResources = RightChecker.getAllCalendarResources(prov);
        AllGroupMembers allMembers = new AllGroupMembers(group.getName());
        RightChecker.getAllGroupMembers(prov, group, allGroups, allCalendarResources, allMembers);
        return allMembers;
    }

    static void getAllEffectiveRights(RightBearer rightBearer, boolean expandSetAttrs, boolean expandGetAttrs, RightCommand.AllEffectiveRights aer) throws ServiceException {
        Entry grantedOnEntry;
        if (rightBearer instanceof RightBearer.GlobalAdmin) {
            for (TargetType tt : TargetType.values()) {
                RightCommand.EffectiveRights er = new RightCommand.EffectiveRights(tt.getCode(), null, null, rightBearer.getId(), rightBearer.getName());
                RightChecker.getEffectiveRights(rightBearer, null, tt, expandSetAttrs, expandGetAttrs, er);
                aer.setAll(tt, er);
            }
            return;
        }
        RightBearer.Grantee grantee = (RightBearer.Grantee)rightBearer;
        Provisioning prov = Provisioning.getInstance();
        HashSet<TargetType> targetTypesToSearch = new HashSet<TargetType>(Arrays.asList(TargetType.values()));
        Set<String> granteeIdsToSearch = grantee.getIdAndGroupIds();
        SearchGrants searchGrants = new SearchGrants(prov, targetTypesToSearch, granteeIdsToSearch);
        Set<SearchGrants.GrantsOnTarget> grantsOnTargets = searchGrants.doSearch().getResults();
        HashSet<DistributionList> groupsWithGrants = new HashSet<DistributionList>();
        for (SearchGrants.GrantsOnTarget grantsOnTarget : grantsOnTargets) {
            Entry grantedOnEntry2 = grantsOnTarget.getTargetEntry();
            ZimbraACL acl = grantsOnTarget.getAcl();
            TargetType targetType = TargetType.getTargetType(grantedOnEntry2);
            if (targetType == TargetType.global) {
                RightChecker.computeRightsInheritedFromGlobalGrant(prov, grantee, expandSetAttrs, expandGetAttrs, aer);
                continue;
            }
            if (targetType == TargetType.domain) {
                RightChecker.computeRightsInheritedFromDomain(prov, grantee, (Domain)grantedOnEntry2, expandSetAttrs, expandGetAttrs, aer);
                continue;
            }
            if (targetType != TargetType.dl) continue;
            groupsWithGrants.add((DistributionList)grantedOnEntry2);
        }
        HashSet<GroupShape> accountShapes = new HashSet<GroupShape>();
        HashSet<GroupShape> calendarResourceShapes = new HashSet<GroupShape>();
        HashSet<GroupShape> distributionListShapes = new HashSet<GroupShape>();
        for (DistributionList group : groupsWithGrants) {
            DistributionList dl = prov.get(Provisioning.DistributionListBy.id, group.getId());
            AllGroupMembers allMembers = RightChecker.getAllGroupMembers(prov, dl);
            GroupShape.shapeMembers(TargetType.account, accountShapes, allMembers);
            GroupShape.shapeMembers(TargetType.calresource, calendarResourceShapes, allMembers);
            GroupShape.shapeMembers(TargetType.dl, distributionListShapes, allMembers);
        }
        HashSet<String> entryIdsHasGrants = new HashSet<String>();
        for (SearchGrants.GrantsOnTarget grantsOnTarget : grantsOnTargets) {
            grantedOnEntry = grantsOnTarget.getTargetEntry();
            if (!(grantedOnEntry instanceof NamedEntry)) continue;
            entryIdsHasGrants.add(((NamedEntry)grantedOnEntry).getId());
        }
        RightChecker.computeRightsOnGroupShape(prov, grantee, TargetType.account, accountShapes, expandSetAttrs, expandGetAttrs, aer, entryIdsHasGrants);
        RightChecker.computeRightsOnGroupShape(prov, grantee, TargetType.calresource, calendarResourceShapes, expandSetAttrs, expandGetAttrs, aer, entryIdsHasGrants);
        RightChecker.computeRightsOnGroupShape(prov, grantee, TargetType.dl, distributionListShapes, expandSetAttrs, expandGetAttrs, aer, entryIdsHasGrants);
        for (SearchGrants.GrantsOnTarget grantsOnTarget : grantsOnTargets) {
            grantedOnEntry = grantsOnTarget.getTargetEntry();
            ZimbraACL acl = grantsOnTarget.getAcl();
            TargetType targetType = TargetType.getTargetType(grantedOnEntry);
            if (targetType == TargetType.global) continue;
            RightChecker.computeRightsOnEntry(prov, grantee, targetType, grantedOnEntry, expandSetAttrs, expandGetAttrs, aer);
        }
    }

    private static void groupTest() throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        DistributionList dl = prov.get(Provisioning.DistributionListBy.name, "group1@phoebe.mac");
        AllGroupMembers allMembers = RightChecker.getAllGroupMembers(prov, dl);
        System.out.println("\naccounts");
        for (String member : allMembers.getMembers(TargetType.account)) {
            System.out.println("  " + member);
        }
        System.out.println("\ncalendar resources");
        for (String member : allMembers.getMembers(TargetType.calresource)) {
            System.out.println("  " + member);
        }
        System.out.println("\ngroups");
        for (String member : allMembers.getMembers(TargetType.dl)) {
            System.out.println("  " + member);
        }
    }

    private static void setupShapeTest() throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        String domainName = "test.com";
        Domain domain = prov.createDomain(domainName, new HashMap<String, Object>());
        DistributionList groupA = prov.createDistributionList("groupA@" + domainName, new HashMap<String, Object>());
        DistributionList groupB = prov.createDistributionList("groupB@" + domainName, new HashMap<String, Object>());
        DistributionList groupC = prov.createDistributionList("groupC@" + domainName, new HashMap<String, Object>());
        DistributionList groupD = prov.createDistributionList("groupD@" + domainName, new HashMap<String, Object>());
        String pw = "test123";
        Account A = prov.createAccount("A@" + domainName, pw, null);
        Account B = prov.createAccount("B@" + domainName, pw, null);
        Account C = prov.createAccount("C@" + domainName, pw, null);
        Account D = prov.createAccount("D@" + domainName, pw, null);
        Account AB = prov.createAccount("AB@" + domainName, pw, null);
        Account AC = prov.createAccount("AC@" + domainName, pw, null);
        Account AD = prov.createAccount("AD@" + domainName, pw, null);
        Account BC = prov.createAccount("BC@" + domainName, pw, null);
        Account BD = prov.createAccount("BD@" + domainName, pw, null);
        Account CD = prov.createAccount("CD@" + domainName, pw, null);
        Account ABC = prov.createAccount("ABC@" + domainName, pw, null);
        Account ABD = prov.createAccount("ABD@" + domainName, pw, null);
        Account ACD = prov.createAccount("ACD@" + domainName, pw, null);
        Account BCD = prov.createAccount("BCD@" + domainName, pw, null);
        Account ABCD = prov.createAccount("ABCD@" + domainName, pw, null);
        groupA.addMembers(new String[]{A.getName(), AB.getName(), AC.getName(), AD.getName(), ABC.getName(), ABD.getName(), ACD.getName(), ABCD.getName()});
        groupB.addMembers(new String[]{B.getName(), AB.getName(), BC.getName(), BD.getName(), ABC.getName(), ABD.getName(), BCD.getName(), ABCD.getName()});
        groupC.addMembers(new String[]{C.getName(), AC.getName(), BC.getName(), CD.getName(), ABC.getName(), ACD.getName(), BCD.getName(), ABCD.getName()});
        groupD.addMembers(new String[]{D.getName(), AD.getName(), BD.getName(), CD.getName(), ABD.getName(), ACD.getName(), BCD.getName(), ABCD.getName()});
    }

    private static void shapeTest() throws ServiceException {
        RightChecker.setupShapeTest();
        Provisioning prov = Provisioning.getInstance();
        HashSet<DistributionList> groupsWithGrants = new HashSet<DistributionList>();
        String domainName = "test.com";
        groupsWithGrants.add(prov.get(Provisioning.DistributionListBy.name, "groupA@" + domainName));
        groupsWithGrants.add(prov.get(Provisioning.DistributionListBy.name, "groupB@" + domainName));
        groupsWithGrants.add(prov.get(Provisioning.DistributionListBy.name, "groupC@" + domainName));
        groupsWithGrants.add(prov.get(Provisioning.DistributionListBy.name, "groupD@" + domainName));
        HashSet<GroupShape> accountShapes = new HashSet<GroupShape>();
        HashSet<GroupShape> calendarResourceShapes = new HashSet<GroupShape>();
        HashSet<GroupShape> distributionListShapes = new HashSet<GroupShape>();
        for (DistributionList group : groupsWithGrants) {
            DistributionList dl = prov.get(Provisioning.DistributionListBy.id, group.getId());
            AllGroupMembers allMembers = RightChecker.getAllGroupMembers(prov, dl);
            GroupShape.shapeMembers(TargetType.account, accountShapes, allMembers);
            GroupShape.shapeMembers(TargetType.calresource, calendarResourceShapes, allMembers);
            GroupShape.shapeMembers(TargetType.dl, distributionListShapes, allMembers);
        }
        int count = 1;
        for (GroupShape shape : accountShapes) {
            System.out.println("\n" + count++);
            for (String group : shape.getGroups()) {
                System.out.println("group " + group);
            }
            for (String member : shape.getMembers()) {
                System.out.println("    " + member);
            }
        }
    }

    public static void main(String[] args) throws ServiceException {
        RightChecker.shapeTest();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroupShape {
        Set<String> mGroups = new HashSet<String>();
        Set<String> mMembers = new HashSet<String>();

        private GroupShape() {
        }

        private void addGroups(Set<String> groups) {
            this.mGroups.addAll(groups);
        }

        private void addGroup(String group) {
            this.mGroups.add(group);
        }

        private Set<String> getGroups() {
            return this.mGroups;
        }

        private void addMembers(Set<String> members) {
            this.mMembers.addAll(members);
        }

        private void addMember(String member) {
            this.mMembers.add(member);
        }

        private Set<String> getMembers() {
            return this.mMembers;
        }

        private boolean removeMemberIfPresent(String member) {
            if (this.mMembers.contains(member)) {
                this.mMembers.remove(member);
                return true;
            }
            return false;
        }

        private boolean hasMembers() {
            return !this.mMembers.isEmpty();
        }

        static void shapeMembers(TargetType targetType, Set<GroupShape> shapes, AllGroupMembers group) throws ServiceException {
            HashSet<GroupShape> newShapes = new HashSet<GroupShape>();
            GroupShape newShape = new GroupShape();
            newShape.addGroup(group.getGroupName());
            newShape.addMembers(group.getMembers(targetType));
            for (GroupShape shape : shapes) {
                GroupShape intersectShape = new GroupShape();
                for (String member : group.getMembers(targetType)) {
                    if (!shape.removeMemberIfPresent(member)) continue;
                    intersectShape.addMember(member);
                    newShape.removeMemberIfPresent(member);
                }
                if (!intersectShape.hasMembers()) continue;
                intersectShape.addGroups(shape.getGroups());
                intersectShape.addGroup(group.getGroupName());
                newShapes.add(intersectShape);
            }
            shapes.addAll(newShapes);
            if (newShape.hasMembers()) {
                shapes.add(newShape);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AllGroupMembers {
        String mGroupName;
        Set<String> mAccounts = new HashSet<String>();
        Set<String> mCalendarResources = new HashSet<String>();
        Set<String> mDistributionLists = new HashSet<String>();

        AllGroupMembers(String groupName) {
            this.mGroupName = groupName;
        }

        String getGroupName() {
            return this.mGroupName;
        }

        Set<String> getMembers(TargetType targetType) throws ServiceException {
            switch (targetType) {
                case account: {
                    return this.mAccounts;
                }
                case calresource: {
                    return this.mCalendarResources;
                }
                case dl: {
                    return this.mDistributionLists;
                }
            }
            throw ServiceException.FAILURE("internal error", null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Visitor
    implements LdapUtil.SearchLdapVisitor {
        private String mNameAttr;
        private Set<String> mNames = new HashSet<String>();

        Visitor(String nameAttr) {
            this.mNameAttr = nameAttr;
        }

        @Override
        public void visit(String dn, Map<String, Object> attrs, Attributes ldapAttrs) {
            this.mNames.add((String)attrs.get(this.mNameAttr));
        }

        private Set<String> getResult() {
            return this.mNames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CollectAttrsResult {
        SOME(false),
        ALLOW_ALL(true),
        DENY_ALL(true);

        private boolean mIsAll;

        private CollectAttrsResult(boolean isAll) {
            this.mIsAll = isAll;
        }

        boolean isAll() {
            return this.mIsAll;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroupACLs {
        private Set<ZimbraACE> aclsOnGroupTargetsAllowedNotDelegable = null;
        private Set<ZimbraACE> aclsOnGroupTargetsAllowedDelegable = null;
        private Set<ZimbraACE> aclsOnGroupTargetsDenied = null;

        private GroupACLs() {
        }

        void collectACL(Entry grantedOn, boolean skipPositiveGrants) throws ServiceException {
            if (this.aclsOnGroupTargetsAllowedNotDelegable == null) {
                this.aclsOnGroupTargetsAllowedNotDelegable = new HashSet<ZimbraACE>();
            }
            if (this.aclsOnGroupTargetsAllowedDelegable == null) {
                this.aclsOnGroupTargetsAllowedDelegable = new HashSet<ZimbraACE>();
            }
            if (this.aclsOnGroupTargetsDenied == null) {
                this.aclsOnGroupTargetsDenied = new HashSet<ZimbraACE>();
            }
            Set<ZimbraACE> allowedNotDelegable = ACLUtil.getAllowedNotDelegableACEs(grantedOn);
            Set<ZimbraACE> allowedDelegable = ACLUtil.getAllowedDelegableACEs(grantedOn);
            Set<ZimbraACE> denied = ACLUtil.getDeniedACEs(grantedOn);
            if (allowedNotDelegable != null && !skipPositiveGrants) {
                this.aclsOnGroupTargetsAllowedNotDelegable.addAll(allowedNotDelegable);
            }
            if (allowedDelegable != null && !skipPositiveGrants) {
                this.aclsOnGroupTargetsAllowedDelegable.addAll(allowedDelegable);
            }
            if (denied != null) {
                this.aclsOnGroupTargetsDenied.addAll(denied);
            }
        }

        List<ZimbraACE> getAllACLs() {
            if (this.aclsOnGroupTargetsAllowedNotDelegable != null && !this.aclsOnGroupTargetsAllowedNotDelegable.isEmpty() || this.aclsOnGroupTargetsAllowedDelegable != null && !this.aclsOnGroupTargetsAllowedDelegable.isEmpty() || this.aclsOnGroupTargetsDenied != null && !this.aclsOnGroupTargetsDenied.isEmpty()) {
                ArrayList<ZimbraACE> aclsOnGroupTargets = new ArrayList<ZimbraACE>();
                aclsOnGroupTargets.addAll(this.aclsOnGroupTargetsDenied);
                aclsOnGroupTargets.addAll(this.aclsOnGroupTargetsAllowedDelegable);
                aclsOnGroupTargets.addAll(this.aclsOnGroupTargetsAllowedNotDelegable);
                return aclsOnGroupTargets;
            }
            return null;
        }
    }

    private static class SeenRight {
        private boolean mSeenRight;

        private SeenRight() {
        }

        void setSeenRight() {
            this.mSeenRight = true;
        }

        boolean seenRight() {
            return this.mSeenRight;
        }
    }
}

