/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AccessControlUtil;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.RightChecker;
import java.util.HashSet;
import java.util.Set;

public abstract class RightBearer {
    protected NamedEntry mRightBearer;

    static RightBearer newRightBearer(NamedEntry entry) throws ServiceException {
        if (entry instanceof Account && AccessControlUtil.isGlobalAdmin((Account)entry, true)) {
            return new GlobalAdmin(entry);
        }
        return new Grantee(entry);
    }

    protected RightBearer(NamedEntry grantee) {
        this.mRightBearer = grantee;
    }

    String getId() {
        return this.mRightBearer.getId();
    }

    String getName() {
        return this.mRightBearer.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Grantee
    extends RightBearer {
        GranteeType mGranteeType;
        Domain mGranteeDomain;
        Set<String> mIdAndGroupIds;

        public Grantee(NamedEntry grantee) throws ServiceException {
            super(grantee);
            Provisioning.AclGroups granteeGroups;
            Provisioning prov = grantee.getProvisioning();
            if (grantee instanceof Account) {
                this.mGranteeType = GranteeType.GT_USER;
                this.mGranteeDomain = prov.getDomain((Account)grantee);
                granteeGroups = prov.getAclGroups((Account)grantee, true);
            } else if (grantee instanceof DistributionList) {
                this.mGranteeType = GranteeType.GT_GROUP;
                this.mGranteeDomain = prov.getDomain((DistributionList)grantee);
                granteeGroups = prov.getAclGroups((DistributionList)grantee, true);
            } else {
                throw ServiceException.INVALID_REQUEST("invalid grantee type", null);
            }
            if (!RightChecker.isValidGranteeForAdminRights(this.mGranteeType, grantee)) {
                throw ServiceException.INVALID_REQUEST("invalid grantee", null);
            }
            if (this.mGranteeDomain == null) {
                throw ServiceException.FAILURE("internal error, cannot get domain for grantee", null);
            }
            this.mIdAndGroupIds = new HashSet<String>();
            this.mIdAndGroupIds.add(grantee.getId());
            this.mIdAndGroupIds.addAll(granteeGroups.groupIds());
        }

        boolean isAccount() {
            return this.mGranteeType == GranteeType.GT_USER;
        }

        Account getAccount() throws ServiceException {
            if (this.mGranteeType != GranteeType.GT_USER) {
                throw ServiceException.FAILURE("internal error", null);
            }
            return (Account)this.mRightBearer;
        }

        DistributionList getGroup() throws ServiceException {
            if (this.mGranteeType != GranteeType.GT_GROUP) {
                throw ServiceException.FAILURE("internal error", null);
            }
            return (DistributionList)this.mRightBearer;
        }

        Domain getDomain() {
            return this.mGranteeDomain;
        }

        Set<String> getIdAndGroupIds() {
            return this.mIdAndGroupIds;
        }
    }

    static class GlobalAdmin
    extends RightBearer {
        private GlobalAdmin(NamedEntry grantee) throws ServiceException {
            super(grantee);
        }
    }
}

