/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.accesscontrol.UserRight;
import com.zimbra.cs.account.accesscontrol.generated.RightConsts;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Right
extends RightConsts {
    private final String mName;
    protected RightType mRightType;
    private String mDesc;
    private String mDoc;
    private Boolean mDefault;
    protected TargetType mTargetType;

    static void init(RightManager rm) throws ServiceException {
        UserRight.init(rm);
        AdminRight.init(rm);
    }

    Right(String name, RightType rightType) {
        this.mRightType = rightType;
        this.mName = name;
    }

    String dump(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("name         = " + this.mName + "\n");
        sb.append("type         = " + this.mRightType.name() + "\n");
        sb.append("desc         = " + this.mDesc + "\n");
        sb.append("doc          = " + this.mDoc + "\n");
        sb.append("default      = " + this.mDefault + "\n");
        sb.append("target Type  = " + (Object)((Object)this.mTargetType) + "\n");
        return sb.toString();
    }

    abstract boolean overlaps(Right var1) throws ServiceException;

    public boolean isUserRight() {
        return false;
    }

    public boolean isPresetRight() {
        return false;
    }

    public boolean isAttrRight() {
        return false;
    }

    public boolean isComboRight() {
        return false;
    }

    public RightType getRightType() {
        return this.mRightType;
    }

    public String getName() {
        return this.mName;
    }

    public String getDesc() {
        return this.mDesc;
    }

    void setDesc(String desc) {
        this.mDesc = desc;
    }

    public String getDoc() {
        return this.mDoc;
    }

    void setDoc(String doc) {
        this.mDoc = doc;
    }

    public Boolean getDefault() {
        return this.mDefault;
    }

    void setDefault(Boolean defaultValue) {
        this.mDefault = defaultValue;
    }

    boolean executableOnTargetType(TargetType targetType) {
        return this.mTargetType == targetType;
    }

    boolean grantableOnTargetType(TargetType targetType) {
        return targetType.isInheritedBy(this.mTargetType);
    }

    boolean isTheSameRight(Right other) {
        return this == other;
    }

    final String reportGrantableTargetTypes() {
        Set<TargetType> targetTypes = this.getGrantableTargetTypes();
        StringBuilder sb = new StringBuilder();
        for (TargetType tt : targetTypes) {
            sb.append(tt.getCode() + " ");
        }
        return sb.toString();
    }

    protected Set<TargetType> getGrantableTargetTypes() {
        return this.mTargetType.inheritFrom();
    }

    void setTargetType(TargetType targetType) throws ServiceException {
        if (this.mTargetType != null) {
            throw ServiceException.PARSE_ERROR("target type already set", null);
        }
        this.mTargetType = targetType;
    }

    void verifyTargetType() throws ServiceException {
        if (this.mTargetType == null) {
            throw ServiceException.PARSE_ERROR("missing target type", null);
        }
    }

    public TargetType getTargetType() throws ServiceException {
        return this.mTargetType;
    }

    public String getTargetTypeStr() {
        return this.mTargetType.getCode();
    }

    void completeRight() throws ServiceException {
        if (this.getDesc() == null) {
            throw ServiceException.PARSE_ERROR("missing description", null);
        }
        this.verifyTargetType();
    }

    public static void main(String[] args) throws ServiceException {
        RightManager.getInstance();
        AdminRight r1 = Rights.Admin.R_domainAdminAccountRights;
        AdminRight r2 = Rights.Admin.R_domainAdminRights;
        boolean overlaps = r1.overlaps(r2);
        System.out.println(r1.getName() + " " + r2.getName() + " => " + overlaps);
        r1 = Rights.Admin.R_modifyCos;
        overlaps = r1.overlaps(r2);
        System.out.println(r1.getName() + " " + r2.getName() + " => " + overlaps);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RightType {
        preset,
        getAttrs,
        setAttrs,
        combo;


        public static RightType fromString(String s) throws ServiceException {
            try {
                return RightType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.PARSE_ERROR("unknown right type: " + s, e);
            }
        }

        public boolean isUserDefinable() {
            return this != preset;
        }
    }
}

