/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.TargetType;
import java.util.HashMap;
import java.util.Map;

public class PseudoTarget {
    static Entry createPseudoTarget(Provisioning prov, TargetType targetType, Provisioning.DomainBy domainBy, String domainStr, boolean createPseudoDomain, Provisioning.CosBy cosBy, String cosStr) throws ServiceException {
        NamedEntry targetEntry = null;
        Config config = prov.getConfig();
        String zimbraId = PseudoZimbraId.getPseudoZimbraId();
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        attrMap.put("zimbraId", zimbraId);
        Domain pseudoDomain = null;
        Domain domain = null;
        if (targetType == TargetType.account || targetType == TargetType.calresource || targetType == TargetType.dl) {
            if (createPseudoDomain) {
                domain = pseudoDomain = (Domain)PseudoTarget.createPseudoTarget(prov, TargetType.domain, null, null, false, null, null);
            } else {
                if (domainBy == null || domainStr == null) {
                    throw ServiceException.INVALID_REQUEST("domainBy and domain identifier is required", null);
                }
                domain = prov.get(domainBy, domainStr);
            }
            if (domain == null) {
                throw AccountServiceException.NO_SUCH_DOMAIN(domainStr);
            }
        }
        switch (targetType) {
            case account: 
            case calresource: {
                Cos cos = null;
                if (cosBy != null && cosStr != null) {
                    cos = prov.get(cosBy, cosStr);
                    if (cos == null) {
                        throw AccountServiceException.NO_SUCH_COS(cosStr);
                    }
                    attrMap.put("zimbraCOSId", cos.getId());
                } else {
                    String domainCosId;
                    String string = domainCosId = domain != null ? domain.getAttr("zimbraDomainDefaultCOSId", null) : null;
                    if (domainCosId != null) {
                        cos = prov.get(Provisioning.CosBy.id, domainCosId);
                    }
                    if (cos == null) {
                        cos = prov.get(Provisioning.CosBy.name, "default");
                    }
                }
                if (targetType == TargetType.account) {
                    targetEntry = new PseudoAccount("pseudo@" + domain.getName(), zimbraId, attrMap, cos.getAccountDefaults(), prov, pseudoDomain);
                    break;
                }
                targetEntry = new PseudoCalendarResource("pseudo@" + domain.getName(), zimbraId, attrMap, cos.getAccountDefaults(), prov, pseudoDomain);
                break;
            }
            case cos: {
                targetEntry = new Cos("pseudocos", zimbraId, attrMap, prov);
                break;
            }
            case dl: {
                targetEntry = new PseudoDistributionList("pseudo@" + domain.getName(), zimbraId, attrMap, prov, pseudoDomain);
                DistributionList dl = (DistributionList)targetEntry;
                dl.turnToAclGroup();
                break;
            }
            case domain: {
                targetEntry = new Domain("pseudo.pseudo", zimbraId, attrMap, config.getDomainDefaults(), prov);
                break;
            }
            case server: {
                targetEntry = new Server("pseudo.pseudo", zimbraId, attrMap, config.getServerDefaults(), prov);
                break;
            }
            case xmppcomponent: {
                targetEntry = new XMPPComponent("pseudo", zimbraId, attrMap, prov);
                break;
            }
            case zimlet: {
                targetEntry = new Zimlet("pseudo", zimbraId, attrMap, prov);
                break;
            }
            default: {
                throw ServiceException.INVALID_REQUEST("unsupported target for createPseudoTarget: " + targetType.getCode(), null);
            }
        }
        return targetEntry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PseudoDistributionList
    extends DistributionList {
        Domain mPseudoDomain;

        public PseudoDistributionList(String name, String id, Map<String, Object> attrs, Provisioning prov, Domain pseudoDomain) {
            super(name, id, attrs, prov);
            this.mPseudoDomain = pseudoDomain;
        }

        Domain getPseudoDomain() {
            return this.mPseudoDomain;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PseudoCalendarResource
    extends CalendarResource {
        Domain mPseudoDomain;

        public PseudoCalendarResource(String name, String id, Map<String, Object> attrs, Map<String, Object> defaults, Provisioning prov, Domain pseudoDomain) {
            super(name, id, attrs, defaults, prov);
            this.mPseudoDomain = pseudoDomain;
        }

        Domain getPseudoDomain() {
            return this.mPseudoDomain;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PseudoAccount
    extends Account {
        Domain mPseudoDomain;
        Provisioning.AclGroups mAclGroups;

        PseudoAccount(String name, String id, Map<String, Object> attrs, Map<String, Object> defaults, Provisioning prov, Domain pseudoDomain) {
            super(name, id, attrs, defaults, prov);
            this.mPseudoDomain = pseudoDomain;
        }

        PseudoAccount(String name, String id, Map<String, Object> attrs, Map<String, Object> defaults, Provisioning prov, DistributionList group) throws ServiceException {
            super(name, id, attrs, defaults, prov);
            this.mAclGroups = prov.getAclGroups(group, false);
        }

        Domain getPseudoDomain() {
            return this.mPseudoDomain;
        }

        Provisioning.AclGroups getAclGroups() {
            return this.mAclGroups;
        }
    }

    static class PseudoZimbraId {
        private static final String PSEUDO_ZIMBRA_ID = "aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa";

        PseudoZimbraId() {
        }

        static String getPseudoZimbraId() {
            return PSEUDO_ZIMBRA_ID;
        }

        static boolean isPseudoZimrbaId(String zid) {
            return PSEUDO_ZIMBRA_ID.equals(zid);
        }
    }
}

