/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.ComboRight;
import com.zimbra.cs.account.accesscontrol.Right;

public class PresetRight
extends AdminRight {
    PresetRight(String name) {
        super(name, Right.RightType.preset);
    }

    public boolean isPresetRight() {
        return true;
    }

    boolean overlaps(Right other) throws ServiceException {
        if (other.isPresetRight()) {
            return this == other;
        }
        if (other.isAttrRight()) {
            return false;
        }
        if (other.isComboRight()) {
            return ((ComboRight)other).containsPresetRight(this);
        }
        throw ServiceException.FAILURE("internal error", null);
    }
}

