/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.accesscontrol.AttrRight;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.TargetType;

public class InlineAttrRight
extends AttrRight {
    private static final String PARTS_SEPARATOR = ".";
    private static final String PARTS_SEPARATOR_ESC = "\\.";
    private static final String OP_GET = "get";
    private static final String OP_SET = "set";

    static InlineAttrRight newInlineAttrRight(String right) throws ServiceException {
        Right.RightType rightType;
        String[] parts = right.split(PARTS_SEPARATOR_ESC);
        if (parts.length != 3) {
            throw ServiceException.PARSE_ERROR("inline attr right might have 3 parts", null);
        }
        if (OP_GET.equals(parts[0])) {
            rightType = Right.RightType.getAttrs;
        } else if (OP_SET.equals(parts[0])) {
            rightType = Right.RightType.setAttrs;
        } else {
            throw ServiceException.PARSE_ERROR("invalid op for inline attr right: " + parts[0], null);
        }
        TargetType targetType = TargetType.fromCode(parts[1]);
        if (targetType == TargetType.global) {
            throw ServiceException.PARSE_ERROR("target type for inline attr right cannot be: " + parts[1], null);
        }
        String attrName = parts[2];
        InlineAttrRight iar = new InlineAttrRight(right, rightType);
        iar.setDesc(right);
        iar.setTargetType(targetType);
        iar.validateAttr(attrName);
        iar.addAttr(attrName);
        iar.completeRight();
        return iar;
    }

    public static String composeGetRight(TargetType targetType, String attrName) {
        return InlineAttrRight.composeRight(OP_GET, targetType, attrName);
    }

    public static String composeSetRight(TargetType targetType, String attrName) {
        return InlineAttrRight.composeRight(OP_SET, targetType, attrName);
    }

    private static String composeRight(String op, TargetType targetType, String attrName) {
        return op + PARTS_SEPARATOR + targetType.getCode() + PARTS_SEPARATOR + attrName;
    }

    static boolean looksLikeOne(String right) {
        return right.contains(PARTS_SEPARATOR);
    }

    private InlineAttrRight(String name, Right.RightType rightType) {
        super(name, rightType);
    }

    boolean isTheSameRight(Right other) {
        return this.getName().equals(other.getName());
    }
}

