/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GranteeType {
    GT_USER("usr", 3),
    GT_GROUP("grp", 5),
    GT_AUTHUSER("all", 8),
    GT_DOMAIN("dom", 1),
    GT_GUEST("gst", 2),
    GT_KEY("key", 2),
    GT_PUBLIC("pub", 16);

    private String mCode;
    private short mFlags;

    private GranteeType(String code, short flags) {
        this.mCode = code;
        GT.sCodeMap.put(code, this);
        this.mFlags = flags;
    }

    public static GranteeType fromCode(String granteeType) throws ServiceException {
        if (granteeType.equals(GT_GUEST.getCode())) {
            throw ServiceException.FAILURE("guest grantee not yet supported", null);
        }
        GranteeType gt = GT.sCodeMap.get(granteeType);
        if (gt == null) {
            throw ServiceException.PARSE_ERROR("invalid grantee type: " + granteeType, null);
        }
        return gt;
    }

    public String getCode() {
        return this.mCode;
    }

    public boolean allowedForAdminRights() {
        return this.hasFlags((short)1);
    }

    public boolean hasFlags(short flags) {
        return (flags & this.mFlags) == flags;
    }

    public static NamedEntry lookupGrantee(Provisioning prov, GranteeType granteeType, Provisioning.GranteeBy granteeBy, String grantee) throws ServiceException {
        NamedEntry granteeEntry = null;
        switch (granteeType) {
            case GT_USER: {
                granteeEntry = prov.get(Provisioning.AccountBy.fromString(granteeBy.name()), grantee);
                if (granteeEntry != null) break;
                throw AccountServiceException.NO_SUCH_ACCOUNT(grantee);
            }
            case GT_GROUP: {
                granteeEntry = prov.getAclGroup(Provisioning.DistributionListBy.fromString(granteeBy.name()), grantee);
                if (granteeEntry != null) break;
                throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(grantee);
            }
            case GT_DOMAIN: {
                granteeEntry = prov.get(Provisioning.DomainBy.fromString(granteeBy.name()), grantee);
                if (granteeEntry != null) break;
                throw AccountServiceException.NO_SUCH_DOMAIN(grantee);
            }
            default: {
                ServiceException.INVALID_REQUEST("invallid grantee type for lookupGrantee:" + granteeType.getCode(), null);
            }
        }
        return granteeEntry;
    }

    private static class GT {
        static Map<String, GranteeType> sCodeMap = new HashMap<String, GranteeType>();

        private GT() {
        }
    }
}

