/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.DomainAccessManager;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightChecker;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.mailbox.ACL;

public class DomainACLAccessManager
extends DomainAccessManager {
    public DomainACLAccessManager() throws ServiceException {
        RightManager.getInstance();
    }

    public boolean canAccessAccount(AuthToken at, Account target, boolean asAdmin) throws ServiceException {
        if (super.canAccessAccount(at, target, asAdmin)) {
            return true;
        }
        return this.canDo(at, (Entry)target, (Right)Rights.User.R_loginAs, asAdmin, false);
    }

    public boolean canAccessAccount(AuthToken at, Account target) throws ServiceException {
        return this.canAccessAccount(at, target, true);
    }

    public boolean canAccessAccount(Account credentials, Account target, boolean asAdmin) throws ServiceException {
        if (super.canAccessAccount(credentials, target, asAdmin)) {
            return true;
        }
        return this.canDo(credentials, (Entry)target, (Right)Rights.User.R_loginAs, asAdmin, false);
    }

    public boolean canAccessAccount(Account credentials, Account target) throws ServiceException {
        return this.canAccessAccount(credentials, target, true);
    }

    public boolean canDo(Account grantee, Entry target, Right rightNeeded, boolean asAdmin, boolean defaultGrant) {
        try {
            if (grantee == null) {
                grantee = ACL.ANONYMOUS_ACCT;
            }
            if (target instanceof Account && ((Account)target).getId().equals(grantee.getId())) {
                return true;
            }
            if (rightNeeded != Rights.User.R_loginAs && target instanceof Account && this.canAccessAccount(grantee, (Account)target, asAdmin)) {
                return true;
            }
            Boolean result = RightChecker.checkPresetRight(grantee, target, rightNeeded, false, null);
            if (result != null) {
                return result;
            }
            Boolean defaultValue = rightNeeded.getDefault();
            if (defaultValue != null) {
                return defaultValue;
            }
            return defaultGrant;
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn((Object)("ACL checking failed: grantee=" + grantee.getName() + ", target=" + target.getLabel() + ", right=" + rightNeeded.getName() + " => denied"), e);
            return false;
        }
    }

    public boolean canDo(AuthToken grantee, Entry target, Right rightNeeded, boolean asAdmin, boolean defaultGrant) {
        try {
            Account granteeAcct = grantee == null ? ACL.ANONYMOUS_ACCT : (grantee.isZimbraUser() ? Provisioning.getInstance().get(Provisioning.AccountBy.id, grantee.getAccountId()) : new ACL.GuestAccount(grantee));
            return this.canDo(granteeAcct, target, rightNeeded, asAdmin, defaultGrant);
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn((Object)("ACL checking failed: grantee=" + grantee.getAccountId() + ", target=" + target.getLabel() + ", right=" + rightNeeded.getName() + " => denied"), e);
            return false;
        }
    }

    public boolean canDo(String granteeEmail, Entry target, Right rightNeeded, boolean asAdmin, boolean defaultGrant) {
        try {
            Account granteeAcct = null;
            if (granteeEmail != null) {
                granteeAcct = Provisioning.getInstance().get(Provisioning.AccountBy.name, granteeEmail);
            }
            if (granteeAcct == null) {
                granteeAcct = ACL.ANONYMOUS_ACCT;
            }
            return this.canDo(granteeAcct, target, rightNeeded, asAdmin, defaultGrant);
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn((Object)("ACL checking failed: grantee=" + granteeEmail + ", target=" + target.getLabel() + ", right=" + rightNeeded.getName() + " => denied"), e);
            return false;
        }
    }
}

