/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.ACLUtil;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.ZimbraACE;
import java.util.List;

public class CrossDomain {
    static Boolean checkCrossDomainAdminRight(Provisioning prov, Domain granteeDomain, Entry target, boolean canDelegateNeeded) throws ServiceException {
        if (!(target instanceof Domain)) {
            throw ServiceException.FAILURE("internal error", null);
        }
        List<ZimbraACE> acl = ACLUtil.getAllACEs(target);
        if (acl == null) {
            return Boolean.FALSE;
        }
        for (ZimbraACE ace : acl) {
            if (ace.getRight() != Rights.Admin.R_crossDomainAdmin || ace.getGranteeType() != GranteeType.GT_DOMAIN || !ace.getGrantee().equals(granteeDomain.getId())) continue;
            if (ace.deny()) {
                return Boolean.FALSE;
            }
            if (canDelegateNeeded && ace.canExecuteOnly()) {
                return false;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    static boolean checkCrossDomain(Provisioning prov, Domain granteeDomain, Domain targetDomain, DistributionList grantedOn) throws ServiceException {
        if (targetDomain == null) {
            return true;
        }
        Domain grantedOnTargetInDomain = prov.getDomain(grantedOn);
        if (grantedOnTargetInDomain == null) {
            ZimbraLog.acl.warn("cannot get domain for dl " + grantedOn.getName() + " for checking cross doamin right");
            return false;
        }
        if (targetDomain.getId().equals(granteeDomain.getId())) {
            return true;
        }
        if (targetDomain.getId().equals(grantedOnTargetInDomain.getId())) {
            return true;
        }
        return CrossDomain.checkCrossDomainAdminRight(prov, granteeDomain, targetDomain, false);
    }

    static boolean validateCrossDomainAdminGrant(Right right, GranteeType granteeType) throws ServiceException {
        if (right == Rights.Admin.R_crossDomainAdmin && granteeType != GranteeType.GT_DOMAIN) {
            throw ServiceException.INVALID_REQUEST("grantee for right " + Rights.Admin.R_crossDomainAdmin.getName() + " must be a domain.", null);
        }
        if (right != Rights.Admin.R_crossDomainAdmin && granteeType == GranteeType.GT_DOMAIN) {
            throw ServiceException.INVALID_REQUEST("grantee for right " + right.getName() + " cannot be a domain.", null);
        }
        return right == Rights.Admin.R_crossDomainAdmin;
    }
}

