/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.SetUtil;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AttrRight;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.TargetType;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboRight
extends AdminRight {
    private Set<Right> mRights = new HashSet<Right>();
    private Set<Right> mAllRights = new HashSet<Right>();
    private Set<Right> mPresetRights = new HashSet<Right>();
    private Set<AttrRight> mAttrRights = new HashSet<AttrRight>();

    ComboRight(String name) {
        super(name, Right.RightType.combo);
    }

    @Override
    public boolean isComboRight() {
        return true;
    }

    @Override
    public String dump(StringBuilder sb) {
        super.dump(sb);
        sb.append("===== combo right properties: =====\n");
        sb.append("rights:\n");
        for (Right r : this.mRights) {
            sb.append("    ");
            sb.append(r.getName());
            sb.append("\n");
        }
        return sb.toString();
    }

    void addRight(Right right) {
        this.mRights.add(right);
    }

    @Override
    boolean overlaps(Right other) throws ServiceException {
        for (Right r : this.getAllRights()) {
            if (!r.overlaps(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean executableOnTargetType(TargetType targetType) {
        return true;
    }

    @Override
    boolean grantableOnTargetType(TargetType targetType) {
        for (Right r : this.getAllRights()) {
            if (r.grantableOnTargetType(targetType)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Set<TargetType> getGrantableTargetTypes() {
        Set<TargetType> targetTypes = null;
        for (Right r : this.getAllRights()) {
            Set<TargetType> tts = r.getGrantableTargetTypes();
            if (targetTypes == null) {
                targetTypes = tts;
                continue;
            }
            targetTypes = SetUtil.intersect(targetTypes, tts);
        }
        return targetTypes;
    }

    @Override
    void setTargetType(TargetType targetType) throws ServiceException {
        throw ServiceException.FAILURE("target type is now allowed for combo right", null);
    }

    @Override
    void verifyTargetType() throws ServiceException {
    }

    @Override
    public TargetType getTargetType() throws ServiceException {
        throw ServiceException.FAILURE("internal error", null);
    }

    @Override
    public String getTargetTypeStr() {
        return null;
    }

    @Override
    void completeRight() throws ServiceException {
        super.completeRight();
        ComboRight.expand(this, this.mPresetRights, this.mAttrRights);
        this.mAllRights.addAll(this.mPresetRights);
        this.mAllRights.addAll(this.mAttrRights);
    }

    private static void expand(ComboRight right, Set<Right> presetRights, Set<AttrRight> attrRights) throws ServiceException {
        for (Right r : right.getRights()) {
            if (r.isPresetRight()) {
                presetRights.add(r);
                continue;
            }
            if (r.isAttrRight()) {
                attrRights.add((AttrRight)r);
                continue;
            }
            if (r.isComboRight()) {
                ComboRight.expand((ComboRight)r, presetRights, attrRights);
                continue;
            }
            throw ServiceException.FAILURE("internal error", null);
        }
    }

    boolean containsPresetRight(Right right) {
        return this.mPresetRights.contains(right);
    }

    Set<Right> getPresetRights() {
        return this.mPresetRights;
    }

    Set<AttrRight> getAttrRights() {
        return this.mAttrRights;
    }

    public Set<Right> getRights() {
        return this.mRights;
    }

    public Set<Right> getAllRights() {
        return this.mAllRights;
    }
}

