/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.AttributeType;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeConstraint {
    private static final String CONSTRAINT_CACHE_KEY = "CONSTRAINT_CACHE";
    private static final String PARTS_DELIMITER = ":";
    private static final String VALUES_DELIMITER = ",";
    private String mAttrName;
    private Set<String> mValues;

    AttributeConstraint(String attrName) {
        this.mAttrName = attrName;
    }

    String getAttrName() {
        return this.mAttrName;
    }

    void setMin(String min) throws ServiceException {
        throw ServiceException.PARSE_ERROR("min constraint not supported for the attribute type", null);
    }

    void setMax(String max) throws ServiceException {
        throw ServiceException.PARSE_ERROR("max constraint not supported for attribute type", null);
    }

    void addValue(String value) {
        if (this.mValues == null) {
            this.mValues = new HashSet<String>();
        }
        this.mValues.add(value);
    }

    boolean isEmpty() {
        return this.getMin() == null && this.getMax() == null && this.getValues() == null;
    }

    Set<String> getValues() {
        return this.mValues;
    }

    String getMin() {
        return null;
    }

    String getMax() {
        return null;
    }

    boolean violateMinMax(String value) throws ServiceException {
        return false;
    }

    boolean violateValues(String value) {
        return this.mValues != null && !this.mValues.contains(value);
    }

    boolean violated(Object value) throws ServiceException {
        if (value instanceof String) {
            if (this.violateValues((String)value)) {
                return true;
            }
            if (this.violateMinMax((String)value)) {
                return true;
            }
        } else if (value instanceof String[]) {
            for (String v : (String[])value) {
                if (this.violateValues(v)) {
                    return true;
                }
                if (!this.violateMinMax(v)) continue;
                return true;
            }
        } else {
            throw ServiceException.FAILURE("internal error", null);
        }
        return false;
    }

    public String toString() {
        Set<String> values;
        String max;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAttrName());
        String min = this.getMin();
        if (min != null) {
            sb.append(":min=" + min);
        }
        if ((max = this.getMax()) != null) {
            sb.append(":max=" + max);
        }
        if ((values = this.getValues()) != null && values.size() > 0) {
            sb.append(":values=");
            boolean first = true;
            for (String value : values) {
                if (!first) {
                    sb.append(VALUES_DELIMITER);
                } else {
                    first = false;
                }
                sb.append(value);
            }
        }
        return sb.toString();
    }

    private static AttributeConstraint fromString(AttributeManager am, String s) throws ServiceException {
        String[] parts = s.split(PARTS_DELIMITER);
        if (parts.length < 2) {
            throw ServiceException.PARSE_ERROR("invalid constraint: " + s, null);
        }
        String attrName = parts[0];
        AttributeConstraint constraint = AttributeConstraint.newConstratint(am, attrName);
        for (int i = 1; i < parts.length; ++i) {
            String[] vs;
            String part = parts[i];
            if (part.startsWith("min=")) {
                constraint.setMin(part.substring(4));
                continue;
            }
            if (part.startsWith("max=")) {
                constraint.setMax(part.substring(4));
                continue;
            }
            if (!part.startsWith("values=")) continue;
            String values = part.substring(7);
            for (String v : vs = values.split(VALUES_DELIMITER)) {
                constraint.addValue(v);
            }
        }
        return constraint;
    }

    public static AttributeConstraint fromXML(AttributeManager am, String attrName, Element eConstraint) throws ServiceException {
        Element eValues;
        Element eMax;
        AttributeConstraint constraint = AttributeConstraint.newConstratint(am, attrName);
        Element eMin = eConstraint.getOptionalElement("min");
        if (eMin != null) {
            constraint.setMin(eMin.getText());
        }
        if ((eMax = eConstraint.getOptionalElement("max")) != null) {
            constraint.setMax(eMax.getText());
        }
        if ((eValues = eConstraint.getOptionalElement("values")) != null) {
            for (Element eValue : eValues.listElements("v")) {
                constraint.addValue(eValue.getText());
            }
        }
        return constraint;
    }

    public void toXML(Element eParent) {
        Set<String> values;
        String max;
        Element eConstraint = eParent.addElement("constraint");
        String min = this.getMin();
        if (min != null) {
            eConstraint.addElement("min").setText(min);
        }
        if ((max = this.getMax()) != null) {
            eConstraint.addElement("max").setText(max);
        }
        if ((values = this.getValues()) != null) {
            Element eValues = eConstraint.addElement("values");
            for (String v : values) {
                eValues.addElement("v").setText(v);
            }
        }
    }

    static AttributeConstraint newConstratint(AttributeManager am, String attrName) throws ServiceException {
        AttributeType at = am.getAttributeType(attrName);
        switch (at) {
            case TYPE_BOOLEAN: {
                return new AttributeConstraint(attrName);
            }
            case TYPE_DURATION: {
                return new DurationConstraint(attrName);
            }
            case TYPE_GENTIME: {
                return new GentimeConstraint(attrName);
            }
            case TYPE_EMAIL: 
            case TYPE_EMAILP: 
            case TYPE_CS_EMAILP: 
            case TYPE_ENUM: 
            case TYPE_ID: {
                return new AttributeConstraint(attrName);
            }
            case TYPE_INTEGER: {
                return new IntegerConstraint(attrName);
            }
            case TYPE_PORT: {
                return new IntegerConstraint(attrName);
            }
            case TYPE_PHONE: 
            case TYPE_STRING: 
            case TYPE_ASTRING: 
            case TYPE_OSTRING: 
            case TYPE_CSTRING: 
            case TYPE_REGEX: {
                return new AttributeConstraint(attrName);
            }
            case TYPE_LONG: {
                return new LongConstraint(attrName);
            }
        }
        throw ServiceException.FAILURE("internal error", null);
    }

    static Entry getConstraintEntry(Entry entry) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Entry constraintEntry = null;
        if (entry instanceof Account) {
            constraintEntry = prov.getCOS((Account)entry);
        } else if (entry instanceof Domain || entry instanceof Server) {
            constraintEntry = prov.getConfig();
        }
        return constraintEntry;
    }

    public static Map<String, AttributeConstraint> getConstraint(Entry constraintEntry) throws ServiceException {
        Map<String, AttributeConstraint> constraints = (Map<String, AttributeConstraint>)constraintEntry.getCachedData(CONSTRAINT_CACHE_KEY);
        if (constraints == null) {
            constraints = AttributeConstraint.loadConstraints(constraintEntry);
            constraintEntry.setCachedData(CONSTRAINT_CACHE_KEY, constraints);
        }
        return constraints;
    }

    private static Map<String, AttributeConstraint> loadConstraints(Entry constraintEntry) throws ServiceException {
        HashMap<String, AttributeConstraint> constraints = new HashMap<String, AttributeConstraint>();
        Set<String> cstrnts = constraintEntry.getMultiAttrSet("zimbraConstraint");
        AttributeManager am = AttributeManager.getInstance();
        for (String c : cstrnts) {
            AttributeConstraint constraint = AttributeConstraint.fromString(am, c);
            constraints.put(constraint.getAttrName(), constraint);
        }
        return constraints;
    }

    public static void modifyConstraint(Entry constraintEntry, List<AttributeConstraint> newConstraints) throws ServiceException {
        Map<String, AttributeConstraint> curConstraints = AttributeConstraint.loadConstraints(constraintEntry);
        for (AttributeConstraint newConstraintsForAttr : newConstraints) {
            String attrName = newConstraintsForAttr.getAttrName();
            AttributeConstraint curConstraintsForAttr = curConstraints.get(attrName);
            if (curConstraintsForAttr == null) {
                if (newConstraintsForAttr.isEmpty()) {
                    curConstraints.remove(attrName);
                    continue;
                }
                curConstraints.put(attrName, newConstraintsForAttr);
                continue;
            }
            if (newConstraintsForAttr.isEmpty()) continue;
            curConstraints.put(attrName, newConstraintsForAttr);
        }
        HashMap<String, String[]> newAttrValues = new HashMap<String, String[]>();
        if (curConstraints.size() == 0) {
            newAttrValues.put("zimbraConstraint", null);
        } else {
            ArrayList<String> newValues = new ArrayList<String>();
            for (AttributeConstraint at : curConstraints.values()) {
                newValues.add(at.toString());
            }
            newAttrValues.put("zimbraConstraint", newValues.toArray(new String[newValues.size()]));
        }
        Provisioning.getInstance().modifyAttrs(constraintEntry, newAttrValues);
    }

    private static boolean ignoreConstraint(String attrName) {
        return "zimbraCOSId".equals(attrName) || "zimbraDomainDefaultCOSId".equals(attrName);
    }

    static boolean violateConstraint(Map<String, AttributeConstraint> constraints, String attrName, Object value) throws ServiceException {
        AttributeConstraint constraint = constraints.get(attrName);
        if (constraint == null) {
            return false;
        }
        if (AttributeConstraint.ignoreConstraint(attrName)) {
            ZimbraLog.acl.warn("Constraint for " + attrName + " is not suported and is ignored.");
            return false;
        }
        boolean violated = constraint.violated(value);
        if (violated) {
            throw ServiceException.PERM_DENIED("constraint violated: " + constraint.getAttrName());
        }
        return violated;
    }

    private static void test(Map<String, AttributeConstraint> constraints, String attrName, Object value, boolean expected) throws ServiceException {
        boolean violated = false;
        try {
            violated = AttributeConstraint.violateConstraint(constraints, attrName, value);
        }
        catch (ServiceException e) {
            if ("service.PERM_DENIED".equals(e.getCode())) {
                violated = true;
            }
            throw e;
        }
        StringBuilder sb = new StringBuilder();
        if (value instanceof String[]) {
            for (String s : (String[])value) {
                sb.append(s + " ");
            }
        } else {
            sb.append(value.toString());
        }
        System.out.println("Setting " + attrName + " to " + "[" + sb.toString() + "]" + " => " + (violated ? "denied" : "allowed"));
        if (violated != expected) {
            System.out.println("failed\n");
        }
    }

    public static void main(String[] args) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        AttributeManager am = AttributeManager.getInstance();
        AttributeConstraint.fromString(am, "zimbraPasswordMinLength:min=6");
        AttributeConstraint.fromString(am, "zimbraPasswordMaxLength:min=64");
        AttributeConstraint.fromString(am, "zimbraPasswordMinLength:min=6:max=64:values=1,2,3");
        AttributeConstraint.fromString(am, "zimbraFeatureMailEnabled:values=FALSE,TRUE");
        Account acct = prov.get(Provisioning.AccountBy.name, "user1@phoebe.mac");
        Cos cos = prov.getCOS(acct);
        cos.unsetConstraint();
        HashMap<String, Object> cosConstraints = new HashMap<String, Object>();
        cos.addConstraint("zimbraPasswordMinLength:min=6:max=10:values=8,9", cosConstraints);
        long longMax = Long.MAX_VALUE;
        long longMaxMinusOne = longMax - 1L;
        cos.addConstraint("zimbraMailQuota:max=" + longMaxMinusOne, cosConstraints);
        cos.addConstraint("zimbraPasswordLockoutDuration:min=5h:max=1d", cosConstraints);
        cos.addConstraint("zimbraPrefPop3DownloadSince:min=20060315023000Z", cosConstraints);
        cos.addConstraint("zimbraPrefGroupMailBy:values=conversation", cosConstraints);
        cos.addConstraint("zimbraCalendarMaxRevisions:min=zz:max=10", cosConstraints);
        cos.addConstraint("zimbraZimletAvailableZimlets:values=A,B,C", cosConstraints);
        prov.modifyAttrs(cos, cosConstraints);
        Map<String, AttributeConstraint> constraints = AttributeConstraint.getConstraint(cos);
        AttributeConstraint.test(constraints, "zimbraPasswordMinLength", "5", true);
        AttributeConstraint.test(constraints, "zimbraPasswordMinLength", "6", true);
        AttributeConstraint.test(constraints, "zimbraPasswordMinLength", "7", true);
        AttributeConstraint.test(constraints, "zimbraPasswordMinLength", "8", false);
        AttributeConstraint.test(constraints, "zimbraPasswordMinLength", "9", false);
        AttributeConstraint.test(constraints, "zimbraPasswordMinLength", "10", true);
        AttributeConstraint.test(constraints, "zimbraPasswordMinLength", "11", true);
        AttributeConstraint.test(constraints, "zimbraMailQuota", "" + longMaxMinusOne, false);
        AttributeConstraint.test(constraints, "zimbraMailQuota", "" + longMax, true);
        AttributeConstraint.test(constraints, "zimbraPasswordLockoutDuration", "3h", true);
        AttributeConstraint.test(constraints, "zimbraPasswordLockoutDuration", "25h", true);
        AttributeConstraint.test(constraints, "zimbraPasswordLockoutDuration", "30m", true);
        AttributeConstraint.test(constraints, "zimbraPasswordLockoutDuration", "5h", false);
        AttributeConstraint.test(constraints, "zimbraPasswordLockoutDuration", "600m", false);
        AttributeConstraint.test(constraints, "zimbraPasswordLockoutDuration", "24h", false);
        AttributeConstraint.test(constraints, "zimbraPrefPop3DownloadSince", "20050315023000Z", true);
        AttributeConstraint.test(constraints, "zimbraPrefPop3DownloadSince", "20060315023000Z", false);
        AttributeConstraint.test(constraints, "zimbraPrefPop3DownloadSince", "20060315023001Z", false);
        AttributeConstraint.test(constraints, "zimbraPrefGroupMailBy", "message", true);
        AttributeConstraint.test(constraints, "zimbraPrefGroupMailBy", "conversation", false);
        AttributeConstraint.test(constraints, "zimbraCalendarMaxRevisions", "1", false);
        AttributeConstraint.test(constraints, "zimbraCalendarMaxRevisions", "10", false);
        AttributeConstraint.test(constraints, "zimbraCalendarMaxRevisions", "11", true);
        AttributeConstraint.test(constraints, "zimbraZimletAvailableZimlets", new String[]{"A", "B"}, false);
        AttributeConstraint.test(constraints, "zimbraZimletAvailableZimlets", new String[]{"A", "X"}, true);
        AttributeConstraint.test(constraints, "zimbraPasswordMaxLength", "100", false);
    }

    private static class GentimeConstraint
    extends AttributeConstraint {
        private Long mMin;
        private Long mMax;

        GentimeConstraint(String attrName) {
            super(attrName);
        }

        void setMin(String min) {
            Date date = DateUtil.parseGeneralizedTime(min);
            if (date != null) {
                this.mMin = date.getTime();
            }
        }

        void setMax(String max) {
            Date date = DateUtil.parseGeneralizedTime(max);
            if (date != null) {
                this.mMax = date.getTime();
            }
        }

        String getMin() {
            return this.mMin == null ? null : this.mMin.toString();
        }

        String getMax() {
            return this.mMax == null ? null : this.mMax.toString();
        }

        boolean violateMinMax(String valueStr) throws ServiceException {
            Date value = DateUtil.parseGeneralizedTime(valueStr);
            if (value == null) {
                return true;
            }
            long mSecs = value.getTime();
            if (this.mMin != null && mSecs < this.mMin) {
                return true;
            }
            return this.mMax != null && mSecs > this.mMax;
        }
    }

    private static class DurationConstraint
    extends AttributeConstraint {
        private Long mMin;
        private Long mMax;

        DurationConstraint(String attrName) {
            super(attrName);
        }

        void setMin(String min) {
            try {
                this.mMin = DateUtil.getTimeInterval(min);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }

        void setMax(String max) {
            try {
                this.mMax = DateUtil.getTimeInterval(max);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }

        String getMin() {
            return this.mMin == null ? null : this.mMin.toString();
        }

        String getMax() {
            return this.mMax == null ? null : this.mMax.toString();
        }

        boolean violateMinMax(String valueStr) throws ServiceException {
            try {
                Long value = DateUtil.getTimeInterval(valueStr);
                if (this.mMin != null && value < this.mMin) {
                    return true;
                }
                if (this.mMax != null && value > this.mMax) {
                    return true;
                }
            }
            catch (ServiceException e) {
                return true;
            }
            return false;
        }
    }

    private static class LongConstraint
    extends AttributeConstraint {
        private Long mMin;
        private Long mMax;

        LongConstraint(String attrName) {
            super(attrName);
        }

        void setMin(String min) {
            try {
                this.mMin = Long.valueOf(min);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        void setMax(String max) {
            try {
                this.mMax = Long.valueOf(max);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        String getMin() {
            return this.mMin == null ? null : this.mMin.toString();
        }

        String getMax() {
            return this.mMax == null ? null : this.mMax.toString();
        }

        boolean violateMinMax(String valueStr) throws ServiceException {
            try {
                Long value = Long.valueOf(valueStr);
                if (this.mMin != null && value < this.mMin) {
                    return true;
                }
                if (this.mMax != null && value > this.mMax) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return true;
            }
            return false;
        }
    }

    private static class IntegerConstraint
    extends AttributeConstraint {
        private Integer mMin;
        private Integer mMax;

        IntegerConstraint(String attrName) {
            super(attrName);
        }

        void setMin(String min) {
            try {
                this.mMin = Integer.valueOf(min);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        void setMax(String max) {
            try {
                this.mMax = Integer.valueOf(max);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        String getMin() {
            return this.mMin == null ? null : this.mMin.toString();
        }

        String getMax() {
            return this.mMax == null ? null : this.mMax.toString();
        }

        boolean violateMinMax(String valueStr) throws ServiceException {
            try {
                Integer value = Integer.valueOf(valueStr);
                if (this.mMin != null && value < this.mMin) {
                    return true;
                }
                if (this.mMax != null && value > this.mMax) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return true;
            }
            return false;
        }
    }
}

