/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.SetUtil;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.ComboRight;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.TargetType;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrRight
extends AdminRight {
    private Set<TargetType> mTargetTypes = new HashSet<TargetType>();
    private Set<String> mAttrs;

    AttrRight(String name, Right.RightType rightType) {
        super(name, rightType);
    }

    @Override
    public boolean isAttrRight() {
        return true;
    }

    @Override
    public String dump(StringBuilder sb) {
        super.dump(sb);
        sb.append("===== attrs right properties: =====\n");
        sb.append("target types: ");
        for (TargetType tt : this.mTargetTypes) {
            sb.append(tt.name() + " ");
        }
        sb.append("\n");
        if (this.mAttrs == null) {
            sb.append("all attrs\n");
        } else {
            sb.append("attrs:\n");
            for (String a : this.mAttrs) {
                sb.append("    " + a + "\n");
            }
        }
        return sb.toString();
    }

    @Override
    boolean overlaps(Right other) throws ServiceException {
        if (other.isPresetRight()) {
            return false;
        }
        if (other.isAttrRight()) {
            return this.overlapAttrRight((AttrRight)other);
        }
        if (other.isComboRight()) {
            ComboRight cr = (ComboRight)other;
            Set<AttrRight> otherAttrRights = cr.getAttrRights();
            for (AttrRight ar : otherAttrRights) {
                if (!this.overlapAttrRight(ar)) continue;
                return true;
            }
            return false;
        }
        throw ServiceException.FAILURE("internal error", null);
    }

    private boolean overlapAttrRight(AttrRight otherAttrRight) {
        if (this == otherAttrRight) {
            return true;
        }
        if (SetUtil.intersect(this.getTargetTypes(), otherAttrRight.getTargetTypes()).isEmpty()) {
            return false;
        }
        if (this.allAttrs() || otherAttrRight.allAttrs()) {
            return true;
        }
        return !SetUtil.intersect(this.getAttrs(), otherAttrRight.getAttrs()).isEmpty();
    }

    @Override
    boolean executableOnTargetType(TargetType targetType) {
        return this.mTargetTypes.contains((Object)targetType);
    }

    @Override
    boolean grantableOnTargetType(TargetType targetType) {
        for (TargetType tt : this.getTargetTypes()) {
            if (!targetType.isInheritedBy(tt)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Set<TargetType> getGrantableTargetTypes() {
        HashSet<TargetType> targetTypes = new HashSet<TargetType>();
        for (TargetType tt : this.getTargetTypes()) {
            SetUtil.union(targetTypes, tt.inheritFrom());
        }
        return targetTypes;
    }

    @Override
    void setTargetType(TargetType targetType) throws ServiceException {
        this.mTargetTypes.add(targetType);
    }

    @Override
    void verifyTargetType() throws ServiceException {
    }

    @Override
    public TargetType getTargetType() throws ServiceException {
        throw ServiceException.FAILURE("internal error", null);
    }

    public Set<TargetType> getTargetTypes() {
        return this.mTargetTypes;
    }

    @Override
    public String getTargetTypeStr() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TargetType tt : this.mTargetTypes) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(tt.getCode());
        }
        return sb.toString();
    }

    void addAttr(String attrName) {
        if (this.mAttrs == null) {
            this.mAttrs = new HashSet<String>();
        }
        this.mAttrs.add(attrName);
    }

    public boolean allAttrs() {
        return this.mAttrs == null;
    }

    public Set<String> getAttrs() {
        return this.mAttrs;
    }

    Set<String> getAllAttrs() throws ServiceException {
        if (!this.allAttrs()) {
            throw ServiceException.FAILURE("internal error, can only be called if allAttrs is true", null);
        }
        if (this.mTargetTypes.size() != 1) {
            throw ServiceException.FAILURE("internal error", null);
        }
        TargetType tt = this.mTargetTypes.iterator().next();
        return AttributeManager.getInstance().getAllAttrsInClass(tt.getAttributeClass());
    }

    boolean suitableFor(Right.RightType needed) {
        return needed == this.mRightType || needed == Right.RightType.getAttrs && this.mRightType == Right.RightType.setAttrs;
    }

    @Override
    void completeRight() throws ServiceException {
        super.completeRight();
        if (this.mTargetTypes.size() == 0) {
            throw ServiceException.PARSE_ERROR("missing target type", null);
        }
        if (this.allAttrs() && this.mTargetTypes.size() != 1) {
            throw ServiceException.PARSE_ERROR("there must be exactly one target type for getAttrs/setAttrs right that cover all attributes", null);
        }
    }

    void validateAttr(String attrName) throws ServiceException {
        AttributeManager am = AttributeManager.getInstance();
        for (TargetType tt : this.mTargetTypes) {
            AttributeClass klass = tt.getAttributeClass();
            if (am.getAllAttrsInClass(klass).contains(attrName)) continue;
            throw ServiceException.FAILURE("attribute " + attrName + " is not on " + tt.getCode(), null);
        }
    }
}

