/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AttributeConstraint;
import com.zimbra.cs.account.accesscontrol.RightBearer;
import com.zimbra.cs.account.accesscontrol.RightChecker;
import com.zimbra.cs.account.accesscontrol.TargetType;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllowedAttrs
implements AccessManager.AttrRightChecker {
    private static final Log sLog = LogFactory.getLog(AllowedAttrs.class);
    private Result mResult;
    private Set<String> mAllowSome;

    public static final AllowedAttrs ALLOW_ALL_ATTRS() {
        return new AllowedAttrs(Result.ALLOW_ALL, null);
    }

    public static final AllowedAttrs DENY_ALL_ATTRS() {
        return new AllowedAttrs(Result.DENY_ALL, null);
    }

    public static AllowedAttrs ALLOW_SOME_ATTRS(Set<String> allowSome) {
        return new AllowedAttrs(Result.ALLOW_SOME, allowSome);
    }

    private AllowedAttrs(Result result, Set<String> allowSome) {
        this.mResult = result;
        this.mAllowSome = allowSome;
    }

    public Result getResult() {
        return this.mResult;
    }

    public Set<String> getAllowed() {
        return this.mAllowSome;
    }

    @Override
    public boolean allowAttr(String attrName) {
        if (this.mResult == Result.ALLOW_ALL) {
            return true;
        }
        if (this.mResult == Result.DENY_ALL) {
            return false;
        }
        String actualAttrName = this.getActualAttrName(attrName);
        return this.getAllowed().contains(actualAttrName);
    }

    boolean canAccessAttrs(Set<String> attrsNeeded, Entry target) throws ServiceException {
        if (sLog.isDebugEnabled()) {
            sLog.debug("canAccessAttrs attrsAllowed: " + this.dump());
            StringBuilder sb = new StringBuilder();
            if (attrsNeeded == null) {
                sb.append("<all attributes>");
            } else {
                for (String a : attrsNeeded) {
                    sb.append(a + " ");
                }
            }
            sLog.debug("canAccessAttrs attrsNeeded: " + sb.toString());
        }
        if (this.mResult == Result.ALLOW_ALL) {
            return true;
        }
        if (this.mResult == Result.DENY_ALL) {
            return false;
        }
        if (attrsNeeded == null) {
            return false;
        }
        Set<String> allowed = this.getAllowed();
        for (String attr : attrsNeeded) {
            String attrName = this.getActualAttrName(attr);
            if (allowed.contains(attrName)) continue;
            throw ServiceException.PERM_DENIED("cannot access attribute " + attrName + " on " + (Object)((Object)TargetType.getTargetType(target)) + " target " + target.getLabel());
        }
        return true;
    }

    boolean canSetAttrs(RightBearer.Grantee grantee, Entry target, Map<String, Object> attrsNeeded) throws ServiceException {
        AllowedAttrs allowedAttrsOnConstraintEntry;
        boolean hasConstraints;
        if (attrsNeeded == null) {
            throw ServiceException.FAILURE("internal error", null);
        }
        if (this.mResult == Result.DENY_ALL) {
            return false;
        }
        Entry constraintEntry = AttributeConstraint.getConstraintEntry(target);
        Map<String, AttributeConstraint> constraints = constraintEntry == null ? null : AttributeConstraint.getConstraint(constraintEntry);
        boolean bl = hasConstraints = constraints != null && !constraints.isEmpty();
        if (hasConstraints && ((allowedAttrsOnConstraintEntry = RightChecker.accessibleAttrs(grantee, constraintEntry, AdminRight.PR_SET_ATTRS, false)).getResult() == Result.ALLOW_ALL || allowedAttrsOnConstraintEntry.getResult() == Result.ALLOW_SOME && allowedAttrsOnConstraintEntry.getAllowed().contains("zimbraConstraint"))) {
            hasConstraints = false;
        }
        boolean allowAll = this.mResult == Result.ALLOW_ALL;
        Set<String> allowed = this.getAllowed();
        for (Map.Entry<String, Object> attr : attrsNeeded.entrySet()) {
            String attrName = this.getActualAttrName(attr.getKey());
            if (!allowAll && !allowed.contains(attrName)) {
                throw ServiceException.PERM_DENIED("cannot access attribute " + attrName + " on " + (Object)((Object)TargetType.getTargetType(target)) + " target " + target.getLabel());
            }
            if (!hasConstraints || !AttributeConstraint.violateConstraint(constraints, attrName, attr.getValue())) continue;
            return false;
        }
        return true;
    }

    private String getActualAttrName(String attr) {
        if (attr.charAt(0) == '+' || attr.charAt(0) == '-') {
            return attr.substring(1);
        }
        return attr;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("result = " + (Object)((Object)this.mResult) + " ");
        if (this.mResult == Result.ALLOW_SOME) {
            sb.append("allowed = (");
            for (String a : this.mAllowSome) {
                sb.append(a + " ");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        ALLOW_ALL,
        DENY_ALL,
        ALLOW_SOME;

    }
}

