/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.accesscontrol.AttrRight;
import com.zimbra.cs.account.accesscontrol.ComboRight;
import com.zimbra.cs.account.accesscontrol.PresetRight;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.generated.AdminRights;

public abstract class AdminRight
extends Right {
    public static AttrRight PR_GET_ATTRS;
    public static AttrRight PR_SET_ATTRS;
    public static AdminRight PR_ALWAYS_ALLOW;
    public static AdminRight PR_SYSTEM_ADMIN_ONLY;

    static void init(RightManager rm) throws ServiceException {
        PR_GET_ATTRS = (AttrRight)AdminRight.newAdminSystemRight("PSEUDO_GET_ATTRS", Right.RightType.getAttrs);
        PR_SET_ATTRS = (AttrRight)AdminRight.newAdminSystemRight("PSEUDO_SET_ATTRS", Right.RightType.setAttrs);
        PR_ALWAYS_ALLOW = AdminRight.newAdminSystemRight("PSEUDO_ALWAYS_ALLOW", Right.RightType.preset);
        PR_SYSTEM_ADMIN_ONLY = AdminRight.newAdminSystemRight("PSEUDO_SYSTEM_ADMIN_ONLY", Right.RightType.preset);
        AdminRights.init(rm);
    }

    protected AdminRight(String name, Right.RightType rightType) {
        super(name, rightType);
    }

    static AdminRight newAdminSystemRight(String name, Right.RightType rightType) {
        return AdminRight.newAdminRight(name, rightType);
    }

    private static AdminRight newAdminRight(String name, Right.RightType rightType) {
        if (rightType == Right.RightType.getAttrs || rightType == Right.RightType.setAttrs) {
            return new AttrRight(name, rightType);
        }
        if (rightType == Right.RightType.combo) {
            return new ComboRight(name);
        }
        return new PresetRight(name);
    }
}

