/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.accesscontrol.Right;

public class AccessControlUtil {
    public static boolean isGlobalAdmin(Account acct, boolean asAdmin) {
        return asAdmin && acct != null && acct.getBooleanAttr("zimbraIsAdminAccount", false);
    }

    static boolean isDelegatedAdmin(Account acct, boolean asAdmin) {
        return asAdmin && acct != null && acct.getBooleanAttr("zimbraIsDelegatedAdminAccount", false);
    }

    public static Boolean checkHardRules(Account authedAcct, boolean asAdmin, Entry target, Right right) throws ServiceException {
        boolean isAdminRight;
        if (AccessControlUtil.isGlobalAdmin(authedAcct, asAdmin)) {
            return Boolean.TRUE;
        }
        boolean bl = isAdminRight = right == null || !right.isUserRight();
        if (isAdminRight) {
            if (!AccessControlUtil.isDelegatedAdmin(authedAcct, asAdmin)) {
                throw ServiceException.PERM_DENIED("not an eligible admin account");
            }
            if (target instanceof Account && AccessControlUtil.isGlobalAdmin((Account)target, true)) {
                throw ServiceException.PERM_DENIED("delegated admin is not allowed to access a global admin's account");
            }
        }
        return null;
    }
}

