/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.accesscontrol.ZimbraACE;
import com.zimbra.cs.account.accesscontrol.ZimbraACL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLUtil {
    private static final String ACL_CACHE_KEY = "ENTRY.ACL_CACHE";

    public static List<ZimbraACE> getAllACEs(Entry entry) throws ServiceException {
        ZimbraACL acl = ACLUtil.getACL(entry);
        if (acl != null) {
            return acl.getAllACEs();
        }
        return null;
    }

    public static Set<ZimbraACE> getAllowedNotDelegableACEs(Entry entry) throws ServiceException {
        ZimbraACL acl = ACLUtil.getACL(entry);
        if (acl != null) {
            return acl.getAllowedNotDelegableACEs();
        }
        return null;
    }

    public static Set<ZimbraACE> getAllowedDelegableACEs(Entry entry) throws ServiceException {
        ZimbraACL acl = ACLUtil.getACL(entry);
        if (acl != null) {
            return acl.getAllowedDelegableACEs();
        }
        return null;
    }

    public static Set<ZimbraACE> getDeniedACEs(Entry entry) throws ServiceException {
        ZimbraACL acl = ACLUtil.getACL(entry);
        if (acl != null) {
            return acl.getDeniedACEs();
        }
        return null;
    }

    public static List<ZimbraACE> getACEs(Entry entry, Set<Right> rights) throws ServiceException {
        ZimbraACL acl = ACLUtil.getACL(entry);
        if (acl != null) {
            return acl.getACEs(rights);
        }
        return null;
    }

    public static List<ZimbraACE> grantRight(Provisioning prov, Entry target, Set<ZimbraACE> aces) throws ServiceException {
        for (ZimbraACE ace : aces) {
            ZimbraACE.validate(ace);
        }
        ZimbraACL acl = ACLUtil.getACL(target);
        List<ZimbraACE> granted = null;
        if (acl == null) {
            acl = new ZimbraACL(aces);
            granted = acl.getAllACEs();
        } else {
            acl = acl.clone();
            granted = acl.grantAccess(aces);
        }
        ACLUtil.serialize(prov, target, acl);
        return granted;
    }

    public static List<ZimbraACE> revokeRight(Provisioning prov, Entry target, Set<ZimbraACE> aces) throws ServiceException {
        ZimbraACL acl = ACLUtil.getACL(target);
        if (acl == null) {
            return new ArrayList<ZimbraACE>();
        }
        acl = acl.clone();
        List<ZimbraACE> revoked = acl.revokeAccess(aces);
        ACLUtil.serialize(prov, target, acl);
        return revoked;
    }

    private static void serialize(Provisioning prov, Entry entry, ZimbraACL acl) throws ServiceException {
        HashMap<String, List<String>> attrs = new HashMap<String, List<String>>();
        attrs.put("zimbraACE", acl.serialize());
        prov.modifyAttrs(entry, attrs);
    }

    static ZimbraACL getACL(Entry entry) throws ServiceException {
        ZimbraACL acl = (ZimbraACL)entry.getCachedData(ACL_CACHE_KEY);
        if (acl != null) {
            return acl;
        }
        String[] aces = entry.getMultiAttr("zimbraACE");
        if (aces.length == 0) {
            return null;
        }
        acl = new ZimbraACL(aces, TargetType.getTargetType(entry), entry.getLabel());
        entry.setCachedData(ACL_CACHE_KEY, acl);
        return acl;
    }
}

