/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account.accesscontrol;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.EmailUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.DomainAccessManager;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.AccessControlUtil;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AllowedAttrs;
import com.zimbra.cs.account.accesscontrol.AttrRight;
import com.zimbra.cs.account.accesscontrol.ComboRight;
import com.zimbra.cs.account.accesscontrol.PseudoTarget;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightBearer;
import com.zimbra.cs.account.accesscontrol.RightChecker;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.mailbox.ACL;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLAccessManager
extends AccessManager {
    public ACLAccessManager() throws ServiceException {
        RightManager.getInstance();
    }

    @Override
    public boolean isDomainAdminOnly(AuthToken at) {
        return false;
    }

    @Override
    public boolean canAccessAccount(AuthToken at, Account target, boolean asAdmin) throws ServiceException {
        this.checkDomainStatus(target);
        if (this.isParentOf(at, target)) {
            return true;
        }
        if (asAdmin) {
            return this.canDo(at, (Entry)target, (Right)Rights.Admin.R_adminLoginAs, asAdmin);
        }
        return this.canDo(at, (Entry)target, (Right)Rights.User.R_loginAs, asAdmin);
    }

    @Override
    public boolean canAccessAccount(AuthToken at, Account target) throws ServiceException {
        return this.canAccessAccount(at, target, true);
    }

    @Override
    public boolean canAccessAccount(Account credentials, Account target, boolean asAdmin) throws ServiceException {
        this.checkDomainStatus(target);
        if (this.isParentOf(credentials, target)) {
            return true;
        }
        if (asAdmin) {
            return this.canDo(credentials, (Entry)target, (Right)Rights.Admin.R_adminLoginAs, asAdmin);
        }
        return this.canDo(credentials, (Entry)target, (Right)Rights.User.R_loginAs, asAdmin);
    }

    @Override
    public boolean canAccessAccount(Account credentials, Account target) throws ServiceException {
        return this.canAccessAccount(credentials, target, true);
    }

    @Override
    public boolean canAccessCos(AuthToken at, Cos cos) throws ServiceException {
        return false;
    }

    @Override
    public boolean canAccessDomain(AuthToken at, String domainName) throws ServiceException {
        throw ServiceException.FAILURE("internal error", null);
    }

    @Override
    public boolean canAccessDomain(AuthToken at, Domain domain) throws ServiceException {
        throw ServiceException.FAILURE("internal error", null);
    }

    @Override
    public boolean canAccessEmail(AuthToken at, String email) throws ServiceException {
        throw ServiceException.FAILURE("internal error", null);
    }

    @Override
    public boolean canModifyMailQuota(AuthToken at, Account targetAccount, long mailQuota) throws ServiceException {
        return DomainAccessManager.canSetMailQuota(at, targetAccount, mailQuota);
    }

    @Override
    public boolean canDo(Account grantee, Entry target, Right rightNeeded, boolean asAdmin) {
        try {
            return this.canDo(grantee, target, rightNeeded, asAdmin, null);
        }
        catch (ServiceException e) {
            ZimbraLog.acl.warn((Object)"right denied", e);
            return false;
        }
    }

    @Override
    public boolean canDo(AuthToken grantee, Entry target, Right rightNeeded, boolean asAdmin) {
        try {
            return this.canDo(grantee, target, rightNeeded, asAdmin, null);
        }
        catch (ServiceException e) {
            ZimbraLog.acl.warn((Object)"right denied", e);
            return false;
        }
    }

    @Override
    public boolean canDo(String granteeEmail, Entry target, Right rightNeeded, boolean asAdmin) {
        try {
            return this.canDo(granteeEmail, target, rightNeeded, asAdmin, null);
        }
        catch (ServiceException e) {
            ZimbraLog.acl.warn((Object)"right denied", e);
            return false;
        }
    }

    @Override
    public boolean canDo(Account grantee, Entry target, Right rightNeeded, boolean asAdmin, AccessManager.ViaGrant via) throws ServiceException {
        Boolean hardRulesResult = AccessControlUtil.checkHardRules(grantee, asAdmin, target, rightNeeded);
        if (hardRulesResult != null) {
            return hardRulesResult;
        }
        if (asAdmin) {
            if (rightNeeded == AdminRight.PR_ALWAYS_ALLOW) {
                return true;
            }
            if (rightNeeded == AdminRight.PR_SYSTEM_ADMIN_ONLY) {
                return false;
            }
        }
        return this.checkPresetRight(grantee, target, rightNeeded, false, asAdmin, via);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canDo(AuthToken grantee, Entry target, Right rightNeeded, boolean asAdmin, AccessManager.ViaGrant via) throws ServiceException {
        try {
            Account granteeAcct;
            if (grantee == null) {
                if (!rightNeeded.isUserRight()) return false;
                granteeAcct = ACL.ANONYMOUS_ACCT;
                return this.canDo(granteeAcct, target, rightNeeded, asAdmin, via);
            } else if (grantee.isZimbraUser()) {
                granteeAcct = this.getAccountFromAuthToken(grantee);
                return this.canDo(granteeAcct, target, rightNeeded, asAdmin, via);
            } else {
                if (!rightNeeded.isUserRight()) return false;
                granteeAcct = new ACL.GuestAccount(grantee);
            }
            return this.canDo(granteeAcct, target, rightNeeded, asAdmin, via);
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn((Object)("ACL checking failed: grantee=" + grantee.getAccountId() + ", target=" + target.getLabel() + ", right=" + rightNeeded.getName() + " => denied"), e);
            return false;
        }
    }

    @Override
    public boolean canDo(String granteeEmail, Entry target, Right rightNeeded, boolean asAdmin, AccessManager.ViaGrant via) throws ServiceException {
        try {
            Account granteeAcct = null;
            if (granteeEmail != null) {
                granteeAcct = Provisioning.getInstance().get(Provisioning.AccountBy.name, granteeEmail);
            }
            if (granteeAcct == null) {
                if (rightNeeded.isUserRight()) {
                    granteeAcct = ACL.ANONYMOUS_ACCT;
                } else {
                    return false;
                }
            }
            return this.canDo(granteeAcct, target, rightNeeded, asAdmin, via);
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn((Object)("ACL checking failed: grantee=" + granteeEmail + ", target=" + target.getLabel() + ", right=" + rightNeeded.getName() + " => denied"), e);
            return false;
        }
    }

    @Override
    public boolean canGetAttrs(Account grantee, Entry target, Set<String> attrsNeeded, boolean asAdmin) throws ServiceException {
        Boolean hardRulesResult = AccessControlUtil.checkHardRules(grantee, asAdmin, target, null);
        if (hardRulesResult != null) {
            return hardRulesResult;
        }
        return this.canGetAttrsInternal(grantee, target, attrsNeeded, false);
    }

    @Override
    public boolean canGetAttrs(AuthToken grantee, Entry target, Set<String> attrs, boolean asAdmin) throws ServiceException {
        return this.canGetAttrs(this.getAccountFromAuthToken(grantee), target, attrs, asAdmin);
    }

    @Override
    public AccessManager.AttrRightChecker canGetAttrs(Account credentials, Entry target, boolean asAdmin) throws ServiceException {
        Boolean hardRulesResult = AccessControlUtil.checkHardRules(credentials, asAdmin, target, null);
        if (hardRulesResult == Boolean.TRUE) {
            return AllowedAttrs.ALLOW_ALL_ATTRS();
        }
        if (hardRulesResult == Boolean.FALSE) {
            return AllowedAttrs.DENY_ALL_ATTRS();
        }
        return RightChecker.accessibleAttrs(new RightBearer.Grantee(credentials), target, AdminRight.PR_GET_ATTRS, false);
    }

    @Override
    public AccessManager.AttrRightChecker canGetAttrs(AuthToken credentials, Entry target, boolean asAdmin) throws ServiceException {
        return this.canGetAttrs(this.getAccountFromAuthToken(credentials), target, asAdmin);
    }

    @Override
    public boolean canSetAttrs(Account grantee, Entry target, Set<String> attrsNeeded, boolean asAdmin) throws ServiceException {
        Boolean hardRulesResult = AccessControlUtil.checkHardRules(grantee, asAdmin, target, null);
        if (hardRulesResult != null) {
            return hardRulesResult;
        }
        return this.canSetAttrsInternal(grantee, target, attrsNeeded, false);
    }

    @Override
    public boolean canSetAttrs(AuthToken grantee, Entry target, Set<String> attrs, boolean asAdmin) throws ServiceException {
        return this.canSetAttrs(this.getAccountFromAuthToken(grantee), target, attrs, asAdmin);
    }

    @Override
    public boolean canSetAttrs(Account granteeAcct, Entry target, Map<String, Object> attrsNeeded, boolean asAdmin) throws ServiceException {
        Boolean hardRulesResult = AccessControlUtil.checkHardRules(granteeAcct, asAdmin, target, null);
        if (hardRulesResult != null) {
            return hardRulesResult;
        }
        RightBearer.Grantee grantee = new RightBearer.Grantee(granteeAcct);
        AllowedAttrs allowedAttrs = RightChecker.accessibleAttrs(grantee, target, AdminRight.PR_SET_ATTRS, false);
        return allowedAttrs.canSetAttrs(grantee, target, attrsNeeded);
    }

    @Override
    public boolean canSetAttrs(AuthToken grantee, Entry target, Map<String, Object> attrs, boolean asAdmin) throws ServiceException {
        return this.canSetAttrs(this.getAccountFromAuthToken(grantee), target, attrs, asAdmin);
    }

    @Override
    public boolean canSetAttrsOnCreate(Account grantee, TargetType targetType, String entryName, Map<String, Object> attrs, boolean asAdmin) throws ServiceException {
        Provisioning.DomainBy domainBy = null;
        String domainStr = null;
        Provisioning.CosBy cosBy = null;
        String cosStr = null;
        if (targetType == TargetType.account || targetType == TargetType.calresource || targetType == TargetType.dl) {
            String[] parts = EmailUtil.getLocalPartAndDomain(entryName);
            if (parts == null) {
                throw ServiceException.INVALID_REQUEST("must be valid email address: " + entryName, null);
            }
            domainBy = Provisioning.DomainBy.name;
            domainStr = parts[1];
        }
        if ((targetType == TargetType.account || targetType == TargetType.calresource) && (cosStr = (String)attrs.get("zimbraCOSId")) != null) {
            cosBy = LdapUtil.isValidUUID(cosStr) ? Provisioning.CosBy.id : Provisioning.CosBy.name;
        }
        Entry target = PseudoTarget.createPseudoTarget(Provisioning.getInstance(), targetType, domainBy, domainStr, false, cosBy, cosStr);
        return this.canSetAttrs(grantee, target, attrs, asAdmin);
    }

    @Override
    public boolean canPerform(Account grantee, Entry target, Right rightNeeded, boolean canDelegateNeeded, Map<String, Object> attrs, boolean asAdmin, AccessManager.ViaGrant viaGrant) throws ServiceException {
        Boolean hardRulesResult = AccessControlUtil.checkHardRules(grantee, asAdmin, target, rightNeeded);
        if (hardRulesResult != null) {
            return hardRulesResult;
        }
        boolean allowed = false;
        if (rightNeeded.isPresetRight()) {
            allowed = this.checkPresetRight(grantee, target, rightNeeded, canDelegateNeeded, asAdmin, viaGrant);
        } else if (rightNeeded.isAttrRight()) {
            AttrRight attrRight = (AttrRight)rightNeeded;
            allowed = this.checkAttrRight(grantee, target, (AttrRight)rightNeeded, canDelegateNeeded, attrs, asAdmin);
        } else if (rightNeeded.isComboRight()) {
            ComboRight comboRight = (ComboRight)rightNeeded;
            for (Right right : comboRight.getAllRights()) {
                if (this.canPerform(grantee, target, right, canDelegateNeeded, attrs, asAdmin, null)) continue;
                return false;
            }
            allowed = true;
        }
        return allowed;
    }

    @Override
    public boolean canPerform(AuthToken grantee, Entry target, Right rightNeeded, boolean canDelegate, Map<String, Object> attrs, boolean asAdmin, AccessManager.ViaGrant viaGrant) throws ServiceException {
        Account authedAcct = this.getAccountFromAuthToken(grantee);
        return this.canPerform(authedAcct, target, rightNeeded, canDelegate, attrs, asAdmin, viaGrant);
    }

    private boolean checkPresetRight(Account grantee, Entry target, Right rightNeeded, boolean canDelegateNeeded, boolean asAdmin, AccessManager.ViaGrant via) {
        try {
            if (grantee == null) {
                if (canDelegateNeeded) {
                    return false;
                }
                if (rightNeeded.isUserRight()) {
                    grantee = ACL.ANONYMOUS_ACCT;
                } else {
                    return false;
                }
            }
            if (rightNeeded.isUserRight()) {
                if (target instanceof Account) {
                    if (((Account)target).getId().equals(grantee.getId())) {
                        return true;
                    }
                    if (rightNeeded != Rights.User.R_loginAs && this.canAccessAccount(grantee, (Account)target, asAdmin)) {
                        return true;
                    }
                }
            } else if (target == null) {
                return false;
            }
            Boolean result = null;
            if (target != null) {
                result = RightChecker.checkPresetRight(grantee, target, rightNeeded, canDelegateNeeded, via);
            }
            if (result != null) {
                return result;
            }
            if (canDelegateNeeded) {
                return false;
            }
            Boolean defaultValue = rightNeeded.getDefault();
            if (defaultValue != null) {
                return defaultValue;
            }
        }
        catch (ServiceException e) {
            ZimbraLog.account.warn((Object)("ACL checking failed: grantee=" + grantee.getName() + ", target=" + target.getLabel() + ", right=" + rightNeeded.getName() + " => denied"), e);
        }
        return false;
    }

    private boolean checkAttrRight(Account grantee, Entry target, AttrRight rightNeeded, boolean canDelegateNeeded, Map<String, Object> attrs, boolean asAdmin) throws ServiceException {
        TargetType targetType = TargetType.getTargetType(target);
        if (!RightChecker.rightApplicableOnTargetType(targetType, rightNeeded, canDelegateNeeded)) {
            return false;
        }
        boolean allowed = false;
        if (rightNeeded.getRightType() == Right.RightType.getAttrs) {
            allowed = this.checkAttrRight(grantee, target, rightNeeded, canDelegateNeeded);
        } else if (attrs == null || attrs.isEmpty()) {
            allowed = this.checkAttrRight(grantee, target, rightNeeded, canDelegateNeeded);
        } else {
            if (canDelegateNeeded) {
                throw ServiceException.FAILURE("internal error", null);
            }
            allowed = this.canSetAttrs(grantee, target, attrs, asAdmin);
        }
        return allowed;
    }

    private boolean checkAttrRight(Account granteeAcct, Entry target, AttrRight rightNeeded, boolean canDelegateNeeded) throws ServiceException {
        AllowedAttrs allowedAttrs = RightChecker.accessibleAttrs(new RightBearer.Grantee(granteeAcct), target, rightNeeded, canDelegateNeeded);
        return allowedAttrs.canAccessAttrs(rightNeeded.getAttrs(), target);
    }

    private boolean canGetAttrsInternal(Account granteeAcct, Entry target, Set<String> attrsNeeded, boolean canDelegateNeeded) throws ServiceException {
        AllowedAttrs allowedAttrs = RightChecker.accessibleAttrs(new RightBearer.Grantee(granteeAcct), target, AdminRight.PR_GET_ATTRS, canDelegateNeeded);
        return allowedAttrs.canAccessAttrs(attrsNeeded, target);
    }

    private boolean canSetAttrsInternal(Account granteeAcct, Entry target, Set<String> attrsNeeded, boolean canDelegateNeeded) throws ServiceException {
        AllowedAttrs allowedAttrs = RightChecker.accessibleAttrs(new RightBearer.Grantee(granteeAcct), target, AdminRight.PR_SET_ATTRS, canDelegateNeeded);
        return allowedAttrs.canAccessAttrs(attrsNeeded, target);
    }

    private Account getAccountFromAuthToken(AuthToken authToken) throws ServiceException {
        String acctId = authToken.getAccountId();
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.id, acctId);
        if (acct == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(acctId);
        }
        return acct;
    }

    public static void main(String[] args) {
    }
}

