/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.BlobMetaData;
import com.zimbra.common.util.BlobMetaDataEncodingException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.ZimbraCookie;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.AuthTokenKey;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.service.ZimbraAuthProvider;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;

public class ZimbraAuthToken
extends AuthToken {
    private static final String C_ID = "id";
    private static final String C_AID = "aid";
    private static final String C_EXP = "exp";
    private static final String C_ADMIN = "admin";
    private static final String C_DOMAIN = "domain";
    private static final String C_DLGADMIN = "dlgadmin";
    private static final String C_TYPE = "type";
    private static final String C_TYPE_ZIMBRA_USER = "zimbra";
    private static final String C_TYPE_EXTERNAL_USER = "external";
    private static final String C_EXTERNAL_USER_EMAIL = "email";
    private static final String C_DIGEST = "digest";
    private static final String C_VALIDITY_VALUE = "vv";
    private static LRUMap mCache = new LRUMap(LC.zimbra_authtoken_cache_size.intValue());
    private static Log mLog = LogFactory.getLog(AuthToken.class);
    private String mAccountId;
    private String mAdminAccountId;
    private int mValidityValue = -1;
    private long mExpires;
    private String mEncoded;
    private boolean mIsAdmin;
    private boolean mIsDomainAdmin;
    private boolean mIsDelegatedAdmin;
    private String mType;
    private String mExternalUserEmail;
    private String mDigest;
    private String mAccessKey;
    private String mProxyAuthToken;

    public String toString() {
        return "AuthToken(acct=" + this.mAccountId + " admin=" + this.mAdminAccountId + " exp=" + this.mExpires + " isAdm=" + this.mIsAdmin + " isDomAd=" + this.mIsDomainAdmin + " isDlgAd=" + this.mIsDelegatedAdmin + ")";
    }

    protected static AuthTokenKey getCurrentKey() throws AuthTokenException {
        try {
            AuthTokenKey key = AuthTokenKey.getCurrentKey();
            return key;
        }
        catch (ServiceException e) {
            mLog.fatal((Object)"unable to get latest AuthTokenKey", e);
            throw new AuthTokenException("unable to get AuthTokenKey", e);
        }
    }

    public static synchronized AuthToken getAuthToken(String encoded) throws AuthTokenException {
        ZimbraAuthToken at = (ZimbraAuthToken)mCache.get((Object)encoded);
        if (at == null) {
            at = new ZimbraAuthToken(encoded);
            if (!at.isExpired()) {
                mCache.put((Object)encoded, (Object)at);
            }
        } else if (at.isExpired()) {
            mCache.remove((Object)encoded);
        }
        return at;
    }

    public static AuthToken getZimbraAdminAuthToken() throws ServiceException {
        Account acct = Provisioning.getInstance().get(Provisioning.AccountBy.adminName, LC.zimbra_ldap_user.value());
        return new ZimbraAuthToken(acct, true);
    }

    protected ZimbraAuthToken() {
    }

    public static Map getInfo(String encoded) throws AuthTokenException {
        String[] parts = encoded.split("_");
        if (parts.length != 3) {
            throw new AuthTokenException("invalid authtoken format");
        }
        return ZimbraAuthToken.getAttrs(parts[2]);
    }

    private static Map getAttrs(String data) throws AuthTokenException {
        try {
            String decoded = new String(Hex.decodeHex((char[])data.toCharArray()));
            return BlobMetaData.decode(decoded);
        }
        catch (DecoderException e) {
            throw new AuthTokenException("decoding exception", e);
        }
        catch (BlobMetaDataEncodingException e) {
            throw new AuthTokenException("blob decoding exception", e);
        }
    }

    protected ZimbraAuthToken(String encoded) throws AuthTokenException {
        try {
            this.mEncoded = encoded;
            int pos = encoded.indexOf(95);
            if (pos == -1) {
                throw new AuthTokenException("invalid authtoken format");
            }
            String ver = encoded.substring(0, pos);
            int pos2 = encoded.indexOf(95, pos + 1);
            if (pos2 == -1) {
                throw new AuthTokenException("invalid authtoken format");
            }
            String hmac = encoded.substring(pos + 1, pos2);
            String data = encoded.substring(pos2 + 1);
            AuthTokenKey key = AuthTokenKey.getVersion(ver);
            if (key == null) {
                throw new AuthTokenException("unknown key version");
            }
            String computedHmac = this.getHmac(data, key.getKey());
            if (!computedHmac.equals(hmac)) {
                throw new AuthTokenException("hmac failure");
            }
            Map map = ZimbraAuthToken.getAttrs(data);
            this.mAccountId = (String)map.get(C_ID);
            this.mAdminAccountId = (String)map.get(C_AID);
            this.mExpires = Long.parseLong((String)map.get(C_EXP));
            String ia = (String)map.get(C_ADMIN);
            this.mIsAdmin = "1".equals(ia);
            String da = (String)map.get(C_DOMAIN);
            this.mIsDomainAdmin = "1".equals(da);
            String dlga = (String)map.get(C_DLGADMIN);
            this.mIsDelegatedAdmin = "1".equals(dlga);
            this.mType = (String)map.get(C_TYPE);
            this.mExternalUserEmail = (String)map.get(C_EXTERNAL_USER_EMAIL);
            this.mDigest = (String)map.get(C_DIGEST);
            String vv = (String)map.get(C_VALIDITY_VALUE);
            if (vv != null) {
                try {
                    this.mValidityValue = Integer.parseInt(vv);
                }
                catch (NumberFormatException e) {
                    this.mValidityValue = -1;
                }
            } else {
                this.mValidityValue = -1;
            }
        }
        catch (ServiceException e) {
            throw new AuthTokenException("service exception", e);
        }
    }

    public ZimbraAuthToken(Account acct) {
        this(acct, false);
    }

    public ZimbraAuthToken(Account acct, boolean isAdmin) {
        this(acct, 0L, isAdmin, null);
        long lifetime = this.mIsAdmin || this.mIsDomainAdmin || this.mIsDelegatedAdmin ? acct.getTimeInterval("zimbraAdminAuthTokenLifetime", 43200000L) : acct.getTimeInterval("zimbraAuthTokenLifetime", 43200000L);
        this.mExpires = System.currentTimeMillis() + lifetime;
    }

    public ZimbraAuthToken(Account acct, long expires) {
        this(acct, expires, false, null);
    }

    public ZimbraAuthToken(Account acct, long expires, boolean isAdmin, Account adminAcct) {
        this.mAccountId = acct.getId();
        this.mAdminAccountId = adminAcct != null ? adminAcct.getId() : null;
        this.mValidityValue = acct.getAuthTokenValidityValue();
        this.mExpires = expires;
        this.mIsAdmin = isAdmin && "TRUE".equals(acct.getAttr("zimbraIsAdminAccount"));
        this.mIsDomainAdmin = isAdmin && "TRUE".equals(acct.getAttr("zimbraIsDomainAdminAccount"));
        this.mIsDelegatedAdmin = isAdmin && "TRUE".equals(acct.getAttr("zimbraIsDelegatedAdminAccount"));
        this.mEncoded = null;
        if (acct instanceof ACL.GuestAccount) {
            this.mType = C_TYPE_EXTERNAL_USER;
            ACL.GuestAccount g = (ACL.GuestAccount)acct;
            this.mDigest = g.getDigest();
            this.mAccessKey = g.getAccessKey();
            this.mExternalUserEmail = g.getName();
        } else {
            this.mType = C_TYPE_ZIMBRA_USER;
        }
    }

    public ZimbraAuthToken(String acctId, String externalEmail, String pass, String digest, long expires) {
        this.mAccountId = acctId;
        this.mExpires = expires;
        this.mExternalUserEmail = externalEmail == null ? "public" : externalEmail;
        this.mDigest = digest != null ? digest : ZimbraAuthToken.generateDigest(externalEmail, pass);
        this.mType = C_TYPE_EXTERNAL_USER;
    }

    public String getAccountId() {
        return this.mAccountId;
    }

    public String getAdminAccountId() {
        return this.mAdminAccountId;
    }

    public long getExpires() {
        return this.mExpires;
    }

    public int getValidityValue() {
        return this.mValidityValue;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.mExpires;
    }

    public boolean isAdmin() {
        return this.mIsAdmin;
    }

    public boolean isDomainAdmin() {
        return this.mIsDomainAdmin;
    }

    public boolean isDelegatedAdmin() {
        return this.mIsDelegatedAdmin;
    }

    public boolean isZimbraUser() {
        return this.mType == null || this.mType.compareTo(C_TYPE_ZIMBRA_USER) == 0;
    }

    public String getExternalUserEmail() {
        return this.mExternalUserEmail;
    }

    public String getDigest() {
        return this.mDigest;
    }

    public String getAccessKey() {
        return this.mAccessKey;
    }

    public String getEncoded() throws AuthTokenException {
        if (this.mEncoded == null) {
            StringBuffer encodedBuff = new StringBuffer(64);
            BlobMetaData.encodeMetaData(C_ID, this.mAccountId, encodedBuff);
            BlobMetaData.encodeMetaData(C_EXP, Long.toString(this.mExpires), encodedBuff);
            if (this.mAdminAccountId != null) {
                BlobMetaData.encodeMetaData(C_AID, this.mAdminAccountId, encodedBuff);
            }
            if (this.mIsAdmin) {
                BlobMetaData.encodeMetaData(C_ADMIN, "1", encodedBuff);
            }
            if (this.mIsDomainAdmin) {
                BlobMetaData.encodeMetaData(C_DOMAIN, "1", encodedBuff);
            }
            if (this.mIsDelegatedAdmin) {
                BlobMetaData.encodeMetaData(C_DLGADMIN, "1", encodedBuff);
            }
            if (this.mValidityValue != -1) {
                BlobMetaData.encodeMetaData(C_VALIDITY_VALUE, this.mValidityValue, encodedBuff);
            }
            BlobMetaData.encodeMetaData(C_TYPE, this.mType, encodedBuff);
            BlobMetaData.encodeMetaData(C_EXTERNAL_USER_EMAIL, this.mExternalUserEmail, encodedBuff);
            BlobMetaData.encodeMetaData(C_DIGEST, this.mDigest, encodedBuff);
            String data = new String(Hex.encodeHex((byte[])encodedBuff.toString().getBytes()));
            AuthTokenKey key = ZimbraAuthToken.getCurrentKey();
            String hmac = this.getHmac(data, key.getKey());
            this.mEncoded = key.getVersion() + "_" + hmac + "_" + data;
        }
        return this.mEncoded;
    }

    private String getHmac(String data, byte[] key) {
        try {
            ByteKey bk = new ByteKey(key);
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(bk);
            return new String(Hex.encodeHex((byte[])mac.doFinal(data.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("fatal error", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("fatal error", e);
        }
    }

    public String getCrumb() throws AuthTokenException {
        String authToken = this.getEncoded();
        try {
            ByteKey bk = new ByteKey(ZimbraAuthToken.getCurrentKey().getKey());
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(bk);
            return new String(Hex.encodeHex((byte[])mac.doFinal(authToken.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("fatal error", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("fatal error", e);
        }
    }

    private String getOrigAuthData() throws ServiceException {
        String origAuthData = null;
        try {
            origAuthData = this.getEncoded();
            if (origAuthData == null) {
                throw ServiceException.FAILURE("unable to get encoded auth token", null);
            }
        }
        catch (AuthTokenException e) {
            throw ServiceException.FAILURE("unable to get encoded auth token", e);
        }
        return origAuthData;
    }

    public void encode(HttpClient client, HttpMethod method, boolean isAdminReq, String cookieDomain) throws ServiceException {
        String origAuthData = this.getOrigAuthData();
        HttpState state = new HttpState();
        client.setState(state);
        state.addCookie(new Cookie(cookieDomain, ZimbraAuthProvider.cookieName(isAdminReq), origAuthData, "/", null, false));
        client.getParams().setCookiePolicy("compatibility");
    }

    public void encode(HttpState state, boolean isAdminReq, String cookieDomain) throws ServiceException {
        String origAuthData = this.getOrigAuthData();
        state.addCookie(new Cookie(cookieDomain, ZimbraAuthProvider.cookieName(isAdminReq), origAuthData, "/", null, false));
    }

    public void encode(HttpServletResponse resp, boolean isAdminReq, boolean secureCookie) throws ServiceException {
        String origAuthData = this.getOrigAuthData();
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(ZimbraAuthProvider.cookieName(isAdminReq), origAuthData);
        ZimbraCookie.setAuthTokenCookieDomainPath(cookie, ZimbraCookie.PATH_ROOT);
        cookie.setSecure(secureCookie);
        resp.addCookie(cookie);
    }

    public void encodeAuthResp(Element parent, boolean isAdmin) throws ServiceException {
        if (isAdmin) {
            parent.addElement("authToken").setText(this.getOrigAuthData());
        } else {
            parent.addElement("authToken").setText(this.getOrigAuthData());
        }
    }

    public ZAuthToken toZAuthToken() throws ServiceException {
        return new ZAuthToken(this.getOrigAuthData(), this.mProxyAuthToken);
    }

    public void setProxyAuthToken(String encoded) {
        this.mProxyAuthToken = encoded;
    }

    public String getProxyAuthToken() {
        return this.mProxyAuthToken;
    }

    public void resetProxyAuthToken() {
        this.mProxyAuthToken = null;
    }

    public static void main(String[] args) throws ServiceException, AuthTokenException {
        Account a = Provisioning.getInstance().get(Provisioning.AccountBy.name, "user1@example.zimbra.com");
        ZimbraAuthToken at = new ZimbraAuthToken(a);
        long start = System.currentTimeMillis();
        String encoded = at.getEncoded();
        for (int i = 0; i < 1000; ++i) {
            new ZimbraAuthToken(encoded);
        }
        long finish = System.currentTimeMillis();
        System.out.println(finish - start);
        start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            ZimbraAuthToken.getAuthToken(encoded);
        }
        finish = System.currentTimeMillis();
        System.out.println(finish - start);
    }

    static class ByteKey
    implements SecretKey {
        private static final long serialVersionUID = -7237091299729195624L;
        private byte[] mKey;

        ByteKey(byte[] key) {
            this.mKey = (byte[])key.clone();
        }

        public byte[] getEncoded() {
            return this.mKey;
        }

        public String getAlgorithm() {
            return "HmacSHA1";
        }

        public String getFormat() {
            return "RAW";
        }
    }
}

