/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZAttr;
import com.zimbra.cs.account.ZAttrProvisioning;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZAttrServer
extends NamedEntry {
    public ZAttrServer(String name, String id, Map<String, Object> attrs, Map<String, Object> defaults, Provisioning prov) {
        super(name, id, attrs, defaults, prov);
    }

    @ZAttr(id=-1L)
    public String getCn() {
        return this.getAttr("cn", null);
    }

    @ZAttr(id=-1L)
    public void setCn(String cn) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("cn", cn);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=-1L)
    public Map<String, Object> setCn(String cn, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("cn", cn);
        return attrs;
    }

    @ZAttr(id=-1L)
    public void unsetCn() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("cn", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=-1L)
    public Map<String, Object> unsetCn(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("cn", "");
        return attrs;
    }

    @ZAttr(id=-1L)
    public String[] getDescription() {
        return this.getMultiAttr("description");
    }

    @ZAttr(id=-1L)
    public void setDescription(String[] description) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("description", description);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=-1L)
    public Map<String, Object> setDescription(String[] description, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("description", description);
        return attrs;
    }

    @ZAttr(id=-1L)
    public void addDescription(String description) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+description", description);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=-1L)
    public Map<String, Object> addDescription(String description, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+description", description);
        return attrs;
    }

    @ZAttr(id=-1L)
    public void removeDescription(String description) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-description", description);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=-1L)
    public Map<String, Object> removeDescription(String description, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-description", description);
        return attrs;
    }

    @ZAttr(id=-1L)
    public void unsetDescription() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("description", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=-1L)
    public Map<String, Object> unsetDescription(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("description", "");
        return attrs;
    }

    @ZAttr(id=659L)
    public String[] getACE() {
        return this.getMultiAttr("zimbraACE");
    }

    @ZAttr(id=659L)
    public void setACE(String[] zimbraACE) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraACE", zimbraACE);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=659L)
    public Map<String, Object> setACE(String[] zimbraACE, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraACE", zimbraACE);
        return attrs;
    }

    @ZAttr(id=659L)
    public void addACE(String zimbraACE) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraACE", zimbraACE);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=659L)
    public Map<String, Object> addACE(String zimbraACE, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraACE", zimbraACE);
        return attrs;
    }

    @ZAttr(id=659L)
    public void removeACE(String zimbraACE) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraACE", zimbraACE);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=659L)
    public Map<String, Object> removeACE(String zimbraACE, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraACE", zimbraACE);
        return attrs;
    }

    @ZAttr(id=659L)
    public void unsetACE() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraACE", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=659L)
    public Map<String, Object> unsetACE(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraACE", "");
        return attrs;
    }

    @ZAttr(id=155L)
    public int getAdminPort() {
        return this.getIntAttr("zimbraAdminPort", 7071);
    }

    @ZAttr(id=155L)
    public String getAdminPortAsString() {
        return this.getAttr("zimbraAdminPort", "7071");
    }

    @ZAttr(id=155L)
    public void setAdminPort(int zimbraAdminPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminPort", Integer.toString(zimbraAdminPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=155L)
    public Map<String, Object> setAdminPort(int zimbraAdminPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminPort", Integer.toString(zimbraAdminPort));
        return attrs;
    }

    @ZAttr(id=155L)
    public void setAdminPortAsString(String zimbraAdminPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminPort", zimbraAdminPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=155L)
    public Map<String, Object> setAdminPortAsString(String zimbraAdminPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminPort", zimbraAdminPort);
        return attrs;
    }

    @ZAttr(id=155L)
    public void unsetAdminPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=155L)
    public Map<String, Object> unsetAdminPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminPort", "");
        return attrs;
    }

    @ZAttr(id=497L)
    public String getAdminURL() {
        return this.getAttr("zimbraAdminURL", "/zimbraAdmin");
    }

    @ZAttr(id=497L)
    public void setAdminURL(String zimbraAdminURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminURL", zimbraAdminURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=497L)
    public Map<String, Object> setAdminURL(String zimbraAdminURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminURL", zimbraAdminURL);
        return attrs;
    }

    @ZAttr(id=497L)
    public void unsetAdminURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=497L)
    public Map<String, Object> unsetAdminURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminURL", "");
        return attrs;
    }

    @ZAttr(id=582L)
    public int getAttachmentsIndexedTextLimit() {
        return this.getIntAttr("zimbraAttachmentsIndexedTextLimit", 0x100000);
    }

    @ZAttr(id=582L)
    public void setAttachmentsIndexedTextLimit(int zimbraAttachmentsIndexedTextLimit) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsIndexedTextLimit", Integer.toString(zimbraAttachmentsIndexedTextLimit));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=582L)
    public Map<String, Object> setAttachmentsIndexedTextLimit(int zimbraAttachmentsIndexedTextLimit, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsIndexedTextLimit", Integer.toString(zimbraAttachmentsIndexedTextLimit));
        return attrs;
    }

    @ZAttr(id=582L)
    public void unsetAttachmentsIndexedTextLimit() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsIndexedTextLimit", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=582L)
    public Map<String, Object> unsetAttachmentsIndexedTextLimit(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsIndexedTextLimit", "");
        return attrs;
    }

    @ZAttr(id=239L)
    public String getAttachmentsScanURL() {
        return this.getAttr("zimbraAttachmentsScanURL", null);
    }

    @ZAttr(id=239L)
    public void setAttachmentsScanURL(String zimbraAttachmentsScanURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsScanURL", zimbraAttachmentsScanURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=239L)
    public Map<String, Object> setAttachmentsScanURL(String zimbraAttachmentsScanURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsScanURL", zimbraAttachmentsScanURL);
        return attrs;
    }

    @ZAttr(id=239L)
    public void unsetAttachmentsScanURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsScanURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=239L)
    public Map<String, Object> unsetAttachmentsScanURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsScanURL", "");
        return attrs;
    }

    @ZAttr(id=513L)
    public String getBackupAutoGroupedInterval() {
        return this.getAttr("zimbraBackupAutoGroupedInterval", "1d");
    }

    @ZAttr(id=513L)
    public void setBackupAutoGroupedInterval(String zimbraBackupAutoGroupedInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedInterval", zimbraBackupAutoGroupedInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=513L)
    public Map<String, Object> setBackupAutoGroupedInterval(String zimbraBackupAutoGroupedInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedInterval", zimbraBackupAutoGroupedInterval);
        return attrs;
    }

    @ZAttr(id=513L)
    public void unsetBackupAutoGroupedInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=513L)
    public Map<String, Object> unsetBackupAutoGroupedInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedInterval", "");
        return attrs;
    }

    @ZAttr(id=514L)
    public int getBackupAutoGroupedNumGroups() {
        return this.getIntAttr("zimbraBackupAutoGroupedNumGroups", 7);
    }

    @ZAttr(id=514L)
    public void setBackupAutoGroupedNumGroups(int zimbraBackupAutoGroupedNumGroups) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedNumGroups", Integer.toString(zimbraBackupAutoGroupedNumGroups));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=514L)
    public Map<String, Object> setBackupAutoGroupedNumGroups(int zimbraBackupAutoGroupedNumGroups, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedNumGroups", Integer.toString(zimbraBackupAutoGroupedNumGroups));
        return attrs;
    }

    @ZAttr(id=514L)
    public void unsetBackupAutoGroupedNumGroups() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedNumGroups", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=514L)
    public Map<String, Object> unsetBackupAutoGroupedNumGroups(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedNumGroups", "");
        return attrs;
    }

    @ZAttr(id=515L)
    public boolean isBackupAutoGroupedThrottled() {
        return this.getBooleanAttr("zimbraBackupAutoGroupedThrottled", false);
    }

    @ZAttr(id=515L)
    public void setBackupAutoGroupedThrottled(boolean zimbraBackupAutoGroupedThrottled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedThrottled", zimbraBackupAutoGroupedThrottled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=515L)
    public Map<String, Object> setBackupAutoGroupedThrottled(boolean zimbraBackupAutoGroupedThrottled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedThrottled", zimbraBackupAutoGroupedThrottled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=515L)
    public void unsetBackupAutoGroupedThrottled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedThrottled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=515L)
    public Map<String, Object> unsetBackupAutoGroupedThrottled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedThrottled", "");
        return attrs;
    }

    @ZAttr(id=512L)
    public ZAttrProvisioning.BackupMode getBackupMode() {
        try {
            String v = this.getAttr("zimbraBackupMode");
            return v == null ? ZAttrProvisioning.BackupMode.Standard : ZAttrProvisioning.BackupMode.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.BackupMode.Standard;
        }
    }

    @ZAttr(id=512L)
    public String getBackupModeAsString() {
        return this.getAttr("zimbraBackupMode", "Standard");
    }

    @ZAttr(id=512L)
    public void setBackupMode(ZAttrProvisioning.BackupMode zimbraBackupMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupMode", zimbraBackupMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=512L)
    public Map<String, Object> setBackupMode(ZAttrProvisioning.BackupMode zimbraBackupMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupMode", zimbraBackupMode.toString());
        return attrs;
    }

    @ZAttr(id=512L)
    public void setBackupModeAsString(String zimbraBackupMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupMode", zimbraBackupMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=512L)
    public Map<String, Object> setBackupModeAsString(String zimbraBackupMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupMode", zimbraBackupMode);
        return attrs;
    }

    @ZAttr(id=512L)
    public void unsetBackupMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=512L)
    public Map<String, Object> unsetBackupMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupMode", "");
        return attrs;
    }

    @ZAttr(id=459L)
    public String[] getBackupReportEmailRecipients() {
        return this.getMultiAttr("zimbraBackupReportEmailRecipients");
    }

    @ZAttr(id=459L)
    public void setBackupReportEmailRecipients(String[] zimbraBackupReportEmailRecipients) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=459L)
    public Map<String, Object> setBackupReportEmailRecipients(String[] zimbraBackupReportEmailRecipients, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        return attrs;
    }

    @ZAttr(id=459L)
    public void addBackupReportEmailRecipients(String zimbraBackupReportEmailRecipients) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=459L)
    public Map<String, Object> addBackupReportEmailRecipients(String zimbraBackupReportEmailRecipients, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        return attrs;
    }

    @ZAttr(id=459L)
    public void removeBackupReportEmailRecipients(String zimbraBackupReportEmailRecipients) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=459L)
    public Map<String, Object> removeBackupReportEmailRecipients(String zimbraBackupReportEmailRecipients, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        return attrs;
    }

    @ZAttr(id=459L)
    public void unsetBackupReportEmailRecipients() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupReportEmailRecipients", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=459L)
    public Map<String, Object> unsetBackupReportEmailRecipients(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailRecipients", "");
        return attrs;
    }

    @ZAttr(id=460L)
    public String getBackupReportEmailSender() {
        return this.getAttr("zimbraBackupReportEmailSender", null);
    }

    @ZAttr(id=460L)
    public void setBackupReportEmailSender(String zimbraBackupReportEmailSender) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupReportEmailSender", zimbraBackupReportEmailSender);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=460L)
    public Map<String, Object> setBackupReportEmailSender(String zimbraBackupReportEmailSender, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailSender", zimbraBackupReportEmailSender);
        return attrs;
    }

    @ZAttr(id=460L)
    public void unsetBackupReportEmailSender() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupReportEmailSender", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=460L)
    public Map<String, Object> unsetBackupReportEmailSender(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailSender", "");
        return attrs;
    }

    @ZAttr(id=461L)
    public String getBackupReportEmailSubjectPrefix() {
        return this.getAttr("zimbraBackupReportEmailSubjectPrefix", "ZCS Backup Report");
    }

    @ZAttr(id=461L)
    public void setBackupReportEmailSubjectPrefix(String zimbraBackupReportEmailSubjectPrefix) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupReportEmailSubjectPrefix", zimbraBackupReportEmailSubjectPrefix);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=461L)
    public Map<String, Object> setBackupReportEmailSubjectPrefix(String zimbraBackupReportEmailSubjectPrefix, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailSubjectPrefix", zimbraBackupReportEmailSubjectPrefix);
        return attrs;
    }

    @ZAttr(id=461L)
    public void unsetBackupReportEmailSubjectPrefix() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupReportEmailSubjectPrefix", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=461L)
    public Map<String, Object> unsetBackupReportEmailSubjectPrefix(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailSubjectPrefix", "");
        return attrs;
    }

    @ZAttr(id=1004L)
    public boolean isBackupSkipBlobs() {
        return this.getBooleanAttr("zimbraBackupSkipBlobs", false);
    }

    @ZAttr(id=1004L)
    public void setBackupSkipBlobs(boolean zimbraBackupSkipBlobs) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipBlobs", zimbraBackupSkipBlobs ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1004L)
    public Map<String, Object> setBackupSkipBlobs(boolean zimbraBackupSkipBlobs, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipBlobs", zimbraBackupSkipBlobs ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1004L)
    public void unsetBackupSkipBlobs() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipBlobs", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1004L)
    public Map<String, Object> unsetBackupSkipBlobs(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipBlobs", "");
        return attrs;
    }

    @ZAttr(id=1005L)
    public boolean isBackupSkipHsmBlobs() {
        return this.getBooleanAttr("zimbraBackupSkipHsmBlobs", false);
    }

    @ZAttr(id=1005L)
    public void setBackupSkipHsmBlobs(boolean zimbraBackupSkipHsmBlobs) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipHsmBlobs", zimbraBackupSkipHsmBlobs ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1005L)
    public Map<String, Object> setBackupSkipHsmBlobs(boolean zimbraBackupSkipHsmBlobs, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipHsmBlobs", zimbraBackupSkipHsmBlobs ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1005L)
    public void unsetBackupSkipHsmBlobs() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipHsmBlobs", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1005L)
    public Map<String, Object> unsetBackupSkipHsmBlobs(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipHsmBlobs", "");
        return attrs;
    }

    @ZAttr(id=1003L)
    public boolean isBackupSkipSearchIndex() {
        return this.getBooleanAttr("zimbraBackupSkipSearchIndex", false);
    }

    @ZAttr(id=1003L)
    public void setBackupSkipSearchIndex(boolean zimbraBackupSkipSearchIndex) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipSearchIndex", zimbraBackupSkipSearchIndex ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1003L)
    public Map<String, Object> setBackupSkipSearchIndex(boolean zimbraBackupSkipSearchIndex, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipSearchIndex", zimbraBackupSkipSearchIndex ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1003L)
    public void unsetBackupSkipSearchIndex() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipSearchIndex", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1003L)
    public Map<String, Object> unsetBackupSkipSearchIndex(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipSearchIndex", "");
        return attrs;
    }

    @ZAttr(id=458L)
    public String getBackupTarget() {
        return this.getAttr("zimbraBackupTarget", "/opt/zimbra/backup");
    }

    @ZAttr(id=458L)
    public void setBackupTarget(String zimbraBackupTarget) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupTarget", zimbraBackupTarget);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=458L)
    public Map<String, Object> setBackupTarget(String zimbraBackupTarget, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupTarget", zimbraBackupTarget);
        return attrs;
    }

    @ZAttr(id=458L)
    public void unsetBackupTarget() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupTarget", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=458L)
    public Map<String, Object> unsetBackupTarget(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupTarget", "");
        return attrs;
    }

    @ZAttr(id=820L)
    public boolean isCalendarCalDavClearTextPasswordEnabled() {
        return this.getBooleanAttr("zimbraCalendarCalDavClearTextPasswordEnabled", true);
    }

    @ZAttr(id=820L)
    public void setCalendarCalDavClearTextPasswordEnabled(boolean zimbraCalendarCalDavClearTextPasswordEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCalDavClearTextPasswordEnabled", zimbraCalendarCalDavClearTextPasswordEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=820L)
    public Map<String, Object> setCalendarCalDavClearTextPasswordEnabled(boolean zimbraCalendarCalDavClearTextPasswordEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavClearTextPasswordEnabled", zimbraCalendarCalDavClearTextPasswordEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=820L)
    public void unsetCalendarCalDavClearTextPasswordEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCalDavClearTextPasswordEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=820L)
    public Map<String, Object> unsetCalendarCalDavClearTextPasswordEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavClearTextPasswordEnabled", "");
        return attrs;
    }

    @ZAttr(id=661L)
    public int getCalendarRecurrenceDailyMaxDays() {
        return this.getIntAttr("zimbraCalendarRecurrenceDailyMaxDays", 730);
    }

    @ZAttr(id=661L)
    public void setCalendarRecurrenceDailyMaxDays(int zimbraCalendarRecurrenceDailyMaxDays) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceDailyMaxDays", Integer.toString(zimbraCalendarRecurrenceDailyMaxDays));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=661L)
    public Map<String, Object> setCalendarRecurrenceDailyMaxDays(int zimbraCalendarRecurrenceDailyMaxDays, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceDailyMaxDays", Integer.toString(zimbraCalendarRecurrenceDailyMaxDays));
        return attrs;
    }

    @ZAttr(id=661L)
    public void unsetCalendarRecurrenceDailyMaxDays() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceDailyMaxDays", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=661L)
    public Map<String, Object> unsetCalendarRecurrenceDailyMaxDays(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceDailyMaxDays", "");
        return attrs;
    }

    @ZAttr(id=660L)
    public int getCalendarRecurrenceMaxInstances() {
        return this.getIntAttr("zimbraCalendarRecurrenceMaxInstances", 0);
    }

    @ZAttr(id=660L)
    public void setCalendarRecurrenceMaxInstances(int zimbraCalendarRecurrenceMaxInstances) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceMaxInstances", Integer.toString(zimbraCalendarRecurrenceMaxInstances));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=660L)
    public Map<String, Object> setCalendarRecurrenceMaxInstances(int zimbraCalendarRecurrenceMaxInstances, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceMaxInstances", Integer.toString(zimbraCalendarRecurrenceMaxInstances));
        return attrs;
    }

    @ZAttr(id=660L)
    public void unsetCalendarRecurrenceMaxInstances() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceMaxInstances", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=660L)
    public Map<String, Object> unsetCalendarRecurrenceMaxInstances(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceMaxInstances", "");
        return attrs;
    }

    @ZAttr(id=663L)
    public int getCalendarRecurrenceMonthlyMaxMonths() {
        return this.getIntAttr("zimbraCalendarRecurrenceMonthlyMaxMonths", 360);
    }

    @ZAttr(id=663L)
    public void setCalendarRecurrenceMonthlyMaxMonths(int zimbraCalendarRecurrenceMonthlyMaxMonths) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceMonthlyMaxMonths", Integer.toString(zimbraCalendarRecurrenceMonthlyMaxMonths));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=663L)
    public Map<String, Object> setCalendarRecurrenceMonthlyMaxMonths(int zimbraCalendarRecurrenceMonthlyMaxMonths, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceMonthlyMaxMonths", Integer.toString(zimbraCalendarRecurrenceMonthlyMaxMonths));
        return attrs;
    }

    @ZAttr(id=663L)
    public void unsetCalendarRecurrenceMonthlyMaxMonths() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceMonthlyMaxMonths", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=663L)
    public Map<String, Object> unsetCalendarRecurrenceMonthlyMaxMonths(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceMonthlyMaxMonths", "");
        return attrs;
    }

    @ZAttr(id=665L)
    public int getCalendarRecurrenceOtherFrequencyMaxYears() {
        return this.getIntAttr("zimbraCalendarRecurrenceOtherFrequencyMaxYears", 1);
    }

    @ZAttr(id=665L)
    public void setCalendarRecurrenceOtherFrequencyMaxYears(int zimbraCalendarRecurrenceOtherFrequencyMaxYears) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceOtherFrequencyMaxYears", Integer.toString(zimbraCalendarRecurrenceOtherFrequencyMaxYears));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=665L)
    public Map<String, Object> setCalendarRecurrenceOtherFrequencyMaxYears(int zimbraCalendarRecurrenceOtherFrequencyMaxYears, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceOtherFrequencyMaxYears", Integer.toString(zimbraCalendarRecurrenceOtherFrequencyMaxYears));
        return attrs;
    }

    @ZAttr(id=665L)
    public void unsetCalendarRecurrenceOtherFrequencyMaxYears() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceOtherFrequencyMaxYears", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=665L)
    public Map<String, Object> unsetCalendarRecurrenceOtherFrequencyMaxYears(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceOtherFrequencyMaxYears", "");
        return attrs;
    }

    @ZAttr(id=662L)
    public int getCalendarRecurrenceWeeklyMaxWeeks() {
        return this.getIntAttr("zimbraCalendarRecurrenceWeeklyMaxWeeks", 520);
    }

    @ZAttr(id=662L)
    public void setCalendarRecurrenceWeeklyMaxWeeks(int zimbraCalendarRecurrenceWeeklyMaxWeeks) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceWeeklyMaxWeeks", Integer.toString(zimbraCalendarRecurrenceWeeklyMaxWeeks));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=662L)
    public Map<String, Object> setCalendarRecurrenceWeeklyMaxWeeks(int zimbraCalendarRecurrenceWeeklyMaxWeeks, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceWeeklyMaxWeeks", Integer.toString(zimbraCalendarRecurrenceWeeklyMaxWeeks));
        return attrs;
    }

    @ZAttr(id=662L)
    public void unsetCalendarRecurrenceWeeklyMaxWeeks() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceWeeklyMaxWeeks", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=662L)
    public Map<String, Object> unsetCalendarRecurrenceWeeklyMaxWeeks(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceWeeklyMaxWeeks", "");
        return attrs;
    }

    @ZAttr(id=664L)
    public int getCalendarRecurrenceYearlyMaxYears() {
        return this.getIntAttr("zimbraCalendarRecurrenceYearlyMaxYears", 100);
    }

    @ZAttr(id=664L)
    public void setCalendarRecurrenceYearlyMaxYears(int zimbraCalendarRecurrenceYearlyMaxYears) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceYearlyMaxYears", Integer.toString(zimbraCalendarRecurrenceYearlyMaxYears));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=664L)
    public Map<String, Object> setCalendarRecurrenceYearlyMaxYears(int zimbraCalendarRecurrenceYearlyMaxYears, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceYearlyMaxYears", Integer.toString(zimbraCalendarRecurrenceYearlyMaxYears));
        return attrs;
    }

    @ZAttr(id=664L)
    public void unsetCalendarRecurrenceYearlyMaxYears() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceYearlyMaxYears", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=664L)
    public Map<String, Object> unsetCalendarRecurrenceYearlyMaxYears(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceYearlyMaxYears", "");
        return attrs;
    }

    @ZAttr(id=508L)
    public ZAttrProvisioning.ClusterType getClusterType() {
        try {
            String v = this.getAttr("zimbraClusterType");
            return v == null ? ZAttrProvisioning.ClusterType.none : ZAttrProvisioning.ClusterType.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.ClusterType.none;
        }
    }

    @ZAttr(id=508L)
    public String getClusterTypeAsString() {
        return this.getAttr("zimbraClusterType", "none");
    }

    @ZAttr(id=508L)
    public void setClusterType(ZAttrProvisioning.ClusterType zimbraClusterType) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraClusterType", zimbraClusterType.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=508L)
    public Map<String, Object> setClusterType(ZAttrProvisioning.ClusterType zimbraClusterType, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraClusterType", zimbraClusterType.toString());
        return attrs;
    }

    @ZAttr(id=508L)
    public void setClusterTypeAsString(String zimbraClusterType) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraClusterType", zimbraClusterType);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=508L)
    public Map<String, Object> setClusterTypeAsString(String zimbraClusterType, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraClusterType", zimbraClusterType);
        return attrs;
    }

    @ZAttr(id=508L)
    public void unsetClusterType() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraClusterType", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=508L)
    public Map<String, Object> unsetClusterType(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraClusterType", "");
        return attrs;
    }

    @ZAttr(id=1023L)
    public long getContactRankingTableRefreshInterval() {
        return this.getTimeInterval("zimbraContactRankingTableRefreshInterval", 604800000L);
    }

    @ZAttr(id=1023L)
    public String getContactRankingTableRefreshIntervalAsString() {
        return this.getAttr("zimbraContactRankingTableRefreshInterval", "7d");
    }

    @ZAttr(id=1023L)
    public void setContactRankingTableRefreshInterval(String zimbraContactRankingTableRefreshInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraContactRankingTableRefreshInterval", zimbraContactRankingTableRefreshInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1023L)
    public Map<String, Object> setContactRankingTableRefreshInterval(String zimbraContactRankingTableRefreshInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraContactRankingTableRefreshInterval", zimbraContactRankingTableRefreshInterval);
        return attrs;
    }

    @ZAttr(id=1023L)
    public void unsetContactRankingTableRefreshInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraContactRankingTableRefreshInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1023L)
    public Map<String, Object> unsetContactRankingTableRefreshInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraContactRankingTableRefreshInterval", "");
        return attrs;
    }

    @ZAttr(id=776L)
    public String getConvertdURL() {
        return this.getAttr("zimbraConvertdURL", null);
    }

    @ZAttr(id=776L)
    public void setConvertdURL(String zimbraConvertdURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraConvertdURL", zimbraConvertdURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=776L)
    public Map<String, Object> setConvertdURL(String zimbraConvertdURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraConvertdURL", zimbraConvertdURL);
        return attrs;
    }

    @ZAttr(id=776L)
    public void unsetConvertdURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraConvertdURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=776L)
    public Map<String, Object> unsetConvertdURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraConvertdURL", "");
        return attrs;
    }

    @ZAttr(id=790L)
    public Date getCreateTimestamp() {
        return this.getGeneralizedTimeAttr("zimbraCreateTimestamp", null);
    }

    @ZAttr(id=790L)
    public String getCreateTimestampAsString() {
        return this.getAttr("zimbraCreateTimestamp", null);
    }

    @ZAttr(id=790L)
    public void setCreateTimestamp(Date zimbraCreateTimestamp) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(zimbraCreateTimestamp));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=790L)
    public Map<String, Object> setCreateTimestamp(Date zimbraCreateTimestamp, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(zimbraCreateTimestamp));
        return attrs;
    }

    @ZAttr(id=790L)
    public void setCreateTimestampAsString(String zimbraCreateTimestamp) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCreateTimestamp", zimbraCreateTimestamp);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=790L)
    public Map<String, Object> setCreateTimestampAsString(String zimbraCreateTimestamp, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCreateTimestamp", zimbraCreateTimestamp);
        return attrs;
    }

    @ZAttr(id=790L)
    public void unsetCreateTimestamp() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCreateTimestamp", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=790L)
    public Map<String, Object> unsetCreateTimestamp(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCreateTimestamp", "");
        return attrs;
    }

    @ZAttr(id=1038L)
    public long getDatabaseSlowSqlThreshold() {
        return this.getTimeInterval("zimbraDatabaseSlowSqlThreshold", 2000L);
    }

    @ZAttr(id=1038L)
    public String getDatabaseSlowSqlThresholdAsString() {
        return this.getAttr("zimbraDatabaseSlowSqlThreshold", "2s");
    }

    @ZAttr(id=1038L)
    public void setDatabaseSlowSqlThreshold(String zimbraDatabaseSlowSqlThreshold) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDatabaseSlowSqlThreshold", zimbraDatabaseSlowSqlThreshold);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1038L)
    public Map<String, Object> setDatabaseSlowSqlThreshold(String zimbraDatabaseSlowSqlThreshold, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDatabaseSlowSqlThreshold", zimbraDatabaseSlowSqlThreshold);
        return attrs;
    }

    @ZAttr(id=1038L)
    public void unsetDatabaseSlowSqlThreshold() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDatabaseSlowSqlThreshold", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1038L)
    public Map<String, Object> unsetDatabaseSlowSqlThreshold(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDatabaseSlowSqlThreshold", "");
        return attrs;
    }

    @ZAttr(id=227L)
    public long getFileUploadMaxSize() {
        return this.getLongAttr("zimbraFileUploadMaxSize", 0xA00000L);
    }

    @ZAttr(id=227L)
    public void setFileUploadMaxSize(long zimbraFileUploadMaxSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFileUploadMaxSize", Long.toString(zimbraFileUploadMaxSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=227L)
    public Map<String, Object> setFileUploadMaxSize(long zimbraFileUploadMaxSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFileUploadMaxSize", Long.toString(zimbraFileUploadMaxSize));
        return attrs;
    }

    @ZAttr(id=227L)
    public void unsetFileUploadMaxSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFileUploadMaxSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=227L)
    public Map<String, Object> unsetFileUploadMaxSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFileUploadMaxSize", "");
        return attrs;
    }

    @ZAttr(id=1026L)
    public long getFreebusyPropagationRetryInterval() {
        return this.getTimeInterval("zimbraFreebusyPropagationRetryInterval", 60000L);
    }

    @ZAttr(id=1026L)
    public String getFreebusyPropagationRetryIntervalAsString() {
        return this.getAttr("zimbraFreebusyPropagationRetryInterval", "1m");
    }

    @ZAttr(id=1026L)
    public void setFreebusyPropagationRetryInterval(String zimbraFreebusyPropagationRetryInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyPropagationRetryInterval", zimbraFreebusyPropagationRetryInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1026L)
    public Map<String, Object> setFreebusyPropagationRetryInterval(String zimbraFreebusyPropagationRetryInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyPropagationRetryInterval", zimbraFreebusyPropagationRetryInterval);
        return attrs;
    }

    @ZAttr(id=1026L)
    public void unsetFreebusyPropagationRetryInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyPropagationRetryInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1026L)
    public Map<String, Object> unsetFreebusyPropagationRetryInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyPropagationRetryInterval", "");
        return attrs;
    }

    @ZAttr(id=8L)
    public long getHsmAge() {
        return this.getTimeInterval("zimbraHsmAge", 2592000000L);
    }

    @ZAttr(id=8L)
    public String getHsmAgeAsString() {
        return this.getAttr("zimbraHsmAge", "30d");
    }

    @ZAttr(id=8L)
    public void setHsmAge(String zimbraHsmAge) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHsmAge", zimbraHsmAge);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=8L)
    public Map<String, Object> setHsmAge(String zimbraHsmAge, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHsmAge", zimbraHsmAge);
        return attrs;
    }

    @ZAttr(id=8L)
    public void unsetHsmAge() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHsmAge", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=8L)
    public Map<String, Object> unsetHsmAge(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHsmAge", "");
        return attrs;
    }

    @ZAttr(id=1024L)
    public String[] getHsmPolicy() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraHsmPolicy");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "message,document:before:-30days";
        }
        return stringArray;
    }

    @ZAttr(id=1024L)
    public void setHsmPolicy(String[] zimbraHsmPolicy) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraHsmPolicy", zimbraHsmPolicy);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1024L)
    public Map<String, Object> setHsmPolicy(String[] zimbraHsmPolicy, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHsmPolicy", zimbraHsmPolicy);
        return attrs;
    }

    @ZAttr(id=1024L)
    public void addHsmPolicy(String zimbraHsmPolicy) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraHsmPolicy", zimbraHsmPolicy);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1024L)
    public Map<String, Object> addHsmPolicy(String zimbraHsmPolicy, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraHsmPolicy", zimbraHsmPolicy);
        return attrs;
    }

    @ZAttr(id=1024L)
    public void removeHsmPolicy(String zimbraHsmPolicy) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraHsmPolicy", zimbraHsmPolicy);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1024L)
    public Map<String, Object> removeHsmPolicy(String zimbraHsmPolicy, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraHsmPolicy", zimbraHsmPolicy);
        return attrs;
    }

    @ZAttr(id=1024L)
    public void unsetHsmPolicy() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHsmPolicy", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1024L)
    public Map<String, Object> unsetHsmPolicy(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHsmPolicy", "");
        return attrs;
    }

    @ZAttr(id=1043L)
    public boolean isHttpDebugHandlerEnabled() {
        return this.getBooleanAttr("zimbraHttpDebugHandlerEnabled", true);
    }

    @ZAttr(id=1043L)
    public void setHttpDebugHandlerEnabled(boolean zimbraHttpDebugHandlerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpDebugHandlerEnabled", zimbraHttpDebugHandlerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1043L)
    public Map<String, Object> setHttpDebugHandlerEnabled(boolean zimbraHttpDebugHandlerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpDebugHandlerEnabled", zimbraHttpDebugHandlerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1043L)
    public void unsetHttpDebugHandlerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpDebugHandlerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1043L)
    public Map<String, Object> unsetHttpDebugHandlerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpDebugHandlerEnabled", "");
        return attrs;
    }

    @ZAttr(id=518L)
    public int getHttpNumThreads() {
        return this.getIntAttr("zimbraHttpNumThreads", 250);
    }

    @ZAttr(id=518L)
    public void setHttpNumThreads(int zimbraHttpNumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpNumThreads", Integer.toString(zimbraHttpNumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=518L)
    public Map<String, Object> setHttpNumThreads(int zimbraHttpNumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpNumThreads", Integer.toString(zimbraHttpNumThreads));
        return attrs;
    }

    @ZAttr(id=518L)
    public void unsetHttpNumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpNumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=518L)
    public Map<String, Object> unsetHttpNumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpNumThreads", "");
        return attrs;
    }

    @ZAttr(id=388L)
    public String[] getHttpProxyURL() {
        return this.getMultiAttr("zimbraHttpProxyURL");
    }

    @ZAttr(id=388L)
    public void setHttpProxyURL(String[] zimbraHttpProxyURL) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraHttpProxyURL", zimbraHttpProxyURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=388L)
    public Map<String, Object> setHttpProxyURL(String[] zimbraHttpProxyURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpProxyURL", zimbraHttpProxyURL);
        return attrs;
    }

    @ZAttr(id=388L)
    public void addHttpProxyURL(String zimbraHttpProxyURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraHttpProxyURL", zimbraHttpProxyURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=388L)
    public Map<String, Object> addHttpProxyURL(String zimbraHttpProxyURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraHttpProxyURL", zimbraHttpProxyURL);
        return attrs;
    }

    @ZAttr(id=388L)
    public void removeHttpProxyURL(String zimbraHttpProxyURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraHttpProxyURL", zimbraHttpProxyURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=388L)
    public Map<String, Object> removeHttpProxyURL(String zimbraHttpProxyURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraHttpProxyURL", zimbraHttpProxyURL);
        return attrs;
    }

    @ZAttr(id=388L)
    public void unsetHttpProxyURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpProxyURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=388L)
    public Map<String, Object> unsetHttpProxyURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpProxyURL", "");
        return attrs;
    }

    @ZAttr(id=519L)
    public int getHttpSSLNumThreads() {
        return this.getIntAttr("zimbraHttpSSLNumThreads", 50);
    }

    @ZAttr(id=519L)
    public void setHttpSSLNumThreads(int zimbraHttpSSLNumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpSSLNumThreads", Integer.toString(zimbraHttpSSLNumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=519L)
    public Map<String, Object> setHttpSSLNumThreads(int zimbraHttpSSLNumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpSSLNumThreads", Integer.toString(zimbraHttpSSLNumThreads));
        return attrs;
    }

    @ZAttr(id=519L)
    public void unsetHttpSSLNumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpSSLNumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=519L)
    public Map<String, Object> unsetHttpSSLNumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpSSLNumThreads", "");
        return attrs;
    }

    @ZAttr(id=567L)
    public String[] getIMBindAddress() {
        return this.getMultiAttr("zimbraIMBindAddress");
    }

    @ZAttr(id=567L)
    public void setIMBindAddress(String[] zimbraIMBindAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraIMBindAddress", zimbraIMBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=567L)
    public Map<String, Object> setIMBindAddress(String[] zimbraIMBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraIMBindAddress", zimbraIMBindAddress);
        return attrs;
    }

    @ZAttr(id=567L)
    public void addIMBindAddress(String zimbraIMBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraIMBindAddress", zimbraIMBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=567L)
    public Map<String, Object> addIMBindAddress(String zimbraIMBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraIMBindAddress", zimbraIMBindAddress);
        return attrs;
    }

    @ZAttr(id=567L)
    public void removeIMBindAddress(String zimbraIMBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraIMBindAddress", zimbraIMBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=567L)
    public Map<String, Object> removeIMBindAddress(String zimbraIMBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraIMBindAddress", zimbraIMBindAddress);
        return attrs;
    }

    @ZAttr(id=567L)
    public void unsetIMBindAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraIMBindAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=567L)
    public Map<String, Object> unsetIMBindAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraIMBindAddress", "");
        return attrs;
    }

    @Override
    @ZAttr(id=1L)
    public String getId() {
        return this.getAttr("zimbraId", null);
    }

    @ZAttr(id=1L)
    public void setId(String zimbraId) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraId", zimbraId);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1L)
    public Map<String, Object> setId(String zimbraId, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraId", zimbraId);
        return attrs;
    }

    @ZAttr(id=1L)
    public void unsetId() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraId", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1L)
    public Map<String, Object> unsetId(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraId", "");
        return attrs;
    }

    @ZAttr(id=178L)
    public String getImapAdvertisedName() {
        return this.getAttr("zimbraImapAdvertisedName", null);
    }

    @ZAttr(id=178L)
    public void setImapAdvertisedName(String zimbraImapAdvertisedName) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapAdvertisedName", zimbraImapAdvertisedName);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=178L)
    public Map<String, Object> setImapAdvertisedName(String zimbraImapAdvertisedName, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapAdvertisedName", zimbraImapAdvertisedName);
        return attrs;
    }

    @ZAttr(id=178L)
    public void unsetImapAdvertisedName() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapAdvertisedName", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=178L)
    public Map<String, Object> unsetImapAdvertisedName(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapAdvertisedName", "");
        return attrs;
    }

    @ZAttr(id=179L)
    public String[] getImapBindAddress() {
        return this.getMultiAttr("zimbraImapBindAddress");
    }

    @ZAttr(id=179L)
    public void setImapBindAddress(String[] zimbraImapBindAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraImapBindAddress", zimbraImapBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=179L)
    public Map<String, Object> setImapBindAddress(String[] zimbraImapBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindAddress", zimbraImapBindAddress);
        return attrs;
    }

    @ZAttr(id=179L)
    public void addImapBindAddress(String zimbraImapBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraImapBindAddress", zimbraImapBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=179L)
    public Map<String, Object> addImapBindAddress(String zimbraImapBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraImapBindAddress", zimbraImapBindAddress);
        return attrs;
    }

    @ZAttr(id=179L)
    public void removeImapBindAddress(String zimbraImapBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraImapBindAddress", zimbraImapBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=179L)
    public Map<String, Object> removeImapBindAddress(String zimbraImapBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraImapBindAddress", zimbraImapBindAddress);
        return attrs;
    }

    @ZAttr(id=179L)
    public void unsetImapBindAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapBindAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=179L)
    public Map<String, Object> unsetImapBindAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindAddress", "");
        return attrs;
    }

    @ZAttr(id=268L)
    public boolean isImapBindOnStartup() {
        return this.getBooleanAttr("zimbraImapBindOnStartup", true);
    }

    @ZAttr(id=268L)
    public void setImapBindOnStartup(boolean zimbraImapBindOnStartup) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapBindOnStartup", zimbraImapBindOnStartup ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=268L)
    public Map<String, Object> setImapBindOnStartup(boolean zimbraImapBindOnStartup, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindOnStartup", zimbraImapBindOnStartup ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=268L)
    public void unsetImapBindOnStartup() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapBindOnStartup", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=268L)
    public Map<String, Object> unsetImapBindOnStartup(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindOnStartup", "");
        return attrs;
    }

    @ZAttr(id=180L)
    public int getImapBindPort() {
        return this.getIntAttr("zimbraImapBindPort", 7143);
    }

    @ZAttr(id=180L)
    public String getImapBindPortAsString() {
        return this.getAttr("zimbraImapBindPort", "7143");
    }

    @ZAttr(id=180L)
    public void setImapBindPort(int zimbraImapBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapBindPort", Integer.toString(zimbraImapBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=180L)
    public Map<String, Object> setImapBindPort(int zimbraImapBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindPort", Integer.toString(zimbraImapBindPort));
        return attrs;
    }

    @ZAttr(id=180L)
    public void setImapBindPortAsString(String zimbraImapBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapBindPort", zimbraImapBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=180L)
    public Map<String, Object> setImapBindPortAsString(String zimbraImapBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindPort", zimbraImapBindPort);
        return attrs;
    }

    @ZAttr(id=180L)
    public void unsetImapBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=180L)
    public Map<String, Object> unsetImapBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindPort", "");
        return attrs;
    }

    @ZAttr(id=185L)
    public boolean isImapCleartextLoginEnabled() {
        return this.getBooleanAttr("zimbraImapCleartextLoginEnabled", false);
    }

    @ZAttr(id=185L)
    public void setImapCleartextLoginEnabled(boolean zimbraImapCleartextLoginEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapCleartextLoginEnabled", zimbraImapCleartextLoginEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=185L)
    public Map<String, Object> setImapCleartextLoginEnabled(boolean zimbraImapCleartextLoginEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapCleartextLoginEnabled", zimbraImapCleartextLoginEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=185L)
    public void unsetImapCleartextLoginEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapCleartextLoginEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=185L)
    public Map<String, Object> unsetImapCleartextLoginEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapCleartextLoginEnabled", "");
        return attrs;
    }

    @ZAttr(id=443L)
    public String[] getImapDisabledCapability() {
        return this.getMultiAttr("zimbraImapDisabledCapability");
    }

    @ZAttr(id=443L)
    public void setImapDisabledCapability(String[] zimbraImapDisabledCapability) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=443L)
    public Map<String, Object> setImapDisabledCapability(String[] zimbraImapDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        return attrs;
    }

    @ZAttr(id=443L)
    public void addImapDisabledCapability(String zimbraImapDisabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=443L)
    public Map<String, Object> addImapDisabledCapability(String zimbraImapDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        return attrs;
    }

    @ZAttr(id=443L)
    public void removeImapDisabledCapability(String zimbraImapDisabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=443L)
    public Map<String, Object> removeImapDisabledCapability(String zimbraImapDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        return attrs;
    }

    @ZAttr(id=443L)
    public void unsetImapDisabledCapability() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapDisabledCapability", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=443L)
    public Map<String, Object> unsetImapDisabledCapability(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapDisabledCapability", "");
        return attrs;
    }

    @ZAttr(id=693L)
    public boolean isImapExposeVersionOnBanner() {
        return this.getBooleanAttr("zimbraImapExposeVersionOnBanner", false);
    }

    @ZAttr(id=693L)
    public void setImapExposeVersionOnBanner(boolean zimbraImapExposeVersionOnBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapExposeVersionOnBanner", zimbraImapExposeVersionOnBanner ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=693L)
    public Map<String, Object> setImapExposeVersionOnBanner(boolean zimbraImapExposeVersionOnBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapExposeVersionOnBanner", zimbraImapExposeVersionOnBanner ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=693L)
    public void unsetImapExposeVersionOnBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapExposeVersionOnBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=693L)
    public Map<String, Object> unsetImapExposeVersionOnBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapExposeVersionOnBanner", "");
        return attrs;
    }

    @ZAttr(id=181L)
    public int getImapNumThreads() {
        return this.getIntAttr("zimbraImapNumThreads", 200);
    }

    @ZAttr(id=181L)
    public void setImapNumThreads(int zimbraImapNumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapNumThreads", Integer.toString(zimbraImapNumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=181L)
    public Map<String, Object> setImapNumThreads(int zimbraImapNumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapNumThreads", Integer.toString(zimbraImapNumThreads));
        return attrs;
    }

    @ZAttr(id=181L)
    public void unsetImapNumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapNumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=181L)
    public Map<String, Object> unsetImapNumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapNumThreads", "");
        return attrs;
    }

    @ZAttr(id=348L)
    public int getImapProxyBindPort() {
        return this.getIntAttr("zimbraImapProxyBindPort", 143);
    }

    @ZAttr(id=348L)
    public String getImapProxyBindPortAsString() {
        return this.getAttr("zimbraImapProxyBindPort", "143");
    }

    @ZAttr(id=348L)
    public void setImapProxyBindPort(int zimbraImapProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapProxyBindPort", Integer.toString(zimbraImapProxyBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=348L)
    public Map<String, Object> setImapProxyBindPort(int zimbraImapProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapProxyBindPort", Integer.toString(zimbraImapProxyBindPort));
        return attrs;
    }

    @ZAttr(id=348L)
    public void setImapProxyBindPortAsString(String zimbraImapProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapProxyBindPort", zimbraImapProxyBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=348L)
    public Map<String, Object> setImapProxyBindPortAsString(String zimbraImapProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapProxyBindPort", zimbraImapProxyBindPort);
        return attrs;
    }

    @ZAttr(id=348L)
    public void unsetImapProxyBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapProxyBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=348L)
    public Map<String, Object> unsetImapProxyBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapProxyBindPort", "");
        return attrs;
    }

    @ZAttr(id=182L)
    public String[] getImapSSLBindAddress() {
        return this.getMultiAttr("zimbraImapSSLBindAddress");
    }

    @ZAttr(id=182L)
    public void setImapSSLBindAddress(String[] zimbraImapSSLBindAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraImapSSLBindAddress", zimbraImapSSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=182L)
    public Map<String, Object> setImapSSLBindAddress(String[] zimbraImapSSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindAddress", zimbraImapSSLBindAddress);
        return attrs;
    }

    @ZAttr(id=182L)
    public void addImapSSLBindAddress(String zimbraImapSSLBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraImapSSLBindAddress", zimbraImapSSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=182L)
    public Map<String, Object> addImapSSLBindAddress(String zimbraImapSSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraImapSSLBindAddress", zimbraImapSSLBindAddress);
        return attrs;
    }

    @ZAttr(id=182L)
    public void removeImapSSLBindAddress(String zimbraImapSSLBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraImapSSLBindAddress", zimbraImapSSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=182L)
    public Map<String, Object> removeImapSSLBindAddress(String zimbraImapSSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraImapSSLBindAddress", zimbraImapSSLBindAddress);
        return attrs;
    }

    @ZAttr(id=182L)
    public void unsetImapSSLBindAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLBindAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=182L)
    public Map<String, Object> unsetImapSSLBindAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindAddress", "");
        return attrs;
    }

    @ZAttr(id=269L)
    public boolean isImapSSLBindOnStartup() {
        return this.getBooleanAttr("zimbraImapSSLBindOnStartup", true);
    }

    @ZAttr(id=269L)
    public void setImapSSLBindOnStartup(boolean zimbraImapSSLBindOnStartup) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLBindOnStartup", zimbraImapSSLBindOnStartup ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=269L)
    public Map<String, Object> setImapSSLBindOnStartup(boolean zimbraImapSSLBindOnStartup, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindOnStartup", zimbraImapSSLBindOnStartup ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=269L)
    public void unsetImapSSLBindOnStartup() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLBindOnStartup", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=269L)
    public Map<String, Object> unsetImapSSLBindOnStartup(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindOnStartup", "");
        return attrs;
    }

    @ZAttr(id=183L)
    public int getImapSSLBindPort() {
        return this.getIntAttr("zimbraImapSSLBindPort", 7993);
    }

    @ZAttr(id=183L)
    public String getImapSSLBindPortAsString() {
        return this.getAttr("zimbraImapSSLBindPort", "7993");
    }

    @ZAttr(id=183L)
    public void setImapSSLBindPort(int zimbraImapSSLBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLBindPort", Integer.toString(zimbraImapSSLBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=183L)
    public Map<String, Object> setImapSSLBindPort(int zimbraImapSSLBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindPort", Integer.toString(zimbraImapSSLBindPort));
        return attrs;
    }

    @ZAttr(id=183L)
    public void setImapSSLBindPortAsString(String zimbraImapSSLBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLBindPort", zimbraImapSSLBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=183L)
    public Map<String, Object> setImapSSLBindPortAsString(String zimbraImapSSLBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindPort", zimbraImapSSLBindPort);
        return attrs;
    }

    @ZAttr(id=183L)
    public void unsetImapSSLBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=183L)
    public Map<String, Object> unsetImapSSLBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindPort", "");
        return attrs;
    }

    @ZAttr(id=444L)
    public String[] getImapSSLDisabledCapability() {
        return this.getMultiAttr("zimbraImapSSLDisabledCapability");
    }

    @ZAttr(id=444L)
    public void setImapSSLDisabledCapability(String[] zimbraImapSSLDisabledCapability) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=444L)
    public Map<String, Object> setImapSSLDisabledCapability(String[] zimbraImapSSLDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        return attrs;
    }

    @ZAttr(id=444L)
    public void addImapSSLDisabledCapability(String zimbraImapSSLDisabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=444L)
    public Map<String, Object> addImapSSLDisabledCapability(String zimbraImapSSLDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        return attrs;
    }

    @ZAttr(id=444L)
    public void removeImapSSLDisabledCapability(String zimbraImapSSLDisabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=444L)
    public Map<String, Object> removeImapSSLDisabledCapability(String zimbraImapSSLDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        return attrs;
    }

    @ZAttr(id=444L)
    public void unsetImapSSLDisabledCapability() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLDisabledCapability", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=444L)
    public Map<String, Object> unsetImapSSLDisabledCapability(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLDisabledCapability", "");
        return attrs;
    }

    @ZAttr(id=349L)
    public int getImapSSLProxyBindPort() {
        return this.getIntAttr("zimbraImapSSLProxyBindPort", 993);
    }

    @ZAttr(id=349L)
    public String getImapSSLProxyBindPortAsString() {
        return this.getAttr("zimbraImapSSLProxyBindPort", "993");
    }

    @ZAttr(id=349L)
    public void setImapSSLProxyBindPort(int zimbraImapSSLProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLProxyBindPort", Integer.toString(zimbraImapSSLProxyBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=349L)
    public Map<String, Object> setImapSSLProxyBindPort(int zimbraImapSSLProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLProxyBindPort", Integer.toString(zimbraImapSSLProxyBindPort));
        return attrs;
    }

    @ZAttr(id=349L)
    public void setImapSSLProxyBindPortAsString(String zimbraImapSSLProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLProxyBindPort", zimbraImapSSLProxyBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=349L)
    public Map<String, Object> setImapSSLProxyBindPortAsString(String zimbraImapSSLProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLProxyBindPort", zimbraImapSSLProxyBindPort);
        return attrs;
    }

    @ZAttr(id=349L)
    public void unsetImapSSLProxyBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLProxyBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=349L)
    public Map<String, Object> unsetImapSSLProxyBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLProxyBindPort", "");
        return attrs;
    }

    @ZAttr(id=184L)
    public boolean isImapSSLServerEnabled() {
        return this.getBooleanAttr("zimbraImapSSLServerEnabled", true);
    }

    @ZAttr(id=184L)
    public void setImapSSLServerEnabled(boolean zimbraImapSSLServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLServerEnabled", zimbraImapSSLServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=184L)
    public Map<String, Object> setImapSSLServerEnabled(boolean zimbraImapSSLServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLServerEnabled", zimbraImapSSLServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=184L)
    public void unsetImapSSLServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=184L)
    public Map<String, Object> unsetImapSSLServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=555L)
    public boolean isImapSaslGssapiEnabled() {
        return this.getBooleanAttr("zimbraImapSaslGssapiEnabled", false);
    }

    @ZAttr(id=555L)
    public void setImapSaslGssapiEnabled(boolean zimbraImapSaslGssapiEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSaslGssapiEnabled", zimbraImapSaslGssapiEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=555L)
    public Map<String, Object> setImapSaslGssapiEnabled(boolean zimbraImapSaslGssapiEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSaslGssapiEnabled", zimbraImapSaslGssapiEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=555L)
    public void unsetImapSaslGssapiEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSaslGssapiEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=555L)
    public Map<String, Object> unsetImapSaslGssapiEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSaslGssapiEnabled", "");
        return attrs;
    }

    @ZAttr(id=176L)
    public boolean isImapServerEnabled() {
        return this.getBooleanAttr("zimbraImapServerEnabled", true);
    }

    @ZAttr(id=176L)
    public void setImapServerEnabled(boolean zimbraImapServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapServerEnabled", zimbraImapServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=176L)
    public Map<String, Object> setImapServerEnabled(boolean zimbraImapServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapServerEnabled", zimbraImapServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=176L)
    public void unsetImapServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=176L)
    public Map<String, Object> unsetImapServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=132L)
    public boolean isIsMonitorHost() {
        return this.getBooleanAttr("zimbraIsMonitorHost", false);
    }

    @ZAttr(id=132L)
    public void setIsMonitorHost(boolean zimbraIsMonitorHost) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraIsMonitorHost", zimbraIsMonitorHost ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=132L)
    public Map<String, Object> setIsMonitorHost(boolean zimbraIsMonitorHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraIsMonitorHost", zimbraIsMonitorHost ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=132L)
    public void unsetIsMonitorHost() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraIsMonitorHost", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=132L)
    public Map<String, Object> unsetIsMonitorHost(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraIsMonitorHost", "");
        return attrs;
    }

    @ZAttr(id=23L)
    public String getLmtpAdvertisedName() {
        return this.getAttr("zimbraLmtpAdvertisedName", null);
    }

    @ZAttr(id=23L)
    public void setLmtpAdvertisedName(String zimbraLmtpAdvertisedName) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpAdvertisedName", zimbraLmtpAdvertisedName);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=23L)
    public Map<String, Object> setLmtpAdvertisedName(String zimbraLmtpAdvertisedName, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpAdvertisedName", zimbraLmtpAdvertisedName);
        return attrs;
    }

    @ZAttr(id=23L)
    public void unsetLmtpAdvertisedName() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpAdvertisedName", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=23L)
    public Map<String, Object> unsetLmtpAdvertisedName(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpAdvertisedName", "");
        return attrs;
    }

    @ZAttr(id=25L)
    public String[] getLmtpBindAddress() {
        return this.getMultiAttr("zimbraLmtpBindAddress");
    }

    @ZAttr(id=25L)
    public void setLmtpBindAddress(String[] zimbraLmtpBindAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraLmtpBindAddress", zimbraLmtpBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=25L)
    public Map<String, Object> setLmtpBindAddress(String[] zimbraLmtpBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindAddress", zimbraLmtpBindAddress);
        return attrs;
    }

    @ZAttr(id=25L)
    public void addLmtpBindAddress(String zimbraLmtpBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraLmtpBindAddress", zimbraLmtpBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=25L)
    public Map<String, Object> addLmtpBindAddress(String zimbraLmtpBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraLmtpBindAddress", zimbraLmtpBindAddress);
        return attrs;
    }

    @ZAttr(id=25L)
    public void removeLmtpBindAddress(String zimbraLmtpBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraLmtpBindAddress", zimbraLmtpBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=25L)
    public Map<String, Object> removeLmtpBindAddress(String zimbraLmtpBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraLmtpBindAddress", zimbraLmtpBindAddress);
        return attrs;
    }

    @ZAttr(id=25L)
    public void unsetLmtpBindAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpBindAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=25L)
    public Map<String, Object> unsetLmtpBindAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindAddress", "");
        return attrs;
    }

    @ZAttr(id=270L)
    public boolean isLmtpBindOnStartup() {
        return this.getBooleanAttr("zimbraLmtpBindOnStartup", false);
    }

    @ZAttr(id=270L)
    public void setLmtpBindOnStartup(boolean zimbraLmtpBindOnStartup) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpBindOnStartup", zimbraLmtpBindOnStartup ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=270L)
    public Map<String, Object> setLmtpBindOnStartup(boolean zimbraLmtpBindOnStartup, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindOnStartup", zimbraLmtpBindOnStartup ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=270L)
    public void unsetLmtpBindOnStartup() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpBindOnStartup", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=270L)
    public Map<String, Object> unsetLmtpBindOnStartup(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindOnStartup", "");
        return attrs;
    }

    @ZAttr(id=24L)
    public int getLmtpBindPort() {
        return this.getIntAttr("zimbraLmtpBindPort", 7025);
    }

    @ZAttr(id=24L)
    public String getLmtpBindPortAsString() {
        return this.getAttr("zimbraLmtpBindPort", "7025");
    }

    @ZAttr(id=24L)
    public void setLmtpBindPort(int zimbraLmtpBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpBindPort", Integer.toString(zimbraLmtpBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=24L)
    public Map<String, Object> setLmtpBindPort(int zimbraLmtpBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindPort", Integer.toString(zimbraLmtpBindPort));
        return attrs;
    }

    @ZAttr(id=24L)
    public void setLmtpBindPortAsString(String zimbraLmtpBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpBindPort", zimbraLmtpBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=24L)
    public Map<String, Object> setLmtpBindPortAsString(String zimbraLmtpBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindPort", zimbraLmtpBindPort);
        return attrs;
    }

    @ZAttr(id=24L)
    public void unsetLmtpBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=24L)
    public Map<String, Object> unsetLmtpBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindPort", "");
        return attrs;
    }

    @ZAttr(id=691L)
    public boolean isLmtpExposeVersionOnBanner() {
        return this.getBooleanAttr("zimbraLmtpExposeVersionOnBanner", false);
    }

    @ZAttr(id=691L)
    public void setLmtpExposeVersionOnBanner(boolean zimbraLmtpExposeVersionOnBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpExposeVersionOnBanner", zimbraLmtpExposeVersionOnBanner ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=691L)
    public Map<String, Object> setLmtpExposeVersionOnBanner(boolean zimbraLmtpExposeVersionOnBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpExposeVersionOnBanner", zimbraLmtpExposeVersionOnBanner ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=691L)
    public void unsetLmtpExposeVersionOnBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpExposeVersionOnBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=691L)
    public Map<String, Object> unsetLmtpExposeVersionOnBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpExposeVersionOnBanner", "");
        return attrs;
    }

    @ZAttr(id=26L)
    public int getLmtpNumThreads() {
        return this.getIntAttr("zimbraLmtpNumThreads", 20);
    }

    @ZAttr(id=26L)
    public void setLmtpNumThreads(int zimbraLmtpNumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpNumThreads", Integer.toString(zimbraLmtpNumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=26L)
    public Map<String, Object> setLmtpNumThreads(int zimbraLmtpNumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpNumThreads", Integer.toString(zimbraLmtpNumThreads));
        return attrs;
    }

    @ZAttr(id=26L)
    public void unsetLmtpNumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpNumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=26L)
    public Map<String, Object> unsetLmtpNumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpNumThreads", "");
        return attrs;
    }

    @ZAttr(id=657L)
    public boolean isLmtpPermanentFailureWhenOverQuota() {
        return this.getBooleanAttr("zimbraLmtpPermanentFailureWhenOverQuota", false);
    }

    @ZAttr(id=657L)
    public void setLmtpPermanentFailureWhenOverQuota(boolean zimbraLmtpPermanentFailureWhenOverQuota) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpPermanentFailureWhenOverQuota", zimbraLmtpPermanentFailureWhenOverQuota ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=657L)
    public Map<String, Object> setLmtpPermanentFailureWhenOverQuota(boolean zimbraLmtpPermanentFailureWhenOverQuota, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpPermanentFailureWhenOverQuota", zimbraLmtpPermanentFailureWhenOverQuota ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=657L)
    public void unsetLmtpPermanentFailureWhenOverQuota() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpPermanentFailureWhenOverQuota", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=657L)
    public Map<String, Object> unsetLmtpPermanentFailureWhenOverQuota(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpPermanentFailureWhenOverQuota", "");
        return attrs;
    }

    @ZAttr(id=630L)
    public boolean isLmtpServerEnabled() {
        return this.getBooleanAttr("zimbraLmtpServerEnabled", true);
    }

    @ZAttr(id=630L)
    public void setLmtpServerEnabled(boolean zimbraLmtpServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpServerEnabled", zimbraLmtpServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=630L)
    public Map<String, Object> setLmtpServerEnabled(boolean zimbraLmtpServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpServerEnabled", zimbraLmtpServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=630L)
    public void unsetLmtpServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=630L)
    public Map<String, Object> unsetLmtpServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=345L)
    public String getLocaleAsString() {
        return this.getAttr("zimbraLocale", null);
    }

    @ZAttr(id=345L)
    public void setLocale(String zimbraLocale) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLocale", zimbraLocale);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=345L)
    public Map<String, Object> setLocale(String zimbraLocale, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLocale", zimbraLocale);
        return attrs;
    }

    @ZAttr(id=345L)
    public void unsetLocale() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLocale", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=345L)
    public Map<String, Object> unsetLocale(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLocale", "");
        return attrs;
    }

    @ZAttr(id=520L)
    public boolean isLogToSyslog() {
        return this.getBooleanAttr("zimbraLogToSyslog", false);
    }

    @ZAttr(id=520L)
    public void setLogToSyslog(boolean zimbraLogToSyslog) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLogToSyslog", zimbraLogToSyslog ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=520L)
    public Map<String, Object> setLogToSyslog(boolean zimbraLogToSyslog, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLogToSyslog", zimbraLogToSyslog ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=520L)
    public void unsetLogToSyslog() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLogToSyslog", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=520L)
    public Map<String, Object> unsetLogToSyslog(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLogToSyslog", "");
        return attrs;
    }

    @ZAttr(id=791L)
    public boolean isMailClearTextPasswordEnabled() {
        return this.getBooleanAttr("zimbraMailClearTextPasswordEnabled", true);
    }

    @ZAttr(id=791L)
    public void setMailClearTextPasswordEnabled(boolean zimbraMailClearTextPasswordEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailClearTextPasswordEnabled", zimbraMailClearTextPasswordEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=791L)
    public Map<String, Object> setMailClearTextPasswordEnabled(boolean zimbraMailClearTextPasswordEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailClearTextPasswordEnabled", zimbraMailClearTextPasswordEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=791L)
    public void unsetMailClearTextPasswordEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailClearTextPasswordEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=791L)
    public Map<String, Object> unsetMailClearTextPasswordEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailClearTextPasswordEnabled", "");
        return attrs;
    }

    @ZAttr(id=807L)
    public long getMailContentMaxSize() {
        return this.getLongAttr("zimbraMailContentMaxSize", 10240000L);
    }

    @ZAttr(id=807L)
    public void setMailContentMaxSize(long zimbraMailContentMaxSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailContentMaxSize", Long.toString(zimbraMailContentMaxSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=807L)
    public Map<String, Object> setMailContentMaxSize(long zimbraMailContentMaxSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailContentMaxSize", Long.toString(zimbraMailContentMaxSize));
        return attrs;
    }

    @ZAttr(id=807L)
    public void unsetMailContentMaxSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailContentMaxSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=807L)
    public Map<String, Object> unsetMailContentMaxSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailContentMaxSize", "");
        return attrs;
    }

    @ZAttr(id=565L)
    public int getMailDiskStreamingThreshold() {
        return this.getIntAttr("zimbraMailDiskStreamingThreshold", 0x100000);
    }

    @ZAttr(id=565L)
    public void setMailDiskStreamingThreshold(int zimbraMailDiskStreamingThreshold) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailDiskStreamingThreshold", Integer.toString(zimbraMailDiskStreamingThreshold));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=565L)
    public Map<String, Object> setMailDiskStreamingThreshold(int zimbraMailDiskStreamingThreshold, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailDiskStreamingThreshold", Integer.toString(zimbraMailDiskStreamingThreshold));
        return attrs;
    }

    @ZAttr(id=565L)
    public void unsetMailDiskStreamingThreshold() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailDiskStreamingThreshold", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=565L)
    public Map<String, Object> unsetMailDiskStreamingThreshold(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailDiskStreamingThreshold", "");
        return attrs;
    }

    @ZAttr(id=1035L)
    public int getMailFileDescriptorBufferSize() {
        return this.getIntAttr("zimbraMailFileDescriptorBufferSize", 4096);
    }

    @ZAttr(id=1035L)
    public void setMailFileDescriptorBufferSize(int zimbraMailFileDescriptorBufferSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailFileDescriptorBufferSize", Integer.toString(zimbraMailFileDescriptorBufferSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1035L)
    public Map<String, Object> setMailFileDescriptorBufferSize(int zimbraMailFileDescriptorBufferSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailFileDescriptorBufferSize", Integer.toString(zimbraMailFileDescriptorBufferSize));
        return attrs;
    }

    @ZAttr(id=1035L)
    public void unsetMailFileDescriptorBufferSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailFileDescriptorBufferSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1035L)
    public Map<String, Object> unsetMailFileDescriptorBufferSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailFileDescriptorBufferSize", "");
        return attrs;
    }

    @ZAttr(id=1034L)
    public int getMailFileDescriptorCacheSize() {
        return this.getIntAttr("zimbraMailFileDescriptorCacheSize", 1000);
    }

    @ZAttr(id=1034L)
    public void setMailFileDescriptorCacheSize(int zimbraMailFileDescriptorCacheSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailFileDescriptorCacheSize", Integer.toString(zimbraMailFileDescriptorCacheSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1034L)
    public Map<String, Object> setMailFileDescriptorCacheSize(int zimbraMailFileDescriptorCacheSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailFileDescriptorCacheSize", Integer.toString(zimbraMailFileDescriptorCacheSize));
        return attrs;
    }

    @ZAttr(id=1034L)
    public void unsetMailFileDescriptorCacheSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailFileDescriptorCacheSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1034L)
    public Map<String, Object> unsetMailFileDescriptorCacheSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailFileDescriptorCacheSize", "");
        return attrs;
    }

    @ZAttr(id=543L)
    public int getMailLastPurgedMailboxId() {
        return this.getIntAttr("zimbraMailLastPurgedMailboxId", -1);
    }

    @ZAttr(id=543L)
    public void setMailLastPurgedMailboxId(int zimbraMailLastPurgedMailboxId) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailLastPurgedMailboxId", Integer.toString(zimbraMailLastPurgedMailboxId));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=543L)
    public Map<String, Object> setMailLastPurgedMailboxId(int zimbraMailLastPurgedMailboxId, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailLastPurgedMailboxId", Integer.toString(zimbraMailLastPurgedMailboxId));
        return attrs;
    }

    @ZAttr(id=543L)
    public void unsetMailLastPurgedMailboxId() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailLastPurgedMailboxId", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=543L)
    public Map<String, Object> unsetMailLastPurgedMailboxId(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailLastPurgedMailboxId", "");
        return attrs;
    }

    @ZAttr(id=308L)
    public ZAttrProvisioning.MailMode getMailMode() {
        try {
            String v = this.getAttr("zimbraMailMode");
            return v == null ? null : ZAttrProvisioning.MailMode.fromString(v);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @ZAttr(id=308L)
    public String getMailModeAsString() {
        return this.getAttr("zimbraMailMode", null);
    }

    @ZAttr(id=308L)
    public void setMailMode(ZAttrProvisioning.MailMode zimbraMailMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailMode", zimbraMailMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=308L)
    public Map<String, Object> setMailMode(ZAttrProvisioning.MailMode zimbraMailMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailMode", zimbraMailMode.toString());
        return attrs;
    }

    @ZAttr(id=308L)
    public void setMailModeAsString(String zimbraMailMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailMode", zimbraMailMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=308L)
    public Map<String, Object> setMailModeAsString(String zimbraMailMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailMode", zimbraMailMode);
        return attrs;
    }

    @ZAttr(id=308L)
    public void unsetMailMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=308L)
    public Map<String, Object> unsetMailMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailMode", "");
        return attrs;
    }

    @ZAttr(id=154L)
    public int getMailPort() {
        return this.getIntAttr("zimbraMailPort", 80);
    }

    @ZAttr(id=154L)
    public String getMailPortAsString() {
        return this.getAttr("zimbraMailPort", "80");
    }

    @ZAttr(id=154L)
    public void setMailPort(int zimbraMailPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailPort", Integer.toString(zimbraMailPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=154L)
    public Map<String, Object> setMailPort(int zimbraMailPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailPort", Integer.toString(zimbraMailPort));
        return attrs;
    }

    @ZAttr(id=154L)
    public void setMailPortAsString(String zimbraMailPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailPort", zimbraMailPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=154L)
    public Map<String, Object> setMailPortAsString(String zimbraMailPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailPort", zimbraMailPort);
        return attrs;
    }

    @ZAttr(id=154L)
    public void unsetMailPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=154L)
    public Map<String, Object> unsetMailPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailPort", "");
        return attrs;
    }

    @ZAttr(id=626L)
    public int getMailProxyPort() {
        return this.getIntAttr("zimbraMailProxyPort", 0);
    }

    @ZAttr(id=626L)
    public String getMailProxyPortAsString() {
        return this.getAttr("zimbraMailProxyPort", "0");
    }

    @ZAttr(id=626L)
    public void setMailProxyPort(int zimbraMailProxyPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailProxyPort", Integer.toString(zimbraMailProxyPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=626L)
    public Map<String, Object> setMailProxyPort(int zimbraMailProxyPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailProxyPort", Integer.toString(zimbraMailProxyPort));
        return attrs;
    }

    @ZAttr(id=626L)
    public void setMailProxyPortAsString(String zimbraMailProxyPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailProxyPort", zimbraMailProxyPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=626L)
    public Map<String, Object> setMailProxyPortAsString(String zimbraMailProxyPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailProxyPort", zimbraMailProxyPort);
        return attrs;
    }

    @ZAttr(id=626L)
    public void unsetMailProxyPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailProxyPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=626L)
    public Map<String, Object> unsetMailProxyPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailProxyPort", "");
        return attrs;
    }

    @ZAttr(id=542L)
    public long getMailPurgeSleepInterval() {
        return this.getTimeInterval("zimbraMailPurgeSleepInterval", 60000L);
    }

    @ZAttr(id=542L)
    public String getMailPurgeSleepIntervalAsString() {
        return this.getAttr("zimbraMailPurgeSleepInterval", "1m");
    }

    @ZAttr(id=542L)
    public void setMailPurgeSleepInterval(String zimbraMailPurgeSleepInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailPurgeSleepInterval", zimbraMailPurgeSleepInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=542L)
    public Map<String, Object> setMailPurgeSleepInterval(String zimbraMailPurgeSleepInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailPurgeSleepInterval", zimbraMailPurgeSleepInterval);
        return attrs;
    }

    @ZAttr(id=542L)
    public void unsetMailPurgeSleepInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailPurgeSleepInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=542L)
    public Map<String, Object> unsetMailPurgeSleepInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailPurgeSleepInterval", "");
        return attrs;
    }

    @ZAttr(id=764L)
    public boolean isMailRedirectSetEnvelopeSender() {
        return this.getBooleanAttr("zimbraMailRedirectSetEnvelopeSender", true);
    }

    @ZAttr(id=764L)
    public void setMailRedirectSetEnvelopeSender(boolean zimbraMailRedirectSetEnvelopeSender) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailRedirectSetEnvelopeSender", zimbraMailRedirectSetEnvelopeSender ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=764L)
    public Map<String, Object> setMailRedirectSetEnvelopeSender(boolean zimbraMailRedirectSetEnvelopeSender, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailRedirectSetEnvelopeSender", zimbraMailRedirectSetEnvelopeSender ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=764L)
    public void unsetMailRedirectSetEnvelopeSender() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailRedirectSetEnvelopeSender", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=764L)
    public Map<String, Object> unsetMailRedirectSetEnvelopeSender(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailRedirectSetEnvelopeSender", "");
        return attrs;
    }

    @ZAttr(id=613L)
    public ZAttrProvisioning.MailReferMode getMailReferMode() {
        try {
            String v = this.getAttr("zimbraMailReferMode");
            return v == null ? ZAttrProvisioning.MailReferMode.wronghost : ZAttrProvisioning.MailReferMode.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.MailReferMode.wronghost;
        }
    }

    @ZAttr(id=613L)
    public String getMailReferModeAsString() {
        return this.getAttr("zimbraMailReferMode", "wronghost");
    }

    @ZAttr(id=613L)
    public void setMailReferMode(ZAttrProvisioning.MailReferMode zimbraMailReferMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailReferMode", zimbraMailReferMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=613L)
    public Map<String, Object> setMailReferMode(ZAttrProvisioning.MailReferMode zimbraMailReferMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailReferMode", zimbraMailReferMode.toString());
        return attrs;
    }

    @ZAttr(id=613L)
    public void setMailReferModeAsString(String zimbraMailReferMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailReferMode", zimbraMailReferMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=613L)
    public Map<String, Object> setMailReferModeAsString(String zimbraMailReferMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailReferMode", zimbraMailReferMode);
        return attrs;
    }

    @ZAttr(id=613L)
    public void unsetMailReferMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailReferMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=613L)
    public Map<String, Object> unsetMailReferMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailReferMode", "");
        return attrs;
    }

    @ZAttr(id=166L)
    public int getMailSSLPort() {
        return this.getIntAttr("zimbraMailSSLPort", 0);
    }

    @ZAttr(id=166L)
    public String getMailSSLPortAsString() {
        return this.getAttr("zimbraMailSSLPort", "0");
    }

    @ZAttr(id=166L)
    public void setMailSSLPort(int zimbraMailSSLPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLPort", Integer.toString(zimbraMailSSLPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=166L)
    public Map<String, Object> setMailSSLPort(int zimbraMailSSLPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLPort", Integer.toString(zimbraMailSSLPort));
        return attrs;
    }

    @ZAttr(id=166L)
    public void setMailSSLPortAsString(String zimbraMailSSLPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLPort", zimbraMailSSLPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=166L)
    public Map<String, Object> setMailSSLPortAsString(String zimbraMailSSLPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLPort", zimbraMailSSLPort);
        return attrs;
    }

    @ZAttr(id=166L)
    public void unsetMailSSLPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=166L)
    public Map<String, Object> unsetMailSSLPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLPort", "");
        return attrs;
    }

    @ZAttr(id=627L)
    public int getMailSSLProxyPort() {
        return this.getIntAttr("zimbraMailSSLProxyPort", 0);
    }

    @ZAttr(id=627L)
    public String getMailSSLProxyPortAsString() {
        return this.getAttr("zimbraMailSSLProxyPort", "0");
    }

    @ZAttr(id=627L)
    public void setMailSSLProxyPort(int zimbraMailSSLProxyPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLProxyPort", Integer.toString(zimbraMailSSLProxyPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=627L)
    public Map<String, Object> setMailSSLProxyPort(int zimbraMailSSLProxyPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLProxyPort", Integer.toString(zimbraMailSSLProxyPort));
        return attrs;
    }

    @ZAttr(id=627L)
    public void setMailSSLProxyPortAsString(String zimbraMailSSLProxyPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLProxyPort", zimbraMailSSLProxyPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=627L)
    public Map<String, Object> setMailSSLProxyPortAsString(String zimbraMailSSLProxyPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLProxyPort", zimbraMailSSLProxyPort);
        return attrs;
    }

    @ZAttr(id=627L)
    public void unsetMailSSLProxyPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLProxyPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=627L)
    public Map<String, Object> unsetMailSSLProxyPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLProxyPort", "");
        return attrs;
    }

    @ZAttr(id=1025L)
    public String[] getMailTrustedIP() {
        return this.getMultiAttr("zimbraMailTrustedIP");
    }

    @ZAttr(id=1025L)
    public void setMailTrustedIP(String[] zimbraMailTrustedIP) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMailTrustedIP", zimbraMailTrustedIP);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1025L)
    public Map<String, Object> setMailTrustedIP(String[] zimbraMailTrustedIP, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailTrustedIP", zimbraMailTrustedIP);
        return attrs;
    }

    @ZAttr(id=1025L)
    public void addMailTrustedIP(String zimbraMailTrustedIP) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMailTrustedIP", zimbraMailTrustedIP);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1025L)
    public Map<String, Object> addMailTrustedIP(String zimbraMailTrustedIP, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMailTrustedIP", zimbraMailTrustedIP);
        return attrs;
    }

    @ZAttr(id=1025L)
    public void removeMailTrustedIP(String zimbraMailTrustedIP) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMailTrustedIP", zimbraMailTrustedIP);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1025L)
    public Map<String, Object> removeMailTrustedIP(String zimbraMailTrustedIP, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMailTrustedIP", zimbraMailTrustedIP);
        return attrs;
    }

    @ZAttr(id=1025L)
    public void unsetMailTrustedIP() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailTrustedIP", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1025L)
    public Map<String, Object> unsetMailTrustedIP(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailTrustedIP", "");
        return attrs;
    }

    @ZAttr(id=340L)
    public String getMailURL() {
        return this.getAttr("zimbraMailURL", "/zimbra");
    }

    @ZAttr(id=340L)
    public void setMailURL(String zimbraMailURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailURL", zimbraMailURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=340L)
    public Map<String, Object> setMailURL(String zimbraMailURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailURL", zimbraMailURL);
        return attrs;
    }

    @ZAttr(id=340L)
    public void unsetMailURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=340L)
    public Map<String, Object> unsetMailURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailURL", "");
        return attrs;
    }

    @ZAttr(id=825L)
    public long getMailUncompressedCacheMaxBytes() {
        return this.getLongAttr("zimbraMailUncompressedCacheMaxBytes", 0x40000000L);
    }

    @ZAttr(id=825L)
    public void setMailUncompressedCacheMaxBytes(long zimbraMailUncompressedCacheMaxBytes) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUncompressedCacheMaxBytes", Long.toString(zimbraMailUncompressedCacheMaxBytes));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=825L)
    public Map<String, Object> setMailUncompressedCacheMaxBytes(long zimbraMailUncompressedCacheMaxBytes, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUncompressedCacheMaxBytes", Long.toString(zimbraMailUncompressedCacheMaxBytes));
        return attrs;
    }

    @ZAttr(id=825L)
    public void unsetMailUncompressedCacheMaxBytes() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUncompressedCacheMaxBytes", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=825L)
    public Map<String, Object> unsetMailUncompressedCacheMaxBytes(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUncompressedCacheMaxBytes", "");
        return attrs;
    }

    @ZAttr(id=824L)
    public int getMailUncompressedCacheMaxFiles() {
        return this.getIntAttr("zimbraMailUncompressedCacheMaxFiles", 5000);
    }

    @ZAttr(id=824L)
    public void setMailUncompressedCacheMaxFiles(int zimbraMailUncompressedCacheMaxFiles) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUncompressedCacheMaxFiles", Integer.toString(zimbraMailUncompressedCacheMaxFiles));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=824L)
    public Map<String, Object> setMailUncompressedCacheMaxFiles(int zimbraMailUncompressedCacheMaxFiles, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUncompressedCacheMaxFiles", Integer.toString(zimbraMailUncompressedCacheMaxFiles));
        return attrs;
    }

    @ZAttr(id=824L)
    public void unsetMailUncompressedCacheMaxFiles() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUncompressedCacheMaxFiles", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=824L)
    public Map<String, Object> unsetMailUncompressedCacheMaxFiles(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUncompressedCacheMaxFiles", "");
        return attrs;
    }

    @ZAttr(id=1002L)
    public boolean isMailUseDirectBuffers() {
        return this.getBooleanAttr("zimbraMailUseDirectBuffers", false);
    }

    @ZAttr(id=1002L)
    public void setMailUseDirectBuffers(boolean zimbraMailUseDirectBuffers) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUseDirectBuffers", zimbraMailUseDirectBuffers ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1002L)
    public Map<String, Object> setMailUseDirectBuffers(boolean zimbraMailUseDirectBuffers, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUseDirectBuffers", zimbraMailUseDirectBuffers ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1002L)
    public void unsetMailUseDirectBuffers() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUseDirectBuffers", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1002L)
    public Map<String, Object> unsetMailUseDirectBuffers(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUseDirectBuffers", "");
        return attrs;
    }

    @ZAttr(id=1007L)
    public boolean isMailboxMoveSkipBlobs() {
        return this.getBooleanAttr("zimbraMailboxMoveSkipBlobs", false);
    }

    @ZAttr(id=1007L)
    public void setMailboxMoveSkipBlobs(boolean zimbraMailboxMoveSkipBlobs) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipBlobs", zimbraMailboxMoveSkipBlobs ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1007L)
    public Map<String, Object> setMailboxMoveSkipBlobs(boolean zimbraMailboxMoveSkipBlobs, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipBlobs", zimbraMailboxMoveSkipBlobs ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1007L)
    public void unsetMailboxMoveSkipBlobs() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipBlobs", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1007L)
    public Map<String, Object> unsetMailboxMoveSkipBlobs(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipBlobs", "");
        return attrs;
    }

    @ZAttr(id=1008L)
    public boolean isMailboxMoveSkipHsmBlobs() {
        return this.getBooleanAttr("zimbraMailboxMoveSkipHsmBlobs", false);
    }

    @ZAttr(id=1008L)
    public void setMailboxMoveSkipHsmBlobs(boolean zimbraMailboxMoveSkipHsmBlobs) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipHsmBlobs", zimbraMailboxMoveSkipHsmBlobs ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1008L)
    public Map<String, Object> setMailboxMoveSkipHsmBlobs(boolean zimbraMailboxMoveSkipHsmBlobs, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipHsmBlobs", zimbraMailboxMoveSkipHsmBlobs ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1008L)
    public void unsetMailboxMoveSkipHsmBlobs() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipHsmBlobs", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1008L)
    public Map<String, Object> unsetMailboxMoveSkipHsmBlobs(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipHsmBlobs", "");
        return attrs;
    }

    @ZAttr(id=1006L)
    public boolean isMailboxMoveSkipSearchIndex() {
        return this.getBooleanAttr("zimbraMailboxMoveSkipSearchIndex", false);
    }

    @ZAttr(id=1006L)
    public void setMailboxMoveSkipSearchIndex(boolean zimbraMailboxMoveSkipSearchIndex) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipSearchIndex", zimbraMailboxMoveSkipSearchIndex ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1006L)
    public Map<String, Object> setMailboxMoveSkipSearchIndex(boolean zimbraMailboxMoveSkipSearchIndex, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipSearchIndex", zimbraMailboxMoveSkipSearchIndex ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1006L)
    public void unsetMailboxMoveSkipSearchIndex() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipSearchIndex", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1006L)
    public Map<String, Object> unsetMailboxMoveSkipSearchIndex(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipSearchIndex", "");
        return attrs;
    }

    @ZAttr(id=581L)
    public String[] getMemcachedBindAddress() {
        return this.getMultiAttr("zimbraMemcachedBindAddress");
    }

    @ZAttr(id=581L)
    public void setMemcachedBindAddress(String[] zimbraMemcachedBindAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMemcachedBindAddress", zimbraMemcachedBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=581L)
    public Map<String, Object> setMemcachedBindAddress(String[] zimbraMemcachedBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedBindAddress", zimbraMemcachedBindAddress);
        return attrs;
    }

    @ZAttr(id=581L)
    public void addMemcachedBindAddress(String zimbraMemcachedBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMemcachedBindAddress", zimbraMemcachedBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=581L)
    public Map<String, Object> addMemcachedBindAddress(String zimbraMemcachedBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMemcachedBindAddress", zimbraMemcachedBindAddress);
        return attrs;
    }

    @ZAttr(id=581L)
    public void removeMemcachedBindAddress(String zimbraMemcachedBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMemcachedBindAddress", zimbraMemcachedBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=581L)
    public Map<String, Object> removeMemcachedBindAddress(String zimbraMemcachedBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMemcachedBindAddress", zimbraMemcachedBindAddress);
        return attrs;
    }

    @ZAttr(id=581L)
    public void unsetMemcachedBindAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedBindAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=581L)
    public Map<String, Object> unsetMemcachedBindAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedBindAddress", "");
        return attrs;
    }

    @ZAttr(id=580L)
    public int getMemcachedBindPort() {
        return this.getIntAttr("zimbraMemcachedBindPort", 11211);
    }

    @ZAttr(id=580L)
    public String getMemcachedBindPortAsString() {
        return this.getAttr("zimbraMemcachedBindPort", "11211");
    }

    @ZAttr(id=580L)
    public void setMemcachedBindPort(int zimbraMemcachedBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedBindPort", Integer.toString(zimbraMemcachedBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=580L)
    public Map<String, Object> setMemcachedBindPort(int zimbraMemcachedBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedBindPort", Integer.toString(zimbraMemcachedBindPort));
        return attrs;
    }

    @ZAttr(id=580L)
    public void setMemcachedBindPortAsString(String zimbraMemcachedBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedBindPort", zimbraMemcachedBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=580L)
    public Map<String, Object> setMemcachedBindPortAsString(String zimbraMemcachedBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedBindPort", zimbraMemcachedBindPort);
        return attrs;
    }

    @ZAttr(id=580L)
    public void unsetMemcachedBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=580L)
    public Map<String, Object> unsetMemcachedBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedBindPort", "");
        return attrs;
    }

    @ZAttr(id=1015L)
    public boolean isMemcachedClientBinaryProtocolEnabled() {
        return this.getBooleanAttr("zimbraMemcachedClientBinaryProtocolEnabled", false);
    }

    @ZAttr(id=1015L)
    public void setMemcachedClientBinaryProtocolEnabled(boolean zimbraMemcachedClientBinaryProtocolEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientBinaryProtocolEnabled", zimbraMemcachedClientBinaryProtocolEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1015L)
    public Map<String, Object> setMemcachedClientBinaryProtocolEnabled(boolean zimbraMemcachedClientBinaryProtocolEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientBinaryProtocolEnabled", zimbraMemcachedClientBinaryProtocolEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1015L)
    public void unsetMemcachedClientBinaryProtocolEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientBinaryProtocolEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1015L)
    public Map<String, Object> unsetMemcachedClientBinaryProtocolEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientBinaryProtocolEnabled", "");
        return attrs;
    }

    @ZAttr(id=1017L)
    public int getMemcachedClientExpirySeconds() {
        return this.getIntAttr("zimbraMemcachedClientExpirySeconds", 86400);
    }

    @ZAttr(id=1017L)
    public void setMemcachedClientExpirySeconds(int zimbraMemcachedClientExpirySeconds) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientExpirySeconds", Integer.toString(zimbraMemcachedClientExpirySeconds));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1017L)
    public Map<String, Object> setMemcachedClientExpirySeconds(int zimbraMemcachedClientExpirySeconds, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientExpirySeconds", Integer.toString(zimbraMemcachedClientExpirySeconds));
        return attrs;
    }

    @ZAttr(id=1017L)
    public void unsetMemcachedClientExpirySeconds() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientExpirySeconds", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1017L)
    public Map<String, Object> unsetMemcachedClientExpirySeconds(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientExpirySeconds", "");
        return attrs;
    }

    @ZAttr(id=1016L)
    public String getMemcachedClientHashAlgorithm() {
        return this.getAttr("zimbraMemcachedClientHashAlgorithm", "KETAMA_HASH");
    }

    @ZAttr(id=1016L)
    public void setMemcachedClientHashAlgorithm(String zimbraMemcachedClientHashAlgorithm) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientHashAlgorithm", zimbraMemcachedClientHashAlgorithm);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1016L)
    public Map<String, Object> setMemcachedClientHashAlgorithm(String zimbraMemcachedClientHashAlgorithm, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientHashAlgorithm", zimbraMemcachedClientHashAlgorithm);
        return attrs;
    }

    @ZAttr(id=1016L)
    public void unsetMemcachedClientHashAlgorithm() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientHashAlgorithm", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1016L)
    public Map<String, Object> unsetMemcachedClientHashAlgorithm(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientHashAlgorithm", "");
        return attrs;
    }

    @ZAttr(id=1014L)
    public String[] getMemcachedClientServerList() {
        return this.getMultiAttr("zimbraMemcachedClientServerList");
    }

    @ZAttr(id=1014L)
    public void setMemcachedClientServerList(String[] zimbraMemcachedClientServerList) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1014L)
    public Map<String, Object> setMemcachedClientServerList(String[] zimbraMemcachedClientServerList, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        return attrs;
    }

    @ZAttr(id=1014L)
    public void addMemcachedClientServerList(String zimbraMemcachedClientServerList) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1014L)
    public Map<String, Object> addMemcachedClientServerList(String zimbraMemcachedClientServerList, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        return attrs;
    }

    @ZAttr(id=1014L)
    public void removeMemcachedClientServerList(String zimbraMemcachedClientServerList) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1014L)
    public Map<String, Object> removeMemcachedClientServerList(String zimbraMemcachedClientServerList, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        return attrs;
    }

    @ZAttr(id=1014L)
    public void unsetMemcachedClientServerList() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientServerList", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1014L)
    public Map<String, Object> unsetMemcachedClientServerList(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientServerList", "");
        return attrs;
    }

    @ZAttr(id=1018L)
    public int getMemcachedClientTimeoutMillis() {
        return this.getIntAttr("zimbraMemcachedClientTimeoutMillis", 10000);
    }

    @ZAttr(id=1018L)
    public void setMemcachedClientTimeoutMillis(int zimbraMemcachedClientTimeoutMillis) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientTimeoutMillis", Integer.toString(zimbraMemcachedClientTimeoutMillis));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1018L)
    public Map<String, Object> setMemcachedClientTimeoutMillis(int zimbraMemcachedClientTimeoutMillis, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientTimeoutMillis", Integer.toString(zimbraMemcachedClientTimeoutMillis));
        return attrs;
    }

    @ZAttr(id=1018L)
    public void unsetMemcachedClientTimeoutMillis() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientTimeoutMillis", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1018L)
    public Map<String, Object> unsetMemcachedClientTimeoutMillis(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientTimeoutMillis", "");
        return attrs;
    }

    @ZAttr(id=297L)
    public int getMessageCacheSize() {
        return this.getIntAttr("zimbraMessageCacheSize", 2000);
    }

    @ZAttr(id=297L)
    public void setMessageCacheSize(int zimbraMessageCacheSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMessageCacheSize", Integer.toString(zimbraMessageCacheSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=297L)
    public Map<String, Object> setMessageCacheSize(int zimbraMessageCacheSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMessageCacheSize", Integer.toString(zimbraMessageCacheSize));
        return attrs;
    }

    @ZAttr(id=297L)
    public void unsetMessageCacheSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMessageCacheSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=297L)
    public Map<String, Object> unsetMessageCacheSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMessageCacheSize", "");
        return attrs;
    }

    @ZAttr(id=612L)
    public String getMtaAntiSpamLockMethod() {
        return this.getAttr("zimbraMtaAntiSpamLockMethod", "flock");
    }

    @ZAttr(id=612L)
    public void setMtaAntiSpamLockMethod(String zimbraMtaAntiSpamLockMethod) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAntiSpamLockMethod", zimbraMtaAntiSpamLockMethod);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=612L)
    public Map<String, Object> setMtaAntiSpamLockMethod(String zimbraMtaAntiSpamLockMethod, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAntiSpamLockMethod", zimbraMtaAntiSpamLockMethod);
        return attrs;
    }

    @ZAttr(id=612L)
    public void unsetMtaAntiSpamLockMethod() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAntiSpamLockMethod", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=612L)
    public Map<String, Object> unsetMtaAntiSpamLockMethod(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAntiSpamLockMethod", "");
        return attrs;
    }

    @ZAttr(id=194L)
    public boolean isMtaAuthEnabled() {
        return this.getBooleanAttr("zimbraMtaAuthEnabled", true);
    }

    @ZAttr(id=194L)
    public void setMtaAuthEnabled(boolean zimbraMtaAuthEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthEnabled", zimbraMtaAuthEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=194L)
    public Map<String, Object> setMtaAuthEnabled(boolean zimbraMtaAuthEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthEnabled", zimbraMtaAuthEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=194L)
    public void unsetMtaAuthEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=194L)
    public Map<String, Object> unsetMtaAuthEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthEnabled", "");
        return attrs;
    }

    @ZAttr(id=309L)
    public String[] getMtaAuthHost() {
        return this.getMultiAttr("zimbraMtaAuthHost");
    }

    @ZAttr(id=309L)
    public void setMtaAuthHost(String[] zimbraMtaAuthHost) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaAuthHost", zimbraMtaAuthHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=309L)
    public Map<String, Object> setMtaAuthHost(String[] zimbraMtaAuthHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthHost", zimbraMtaAuthHost);
        return attrs;
    }

    @ZAttr(id=309L)
    public void addMtaAuthHost(String zimbraMtaAuthHost) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaAuthHost", zimbraMtaAuthHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=309L)
    public Map<String, Object> addMtaAuthHost(String zimbraMtaAuthHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaAuthHost", zimbraMtaAuthHost);
        return attrs;
    }

    @ZAttr(id=309L)
    public void removeMtaAuthHost(String zimbraMtaAuthHost) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaAuthHost", zimbraMtaAuthHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=309L)
    public Map<String, Object> removeMtaAuthHost(String zimbraMtaAuthHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaAuthHost", zimbraMtaAuthHost);
        return attrs;
    }

    @ZAttr(id=309L)
    public void unsetMtaAuthHost() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthHost", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=309L)
    public Map<String, Object> unsetMtaAuthHost(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthHost", "");
        return attrs;
    }

    @ZAttr(id=505L)
    public boolean isMtaAuthTarget() {
        return this.getBooleanAttr("zimbraMtaAuthTarget", false);
    }

    @ZAttr(id=505L)
    public void setMtaAuthTarget(boolean zimbraMtaAuthTarget) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthTarget", zimbraMtaAuthTarget ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=505L)
    public Map<String, Object> setMtaAuthTarget(boolean zimbraMtaAuthTarget, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthTarget", zimbraMtaAuthTarget ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=505L)
    public void unsetMtaAuthTarget() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthTarget", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=505L)
    public Map<String, Object> unsetMtaAuthTarget(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthTarget", "");
        return attrs;
    }

    @ZAttr(id=310L)
    public String[] getMtaAuthURL() {
        return this.getMultiAttr("zimbraMtaAuthURL");
    }

    @ZAttr(id=310L)
    public void setMtaAuthURL(String[] zimbraMtaAuthURL) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaAuthURL", zimbraMtaAuthURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=310L)
    public Map<String, Object> setMtaAuthURL(String[] zimbraMtaAuthURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthURL", zimbraMtaAuthURL);
        return attrs;
    }

    @ZAttr(id=310L)
    public void addMtaAuthURL(String zimbraMtaAuthURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaAuthURL", zimbraMtaAuthURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=310L)
    public Map<String, Object> addMtaAuthURL(String zimbraMtaAuthURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaAuthURL", zimbraMtaAuthURL);
        return attrs;
    }

    @ZAttr(id=310L)
    public void removeMtaAuthURL(String zimbraMtaAuthURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaAuthURL", zimbraMtaAuthURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=310L)
    public Map<String, Object> removeMtaAuthURL(String zimbraMtaAuthURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaAuthURL", zimbraMtaAuthURL);
        return attrs;
    }

    @ZAttr(id=310L)
    public void unsetMtaAuthURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=310L)
    public Map<String, Object> unsetMtaAuthURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthURL", "");
        return attrs;
    }

    @ZAttr(id=197L)
    public boolean isMtaDnsLookupsEnabled() {
        return this.getBooleanAttr("zimbraMtaDnsLookupsEnabled", true);
    }

    @ZAttr(id=197L)
    public void setMtaDnsLookupsEnabled(boolean zimbraMtaDnsLookupsEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaDnsLookupsEnabled", zimbraMtaDnsLookupsEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=197L)
    public Map<String, Object> setMtaDnsLookupsEnabled(boolean zimbraMtaDnsLookupsEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaDnsLookupsEnabled", zimbraMtaDnsLookupsEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=197L)
    public void unsetMtaDnsLookupsEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaDnsLookupsEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=197L)
    public Map<String, Object> unsetMtaDnsLookupsEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaDnsLookupsEnabled", "");
        return attrs;
    }

    @ZAttr(id=524L)
    public String getMtaMyDestination() {
        return this.getAttr("zimbraMtaMyDestination", "localhost");
    }

    @ZAttr(id=524L)
    public void setMtaMyDestination(String zimbraMtaMyDestination) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyDestination", zimbraMtaMyDestination);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=524L)
    public Map<String, Object> setMtaMyDestination(String zimbraMtaMyDestination, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyDestination", zimbraMtaMyDestination);
        return attrs;
    }

    @ZAttr(id=524L)
    public void unsetMtaMyDestination() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyDestination", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=524L)
    public Map<String, Object> unsetMtaMyDestination(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyDestination", "");
        return attrs;
    }

    @ZAttr(id=509L)
    public String getMtaMyHostname() {
        return this.getAttr("zimbraMtaMyHostname", null);
    }

    @ZAttr(id=509L)
    public void setMtaMyHostname(String zimbraMtaMyHostname) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyHostname", zimbraMtaMyHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=509L)
    public Map<String, Object> setMtaMyHostname(String zimbraMtaMyHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyHostname", zimbraMtaMyHostname);
        return attrs;
    }

    @ZAttr(id=509L)
    public void unsetMtaMyHostname() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyHostname", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=509L)
    public Map<String, Object> unsetMtaMyHostname(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyHostname", "");
        return attrs;
    }

    @ZAttr(id=311L)
    public String[] getMtaMyNetworks() {
        return this.getMultiAttr("zimbraMtaMyNetworks");
    }

    @ZAttr(id=311L)
    public void setMtaMyNetworks(String[] zimbraMtaMyNetworks) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=311L)
    public Map<String, Object> setMtaMyNetworks(String[] zimbraMtaMyNetworks, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        return attrs;
    }

    @ZAttr(id=311L)
    public void addMtaMyNetworks(String zimbraMtaMyNetworks) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=311L)
    public Map<String, Object> addMtaMyNetworks(String zimbraMtaMyNetworks, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        return attrs;
    }

    @ZAttr(id=311L)
    public void removeMtaMyNetworks(String zimbraMtaMyNetworks) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=311L)
    public Map<String, Object> removeMtaMyNetworks(String zimbraMtaMyNetworks, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        return attrs;
    }

    @ZAttr(id=311L)
    public void unsetMtaMyNetworks() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyNetworks", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=311L)
    public Map<String, Object> unsetMtaMyNetworks(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyNetworks", "");
        return attrs;
    }

    @ZAttr(id=510L)
    public String getMtaMyOrigin() {
        return this.getAttr("zimbraMtaMyOrigin", null);
    }

    @ZAttr(id=510L)
    public void setMtaMyOrigin(String zimbraMtaMyOrigin) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyOrigin", zimbraMtaMyOrigin);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=510L)
    public Map<String, Object> setMtaMyOrigin(String zimbraMtaMyOrigin, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyOrigin", zimbraMtaMyOrigin);
        return attrs;
    }

    @ZAttr(id=510L)
    public void unsetMtaMyOrigin() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyOrigin", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=510L)
    public Map<String, Object> unsetMtaMyOrigin(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyOrigin", "");
        return attrs;
    }

    @ZAttr(id=673L)
    public String getMtaNonSmtpdMilters() {
        return this.getAttr("zimbraMtaNonSmtpdMilters", null);
    }

    @ZAttr(id=673L)
    public void setMtaNonSmtpdMilters(String zimbraMtaNonSmtpdMilters) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaNonSmtpdMilters", zimbraMtaNonSmtpdMilters);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=673L)
    public Map<String, Object> setMtaNonSmtpdMilters(String zimbraMtaNonSmtpdMilters, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaNonSmtpdMilters", zimbraMtaNonSmtpdMilters);
        return attrs;
    }

    @ZAttr(id=673L)
    public void unsetMtaNonSmtpdMilters() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaNonSmtpdMilters", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=673L)
    public Map<String, Object> unsetMtaNonSmtpdMilters(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaNonSmtpdMilters", "");
        return attrs;
    }

    @ZAttr(id=199L)
    public String[] getMtaRelayHost() {
        return this.getMultiAttr("zimbraMtaRelayHost");
    }

    @ZAttr(id=199L)
    public void setMtaRelayHost(String[] zimbraMtaRelayHost) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaRelayHost", zimbraMtaRelayHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=199L)
    public Map<String, Object> setMtaRelayHost(String[] zimbraMtaRelayHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaRelayHost", zimbraMtaRelayHost);
        return attrs;
    }

    @ZAttr(id=199L)
    public void addMtaRelayHost(String zimbraMtaRelayHost) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaRelayHost", zimbraMtaRelayHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=199L)
    public Map<String, Object> addMtaRelayHost(String zimbraMtaRelayHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaRelayHost", zimbraMtaRelayHost);
        return attrs;
    }

    @ZAttr(id=199L)
    public void removeMtaRelayHost(String zimbraMtaRelayHost) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaRelayHost", zimbraMtaRelayHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=199L)
    public Map<String, Object> removeMtaRelayHost(String zimbraMtaRelayHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaRelayHost", zimbraMtaRelayHost);
        return attrs;
    }

    @ZAttr(id=199L)
    public void unsetMtaRelayHost() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaRelayHost", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=199L)
    public Map<String, Object> unsetMtaRelayHost(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaRelayHost", "");
        return attrs;
    }

    @ZAttr(id=796L)
    public boolean isMtaSaslAuthEnable() {
        return this.getBooleanAttr("zimbraMtaSaslAuthEnable", true);
    }

    @ZAttr(id=796L)
    public void setMtaSaslAuthEnable(boolean zimbraMtaSaslAuthEnable) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaSaslAuthEnable", zimbraMtaSaslAuthEnable ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=796L)
    public Map<String, Object> setMtaSaslAuthEnable(boolean zimbraMtaSaslAuthEnable, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaSaslAuthEnable", zimbraMtaSaslAuthEnable ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=796L)
    public void unsetMtaSaslAuthEnable() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaSaslAuthEnable", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=796L)
    public Map<String, Object> unsetMtaSaslAuthEnable(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaSaslAuthEnable", "");
        return attrs;
    }

    @ZAttr(id=672L)
    public String getMtaSmtpdMilters() {
        return this.getAttr("zimbraMtaSmtpdMilters", null);
    }

    @ZAttr(id=672L)
    public void setMtaSmtpdMilters(String zimbraMtaSmtpdMilters) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaSmtpdMilters", zimbraMtaSmtpdMilters);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=672L)
    public Map<String, Object> setMtaSmtpdMilters(String zimbraMtaSmtpdMilters, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaSmtpdMilters", zimbraMtaSmtpdMilters);
        return attrs;
    }

    @ZAttr(id=672L)
    public void unsetMtaSmtpdMilters() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaSmtpdMilters", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=672L)
    public Map<String, Object> unsetMtaSmtpdMilters(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaSmtpdMilters", "");
        return attrs;
    }

    @ZAttr(id=200L)
    public boolean isMtaTlsAuthOnly() {
        return this.getBooleanAttr("zimbraMtaTlsAuthOnly", true);
    }

    @ZAttr(id=200L)
    public void setMtaTlsAuthOnly(boolean zimbraMtaTlsAuthOnly) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaTlsAuthOnly", zimbraMtaTlsAuthOnly ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=200L)
    public Map<String, Object> setMtaTlsAuthOnly(boolean zimbraMtaTlsAuthOnly, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaTlsAuthOnly", zimbraMtaTlsAuthOnly ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=200L)
    public void unsetMtaTlsAuthOnly() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaTlsAuthOnly", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=200L)
    public Map<String, Object> unsetMtaTlsAuthOnly(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaTlsAuthOnly", "");
        return attrs;
    }

    @ZAttr(id=795L)
    public ZAttrProvisioning.MtaTlsSecurityLevel getMtaTlsSecurityLevel() {
        try {
            String v = this.getAttr("zimbraMtaTlsSecurityLevel");
            return v == null ? ZAttrProvisioning.MtaTlsSecurityLevel.may : ZAttrProvisioning.MtaTlsSecurityLevel.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.MtaTlsSecurityLevel.may;
        }
    }

    @ZAttr(id=795L)
    public String getMtaTlsSecurityLevelAsString() {
        return this.getAttr("zimbraMtaTlsSecurityLevel", "may");
    }

    @ZAttr(id=795L)
    public void setMtaTlsSecurityLevel(ZAttrProvisioning.MtaTlsSecurityLevel zimbraMtaTlsSecurityLevel) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaTlsSecurityLevel", zimbraMtaTlsSecurityLevel.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=795L)
    public Map<String, Object> setMtaTlsSecurityLevel(ZAttrProvisioning.MtaTlsSecurityLevel zimbraMtaTlsSecurityLevel, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaTlsSecurityLevel", zimbraMtaTlsSecurityLevel.toString());
        return attrs;
    }

    @ZAttr(id=795L)
    public void setMtaTlsSecurityLevelAsString(String zimbraMtaTlsSecurityLevel) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaTlsSecurityLevel", zimbraMtaTlsSecurityLevel);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=795L)
    public Map<String, Object> setMtaTlsSecurityLevelAsString(String zimbraMtaTlsSecurityLevel, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaTlsSecurityLevel", zimbraMtaTlsSecurityLevel);
        return attrs;
    }

    @ZAttr(id=795L)
    public void unsetMtaTlsSecurityLevel() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaTlsSecurityLevel", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=795L)
    public Map<String, Object> unsetMtaTlsSecurityLevel(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaTlsSecurityLevel", "");
        return attrs;
    }

    @ZAttr(id=370L)
    public int getNotebookFolderCacheSize() {
        return this.getIntAttr("zimbraNotebookFolderCacheSize", 1024);
    }

    @ZAttr(id=370L)
    public void setNotebookFolderCacheSize(int zimbraNotebookFolderCacheSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookFolderCacheSize", Integer.toString(zimbraNotebookFolderCacheSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=370L)
    public Map<String, Object> setNotebookFolderCacheSize(int zimbraNotebookFolderCacheSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookFolderCacheSize", Integer.toString(zimbraNotebookFolderCacheSize));
        return attrs;
    }

    @ZAttr(id=370L)
    public void unsetNotebookFolderCacheSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookFolderCacheSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=370L)
    public Map<String, Object> unsetNotebookFolderCacheSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookFolderCacheSize", "");
        return attrs;
    }

    @ZAttr(id=371L)
    public int getNotebookMaxCachedTemplatesPerFolder() {
        return this.getIntAttr("zimbraNotebookMaxCachedTemplatesPerFolder", 256);
    }

    @ZAttr(id=371L)
    public void setNotebookMaxCachedTemplatesPerFolder(int zimbraNotebookMaxCachedTemplatesPerFolder) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookMaxCachedTemplatesPerFolder", Integer.toString(zimbraNotebookMaxCachedTemplatesPerFolder));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=371L)
    public Map<String, Object> setNotebookMaxCachedTemplatesPerFolder(int zimbraNotebookMaxCachedTemplatesPerFolder, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookMaxCachedTemplatesPerFolder", Integer.toString(zimbraNotebookMaxCachedTemplatesPerFolder));
        return attrs;
    }

    @ZAttr(id=371L)
    public void unsetNotebookMaxCachedTemplatesPerFolder() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookMaxCachedTemplatesPerFolder", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=371L)
    public Map<String, Object> unsetNotebookMaxCachedTemplatesPerFolder(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookMaxCachedTemplatesPerFolder", "");
        return attrs;
    }

    @ZAttr(id=369L)
    public int getNotebookPageCacheSize() {
        return this.getIntAttr("zimbraNotebookPageCacheSize", 10240);
    }

    @ZAttr(id=369L)
    public void setNotebookPageCacheSize(int zimbraNotebookPageCacheSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookPageCacheSize", Integer.toString(zimbraNotebookPageCacheSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=369L)
    public Map<String, Object> setNotebookPageCacheSize(int zimbraNotebookPageCacheSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookPageCacheSize", Integer.toString(zimbraNotebookPageCacheSize));
        return attrs;
    }

    @ZAttr(id=369L)
    public void unsetNotebookPageCacheSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookPageCacheSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=369L)
    public Map<String, Object> unsetNotebookPageCacheSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookPageCacheSize", "");
        return attrs;
    }

    @ZAttr(id=9L)
    public String getNotes() {
        return this.getAttr("zimbraNotes", null);
    }

    @ZAttr(id=9L)
    public void setNotes(String zimbraNotes) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotes", zimbraNotes);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=9L)
    public Map<String, Object> setNotes(String zimbraNotes, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotes", zimbraNotes);
        return attrs;
    }

    @ZAttr(id=9L)
    public void unsetNotes() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotes", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=9L)
    public Map<String, Object> unsetNotes(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotes", "");
        return attrs;
    }

    @ZAttr(id=317L)
    public String[] getNotifyBindAddress() {
        return this.getMultiAttr("zimbraNotifyBindAddress");
    }

    @ZAttr(id=317L)
    public void setNotifyBindAddress(String[] zimbraNotifyBindAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=317L)
    public Map<String, Object> setNotifyBindAddress(String[] zimbraNotifyBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        return attrs;
    }

    @ZAttr(id=317L)
    public void addNotifyBindAddress(String zimbraNotifyBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=317L)
    public Map<String, Object> addNotifyBindAddress(String zimbraNotifyBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        return attrs;
    }

    @ZAttr(id=317L)
    public void removeNotifyBindAddress(String zimbraNotifyBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=317L)
    public Map<String, Object> removeNotifyBindAddress(String zimbraNotifyBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        return attrs;
    }

    @ZAttr(id=317L)
    public void unsetNotifyBindAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifyBindAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=317L)
    public Map<String, Object> unsetNotifyBindAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyBindAddress", "");
        return attrs;
    }

    @ZAttr(id=318L)
    public int getNotifyBindPort() {
        return this.getIntAttr("zimbraNotifyBindPort", 7035);
    }

    @ZAttr(id=318L)
    public void setNotifyBindPort(int zimbraNotifyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifyBindPort", Integer.toString(zimbraNotifyBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=318L)
    public Map<String, Object> setNotifyBindPort(int zimbraNotifyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyBindPort", Integer.toString(zimbraNotifyBindPort));
        return attrs;
    }

    @ZAttr(id=318L)
    public void unsetNotifyBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifyBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=318L)
    public Map<String, Object> unsetNotifyBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyBindPort", "");
        return attrs;
    }

    @ZAttr(id=320L)
    public String[] getNotifySSLBindAddress() {
        return this.getMultiAttr("zimbraNotifySSLBindAddress");
    }

    @ZAttr(id=320L)
    public void setNotifySSLBindAddress(String[] zimbraNotifySSLBindAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=320L)
    public Map<String, Object> setNotifySSLBindAddress(String[] zimbraNotifySSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        return attrs;
    }

    @ZAttr(id=320L)
    public void addNotifySSLBindAddress(String zimbraNotifySSLBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=320L)
    public Map<String, Object> addNotifySSLBindAddress(String zimbraNotifySSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        return attrs;
    }

    @ZAttr(id=320L)
    public void removeNotifySSLBindAddress(String zimbraNotifySSLBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=320L)
    public Map<String, Object> removeNotifySSLBindAddress(String zimbraNotifySSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        return attrs;
    }

    @ZAttr(id=320L)
    public void unsetNotifySSLBindAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifySSLBindAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=320L)
    public Map<String, Object> unsetNotifySSLBindAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLBindAddress", "");
        return attrs;
    }

    @ZAttr(id=321L)
    public int getNotifySSLBindPort() {
        return this.getIntAttr("zimbraNotifySSLBindPort", 7036);
    }

    @ZAttr(id=321L)
    public void setNotifySSLBindPort(int zimbraNotifySSLBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifySSLBindPort", Integer.toString(zimbraNotifySSLBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=321L)
    public Map<String, Object> setNotifySSLBindPort(int zimbraNotifySSLBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLBindPort", Integer.toString(zimbraNotifySSLBindPort));
        return attrs;
    }

    @ZAttr(id=321L)
    public void unsetNotifySSLBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifySSLBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=321L)
    public Map<String, Object> unsetNotifySSLBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLBindPort", "");
        return attrs;
    }

    @ZAttr(id=319L)
    public boolean isNotifySSLServerEnabled() {
        return this.getBooleanAttr("zimbraNotifySSLServerEnabled", true);
    }

    @ZAttr(id=319L)
    public void setNotifySSLServerEnabled(boolean zimbraNotifySSLServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifySSLServerEnabled", zimbraNotifySSLServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=319L)
    public Map<String, Object> setNotifySSLServerEnabled(boolean zimbraNotifySSLServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLServerEnabled", zimbraNotifySSLServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=319L)
    public void unsetNotifySSLServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifySSLServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=319L)
    public Map<String, Object> unsetNotifySSLServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=316L)
    public boolean isNotifyServerEnabled() {
        return this.getBooleanAttr("zimbraNotifyServerEnabled", true);
    }

    @ZAttr(id=316L)
    public void setNotifyServerEnabled(boolean zimbraNotifyServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifyServerEnabled", zimbraNotifyServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=316L)
    public Map<String, Object> setNotifyServerEnabled(boolean zimbraNotifyServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyServerEnabled", zimbraNotifyServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=316L)
    public void unsetNotifyServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifyServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=316L)
    public Map<String, Object> unsetNotifyServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=93L)
    public String getPop3AdvertisedName() {
        return this.getAttr("zimbraPop3AdvertisedName", null);
    }

    @ZAttr(id=93L)
    public void setPop3AdvertisedName(String zimbraPop3AdvertisedName) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3AdvertisedName", zimbraPop3AdvertisedName);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=93L)
    public Map<String, Object> setPop3AdvertisedName(String zimbraPop3AdvertisedName, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3AdvertisedName", zimbraPop3AdvertisedName);
        return attrs;
    }

    @ZAttr(id=93L)
    public void unsetPop3AdvertisedName() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3AdvertisedName", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=93L)
    public Map<String, Object> unsetPop3AdvertisedName(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3AdvertisedName", "");
        return attrs;
    }

    @ZAttr(id=95L)
    public String[] getPop3BindAddress() {
        return this.getMultiAttr("zimbraPop3BindAddress");
    }

    @ZAttr(id=95L)
    public void setPop3BindAddress(String[] zimbraPop3BindAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraPop3BindAddress", zimbraPop3BindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=95L)
    public Map<String, Object> setPop3BindAddress(String[] zimbraPop3BindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindAddress", zimbraPop3BindAddress);
        return attrs;
    }

    @ZAttr(id=95L)
    public void addPop3BindAddress(String zimbraPop3BindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraPop3BindAddress", zimbraPop3BindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=95L)
    public Map<String, Object> addPop3BindAddress(String zimbraPop3BindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraPop3BindAddress", zimbraPop3BindAddress);
        return attrs;
    }

    @ZAttr(id=95L)
    public void removePop3BindAddress(String zimbraPop3BindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraPop3BindAddress", zimbraPop3BindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=95L)
    public Map<String, Object> removePop3BindAddress(String zimbraPop3BindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraPop3BindAddress", zimbraPop3BindAddress);
        return attrs;
    }

    @ZAttr(id=95L)
    public void unsetPop3BindAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3BindAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=95L)
    public Map<String, Object> unsetPop3BindAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindAddress", "");
        return attrs;
    }

    @ZAttr(id=271L)
    public boolean isPop3BindOnStartup() {
        return this.getBooleanAttr("zimbraPop3BindOnStartup", true);
    }

    @ZAttr(id=271L)
    public void setPop3BindOnStartup(boolean zimbraPop3BindOnStartup) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3BindOnStartup", zimbraPop3BindOnStartup ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=271L)
    public Map<String, Object> setPop3BindOnStartup(boolean zimbraPop3BindOnStartup, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindOnStartup", zimbraPop3BindOnStartup ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=271L)
    public void unsetPop3BindOnStartup() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3BindOnStartup", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=271L)
    public Map<String, Object> unsetPop3BindOnStartup(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindOnStartup", "");
        return attrs;
    }

    @ZAttr(id=94L)
    public int getPop3BindPort() {
        return this.getIntAttr("zimbraPop3BindPort", 7110);
    }

    @ZAttr(id=94L)
    public String getPop3BindPortAsString() {
        return this.getAttr("zimbraPop3BindPort", "7110");
    }

    @ZAttr(id=94L)
    public void setPop3BindPort(int zimbraPop3BindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3BindPort", Integer.toString(zimbraPop3BindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=94L)
    public Map<String, Object> setPop3BindPort(int zimbraPop3BindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindPort", Integer.toString(zimbraPop3BindPort));
        return attrs;
    }

    @ZAttr(id=94L)
    public void setPop3BindPortAsString(String zimbraPop3BindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3BindPort", zimbraPop3BindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=94L)
    public Map<String, Object> setPop3BindPortAsString(String zimbraPop3BindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindPort", zimbraPop3BindPort);
        return attrs;
    }

    @ZAttr(id=94L)
    public void unsetPop3BindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3BindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=94L)
    public Map<String, Object> unsetPop3BindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindPort", "");
        return attrs;
    }

    @ZAttr(id=189L)
    public boolean isPop3CleartextLoginEnabled() {
        return this.getBooleanAttr("zimbraPop3CleartextLoginEnabled", false);
    }

    @ZAttr(id=189L)
    public void setPop3CleartextLoginEnabled(boolean zimbraPop3CleartextLoginEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3CleartextLoginEnabled", zimbraPop3CleartextLoginEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=189L)
    public Map<String, Object> setPop3CleartextLoginEnabled(boolean zimbraPop3CleartextLoginEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3CleartextLoginEnabled", zimbraPop3CleartextLoginEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=189L)
    public void unsetPop3CleartextLoginEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3CleartextLoginEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=189L)
    public Map<String, Object> unsetPop3CleartextLoginEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3CleartextLoginEnabled", "");
        return attrs;
    }

    @ZAttr(id=692L)
    public boolean isPop3ExposeVersionOnBanner() {
        return this.getBooleanAttr("zimbraPop3ExposeVersionOnBanner", false);
    }

    @ZAttr(id=692L)
    public void setPop3ExposeVersionOnBanner(boolean zimbraPop3ExposeVersionOnBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ExposeVersionOnBanner", zimbraPop3ExposeVersionOnBanner ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=692L)
    public Map<String, Object> setPop3ExposeVersionOnBanner(boolean zimbraPop3ExposeVersionOnBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ExposeVersionOnBanner", zimbraPop3ExposeVersionOnBanner ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=692L)
    public void unsetPop3ExposeVersionOnBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ExposeVersionOnBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=692L)
    public Map<String, Object> unsetPop3ExposeVersionOnBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ExposeVersionOnBanner", "");
        return attrs;
    }

    @ZAttr(id=96L)
    public int getPop3NumThreads() {
        return this.getIntAttr("zimbraPop3NumThreads", 100);
    }

    @ZAttr(id=96L)
    public void setPop3NumThreads(int zimbraPop3NumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3NumThreads", Integer.toString(zimbraPop3NumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=96L)
    public Map<String, Object> setPop3NumThreads(int zimbraPop3NumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3NumThreads", Integer.toString(zimbraPop3NumThreads));
        return attrs;
    }

    @ZAttr(id=96L)
    public void unsetPop3NumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3NumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=96L)
    public Map<String, Object> unsetPop3NumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3NumThreads", "");
        return attrs;
    }

    @ZAttr(id=350L)
    public int getPop3ProxyBindPort() {
        return this.getIntAttr("zimbraPop3ProxyBindPort", 110);
    }

    @ZAttr(id=350L)
    public String getPop3ProxyBindPortAsString() {
        return this.getAttr("zimbraPop3ProxyBindPort", "110");
    }

    @ZAttr(id=350L)
    public void setPop3ProxyBindPort(int zimbraPop3ProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ProxyBindPort", Integer.toString(zimbraPop3ProxyBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=350L)
    public Map<String, Object> setPop3ProxyBindPort(int zimbraPop3ProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ProxyBindPort", Integer.toString(zimbraPop3ProxyBindPort));
        return attrs;
    }

    @ZAttr(id=350L)
    public void setPop3ProxyBindPortAsString(String zimbraPop3ProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ProxyBindPort", zimbraPop3ProxyBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=350L)
    public Map<String, Object> setPop3ProxyBindPortAsString(String zimbraPop3ProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ProxyBindPort", zimbraPop3ProxyBindPort);
        return attrs;
    }

    @ZAttr(id=350L)
    public void unsetPop3ProxyBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ProxyBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=350L)
    public Map<String, Object> unsetPop3ProxyBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ProxyBindPort", "");
        return attrs;
    }

    @ZAttr(id=186L)
    public String[] getPop3SSLBindAddress() {
        return this.getMultiAttr("zimbraPop3SSLBindAddress");
    }

    @ZAttr(id=186L)
    public void setPop3SSLBindAddress(String[] zimbraPop3SSLBindAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraPop3SSLBindAddress", zimbraPop3SSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=186L)
    public Map<String, Object> setPop3SSLBindAddress(String[] zimbraPop3SSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindAddress", zimbraPop3SSLBindAddress);
        return attrs;
    }

    @ZAttr(id=186L)
    public void addPop3SSLBindAddress(String zimbraPop3SSLBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraPop3SSLBindAddress", zimbraPop3SSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=186L)
    public Map<String, Object> addPop3SSLBindAddress(String zimbraPop3SSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraPop3SSLBindAddress", zimbraPop3SSLBindAddress);
        return attrs;
    }

    @ZAttr(id=186L)
    public void removePop3SSLBindAddress(String zimbraPop3SSLBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraPop3SSLBindAddress", zimbraPop3SSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=186L)
    public Map<String, Object> removePop3SSLBindAddress(String zimbraPop3SSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraPop3SSLBindAddress", zimbraPop3SSLBindAddress);
        return attrs;
    }

    @ZAttr(id=186L)
    public void unsetPop3SSLBindAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLBindAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=186L)
    public Map<String, Object> unsetPop3SSLBindAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindAddress", "");
        return attrs;
    }

    @ZAttr(id=272L)
    public boolean isPop3SSLBindOnStartup() {
        return this.getBooleanAttr("zimbraPop3SSLBindOnStartup", true);
    }

    @ZAttr(id=272L)
    public void setPop3SSLBindOnStartup(boolean zimbraPop3SSLBindOnStartup) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLBindOnStartup", zimbraPop3SSLBindOnStartup ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=272L)
    public Map<String, Object> setPop3SSLBindOnStartup(boolean zimbraPop3SSLBindOnStartup, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindOnStartup", zimbraPop3SSLBindOnStartup ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=272L)
    public void unsetPop3SSLBindOnStartup() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLBindOnStartup", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=272L)
    public Map<String, Object> unsetPop3SSLBindOnStartup(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindOnStartup", "");
        return attrs;
    }

    @ZAttr(id=187L)
    public int getPop3SSLBindPort() {
        return this.getIntAttr("zimbraPop3SSLBindPort", 7995);
    }

    @ZAttr(id=187L)
    public String getPop3SSLBindPortAsString() {
        return this.getAttr("zimbraPop3SSLBindPort", "7995");
    }

    @ZAttr(id=187L)
    public void setPop3SSLBindPort(int zimbraPop3SSLBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLBindPort", Integer.toString(zimbraPop3SSLBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=187L)
    public Map<String, Object> setPop3SSLBindPort(int zimbraPop3SSLBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindPort", Integer.toString(zimbraPop3SSLBindPort));
        return attrs;
    }

    @ZAttr(id=187L)
    public void setPop3SSLBindPortAsString(String zimbraPop3SSLBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLBindPort", zimbraPop3SSLBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=187L)
    public Map<String, Object> setPop3SSLBindPortAsString(String zimbraPop3SSLBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindPort", zimbraPop3SSLBindPort);
        return attrs;
    }

    @ZAttr(id=187L)
    public void unsetPop3SSLBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=187L)
    public Map<String, Object> unsetPop3SSLBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindPort", "");
        return attrs;
    }

    @ZAttr(id=351L)
    public int getPop3SSLProxyBindPort() {
        return this.getIntAttr("zimbraPop3SSLProxyBindPort", 995);
    }

    @ZAttr(id=351L)
    public String getPop3SSLProxyBindPortAsString() {
        return this.getAttr("zimbraPop3SSLProxyBindPort", "995");
    }

    @ZAttr(id=351L)
    public void setPop3SSLProxyBindPort(int zimbraPop3SSLProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLProxyBindPort", Integer.toString(zimbraPop3SSLProxyBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=351L)
    public Map<String, Object> setPop3SSLProxyBindPort(int zimbraPop3SSLProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLProxyBindPort", Integer.toString(zimbraPop3SSLProxyBindPort));
        return attrs;
    }

    @ZAttr(id=351L)
    public void setPop3SSLProxyBindPortAsString(String zimbraPop3SSLProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLProxyBindPort", zimbraPop3SSLProxyBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=351L)
    public Map<String, Object> setPop3SSLProxyBindPortAsString(String zimbraPop3SSLProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLProxyBindPort", zimbraPop3SSLProxyBindPort);
        return attrs;
    }

    @ZAttr(id=351L)
    public void unsetPop3SSLProxyBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLProxyBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=351L)
    public Map<String, Object> unsetPop3SSLProxyBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLProxyBindPort", "");
        return attrs;
    }

    @ZAttr(id=188L)
    public boolean isPop3SSLServerEnabled() {
        return this.getBooleanAttr("zimbraPop3SSLServerEnabled", true);
    }

    @ZAttr(id=188L)
    public void setPop3SSLServerEnabled(boolean zimbraPop3SSLServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLServerEnabled", zimbraPop3SSLServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=188L)
    public Map<String, Object> setPop3SSLServerEnabled(boolean zimbraPop3SSLServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLServerEnabled", zimbraPop3SSLServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=188L)
    public void unsetPop3SSLServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=188L)
    public Map<String, Object> unsetPop3SSLServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=554L)
    public boolean isPop3SaslGssapiEnabled() {
        return this.getBooleanAttr("zimbraPop3SaslGssapiEnabled", false);
    }

    @ZAttr(id=554L)
    public void setPop3SaslGssapiEnabled(boolean zimbraPop3SaslGssapiEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SaslGssapiEnabled", zimbraPop3SaslGssapiEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=554L)
    public Map<String, Object> setPop3SaslGssapiEnabled(boolean zimbraPop3SaslGssapiEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SaslGssapiEnabled", zimbraPop3SaslGssapiEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=554L)
    public void unsetPop3SaslGssapiEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SaslGssapiEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=554L)
    public Map<String, Object> unsetPop3SaslGssapiEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SaslGssapiEnabled", "");
        return attrs;
    }

    @ZAttr(id=177L)
    public boolean isPop3ServerEnabled() {
        return this.getBooleanAttr("zimbraPop3ServerEnabled", true);
    }

    @ZAttr(id=177L)
    public void setPop3ServerEnabled(boolean zimbraPop3ServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ServerEnabled", zimbraPop3ServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=177L)
    public Map<String, Object> setPop3ServerEnabled(boolean zimbraPop3ServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ServerEnabled", zimbraPop3ServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=177L)
    public void unsetPop3ServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=177L)
    public Map<String, Object> unsetPop3ServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=76L)
    public String getRedoLogArchiveDir() {
        return this.getAttr("zimbraRedoLogArchiveDir", "redolog/archive");
    }

    @ZAttr(id=76L)
    public void setRedoLogArchiveDir(String zimbraRedoLogArchiveDir) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogArchiveDir", zimbraRedoLogArchiveDir);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=76L)
    public Map<String, Object> setRedoLogArchiveDir(String zimbraRedoLogArchiveDir, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogArchiveDir", zimbraRedoLogArchiveDir);
        return attrs;
    }

    @ZAttr(id=76L)
    public void unsetRedoLogArchiveDir() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogArchiveDir", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=76L)
    public Map<String, Object> unsetRedoLogArchiveDir(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogArchiveDir", "");
        return attrs;
    }

    @ZAttr(id=1009L)
    public int getRedoLogCrashRecoveryLookbackSec() {
        return this.getIntAttr("zimbraRedoLogCrashRecoveryLookbackSec", 10);
    }

    @ZAttr(id=1009L)
    public void setRedoLogCrashRecoveryLookbackSec(int zimbraRedoLogCrashRecoveryLookbackSec) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogCrashRecoveryLookbackSec", Integer.toString(zimbraRedoLogCrashRecoveryLookbackSec));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1009L)
    public Map<String, Object> setRedoLogCrashRecoveryLookbackSec(int zimbraRedoLogCrashRecoveryLookbackSec, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogCrashRecoveryLookbackSec", Integer.toString(zimbraRedoLogCrashRecoveryLookbackSec));
        return attrs;
    }

    @ZAttr(id=1009L)
    public void unsetRedoLogCrashRecoveryLookbackSec() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogCrashRecoveryLookbackSec", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1009L)
    public Map<String, Object> unsetRedoLogCrashRecoveryLookbackSec(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogCrashRecoveryLookbackSec", "");
        return attrs;
    }

    @ZAttr(id=251L)
    public boolean isRedoLogDeleteOnRollover() {
        return this.getBooleanAttr("zimbraRedoLogDeleteOnRollover", true);
    }

    @ZAttr(id=251L)
    public void setRedoLogDeleteOnRollover(boolean zimbraRedoLogDeleteOnRollover) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogDeleteOnRollover", zimbraRedoLogDeleteOnRollover ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=251L)
    public Map<String, Object> setRedoLogDeleteOnRollover(boolean zimbraRedoLogDeleteOnRollover, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogDeleteOnRollover", zimbraRedoLogDeleteOnRollover ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=251L)
    public void unsetRedoLogDeleteOnRollover() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogDeleteOnRollover", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=251L)
    public Map<String, Object> unsetRedoLogDeleteOnRollover(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogDeleteOnRollover", "");
        return attrs;
    }

    @ZAttr(id=74L)
    public boolean isRedoLogEnabled() {
        return this.getBooleanAttr("zimbraRedoLogEnabled", true);
    }

    @ZAttr(id=74L)
    public void setRedoLogEnabled(boolean zimbraRedoLogEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogEnabled", zimbraRedoLogEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=74L)
    public Map<String, Object> setRedoLogEnabled(boolean zimbraRedoLogEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogEnabled", zimbraRedoLogEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=74L)
    public void unsetRedoLogEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=74L)
    public Map<String, Object> unsetRedoLogEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogEnabled", "");
        return attrs;
    }

    @ZAttr(id=79L)
    public int getRedoLogFsyncIntervalMS() {
        return this.getIntAttr("zimbraRedoLogFsyncIntervalMS", 10);
    }

    @ZAttr(id=79L)
    public void setRedoLogFsyncIntervalMS(int zimbraRedoLogFsyncIntervalMS) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogFsyncIntervalMS", Integer.toString(zimbraRedoLogFsyncIntervalMS));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=79L)
    public Map<String, Object> setRedoLogFsyncIntervalMS(int zimbraRedoLogFsyncIntervalMS, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogFsyncIntervalMS", Integer.toString(zimbraRedoLogFsyncIntervalMS));
        return attrs;
    }

    @ZAttr(id=79L)
    public void unsetRedoLogFsyncIntervalMS() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogFsyncIntervalMS", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=79L)
    public Map<String, Object> unsetRedoLogFsyncIntervalMS(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogFsyncIntervalMS", "");
        return attrs;
    }

    @ZAttr(id=75L)
    public String getRedoLogLogPath() {
        return this.getAttr("zimbraRedoLogLogPath", "redolog/redo.log");
    }

    @ZAttr(id=75L)
    public void setRedoLogLogPath(String zimbraRedoLogLogPath) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogLogPath", zimbraRedoLogLogPath);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=75L)
    public Map<String, Object> setRedoLogLogPath(String zimbraRedoLogLogPath, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogLogPath", zimbraRedoLogLogPath);
        return attrs;
    }

    @ZAttr(id=75L)
    public void unsetRedoLogLogPath() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogLogPath", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=75L)
    public Map<String, Object> unsetRedoLogLogPath(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogLogPath", "");
        return attrs;
    }

    @ZAttr(id=225L)
    public String[] getRedoLogProvider() {
        return this.getMultiAttr("zimbraRedoLogProvider");
    }

    @ZAttr(id=225L)
    public void setRedoLogProvider(String[] zimbraRedoLogProvider) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraRedoLogProvider", zimbraRedoLogProvider);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=225L)
    public Map<String, Object> setRedoLogProvider(String[] zimbraRedoLogProvider, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogProvider", zimbraRedoLogProvider);
        return attrs;
    }

    @ZAttr(id=225L)
    public void addRedoLogProvider(String zimbraRedoLogProvider) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraRedoLogProvider", zimbraRedoLogProvider);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=225L)
    public Map<String, Object> addRedoLogProvider(String zimbraRedoLogProvider, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraRedoLogProvider", zimbraRedoLogProvider);
        return attrs;
    }

    @ZAttr(id=225L)
    public void removeRedoLogProvider(String zimbraRedoLogProvider) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraRedoLogProvider", zimbraRedoLogProvider);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=225L)
    public Map<String, Object> removeRedoLogProvider(String zimbraRedoLogProvider, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraRedoLogProvider", zimbraRedoLogProvider);
        return attrs;
    }

    @ZAttr(id=225L)
    public void unsetRedoLogProvider() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogProvider", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=225L)
    public Map<String, Object> unsetRedoLogProvider(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogProvider", "");
        return attrs;
    }

    @ZAttr(id=78L)
    public int getRedoLogRolloverFileSizeKB() {
        return this.getIntAttr("zimbraRedoLogRolloverFileSizeKB", 0x100000);
    }

    @ZAttr(id=78L)
    public void setRedoLogRolloverFileSizeKB(int zimbraRedoLogRolloverFileSizeKB) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverFileSizeKB", Integer.toString(zimbraRedoLogRolloverFileSizeKB));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=78L)
    public Map<String, Object> setRedoLogRolloverFileSizeKB(int zimbraRedoLogRolloverFileSizeKB, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverFileSizeKB", Integer.toString(zimbraRedoLogRolloverFileSizeKB));
        return attrs;
    }

    @ZAttr(id=78L)
    public void unsetRedoLogRolloverFileSizeKB() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverFileSizeKB", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=78L)
    public Map<String, Object> unsetRedoLogRolloverFileSizeKB(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverFileSizeKB", "");
        return attrs;
    }

    @ZAttr(id=1021L)
    public int getRedoLogRolloverHardMaxFileSizeKB() {
        return this.getIntAttr("zimbraRedoLogRolloverHardMaxFileSizeKB", 0x400000);
    }

    @ZAttr(id=1021L)
    public void setRedoLogRolloverHardMaxFileSizeKB(int zimbraRedoLogRolloverHardMaxFileSizeKB) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverHardMaxFileSizeKB", Integer.toString(zimbraRedoLogRolloverHardMaxFileSizeKB));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1021L)
    public Map<String, Object> setRedoLogRolloverHardMaxFileSizeKB(int zimbraRedoLogRolloverHardMaxFileSizeKB, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverHardMaxFileSizeKB", Integer.toString(zimbraRedoLogRolloverHardMaxFileSizeKB));
        return attrs;
    }

    @ZAttr(id=1021L)
    public void unsetRedoLogRolloverHardMaxFileSizeKB() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverHardMaxFileSizeKB", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1021L)
    public Map<String, Object> unsetRedoLogRolloverHardMaxFileSizeKB(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverHardMaxFileSizeKB", "");
        return attrs;
    }

    @ZAttr(id=1020L)
    public int getRedoLogRolloverMinFileAge() {
        return this.getIntAttr("zimbraRedoLogRolloverMinFileAge", 60);
    }

    @ZAttr(id=1020L)
    public void setRedoLogRolloverMinFileAge(int zimbraRedoLogRolloverMinFileAge) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverMinFileAge", Integer.toString(zimbraRedoLogRolloverMinFileAge));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1020L)
    public Map<String, Object> setRedoLogRolloverMinFileAge(int zimbraRedoLogRolloverMinFileAge, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverMinFileAge", Integer.toString(zimbraRedoLogRolloverMinFileAge));
        return attrs;
    }

    @ZAttr(id=1020L)
    public void unsetRedoLogRolloverMinFileAge() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverMinFileAge", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1020L)
    public Map<String, Object> unsetRedoLogRolloverMinFileAge(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverMinFileAge", "");
        return attrs;
    }

    @ZAttr(id=336L)
    public String getRemoteManagementCommand() {
        return this.getAttr("zimbraRemoteManagementCommand", "/opt/zimbra/libexec/zmrcd");
    }

    @ZAttr(id=336L)
    public void setRemoteManagementCommand(String zimbraRemoteManagementCommand) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementCommand", zimbraRemoteManagementCommand);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=336L)
    public Map<String, Object> setRemoteManagementCommand(String zimbraRemoteManagementCommand, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementCommand", zimbraRemoteManagementCommand);
        return attrs;
    }

    @ZAttr(id=336L)
    public void unsetRemoteManagementCommand() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementCommand", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=336L)
    public Map<String, Object> unsetRemoteManagementCommand(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementCommand", "");
        return attrs;
    }

    @ZAttr(id=339L)
    public int getRemoteManagementPort() {
        return this.getIntAttr("zimbraRemoteManagementPort", 22);
    }

    @ZAttr(id=339L)
    public void setRemoteManagementPort(int zimbraRemoteManagementPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementPort", Integer.toString(zimbraRemoteManagementPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=339L)
    public Map<String, Object> setRemoteManagementPort(int zimbraRemoteManagementPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementPort", Integer.toString(zimbraRemoteManagementPort));
        return attrs;
    }

    @ZAttr(id=339L)
    public void unsetRemoteManagementPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=339L)
    public Map<String, Object> unsetRemoteManagementPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementPort", "");
        return attrs;
    }

    @ZAttr(id=338L)
    public String getRemoteManagementPrivateKeyPath() {
        return this.getAttr("zimbraRemoteManagementPrivateKeyPath", "/opt/zimbra/.ssh/zimbra_identity");
    }

    @ZAttr(id=338L)
    public void setRemoteManagementPrivateKeyPath(String zimbraRemoteManagementPrivateKeyPath) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementPrivateKeyPath", zimbraRemoteManagementPrivateKeyPath);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=338L)
    public Map<String, Object> setRemoteManagementPrivateKeyPath(String zimbraRemoteManagementPrivateKeyPath, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementPrivateKeyPath", zimbraRemoteManagementPrivateKeyPath);
        return attrs;
    }

    @ZAttr(id=338L)
    public void unsetRemoteManagementPrivateKeyPath() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementPrivateKeyPath", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=338L)
    public Map<String, Object> unsetRemoteManagementPrivateKeyPath(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementPrivateKeyPath", "");
        return attrs;
    }

    @ZAttr(id=337L)
    public String getRemoteManagementUser() {
        return this.getAttr("zimbraRemoteManagementUser", "zimbra");
    }

    @ZAttr(id=337L)
    public void setRemoteManagementUser(String zimbraRemoteManagementUser) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementUser", zimbraRemoteManagementUser);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=337L)
    public Map<String, Object> setRemoteManagementUser(String zimbraRemoteManagementUser, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementUser", zimbraRemoteManagementUser);
        return attrs;
    }

    @ZAttr(id=337L)
    public void unsetRemoteManagementUser() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementUser", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=337L)
    public Map<String, Object> unsetRemoteManagementUser(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementUser", "");
        return attrs;
    }

    @ZAttr(id=797L)
    public long getReverseProxyConnectTimeout() {
        return this.getTimeInterval("zimbraReverseProxyConnectTimeout", 120000L);
    }

    @ZAttr(id=797L)
    public String getReverseProxyConnectTimeoutAsString() {
        return this.getAttr("zimbraReverseProxyConnectTimeout", "120000ms");
    }

    @ZAttr(id=797L)
    public void setReverseProxyConnectTimeout(String zimbraReverseProxyConnectTimeout) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyConnectTimeout", zimbraReverseProxyConnectTimeout);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=797L)
    public Map<String, Object> setReverseProxyConnectTimeout(String zimbraReverseProxyConnectTimeout, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyConnectTimeout", zimbraReverseProxyConnectTimeout);
        return attrs;
    }

    @ZAttr(id=797L)
    public void unsetReverseProxyConnectTimeout() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyConnectTimeout", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=797L)
    public Map<String, Object> unsetReverseProxyConnectTimeout(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyConnectTimeout", "");
        return attrs;
    }

    @ZAttr(id=703L)
    public String getReverseProxyDefaultRealm() {
        return this.getAttr("zimbraReverseProxyDefaultRealm", null);
    }

    @ZAttr(id=703L)
    public void setReverseProxyDefaultRealm(String zimbraReverseProxyDefaultRealm) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyDefaultRealm", zimbraReverseProxyDefaultRealm);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=703L)
    public Map<String, Object> setReverseProxyDefaultRealm(String zimbraReverseProxyDefaultRealm, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyDefaultRealm", zimbraReverseProxyDefaultRealm);
        return attrs;
    }

    @ZAttr(id=703L)
    public void unsetReverseProxyDefaultRealm() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyDefaultRealm", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=703L)
    public Map<String, Object> unsetReverseProxyDefaultRealm(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyDefaultRealm", "");
        return attrs;
    }

    @ZAttr(id=628L)
    public boolean isReverseProxyHttpEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyHttpEnabled", false);
    }

    @ZAttr(id=628L)
    public void setReverseProxyHttpEnabled(boolean zimbraReverseProxyHttpEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyHttpEnabled", zimbraReverseProxyHttpEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=628L)
    public Map<String, Object> setReverseProxyHttpEnabled(boolean zimbraReverseProxyHttpEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyHttpEnabled", zimbraReverseProxyHttpEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=628L)
    public void unsetReverseProxyHttpEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyHttpEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=628L)
    public Map<String, Object> unsetReverseProxyHttpEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyHttpEnabled", "");
        return attrs;
    }

    @ZAttr(id=719L)
    public String[] getReverseProxyImapEnabledCapability() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraReverseProxyImapEnabledCapability");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[26];
            stringArray2[0] = "IMAP4rev1";
            stringArray2[1] = "ACL";
            stringArray2[2] = "BINARY";
            stringArray2[3] = "CATENATE";
            stringArray2[4] = "CHILDREN";
            stringArray2[5] = "CONDSTORE";
            stringArray2[6] = "ENABLE";
            stringArray2[7] = "ESEARCH";
            stringArray2[8] = "ESORT";
            stringArray2[9] = "I18NLEVEL=1";
            stringArray2[10] = "ID";
            stringArray2[11] = "IDLE";
            stringArray2[12] = "LIST-EXTENDED";
            stringArray2[13] = "LITERAL+";
            stringArray2[14] = "MULTIAPPEND";
            stringArray2[15] = "NAMESPACE";
            stringArray2[16] = "QRESYNC";
            stringArray2[17] = "QUOTA";
            stringArray2[18] = "RIGHTS=ektx";
            stringArray2[19] = "SASL-IR";
            stringArray2[20] = "SEARCHRES";
            stringArray2[21] = "SORT";
            stringArray2[22] = "THREAD=ORDEREDSUBJECT";
            stringArray2[23] = "UIDPLUS";
            stringArray2[24] = "UNSELECT";
            stringArray = stringArray2;
            stringArray2[25] = "WITHIN";
        }
        return stringArray;
    }

    @ZAttr(id=719L)
    public void setReverseProxyImapEnabledCapability(String[] zimbraReverseProxyImapEnabledCapability) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=719L)
    public Map<String, Object> setReverseProxyImapEnabledCapability(String[] zimbraReverseProxyImapEnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        return attrs;
    }

    @ZAttr(id=719L)
    public void addReverseProxyImapEnabledCapability(String zimbraReverseProxyImapEnabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=719L)
    public Map<String, Object> addReverseProxyImapEnabledCapability(String zimbraReverseProxyImapEnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        return attrs;
    }

    @ZAttr(id=719L)
    public void removeReverseProxyImapEnabledCapability(String zimbraReverseProxyImapEnabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=719L)
    public Map<String, Object> removeReverseProxyImapEnabledCapability(String zimbraReverseProxyImapEnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        return attrs;
    }

    @ZAttr(id=719L)
    public void unsetReverseProxyImapEnabledCapability() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapEnabledCapability", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=719L)
    public Map<String, Object> unsetReverseProxyImapEnabledCapability(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapEnabledCapability", "");
        return attrs;
    }

    @ZAttr(id=713L)
    public boolean isReverseProxyImapExposeVersionOnBanner() {
        return this.getBooleanAttr("zimbraReverseProxyImapExposeVersionOnBanner", false);
    }

    @ZAttr(id=713L)
    public void setReverseProxyImapExposeVersionOnBanner(boolean zimbraReverseProxyImapExposeVersionOnBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapExposeVersionOnBanner", zimbraReverseProxyImapExposeVersionOnBanner ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=713L)
    public Map<String, Object> setReverseProxyImapExposeVersionOnBanner(boolean zimbraReverseProxyImapExposeVersionOnBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapExposeVersionOnBanner", zimbraReverseProxyImapExposeVersionOnBanner ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=713L)
    public void unsetReverseProxyImapExposeVersionOnBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapExposeVersionOnBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=713L)
    public Map<String, Object> unsetReverseProxyImapExposeVersionOnBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapExposeVersionOnBanner", "");
        return attrs;
    }

    @ZAttr(id=643L)
    public boolean isReverseProxyImapSaslGssapiEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyImapSaslGssapiEnabled", false);
    }

    @ZAttr(id=643L)
    public void setReverseProxyImapSaslGssapiEnabled(boolean zimbraReverseProxyImapSaslGssapiEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapSaslGssapiEnabled", zimbraReverseProxyImapSaslGssapiEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=643L)
    public Map<String, Object> setReverseProxyImapSaslGssapiEnabled(boolean zimbraReverseProxyImapSaslGssapiEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapSaslGssapiEnabled", zimbraReverseProxyImapSaslGssapiEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=643L)
    public void unsetReverseProxyImapSaslGssapiEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapSaslGssapiEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=643L)
    public Map<String, Object> unsetReverseProxyImapSaslGssapiEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapSaslGssapiEnabled", "");
        return attrs;
    }

    @ZAttr(id=728L)
    public boolean isReverseProxyImapSaslPlainEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyImapSaslPlainEnabled", true);
    }

    @ZAttr(id=728L)
    public void setReverseProxyImapSaslPlainEnabled(boolean zimbraReverseProxyImapSaslPlainEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapSaslPlainEnabled", zimbraReverseProxyImapSaslPlainEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=728L)
    public Map<String, Object> setReverseProxyImapSaslPlainEnabled(boolean zimbraReverseProxyImapSaslPlainEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapSaslPlainEnabled", zimbraReverseProxyImapSaslPlainEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=728L)
    public void unsetReverseProxyImapSaslPlainEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapSaslPlainEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=728L)
    public Map<String, Object> unsetReverseProxyImapSaslPlainEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapSaslPlainEnabled", "");
        return attrs;
    }

    @ZAttr(id=641L)
    public ZAttrProvisioning.ReverseProxyImapStartTlsMode getReverseProxyImapStartTlsMode() {
        try {
            String v = this.getAttr("zimbraReverseProxyImapStartTlsMode");
            return v == null ? ZAttrProvisioning.ReverseProxyImapStartTlsMode.only : ZAttrProvisioning.ReverseProxyImapStartTlsMode.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.ReverseProxyImapStartTlsMode.only;
        }
    }

    @ZAttr(id=641L)
    public String getReverseProxyImapStartTlsModeAsString() {
        return this.getAttr("zimbraReverseProxyImapStartTlsMode", "only");
    }

    @ZAttr(id=641L)
    public void setReverseProxyImapStartTlsMode(ZAttrProvisioning.ReverseProxyImapStartTlsMode zimbraReverseProxyImapStartTlsMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapStartTlsMode", zimbraReverseProxyImapStartTlsMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=641L)
    public Map<String, Object> setReverseProxyImapStartTlsMode(ZAttrProvisioning.ReverseProxyImapStartTlsMode zimbraReverseProxyImapStartTlsMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapStartTlsMode", zimbraReverseProxyImapStartTlsMode.toString());
        return attrs;
    }

    @ZAttr(id=641L)
    public void setReverseProxyImapStartTlsModeAsString(String zimbraReverseProxyImapStartTlsMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapStartTlsMode", zimbraReverseProxyImapStartTlsMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=641L)
    public Map<String, Object> setReverseProxyImapStartTlsModeAsString(String zimbraReverseProxyImapStartTlsMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapStartTlsMode", zimbraReverseProxyImapStartTlsMode);
        return attrs;
    }

    @ZAttr(id=641L)
    public void unsetReverseProxyImapStartTlsMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapStartTlsMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=641L)
    public Map<String, Object> unsetReverseProxyImapStartTlsMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapStartTlsMode", "");
        return attrs;
    }

    @ZAttr(id=735L)
    public long getReverseProxyInactivityTimeout() {
        return this.getTimeInterval("zimbraReverseProxyInactivityTimeout", 3600000L);
    }

    @ZAttr(id=735L)
    public String getReverseProxyInactivityTimeoutAsString() {
        return this.getAttr("zimbraReverseProxyInactivityTimeout", "1h");
    }

    @ZAttr(id=735L)
    public void setReverseProxyInactivityTimeout(String zimbraReverseProxyInactivityTimeout) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyInactivityTimeout", zimbraReverseProxyInactivityTimeout);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=735L)
    public Map<String, Object> setReverseProxyInactivityTimeout(String zimbraReverseProxyInactivityTimeout, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyInactivityTimeout", zimbraReverseProxyInactivityTimeout);
        return attrs;
    }

    @ZAttr(id=735L)
    public void unsetReverseProxyInactivityTimeout() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyInactivityTimeout", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=735L)
    public Map<String, Object> unsetReverseProxyInactivityTimeout(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyInactivityTimeout", "");
        return attrs;
    }

    @ZAttr(id=723L)
    public ZAttrProvisioning.ReverseProxyLogLevel getReverseProxyLogLevel() {
        try {
            String v = this.getAttr("zimbraReverseProxyLogLevel");
            return v == null ? ZAttrProvisioning.ReverseProxyLogLevel.info : ZAttrProvisioning.ReverseProxyLogLevel.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.ReverseProxyLogLevel.info;
        }
    }

    @ZAttr(id=723L)
    public String getReverseProxyLogLevelAsString() {
        return this.getAttr("zimbraReverseProxyLogLevel", "info");
    }

    @ZAttr(id=723L)
    public void setReverseProxyLogLevel(ZAttrProvisioning.ReverseProxyLogLevel zimbraReverseProxyLogLevel) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyLogLevel", zimbraReverseProxyLogLevel.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=723L)
    public Map<String, Object> setReverseProxyLogLevel(ZAttrProvisioning.ReverseProxyLogLevel zimbraReverseProxyLogLevel, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyLogLevel", zimbraReverseProxyLogLevel.toString());
        return attrs;
    }

    @ZAttr(id=723L)
    public void setReverseProxyLogLevelAsString(String zimbraReverseProxyLogLevel) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyLogLevel", zimbraReverseProxyLogLevel);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=723L)
    public Map<String, Object> setReverseProxyLogLevelAsString(String zimbraReverseProxyLogLevel, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyLogLevel", zimbraReverseProxyLogLevel);
        return attrs;
    }

    @ZAttr(id=723L)
    public void unsetReverseProxyLogLevel() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyLogLevel", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=723L)
    public Map<String, Object> unsetReverseProxyLogLevel(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyLogLevel", "");
        return attrs;
    }

    @ZAttr(id=504L)
    public boolean isReverseProxyLookupTarget() {
        return this.getBooleanAttr("zimbraReverseProxyLookupTarget", false);
    }

    @ZAttr(id=504L)
    public void setReverseProxyLookupTarget(boolean zimbraReverseProxyLookupTarget) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyLookupTarget", zimbraReverseProxyLookupTarget ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=504L)
    public Map<String, Object> setReverseProxyLookupTarget(boolean zimbraReverseProxyLookupTarget, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyLookupTarget", zimbraReverseProxyLookupTarget ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=504L)
    public void unsetReverseProxyLookupTarget() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyLookupTarget", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=504L)
    public Map<String, Object> unsetReverseProxyLookupTarget(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyLookupTarget", "");
        return attrs;
    }

    @ZAttr(id=629L)
    public boolean isReverseProxyMailEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyMailEnabled", true);
    }

    @ZAttr(id=629L)
    public void setReverseProxyMailEnabled(boolean zimbraReverseProxyMailEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailEnabled", zimbraReverseProxyMailEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=629L)
    public Map<String, Object> setReverseProxyMailEnabled(boolean zimbraReverseProxyMailEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailEnabled", zimbraReverseProxyMailEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=629L)
    public void unsetReverseProxyMailEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=629L)
    public Map<String, Object> unsetReverseProxyMailEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailEnabled", "");
        return attrs;
    }

    @ZAttr(id=685L)
    public ZAttrProvisioning.ReverseProxyMailMode getReverseProxyMailMode() {
        try {
            String v = this.getAttr("zimbraReverseProxyMailMode");
            return v == null ? null : ZAttrProvisioning.ReverseProxyMailMode.fromString(v);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @ZAttr(id=685L)
    public String getReverseProxyMailModeAsString() {
        return this.getAttr("zimbraReverseProxyMailMode", null);
    }

    @ZAttr(id=685L)
    public void setReverseProxyMailMode(ZAttrProvisioning.ReverseProxyMailMode zimbraReverseProxyMailMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailMode", zimbraReverseProxyMailMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=685L)
    public Map<String, Object> setReverseProxyMailMode(ZAttrProvisioning.ReverseProxyMailMode zimbraReverseProxyMailMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailMode", zimbraReverseProxyMailMode.toString());
        return attrs;
    }

    @ZAttr(id=685L)
    public void setReverseProxyMailModeAsString(String zimbraReverseProxyMailMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailMode", zimbraReverseProxyMailMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=685L)
    public Map<String, Object> setReverseProxyMailModeAsString(String zimbraReverseProxyMailMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailMode", zimbraReverseProxyMailMode);
        return attrs;
    }

    @ZAttr(id=685L)
    public void unsetReverseProxyMailMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=685L)
    public Map<String, Object> unsetReverseProxyMailMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailMode", "");
        return attrs;
    }

    @ZAttr(id=736L)
    public boolean isReverseProxyPassErrors() {
        return this.getBooleanAttr("zimbraReverseProxyPassErrors", true);
    }

    @ZAttr(id=736L)
    public void setReverseProxyPassErrors(boolean zimbraReverseProxyPassErrors) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPassErrors", zimbraReverseProxyPassErrors ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=736L)
    public Map<String, Object> setReverseProxyPassErrors(boolean zimbraReverseProxyPassErrors, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPassErrors", zimbraReverseProxyPassErrors ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=736L)
    public void unsetReverseProxyPassErrors() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPassErrors", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=736L)
    public Map<String, Object> unsetReverseProxyPassErrors(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPassErrors", "");
        return attrs;
    }

    @ZAttr(id=721L)
    public String[] getReverseProxyPop3EnabledCapability() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraReverseProxyPop3EnabledCapability");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "TOP";
            stringArray2[1] = "USER";
            stringArray2[2] = "UIDL";
            stringArray2[3] = "EXPIRE 31 USER";
            stringArray = stringArray2;
            stringArray2[4] = "XOIP";
        }
        return stringArray;
    }

    @ZAttr(id=721L)
    public void setReverseProxyPop3EnabledCapability(String[] zimbraReverseProxyPop3EnabledCapability) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=721L)
    public Map<String, Object> setReverseProxyPop3EnabledCapability(String[] zimbraReverseProxyPop3EnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        return attrs;
    }

    @ZAttr(id=721L)
    public void addReverseProxyPop3EnabledCapability(String zimbraReverseProxyPop3EnabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=721L)
    public Map<String, Object> addReverseProxyPop3EnabledCapability(String zimbraReverseProxyPop3EnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        return attrs;
    }

    @ZAttr(id=721L)
    public void removeReverseProxyPop3EnabledCapability(String zimbraReverseProxyPop3EnabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=721L)
    public Map<String, Object> removeReverseProxyPop3EnabledCapability(String zimbraReverseProxyPop3EnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        return attrs;
    }

    @ZAttr(id=721L)
    public void unsetReverseProxyPop3EnabledCapability() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3EnabledCapability", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=721L)
    public Map<String, Object> unsetReverseProxyPop3EnabledCapability(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3EnabledCapability", "");
        return attrs;
    }

    @ZAttr(id=712L)
    public boolean isReverseProxyPop3ExposeVersionOnBanner() {
        return this.getBooleanAttr("zimbraReverseProxyPop3ExposeVersionOnBanner", false);
    }

    @ZAttr(id=712L)
    public void setReverseProxyPop3ExposeVersionOnBanner(boolean zimbraReverseProxyPop3ExposeVersionOnBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3ExposeVersionOnBanner", zimbraReverseProxyPop3ExposeVersionOnBanner ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=712L)
    public Map<String, Object> setReverseProxyPop3ExposeVersionOnBanner(boolean zimbraReverseProxyPop3ExposeVersionOnBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3ExposeVersionOnBanner", zimbraReverseProxyPop3ExposeVersionOnBanner ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=712L)
    public void unsetReverseProxyPop3ExposeVersionOnBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3ExposeVersionOnBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=712L)
    public Map<String, Object> unsetReverseProxyPop3ExposeVersionOnBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3ExposeVersionOnBanner", "");
        return attrs;
    }

    @ZAttr(id=644L)
    public boolean isReverseProxyPop3SaslGssapiEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyPop3SaslGssapiEnabled", false);
    }

    @ZAttr(id=644L)
    public void setReverseProxyPop3SaslGssapiEnabled(boolean zimbraReverseProxyPop3SaslGssapiEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3SaslGssapiEnabled", zimbraReverseProxyPop3SaslGssapiEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=644L)
    public Map<String, Object> setReverseProxyPop3SaslGssapiEnabled(boolean zimbraReverseProxyPop3SaslGssapiEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3SaslGssapiEnabled", zimbraReverseProxyPop3SaslGssapiEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=644L)
    public void unsetReverseProxyPop3SaslGssapiEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3SaslGssapiEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=644L)
    public Map<String, Object> unsetReverseProxyPop3SaslGssapiEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3SaslGssapiEnabled", "");
        return attrs;
    }

    @ZAttr(id=729L)
    public boolean isReverseProxyPop3SaslPlainEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyPop3SaslPlainEnabled", true);
    }

    @ZAttr(id=729L)
    public void setReverseProxyPop3SaslPlainEnabled(boolean zimbraReverseProxyPop3SaslPlainEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3SaslPlainEnabled", zimbraReverseProxyPop3SaslPlainEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=729L)
    public Map<String, Object> setReverseProxyPop3SaslPlainEnabled(boolean zimbraReverseProxyPop3SaslPlainEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3SaslPlainEnabled", zimbraReverseProxyPop3SaslPlainEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=729L)
    public void unsetReverseProxyPop3SaslPlainEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3SaslPlainEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=729L)
    public Map<String, Object> unsetReverseProxyPop3SaslPlainEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3SaslPlainEnabled", "");
        return attrs;
    }

    @ZAttr(id=642L)
    public ZAttrProvisioning.ReverseProxyPop3StartTlsMode getReverseProxyPop3StartTlsMode() {
        try {
            String v = this.getAttr("zimbraReverseProxyPop3StartTlsMode");
            return v == null ? ZAttrProvisioning.ReverseProxyPop3StartTlsMode.only : ZAttrProvisioning.ReverseProxyPop3StartTlsMode.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.ReverseProxyPop3StartTlsMode.only;
        }
    }

    @ZAttr(id=642L)
    public String getReverseProxyPop3StartTlsModeAsString() {
        return this.getAttr("zimbraReverseProxyPop3StartTlsMode", "only");
    }

    @ZAttr(id=642L)
    public void setReverseProxyPop3StartTlsMode(ZAttrProvisioning.ReverseProxyPop3StartTlsMode zimbraReverseProxyPop3StartTlsMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3StartTlsMode", zimbraReverseProxyPop3StartTlsMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=642L)
    public Map<String, Object> setReverseProxyPop3StartTlsMode(ZAttrProvisioning.ReverseProxyPop3StartTlsMode zimbraReverseProxyPop3StartTlsMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3StartTlsMode", zimbraReverseProxyPop3StartTlsMode.toString());
        return attrs;
    }

    @ZAttr(id=642L)
    public void setReverseProxyPop3StartTlsModeAsString(String zimbraReverseProxyPop3StartTlsMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3StartTlsMode", zimbraReverseProxyPop3StartTlsMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=642L)
    public Map<String, Object> setReverseProxyPop3StartTlsModeAsString(String zimbraReverseProxyPop3StartTlsMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3StartTlsMode", zimbraReverseProxyPop3StartTlsMode);
        return attrs;
    }

    @ZAttr(id=642L)
    public void unsetReverseProxyPop3StartTlsMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3StartTlsMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=642L)
    public Map<String, Object> unsetReverseProxyPop3StartTlsMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3StartTlsMode", "");
        return attrs;
    }

    @ZAttr(id=745L)
    public long getReverseProxyRouteLookupTimeout() {
        return this.getTimeInterval("zimbraReverseProxyRouteLookupTimeout", 15000L);
    }

    @ZAttr(id=745L)
    public String getReverseProxyRouteLookupTimeoutAsString() {
        return this.getAttr("zimbraReverseProxyRouteLookupTimeout", "15s");
    }

    @ZAttr(id=745L)
    public void setReverseProxyRouteLookupTimeout(String zimbraReverseProxyRouteLookupTimeout) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyRouteLookupTimeout", zimbraReverseProxyRouteLookupTimeout);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=745L)
    public Map<String, Object> setReverseProxyRouteLookupTimeout(String zimbraReverseProxyRouteLookupTimeout, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyRouteLookupTimeout", zimbraReverseProxyRouteLookupTimeout);
        return attrs;
    }

    @ZAttr(id=745L)
    public void unsetReverseProxyRouteLookupTimeout() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyRouteLookupTimeout", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=745L)
    public Map<String, Object> unsetReverseProxyRouteLookupTimeout(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyRouteLookupTimeout", "");
        return attrs;
    }

    @ZAttr(id=778L)
    public long getReverseProxyRouteLookupTimeoutCache() {
        return this.getTimeInterval("zimbraReverseProxyRouteLookupTimeoutCache", 60000L);
    }

    @ZAttr(id=778L)
    public String getReverseProxyRouteLookupTimeoutCacheAsString() {
        return this.getAttr("zimbraReverseProxyRouteLookupTimeoutCache", "60s");
    }

    @ZAttr(id=778L)
    public void setReverseProxyRouteLookupTimeoutCache(String zimbraReverseProxyRouteLookupTimeoutCache) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyRouteLookupTimeoutCache", zimbraReverseProxyRouteLookupTimeoutCache);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=778L)
    public Map<String, Object> setReverseProxyRouteLookupTimeoutCache(String zimbraReverseProxyRouteLookupTimeoutCache, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyRouteLookupTimeoutCache", zimbraReverseProxyRouteLookupTimeoutCache);
        return attrs;
    }

    @ZAttr(id=778L)
    public void unsetReverseProxyRouteLookupTimeoutCache() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyRouteLookupTimeoutCache", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=778L)
    public Map<String, Object> unsetReverseProxyRouteLookupTimeoutCache(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyRouteLookupTimeoutCache", "");
        return attrs;
    }

    @ZAttr(id=725L)
    public int getReverseProxyWorkerConnections() {
        return this.getIntAttr("zimbraReverseProxyWorkerConnections", 10240);
    }

    @ZAttr(id=725L)
    public void setReverseProxyWorkerConnections(int zimbraReverseProxyWorkerConnections) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyWorkerConnections", Integer.toString(zimbraReverseProxyWorkerConnections));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=725L)
    public Map<String, Object> setReverseProxyWorkerConnections(int zimbraReverseProxyWorkerConnections, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyWorkerConnections", Integer.toString(zimbraReverseProxyWorkerConnections));
        return attrs;
    }

    @ZAttr(id=725L)
    public void unsetReverseProxyWorkerConnections() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyWorkerConnections", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=725L)
    public Map<String, Object> unsetReverseProxyWorkerConnections(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyWorkerConnections", "");
        return attrs;
    }

    @ZAttr(id=724L)
    public int getReverseProxyWorkerProcesses() {
        return this.getIntAttr("zimbraReverseProxyWorkerProcesses", 4);
    }

    @ZAttr(id=724L)
    public void setReverseProxyWorkerProcesses(int zimbraReverseProxyWorkerProcesses) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyWorkerProcesses", Integer.toString(zimbraReverseProxyWorkerProcesses));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=724L)
    public Map<String, Object> setReverseProxyWorkerProcesses(int zimbraReverseProxyWorkerProcesses, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyWorkerProcesses", Integer.toString(zimbraReverseProxyWorkerProcesses));
        return attrs;
    }

    @ZAttr(id=724L)
    public void unsetReverseProxyWorkerProcesses() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyWorkerProcesses", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=724L)
    public Map<String, Object> unsetReverseProxyWorkerProcesses(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyWorkerProcesses", "");
        return attrs;
    }

    @ZAttr(id=563L)
    public String getSSLCertificate() {
        return this.getAttr("zimbraSSLCertificate", null);
    }

    @ZAttr(id=563L)
    public void setSSLCertificate(String zimbraSSLCertificate) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSSLCertificate", zimbraSSLCertificate);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=563L)
    public Map<String, Object> setSSLCertificate(String zimbraSSLCertificate, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSSLCertificate", zimbraSSLCertificate);
        return attrs;
    }

    @ZAttr(id=563L)
    public void unsetSSLCertificate() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSSLCertificate", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=563L)
    public Map<String, Object> unsetSSLCertificate(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSSLCertificate", "");
        return attrs;
    }

    @ZAttr(id=564L)
    public String getSSLPrivateKey() {
        return this.getAttr("zimbraSSLPrivateKey", null);
    }

    @ZAttr(id=564L)
    public void setSSLPrivateKey(String zimbraSSLPrivateKey) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSSLPrivateKey", zimbraSSLPrivateKey);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=564L)
    public Map<String, Object> setSSLPrivateKey(String zimbraSSLPrivateKey, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSSLPrivateKey", zimbraSSLPrivateKey);
        return attrs;
    }

    @ZAttr(id=564L)
    public void unsetSSLPrivateKey() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSSLPrivateKey", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=564L)
    public Map<String, Object> unsetSSLPrivateKey(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSSLPrivateKey", "");
        return attrs;
    }

    @ZAttr(id=1068L)
    public boolean isSaslGssapiRequiresTls() {
        return this.getBooleanAttr("zimbraSaslGssapiRequiresTls", false);
    }

    @ZAttr(id=1068L)
    public void setSaslGssapiRequiresTls(boolean zimbraSaslGssapiRequiresTls) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSaslGssapiRequiresTls", zimbraSaslGssapiRequiresTls ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1068L)
    public Map<String, Object> setSaslGssapiRequiresTls(boolean zimbraSaslGssapiRequiresTls, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSaslGssapiRequiresTls", zimbraSaslGssapiRequiresTls ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1068L)
    public void unsetSaslGssapiRequiresTls() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSaslGssapiRequiresTls", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1068L)
    public Map<String, Object> unsetSaslGssapiRequiresTls(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSaslGssapiRequiresTls", "");
        return attrs;
    }

    @ZAttr(id=522L)
    public int getScheduledTaskNumThreads() {
        return this.getIntAttr("zimbraScheduledTaskNumThreads", 20);
    }

    @ZAttr(id=522L)
    public void setScheduledTaskNumThreads(int zimbraScheduledTaskNumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraScheduledTaskNumThreads", Integer.toString(zimbraScheduledTaskNumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=522L)
    public Map<String, Object> setScheduledTaskNumThreads(int zimbraScheduledTaskNumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraScheduledTaskNumThreads", Integer.toString(zimbraScheduledTaskNumThreads));
        return attrs;
    }

    @ZAttr(id=522L)
    public void unsetScheduledTaskNumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraScheduledTaskNumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=522L)
    public Map<String, Object> unsetScheduledTaskNumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraScheduledTaskNumThreads", "");
        return attrs;
    }

    @ZAttr(id=220L)
    public String[] getServiceEnabled() {
        return this.getMultiAttr("zimbraServiceEnabled");
    }

    @ZAttr(id=220L)
    public void setServiceEnabled(String[] zimbraServiceEnabled) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraServiceEnabled", zimbraServiceEnabled);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=220L)
    public Map<String, Object> setServiceEnabled(String[] zimbraServiceEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraServiceEnabled", zimbraServiceEnabled);
        return attrs;
    }

    @ZAttr(id=220L)
    public void addServiceEnabled(String zimbraServiceEnabled) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraServiceEnabled", zimbraServiceEnabled);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=220L)
    public Map<String, Object> addServiceEnabled(String zimbraServiceEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraServiceEnabled", zimbraServiceEnabled);
        return attrs;
    }

    @ZAttr(id=220L)
    public void removeServiceEnabled(String zimbraServiceEnabled) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraServiceEnabled", zimbraServiceEnabled);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=220L)
    public Map<String, Object> removeServiceEnabled(String zimbraServiceEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraServiceEnabled", zimbraServiceEnabled);
        return attrs;
    }

    @ZAttr(id=220L)
    public void unsetServiceEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraServiceEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=220L)
    public Map<String, Object> unsetServiceEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraServiceEnabled", "");
        return attrs;
    }

    @ZAttr(id=65L)
    public String getServiceHostname() {
        return this.getAttr("zimbraServiceHostname", null);
    }

    @ZAttr(id=65L)
    public void setServiceHostname(String zimbraServiceHostname) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraServiceHostname", zimbraServiceHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=65L)
    public Map<String, Object> setServiceHostname(String zimbraServiceHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraServiceHostname", zimbraServiceHostname);
        return attrs;
    }

    @ZAttr(id=65L)
    public void unsetServiceHostname() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraServiceHostname", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=65L)
    public Map<String, Object> unsetServiceHostname(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraServiceHostname", "");
        return attrs;
    }

    @ZAttr(id=221L)
    public String[] getServiceInstalled() {
        return this.getMultiAttr("zimbraServiceInstalled");
    }

    @ZAttr(id=221L)
    public void setServiceInstalled(String[] zimbraServiceInstalled) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraServiceInstalled", zimbraServiceInstalled);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=221L)
    public Map<String, Object> setServiceInstalled(String[] zimbraServiceInstalled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraServiceInstalled", zimbraServiceInstalled);
        return attrs;
    }

    @ZAttr(id=221L)
    public void addServiceInstalled(String zimbraServiceInstalled) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraServiceInstalled", zimbraServiceInstalled);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=221L)
    public Map<String, Object> addServiceInstalled(String zimbraServiceInstalled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraServiceInstalled", zimbraServiceInstalled);
        return attrs;
    }

    @ZAttr(id=221L)
    public void removeServiceInstalled(String zimbraServiceInstalled) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraServiceInstalled", zimbraServiceInstalled);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=221L)
    public Map<String, Object> removeServiceInstalled(String zimbraServiceInstalled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraServiceInstalled", zimbraServiceInstalled);
        return attrs;
    }

    @ZAttr(id=221L)
    public void unsetServiceInstalled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraServiceInstalled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=221L)
    public Map<String, Object> unsetServiceInstalled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraServiceInstalled", "");
        return attrs;
    }

    @ZAttr(id=97L)
    public String[] getSmtpHostname() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraSmtpHostname");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "localhost";
        }
        return stringArray;
    }

    @ZAttr(id=97L)
    public void setSmtpHostname(String[] zimbraSmtpHostname) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraSmtpHostname", zimbraSmtpHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=97L)
    public Map<String, Object> setSmtpHostname(String[] zimbraSmtpHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpHostname", zimbraSmtpHostname);
        return attrs;
    }

    @ZAttr(id=97L)
    public void addSmtpHostname(String zimbraSmtpHostname) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraSmtpHostname", zimbraSmtpHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=97L)
    public Map<String, Object> addSmtpHostname(String zimbraSmtpHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraSmtpHostname", zimbraSmtpHostname);
        return attrs;
    }

    @ZAttr(id=97L)
    public void removeSmtpHostname(String zimbraSmtpHostname) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraSmtpHostname", zimbraSmtpHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=97L)
    public Map<String, Object> removeSmtpHostname(String zimbraSmtpHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraSmtpHostname", zimbraSmtpHostname);
        return attrs;
    }

    @ZAttr(id=97L)
    public void unsetSmtpHostname() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpHostname", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=97L)
    public Map<String, Object> unsetSmtpHostname(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpHostname", "");
        return attrs;
    }

    @ZAttr(id=98L)
    public int getSmtpPort() {
        return this.getIntAttr("zimbraSmtpPort", 25);
    }

    @ZAttr(id=98L)
    public String getSmtpPortAsString() {
        return this.getAttr("zimbraSmtpPort", "25");
    }

    @ZAttr(id=98L)
    public void setSmtpPort(int zimbraSmtpPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpPort", Integer.toString(zimbraSmtpPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=98L)
    public Map<String, Object> setSmtpPort(int zimbraSmtpPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpPort", Integer.toString(zimbraSmtpPort));
        return attrs;
    }

    @ZAttr(id=98L)
    public void setSmtpPortAsString(String zimbraSmtpPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpPort", zimbraSmtpPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=98L)
    public Map<String, Object> setSmtpPortAsString(String zimbraSmtpPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpPort", zimbraSmtpPort);
        return attrs;
    }

    @ZAttr(id=98L)
    public void unsetSmtpPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=98L)
    public Map<String, Object> unsetSmtpPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpPort", "");
        return attrs;
    }

    @ZAttr(id=249L)
    public boolean isSmtpSendPartial() {
        return this.getBooleanAttr("zimbraSmtpSendPartial", false);
    }

    @ZAttr(id=249L)
    public void setSmtpSendPartial(boolean zimbraSmtpSendPartial) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpSendPartial", zimbraSmtpSendPartial ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=249L)
    public Map<String, Object> setSmtpSendPartial(boolean zimbraSmtpSendPartial, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpSendPartial", zimbraSmtpSendPartial ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=249L)
    public void unsetSmtpSendPartial() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpSendPartial", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=249L)
    public Map<String, Object> unsetSmtpSendPartial(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpSendPartial", "");
        return attrs;
    }

    @ZAttr(id=99L)
    public int getSmtpTimeout() {
        return this.getIntAttr("zimbraSmtpTimeout", 60);
    }

    @ZAttr(id=99L)
    public void setSmtpTimeout(int zimbraSmtpTimeout) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpTimeout", Integer.toString(zimbraSmtpTimeout));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=99L)
    public Map<String, Object> setSmtpTimeout(int zimbraSmtpTimeout, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpTimeout", Integer.toString(zimbraSmtpTimeout));
        return attrs;
    }

    @ZAttr(id=99L)
    public void unsetSmtpTimeout() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpTimeout", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=99L)
    public Map<String, Object> unsetSmtpTimeout(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpTimeout", "");
        return attrs;
    }

    @ZAttr(id=708L)
    public boolean isSoapExposeVersion() {
        return this.getBooleanAttr("zimbraSoapExposeVersion", false);
    }

    @ZAttr(id=708L)
    public void setSoapExposeVersion(boolean zimbraSoapExposeVersion) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSoapExposeVersion", zimbraSoapExposeVersion ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=708L)
    public Map<String, Object> setSoapExposeVersion(boolean zimbraSoapExposeVersion, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSoapExposeVersion", zimbraSoapExposeVersion ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=708L)
    public void unsetSoapExposeVersion() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSoapExposeVersion", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=708L)
    public Map<String, Object> unsetSoapExposeVersion(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSoapExposeVersion", "");
        return attrs;
    }

    @ZAttr(id=557L)
    public int getSoapRequestMaxSize() {
        return this.getIntAttr("zimbraSoapRequestMaxSize", 15360000);
    }

    @ZAttr(id=557L)
    public void setSoapRequestMaxSize(int zimbraSoapRequestMaxSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSoapRequestMaxSize", Integer.toString(zimbraSoapRequestMaxSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=557L)
    public Map<String, Object> setSoapRequestMaxSize(int zimbraSoapRequestMaxSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSoapRequestMaxSize", Integer.toString(zimbraSoapRequestMaxSize));
        return attrs;
    }

    @ZAttr(id=557L)
    public void unsetSoapRequestMaxSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSoapRequestMaxSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=557L)
    public Map<String, Object> unsetSoapRequestMaxSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSoapRequestMaxSize", "");
        return attrs;
    }

    @ZAttr(id=1042L)
    public String[] getSpellAvailableDictionary() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraSpellAvailableDictionary");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "en_US";
        }
        return stringArray;
    }

    @ZAttr(id=1042L)
    public void setSpellAvailableDictionary(String[] zimbraSpellAvailableDictionary) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1042L)
    public Map<String, Object> setSpellAvailableDictionary(String[] zimbraSpellAvailableDictionary, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        return attrs;
    }

    @ZAttr(id=1042L)
    public void addSpellAvailableDictionary(String zimbraSpellAvailableDictionary) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1042L)
    public Map<String, Object> addSpellAvailableDictionary(String zimbraSpellAvailableDictionary, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        return attrs;
    }

    @ZAttr(id=1042L)
    public void removeSpellAvailableDictionary(String zimbraSpellAvailableDictionary) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1042L)
    public Map<String, Object> removeSpellAvailableDictionary(String zimbraSpellAvailableDictionary, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        return attrs;
    }

    @ZAttr(id=1042L)
    public void unsetSpellAvailableDictionary() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpellAvailableDictionary", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1042L)
    public Map<String, Object> unsetSpellAvailableDictionary(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpellAvailableDictionary", "");
        return attrs;
    }

    @ZAttr(id=267L)
    public String[] getSpellCheckURL() {
        return this.getMultiAttr("zimbraSpellCheckURL");
    }

    @ZAttr(id=267L)
    public void setSpellCheckURL(String[] zimbraSpellCheckURL) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraSpellCheckURL", zimbraSpellCheckURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=267L)
    public Map<String, Object> setSpellCheckURL(String[] zimbraSpellCheckURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpellCheckURL", zimbraSpellCheckURL);
        return attrs;
    }

    @ZAttr(id=267L)
    public void addSpellCheckURL(String zimbraSpellCheckURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraSpellCheckURL", zimbraSpellCheckURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=267L)
    public Map<String, Object> addSpellCheckURL(String zimbraSpellCheckURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraSpellCheckURL", zimbraSpellCheckURL);
        return attrs;
    }

    @ZAttr(id=267L)
    public void removeSpellCheckURL(String zimbraSpellCheckURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraSpellCheckURL", zimbraSpellCheckURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=267L)
    public Map<String, Object> removeSpellCheckURL(String zimbraSpellCheckURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraSpellCheckURL", zimbraSpellCheckURL);
        return attrs;
    }

    @ZAttr(id=267L)
    public void unsetSpellCheckURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpellCheckURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=267L)
    public Map<String, Object> unsetSpellCheckURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpellCheckURL", "");
        return attrs;
    }

    @ZAttr(id=262L)
    public String getSshPublicKey() {
        return this.getAttr("zimbraSshPublicKey", null);
    }

    @ZAttr(id=262L)
    public void setSshPublicKey(String zimbraSshPublicKey) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSshPublicKey", zimbraSshPublicKey);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=262L)
    public Map<String, Object> setSshPublicKey(String zimbraSshPublicKey, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSshPublicKey", zimbraSshPublicKey);
        return attrs;
    }

    @ZAttr(id=262L)
    public void unsetSshPublicKey() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSshPublicKey", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=262L)
    public Map<String, Object> unsetSshPublicKey(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSshPublicKey", "");
        return attrs;
    }

    @ZAttr(id=792L)
    public String[] getStatThreadNamePrefix() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraStatThreadNamePrefix");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[14];
            stringArray2[0] = "btpool";
            stringArray2[1] = "pool";
            stringArray2[2] = "LmtpServer";
            stringArray2[3] = "ImapServer";
            stringArray2[4] = "ImapSSLServer";
            stringArray2[5] = "Pop3Server";
            stringArray2[6] = "Pop3SSLServer";
            stringArray2[7] = "ScheduledTask";
            stringArray2[8] = "Timer";
            stringArray2[9] = "AnonymousIoService";
            stringArray2[10] = "CloudRoutingReaderThread";
            stringArray2[11] = "GC";
            stringArray2[12] = "SocketAcceptor";
            stringArray = stringArray2;
            stringArray2[13] = "Thread";
        }
        return stringArray;
    }

    @ZAttr(id=792L)
    public void setStatThreadNamePrefix(String[] zimbraStatThreadNamePrefix) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=792L)
    public Map<String, Object> setStatThreadNamePrefix(String[] zimbraStatThreadNamePrefix, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        return attrs;
    }

    @ZAttr(id=792L)
    public void addStatThreadNamePrefix(String zimbraStatThreadNamePrefix) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=792L)
    public Map<String, Object> addStatThreadNamePrefix(String zimbraStatThreadNamePrefix, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        return attrs;
    }

    @ZAttr(id=792L)
    public void removeStatThreadNamePrefix(String zimbraStatThreadNamePrefix) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=792L)
    public Map<String, Object> removeStatThreadNamePrefix(String zimbraStatThreadNamePrefix, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        return attrs;
    }

    @ZAttr(id=792L)
    public void unsetStatThreadNamePrefix() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraStatThreadNamePrefix", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=792L)
    public Map<String, Object> unsetStatThreadNamePrefix(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraStatThreadNamePrefix", "");
        return attrs;
    }

    @ZAttr(id=171L)
    public int getTableMaintenanceGrowthFactor() {
        return this.getIntAttr("zimbraTableMaintenanceGrowthFactor", 10);
    }

    @ZAttr(id=171L)
    public void setTableMaintenanceGrowthFactor(int zimbraTableMaintenanceGrowthFactor) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceGrowthFactor", Integer.toString(zimbraTableMaintenanceGrowthFactor));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=171L)
    public Map<String, Object> setTableMaintenanceGrowthFactor(int zimbraTableMaintenanceGrowthFactor, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceGrowthFactor", Integer.toString(zimbraTableMaintenanceGrowthFactor));
        return attrs;
    }

    @ZAttr(id=171L)
    public void unsetTableMaintenanceGrowthFactor() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceGrowthFactor", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=171L)
    public Map<String, Object> unsetTableMaintenanceGrowthFactor(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceGrowthFactor", "");
        return attrs;
    }

    @ZAttr(id=169L)
    public int getTableMaintenanceMaxRows() {
        return this.getIntAttr("zimbraTableMaintenanceMaxRows", 1000000);
    }

    @ZAttr(id=169L)
    public void setTableMaintenanceMaxRows(int zimbraTableMaintenanceMaxRows) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceMaxRows", Integer.toString(zimbraTableMaintenanceMaxRows));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=169L)
    public Map<String, Object> setTableMaintenanceMaxRows(int zimbraTableMaintenanceMaxRows, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceMaxRows", Integer.toString(zimbraTableMaintenanceMaxRows));
        return attrs;
    }

    @ZAttr(id=169L)
    public void unsetTableMaintenanceMaxRows() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceMaxRows", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=169L)
    public Map<String, Object> unsetTableMaintenanceMaxRows(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceMaxRows", "");
        return attrs;
    }

    @ZAttr(id=168L)
    public int getTableMaintenanceMinRows() {
        return this.getIntAttr("zimbraTableMaintenanceMinRows", 10000);
    }

    @ZAttr(id=168L)
    public void setTableMaintenanceMinRows(int zimbraTableMaintenanceMinRows) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceMinRows", Integer.toString(zimbraTableMaintenanceMinRows));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=168L)
    public Map<String, Object> setTableMaintenanceMinRows(int zimbraTableMaintenanceMinRows, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceMinRows", Integer.toString(zimbraTableMaintenanceMinRows));
        return attrs;
    }

    @ZAttr(id=168L)
    public void unsetTableMaintenanceMinRows() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceMinRows", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=168L)
    public Map<String, Object> unsetTableMaintenanceMinRows(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceMinRows", "");
        return attrs;
    }

    @ZAttr(id=170L)
    public ZAttrProvisioning.TableMaintenanceOperation getTableMaintenanceOperation() {
        try {
            String v = this.getAttr("zimbraTableMaintenanceOperation");
            return v == null ? ZAttrProvisioning.TableMaintenanceOperation.ANALYZE : ZAttrProvisioning.TableMaintenanceOperation.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.TableMaintenanceOperation.ANALYZE;
        }
    }

    @ZAttr(id=170L)
    public String getTableMaintenanceOperationAsString() {
        return this.getAttr("zimbraTableMaintenanceOperation", "ANALYZE");
    }

    @ZAttr(id=170L)
    public void setTableMaintenanceOperation(ZAttrProvisioning.TableMaintenanceOperation zimbraTableMaintenanceOperation) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceOperation", zimbraTableMaintenanceOperation.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=170L)
    public Map<String, Object> setTableMaintenanceOperation(ZAttrProvisioning.TableMaintenanceOperation zimbraTableMaintenanceOperation, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceOperation", zimbraTableMaintenanceOperation.toString());
        return attrs;
    }

    @ZAttr(id=170L)
    public void setTableMaintenanceOperationAsString(String zimbraTableMaintenanceOperation) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceOperation", zimbraTableMaintenanceOperation);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=170L)
    public Map<String, Object> setTableMaintenanceOperationAsString(String zimbraTableMaintenanceOperation, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceOperation", zimbraTableMaintenanceOperation);
        return attrs;
    }

    @ZAttr(id=170L)
    public void unsetTableMaintenanceOperation() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceOperation", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=170L)
    public Map<String, Object> unsetTableMaintenanceOperation(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceOperation", "");
        return attrs;
    }

    @ZAttr(id=146L)
    public boolean isUserServicesEnabled() {
        return this.getBooleanAttr("zimbraUserServicesEnabled", false);
    }

    @ZAttr(id=146L)
    public void setUserServicesEnabled(boolean zimbraUserServicesEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraUserServicesEnabled", zimbraUserServicesEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=146L)
    public Map<String, Object> setUserServicesEnabled(boolean zimbraUserServicesEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraUserServicesEnabled", zimbraUserServicesEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=146L)
    public void unsetUserServicesEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraUserServicesEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=146L)
    public Map<String, Object> unsetUserServicesEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraUserServicesEnabled", "");
        return attrs;
    }

    @ZAttr(id=191L)
    public long getVirusDefinitionsUpdateFrequency() {
        return this.getTimeInterval("zimbraVirusDefinitionsUpdateFrequency", 0x6DDD00L);
    }

    @ZAttr(id=191L)
    public String getVirusDefinitionsUpdateFrequencyAsString() {
        return this.getAttr("zimbraVirusDefinitionsUpdateFrequency", "2h");
    }

    @ZAttr(id=191L)
    public void setVirusDefinitionsUpdateFrequency(String zimbraVirusDefinitionsUpdateFrequency) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusDefinitionsUpdateFrequency", zimbraVirusDefinitionsUpdateFrequency);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=191L)
    public Map<String, Object> setVirusDefinitionsUpdateFrequency(String zimbraVirusDefinitionsUpdateFrequency, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusDefinitionsUpdateFrequency", zimbraVirusDefinitionsUpdateFrequency);
        return attrs;
    }

    @ZAttr(id=191L)
    public void unsetVirusDefinitionsUpdateFrequency() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusDefinitionsUpdateFrequency", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=191L)
    public Map<String, Object> unsetVirusDefinitionsUpdateFrequency(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusDefinitionsUpdateFrequency", "");
        return attrs;
    }

    @ZAttr(id=397L)
    public boolean isXMPPEnabled() {
        return this.getBooleanAttr("zimbraXMPPEnabled", true);
    }

    @ZAttr(id=397L)
    public void setXMPPEnabled(boolean zimbraXMPPEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraXMPPEnabled", zimbraXMPPEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=397L)
    public Map<String, Object> setXMPPEnabled(boolean zimbraXMPPEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraXMPPEnabled", zimbraXMPPEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=397L)
    public void unsetXMPPEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraXMPPEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=397L)
    public Map<String, Object> unsetXMPPEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraXMPPEnabled", "");
        return attrs;
    }
}

