/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZAttr;
import com.zimbra.cs.account.ZAttrProvisioning;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZAttrConfig
extends Entry {
    public ZAttrConfig(Map<String, Object> attrs, Provisioning provisioning) {
        super(attrs, null, provisioning);
    }

    @ZAttr(id=-1L)
    public String[] getDescription() {
        return this.getMultiAttr("description");
    }

    @ZAttr(id=-1L)
    public void setDescription(String[] description) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("description", description);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=-1L)
    public Map<String, Object> setDescription(String[] description, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("description", description);
        return attrs;
    }

    @ZAttr(id=-1L)
    public void addDescription(String description) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+description", description);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=-1L)
    public Map<String, Object> addDescription(String description, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+description", description);
        return attrs;
    }

    @ZAttr(id=-1L)
    public void removeDescription(String description) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-description", description);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=-1L)
    public Map<String, Object> removeDescription(String description, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-description", description);
        return attrs;
    }

    @ZAttr(id=-1L)
    public void unsetDescription() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("description", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=-1L)
    public Map<String, Object> unsetDescription(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("description", "");
        return attrs;
    }

    @ZAttr(id=659L)
    public String[] getACE() {
        return this.getMultiAttr("zimbraACE");
    }

    @ZAttr(id=659L)
    public void setACE(String[] zimbraACE) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraACE", zimbraACE);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=659L)
    public Map<String, Object> setACE(String[] zimbraACE, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraACE", zimbraACE);
        return attrs;
    }

    @ZAttr(id=659L)
    public void addACE(String zimbraACE) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraACE", zimbraACE);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=659L)
    public Map<String, Object> addACE(String zimbraACE, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraACE", zimbraACE);
        return attrs;
    }

    @ZAttr(id=659L)
    public void removeACE(String zimbraACE) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraACE", zimbraACE);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=659L)
    public Map<String, Object> removeACE(String zimbraACE, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraACE", zimbraACE);
        return attrs;
    }

    @ZAttr(id=659L)
    public void unsetACE() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraACE", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=659L)
    public Map<String, Object> unsetACE(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraACE", "");
        return attrs;
    }

    @ZAttr(id=112L)
    public String[] getAccountClientAttr() {
        return this.getMultiAttr("zimbraAccountClientAttr");
    }

    @ZAttr(id=112L)
    public void setAccountClientAttr(String[] zimbraAccountClientAttr) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraAccountClientAttr", zimbraAccountClientAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=112L)
    public Map<String, Object> setAccountClientAttr(String[] zimbraAccountClientAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAccountClientAttr", zimbraAccountClientAttr);
        return attrs;
    }

    @ZAttr(id=112L)
    public void addAccountClientAttr(String zimbraAccountClientAttr) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraAccountClientAttr", zimbraAccountClientAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=112L)
    public Map<String, Object> addAccountClientAttr(String zimbraAccountClientAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraAccountClientAttr", zimbraAccountClientAttr);
        return attrs;
    }

    @ZAttr(id=112L)
    public void removeAccountClientAttr(String zimbraAccountClientAttr) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraAccountClientAttr", zimbraAccountClientAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=112L)
    public Map<String, Object> removeAccountClientAttr(String zimbraAccountClientAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraAccountClientAttr", zimbraAccountClientAttr);
        return attrs;
    }

    @ZAttr(id=112L)
    public void unsetAccountClientAttr() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAccountClientAttr", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=112L)
    public Map<String, Object> unsetAccountClientAttr(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAccountClientAttr", "");
        return attrs;
    }

    @ZAttr(id=438L)
    public String[] getAccountExtraObjectClass() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraAccountExtraObjectClass");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "amavisAccount";
        }
        return stringArray;
    }

    @ZAttr(id=438L)
    public void setAccountExtraObjectClass(String[] zimbraAccountExtraObjectClass) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraAccountExtraObjectClass", zimbraAccountExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=438L)
    public Map<String, Object> setAccountExtraObjectClass(String[] zimbraAccountExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAccountExtraObjectClass", zimbraAccountExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=438L)
    public void addAccountExtraObjectClass(String zimbraAccountExtraObjectClass) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraAccountExtraObjectClass", zimbraAccountExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=438L)
    public Map<String, Object> addAccountExtraObjectClass(String zimbraAccountExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraAccountExtraObjectClass", zimbraAccountExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=438L)
    public void removeAccountExtraObjectClass(String zimbraAccountExtraObjectClass) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraAccountExtraObjectClass", zimbraAccountExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=438L)
    public Map<String, Object> removeAccountExtraObjectClass(String zimbraAccountExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraAccountExtraObjectClass", zimbraAccountExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=438L)
    public void unsetAccountExtraObjectClass() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAccountExtraObjectClass", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=438L)
    public Map<String, Object> unsetAccountExtraObjectClass(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAccountExtraObjectClass", "");
        return attrs;
    }

    @ZAttr(id=746L)
    public boolean isAdminConsoleCatchAllAddressEnabled() {
        return this.getBooleanAttr("zimbraAdminConsoleCatchAllAddressEnabled", false);
    }

    @ZAttr(id=746L)
    public void setAdminConsoleCatchAllAddressEnabled(boolean zimbraAdminConsoleCatchAllAddressEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleCatchAllAddressEnabled", zimbraAdminConsoleCatchAllAddressEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=746L)
    public Map<String, Object> setAdminConsoleCatchAllAddressEnabled(boolean zimbraAdminConsoleCatchAllAddressEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleCatchAllAddressEnabled", zimbraAdminConsoleCatchAllAddressEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=746L)
    public void unsetAdminConsoleCatchAllAddressEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleCatchAllAddressEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=746L)
    public Map<String, Object> unsetAdminConsoleCatchAllAddressEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleCatchAllAddressEnabled", "");
        return attrs;
    }

    @ZAttr(id=743L)
    public boolean isAdminConsoleDNSCheckEnabled() {
        return this.getBooleanAttr("zimbraAdminConsoleDNSCheckEnabled", false);
    }

    @ZAttr(id=743L)
    public void setAdminConsoleDNSCheckEnabled(boolean zimbraAdminConsoleDNSCheckEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleDNSCheckEnabled", zimbraAdminConsoleDNSCheckEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=743L)
    public Map<String, Object> setAdminConsoleDNSCheckEnabled(boolean zimbraAdminConsoleDNSCheckEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleDNSCheckEnabled", zimbraAdminConsoleDNSCheckEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=743L)
    public void unsetAdminConsoleDNSCheckEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleDNSCheckEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=743L)
    public Map<String, Object> unsetAdminConsoleDNSCheckEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleDNSCheckEnabled", "");
        return attrs;
    }

    @ZAttr(id=774L)
    public boolean isAdminConsoleLDAPAuthEnabled() {
        return this.getBooleanAttr("zimbraAdminConsoleLDAPAuthEnabled", false);
    }

    @ZAttr(id=774L)
    public void setAdminConsoleLDAPAuthEnabled(boolean zimbraAdminConsoleLDAPAuthEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleLDAPAuthEnabled", zimbraAdminConsoleLDAPAuthEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=774L)
    public Map<String, Object> setAdminConsoleLDAPAuthEnabled(boolean zimbraAdminConsoleLDAPAuthEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleLDAPAuthEnabled", zimbraAdminConsoleLDAPAuthEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=774L)
    public void unsetAdminConsoleLDAPAuthEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleLDAPAuthEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=774L)
    public Map<String, Object> unsetAdminConsoleLDAPAuthEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleLDAPAuthEnabled", "");
        return attrs;
    }

    @ZAttr(id=772L)
    public String[] getAdminConsoleLoginMessage() {
        return this.getMultiAttr("zimbraAdminConsoleLoginMessage");
    }

    @ZAttr(id=772L)
    public void setAdminConsoleLoginMessage(String[] zimbraAdminConsoleLoginMessage) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraAdminConsoleLoginMessage", zimbraAdminConsoleLoginMessage);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=772L)
    public Map<String, Object> setAdminConsoleLoginMessage(String[] zimbraAdminConsoleLoginMessage, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleLoginMessage", zimbraAdminConsoleLoginMessage);
        return attrs;
    }

    @ZAttr(id=772L)
    public void addAdminConsoleLoginMessage(String zimbraAdminConsoleLoginMessage) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraAdminConsoleLoginMessage", zimbraAdminConsoleLoginMessage);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=772L)
    public Map<String, Object> addAdminConsoleLoginMessage(String zimbraAdminConsoleLoginMessage, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraAdminConsoleLoginMessage", zimbraAdminConsoleLoginMessage);
        return attrs;
    }

    @ZAttr(id=772L)
    public void removeAdminConsoleLoginMessage(String zimbraAdminConsoleLoginMessage) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraAdminConsoleLoginMessage", zimbraAdminConsoleLoginMessage);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=772L)
    public Map<String, Object> removeAdminConsoleLoginMessage(String zimbraAdminConsoleLoginMessage, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraAdminConsoleLoginMessage", zimbraAdminConsoleLoginMessage);
        return attrs;
    }

    @ZAttr(id=772L)
    public void unsetAdminConsoleLoginMessage() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleLoginMessage", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=772L)
    public Map<String, Object> unsetAdminConsoleLoginMessage(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleLoginMessage", "");
        return attrs;
    }

    @ZAttr(id=696L)
    public String getAdminConsoleLoginURL() {
        return this.getAttr("zimbraAdminConsoleLoginURL", null);
    }

    @ZAttr(id=696L)
    public void setAdminConsoleLoginURL(String zimbraAdminConsoleLoginURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleLoginURL", zimbraAdminConsoleLoginURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=696L)
    public Map<String, Object> setAdminConsoleLoginURL(String zimbraAdminConsoleLoginURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleLoginURL", zimbraAdminConsoleLoginURL);
        return attrs;
    }

    @ZAttr(id=696L)
    public void unsetAdminConsoleLoginURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleLoginURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=696L)
    public Map<String, Object> unsetAdminConsoleLoginURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleLoginURL", "");
        return attrs;
    }

    @ZAttr(id=684L)
    public String getAdminConsoleLogoutURL() {
        return this.getAttr("zimbraAdminConsoleLogoutURL", null);
    }

    @ZAttr(id=684L)
    public void setAdminConsoleLogoutURL(String zimbraAdminConsoleLogoutURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleLogoutURL", zimbraAdminConsoleLogoutURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=684L)
    public Map<String, Object> setAdminConsoleLogoutURL(String zimbraAdminConsoleLogoutURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleLogoutURL", zimbraAdminConsoleLogoutURL);
        return attrs;
    }

    @ZAttr(id=684L)
    public void unsetAdminConsoleLogoutURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleLogoutURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=684L)
    public Map<String, Object> unsetAdminConsoleLogoutURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleLogoutURL", "");
        return attrs;
    }

    @ZAttr(id=751L)
    public boolean isAdminConsoleSkinEnabled() {
        return this.getBooleanAttr("zimbraAdminConsoleSkinEnabled", false);
    }

    @ZAttr(id=751L)
    public void setAdminConsoleSkinEnabled(boolean zimbraAdminConsoleSkinEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleSkinEnabled", zimbraAdminConsoleSkinEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=751L)
    public Map<String, Object> setAdminConsoleSkinEnabled(boolean zimbraAdminConsoleSkinEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleSkinEnabled", zimbraAdminConsoleSkinEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=751L)
    public void unsetAdminConsoleSkinEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminConsoleSkinEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=751L)
    public Map<String, Object> unsetAdminConsoleSkinEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminConsoleSkinEnabled", "");
        return attrs;
    }

    @ZAttr(id=155L)
    public int getAdminPort() {
        return this.getIntAttr("zimbraAdminPort", 7071);
    }

    @ZAttr(id=155L)
    public String getAdminPortAsString() {
        return this.getAttr("zimbraAdminPort", "7071");
    }

    @ZAttr(id=155L)
    public void setAdminPort(int zimbraAdminPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminPort", Integer.toString(zimbraAdminPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=155L)
    public Map<String, Object> setAdminPort(int zimbraAdminPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminPort", Integer.toString(zimbraAdminPort));
        return attrs;
    }

    @ZAttr(id=155L)
    public void setAdminPortAsString(String zimbraAdminPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminPort", zimbraAdminPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=155L)
    public Map<String, Object> setAdminPortAsString(String zimbraAdminPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminPort", zimbraAdminPort);
        return attrs;
    }

    @ZAttr(id=155L)
    public void unsetAdminPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=155L)
    public Map<String, Object> unsetAdminPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminPort", "");
        return attrs;
    }

    @ZAttr(id=497L)
    public String getAdminURL() {
        return this.getAttr("zimbraAdminURL", "/zimbraAdmin");
    }

    @ZAttr(id=497L)
    public void setAdminURL(String zimbraAdminURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminURL", zimbraAdminURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=497L)
    public Map<String, Object> setAdminURL(String zimbraAdminURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminURL", zimbraAdminURL);
        return attrs;
    }

    @ZAttr(id=497L)
    public void unsetAdminURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAdminURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=497L)
    public Map<String, Object> unsetAdminURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAdminURL", "");
        return attrs;
    }

    @ZAttr(id=1052L)
    public boolean isAllowNonLDHCharsInDomain() {
        return this.getBooleanAttr("zimbraAllowNonLDHCharsInDomain", true);
    }

    @ZAttr(id=1052L)
    public void setAllowNonLDHCharsInDomain(boolean zimbraAllowNonLDHCharsInDomain) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAllowNonLDHCharsInDomain", zimbraAllowNonLDHCharsInDomain ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1052L)
    public Map<String, Object> setAllowNonLDHCharsInDomain(boolean zimbraAllowNonLDHCharsInDomain, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAllowNonLDHCharsInDomain", zimbraAllowNonLDHCharsInDomain ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1052L)
    public void unsetAllowNonLDHCharsInDomain() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAllowNonLDHCharsInDomain", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1052L)
    public Map<String, Object> unsetAllowNonLDHCharsInDomain(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAllowNonLDHCharsInDomain", "");
        return attrs;
    }

    @ZAttr(id=430L)
    public String getArchiveMailFrom() {
        return this.getAttr("zimbraArchiveMailFrom", null);
    }

    @ZAttr(id=430L)
    public void setArchiveMailFrom(String zimbraArchiveMailFrom) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraArchiveMailFrom", zimbraArchiveMailFrom);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=430L)
    public Map<String, Object> setArchiveMailFrom(String zimbraArchiveMailFrom, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraArchiveMailFrom", zimbraArchiveMailFrom);
        return attrs;
    }

    @ZAttr(id=430L)
    public void unsetArchiveMailFrom() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraArchiveMailFrom", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=430L)
    public Map<String, Object> unsetArchiveMailFrom(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraArchiveMailFrom", "");
        return attrs;
    }

    @ZAttr(id=115L)
    public boolean isAttachmentsBlocked() {
        return this.getBooleanAttr("zimbraAttachmentsBlocked", false);
    }

    @ZAttr(id=115L)
    public void setAttachmentsBlocked(boolean zimbraAttachmentsBlocked) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsBlocked", zimbraAttachmentsBlocked ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=115L)
    public Map<String, Object> setAttachmentsBlocked(boolean zimbraAttachmentsBlocked, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsBlocked", zimbraAttachmentsBlocked ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=115L)
    public void unsetAttachmentsBlocked() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsBlocked", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=115L)
    public Map<String, Object> unsetAttachmentsBlocked(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsBlocked", "");
        return attrs;
    }

    @ZAttr(id=582L)
    public int getAttachmentsIndexedTextLimit() {
        return this.getIntAttr("zimbraAttachmentsIndexedTextLimit", 0x100000);
    }

    @ZAttr(id=582L)
    public void setAttachmentsIndexedTextLimit(int zimbraAttachmentsIndexedTextLimit) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsIndexedTextLimit", Integer.toString(zimbraAttachmentsIndexedTextLimit));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=582L)
    public Map<String, Object> setAttachmentsIndexedTextLimit(int zimbraAttachmentsIndexedTextLimit, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsIndexedTextLimit", Integer.toString(zimbraAttachmentsIndexedTextLimit));
        return attrs;
    }

    @ZAttr(id=582L)
    public void unsetAttachmentsIndexedTextLimit() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsIndexedTextLimit", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=582L)
    public Map<String, Object> unsetAttachmentsIndexedTextLimit(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsIndexedTextLimit", "");
        return attrs;
    }

    @ZAttr(id=238L)
    public String getAttachmentsScanClass() {
        return this.getAttr("zimbraAttachmentsScanClass", "com.zimbra.cs.scan.ClamScanner");
    }

    @ZAttr(id=238L)
    public void setAttachmentsScanClass(String zimbraAttachmentsScanClass) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsScanClass", zimbraAttachmentsScanClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=238L)
    public Map<String, Object> setAttachmentsScanClass(String zimbraAttachmentsScanClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsScanClass", zimbraAttachmentsScanClass);
        return attrs;
    }

    @ZAttr(id=238L)
    public void unsetAttachmentsScanClass() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsScanClass", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=238L)
    public Map<String, Object> unsetAttachmentsScanClass(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsScanClass", "");
        return attrs;
    }

    @ZAttr(id=237L)
    public boolean isAttachmentsScanEnabled() {
        return this.getBooleanAttr("zimbraAttachmentsScanEnabled", false);
    }

    @ZAttr(id=237L)
    public void setAttachmentsScanEnabled(boolean zimbraAttachmentsScanEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsScanEnabled", zimbraAttachmentsScanEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=237L)
    public Map<String, Object> setAttachmentsScanEnabled(boolean zimbraAttachmentsScanEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsScanEnabled", zimbraAttachmentsScanEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=237L)
    public void unsetAttachmentsScanEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsScanEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=237L)
    public Map<String, Object> unsetAttachmentsScanEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsScanEnabled", "");
        return attrs;
    }

    @ZAttr(id=239L)
    public String getAttachmentsScanURL() {
        return this.getAttr("zimbraAttachmentsScanURL", null);
    }

    @ZAttr(id=239L)
    public void setAttachmentsScanURL(String zimbraAttachmentsScanURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsScanURL", zimbraAttachmentsScanURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=239L)
    public Map<String, Object> setAttachmentsScanURL(String zimbraAttachmentsScanURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsScanURL", zimbraAttachmentsScanURL);
        return attrs;
    }

    @ZAttr(id=239L)
    public void unsetAttachmentsScanURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsScanURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=239L)
    public Map<String, Object> unsetAttachmentsScanURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsScanURL", "");
        return attrs;
    }

    @ZAttr(id=116L)
    public boolean isAttachmentsViewInHtmlOnly() {
        return this.getBooleanAttr("zimbraAttachmentsViewInHtmlOnly", false);
    }

    @ZAttr(id=116L)
    public void setAttachmentsViewInHtmlOnly(boolean zimbraAttachmentsViewInHtmlOnly) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsViewInHtmlOnly", zimbraAttachmentsViewInHtmlOnly ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=116L)
    public Map<String, Object> setAttachmentsViewInHtmlOnly(boolean zimbraAttachmentsViewInHtmlOnly, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsViewInHtmlOnly", zimbraAttachmentsViewInHtmlOnly ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=116L)
    public void unsetAttachmentsViewInHtmlOnly() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAttachmentsViewInHtmlOnly", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=116L)
    public Map<String, Object> unsetAttachmentsViewInHtmlOnly(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAttachmentsViewInHtmlOnly", "");
        return attrs;
    }

    @ZAttr(id=100L)
    public String[] getAuthTokenKey() {
        return this.getMultiAttr("zimbraAuthTokenKey");
    }

    @ZAttr(id=100L)
    public void setAuthTokenKey(String[] zimbraAuthTokenKey) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraAuthTokenKey", zimbraAuthTokenKey);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=100L)
    public Map<String, Object> setAuthTokenKey(String[] zimbraAuthTokenKey, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAuthTokenKey", zimbraAuthTokenKey);
        return attrs;
    }

    @ZAttr(id=100L)
    public void addAuthTokenKey(String zimbraAuthTokenKey) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraAuthTokenKey", zimbraAuthTokenKey);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=100L)
    public Map<String, Object> addAuthTokenKey(String zimbraAuthTokenKey, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraAuthTokenKey", zimbraAuthTokenKey);
        return attrs;
    }

    @ZAttr(id=100L)
    public void removeAuthTokenKey(String zimbraAuthTokenKey) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraAuthTokenKey", zimbraAuthTokenKey);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=100L)
    public Map<String, Object> removeAuthTokenKey(String zimbraAuthTokenKey, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraAuthTokenKey", zimbraAuthTokenKey);
        return attrs;
    }

    @ZAttr(id=100L)
    public void unsetAuthTokenKey() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAuthTokenKey", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=100L)
    public Map<String, Object> unsetAuthTokenKey(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAuthTokenKey", "");
        return attrs;
    }

    @ZAttr(id=502L)
    public boolean isAutoSubmittedNullReturnPath() {
        return this.getBooleanAttr("zimbraAutoSubmittedNullReturnPath", true);
    }

    @ZAttr(id=502L)
    public void setAutoSubmittedNullReturnPath(boolean zimbraAutoSubmittedNullReturnPath) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAutoSubmittedNullReturnPath", zimbraAutoSubmittedNullReturnPath ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=502L)
    public Map<String, Object> setAutoSubmittedNullReturnPath(boolean zimbraAutoSubmittedNullReturnPath, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAutoSubmittedNullReturnPath", zimbraAutoSubmittedNullReturnPath ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=502L)
    public void unsetAutoSubmittedNullReturnPath() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAutoSubmittedNullReturnPath", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=502L)
    public Map<String, Object> unsetAutoSubmittedNullReturnPath(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAutoSubmittedNullReturnPath", "");
        return attrs;
    }

    @ZAttr(id=513L)
    public String getBackupAutoGroupedInterval() {
        return this.getAttr("zimbraBackupAutoGroupedInterval", "1d");
    }

    @ZAttr(id=513L)
    public void setBackupAutoGroupedInterval(String zimbraBackupAutoGroupedInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedInterval", zimbraBackupAutoGroupedInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=513L)
    public Map<String, Object> setBackupAutoGroupedInterval(String zimbraBackupAutoGroupedInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedInterval", zimbraBackupAutoGroupedInterval);
        return attrs;
    }

    @ZAttr(id=513L)
    public void unsetBackupAutoGroupedInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=513L)
    public Map<String, Object> unsetBackupAutoGroupedInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedInterval", "");
        return attrs;
    }

    @ZAttr(id=514L)
    public int getBackupAutoGroupedNumGroups() {
        return this.getIntAttr("zimbraBackupAutoGroupedNumGroups", 7);
    }

    @ZAttr(id=514L)
    public void setBackupAutoGroupedNumGroups(int zimbraBackupAutoGroupedNumGroups) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedNumGroups", Integer.toString(zimbraBackupAutoGroupedNumGroups));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=514L)
    public Map<String, Object> setBackupAutoGroupedNumGroups(int zimbraBackupAutoGroupedNumGroups, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedNumGroups", Integer.toString(zimbraBackupAutoGroupedNumGroups));
        return attrs;
    }

    @ZAttr(id=514L)
    public void unsetBackupAutoGroupedNumGroups() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedNumGroups", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=514L)
    public Map<String, Object> unsetBackupAutoGroupedNumGroups(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedNumGroups", "");
        return attrs;
    }

    @ZAttr(id=515L)
    public boolean isBackupAutoGroupedThrottled() {
        return this.getBooleanAttr("zimbraBackupAutoGroupedThrottled", false);
    }

    @ZAttr(id=515L)
    public void setBackupAutoGroupedThrottled(boolean zimbraBackupAutoGroupedThrottled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedThrottled", zimbraBackupAutoGroupedThrottled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=515L)
    public Map<String, Object> setBackupAutoGroupedThrottled(boolean zimbraBackupAutoGroupedThrottled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedThrottled", zimbraBackupAutoGroupedThrottled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=515L)
    public void unsetBackupAutoGroupedThrottled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupAutoGroupedThrottled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=515L)
    public Map<String, Object> unsetBackupAutoGroupedThrottled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupAutoGroupedThrottled", "");
        return attrs;
    }

    @ZAttr(id=512L)
    public ZAttrProvisioning.BackupMode getBackupMode() {
        try {
            String v = this.getAttr("zimbraBackupMode");
            return v == null ? ZAttrProvisioning.BackupMode.Standard : ZAttrProvisioning.BackupMode.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.BackupMode.Standard;
        }
    }

    @ZAttr(id=512L)
    public String getBackupModeAsString() {
        return this.getAttr("zimbraBackupMode", "Standard");
    }

    @ZAttr(id=512L)
    public void setBackupMode(ZAttrProvisioning.BackupMode zimbraBackupMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupMode", zimbraBackupMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=512L)
    public Map<String, Object> setBackupMode(ZAttrProvisioning.BackupMode zimbraBackupMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupMode", zimbraBackupMode.toString());
        return attrs;
    }

    @ZAttr(id=512L)
    public void setBackupModeAsString(String zimbraBackupMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupMode", zimbraBackupMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=512L)
    public Map<String, Object> setBackupModeAsString(String zimbraBackupMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupMode", zimbraBackupMode);
        return attrs;
    }

    @ZAttr(id=512L)
    public void unsetBackupMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=512L)
    public Map<String, Object> unsetBackupMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupMode", "");
        return attrs;
    }

    @ZAttr(id=459L)
    public String[] getBackupReportEmailRecipients() {
        return this.getMultiAttr("zimbraBackupReportEmailRecipients");
    }

    @ZAttr(id=459L)
    public void setBackupReportEmailRecipients(String[] zimbraBackupReportEmailRecipients) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=459L)
    public Map<String, Object> setBackupReportEmailRecipients(String[] zimbraBackupReportEmailRecipients, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        return attrs;
    }

    @ZAttr(id=459L)
    public void addBackupReportEmailRecipients(String zimbraBackupReportEmailRecipients) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=459L)
    public Map<String, Object> addBackupReportEmailRecipients(String zimbraBackupReportEmailRecipients, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        return attrs;
    }

    @ZAttr(id=459L)
    public void removeBackupReportEmailRecipients(String zimbraBackupReportEmailRecipients) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=459L)
    public Map<String, Object> removeBackupReportEmailRecipients(String zimbraBackupReportEmailRecipients, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraBackupReportEmailRecipients", zimbraBackupReportEmailRecipients);
        return attrs;
    }

    @ZAttr(id=459L)
    public void unsetBackupReportEmailRecipients() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupReportEmailRecipients", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=459L)
    public Map<String, Object> unsetBackupReportEmailRecipients(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailRecipients", "");
        return attrs;
    }

    @ZAttr(id=460L)
    public String getBackupReportEmailSender() {
        return this.getAttr("zimbraBackupReportEmailSender", null);
    }

    @ZAttr(id=460L)
    public void setBackupReportEmailSender(String zimbraBackupReportEmailSender) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupReportEmailSender", zimbraBackupReportEmailSender);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=460L)
    public Map<String, Object> setBackupReportEmailSender(String zimbraBackupReportEmailSender, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailSender", zimbraBackupReportEmailSender);
        return attrs;
    }

    @ZAttr(id=460L)
    public void unsetBackupReportEmailSender() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupReportEmailSender", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=460L)
    public Map<String, Object> unsetBackupReportEmailSender(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailSender", "");
        return attrs;
    }

    @ZAttr(id=461L)
    public String getBackupReportEmailSubjectPrefix() {
        return this.getAttr("zimbraBackupReportEmailSubjectPrefix", "ZCS Backup Report");
    }

    @ZAttr(id=461L)
    public void setBackupReportEmailSubjectPrefix(String zimbraBackupReportEmailSubjectPrefix) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupReportEmailSubjectPrefix", zimbraBackupReportEmailSubjectPrefix);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=461L)
    public Map<String, Object> setBackupReportEmailSubjectPrefix(String zimbraBackupReportEmailSubjectPrefix, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailSubjectPrefix", zimbraBackupReportEmailSubjectPrefix);
        return attrs;
    }

    @ZAttr(id=461L)
    public void unsetBackupReportEmailSubjectPrefix() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupReportEmailSubjectPrefix", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=461L)
    public Map<String, Object> unsetBackupReportEmailSubjectPrefix(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupReportEmailSubjectPrefix", "");
        return attrs;
    }

    @ZAttr(id=1004L)
    public boolean isBackupSkipBlobs() {
        return this.getBooleanAttr("zimbraBackupSkipBlobs", false);
    }

    @ZAttr(id=1004L)
    public void setBackupSkipBlobs(boolean zimbraBackupSkipBlobs) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipBlobs", zimbraBackupSkipBlobs ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1004L)
    public Map<String, Object> setBackupSkipBlobs(boolean zimbraBackupSkipBlobs, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipBlobs", zimbraBackupSkipBlobs ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1004L)
    public void unsetBackupSkipBlobs() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipBlobs", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1004L)
    public Map<String, Object> unsetBackupSkipBlobs(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipBlobs", "");
        return attrs;
    }

    @ZAttr(id=1005L)
    public boolean isBackupSkipHsmBlobs() {
        return this.getBooleanAttr("zimbraBackupSkipHsmBlobs", false);
    }

    @ZAttr(id=1005L)
    public void setBackupSkipHsmBlobs(boolean zimbraBackupSkipHsmBlobs) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipHsmBlobs", zimbraBackupSkipHsmBlobs ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1005L)
    public Map<String, Object> setBackupSkipHsmBlobs(boolean zimbraBackupSkipHsmBlobs, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipHsmBlobs", zimbraBackupSkipHsmBlobs ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1005L)
    public void unsetBackupSkipHsmBlobs() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipHsmBlobs", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1005L)
    public Map<String, Object> unsetBackupSkipHsmBlobs(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipHsmBlobs", "");
        return attrs;
    }

    @ZAttr(id=1003L)
    public boolean isBackupSkipSearchIndex() {
        return this.getBooleanAttr("zimbraBackupSkipSearchIndex", false);
    }

    @ZAttr(id=1003L)
    public void setBackupSkipSearchIndex(boolean zimbraBackupSkipSearchIndex) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipSearchIndex", zimbraBackupSkipSearchIndex ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1003L)
    public Map<String, Object> setBackupSkipSearchIndex(boolean zimbraBackupSkipSearchIndex, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipSearchIndex", zimbraBackupSkipSearchIndex ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1003L)
    public void unsetBackupSkipSearchIndex() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupSkipSearchIndex", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1003L)
    public Map<String, Object> unsetBackupSkipSearchIndex(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupSkipSearchIndex", "");
        return attrs;
    }

    @ZAttr(id=458L)
    public String getBackupTarget() {
        return this.getAttr("zimbraBackupTarget", "/opt/zimbra/backup");
    }

    @ZAttr(id=458L)
    public void setBackupTarget(String zimbraBackupTarget) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupTarget", zimbraBackupTarget);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=458L)
    public Map<String, Object> setBackupTarget(String zimbraBackupTarget, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupTarget", zimbraBackupTarget);
        return attrs;
    }

    @ZAttr(id=458L)
    public void unsetBackupTarget() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraBackupTarget", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=458L)
    public Map<String, Object> unsetBackupTarget(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraBackupTarget", "");
        return attrs;
    }

    @ZAttr(id=21L)
    public String[] getCOSInheritedAttr() {
        return this.getMultiAttr("zimbraCOSInheritedAttr");
    }

    @ZAttr(id=21L)
    public void setCOSInheritedAttr(String[] zimbraCOSInheritedAttr) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraCOSInheritedAttr", zimbraCOSInheritedAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=21L)
    public Map<String, Object> setCOSInheritedAttr(String[] zimbraCOSInheritedAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCOSInheritedAttr", zimbraCOSInheritedAttr);
        return attrs;
    }

    @ZAttr(id=21L)
    public void addCOSInheritedAttr(String zimbraCOSInheritedAttr) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraCOSInheritedAttr", zimbraCOSInheritedAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=21L)
    public Map<String, Object> addCOSInheritedAttr(String zimbraCOSInheritedAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraCOSInheritedAttr", zimbraCOSInheritedAttr);
        return attrs;
    }

    @ZAttr(id=21L)
    public void removeCOSInheritedAttr(String zimbraCOSInheritedAttr) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraCOSInheritedAttr", zimbraCOSInheritedAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=21L)
    public Map<String, Object> removeCOSInheritedAttr(String zimbraCOSInheritedAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraCOSInheritedAttr", zimbraCOSInheritedAttr);
        return attrs;
    }

    @ZAttr(id=21L)
    public void unsetCOSInheritedAttr() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCOSInheritedAttr", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=21L)
    public Map<String, Object> unsetCOSInheritedAttr(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCOSInheritedAttr", "");
        return attrs;
    }

    @ZAttr(id=651L)
    public String[] getCalendarCalDavAlternateCalendarHomeSet() {
        return this.getMultiAttr("zimbraCalendarCalDavAlternateCalendarHomeSet");
    }

    @ZAttr(id=651L)
    public void setCalendarCalDavAlternateCalendarHomeSet(String[] zimbraCalendarCalDavAlternateCalendarHomeSet) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraCalendarCalDavAlternateCalendarHomeSet", zimbraCalendarCalDavAlternateCalendarHomeSet);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=651L)
    public Map<String, Object> setCalendarCalDavAlternateCalendarHomeSet(String[] zimbraCalendarCalDavAlternateCalendarHomeSet, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavAlternateCalendarHomeSet", zimbraCalendarCalDavAlternateCalendarHomeSet);
        return attrs;
    }

    @ZAttr(id=651L)
    public void addCalendarCalDavAlternateCalendarHomeSet(String zimbraCalendarCalDavAlternateCalendarHomeSet) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraCalendarCalDavAlternateCalendarHomeSet", zimbraCalendarCalDavAlternateCalendarHomeSet);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=651L)
    public Map<String, Object> addCalendarCalDavAlternateCalendarHomeSet(String zimbraCalendarCalDavAlternateCalendarHomeSet, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraCalendarCalDavAlternateCalendarHomeSet", zimbraCalendarCalDavAlternateCalendarHomeSet);
        return attrs;
    }

    @ZAttr(id=651L)
    public void removeCalendarCalDavAlternateCalendarHomeSet(String zimbraCalendarCalDavAlternateCalendarHomeSet) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraCalendarCalDavAlternateCalendarHomeSet", zimbraCalendarCalDavAlternateCalendarHomeSet);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=651L)
    public Map<String, Object> removeCalendarCalDavAlternateCalendarHomeSet(String zimbraCalendarCalDavAlternateCalendarHomeSet, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraCalendarCalDavAlternateCalendarHomeSet", zimbraCalendarCalDavAlternateCalendarHomeSet);
        return attrs;
    }

    @ZAttr(id=651L)
    public void unsetCalendarCalDavAlternateCalendarHomeSet() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCalDavAlternateCalendarHomeSet", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=651L)
    public Map<String, Object> unsetCalendarCalDavAlternateCalendarHomeSet(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavAlternateCalendarHomeSet", "");
        return attrs;
    }

    @ZAttr(id=820L)
    public boolean isCalendarCalDavClearTextPasswordEnabled() {
        return this.getBooleanAttr("zimbraCalendarCalDavClearTextPasswordEnabled", true);
    }

    @ZAttr(id=820L)
    public void setCalendarCalDavClearTextPasswordEnabled(boolean zimbraCalendarCalDavClearTextPasswordEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCalDavClearTextPasswordEnabled", zimbraCalendarCalDavClearTextPasswordEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=820L)
    public Map<String, Object> setCalendarCalDavClearTextPasswordEnabled(boolean zimbraCalendarCalDavClearTextPasswordEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavClearTextPasswordEnabled", zimbraCalendarCalDavClearTextPasswordEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=820L)
    public void unsetCalendarCalDavClearTextPasswordEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCalDavClearTextPasswordEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=820L)
    public Map<String, Object> unsetCalendarCalDavClearTextPasswordEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavClearTextPasswordEnabled", "");
        return attrs;
    }

    @ZAttr(id=690L)
    public boolean isCalendarCalDavDisableFreebusy() {
        return this.getBooleanAttr("zimbraCalendarCalDavDisableFreebusy", false);
    }

    @ZAttr(id=690L)
    public void setCalendarCalDavDisableFreebusy(boolean zimbraCalendarCalDavDisableFreebusy) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCalDavDisableFreebusy", zimbraCalendarCalDavDisableFreebusy ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=690L)
    public Map<String, Object> setCalendarCalDavDisableFreebusy(boolean zimbraCalendarCalDavDisableFreebusy, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavDisableFreebusy", zimbraCalendarCalDavDisableFreebusy ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=690L)
    public void unsetCalendarCalDavDisableFreebusy() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCalDavDisableFreebusy", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=690L)
    public Map<String, Object> unsetCalendarCalDavDisableFreebusy(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavDisableFreebusy", "");
        return attrs;
    }

    @ZAttr(id=652L)
    public boolean isCalendarCalDavDisableScheduling() {
        return this.getBooleanAttr("zimbraCalendarCalDavDisableScheduling", false);
    }

    @ZAttr(id=652L)
    public void setCalendarCalDavDisableScheduling(boolean zimbraCalendarCalDavDisableScheduling) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCalDavDisableScheduling", zimbraCalendarCalDavDisableScheduling ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=652L)
    public Map<String, Object> setCalendarCalDavDisableScheduling(boolean zimbraCalendarCalDavDisableScheduling, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavDisableScheduling", zimbraCalendarCalDavDisableScheduling ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=652L)
    public void unsetCalendarCalDavDisableScheduling() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCalDavDisableScheduling", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=652L)
    public Map<String, Object> unsetCalendarCalDavDisableScheduling(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavDisableScheduling", "");
        return attrs;
    }

    @ZAttr(id=794L)
    public boolean isCalendarCalDavUseDistinctAppointmentAndToDoCollection() {
        return this.getBooleanAttr("zimbraCalendarCalDavUseDistinctAppointmentAndToDoCollection", false);
    }

    @ZAttr(id=794L)
    public void setCalendarCalDavUseDistinctAppointmentAndToDoCollection(boolean zimbraCalendarCalDavUseDistinctAppointmentAndToDoCollection) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCalDavUseDistinctAppointmentAndToDoCollection", zimbraCalendarCalDavUseDistinctAppointmentAndToDoCollection ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=794L)
    public Map<String, Object> setCalendarCalDavUseDistinctAppointmentAndToDoCollection(boolean zimbraCalendarCalDavUseDistinctAppointmentAndToDoCollection, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavUseDistinctAppointmentAndToDoCollection", zimbraCalendarCalDavUseDistinctAppointmentAndToDoCollection ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=794L)
    public void unsetCalendarCalDavUseDistinctAppointmentAndToDoCollection() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCalDavUseDistinctAppointmentAndToDoCollection", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=794L)
    public Map<String, Object> unsetCalendarCalDavUseDistinctAppointmentAndToDoCollection(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCalDavUseDistinctAppointmentAndToDoCollection", "");
        return attrs;
    }

    @ZAttr(id=243L)
    public ZAttrProvisioning.CalendarCompatibilityMode getCalendarCompatibilityMode() {
        try {
            String v = this.getAttr("zimbraCalendarCompatibilityMode");
            return v == null ? ZAttrProvisioning.CalendarCompatibilityMode.standard : ZAttrProvisioning.CalendarCompatibilityMode.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.CalendarCompatibilityMode.standard;
        }
    }

    @ZAttr(id=243L)
    public String getCalendarCompatibilityModeAsString() {
        return this.getAttr("zimbraCalendarCompatibilityMode", "standard");
    }

    @ZAttr(id=243L)
    public void setCalendarCompatibilityMode(ZAttrProvisioning.CalendarCompatibilityMode zimbraCalendarCompatibilityMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCompatibilityMode", zimbraCalendarCompatibilityMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=243L)
    public Map<String, Object> setCalendarCompatibilityMode(ZAttrProvisioning.CalendarCompatibilityMode zimbraCalendarCompatibilityMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCompatibilityMode", zimbraCalendarCompatibilityMode.toString());
        return attrs;
    }

    @ZAttr(id=243L)
    public void setCalendarCompatibilityModeAsString(String zimbraCalendarCompatibilityMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCompatibilityMode", zimbraCalendarCompatibilityMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=243L)
    public Map<String, Object> setCalendarCompatibilityModeAsString(String zimbraCalendarCompatibilityMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCompatibilityMode", zimbraCalendarCompatibilityMode);
        return attrs;
    }

    @ZAttr(id=243L)
    public void unsetCalendarCompatibilityMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarCompatibilityMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=243L)
    public Map<String, Object> unsetCalendarCompatibilityMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarCompatibilityMode", "");
        return attrs;
    }

    @ZAttr(id=661L)
    public int getCalendarRecurrenceDailyMaxDays() {
        return this.getIntAttr("zimbraCalendarRecurrenceDailyMaxDays", 730);
    }

    @ZAttr(id=661L)
    public void setCalendarRecurrenceDailyMaxDays(int zimbraCalendarRecurrenceDailyMaxDays) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceDailyMaxDays", Integer.toString(zimbraCalendarRecurrenceDailyMaxDays));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=661L)
    public Map<String, Object> setCalendarRecurrenceDailyMaxDays(int zimbraCalendarRecurrenceDailyMaxDays, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceDailyMaxDays", Integer.toString(zimbraCalendarRecurrenceDailyMaxDays));
        return attrs;
    }

    @ZAttr(id=661L)
    public void unsetCalendarRecurrenceDailyMaxDays() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceDailyMaxDays", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=661L)
    public Map<String, Object> unsetCalendarRecurrenceDailyMaxDays(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceDailyMaxDays", "");
        return attrs;
    }

    @ZAttr(id=660L)
    public int getCalendarRecurrenceMaxInstances() {
        return this.getIntAttr("zimbraCalendarRecurrenceMaxInstances", 0);
    }

    @ZAttr(id=660L)
    public void setCalendarRecurrenceMaxInstances(int zimbraCalendarRecurrenceMaxInstances) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceMaxInstances", Integer.toString(zimbraCalendarRecurrenceMaxInstances));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=660L)
    public Map<String, Object> setCalendarRecurrenceMaxInstances(int zimbraCalendarRecurrenceMaxInstances, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceMaxInstances", Integer.toString(zimbraCalendarRecurrenceMaxInstances));
        return attrs;
    }

    @ZAttr(id=660L)
    public void unsetCalendarRecurrenceMaxInstances() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceMaxInstances", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=660L)
    public Map<String, Object> unsetCalendarRecurrenceMaxInstances(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceMaxInstances", "");
        return attrs;
    }

    @ZAttr(id=663L)
    public int getCalendarRecurrenceMonthlyMaxMonths() {
        return this.getIntAttr("zimbraCalendarRecurrenceMonthlyMaxMonths", 360);
    }

    @ZAttr(id=663L)
    public void setCalendarRecurrenceMonthlyMaxMonths(int zimbraCalendarRecurrenceMonthlyMaxMonths) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceMonthlyMaxMonths", Integer.toString(zimbraCalendarRecurrenceMonthlyMaxMonths));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=663L)
    public Map<String, Object> setCalendarRecurrenceMonthlyMaxMonths(int zimbraCalendarRecurrenceMonthlyMaxMonths, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceMonthlyMaxMonths", Integer.toString(zimbraCalendarRecurrenceMonthlyMaxMonths));
        return attrs;
    }

    @ZAttr(id=663L)
    public void unsetCalendarRecurrenceMonthlyMaxMonths() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceMonthlyMaxMonths", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=663L)
    public Map<String, Object> unsetCalendarRecurrenceMonthlyMaxMonths(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceMonthlyMaxMonths", "");
        return attrs;
    }

    @ZAttr(id=665L)
    public int getCalendarRecurrenceOtherFrequencyMaxYears() {
        return this.getIntAttr("zimbraCalendarRecurrenceOtherFrequencyMaxYears", 1);
    }

    @ZAttr(id=665L)
    public void setCalendarRecurrenceOtherFrequencyMaxYears(int zimbraCalendarRecurrenceOtherFrequencyMaxYears) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceOtherFrequencyMaxYears", Integer.toString(zimbraCalendarRecurrenceOtherFrequencyMaxYears));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=665L)
    public Map<String, Object> setCalendarRecurrenceOtherFrequencyMaxYears(int zimbraCalendarRecurrenceOtherFrequencyMaxYears, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceOtherFrequencyMaxYears", Integer.toString(zimbraCalendarRecurrenceOtherFrequencyMaxYears));
        return attrs;
    }

    @ZAttr(id=665L)
    public void unsetCalendarRecurrenceOtherFrequencyMaxYears() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceOtherFrequencyMaxYears", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=665L)
    public Map<String, Object> unsetCalendarRecurrenceOtherFrequencyMaxYears(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceOtherFrequencyMaxYears", "");
        return attrs;
    }

    @ZAttr(id=662L)
    public int getCalendarRecurrenceWeeklyMaxWeeks() {
        return this.getIntAttr("zimbraCalendarRecurrenceWeeklyMaxWeeks", 520);
    }

    @ZAttr(id=662L)
    public void setCalendarRecurrenceWeeklyMaxWeeks(int zimbraCalendarRecurrenceWeeklyMaxWeeks) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceWeeklyMaxWeeks", Integer.toString(zimbraCalendarRecurrenceWeeklyMaxWeeks));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=662L)
    public Map<String, Object> setCalendarRecurrenceWeeklyMaxWeeks(int zimbraCalendarRecurrenceWeeklyMaxWeeks, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceWeeklyMaxWeeks", Integer.toString(zimbraCalendarRecurrenceWeeklyMaxWeeks));
        return attrs;
    }

    @ZAttr(id=662L)
    public void unsetCalendarRecurrenceWeeklyMaxWeeks() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceWeeklyMaxWeeks", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=662L)
    public Map<String, Object> unsetCalendarRecurrenceWeeklyMaxWeeks(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceWeeklyMaxWeeks", "");
        return attrs;
    }

    @ZAttr(id=664L)
    public int getCalendarRecurrenceYearlyMaxYears() {
        return this.getIntAttr("zimbraCalendarRecurrenceYearlyMaxYears", 100);
    }

    @ZAttr(id=664L)
    public void setCalendarRecurrenceYearlyMaxYears(int zimbraCalendarRecurrenceYearlyMaxYears) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceYearlyMaxYears", Integer.toString(zimbraCalendarRecurrenceYearlyMaxYears));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=664L)
    public Map<String, Object> setCalendarRecurrenceYearlyMaxYears(int zimbraCalendarRecurrenceYearlyMaxYears, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceYearlyMaxYears", Integer.toString(zimbraCalendarRecurrenceYearlyMaxYears));
        return attrs;
    }

    @ZAttr(id=664L)
    public void unsetCalendarRecurrenceYearlyMaxYears() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarRecurrenceYearlyMaxYears", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=664L)
    public Map<String, Object> unsetCalendarRecurrenceYearlyMaxYears(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarRecurrenceYearlyMaxYears", "");
        return attrs;
    }

    @ZAttr(id=753L)
    public String[] getCalendarResourceExtraObjectClass() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraCalendarResourceExtraObjectClass");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "amavisAccount";
        }
        return stringArray;
    }

    @ZAttr(id=753L)
    public void setCalendarResourceExtraObjectClass(String[] zimbraCalendarResourceExtraObjectClass) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraCalendarResourceExtraObjectClass", zimbraCalendarResourceExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=753L)
    public Map<String, Object> setCalendarResourceExtraObjectClass(String[] zimbraCalendarResourceExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarResourceExtraObjectClass", zimbraCalendarResourceExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=753L)
    public void addCalendarResourceExtraObjectClass(String zimbraCalendarResourceExtraObjectClass) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraCalendarResourceExtraObjectClass", zimbraCalendarResourceExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=753L)
    public Map<String, Object> addCalendarResourceExtraObjectClass(String zimbraCalendarResourceExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraCalendarResourceExtraObjectClass", zimbraCalendarResourceExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=753L)
    public void removeCalendarResourceExtraObjectClass(String zimbraCalendarResourceExtraObjectClass) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraCalendarResourceExtraObjectClass", zimbraCalendarResourceExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=753L)
    public Map<String, Object> removeCalendarResourceExtraObjectClass(String zimbraCalendarResourceExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraCalendarResourceExtraObjectClass", zimbraCalendarResourceExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=753L)
    public void unsetCalendarResourceExtraObjectClass() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalendarResourceExtraObjectClass", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=753L)
    public Map<String, Object> unsetCalendarResourceExtraObjectClass(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalendarResourceExtraObjectClass", "");
        return attrs;
    }

    @ZAttr(id=280L)
    public String getCertAuthorityCertSelfSigned() {
        return this.getAttr("zimbraCertAuthorityCertSelfSigned", null);
    }

    @ZAttr(id=280L)
    public void setCertAuthorityCertSelfSigned(String zimbraCertAuthorityCertSelfSigned) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCertAuthorityCertSelfSigned", zimbraCertAuthorityCertSelfSigned);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=280L)
    public Map<String, Object> setCertAuthorityCertSelfSigned(String zimbraCertAuthorityCertSelfSigned, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCertAuthorityCertSelfSigned", zimbraCertAuthorityCertSelfSigned);
        return attrs;
    }

    @ZAttr(id=280L)
    public void unsetCertAuthorityCertSelfSigned() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCertAuthorityCertSelfSigned", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=280L)
    public Map<String, Object> unsetCertAuthorityCertSelfSigned(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCertAuthorityCertSelfSigned", "");
        return attrs;
    }

    @ZAttr(id=279L)
    public String getCertAuthorityKeySelfSigned() {
        return this.getAttr("zimbraCertAuthorityKeySelfSigned", null);
    }

    @ZAttr(id=279L)
    public void setCertAuthorityKeySelfSigned(String zimbraCertAuthorityKeySelfSigned) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCertAuthorityKeySelfSigned", zimbraCertAuthorityKeySelfSigned);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=279L)
    public Map<String, Object> setCertAuthorityKeySelfSigned(String zimbraCertAuthorityKeySelfSigned, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCertAuthorityKeySelfSigned", zimbraCertAuthorityKeySelfSigned);
        return attrs;
    }

    @ZAttr(id=279L)
    public void unsetCertAuthorityKeySelfSigned() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCertAuthorityKeySelfSigned", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=279L)
    public Map<String, Object> unsetCertAuthorityKeySelfSigned(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCertAuthorityKeySelfSigned", "");
        return attrs;
    }

    @ZAttr(id=777L)
    public String getChangePasswordURL() {
        return this.getAttr("zimbraChangePasswordURL", null);
    }

    @ZAttr(id=777L)
    public void setChangePasswordURL(String zimbraChangePasswordURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraChangePasswordURL", zimbraChangePasswordURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=777L)
    public Map<String, Object> setChangePasswordURL(String zimbraChangePasswordURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraChangePasswordURL", zimbraChangePasswordURL);
        return attrs;
    }

    @ZAttr(id=777L)
    public void unsetChangePasswordURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraChangePasswordURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=777L)
    public Map<String, Object> unsetChangePasswordURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraChangePasswordURL", "");
        return attrs;
    }

    @ZAttr(id=508L)
    public ZAttrProvisioning.ClusterType getClusterType() {
        try {
            String v = this.getAttr("zimbraClusterType");
            return v == null ? ZAttrProvisioning.ClusterType.none : ZAttrProvisioning.ClusterType.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.ClusterType.none;
        }
    }

    @ZAttr(id=508L)
    public String getClusterTypeAsString() {
        return this.getAttr("zimbraClusterType", "none");
    }

    @ZAttr(id=508L)
    public void setClusterType(ZAttrProvisioning.ClusterType zimbraClusterType) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraClusterType", zimbraClusterType.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=508L)
    public Map<String, Object> setClusterType(ZAttrProvisioning.ClusterType zimbraClusterType, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraClusterType", zimbraClusterType.toString());
        return attrs;
    }

    @ZAttr(id=508L)
    public void setClusterTypeAsString(String zimbraClusterType) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraClusterType", zimbraClusterType);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=508L)
    public Map<String, Object> setClusterTypeAsString(String zimbraClusterType, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraClusterType", zimbraClusterType);
        return attrs;
    }

    @ZAttr(id=508L)
    public void unsetClusterType() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraClusterType", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=508L)
    public Map<String, Object> unsetClusterType(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraClusterType", "");
        return attrs;
    }

    @ZAttr(id=242L)
    public String[] getComponentAvailable() {
        return this.getMultiAttr("zimbraComponentAvailable");
    }

    @ZAttr(id=242L)
    public void setComponentAvailable(String[] zimbraComponentAvailable) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraComponentAvailable", zimbraComponentAvailable);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=242L)
    public Map<String, Object> setComponentAvailable(String[] zimbraComponentAvailable, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraComponentAvailable", zimbraComponentAvailable);
        return attrs;
    }

    @ZAttr(id=242L)
    public void addComponentAvailable(String zimbraComponentAvailable) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraComponentAvailable", zimbraComponentAvailable);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=242L)
    public Map<String, Object> addComponentAvailable(String zimbraComponentAvailable, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraComponentAvailable", zimbraComponentAvailable);
        return attrs;
    }

    @ZAttr(id=242L)
    public void removeComponentAvailable(String zimbraComponentAvailable) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraComponentAvailable", zimbraComponentAvailable);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=242L)
    public Map<String, Object> removeComponentAvailable(String zimbraComponentAvailable, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraComponentAvailable", zimbraComponentAvailable);
        return attrs;
    }

    @ZAttr(id=242L)
    public void unsetComponentAvailable() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraComponentAvailable", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=242L)
    public Map<String, Object> unsetComponentAvailable(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraComponentAvailable", "");
        return attrs;
    }

    @ZAttr(id=766L)
    public String[] getConstraint() {
        return this.getMultiAttr("zimbraConstraint");
    }

    @ZAttr(id=766L)
    public void setConstraint(String[] zimbraConstraint) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraConstraint", zimbraConstraint);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=766L)
    public Map<String, Object> setConstraint(String[] zimbraConstraint, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraConstraint", zimbraConstraint);
        return attrs;
    }

    @ZAttr(id=766L)
    public void addConstraint(String zimbraConstraint) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraConstraint", zimbraConstraint);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=766L)
    public Map<String, Object> addConstraint(String zimbraConstraint, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraConstraint", zimbraConstraint);
        return attrs;
    }

    @ZAttr(id=766L)
    public void removeConstraint(String zimbraConstraint) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraConstraint", zimbraConstraint);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=766L)
    public Map<String, Object> removeConstraint(String zimbraConstraint, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraConstraint", zimbraConstraint);
        return attrs;
    }

    @ZAttr(id=766L)
    public void unsetConstraint() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraConstraint", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=766L)
    public Map<String, Object> unsetConstraint(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraConstraint", "");
        return attrs;
    }

    @ZAttr(id=1023L)
    public long getContactRankingTableRefreshInterval() {
        return this.getTimeInterval("zimbraContactRankingTableRefreshInterval", 604800000L);
    }

    @ZAttr(id=1023L)
    public String getContactRankingTableRefreshIntervalAsString() {
        return this.getAttr("zimbraContactRankingTableRefreshInterval", "7d");
    }

    @ZAttr(id=1023L)
    public void setContactRankingTableRefreshInterval(String zimbraContactRankingTableRefreshInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraContactRankingTableRefreshInterval", zimbraContactRankingTableRefreshInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1023L)
    public Map<String, Object> setContactRankingTableRefreshInterval(String zimbraContactRankingTableRefreshInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraContactRankingTableRefreshInterval", zimbraContactRankingTableRefreshInterval);
        return attrs;
    }

    @ZAttr(id=1023L)
    public void unsetContactRankingTableRefreshInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraContactRankingTableRefreshInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1023L)
    public Map<String, Object> unsetContactRankingTableRefreshInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraContactRankingTableRefreshInterval", "");
        return attrs;
    }

    @ZAttr(id=776L)
    public String getConvertdURL() {
        return this.getAttr("zimbraConvertdURL", null);
    }

    @ZAttr(id=776L)
    public void setConvertdURL(String zimbraConvertdURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraConvertdURL", zimbraConvertdURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=776L)
    public Map<String, Object> setConvertdURL(String zimbraConvertdURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraConvertdURL", zimbraConvertdURL);
        return attrs;
    }

    @ZAttr(id=776L)
    public void unsetConvertdURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraConvertdURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=776L)
    public Map<String, Object> unsetConvertdURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraConvertdURL", "");
        return attrs;
    }

    @ZAttr(id=754L)
    public String[] getCosExtraObjectClass() {
        return this.getMultiAttr("zimbraCosExtraObjectClass");
    }

    @ZAttr(id=754L)
    public void setCosExtraObjectClass(String[] zimbraCosExtraObjectClass) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraCosExtraObjectClass", zimbraCosExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=754L)
    public Map<String, Object> setCosExtraObjectClass(String[] zimbraCosExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCosExtraObjectClass", zimbraCosExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=754L)
    public void addCosExtraObjectClass(String zimbraCosExtraObjectClass) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraCosExtraObjectClass", zimbraCosExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=754L)
    public Map<String, Object> addCosExtraObjectClass(String zimbraCosExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraCosExtraObjectClass", zimbraCosExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=754L)
    public void removeCosExtraObjectClass(String zimbraCosExtraObjectClass) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraCosExtraObjectClass", zimbraCosExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=754L)
    public Map<String, Object> removeCosExtraObjectClass(String zimbraCosExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraCosExtraObjectClass", zimbraCosExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=754L)
    public void unsetCosExtraObjectClass() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCosExtraObjectClass", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=754L)
    public Map<String, Object> unsetCosExtraObjectClass(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCosExtraObjectClass", "");
        return attrs;
    }

    @ZAttr(id=790L)
    public Date getCreateTimestamp() {
        return this.getGeneralizedTimeAttr("zimbraCreateTimestamp", null);
    }

    @ZAttr(id=790L)
    public String getCreateTimestampAsString() {
        return this.getAttr("zimbraCreateTimestamp", null);
    }

    @ZAttr(id=790L)
    public void setCreateTimestamp(Date zimbraCreateTimestamp) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(zimbraCreateTimestamp));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=790L)
    public Map<String, Object> setCreateTimestamp(Date zimbraCreateTimestamp, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(zimbraCreateTimestamp));
        return attrs;
    }

    @ZAttr(id=790L)
    public void setCreateTimestampAsString(String zimbraCreateTimestamp) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCreateTimestamp", zimbraCreateTimestamp);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=790L)
    public Map<String, Object> setCreateTimestampAsString(String zimbraCreateTimestamp, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCreateTimestamp", zimbraCreateTimestamp);
        return attrs;
    }

    @ZAttr(id=790L)
    public void unsetCreateTimestamp() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCreateTimestamp", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=790L)
    public Map<String, Object> unsetCreateTimestamp(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCreateTimestamp", "");
        return attrs;
    }

    @ZAttr(id=744L)
    public String getDNSCheckHostname() {
        return this.getAttr("zimbraDNSCheckHostname", null);
    }

    @ZAttr(id=744L)
    public void setDNSCheckHostname(String zimbraDNSCheckHostname) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDNSCheckHostname", zimbraDNSCheckHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=744L)
    public Map<String, Object> setDNSCheckHostname(String zimbraDNSCheckHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDNSCheckHostname", zimbraDNSCheckHostname);
        return attrs;
    }

    @ZAttr(id=744L)
    public void unsetDNSCheckHostname() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDNSCheckHostname", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=744L)
    public Map<String, Object> unsetDNSCheckHostname(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDNSCheckHostname", "");
        return attrs;
    }

    @ZAttr(id=1038L)
    public long getDatabaseSlowSqlThreshold() {
        return this.getTimeInterval("zimbraDatabaseSlowSqlThreshold", 2000L);
    }

    @ZAttr(id=1038L)
    public String getDatabaseSlowSqlThresholdAsString() {
        return this.getAttr("zimbraDatabaseSlowSqlThreshold", "2s");
    }

    @ZAttr(id=1038L)
    public void setDatabaseSlowSqlThreshold(String zimbraDatabaseSlowSqlThreshold) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDatabaseSlowSqlThreshold", zimbraDatabaseSlowSqlThreshold);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1038L)
    public Map<String, Object> setDatabaseSlowSqlThreshold(String zimbraDatabaseSlowSqlThreshold, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDatabaseSlowSqlThreshold", zimbraDatabaseSlowSqlThreshold);
        return attrs;
    }

    @ZAttr(id=1038L)
    public void unsetDatabaseSlowSqlThreshold() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDatabaseSlowSqlThreshold", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1038L)
    public Map<String, Object> unsetDatabaseSlowSqlThreshold(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDatabaseSlowSqlThreshold", "");
        return attrs;
    }

    @ZAttr(id=172L)
    public String getDefaultDomainName() {
        return this.getAttr("zimbraDefaultDomainName", null);
    }

    @ZAttr(id=172L)
    public void setDefaultDomainName(String zimbraDefaultDomainName) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDefaultDomainName", zimbraDefaultDomainName);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=172L)
    public Map<String, Object> setDefaultDomainName(String zimbraDefaultDomainName, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDefaultDomainName", zimbraDefaultDomainName);
        return attrs;
    }

    @ZAttr(id=172L)
    public void unsetDefaultDomainName() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDefaultDomainName", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=172L)
    public Map<String, Object> unsetDefaultDomainName(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDefaultDomainName", "");
        return attrs;
    }

    @ZAttr(id=300L)
    public String[] getDomainAdminModifiableAttr() {
        return this.getMultiAttr("zimbraDomainAdminModifiableAttr");
    }

    @ZAttr(id=300L)
    public void setDomainAdminModifiableAttr(String[] zimbraDomainAdminModifiableAttr) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraDomainAdminModifiableAttr", zimbraDomainAdminModifiableAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=300L)
    public Map<String, Object> setDomainAdminModifiableAttr(String[] zimbraDomainAdminModifiableAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainAdminModifiableAttr", zimbraDomainAdminModifiableAttr);
        return attrs;
    }

    @ZAttr(id=300L)
    public void addDomainAdminModifiableAttr(String zimbraDomainAdminModifiableAttr) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraDomainAdminModifiableAttr", zimbraDomainAdminModifiableAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=300L)
    public Map<String, Object> addDomainAdminModifiableAttr(String zimbraDomainAdminModifiableAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraDomainAdminModifiableAttr", zimbraDomainAdminModifiableAttr);
        return attrs;
    }

    @ZAttr(id=300L)
    public void removeDomainAdminModifiableAttr(String zimbraDomainAdminModifiableAttr) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraDomainAdminModifiableAttr", zimbraDomainAdminModifiableAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=300L)
    public Map<String, Object> removeDomainAdminModifiableAttr(String zimbraDomainAdminModifiableAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraDomainAdminModifiableAttr", zimbraDomainAdminModifiableAttr);
        return attrs;
    }

    @ZAttr(id=300L)
    public void unsetDomainAdminModifiableAttr() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainAdminModifiableAttr", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=300L)
    public Map<String, Object> unsetDomainAdminModifiableAttr(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainAdminModifiableAttr", "");
        return attrs;
    }

    @ZAttr(id=755L)
    public String[] getDomainExtraObjectClass() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraDomainExtraObjectClass");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "amavisAccount";
        }
        return stringArray;
    }

    @ZAttr(id=755L)
    public void setDomainExtraObjectClass(String[] zimbraDomainExtraObjectClass) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraDomainExtraObjectClass", zimbraDomainExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=755L)
    public Map<String, Object> setDomainExtraObjectClass(String[] zimbraDomainExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainExtraObjectClass", zimbraDomainExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=755L)
    public void addDomainExtraObjectClass(String zimbraDomainExtraObjectClass) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraDomainExtraObjectClass", zimbraDomainExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=755L)
    public Map<String, Object> addDomainExtraObjectClass(String zimbraDomainExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraDomainExtraObjectClass", zimbraDomainExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=755L)
    public void removeDomainExtraObjectClass(String zimbraDomainExtraObjectClass) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraDomainExtraObjectClass", zimbraDomainExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=755L)
    public Map<String, Object> removeDomainExtraObjectClass(String zimbraDomainExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraDomainExtraObjectClass", zimbraDomainExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=755L)
    public void unsetDomainExtraObjectClass() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainExtraObjectClass", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=755L)
    public Map<String, Object> unsetDomainExtraObjectClass(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainExtraObjectClass", "");
        return attrs;
    }

    @ZAttr(id=63L)
    public String[] getDomainInheritedAttr() {
        return this.getMultiAttr("zimbraDomainInheritedAttr");
    }

    @ZAttr(id=63L)
    public void setDomainInheritedAttr(String[] zimbraDomainInheritedAttr) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraDomainInheritedAttr", zimbraDomainInheritedAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=63L)
    public Map<String, Object> setDomainInheritedAttr(String[] zimbraDomainInheritedAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainInheritedAttr", zimbraDomainInheritedAttr);
        return attrs;
    }

    @ZAttr(id=63L)
    public void addDomainInheritedAttr(String zimbraDomainInheritedAttr) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraDomainInheritedAttr", zimbraDomainInheritedAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=63L)
    public Map<String, Object> addDomainInheritedAttr(String zimbraDomainInheritedAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraDomainInheritedAttr", zimbraDomainInheritedAttr);
        return attrs;
    }

    @ZAttr(id=63L)
    public void removeDomainInheritedAttr(String zimbraDomainInheritedAttr) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraDomainInheritedAttr", zimbraDomainInheritedAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=63L)
    public Map<String, Object> removeDomainInheritedAttr(String zimbraDomainInheritedAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraDomainInheritedAttr", zimbraDomainInheritedAttr);
        return attrs;
    }

    @ZAttr(id=63L)
    public void unsetDomainInheritedAttr() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainInheritedAttr", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=63L)
    public Map<String, Object> unsetDomainInheritedAttr(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainInheritedAttr", "");
        return attrs;
    }

    @ZAttr(id=1069L)
    public boolean isDomainMandatoryMailSignatureEnabled() {
        return this.getBooleanAttr("zimbraDomainMandatoryMailSignatureEnabled", false);
    }

    @ZAttr(id=1069L)
    public void setDomainMandatoryMailSignatureEnabled(boolean zimbraDomainMandatoryMailSignatureEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainMandatoryMailSignatureEnabled", zimbraDomainMandatoryMailSignatureEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1069L)
    public Map<String, Object> setDomainMandatoryMailSignatureEnabled(boolean zimbraDomainMandatoryMailSignatureEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainMandatoryMailSignatureEnabled", zimbraDomainMandatoryMailSignatureEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1069L)
    public void unsetDomainMandatoryMailSignatureEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainMandatoryMailSignatureEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1069L)
    public Map<String, Object> unsetDomainMandatoryMailSignatureEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainMandatoryMailSignatureEnabled", "");
        return attrs;
    }

    @ZAttr(id=1071L)
    public String getDomainMandatoryMailSignatureHTML() {
        return this.getAttr("zimbraDomainMandatoryMailSignatureHTML", null);
    }

    @ZAttr(id=1071L)
    public void setDomainMandatoryMailSignatureHTML(String zimbraDomainMandatoryMailSignatureHTML) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainMandatoryMailSignatureHTML", zimbraDomainMandatoryMailSignatureHTML);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1071L)
    public Map<String, Object> setDomainMandatoryMailSignatureHTML(String zimbraDomainMandatoryMailSignatureHTML, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainMandatoryMailSignatureHTML", zimbraDomainMandatoryMailSignatureHTML);
        return attrs;
    }

    @ZAttr(id=1071L)
    public void unsetDomainMandatoryMailSignatureHTML() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainMandatoryMailSignatureHTML", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1071L)
    public Map<String, Object> unsetDomainMandatoryMailSignatureHTML(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainMandatoryMailSignatureHTML", "");
        return attrs;
    }

    @ZAttr(id=1070L)
    public String getDomainMandatoryMailSignatureText() {
        return this.getAttr("zimbraDomainMandatoryMailSignatureText", null);
    }

    @ZAttr(id=1070L)
    public void setDomainMandatoryMailSignatureText(String zimbraDomainMandatoryMailSignatureText) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainMandatoryMailSignatureText", zimbraDomainMandatoryMailSignatureText);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1070L)
    public Map<String, Object> setDomainMandatoryMailSignatureText(String zimbraDomainMandatoryMailSignatureText, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainMandatoryMailSignatureText", zimbraDomainMandatoryMailSignatureText);
        return attrs;
    }

    @ZAttr(id=1070L)
    public void unsetDomainMandatoryMailSignatureText() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainMandatoryMailSignatureText", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1070L)
    public Map<String, Object> unsetDomainMandatoryMailSignatureText(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainMandatoryMailSignatureText", "");
        return attrs;
    }

    @ZAttr(id=535L)
    public ZAttrProvisioning.DomainStatus getDomainStatus() {
        try {
            String v = this.getAttr("zimbraDomainStatus");
            return v == null ? null : ZAttrProvisioning.DomainStatus.fromString(v);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @ZAttr(id=535L)
    public String getDomainStatusAsString() {
        return this.getAttr("zimbraDomainStatus", null);
    }

    @ZAttr(id=535L)
    public void setDomainStatus(ZAttrProvisioning.DomainStatus zimbraDomainStatus) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainStatus", zimbraDomainStatus.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=535L)
    public Map<String, Object> setDomainStatus(ZAttrProvisioning.DomainStatus zimbraDomainStatus, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainStatus", zimbraDomainStatus.toString());
        return attrs;
    }

    @ZAttr(id=535L)
    public void setDomainStatusAsString(String zimbraDomainStatus) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainStatus", zimbraDomainStatus);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=535L)
    public Map<String, Object> setDomainStatusAsString(String zimbraDomainStatus, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainStatus", zimbraDomainStatus);
        return attrs;
    }

    @ZAttr(id=535L)
    public void unsetDomainStatus() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraDomainStatus", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=535L)
    public Map<String, Object> unsetDomainStatus(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraDomainStatus", "");
        return attrs;
    }

    @ZAttr(id=227L)
    public long getFileUploadMaxSize() {
        return this.getLongAttr("zimbraFileUploadMaxSize", 0xA00000L);
    }

    @ZAttr(id=227L)
    public void setFileUploadMaxSize(long zimbraFileUploadMaxSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFileUploadMaxSize", Long.toString(zimbraFileUploadMaxSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=227L)
    public Map<String, Object> setFileUploadMaxSize(long zimbraFileUploadMaxSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFileUploadMaxSize", Long.toString(zimbraFileUploadMaxSize));
        return attrs;
    }

    @ZAttr(id=227L)
    public void unsetFileUploadMaxSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFileUploadMaxSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=227L)
    public Map<String, Object> unsetFileUploadMaxSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFileUploadMaxSize", "");
        return attrs;
    }

    @ZAttr(id=609L)
    public String getFreebusyExchangeAuthPassword() {
        return this.getAttr("zimbraFreebusyExchangeAuthPassword", null);
    }

    @ZAttr(id=609L)
    public void setFreebusyExchangeAuthPassword(String zimbraFreebusyExchangeAuthPassword) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeAuthPassword", zimbraFreebusyExchangeAuthPassword);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=609L)
    public Map<String, Object> setFreebusyExchangeAuthPassword(String zimbraFreebusyExchangeAuthPassword, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeAuthPassword", zimbraFreebusyExchangeAuthPassword);
        return attrs;
    }

    @ZAttr(id=609L)
    public void unsetFreebusyExchangeAuthPassword() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeAuthPassword", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=609L)
    public Map<String, Object> unsetFreebusyExchangeAuthPassword(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeAuthPassword", "");
        return attrs;
    }

    @ZAttr(id=611L)
    public ZAttrProvisioning.FreebusyExchangeAuthScheme getFreebusyExchangeAuthScheme() {
        try {
            String v = this.getAttr("zimbraFreebusyExchangeAuthScheme");
            return v == null ? null : ZAttrProvisioning.FreebusyExchangeAuthScheme.fromString(v);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @ZAttr(id=611L)
    public String getFreebusyExchangeAuthSchemeAsString() {
        return this.getAttr("zimbraFreebusyExchangeAuthScheme", null);
    }

    @ZAttr(id=611L)
    public void setFreebusyExchangeAuthScheme(ZAttrProvisioning.FreebusyExchangeAuthScheme zimbraFreebusyExchangeAuthScheme) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeAuthScheme", zimbraFreebusyExchangeAuthScheme.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=611L)
    public Map<String, Object> setFreebusyExchangeAuthScheme(ZAttrProvisioning.FreebusyExchangeAuthScheme zimbraFreebusyExchangeAuthScheme, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeAuthScheme", zimbraFreebusyExchangeAuthScheme.toString());
        return attrs;
    }

    @ZAttr(id=611L)
    public void setFreebusyExchangeAuthSchemeAsString(String zimbraFreebusyExchangeAuthScheme) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeAuthScheme", zimbraFreebusyExchangeAuthScheme);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=611L)
    public Map<String, Object> setFreebusyExchangeAuthSchemeAsString(String zimbraFreebusyExchangeAuthScheme, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeAuthScheme", zimbraFreebusyExchangeAuthScheme);
        return attrs;
    }

    @ZAttr(id=611L)
    public void unsetFreebusyExchangeAuthScheme() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeAuthScheme", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=611L)
    public Map<String, Object> unsetFreebusyExchangeAuthScheme(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeAuthScheme", "");
        return attrs;
    }

    @ZAttr(id=608L)
    public String getFreebusyExchangeAuthUsername() {
        return this.getAttr("zimbraFreebusyExchangeAuthUsername", null);
    }

    @ZAttr(id=608L)
    public void setFreebusyExchangeAuthUsername(String zimbraFreebusyExchangeAuthUsername) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeAuthUsername", zimbraFreebusyExchangeAuthUsername);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=608L)
    public Map<String, Object> setFreebusyExchangeAuthUsername(String zimbraFreebusyExchangeAuthUsername, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeAuthUsername", zimbraFreebusyExchangeAuthUsername);
        return attrs;
    }

    @ZAttr(id=608L)
    public void unsetFreebusyExchangeAuthUsername() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeAuthUsername", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=608L)
    public Map<String, Object> unsetFreebusyExchangeAuthUsername(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeAuthUsername", "");
        return attrs;
    }

    @ZAttr(id=621L)
    public long getFreebusyExchangeCachedInterval() {
        return this.getTimeInterval("zimbraFreebusyExchangeCachedInterval", 5184000000L);
    }

    @ZAttr(id=621L)
    public String getFreebusyExchangeCachedIntervalAsString() {
        return this.getAttr("zimbraFreebusyExchangeCachedInterval", "60d");
    }

    @ZAttr(id=621L)
    public void setFreebusyExchangeCachedInterval(String zimbraFreebusyExchangeCachedInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeCachedInterval", zimbraFreebusyExchangeCachedInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=621L)
    public Map<String, Object> setFreebusyExchangeCachedInterval(String zimbraFreebusyExchangeCachedInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeCachedInterval", zimbraFreebusyExchangeCachedInterval);
        return attrs;
    }

    @ZAttr(id=621L)
    public void unsetFreebusyExchangeCachedInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeCachedInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=621L)
    public Map<String, Object> unsetFreebusyExchangeCachedInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeCachedInterval", "");
        return attrs;
    }

    @ZAttr(id=620L)
    public long getFreebusyExchangeCachedIntervalStart() {
        return this.getTimeInterval("zimbraFreebusyExchangeCachedIntervalStart", 604800000L);
    }

    @ZAttr(id=620L)
    public String getFreebusyExchangeCachedIntervalStartAsString() {
        return this.getAttr("zimbraFreebusyExchangeCachedIntervalStart", "7d");
    }

    @ZAttr(id=620L)
    public void setFreebusyExchangeCachedIntervalStart(String zimbraFreebusyExchangeCachedIntervalStart) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeCachedIntervalStart", zimbraFreebusyExchangeCachedIntervalStart);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=620L)
    public Map<String, Object> setFreebusyExchangeCachedIntervalStart(String zimbraFreebusyExchangeCachedIntervalStart, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeCachedIntervalStart", zimbraFreebusyExchangeCachedIntervalStart);
        return attrs;
    }

    @ZAttr(id=620L)
    public void unsetFreebusyExchangeCachedIntervalStart() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeCachedIntervalStart", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=620L)
    public Map<String, Object> unsetFreebusyExchangeCachedIntervalStart(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeCachedIntervalStart", "");
        return attrs;
    }

    @ZAttr(id=607L)
    public String getFreebusyExchangeURL() {
        return this.getAttr("zimbraFreebusyExchangeURL", null);
    }

    @ZAttr(id=607L)
    public void setFreebusyExchangeURL(String zimbraFreebusyExchangeURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeURL", zimbraFreebusyExchangeURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=607L)
    public Map<String, Object> setFreebusyExchangeURL(String zimbraFreebusyExchangeURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeURL", zimbraFreebusyExchangeURL);
        return attrs;
    }

    @ZAttr(id=607L)
    public void unsetFreebusyExchangeURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=607L)
    public Map<String, Object> unsetFreebusyExchangeURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeURL", "");
        return attrs;
    }

    @ZAttr(id=610L)
    public String getFreebusyExchangeUserOrg() {
        return this.getAttr("zimbraFreebusyExchangeUserOrg", null);
    }

    @ZAttr(id=610L)
    public void setFreebusyExchangeUserOrg(String zimbraFreebusyExchangeUserOrg) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeUserOrg", zimbraFreebusyExchangeUserOrg);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=610L)
    public Map<String, Object> setFreebusyExchangeUserOrg(String zimbraFreebusyExchangeUserOrg, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeUserOrg", zimbraFreebusyExchangeUserOrg);
        return attrs;
    }

    @ZAttr(id=610L)
    public void unsetFreebusyExchangeUserOrg() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyExchangeUserOrg", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=610L)
    public Map<String, Object> unsetFreebusyExchangeUserOrg(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyExchangeUserOrg", "");
        return attrs;
    }

    @ZAttr(id=1026L)
    public long getFreebusyPropagationRetryInterval() {
        return this.getTimeInterval("zimbraFreebusyPropagationRetryInterval", 60000L);
    }

    @ZAttr(id=1026L)
    public String getFreebusyPropagationRetryIntervalAsString() {
        return this.getAttr("zimbraFreebusyPropagationRetryInterval", "1m");
    }

    @ZAttr(id=1026L)
    public void setFreebusyPropagationRetryInterval(String zimbraFreebusyPropagationRetryInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyPropagationRetryInterval", zimbraFreebusyPropagationRetryInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1026L)
    public Map<String, Object> setFreebusyPropagationRetryInterval(String zimbraFreebusyPropagationRetryInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyPropagationRetryInterval", zimbraFreebusyPropagationRetryInterval);
        return attrs;
    }

    @ZAttr(id=1026L)
    public void unsetFreebusyPropagationRetryInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraFreebusyPropagationRetryInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1026L)
    public Map<String, Object> unsetFreebusyPropagationRetryInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraFreebusyPropagationRetryInterval", "");
        return attrs;
    }

    @ZAttr(id=360L)
    public String getGalAutoCompleteLdapFilter() {
        return this.getAttr("zimbraGalAutoCompleteLdapFilter", "externalLdapAutoComplete");
    }

    @ZAttr(id=360L)
    public void setGalAutoCompleteLdapFilter(String zimbraGalAutoCompleteLdapFilter) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalAutoCompleteLdapFilter", zimbraGalAutoCompleteLdapFilter);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=360L)
    public Map<String, Object> setGalAutoCompleteLdapFilter(String zimbraGalAutoCompleteLdapFilter, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalAutoCompleteLdapFilter", zimbraGalAutoCompleteLdapFilter);
        return attrs;
    }

    @ZAttr(id=360L)
    public void unsetGalAutoCompleteLdapFilter() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalAutoCompleteLdapFilter", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=360L)
    public Map<String, Object> unsetGalAutoCompleteLdapFilter(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalAutoCompleteLdapFilter", "");
        return attrs;
    }

    @ZAttr(id=358L)
    public String getGalInternalSearchBase() {
        return this.getAttr("zimbraGalInternalSearchBase", "DOMAIN");
    }

    @ZAttr(id=358L)
    public void setGalInternalSearchBase(String zimbraGalInternalSearchBase) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalInternalSearchBase", zimbraGalInternalSearchBase);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=358L)
    public Map<String, Object> setGalInternalSearchBase(String zimbraGalInternalSearchBase, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalInternalSearchBase", zimbraGalInternalSearchBase);
        return attrs;
    }

    @ZAttr(id=358L)
    public void unsetGalInternalSearchBase() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalInternalSearchBase", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=358L)
    public Map<String, Object> unsetGalInternalSearchBase(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalInternalSearchBase", "");
        return attrs;
    }

    @ZAttr(id=153L)
    public String[] getGalLdapAttrMap() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraGalLdapAttrMap");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[23];
            stringArray2[0] = "co=workCountry";
            stringArray2[1] = "company=company";
            stringArray2[2] = "givenName,gn=firstName";
            stringArray2[3] = "sn=lastName";
            stringArray2[4] = "displayName,cn=fullName";
            stringArray2[5] = "initials=initials";
            stringArray2[6] = "description=notes";
            stringArray2[7] = "l=workCity";
            stringArray2[8] = "physicalDeliveryOfficeName=office";
            stringArray2[9] = "ou=department";
            stringArray2[10] = "street,streetAddress=workStreet";
            stringArray2[11] = "postalCode=workPostalCode";
            stringArray2[12] = "telephoneNumber=workPhone";
            stringArray2[13] = "st=workState";
            stringArray2[14] = "zimbraMailDeliveryAddress,zimbraMailAlias,mail=email,email2,email3,email4,email5,email6,email7,email8,email9,email10,email11,email12,email13,email14,email15,email16";
            stringArray2[15] = "title=jobTitle";
            stringArray2[16] = "whenChanged,modifyTimeStamp=modifyTimeStamp";
            stringArray2[17] = "whenCreated,createTimeStamp=createTimeStamp";
            stringArray2[18] = "zimbraId=zimbraId";
            stringArray2[19] = "objectClass=objectClass";
            stringArray2[20] = "zimbraMailForwardingAddress=zimbraMailForwardingAddress";
            stringArray2[21] = "zimbraCalResType=zimbraCalResType";
            stringArray = stringArray2;
            stringArray2[22] = "zimbraCalResLocationDisplayName=zimbraCalResLocationDisplayName";
        }
        return stringArray;
    }

    @ZAttr(id=153L)
    public void setGalLdapAttrMap(String[] zimbraGalLdapAttrMap) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraGalLdapAttrMap", zimbraGalLdapAttrMap);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=153L)
    public Map<String, Object> setGalLdapAttrMap(String[] zimbraGalLdapAttrMap, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalLdapAttrMap", zimbraGalLdapAttrMap);
        return attrs;
    }

    @ZAttr(id=153L)
    public void addGalLdapAttrMap(String zimbraGalLdapAttrMap) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraGalLdapAttrMap", zimbraGalLdapAttrMap);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=153L)
    public Map<String, Object> addGalLdapAttrMap(String zimbraGalLdapAttrMap, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraGalLdapAttrMap", zimbraGalLdapAttrMap);
        return attrs;
    }

    @ZAttr(id=153L)
    public void removeGalLdapAttrMap(String zimbraGalLdapAttrMap) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraGalLdapAttrMap", zimbraGalLdapAttrMap);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=153L)
    public Map<String, Object> removeGalLdapAttrMap(String zimbraGalLdapAttrMap, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraGalLdapAttrMap", zimbraGalLdapAttrMap);
        return attrs;
    }

    @ZAttr(id=153L)
    public void unsetGalLdapAttrMap() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalLdapAttrMap", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=153L)
    public Map<String, Object> unsetGalLdapAttrMap(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalLdapAttrMap", "");
        return attrs;
    }

    @ZAttr(id=52L)
    public String[] getGalLdapFilterDef() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraGalLdapFilterDef");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[12];
            stringArray2[0] = "zimbraAccounts:(&(|(displayName=*%s*)(cn=*%s*)(sn=*%s*)(gn=*%s*)(mail=*%s*)(zimbraMailDeliveryAddress=*%s*)(zimbraMailAlias=*%s*))(|(objectclass=zimbraAccount)(objectclass=zimbraDistributionList))(!(objectclass=zimbraCalendarResource)))";
            stringArray2[1] = "zimbraAccountAutoComplete:(&(|(displayName=%s*)(cn=%s*)(sn=%s*)(gn=%s*)(mail=%s*)(zimbraMailDeliveryAddress=%s*)(zimbraMailAlias=%s*))(|(objectclass=zimbraAccount)(objectclass=zimbraDistributionList))(!(objectclass=zimbraCalendarResource)))";
            stringArray2[2] = "zimbraAccountSync:(&(|(displayName=*%s*)(cn=*%s*)(sn=*%s*)(gn=*%s*)(mail=*%s*)(zimbraMailDeliveryAddress=*%s*)(zimbraMailAlias=*%s*))(|(objectclass=zimbraAccount)(objectclass=zimbraDistributionList))(!(objectclass=zimbraCalendarResource)))";
            stringArray2[3] = "zimbraResources:(&(|(displayName=*%s*)(cn=*%s*)(sn=*%s*)(gn=*%s*)(mail=*%s*)(zimbraMailDeliveryAddress=*%s*)(zimbraMailAlias=*%s*))(objectclass=zimbraCalendarResource))";
            stringArray2[4] = "zimbraResourceAutoComplete:(&(|(displayName=%s*)(cn=%s*)(sn=%s*)(gn=%s*)(mail=%s*)(zimbraMailDeliveryAddress=%s*)(zimbraMailAlias=%s*))(objectclass=zimbraCalendarResource))";
            stringArray2[5] = "zimbraResourceSync:(&(|(displayName=*%s*)(cn=*%s*)(sn=*%s*)(gn=*%s*)(mail=*%s*)(zimbraMailDeliveryAddress=*%s*)(zimbraMailAlias=*%s*))(objectclass=zimbraCalendarResource))";
            stringArray2[6] = "zimbraAutoComplete:(&(|(displayName=%s*)(cn=%s*)(sn=%s*)(gn=%s*)(mail=%s*)(zimbraMailDeliveryAddress=%s*)(zimbraMailAlias=%s*))(|(objectclass=zimbraAccount)(objectclass=zimbraDistributionList)))";
            stringArray2[7] = "zimbraSearch:(&(|(displayName=*%s*)(cn=*%s*)(sn=*%s*)(gn=*%s*)(mail=*%s*)(zimbraMailDeliveryAddress=*%s*)(zimbraMailAlias=*%s*))(|(objectclass=zimbraAccount)(objectclass=zimbraDistributionList)))";
            stringArray2[8] = "zimbraSync:(&(|(displayName=*)(cn=*)(sn=*)(gn=*)(mail=*)(zimbraMailDeliveryAddress=*)(zimbraMailAlias=*))(|(objectclass=zimbraAccount)(objectclass=zimbraDistributionList))(!(zimbraHideInGal=TRUE))(!(zimbraIsSystemResource=TRUE)))";
            stringArray2[9] = "ad:(&(|(displayName=*%s*)(cn=*%s*)(sn=*%s*)(givenName=*%s*)(mail=*%s*))(!(msExchHideFromAddressLists=TRUE))(mailnickname=*)(|(&(objectCategory=person)(objectClass=user)(!(homeMDB=*))(!(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=user)(|(homeMDB=*)(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=contact))(objectCategory=group)(objectCategory=publicFolder)(objectCategory=msExchDynamicDistributionList)))";
            stringArray2[10] = "adAutoComplete:(&(|(displayName=%s*)(cn=%s*)(sn=%s*)(givenName=%s*)(mail=%s*))(!(msExchHideFromAddressLists=TRUE))(mailnickname=*)(|(&(objectCategory=person)(objectClass=user)(!(homeMDB=*))(!(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=user)(|(homeMDB=*)(msExchHomeServerName=*)))(&(objectCategory=person)(objectClass=contact))(objectCategory=group)(objectCategory=publicFolder)(objectCategory=msExchDynamicDistributionList)))";
            stringArray = stringArray2;
            stringArray2[11] = "externalLdapAutoComplete:(|(cn=%s*)(sn=%s*)(gn=%s*)(mail=%s*))";
        }
        return stringArray;
    }

    @ZAttr(id=52L)
    public void setGalLdapFilterDef(String[] zimbraGalLdapFilterDef) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraGalLdapFilterDef", zimbraGalLdapFilterDef);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=52L)
    public Map<String, Object> setGalLdapFilterDef(String[] zimbraGalLdapFilterDef, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalLdapFilterDef", zimbraGalLdapFilterDef);
        return attrs;
    }

    @ZAttr(id=52L)
    public void addGalLdapFilterDef(String zimbraGalLdapFilterDef) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraGalLdapFilterDef", zimbraGalLdapFilterDef);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=52L)
    public Map<String, Object> addGalLdapFilterDef(String zimbraGalLdapFilterDef, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraGalLdapFilterDef", zimbraGalLdapFilterDef);
        return attrs;
    }

    @ZAttr(id=52L)
    public void removeGalLdapFilterDef(String zimbraGalLdapFilterDef) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraGalLdapFilterDef", zimbraGalLdapFilterDef);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=52L)
    public Map<String, Object> removeGalLdapFilterDef(String zimbraGalLdapFilterDef, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraGalLdapFilterDef", zimbraGalLdapFilterDef);
        return attrs;
    }

    @ZAttr(id=52L)
    public void unsetGalLdapFilterDef() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalLdapFilterDef", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=52L)
    public Map<String, Object> unsetGalLdapFilterDef(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalLdapFilterDef", "");
        return attrs;
    }

    @ZAttr(id=583L)
    public int getGalLdapPageSize() {
        return this.getIntAttr("zimbraGalLdapPageSize", 1000);
    }

    @ZAttr(id=583L)
    public void setGalLdapPageSize(int zimbraGalLdapPageSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalLdapPageSize", Integer.toString(zimbraGalLdapPageSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=583L)
    public Map<String, Object> setGalLdapPageSize(int zimbraGalLdapPageSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalLdapPageSize", Integer.toString(zimbraGalLdapPageSize));
        return attrs;
    }

    @ZAttr(id=583L)
    public void unsetGalLdapPageSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalLdapPageSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=583L)
    public Map<String, Object> unsetGalLdapPageSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalLdapPageSize", "");
        return attrs;
    }

    @ZAttr(id=53L)
    public int getGalMaxResults() {
        return this.getIntAttr("zimbraGalMaxResults", 100);
    }

    @ZAttr(id=53L)
    public void setGalMaxResults(int zimbraGalMaxResults) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalMaxResults", Integer.toString(zimbraGalMaxResults));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=53L)
    public Map<String, Object> setGalMaxResults(int zimbraGalMaxResults, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalMaxResults", Integer.toString(zimbraGalMaxResults));
        return attrs;
    }

    @ZAttr(id=53L)
    public void unsetGalMaxResults() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalMaxResults", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=53L)
    public Map<String, Object> unsetGalMaxResults(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalMaxResults", "");
        return attrs;
    }

    @ZAttr(id=598L)
    public String getGalSyncInternalSearchBase() {
        return this.getAttr("zimbraGalSyncInternalSearchBase", null);
    }

    @ZAttr(id=598L)
    public void setGalSyncInternalSearchBase(String zimbraGalSyncInternalSearchBase) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalSyncInternalSearchBase", zimbraGalSyncInternalSearchBase);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=598L)
    public Map<String, Object> setGalSyncInternalSearchBase(String zimbraGalSyncInternalSearchBase, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalSyncInternalSearchBase", zimbraGalSyncInternalSearchBase);
        return attrs;
    }

    @ZAttr(id=598L)
    public void unsetGalSyncInternalSearchBase() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalSyncInternalSearchBase", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=598L)
    public Map<String, Object> unsetGalSyncInternalSearchBase(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalSyncInternalSearchBase", "");
        return attrs;
    }

    @ZAttr(id=597L)
    public int getGalSyncLdapPageSize() {
        return this.getIntAttr("zimbraGalSyncLdapPageSize", 1000);
    }

    @ZAttr(id=597L)
    public void setGalSyncLdapPageSize(int zimbraGalSyncLdapPageSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalSyncLdapPageSize", Integer.toString(zimbraGalSyncLdapPageSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=597L)
    public Map<String, Object> setGalSyncLdapPageSize(int zimbraGalSyncLdapPageSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalSyncLdapPageSize", Integer.toString(zimbraGalSyncLdapPageSize));
        return attrs;
    }

    @ZAttr(id=597L)
    public void unsetGalSyncLdapPageSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalSyncLdapPageSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=597L)
    public Map<String, Object> unsetGalSyncLdapPageSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalSyncLdapPageSize", "");
        return attrs;
    }

    @ZAttr(id=1019L)
    public String getGalSyncTimestampFormat() {
        return this.getAttr("zimbraGalSyncTimestampFormat", "yyyyMMddHHmmss'Z'");
    }

    @ZAttr(id=1019L)
    public void setGalSyncTimestampFormat(String zimbraGalSyncTimestampFormat) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalSyncTimestampFormat", zimbraGalSyncTimestampFormat);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1019L)
    public Map<String, Object> setGalSyncTimestampFormat(String zimbraGalSyncTimestampFormat, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalSyncTimestampFormat", zimbraGalSyncTimestampFormat);
        return attrs;
    }

    @ZAttr(id=1019L)
    public void unsetGalSyncTimestampFormat() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraGalSyncTimestampFormat", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1019L)
    public Map<String, Object> unsetGalSyncTimestampFormat(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraGalSyncTimestampFormat", "");
        return attrs;
    }

    @ZAttr(id=674L)
    public String getHelpAdminURL() {
        return this.getAttr("zimbraHelpAdminURL", null);
    }

    @ZAttr(id=674L)
    public void setHelpAdminURL(String zimbraHelpAdminURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHelpAdminURL", zimbraHelpAdminURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=674L)
    public Map<String, Object> setHelpAdminURL(String zimbraHelpAdminURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHelpAdminURL", zimbraHelpAdminURL);
        return attrs;
    }

    @ZAttr(id=674L)
    public void unsetHelpAdminURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHelpAdminURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=674L)
    public Map<String, Object> unsetHelpAdminURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHelpAdminURL", "");
        return attrs;
    }

    @ZAttr(id=676L)
    public String getHelpAdvancedURL() {
        return this.getAttr("zimbraHelpAdvancedURL", null);
    }

    @ZAttr(id=676L)
    public void setHelpAdvancedURL(String zimbraHelpAdvancedURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHelpAdvancedURL", zimbraHelpAdvancedURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=676L)
    public Map<String, Object> setHelpAdvancedURL(String zimbraHelpAdvancedURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHelpAdvancedURL", zimbraHelpAdvancedURL);
        return attrs;
    }

    @ZAttr(id=676L)
    public void unsetHelpAdvancedURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHelpAdvancedURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=676L)
    public Map<String, Object> unsetHelpAdvancedURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHelpAdvancedURL", "");
        return attrs;
    }

    @ZAttr(id=675L)
    public String getHelpDelegatedURL() {
        return this.getAttr("zimbraHelpDelegatedURL", null);
    }

    @ZAttr(id=675L)
    public void setHelpDelegatedURL(String zimbraHelpDelegatedURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHelpDelegatedURL", zimbraHelpDelegatedURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=675L)
    public Map<String, Object> setHelpDelegatedURL(String zimbraHelpDelegatedURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHelpDelegatedURL", zimbraHelpDelegatedURL);
        return attrs;
    }

    @ZAttr(id=675L)
    public void unsetHelpDelegatedURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHelpDelegatedURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=675L)
    public Map<String, Object> unsetHelpDelegatedURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHelpDelegatedURL", "");
        return attrs;
    }

    @ZAttr(id=677L)
    public String getHelpStandardURL() {
        return this.getAttr("zimbraHelpStandardURL", null);
    }

    @ZAttr(id=677L)
    public void setHelpStandardURL(String zimbraHelpStandardURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHelpStandardURL", zimbraHelpStandardURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=677L)
    public Map<String, Object> setHelpStandardURL(String zimbraHelpStandardURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHelpStandardURL", zimbraHelpStandardURL);
        return attrs;
    }

    @ZAttr(id=677L)
    public void unsetHelpStandardURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHelpStandardURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=677L)
    public Map<String, Object> unsetHelpStandardURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHelpStandardURL", "");
        return attrs;
    }

    @ZAttr(id=8L)
    public long getHsmAge() {
        return this.getTimeInterval("zimbraHsmAge", 2592000000L);
    }

    @ZAttr(id=8L)
    public String getHsmAgeAsString() {
        return this.getAttr("zimbraHsmAge", "30d");
    }

    @ZAttr(id=8L)
    public void setHsmAge(String zimbraHsmAge) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHsmAge", zimbraHsmAge);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=8L)
    public Map<String, Object> setHsmAge(String zimbraHsmAge, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHsmAge", zimbraHsmAge);
        return attrs;
    }

    @ZAttr(id=8L)
    public void unsetHsmAge() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHsmAge", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=8L)
    public Map<String, Object> unsetHsmAge(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHsmAge", "");
        return attrs;
    }

    @ZAttr(id=1024L)
    public String[] getHsmPolicy() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraHsmPolicy");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "message,document:before:-30days";
        }
        return stringArray;
    }

    @ZAttr(id=1024L)
    public void setHsmPolicy(String[] zimbraHsmPolicy) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraHsmPolicy", zimbraHsmPolicy);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1024L)
    public Map<String, Object> setHsmPolicy(String[] zimbraHsmPolicy, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHsmPolicy", zimbraHsmPolicy);
        return attrs;
    }

    @ZAttr(id=1024L)
    public void addHsmPolicy(String zimbraHsmPolicy) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraHsmPolicy", zimbraHsmPolicy);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1024L)
    public Map<String, Object> addHsmPolicy(String zimbraHsmPolicy, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraHsmPolicy", zimbraHsmPolicy);
        return attrs;
    }

    @ZAttr(id=1024L)
    public void removeHsmPolicy(String zimbraHsmPolicy) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraHsmPolicy", zimbraHsmPolicy);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1024L)
    public Map<String, Object> removeHsmPolicy(String zimbraHsmPolicy, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraHsmPolicy", zimbraHsmPolicy);
        return attrs;
    }

    @ZAttr(id=1024L)
    public void unsetHsmPolicy() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHsmPolicy", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1024L)
    public Map<String, Object> unsetHsmPolicy(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHsmPolicy", "");
        return attrs;
    }

    @ZAttr(id=1043L)
    public boolean isHttpDebugHandlerEnabled() {
        return this.getBooleanAttr("zimbraHttpDebugHandlerEnabled", true);
    }

    @ZAttr(id=1043L)
    public void setHttpDebugHandlerEnabled(boolean zimbraHttpDebugHandlerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpDebugHandlerEnabled", zimbraHttpDebugHandlerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1043L)
    public Map<String, Object> setHttpDebugHandlerEnabled(boolean zimbraHttpDebugHandlerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpDebugHandlerEnabled", zimbraHttpDebugHandlerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1043L)
    public void unsetHttpDebugHandlerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpDebugHandlerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1043L)
    public Map<String, Object> unsetHttpDebugHandlerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpDebugHandlerEnabled", "");
        return attrs;
    }

    @ZAttr(id=518L)
    public int getHttpNumThreads() {
        return this.getIntAttr("zimbraHttpNumThreads", 250);
    }

    @ZAttr(id=518L)
    public void setHttpNumThreads(int zimbraHttpNumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpNumThreads", Integer.toString(zimbraHttpNumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=518L)
    public Map<String, Object> setHttpNumThreads(int zimbraHttpNumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpNumThreads", Integer.toString(zimbraHttpNumThreads));
        return attrs;
    }

    @ZAttr(id=518L)
    public void unsetHttpNumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpNumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=518L)
    public Map<String, Object> unsetHttpNumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpNumThreads", "");
        return attrs;
    }

    @ZAttr(id=388L)
    public String[] getHttpProxyURL() {
        return this.getMultiAttr("zimbraHttpProxyURL");
    }

    @ZAttr(id=388L)
    public void setHttpProxyURL(String[] zimbraHttpProxyURL) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraHttpProxyURL", zimbraHttpProxyURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=388L)
    public Map<String, Object> setHttpProxyURL(String[] zimbraHttpProxyURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpProxyURL", zimbraHttpProxyURL);
        return attrs;
    }

    @ZAttr(id=388L)
    public void addHttpProxyURL(String zimbraHttpProxyURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraHttpProxyURL", zimbraHttpProxyURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=388L)
    public Map<String, Object> addHttpProxyURL(String zimbraHttpProxyURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraHttpProxyURL", zimbraHttpProxyURL);
        return attrs;
    }

    @ZAttr(id=388L)
    public void removeHttpProxyURL(String zimbraHttpProxyURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraHttpProxyURL", zimbraHttpProxyURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=388L)
    public Map<String, Object> removeHttpProxyURL(String zimbraHttpProxyURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraHttpProxyURL", zimbraHttpProxyURL);
        return attrs;
    }

    @ZAttr(id=388L)
    public void unsetHttpProxyURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpProxyURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=388L)
    public Map<String, Object> unsetHttpProxyURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpProxyURL", "");
        return attrs;
    }

    @ZAttr(id=519L)
    public int getHttpSSLNumThreads() {
        return this.getIntAttr("zimbraHttpSSLNumThreads", 50);
    }

    @ZAttr(id=519L)
    public void setHttpSSLNumThreads(int zimbraHttpSSLNumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpSSLNumThreads", Integer.toString(zimbraHttpSSLNumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=519L)
    public Map<String, Object> setHttpSSLNumThreads(int zimbraHttpSSLNumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpSSLNumThreads", Integer.toString(zimbraHttpSSLNumThreads));
        return attrs;
    }

    @ZAttr(id=519L)
    public void unsetHttpSSLNumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraHttpSSLNumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=519L)
    public Map<String, Object> unsetHttpSSLNumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraHttpSSLNumThreads", "");
        return attrs;
    }

    @ZAttr(id=268L)
    public boolean isImapBindOnStartup() {
        return this.getBooleanAttr("zimbraImapBindOnStartup", true);
    }

    @ZAttr(id=268L)
    public void setImapBindOnStartup(boolean zimbraImapBindOnStartup) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapBindOnStartup", zimbraImapBindOnStartup ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=268L)
    public Map<String, Object> setImapBindOnStartup(boolean zimbraImapBindOnStartup, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindOnStartup", zimbraImapBindOnStartup ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=268L)
    public void unsetImapBindOnStartup() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapBindOnStartup", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=268L)
    public Map<String, Object> unsetImapBindOnStartup(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindOnStartup", "");
        return attrs;
    }

    @ZAttr(id=180L)
    public int getImapBindPort() {
        return this.getIntAttr("zimbraImapBindPort", 7143);
    }

    @ZAttr(id=180L)
    public String getImapBindPortAsString() {
        return this.getAttr("zimbraImapBindPort", "7143");
    }

    @ZAttr(id=180L)
    public void setImapBindPort(int zimbraImapBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapBindPort", Integer.toString(zimbraImapBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=180L)
    public Map<String, Object> setImapBindPort(int zimbraImapBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindPort", Integer.toString(zimbraImapBindPort));
        return attrs;
    }

    @ZAttr(id=180L)
    public void setImapBindPortAsString(String zimbraImapBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapBindPort", zimbraImapBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=180L)
    public Map<String, Object> setImapBindPortAsString(String zimbraImapBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindPort", zimbraImapBindPort);
        return attrs;
    }

    @ZAttr(id=180L)
    public void unsetImapBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=180L)
    public Map<String, Object> unsetImapBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapBindPort", "");
        return attrs;
    }

    @ZAttr(id=185L)
    public boolean isImapCleartextLoginEnabled() {
        return this.getBooleanAttr("zimbraImapCleartextLoginEnabled", false);
    }

    @ZAttr(id=185L)
    public void setImapCleartextLoginEnabled(boolean zimbraImapCleartextLoginEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapCleartextLoginEnabled", zimbraImapCleartextLoginEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=185L)
    public Map<String, Object> setImapCleartextLoginEnabled(boolean zimbraImapCleartextLoginEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapCleartextLoginEnabled", zimbraImapCleartextLoginEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=185L)
    public void unsetImapCleartextLoginEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapCleartextLoginEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=185L)
    public Map<String, Object> unsetImapCleartextLoginEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapCleartextLoginEnabled", "");
        return attrs;
    }

    @ZAttr(id=443L)
    public String[] getImapDisabledCapability() {
        return this.getMultiAttr("zimbraImapDisabledCapability");
    }

    @ZAttr(id=443L)
    public void setImapDisabledCapability(String[] zimbraImapDisabledCapability) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=443L)
    public Map<String, Object> setImapDisabledCapability(String[] zimbraImapDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        return attrs;
    }

    @ZAttr(id=443L)
    public void addImapDisabledCapability(String zimbraImapDisabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=443L)
    public Map<String, Object> addImapDisabledCapability(String zimbraImapDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        return attrs;
    }

    @ZAttr(id=443L)
    public void removeImapDisabledCapability(String zimbraImapDisabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=443L)
    public Map<String, Object> removeImapDisabledCapability(String zimbraImapDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraImapDisabledCapability", zimbraImapDisabledCapability);
        return attrs;
    }

    @ZAttr(id=443L)
    public void unsetImapDisabledCapability() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapDisabledCapability", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=443L)
    public Map<String, Object> unsetImapDisabledCapability(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapDisabledCapability", "");
        return attrs;
    }

    @ZAttr(id=693L)
    public boolean isImapExposeVersionOnBanner() {
        return this.getBooleanAttr("zimbraImapExposeVersionOnBanner", false);
    }

    @ZAttr(id=693L)
    public void setImapExposeVersionOnBanner(boolean zimbraImapExposeVersionOnBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapExposeVersionOnBanner", zimbraImapExposeVersionOnBanner ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=693L)
    public Map<String, Object> setImapExposeVersionOnBanner(boolean zimbraImapExposeVersionOnBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapExposeVersionOnBanner", zimbraImapExposeVersionOnBanner ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=693L)
    public void unsetImapExposeVersionOnBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapExposeVersionOnBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=693L)
    public Map<String, Object> unsetImapExposeVersionOnBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapExposeVersionOnBanner", "");
        return attrs;
    }

    @ZAttr(id=181L)
    public int getImapNumThreads() {
        return this.getIntAttr("zimbraImapNumThreads", 200);
    }

    @ZAttr(id=181L)
    public void setImapNumThreads(int zimbraImapNumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapNumThreads", Integer.toString(zimbraImapNumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=181L)
    public Map<String, Object> setImapNumThreads(int zimbraImapNumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapNumThreads", Integer.toString(zimbraImapNumThreads));
        return attrs;
    }

    @ZAttr(id=181L)
    public void unsetImapNumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapNumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=181L)
    public Map<String, Object> unsetImapNumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapNumThreads", "");
        return attrs;
    }

    @ZAttr(id=348L)
    public int getImapProxyBindPort() {
        return this.getIntAttr("zimbraImapProxyBindPort", 143);
    }

    @ZAttr(id=348L)
    public String getImapProxyBindPortAsString() {
        return this.getAttr("zimbraImapProxyBindPort", "143");
    }

    @ZAttr(id=348L)
    public void setImapProxyBindPort(int zimbraImapProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapProxyBindPort", Integer.toString(zimbraImapProxyBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=348L)
    public Map<String, Object> setImapProxyBindPort(int zimbraImapProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapProxyBindPort", Integer.toString(zimbraImapProxyBindPort));
        return attrs;
    }

    @ZAttr(id=348L)
    public void setImapProxyBindPortAsString(String zimbraImapProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapProxyBindPort", zimbraImapProxyBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=348L)
    public Map<String, Object> setImapProxyBindPortAsString(String zimbraImapProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapProxyBindPort", zimbraImapProxyBindPort);
        return attrs;
    }

    @ZAttr(id=348L)
    public void unsetImapProxyBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapProxyBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=348L)
    public Map<String, Object> unsetImapProxyBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapProxyBindPort", "");
        return attrs;
    }

    @ZAttr(id=269L)
    public boolean isImapSSLBindOnStartup() {
        return this.getBooleanAttr("zimbraImapSSLBindOnStartup", true);
    }

    @ZAttr(id=269L)
    public void setImapSSLBindOnStartup(boolean zimbraImapSSLBindOnStartup) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLBindOnStartup", zimbraImapSSLBindOnStartup ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=269L)
    public Map<String, Object> setImapSSLBindOnStartup(boolean zimbraImapSSLBindOnStartup, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindOnStartup", zimbraImapSSLBindOnStartup ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=269L)
    public void unsetImapSSLBindOnStartup() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLBindOnStartup", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=269L)
    public Map<String, Object> unsetImapSSLBindOnStartup(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindOnStartup", "");
        return attrs;
    }

    @ZAttr(id=183L)
    public int getImapSSLBindPort() {
        return this.getIntAttr("zimbraImapSSLBindPort", 7993);
    }

    @ZAttr(id=183L)
    public String getImapSSLBindPortAsString() {
        return this.getAttr("zimbraImapSSLBindPort", "7993");
    }

    @ZAttr(id=183L)
    public void setImapSSLBindPort(int zimbraImapSSLBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLBindPort", Integer.toString(zimbraImapSSLBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=183L)
    public Map<String, Object> setImapSSLBindPort(int zimbraImapSSLBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindPort", Integer.toString(zimbraImapSSLBindPort));
        return attrs;
    }

    @ZAttr(id=183L)
    public void setImapSSLBindPortAsString(String zimbraImapSSLBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLBindPort", zimbraImapSSLBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=183L)
    public Map<String, Object> setImapSSLBindPortAsString(String zimbraImapSSLBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindPort", zimbraImapSSLBindPort);
        return attrs;
    }

    @ZAttr(id=183L)
    public void unsetImapSSLBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=183L)
    public Map<String, Object> unsetImapSSLBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLBindPort", "");
        return attrs;
    }

    @ZAttr(id=444L)
    public String[] getImapSSLDisabledCapability() {
        return this.getMultiAttr("zimbraImapSSLDisabledCapability");
    }

    @ZAttr(id=444L)
    public void setImapSSLDisabledCapability(String[] zimbraImapSSLDisabledCapability) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=444L)
    public Map<String, Object> setImapSSLDisabledCapability(String[] zimbraImapSSLDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        return attrs;
    }

    @ZAttr(id=444L)
    public void addImapSSLDisabledCapability(String zimbraImapSSLDisabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=444L)
    public Map<String, Object> addImapSSLDisabledCapability(String zimbraImapSSLDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        return attrs;
    }

    @ZAttr(id=444L)
    public void removeImapSSLDisabledCapability(String zimbraImapSSLDisabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=444L)
    public Map<String, Object> removeImapSSLDisabledCapability(String zimbraImapSSLDisabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraImapSSLDisabledCapability", zimbraImapSSLDisabledCapability);
        return attrs;
    }

    @ZAttr(id=444L)
    public void unsetImapSSLDisabledCapability() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLDisabledCapability", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=444L)
    public Map<String, Object> unsetImapSSLDisabledCapability(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLDisabledCapability", "");
        return attrs;
    }

    @ZAttr(id=349L)
    public int getImapSSLProxyBindPort() {
        return this.getIntAttr("zimbraImapSSLProxyBindPort", 993);
    }

    @ZAttr(id=349L)
    public String getImapSSLProxyBindPortAsString() {
        return this.getAttr("zimbraImapSSLProxyBindPort", "993");
    }

    @ZAttr(id=349L)
    public void setImapSSLProxyBindPort(int zimbraImapSSLProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLProxyBindPort", Integer.toString(zimbraImapSSLProxyBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=349L)
    public Map<String, Object> setImapSSLProxyBindPort(int zimbraImapSSLProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLProxyBindPort", Integer.toString(zimbraImapSSLProxyBindPort));
        return attrs;
    }

    @ZAttr(id=349L)
    public void setImapSSLProxyBindPortAsString(String zimbraImapSSLProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLProxyBindPort", zimbraImapSSLProxyBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=349L)
    public Map<String, Object> setImapSSLProxyBindPortAsString(String zimbraImapSSLProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLProxyBindPort", zimbraImapSSLProxyBindPort);
        return attrs;
    }

    @ZAttr(id=349L)
    public void unsetImapSSLProxyBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLProxyBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=349L)
    public Map<String, Object> unsetImapSSLProxyBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLProxyBindPort", "");
        return attrs;
    }

    @ZAttr(id=184L)
    public boolean isImapSSLServerEnabled() {
        return this.getBooleanAttr("zimbraImapSSLServerEnabled", true);
    }

    @ZAttr(id=184L)
    public void setImapSSLServerEnabled(boolean zimbraImapSSLServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLServerEnabled", zimbraImapSSLServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=184L)
    public Map<String, Object> setImapSSLServerEnabled(boolean zimbraImapSSLServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLServerEnabled", zimbraImapSSLServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=184L)
    public void unsetImapSSLServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSSLServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=184L)
    public Map<String, Object> unsetImapSSLServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSSLServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=555L)
    public boolean isImapSaslGssapiEnabled() {
        return this.getBooleanAttr("zimbraImapSaslGssapiEnabled", false);
    }

    @ZAttr(id=555L)
    public void setImapSaslGssapiEnabled(boolean zimbraImapSaslGssapiEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSaslGssapiEnabled", zimbraImapSaslGssapiEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=555L)
    public Map<String, Object> setImapSaslGssapiEnabled(boolean zimbraImapSaslGssapiEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSaslGssapiEnabled", zimbraImapSaslGssapiEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=555L)
    public void unsetImapSaslGssapiEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapSaslGssapiEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=555L)
    public Map<String, Object> unsetImapSaslGssapiEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapSaslGssapiEnabled", "");
        return attrs;
    }

    @ZAttr(id=176L)
    public boolean isImapServerEnabled() {
        return this.getBooleanAttr("zimbraImapServerEnabled", true);
    }

    @ZAttr(id=176L)
    public void setImapServerEnabled(boolean zimbraImapServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapServerEnabled", zimbraImapServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=176L)
    public Map<String, Object> setImapServerEnabled(boolean zimbraImapServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapServerEnabled", zimbraImapServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=176L)
    public void unsetImapServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraImapServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=176L)
    public Map<String, Object> unsetImapServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraImapServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=368L)
    public String[] getInstalledSkin() {
        return this.getMultiAttr("zimbraInstalledSkin");
    }

    @ZAttr(id=368L)
    public void setInstalledSkin(String[] zimbraInstalledSkin) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraInstalledSkin", zimbraInstalledSkin);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=368L)
    public Map<String, Object> setInstalledSkin(String[] zimbraInstalledSkin, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraInstalledSkin", zimbraInstalledSkin);
        return attrs;
    }

    @ZAttr(id=368L)
    public void addInstalledSkin(String zimbraInstalledSkin) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraInstalledSkin", zimbraInstalledSkin);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=368L)
    public Map<String, Object> addInstalledSkin(String zimbraInstalledSkin, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraInstalledSkin", zimbraInstalledSkin);
        return attrs;
    }

    @ZAttr(id=368L)
    public void removeInstalledSkin(String zimbraInstalledSkin) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraInstalledSkin", zimbraInstalledSkin);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=368L)
    public Map<String, Object> removeInstalledSkin(String zimbraInstalledSkin, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraInstalledSkin", zimbraInstalledSkin);
        return attrs;
    }

    @ZAttr(id=368L)
    public void unsetInstalledSkin() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraInstalledSkin", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=368L)
    public Map<String, Object> unsetInstalledSkin(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraInstalledSkin", "");
        return attrs;
    }

    @ZAttr(id=114L)
    public long getLastLogonTimestampFrequency() {
        return this.getTimeInterval("zimbraLastLogonTimestampFrequency", 604800000L);
    }

    @ZAttr(id=114L)
    public String getLastLogonTimestampFrequencyAsString() {
        return this.getAttr("zimbraLastLogonTimestampFrequency", "7d");
    }

    @ZAttr(id=114L)
    public void setLastLogonTimestampFrequency(String zimbraLastLogonTimestampFrequency) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLastLogonTimestampFrequency", zimbraLastLogonTimestampFrequency);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=114L)
    public Map<String, Object> setLastLogonTimestampFrequency(String zimbraLastLogonTimestampFrequency, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLastLogonTimestampFrequency", zimbraLastLogonTimestampFrequency);
        return attrs;
    }

    @ZAttr(id=114L)
    public void unsetLastLogonTimestampFrequency() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLastLogonTimestampFrequency", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=114L)
    public Map<String, Object> unsetLastLogonTimestampFrequency(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLastLogonTimestampFrequency", "");
        return attrs;
    }

    @ZAttr(id=270L)
    public boolean isLmtpBindOnStartup() {
        return this.getBooleanAttr("zimbraLmtpBindOnStartup", false);
    }

    @ZAttr(id=270L)
    public void setLmtpBindOnStartup(boolean zimbraLmtpBindOnStartup) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpBindOnStartup", zimbraLmtpBindOnStartup ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=270L)
    public Map<String, Object> setLmtpBindOnStartup(boolean zimbraLmtpBindOnStartup, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindOnStartup", zimbraLmtpBindOnStartup ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=270L)
    public void unsetLmtpBindOnStartup() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpBindOnStartup", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=270L)
    public Map<String, Object> unsetLmtpBindOnStartup(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindOnStartup", "");
        return attrs;
    }

    @ZAttr(id=24L)
    public int getLmtpBindPort() {
        return this.getIntAttr("zimbraLmtpBindPort", 7025);
    }

    @ZAttr(id=24L)
    public String getLmtpBindPortAsString() {
        return this.getAttr("zimbraLmtpBindPort", "7025");
    }

    @ZAttr(id=24L)
    public void setLmtpBindPort(int zimbraLmtpBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpBindPort", Integer.toString(zimbraLmtpBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=24L)
    public Map<String, Object> setLmtpBindPort(int zimbraLmtpBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindPort", Integer.toString(zimbraLmtpBindPort));
        return attrs;
    }

    @ZAttr(id=24L)
    public void setLmtpBindPortAsString(String zimbraLmtpBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpBindPort", zimbraLmtpBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=24L)
    public Map<String, Object> setLmtpBindPortAsString(String zimbraLmtpBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindPort", zimbraLmtpBindPort);
        return attrs;
    }

    @ZAttr(id=24L)
    public void unsetLmtpBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=24L)
    public Map<String, Object> unsetLmtpBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpBindPort", "");
        return attrs;
    }

    @ZAttr(id=691L)
    public boolean isLmtpExposeVersionOnBanner() {
        return this.getBooleanAttr("zimbraLmtpExposeVersionOnBanner", false);
    }

    @ZAttr(id=691L)
    public void setLmtpExposeVersionOnBanner(boolean zimbraLmtpExposeVersionOnBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpExposeVersionOnBanner", zimbraLmtpExposeVersionOnBanner ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=691L)
    public Map<String, Object> setLmtpExposeVersionOnBanner(boolean zimbraLmtpExposeVersionOnBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpExposeVersionOnBanner", zimbraLmtpExposeVersionOnBanner ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=691L)
    public void unsetLmtpExposeVersionOnBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpExposeVersionOnBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=691L)
    public Map<String, Object> unsetLmtpExposeVersionOnBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpExposeVersionOnBanner", "");
        return attrs;
    }

    @ZAttr(id=26L)
    public int getLmtpNumThreads() {
        return this.getIntAttr("zimbraLmtpNumThreads", 20);
    }

    @ZAttr(id=26L)
    public void setLmtpNumThreads(int zimbraLmtpNumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpNumThreads", Integer.toString(zimbraLmtpNumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=26L)
    public Map<String, Object> setLmtpNumThreads(int zimbraLmtpNumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpNumThreads", Integer.toString(zimbraLmtpNumThreads));
        return attrs;
    }

    @ZAttr(id=26L)
    public void unsetLmtpNumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpNumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=26L)
    public Map<String, Object> unsetLmtpNumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpNumThreads", "");
        return attrs;
    }

    @ZAttr(id=657L)
    public boolean isLmtpPermanentFailureWhenOverQuota() {
        return this.getBooleanAttr("zimbraLmtpPermanentFailureWhenOverQuota", false);
    }

    @ZAttr(id=657L)
    public void setLmtpPermanentFailureWhenOverQuota(boolean zimbraLmtpPermanentFailureWhenOverQuota) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpPermanentFailureWhenOverQuota", zimbraLmtpPermanentFailureWhenOverQuota ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=657L)
    public Map<String, Object> setLmtpPermanentFailureWhenOverQuota(boolean zimbraLmtpPermanentFailureWhenOverQuota, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpPermanentFailureWhenOverQuota", zimbraLmtpPermanentFailureWhenOverQuota ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=657L)
    public void unsetLmtpPermanentFailureWhenOverQuota() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpPermanentFailureWhenOverQuota", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=657L)
    public Map<String, Object> unsetLmtpPermanentFailureWhenOverQuota(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpPermanentFailureWhenOverQuota", "");
        return attrs;
    }

    @ZAttr(id=630L)
    public boolean isLmtpServerEnabled() {
        return this.getBooleanAttr("zimbraLmtpServerEnabled", true);
    }

    @ZAttr(id=630L)
    public void setLmtpServerEnabled(boolean zimbraLmtpServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpServerEnabled", zimbraLmtpServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=630L)
    public Map<String, Object> setLmtpServerEnabled(boolean zimbraLmtpServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpServerEnabled", zimbraLmtpServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=630L)
    public void unsetLmtpServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLmtpServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=630L)
    public Map<String, Object> unsetLmtpServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLmtpServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=345L)
    public String getLocaleAsString() {
        return this.getAttr("zimbraLocale", null);
    }

    @ZAttr(id=345L)
    public void setLocale(String zimbraLocale) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLocale", zimbraLocale);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=345L)
    public Map<String, Object> setLocale(String zimbraLocale, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLocale", zimbraLocale);
        return attrs;
    }

    @ZAttr(id=345L)
    public void unsetLocale() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLocale", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=345L)
    public Map<String, Object> unsetLocale(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLocale", "");
        return attrs;
    }

    @ZAttr(id=250L)
    public String[] getLogHostname() {
        return this.getMultiAttr("zimbraLogHostname");
    }

    @ZAttr(id=250L)
    public void setLogHostname(String[] zimbraLogHostname) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraLogHostname", zimbraLogHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=250L)
    public Map<String, Object> setLogHostname(String[] zimbraLogHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLogHostname", zimbraLogHostname);
        return attrs;
    }

    @ZAttr(id=250L)
    public void addLogHostname(String zimbraLogHostname) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraLogHostname", zimbraLogHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=250L)
    public Map<String, Object> addLogHostname(String zimbraLogHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraLogHostname", zimbraLogHostname);
        return attrs;
    }

    @ZAttr(id=250L)
    public void removeLogHostname(String zimbraLogHostname) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraLogHostname", zimbraLogHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=250L)
    public Map<String, Object> removeLogHostname(String zimbraLogHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraLogHostname", zimbraLogHostname);
        return attrs;
    }

    @ZAttr(id=250L)
    public void unsetLogHostname() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLogHostname", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=250L)
    public Map<String, Object> unsetLogHostname(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLogHostname", "");
        return attrs;
    }

    @ZAttr(id=263L)
    public long getLogRawLifetime() {
        return this.getTimeInterval("zimbraLogRawLifetime", 2678400000L);
    }

    @ZAttr(id=263L)
    public String getLogRawLifetimeAsString() {
        return this.getAttr("zimbraLogRawLifetime", "31d");
    }

    @ZAttr(id=263L)
    public void setLogRawLifetime(String zimbraLogRawLifetime) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLogRawLifetime", zimbraLogRawLifetime);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=263L)
    public Map<String, Object> setLogRawLifetime(String zimbraLogRawLifetime, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLogRawLifetime", zimbraLogRawLifetime);
        return attrs;
    }

    @ZAttr(id=263L)
    public void unsetLogRawLifetime() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLogRawLifetime", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=263L)
    public Map<String, Object> unsetLogRawLifetime(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLogRawLifetime", "");
        return attrs;
    }

    @ZAttr(id=264L)
    public long getLogSummaryLifetime() {
        return this.getTimeInterval("zimbraLogSummaryLifetime", 63072000000L);
    }

    @ZAttr(id=264L)
    public String getLogSummaryLifetimeAsString() {
        return this.getAttr("zimbraLogSummaryLifetime", "730d");
    }

    @ZAttr(id=264L)
    public void setLogSummaryLifetime(String zimbraLogSummaryLifetime) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLogSummaryLifetime", zimbraLogSummaryLifetime);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=264L)
    public Map<String, Object> setLogSummaryLifetime(String zimbraLogSummaryLifetime, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLogSummaryLifetime", zimbraLogSummaryLifetime);
        return attrs;
    }

    @ZAttr(id=264L)
    public void unsetLogSummaryLifetime() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLogSummaryLifetime", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=264L)
    public Map<String, Object> unsetLogSummaryLifetime(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLogSummaryLifetime", "");
        return attrs;
    }

    @ZAttr(id=520L)
    public boolean isLogToSyslog() {
        return this.getBooleanAttr("zimbraLogToSyslog", false);
    }

    @ZAttr(id=520L)
    public void setLogToSyslog(boolean zimbraLogToSyslog) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLogToSyslog", zimbraLogToSyslog ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=520L)
    public Map<String, Object> setLogToSyslog(boolean zimbraLogToSyslog, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLogToSyslog", zimbraLogToSyslog ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=520L)
    public void unsetLogToSyslog() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLogToSyslog", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=520L)
    public Map<String, Object> unsetLogToSyslog(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLogToSyslog", "");
        return attrs;
    }

    @ZAttr(id=791L)
    public boolean isMailClearTextPasswordEnabled() {
        return this.getBooleanAttr("zimbraMailClearTextPasswordEnabled", true);
    }

    @ZAttr(id=791L)
    public void setMailClearTextPasswordEnabled(boolean zimbraMailClearTextPasswordEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailClearTextPasswordEnabled", zimbraMailClearTextPasswordEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=791L)
    public Map<String, Object> setMailClearTextPasswordEnabled(boolean zimbraMailClearTextPasswordEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailClearTextPasswordEnabled", zimbraMailClearTextPasswordEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=791L)
    public void unsetMailClearTextPasswordEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailClearTextPasswordEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=791L)
    public Map<String, Object> unsetMailClearTextPasswordEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailClearTextPasswordEnabled", "");
        return attrs;
    }

    @ZAttr(id=807L)
    public long getMailContentMaxSize() {
        return this.getLongAttr("zimbraMailContentMaxSize", 10240000L);
    }

    @ZAttr(id=807L)
    public void setMailContentMaxSize(long zimbraMailContentMaxSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailContentMaxSize", Long.toString(zimbraMailContentMaxSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=807L)
    public Map<String, Object> setMailContentMaxSize(long zimbraMailContentMaxSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailContentMaxSize", Long.toString(zimbraMailContentMaxSize));
        return attrs;
    }

    @ZAttr(id=807L)
    public void unsetMailContentMaxSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailContentMaxSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=807L)
    public Map<String, Object> unsetMailContentMaxSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailContentMaxSize", "");
        return attrs;
    }

    @ZAttr(id=565L)
    public int getMailDiskStreamingThreshold() {
        return this.getIntAttr("zimbraMailDiskStreamingThreshold", 0x100000);
    }

    @ZAttr(id=565L)
    public void setMailDiskStreamingThreshold(int zimbraMailDiskStreamingThreshold) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailDiskStreamingThreshold", Integer.toString(zimbraMailDiskStreamingThreshold));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=565L)
    public Map<String, Object> setMailDiskStreamingThreshold(int zimbraMailDiskStreamingThreshold, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailDiskStreamingThreshold", Integer.toString(zimbraMailDiskStreamingThreshold));
        return attrs;
    }

    @ZAttr(id=565L)
    public void unsetMailDiskStreamingThreshold() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailDiskStreamingThreshold", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=565L)
    public Map<String, Object> unsetMailDiskStreamingThreshold(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailDiskStreamingThreshold", "");
        return attrs;
    }

    @ZAttr(id=1035L)
    public int getMailFileDescriptorBufferSize() {
        return this.getIntAttr("zimbraMailFileDescriptorBufferSize", 4096);
    }

    @ZAttr(id=1035L)
    public void setMailFileDescriptorBufferSize(int zimbraMailFileDescriptorBufferSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailFileDescriptorBufferSize", Integer.toString(zimbraMailFileDescriptorBufferSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1035L)
    public Map<String, Object> setMailFileDescriptorBufferSize(int zimbraMailFileDescriptorBufferSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailFileDescriptorBufferSize", Integer.toString(zimbraMailFileDescriptorBufferSize));
        return attrs;
    }

    @ZAttr(id=1035L)
    public void unsetMailFileDescriptorBufferSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailFileDescriptorBufferSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1035L)
    public Map<String, Object> unsetMailFileDescriptorBufferSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailFileDescriptorBufferSize", "");
        return attrs;
    }

    @ZAttr(id=1034L)
    public int getMailFileDescriptorCacheSize() {
        return this.getIntAttr("zimbraMailFileDescriptorCacheSize", 1000);
    }

    @ZAttr(id=1034L)
    public void setMailFileDescriptorCacheSize(int zimbraMailFileDescriptorCacheSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailFileDescriptorCacheSize", Integer.toString(zimbraMailFileDescriptorCacheSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1034L)
    public Map<String, Object> setMailFileDescriptorCacheSize(int zimbraMailFileDescriptorCacheSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailFileDescriptorCacheSize", Integer.toString(zimbraMailFileDescriptorCacheSize));
        return attrs;
    }

    @ZAttr(id=1034L)
    public void unsetMailFileDescriptorCacheSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailFileDescriptorCacheSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1034L)
    public Map<String, Object> unsetMailFileDescriptorCacheSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailFileDescriptorCacheSize", "");
        return attrs;
    }

    @ZAttr(id=308L)
    public ZAttrProvisioning.MailMode getMailMode() {
        try {
            String v = this.getAttr("zimbraMailMode");
            return v == null ? null : ZAttrProvisioning.MailMode.fromString(v);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @ZAttr(id=308L)
    public String getMailModeAsString() {
        return this.getAttr("zimbraMailMode", null);
    }

    @ZAttr(id=308L)
    public void setMailMode(ZAttrProvisioning.MailMode zimbraMailMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailMode", zimbraMailMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=308L)
    public Map<String, Object> setMailMode(ZAttrProvisioning.MailMode zimbraMailMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailMode", zimbraMailMode.toString());
        return attrs;
    }

    @ZAttr(id=308L)
    public void setMailModeAsString(String zimbraMailMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailMode", zimbraMailMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=308L)
    public Map<String, Object> setMailModeAsString(String zimbraMailMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailMode", zimbraMailMode);
        return attrs;
    }

    @ZAttr(id=308L)
    public void unsetMailMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=308L)
    public Map<String, Object> unsetMailMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailMode", "");
        return attrs;
    }

    @ZAttr(id=154L)
    public int getMailPort() {
        return this.getIntAttr("zimbraMailPort", 80);
    }

    @ZAttr(id=154L)
    public String getMailPortAsString() {
        return this.getAttr("zimbraMailPort", "80");
    }

    @ZAttr(id=154L)
    public void setMailPort(int zimbraMailPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailPort", Integer.toString(zimbraMailPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=154L)
    public Map<String, Object> setMailPort(int zimbraMailPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailPort", Integer.toString(zimbraMailPort));
        return attrs;
    }

    @ZAttr(id=154L)
    public void setMailPortAsString(String zimbraMailPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailPort", zimbraMailPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=154L)
    public Map<String, Object> setMailPortAsString(String zimbraMailPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailPort", zimbraMailPort);
        return attrs;
    }

    @ZAttr(id=154L)
    public void unsetMailPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=154L)
    public Map<String, Object> unsetMailPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailPort", "");
        return attrs;
    }

    @ZAttr(id=626L)
    public int getMailProxyPort() {
        return this.getIntAttr("zimbraMailProxyPort", 0);
    }

    @ZAttr(id=626L)
    public String getMailProxyPortAsString() {
        return this.getAttr("zimbraMailProxyPort", "0");
    }

    @ZAttr(id=626L)
    public void setMailProxyPort(int zimbraMailProxyPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailProxyPort", Integer.toString(zimbraMailProxyPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=626L)
    public Map<String, Object> setMailProxyPort(int zimbraMailProxyPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailProxyPort", Integer.toString(zimbraMailProxyPort));
        return attrs;
    }

    @ZAttr(id=626L)
    public void setMailProxyPortAsString(String zimbraMailProxyPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailProxyPort", zimbraMailProxyPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=626L)
    public Map<String, Object> setMailProxyPortAsString(String zimbraMailProxyPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailProxyPort", zimbraMailProxyPort);
        return attrs;
    }

    @ZAttr(id=626L)
    public void unsetMailProxyPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailProxyPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=626L)
    public Map<String, Object> unsetMailProxyPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailProxyPort", "");
        return attrs;
    }

    @ZAttr(id=542L)
    public long getMailPurgeSleepInterval() {
        return this.getTimeInterval("zimbraMailPurgeSleepInterval", 60000L);
    }

    @ZAttr(id=542L)
    public String getMailPurgeSleepIntervalAsString() {
        return this.getAttr("zimbraMailPurgeSleepInterval", "1m");
    }

    @ZAttr(id=542L)
    public void setMailPurgeSleepInterval(String zimbraMailPurgeSleepInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailPurgeSleepInterval", zimbraMailPurgeSleepInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=542L)
    public Map<String, Object> setMailPurgeSleepInterval(String zimbraMailPurgeSleepInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailPurgeSleepInterval", zimbraMailPurgeSleepInterval);
        return attrs;
    }

    @ZAttr(id=542L)
    public void unsetMailPurgeSleepInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailPurgeSleepInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=542L)
    public Map<String, Object> unsetMailPurgeSleepInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailPurgeSleepInterval", "");
        return attrs;
    }

    @ZAttr(id=764L)
    public boolean isMailRedirectSetEnvelopeSender() {
        return this.getBooleanAttr("zimbraMailRedirectSetEnvelopeSender", true);
    }

    @ZAttr(id=764L)
    public void setMailRedirectSetEnvelopeSender(boolean zimbraMailRedirectSetEnvelopeSender) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailRedirectSetEnvelopeSender", zimbraMailRedirectSetEnvelopeSender ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=764L)
    public Map<String, Object> setMailRedirectSetEnvelopeSender(boolean zimbraMailRedirectSetEnvelopeSender, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailRedirectSetEnvelopeSender", zimbraMailRedirectSetEnvelopeSender ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=764L)
    public void unsetMailRedirectSetEnvelopeSender() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailRedirectSetEnvelopeSender", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=764L)
    public Map<String, Object> unsetMailRedirectSetEnvelopeSender(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailRedirectSetEnvelopeSender", "");
        return attrs;
    }

    @ZAttr(id=613L)
    public ZAttrProvisioning.MailReferMode getMailReferMode() {
        try {
            String v = this.getAttr("zimbraMailReferMode");
            return v == null ? ZAttrProvisioning.MailReferMode.wronghost : ZAttrProvisioning.MailReferMode.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.MailReferMode.wronghost;
        }
    }

    @ZAttr(id=613L)
    public String getMailReferModeAsString() {
        return this.getAttr("zimbraMailReferMode", "wronghost");
    }

    @ZAttr(id=613L)
    public void setMailReferMode(ZAttrProvisioning.MailReferMode zimbraMailReferMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailReferMode", zimbraMailReferMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=613L)
    public Map<String, Object> setMailReferMode(ZAttrProvisioning.MailReferMode zimbraMailReferMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailReferMode", zimbraMailReferMode.toString());
        return attrs;
    }

    @ZAttr(id=613L)
    public void setMailReferModeAsString(String zimbraMailReferMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailReferMode", zimbraMailReferMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=613L)
    public Map<String, Object> setMailReferModeAsString(String zimbraMailReferMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailReferMode", zimbraMailReferMode);
        return attrs;
    }

    @ZAttr(id=613L)
    public void unsetMailReferMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailReferMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=613L)
    public Map<String, Object> unsetMailReferMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailReferMode", "");
        return attrs;
    }

    @ZAttr(id=166L)
    public int getMailSSLPort() {
        return this.getIntAttr("zimbraMailSSLPort", 0);
    }

    @ZAttr(id=166L)
    public String getMailSSLPortAsString() {
        return this.getAttr("zimbraMailSSLPort", "0");
    }

    @ZAttr(id=166L)
    public void setMailSSLPort(int zimbraMailSSLPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLPort", Integer.toString(zimbraMailSSLPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=166L)
    public Map<String, Object> setMailSSLPort(int zimbraMailSSLPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLPort", Integer.toString(zimbraMailSSLPort));
        return attrs;
    }

    @ZAttr(id=166L)
    public void setMailSSLPortAsString(String zimbraMailSSLPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLPort", zimbraMailSSLPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=166L)
    public Map<String, Object> setMailSSLPortAsString(String zimbraMailSSLPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLPort", zimbraMailSSLPort);
        return attrs;
    }

    @ZAttr(id=166L)
    public void unsetMailSSLPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=166L)
    public Map<String, Object> unsetMailSSLPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLPort", "");
        return attrs;
    }

    @ZAttr(id=627L)
    public int getMailSSLProxyPort() {
        return this.getIntAttr("zimbraMailSSLProxyPort", 0);
    }

    @ZAttr(id=627L)
    public String getMailSSLProxyPortAsString() {
        return this.getAttr("zimbraMailSSLProxyPort", "0");
    }

    @ZAttr(id=627L)
    public void setMailSSLProxyPort(int zimbraMailSSLProxyPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLProxyPort", Integer.toString(zimbraMailSSLProxyPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=627L)
    public Map<String, Object> setMailSSLProxyPort(int zimbraMailSSLProxyPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLProxyPort", Integer.toString(zimbraMailSSLProxyPort));
        return attrs;
    }

    @ZAttr(id=627L)
    public void setMailSSLProxyPortAsString(String zimbraMailSSLProxyPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLProxyPort", zimbraMailSSLProxyPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=627L)
    public Map<String, Object> setMailSSLProxyPortAsString(String zimbraMailSSLProxyPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLProxyPort", zimbraMailSSLProxyPort);
        return attrs;
    }

    @ZAttr(id=627L)
    public void unsetMailSSLProxyPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailSSLProxyPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=627L)
    public Map<String, Object> unsetMailSSLProxyPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailSSLProxyPort", "");
        return attrs;
    }

    @ZAttr(id=1025L)
    public String[] getMailTrustedIP() {
        return this.getMultiAttr("zimbraMailTrustedIP");
    }

    @ZAttr(id=1025L)
    public void setMailTrustedIP(String[] zimbraMailTrustedIP) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMailTrustedIP", zimbraMailTrustedIP);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1025L)
    public Map<String, Object> setMailTrustedIP(String[] zimbraMailTrustedIP, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailTrustedIP", zimbraMailTrustedIP);
        return attrs;
    }

    @ZAttr(id=1025L)
    public void addMailTrustedIP(String zimbraMailTrustedIP) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMailTrustedIP", zimbraMailTrustedIP);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1025L)
    public Map<String, Object> addMailTrustedIP(String zimbraMailTrustedIP, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMailTrustedIP", zimbraMailTrustedIP);
        return attrs;
    }

    @ZAttr(id=1025L)
    public void removeMailTrustedIP(String zimbraMailTrustedIP) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMailTrustedIP", zimbraMailTrustedIP);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1025L)
    public Map<String, Object> removeMailTrustedIP(String zimbraMailTrustedIP, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMailTrustedIP", zimbraMailTrustedIP);
        return attrs;
    }

    @ZAttr(id=1025L)
    public void unsetMailTrustedIP() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailTrustedIP", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1025L)
    public Map<String, Object> unsetMailTrustedIP(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailTrustedIP", "");
        return attrs;
    }

    @ZAttr(id=340L)
    public String getMailURL() {
        return this.getAttr("zimbraMailURL", "/zimbra");
    }

    @ZAttr(id=340L)
    public void setMailURL(String zimbraMailURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailURL", zimbraMailURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=340L)
    public Map<String, Object> setMailURL(String zimbraMailURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailURL", zimbraMailURL);
        return attrs;
    }

    @ZAttr(id=340L)
    public void unsetMailURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=340L)
    public Map<String, Object> unsetMailURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailURL", "");
        return attrs;
    }

    @ZAttr(id=825L)
    public long getMailUncompressedCacheMaxBytes() {
        return this.getLongAttr("zimbraMailUncompressedCacheMaxBytes", 0x40000000L);
    }

    @ZAttr(id=825L)
    public void setMailUncompressedCacheMaxBytes(long zimbraMailUncompressedCacheMaxBytes) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUncompressedCacheMaxBytes", Long.toString(zimbraMailUncompressedCacheMaxBytes));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=825L)
    public Map<String, Object> setMailUncompressedCacheMaxBytes(long zimbraMailUncompressedCacheMaxBytes, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUncompressedCacheMaxBytes", Long.toString(zimbraMailUncompressedCacheMaxBytes));
        return attrs;
    }

    @ZAttr(id=825L)
    public void unsetMailUncompressedCacheMaxBytes() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUncompressedCacheMaxBytes", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=825L)
    public Map<String, Object> unsetMailUncompressedCacheMaxBytes(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUncompressedCacheMaxBytes", "");
        return attrs;
    }

    @ZAttr(id=824L)
    public int getMailUncompressedCacheMaxFiles() {
        return this.getIntAttr("zimbraMailUncompressedCacheMaxFiles", 5000);
    }

    @ZAttr(id=824L)
    public void setMailUncompressedCacheMaxFiles(int zimbraMailUncompressedCacheMaxFiles) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUncompressedCacheMaxFiles", Integer.toString(zimbraMailUncompressedCacheMaxFiles));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=824L)
    public Map<String, Object> setMailUncompressedCacheMaxFiles(int zimbraMailUncompressedCacheMaxFiles, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUncompressedCacheMaxFiles", Integer.toString(zimbraMailUncompressedCacheMaxFiles));
        return attrs;
    }

    @ZAttr(id=824L)
    public void unsetMailUncompressedCacheMaxFiles() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUncompressedCacheMaxFiles", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=824L)
    public Map<String, Object> unsetMailUncompressedCacheMaxFiles(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUncompressedCacheMaxFiles", "");
        return attrs;
    }

    @ZAttr(id=1002L)
    public boolean isMailUseDirectBuffers() {
        return this.getBooleanAttr("zimbraMailUseDirectBuffers", false);
    }

    @ZAttr(id=1002L)
    public void setMailUseDirectBuffers(boolean zimbraMailUseDirectBuffers) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUseDirectBuffers", zimbraMailUseDirectBuffers ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1002L)
    public Map<String, Object> setMailUseDirectBuffers(boolean zimbraMailUseDirectBuffers, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUseDirectBuffers", zimbraMailUseDirectBuffers ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1002L)
    public void unsetMailUseDirectBuffers() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailUseDirectBuffers", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1002L)
    public Map<String, Object> unsetMailUseDirectBuffers(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailUseDirectBuffers", "");
        return attrs;
    }

    @ZAttr(id=1007L)
    public boolean isMailboxMoveSkipBlobs() {
        return this.getBooleanAttr("zimbraMailboxMoveSkipBlobs", false);
    }

    @ZAttr(id=1007L)
    public void setMailboxMoveSkipBlobs(boolean zimbraMailboxMoveSkipBlobs) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipBlobs", zimbraMailboxMoveSkipBlobs ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1007L)
    public Map<String, Object> setMailboxMoveSkipBlobs(boolean zimbraMailboxMoveSkipBlobs, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipBlobs", zimbraMailboxMoveSkipBlobs ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1007L)
    public void unsetMailboxMoveSkipBlobs() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipBlobs", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1007L)
    public Map<String, Object> unsetMailboxMoveSkipBlobs(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipBlobs", "");
        return attrs;
    }

    @ZAttr(id=1008L)
    public boolean isMailboxMoveSkipHsmBlobs() {
        return this.getBooleanAttr("zimbraMailboxMoveSkipHsmBlobs", false);
    }

    @ZAttr(id=1008L)
    public void setMailboxMoveSkipHsmBlobs(boolean zimbraMailboxMoveSkipHsmBlobs) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipHsmBlobs", zimbraMailboxMoveSkipHsmBlobs ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1008L)
    public Map<String, Object> setMailboxMoveSkipHsmBlobs(boolean zimbraMailboxMoveSkipHsmBlobs, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipHsmBlobs", zimbraMailboxMoveSkipHsmBlobs ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1008L)
    public void unsetMailboxMoveSkipHsmBlobs() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipHsmBlobs", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1008L)
    public Map<String, Object> unsetMailboxMoveSkipHsmBlobs(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipHsmBlobs", "");
        return attrs;
    }

    @ZAttr(id=1006L)
    public boolean isMailboxMoveSkipSearchIndex() {
        return this.getBooleanAttr("zimbraMailboxMoveSkipSearchIndex", false);
    }

    @ZAttr(id=1006L)
    public void setMailboxMoveSkipSearchIndex(boolean zimbraMailboxMoveSkipSearchIndex) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipSearchIndex", zimbraMailboxMoveSkipSearchIndex ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1006L)
    public Map<String, Object> setMailboxMoveSkipSearchIndex(boolean zimbraMailboxMoveSkipSearchIndex, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipSearchIndex", zimbraMailboxMoveSkipSearchIndex ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1006L)
    public void unsetMailboxMoveSkipSearchIndex() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMailboxMoveSkipSearchIndex", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1006L)
    public Map<String, Object> unsetMailboxMoveSkipSearchIndex(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMailboxMoveSkipSearchIndex", "");
        return attrs;
    }

    @ZAttr(id=580L)
    public int getMemcachedBindPort() {
        return this.getIntAttr("zimbraMemcachedBindPort", 11211);
    }

    @ZAttr(id=580L)
    public String getMemcachedBindPortAsString() {
        return this.getAttr("zimbraMemcachedBindPort", "11211");
    }

    @ZAttr(id=580L)
    public void setMemcachedBindPort(int zimbraMemcachedBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedBindPort", Integer.toString(zimbraMemcachedBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=580L)
    public Map<String, Object> setMemcachedBindPort(int zimbraMemcachedBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedBindPort", Integer.toString(zimbraMemcachedBindPort));
        return attrs;
    }

    @ZAttr(id=580L)
    public void setMemcachedBindPortAsString(String zimbraMemcachedBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedBindPort", zimbraMemcachedBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=580L)
    public Map<String, Object> setMemcachedBindPortAsString(String zimbraMemcachedBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedBindPort", zimbraMemcachedBindPort);
        return attrs;
    }

    @ZAttr(id=580L)
    public void unsetMemcachedBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=580L)
    public Map<String, Object> unsetMemcachedBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedBindPort", "");
        return attrs;
    }

    @ZAttr(id=1015L)
    public boolean isMemcachedClientBinaryProtocolEnabled() {
        return this.getBooleanAttr("zimbraMemcachedClientBinaryProtocolEnabled", false);
    }

    @ZAttr(id=1015L)
    public void setMemcachedClientBinaryProtocolEnabled(boolean zimbraMemcachedClientBinaryProtocolEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientBinaryProtocolEnabled", zimbraMemcachedClientBinaryProtocolEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1015L)
    public Map<String, Object> setMemcachedClientBinaryProtocolEnabled(boolean zimbraMemcachedClientBinaryProtocolEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientBinaryProtocolEnabled", zimbraMemcachedClientBinaryProtocolEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1015L)
    public void unsetMemcachedClientBinaryProtocolEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientBinaryProtocolEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1015L)
    public Map<String, Object> unsetMemcachedClientBinaryProtocolEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientBinaryProtocolEnabled", "");
        return attrs;
    }

    @ZAttr(id=1017L)
    public int getMemcachedClientExpirySeconds() {
        return this.getIntAttr("zimbraMemcachedClientExpirySeconds", 86400);
    }

    @ZAttr(id=1017L)
    public void setMemcachedClientExpirySeconds(int zimbraMemcachedClientExpirySeconds) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientExpirySeconds", Integer.toString(zimbraMemcachedClientExpirySeconds));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1017L)
    public Map<String, Object> setMemcachedClientExpirySeconds(int zimbraMemcachedClientExpirySeconds, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientExpirySeconds", Integer.toString(zimbraMemcachedClientExpirySeconds));
        return attrs;
    }

    @ZAttr(id=1017L)
    public void unsetMemcachedClientExpirySeconds() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientExpirySeconds", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1017L)
    public Map<String, Object> unsetMemcachedClientExpirySeconds(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientExpirySeconds", "");
        return attrs;
    }

    @ZAttr(id=1016L)
    public String getMemcachedClientHashAlgorithm() {
        return this.getAttr("zimbraMemcachedClientHashAlgorithm", "KETAMA_HASH");
    }

    @ZAttr(id=1016L)
    public void setMemcachedClientHashAlgorithm(String zimbraMemcachedClientHashAlgorithm) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientHashAlgorithm", zimbraMemcachedClientHashAlgorithm);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1016L)
    public Map<String, Object> setMemcachedClientHashAlgorithm(String zimbraMemcachedClientHashAlgorithm, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientHashAlgorithm", zimbraMemcachedClientHashAlgorithm);
        return attrs;
    }

    @ZAttr(id=1016L)
    public void unsetMemcachedClientHashAlgorithm() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientHashAlgorithm", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1016L)
    public Map<String, Object> unsetMemcachedClientHashAlgorithm(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientHashAlgorithm", "");
        return attrs;
    }

    @ZAttr(id=1014L)
    public String[] getMemcachedClientServerList() {
        return this.getMultiAttr("zimbraMemcachedClientServerList");
    }

    @ZAttr(id=1014L)
    public void setMemcachedClientServerList(String[] zimbraMemcachedClientServerList) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1014L)
    public Map<String, Object> setMemcachedClientServerList(String[] zimbraMemcachedClientServerList, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        return attrs;
    }

    @ZAttr(id=1014L)
    public void addMemcachedClientServerList(String zimbraMemcachedClientServerList) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1014L)
    public Map<String, Object> addMemcachedClientServerList(String zimbraMemcachedClientServerList, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        return attrs;
    }

    @ZAttr(id=1014L)
    public void removeMemcachedClientServerList(String zimbraMemcachedClientServerList) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1014L)
    public Map<String, Object> removeMemcachedClientServerList(String zimbraMemcachedClientServerList, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMemcachedClientServerList", zimbraMemcachedClientServerList);
        return attrs;
    }

    @ZAttr(id=1014L)
    public void unsetMemcachedClientServerList() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientServerList", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1014L)
    public Map<String, Object> unsetMemcachedClientServerList(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientServerList", "");
        return attrs;
    }

    @ZAttr(id=1018L)
    public int getMemcachedClientTimeoutMillis() {
        return this.getIntAttr("zimbraMemcachedClientTimeoutMillis", 10000);
    }

    @ZAttr(id=1018L)
    public void setMemcachedClientTimeoutMillis(int zimbraMemcachedClientTimeoutMillis) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientTimeoutMillis", Integer.toString(zimbraMemcachedClientTimeoutMillis));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1018L)
    public Map<String, Object> setMemcachedClientTimeoutMillis(int zimbraMemcachedClientTimeoutMillis, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientTimeoutMillis", Integer.toString(zimbraMemcachedClientTimeoutMillis));
        return attrs;
    }

    @ZAttr(id=1018L)
    public void unsetMemcachedClientTimeoutMillis() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMemcachedClientTimeoutMillis", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1018L)
    public Map<String, Object> unsetMemcachedClientTimeoutMillis(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMemcachedClientTimeoutMillis", "");
        return attrs;
    }

    @ZAttr(id=297L)
    public int getMessageCacheSize() {
        return this.getIntAttr("zimbraMessageCacheSize", 2000);
    }

    @ZAttr(id=297L)
    public void setMessageCacheSize(int zimbraMessageCacheSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMessageCacheSize", Integer.toString(zimbraMessageCacheSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=297L)
    public Map<String, Object> setMessageCacheSize(int zimbraMessageCacheSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMessageCacheSize", Integer.toString(zimbraMessageCacheSize));
        return attrs;
    }

    @ZAttr(id=297L)
    public void unsetMessageCacheSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMessageCacheSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=297L)
    public Map<String, Object> unsetMessageCacheSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMessageCacheSize", "");
        return attrs;
    }

    @ZAttr(id=334L)
    public int getMessageIdDedupeCacheSize() {
        return this.getIntAttr("zimbraMessageIdDedupeCacheSize", 3000);
    }

    @ZAttr(id=334L)
    public void setMessageIdDedupeCacheSize(int zimbraMessageIdDedupeCacheSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMessageIdDedupeCacheSize", Integer.toString(zimbraMessageIdDedupeCacheSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=334L)
    public Map<String, Object> setMessageIdDedupeCacheSize(int zimbraMessageIdDedupeCacheSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMessageIdDedupeCacheSize", Integer.toString(zimbraMessageIdDedupeCacheSize));
        return attrs;
    }

    @ZAttr(id=334L)
    public void unsetMessageIdDedupeCacheSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMessageIdDedupeCacheSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=334L)
    public Map<String, Object> unsetMessageIdDedupeCacheSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMessageIdDedupeCacheSize", "");
        return attrs;
    }

    @ZAttr(id=612L)
    public String getMtaAntiSpamLockMethod() {
        return this.getAttr("zimbraMtaAntiSpamLockMethod", "flock");
    }

    @ZAttr(id=612L)
    public void setMtaAntiSpamLockMethod(String zimbraMtaAntiSpamLockMethod) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAntiSpamLockMethod", zimbraMtaAntiSpamLockMethod);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=612L)
    public Map<String, Object> setMtaAntiSpamLockMethod(String zimbraMtaAntiSpamLockMethod, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAntiSpamLockMethod", zimbraMtaAntiSpamLockMethod);
        return attrs;
    }

    @ZAttr(id=612L)
    public void unsetMtaAntiSpamLockMethod() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAntiSpamLockMethod", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=612L)
    public Map<String, Object> unsetMtaAntiSpamLockMethod(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAntiSpamLockMethod", "");
        return attrs;
    }

    @ZAttr(id=194L)
    public boolean isMtaAuthEnabled() {
        return this.getBooleanAttr("zimbraMtaAuthEnabled", true);
    }

    @ZAttr(id=194L)
    public void setMtaAuthEnabled(boolean zimbraMtaAuthEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthEnabled", zimbraMtaAuthEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=194L)
    public Map<String, Object> setMtaAuthEnabled(boolean zimbraMtaAuthEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthEnabled", zimbraMtaAuthEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=194L)
    public void unsetMtaAuthEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=194L)
    public Map<String, Object> unsetMtaAuthEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthEnabled", "");
        return attrs;
    }

    @ZAttr(id=309L)
    public String[] getMtaAuthHost() {
        return this.getMultiAttr("zimbraMtaAuthHost");
    }

    @ZAttr(id=309L)
    public void setMtaAuthHost(String[] zimbraMtaAuthHost) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaAuthHost", zimbraMtaAuthHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=309L)
    public Map<String, Object> setMtaAuthHost(String[] zimbraMtaAuthHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthHost", zimbraMtaAuthHost);
        return attrs;
    }

    @ZAttr(id=309L)
    public void addMtaAuthHost(String zimbraMtaAuthHost) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaAuthHost", zimbraMtaAuthHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=309L)
    public Map<String, Object> addMtaAuthHost(String zimbraMtaAuthHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaAuthHost", zimbraMtaAuthHost);
        return attrs;
    }

    @ZAttr(id=309L)
    public void removeMtaAuthHost(String zimbraMtaAuthHost) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaAuthHost", zimbraMtaAuthHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=309L)
    public Map<String, Object> removeMtaAuthHost(String zimbraMtaAuthHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaAuthHost", zimbraMtaAuthHost);
        return attrs;
    }

    @ZAttr(id=309L)
    public void unsetMtaAuthHost() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthHost", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=309L)
    public Map<String, Object> unsetMtaAuthHost(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthHost", "");
        return attrs;
    }

    @ZAttr(id=505L)
    public boolean isMtaAuthTarget() {
        return this.getBooleanAttr("zimbraMtaAuthTarget", false);
    }

    @ZAttr(id=505L)
    public void setMtaAuthTarget(boolean zimbraMtaAuthTarget) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthTarget", zimbraMtaAuthTarget ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=505L)
    public Map<String, Object> setMtaAuthTarget(boolean zimbraMtaAuthTarget, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthTarget", zimbraMtaAuthTarget ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=505L)
    public void unsetMtaAuthTarget() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthTarget", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=505L)
    public Map<String, Object> unsetMtaAuthTarget(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthTarget", "");
        return attrs;
    }

    @ZAttr(id=310L)
    public String[] getMtaAuthURL() {
        return this.getMultiAttr("zimbraMtaAuthURL");
    }

    @ZAttr(id=310L)
    public void setMtaAuthURL(String[] zimbraMtaAuthURL) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaAuthURL", zimbraMtaAuthURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=310L)
    public Map<String, Object> setMtaAuthURL(String[] zimbraMtaAuthURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthURL", zimbraMtaAuthURL);
        return attrs;
    }

    @ZAttr(id=310L)
    public void addMtaAuthURL(String zimbraMtaAuthURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaAuthURL", zimbraMtaAuthURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=310L)
    public Map<String, Object> addMtaAuthURL(String zimbraMtaAuthURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaAuthURL", zimbraMtaAuthURL);
        return attrs;
    }

    @ZAttr(id=310L)
    public void removeMtaAuthURL(String zimbraMtaAuthURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaAuthURL", zimbraMtaAuthURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=310L)
    public Map<String, Object> removeMtaAuthURL(String zimbraMtaAuthURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaAuthURL", zimbraMtaAuthURL);
        return attrs;
    }

    @ZAttr(id=310L)
    public void unsetMtaAuthURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaAuthURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=310L)
    public Map<String, Object> unsetMtaAuthURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaAuthURL", "");
        return attrs;
    }

    @ZAttr(id=195L)
    public String[] getMtaBlockedExtension() {
        return this.getMultiAttr("zimbraMtaBlockedExtension");
    }

    @ZAttr(id=195L)
    public void setMtaBlockedExtension(String[] zimbraMtaBlockedExtension) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaBlockedExtension", zimbraMtaBlockedExtension);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=195L)
    public Map<String, Object> setMtaBlockedExtension(String[] zimbraMtaBlockedExtension, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaBlockedExtension", zimbraMtaBlockedExtension);
        return attrs;
    }

    @ZAttr(id=195L)
    public void addMtaBlockedExtension(String zimbraMtaBlockedExtension) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaBlockedExtension", zimbraMtaBlockedExtension);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=195L)
    public Map<String, Object> addMtaBlockedExtension(String zimbraMtaBlockedExtension, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaBlockedExtension", zimbraMtaBlockedExtension);
        return attrs;
    }

    @ZAttr(id=195L)
    public void removeMtaBlockedExtension(String zimbraMtaBlockedExtension) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaBlockedExtension", zimbraMtaBlockedExtension);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=195L)
    public Map<String, Object> removeMtaBlockedExtension(String zimbraMtaBlockedExtension, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaBlockedExtension", zimbraMtaBlockedExtension);
        return attrs;
    }

    @ZAttr(id=195L)
    public void unsetMtaBlockedExtension() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaBlockedExtension", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=195L)
    public Map<String, Object> unsetMtaBlockedExtension(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaBlockedExtension", "");
        return attrs;
    }

    @ZAttr(id=1031L)
    public boolean isMtaBlockedExtensionWarnAdmin() {
        return this.getBooleanAttr("zimbraMtaBlockedExtensionWarnAdmin", true);
    }

    @ZAttr(id=1031L)
    public void setMtaBlockedExtensionWarnAdmin(boolean zimbraMtaBlockedExtensionWarnAdmin) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaBlockedExtensionWarnAdmin", zimbraMtaBlockedExtensionWarnAdmin ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1031L)
    public Map<String, Object> setMtaBlockedExtensionWarnAdmin(boolean zimbraMtaBlockedExtensionWarnAdmin, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaBlockedExtensionWarnAdmin", zimbraMtaBlockedExtensionWarnAdmin ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1031L)
    public void unsetMtaBlockedExtensionWarnAdmin() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaBlockedExtensionWarnAdmin", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1031L)
    public Map<String, Object> unsetMtaBlockedExtensionWarnAdmin(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaBlockedExtensionWarnAdmin", "");
        return attrs;
    }

    @ZAttr(id=1032L)
    public boolean isMtaBlockedExtensionWarnRecipient() {
        return this.getBooleanAttr("zimbraMtaBlockedExtensionWarnRecipient", true);
    }

    @ZAttr(id=1032L)
    public void setMtaBlockedExtensionWarnRecipient(boolean zimbraMtaBlockedExtensionWarnRecipient) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaBlockedExtensionWarnRecipient", zimbraMtaBlockedExtensionWarnRecipient ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1032L)
    public Map<String, Object> setMtaBlockedExtensionWarnRecipient(boolean zimbraMtaBlockedExtensionWarnRecipient, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaBlockedExtensionWarnRecipient", zimbraMtaBlockedExtensionWarnRecipient ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1032L)
    public void unsetMtaBlockedExtensionWarnRecipient() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaBlockedExtensionWarnRecipient", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1032L)
    public Map<String, Object> unsetMtaBlockedExtensionWarnRecipient(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaBlockedExtensionWarnRecipient", "");
        return attrs;
    }

    @ZAttr(id=196L)
    public String[] getMtaCommonBlockedExtension() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraMtaCommonBlockedExtension");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[31];
            stringArray2[0] = "asd";
            stringArray2[1] = "bat";
            stringArray2[2] = "chm";
            stringArray2[3] = "cmd";
            stringArray2[4] = "com";
            stringArray2[5] = "dll";
            stringArray2[6] = "do";
            stringArray2[7] = "exe";
            stringArray2[8] = "hlp";
            stringArray2[9] = "hta";
            stringArray2[10] = "js";
            stringArray2[11] = "jse";
            stringArray2[12] = "lnk";
            stringArray2[13] = "mov";
            stringArray2[14] = "ocx";
            stringArray2[15] = "pif";
            stringArray2[16] = "reg";
            stringArray2[17] = "rm";
            stringArray2[18] = "scr";
            stringArray2[19] = "shb";
            stringArray2[20] = "shm";
            stringArray2[21] = "shs";
            stringArray2[22] = "vbe";
            stringArray2[23] = "vbs";
            stringArray2[24] = "vbx";
            stringArray2[25] = "vxd";
            stringArray2[26] = "wav";
            stringArray2[27] = "wmf";
            stringArray2[28] = "wsf";
            stringArray2[29] = "wsh";
            stringArray = stringArray2;
            stringArray2[30] = "xl";
        }
        return stringArray;
    }

    @ZAttr(id=196L)
    public void setMtaCommonBlockedExtension(String[] zimbraMtaCommonBlockedExtension) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaCommonBlockedExtension", zimbraMtaCommonBlockedExtension);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=196L)
    public Map<String, Object> setMtaCommonBlockedExtension(String[] zimbraMtaCommonBlockedExtension, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaCommonBlockedExtension", zimbraMtaCommonBlockedExtension);
        return attrs;
    }

    @ZAttr(id=196L)
    public void addMtaCommonBlockedExtension(String zimbraMtaCommonBlockedExtension) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaCommonBlockedExtension", zimbraMtaCommonBlockedExtension);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=196L)
    public Map<String, Object> addMtaCommonBlockedExtension(String zimbraMtaCommonBlockedExtension, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaCommonBlockedExtension", zimbraMtaCommonBlockedExtension);
        return attrs;
    }

    @ZAttr(id=196L)
    public void removeMtaCommonBlockedExtension(String zimbraMtaCommonBlockedExtension) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaCommonBlockedExtension", zimbraMtaCommonBlockedExtension);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=196L)
    public Map<String, Object> removeMtaCommonBlockedExtension(String zimbraMtaCommonBlockedExtension, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaCommonBlockedExtension", zimbraMtaCommonBlockedExtension);
        return attrs;
    }

    @ZAttr(id=196L)
    public void unsetMtaCommonBlockedExtension() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaCommonBlockedExtension", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=196L)
    public Map<String, Object> unsetMtaCommonBlockedExtension(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaCommonBlockedExtension", "");
        return attrs;
    }

    @ZAttr(id=197L)
    public boolean isMtaDnsLookupsEnabled() {
        return this.getBooleanAttr("zimbraMtaDnsLookupsEnabled", true);
    }

    @ZAttr(id=197L)
    public void setMtaDnsLookupsEnabled(boolean zimbraMtaDnsLookupsEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaDnsLookupsEnabled", zimbraMtaDnsLookupsEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=197L)
    public Map<String, Object> setMtaDnsLookupsEnabled(boolean zimbraMtaDnsLookupsEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaDnsLookupsEnabled", zimbraMtaDnsLookupsEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=197L)
    public void unsetMtaDnsLookupsEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaDnsLookupsEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=197L)
    public Map<String, Object> unsetMtaDnsLookupsEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaDnsLookupsEnabled", "");
        return attrs;
    }

    @ZAttr(id=198L)
    public int getMtaMaxMessageSize() {
        return this.getIntAttr("zimbraMtaMaxMessageSize", 10240000);
    }

    @ZAttr(id=198L)
    public void setMtaMaxMessageSize(int zimbraMtaMaxMessageSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMaxMessageSize", Integer.toString(zimbraMtaMaxMessageSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=198L)
    public Map<String, Object> setMtaMaxMessageSize(int zimbraMtaMaxMessageSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMaxMessageSize", Integer.toString(zimbraMtaMaxMessageSize));
        return attrs;
    }

    @ZAttr(id=198L)
    public void unsetMtaMaxMessageSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMaxMessageSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=198L)
    public Map<String, Object> unsetMtaMaxMessageSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMaxMessageSize", "");
        return attrs;
    }

    @ZAttr(id=524L)
    public String getMtaMyDestination() {
        return this.getAttr("zimbraMtaMyDestination", "localhost");
    }

    @ZAttr(id=524L)
    public void setMtaMyDestination(String zimbraMtaMyDestination) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyDestination", zimbraMtaMyDestination);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=524L)
    public Map<String, Object> setMtaMyDestination(String zimbraMtaMyDestination, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyDestination", zimbraMtaMyDestination);
        return attrs;
    }

    @ZAttr(id=524L)
    public void unsetMtaMyDestination() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyDestination", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=524L)
    public Map<String, Object> unsetMtaMyDestination(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyDestination", "");
        return attrs;
    }

    @ZAttr(id=509L)
    public String getMtaMyHostname() {
        return this.getAttr("zimbraMtaMyHostname", null);
    }

    @ZAttr(id=509L)
    public void setMtaMyHostname(String zimbraMtaMyHostname) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyHostname", zimbraMtaMyHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=509L)
    public Map<String, Object> setMtaMyHostname(String zimbraMtaMyHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyHostname", zimbraMtaMyHostname);
        return attrs;
    }

    @ZAttr(id=509L)
    public void unsetMtaMyHostname() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyHostname", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=509L)
    public Map<String, Object> unsetMtaMyHostname(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyHostname", "");
        return attrs;
    }

    @ZAttr(id=311L)
    public String[] getMtaMyNetworks() {
        return this.getMultiAttr("zimbraMtaMyNetworks");
    }

    @ZAttr(id=311L)
    public void setMtaMyNetworks(String[] zimbraMtaMyNetworks) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=311L)
    public Map<String, Object> setMtaMyNetworks(String[] zimbraMtaMyNetworks, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        return attrs;
    }

    @ZAttr(id=311L)
    public void addMtaMyNetworks(String zimbraMtaMyNetworks) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=311L)
    public Map<String, Object> addMtaMyNetworks(String zimbraMtaMyNetworks, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        return attrs;
    }

    @ZAttr(id=311L)
    public void removeMtaMyNetworks(String zimbraMtaMyNetworks) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=311L)
    public Map<String, Object> removeMtaMyNetworks(String zimbraMtaMyNetworks, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaMyNetworks", zimbraMtaMyNetworks);
        return attrs;
    }

    @ZAttr(id=311L)
    public void unsetMtaMyNetworks() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyNetworks", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=311L)
    public Map<String, Object> unsetMtaMyNetworks(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyNetworks", "");
        return attrs;
    }

    @ZAttr(id=510L)
    public String getMtaMyOrigin() {
        return this.getAttr("zimbraMtaMyOrigin", null);
    }

    @ZAttr(id=510L)
    public void setMtaMyOrigin(String zimbraMtaMyOrigin) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyOrigin", zimbraMtaMyOrigin);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=510L)
    public Map<String, Object> setMtaMyOrigin(String zimbraMtaMyOrigin, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyOrigin", zimbraMtaMyOrigin);
        return attrs;
    }

    @ZAttr(id=510L)
    public void unsetMtaMyOrigin() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaMyOrigin", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=510L)
    public Map<String, Object> unsetMtaMyOrigin(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaMyOrigin", "");
        return attrs;
    }

    @ZAttr(id=673L)
    public String getMtaNonSmtpdMilters() {
        return this.getAttr("zimbraMtaNonSmtpdMilters", null);
    }

    @ZAttr(id=673L)
    public void setMtaNonSmtpdMilters(String zimbraMtaNonSmtpdMilters) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaNonSmtpdMilters", zimbraMtaNonSmtpdMilters);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=673L)
    public Map<String, Object> setMtaNonSmtpdMilters(String zimbraMtaNonSmtpdMilters, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaNonSmtpdMilters", zimbraMtaNonSmtpdMilters);
        return attrs;
    }

    @ZAttr(id=673L)
    public void unsetMtaNonSmtpdMilters() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaNonSmtpdMilters", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=673L)
    public Map<String, Object> unsetMtaNonSmtpdMilters(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaNonSmtpdMilters", "");
        return attrs;
    }

    @ZAttr(id=306L)
    public String[] getMtaRecipientDelimiter() {
        return this.getMultiAttr("zimbraMtaRecipientDelimiter");
    }

    @ZAttr(id=306L)
    public void setMtaRecipientDelimiter(String[] zimbraMtaRecipientDelimiter) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaRecipientDelimiter", zimbraMtaRecipientDelimiter);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=306L)
    public Map<String, Object> setMtaRecipientDelimiter(String[] zimbraMtaRecipientDelimiter, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaRecipientDelimiter", zimbraMtaRecipientDelimiter);
        return attrs;
    }

    @ZAttr(id=306L)
    public void addMtaRecipientDelimiter(String zimbraMtaRecipientDelimiter) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaRecipientDelimiter", zimbraMtaRecipientDelimiter);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=306L)
    public Map<String, Object> addMtaRecipientDelimiter(String zimbraMtaRecipientDelimiter, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaRecipientDelimiter", zimbraMtaRecipientDelimiter);
        return attrs;
    }

    @ZAttr(id=306L)
    public void removeMtaRecipientDelimiter(String zimbraMtaRecipientDelimiter) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaRecipientDelimiter", zimbraMtaRecipientDelimiter);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=306L)
    public Map<String, Object> removeMtaRecipientDelimiter(String zimbraMtaRecipientDelimiter, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaRecipientDelimiter", zimbraMtaRecipientDelimiter);
        return attrs;
    }

    @ZAttr(id=306L)
    public void unsetMtaRecipientDelimiter() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaRecipientDelimiter", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=306L)
    public Map<String, Object> unsetMtaRecipientDelimiter(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaRecipientDelimiter", "");
        return attrs;
    }

    @ZAttr(id=199L)
    public String[] getMtaRelayHost() {
        return this.getMultiAttr("zimbraMtaRelayHost");
    }

    @ZAttr(id=199L)
    public void setMtaRelayHost(String[] zimbraMtaRelayHost) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaRelayHost", zimbraMtaRelayHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=199L)
    public Map<String, Object> setMtaRelayHost(String[] zimbraMtaRelayHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaRelayHost", zimbraMtaRelayHost);
        return attrs;
    }

    @ZAttr(id=199L)
    public void addMtaRelayHost(String zimbraMtaRelayHost) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaRelayHost", zimbraMtaRelayHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=199L)
    public Map<String, Object> addMtaRelayHost(String zimbraMtaRelayHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaRelayHost", zimbraMtaRelayHost);
        return attrs;
    }

    @ZAttr(id=199L)
    public void removeMtaRelayHost(String zimbraMtaRelayHost) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaRelayHost", zimbraMtaRelayHost);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=199L)
    public Map<String, Object> removeMtaRelayHost(String zimbraMtaRelayHost, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaRelayHost", zimbraMtaRelayHost);
        return attrs;
    }

    @ZAttr(id=199L)
    public void unsetMtaRelayHost() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaRelayHost", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=199L)
    public Map<String, Object> unsetMtaRelayHost(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaRelayHost", "");
        return attrs;
    }

    @ZAttr(id=226L)
    public String[] getMtaRestriction() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraMtaRestriction");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "reject_invalid_hostname";
            stringArray = stringArray2;
            stringArray2[1] = "reject_non_fqdn_sender";
        }
        return stringArray;
    }

    @ZAttr(id=226L)
    public void setMtaRestriction(String[] zimbraMtaRestriction) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraMtaRestriction", zimbraMtaRestriction);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=226L)
    public Map<String, Object> setMtaRestriction(String[] zimbraMtaRestriction, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaRestriction", zimbraMtaRestriction);
        return attrs;
    }

    @ZAttr(id=226L)
    public void addMtaRestriction(String zimbraMtaRestriction) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraMtaRestriction", zimbraMtaRestriction);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=226L)
    public Map<String, Object> addMtaRestriction(String zimbraMtaRestriction, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraMtaRestriction", zimbraMtaRestriction);
        return attrs;
    }

    @ZAttr(id=226L)
    public void removeMtaRestriction(String zimbraMtaRestriction) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraMtaRestriction", zimbraMtaRestriction);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=226L)
    public Map<String, Object> removeMtaRestriction(String zimbraMtaRestriction, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraMtaRestriction", zimbraMtaRestriction);
        return attrs;
    }

    @ZAttr(id=226L)
    public void unsetMtaRestriction() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaRestriction", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=226L)
    public Map<String, Object> unsetMtaRestriction(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaRestriction", "");
        return attrs;
    }

    @ZAttr(id=796L)
    public boolean isMtaSaslAuthEnable() {
        return this.getBooleanAttr("zimbraMtaSaslAuthEnable", true);
    }

    @ZAttr(id=796L)
    public void setMtaSaslAuthEnable(boolean zimbraMtaSaslAuthEnable) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaSaslAuthEnable", zimbraMtaSaslAuthEnable ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=796L)
    public Map<String, Object> setMtaSaslAuthEnable(boolean zimbraMtaSaslAuthEnable, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaSaslAuthEnable", zimbraMtaSaslAuthEnable ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=796L)
    public void unsetMtaSaslAuthEnable() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaSaslAuthEnable", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=796L)
    public Map<String, Object> unsetMtaSaslAuthEnable(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaSaslAuthEnable", "");
        return attrs;
    }

    @ZAttr(id=672L)
    public String getMtaSmtpdMilters() {
        return this.getAttr("zimbraMtaSmtpdMilters", null);
    }

    @ZAttr(id=672L)
    public void setMtaSmtpdMilters(String zimbraMtaSmtpdMilters) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaSmtpdMilters", zimbraMtaSmtpdMilters);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=672L)
    public Map<String, Object> setMtaSmtpdMilters(String zimbraMtaSmtpdMilters, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaSmtpdMilters", zimbraMtaSmtpdMilters);
        return attrs;
    }

    @ZAttr(id=672L)
    public void unsetMtaSmtpdMilters() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaSmtpdMilters", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=672L)
    public Map<String, Object> unsetMtaSmtpdMilters(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaSmtpdMilters", "");
        return attrs;
    }

    @ZAttr(id=200L)
    public boolean isMtaTlsAuthOnly() {
        return this.getBooleanAttr("zimbraMtaTlsAuthOnly", true);
    }

    @ZAttr(id=200L)
    public void setMtaTlsAuthOnly(boolean zimbraMtaTlsAuthOnly) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaTlsAuthOnly", zimbraMtaTlsAuthOnly ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=200L)
    public Map<String, Object> setMtaTlsAuthOnly(boolean zimbraMtaTlsAuthOnly, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaTlsAuthOnly", zimbraMtaTlsAuthOnly ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=200L)
    public void unsetMtaTlsAuthOnly() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaTlsAuthOnly", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=200L)
    public Map<String, Object> unsetMtaTlsAuthOnly(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaTlsAuthOnly", "");
        return attrs;
    }

    @ZAttr(id=795L)
    public ZAttrProvisioning.MtaTlsSecurityLevel getMtaTlsSecurityLevel() {
        try {
            String v = this.getAttr("zimbraMtaTlsSecurityLevel");
            return v == null ? ZAttrProvisioning.MtaTlsSecurityLevel.may : ZAttrProvisioning.MtaTlsSecurityLevel.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.MtaTlsSecurityLevel.may;
        }
    }

    @ZAttr(id=795L)
    public String getMtaTlsSecurityLevelAsString() {
        return this.getAttr("zimbraMtaTlsSecurityLevel", "may");
    }

    @ZAttr(id=795L)
    public void setMtaTlsSecurityLevel(ZAttrProvisioning.MtaTlsSecurityLevel zimbraMtaTlsSecurityLevel) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaTlsSecurityLevel", zimbraMtaTlsSecurityLevel.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=795L)
    public Map<String, Object> setMtaTlsSecurityLevel(ZAttrProvisioning.MtaTlsSecurityLevel zimbraMtaTlsSecurityLevel, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaTlsSecurityLevel", zimbraMtaTlsSecurityLevel.toString());
        return attrs;
    }

    @ZAttr(id=795L)
    public void setMtaTlsSecurityLevelAsString(String zimbraMtaTlsSecurityLevel) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaTlsSecurityLevel", zimbraMtaTlsSecurityLevel);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=795L)
    public Map<String, Object> setMtaTlsSecurityLevelAsString(String zimbraMtaTlsSecurityLevel, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaTlsSecurityLevel", zimbraMtaTlsSecurityLevel);
        return attrs;
    }

    @ZAttr(id=795L)
    public void unsetMtaTlsSecurityLevel() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraMtaTlsSecurityLevel", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=795L)
    public Map<String, Object> unsetMtaTlsSecurityLevel(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraMtaTlsSecurityLevel", "");
        return attrs;
    }

    @ZAttr(id=375L)
    public String getNetworkActivation() {
        return this.getAttr("zimbraNetworkActivation", null);
    }

    @ZAttr(id=375L)
    public void setNetworkActivation(String zimbraNetworkActivation) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNetworkActivation", zimbraNetworkActivation);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=375L)
    public Map<String, Object> setNetworkActivation(String zimbraNetworkActivation, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNetworkActivation", zimbraNetworkActivation);
        return attrs;
    }

    @ZAttr(id=375L)
    public void unsetNetworkActivation() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNetworkActivation", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=375L)
    public Map<String, Object> unsetNetworkActivation(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNetworkActivation", "");
        return attrs;
    }

    @ZAttr(id=374L)
    public String getNetworkLicense() {
        return this.getAttr("zimbraNetworkLicense", null);
    }

    @ZAttr(id=374L)
    public void setNetworkLicense(String zimbraNetworkLicense) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNetworkLicense", zimbraNetworkLicense);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=374L)
    public Map<String, Object> setNetworkLicense(String zimbraNetworkLicense, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNetworkLicense", zimbraNetworkLicense);
        return attrs;
    }

    @ZAttr(id=374L)
    public void unsetNetworkLicense() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNetworkLicense", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=374L)
    public Map<String, Object> unsetNetworkLicense(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNetworkLicense", "");
        return attrs;
    }

    @ZAttr(id=363L)
    public String getNotebookAccount() {
        return this.getAttr("zimbraNotebookAccount", null);
    }

    @ZAttr(id=363L)
    public void setNotebookAccount(String zimbraNotebookAccount) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookAccount", zimbraNotebookAccount);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=363L)
    public Map<String, Object> setNotebookAccount(String zimbraNotebookAccount, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookAccount", zimbraNotebookAccount);
        return attrs;
    }

    @ZAttr(id=363L)
    public void unsetNotebookAccount() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookAccount", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=363L)
    public Map<String, Object> unsetNotebookAccount(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookAccount", "");
        return attrs;
    }

    @ZAttr(id=370L)
    public int getNotebookFolderCacheSize() {
        return this.getIntAttr("zimbraNotebookFolderCacheSize", 1024);
    }

    @ZAttr(id=370L)
    public void setNotebookFolderCacheSize(int zimbraNotebookFolderCacheSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookFolderCacheSize", Integer.toString(zimbraNotebookFolderCacheSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=370L)
    public Map<String, Object> setNotebookFolderCacheSize(int zimbraNotebookFolderCacheSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookFolderCacheSize", Integer.toString(zimbraNotebookFolderCacheSize));
        return attrs;
    }

    @ZAttr(id=370L)
    public void unsetNotebookFolderCacheSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookFolderCacheSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=370L)
    public Map<String, Object> unsetNotebookFolderCacheSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookFolderCacheSize", "");
        return attrs;
    }

    @ZAttr(id=371L)
    public int getNotebookMaxCachedTemplatesPerFolder() {
        return this.getIntAttr("zimbraNotebookMaxCachedTemplatesPerFolder", 256);
    }

    @ZAttr(id=371L)
    public void setNotebookMaxCachedTemplatesPerFolder(int zimbraNotebookMaxCachedTemplatesPerFolder) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookMaxCachedTemplatesPerFolder", Integer.toString(zimbraNotebookMaxCachedTemplatesPerFolder));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=371L)
    public Map<String, Object> setNotebookMaxCachedTemplatesPerFolder(int zimbraNotebookMaxCachedTemplatesPerFolder, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookMaxCachedTemplatesPerFolder", Integer.toString(zimbraNotebookMaxCachedTemplatesPerFolder));
        return attrs;
    }

    @ZAttr(id=371L)
    public void unsetNotebookMaxCachedTemplatesPerFolder() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookMaxCachedTemplatesPerFolder", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=371L)
    public Map<String, Object> unsetNotebookMaxCachedTemplatesPerFolder(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookMaxCachedTemplatesPerFolder", "");
        return attrs;
    }

    @ZAttr(id=369L)
    public int getNotebookPageCacheSize() {
        return this.getIntAttr("zimbraNotebookPageCacheSize", 10240);
    }

    @ZAttr(id=369L)
    public void setNotebookPageCacheSize(int zimbraNotebookPageCacheSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookPageCacheSize", Integer.toString(zimbraNotebookPageCacheSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=369L)
    public Map<String, Object> setNotebookPageCacheSize(int zimbraNotebookPageCacheSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookPageCacheSize", Integer.toString(zimbraNotebookPageCacheSize));
        return attrs;
    }

    @ZAttr(id=369L)
    public void unsetNotebookPageCacheSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotebookPageCacheSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=369L)
    public Map<String, Object> unsetNotebookPageCacheSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotebookPageCacheSize", "");
        return attrs;
    }

    @ZAttr(id=317L)
    public String[] getNotifyBindAddress() {
        return this.getMultiAttr("zimbraNotifyBindAddress");
    }

    @ZAttr(id=317L)
    public void setNotifyBindAddress(String[] zimbraNotifyBindAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=317L)
    public Map<String, Object> setNotifyBindAddress(String[] zimbraNotifyBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        return attrs;
    }

    @ZAttr(id=317L)
    public void addNotifyBindAddress(String zimbraNotifyBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=317L)
    public Map<String, Object> addNotifyBindAddress(String zimbraNotifyBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        return attrs;
    }

    @ZAttr(id=317L)
    public void removeNotifyBindAddress(String zimbraNotifyBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=317L)
    public Map<String, Object> removeNotifyBindAddress(String zimbraNotifyBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraNotifyBindAddress", zimbraNotifyBindAddress);
        return attrs;
    }

    @ZAttr(id=317L)
    public void unsetNotifyBindAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifyBindAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=317L)
    public Map<String, Object> unsetNotifyBindAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyBindAddress", "");
        return attrs;
    }

    @ZAttr(id=318L)
    public int getNotifyBindPort() {
        return this.getIntAttr("zimbraNotifyBindPort", 7035);
    }

    @ZAttr(id=318L)
    public void setNotifyBindPort(int zimbraNotifyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifyBindPort", Integer.toString(zimbraNotifyBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=318L)
    public Map<String, Object> setNotifyBindPort(int zimbraNotifyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyBindPort", Integer.toString(zimbraNotifyBindPort));
        return attrs;
    }

    @ZAttr(id=318L)
    public void unsetNotifyBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifyBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=318L)
    public Map<String, Object> unsetNotifyBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyBindPort", "");
        return attrs;
    }

    @ZAttr(id=320L)
    public String[] getNotifySSLBindAddress() {
        return this.getMultiAttr("zimbraNotifySSLBindAddress");
    }

    @ZAttr(id=320L)
    public void setNotifySSLBindAddress(String[] zimbraNotifySSLBindAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=320L)
    public Map<String, Object> setNotifySSLBindAddress(String[] zimbraNotifySSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        return attrs;
    }

    @ZAttr(id=320L)
    public void addNotifySSLBindAddress(String zimbraNotifySSLBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=320L)
    public Map<String, Object> addNotifySSLBindAddress(String zimbraNotifySSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        return attrs;
    }

    @ZAttr(id=320L)
    public void removeNotifySSLBindAddress(String zimbraNotifySSLBindAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=320L)
    public Map<String, Object> removeNotifySSLBindAddress(String zimbraNotifySSLBindAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraNotifySSLBindAddress", zimbraNotifySSLBindAddress);
        return attrs;
    }

    @ZAttr(id=320L)
    public void unsetNotifySSLBindAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifySSLBindAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=320L)
    public Map<String, Object> unsetNotifySSLBindAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLBindAddress", "");
        return attrs;
    }

    @ZAttr(id=321L)
    public int getNotifySSLBindPort() {
        return this.getIntAttr("zimbraNotifySSLBindPort", 7036);
    }

    @ZAttr(id=321L)
    public void setNotifySSLBindPort(int zimbraNotifySSLBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifySSLBindPort", Integer.toString(zimbraNotifySSLBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=321L)
    public Map<String, Object> setNotifySSLBindPort(int zimbraNotifySSLBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLBindPort", Integer.toString(zimbraNotifySSLBindPort));
        return attrs;
    }

    @ZAttr(id=321L)
    public void unsetNotifySSLBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifySSLBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=321L)
    public Map<String, Object> unsetNotifySSLBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLBindPort", "");
        return attrs;
    }

    @ZAttr(id=319L)
    public boolean isNotifySSLServerEnabled() {
        return this.getBooleanAttr("zimbraNotifySSLServerEnabled", true);
    }

    @ZAttr(id=319L)
    public void setNotifySSLServerEnabled(boolean zimbraNotifySSLServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifySSLServerEnabled", zimbraNotifySSLServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=319L)
    public Map<String, Object> setNotifySSLServerEnabled(boolean zimbraNotifySSLServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLServerEnabled", zimbraNotifySSLServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=319L)
    public void unsetNotifySSLServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifySSLServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=319L)
    public Map<String, Object> unsetNotifySSLServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifySSLServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=316L)
    public boolean isNotifyServerEnabled() {
        return this.getBooleanAttr("zimbraNotifyServerEnabled", true);
    }

    @ZAttr(id=316L)
    public void setNotifyServerEnabled(boolean zimbraNotifyServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifyServerEnabled", zimbraNotifyServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=316L)
    public Map<String, Object> setNotifyServerEnabled(boolean zimbraNotifyServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyServerEnabled", zimbraNotifyServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=316L)
    public void unsetNotifyServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraNotifyServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=316L)
    public Map<String, Object> unsetNotifyServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraNotifyServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=586L)
    public String getPasswordChangeListener() {
        return this.getAttr("zimbraPasswordChangeListener", null);
    }

    @ZAttr(id=586L)
    public void setPasswordChangeListener(String zimbraPasswordChangeListener) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPasswordChangeListener", zimbraPasswordChangeListener);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=586L)
    public Map<String, Object> setPasswordChangeListener(String zimbraPasswordChangeListener, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPasswordChangeListener", zimbraPasswordChangeListener);
        return attrs;
    }

    @ZAttr(id=586L)
    public void unsetPasswordChangeListener() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPasswordChangeListener", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=586L)
    public Map<String, Object> unsetPasswordChangeListener(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPasswordChangeListener", "");
        return attrs;
    }

    @ZAttr(id=271L)
    public boolean isPop3BindOnStartup() {
        return this.getBooleanAttr("zimbraPop3BindOnStartup", true);
    }

    @ZAttr(id=271L)
    public void setPop3BindOnStartup(boolean zimbraPop3BindOnStartup) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3BindOnStartup", zimbraPop3BindOnStartup ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=271L)
    public Map<String, Object> setPop3BindOnStartup(boolean zimbraPop3BindOnStartup, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindOnStartup", zimbraPop3BindOnStartup ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=271L)
    public void unsetPop3BindOnStartup() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3BindOnStartup", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=271L)
    public Map<String, Object> unsetPop3BindOnStartup(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindOnStartup", "");
        return attrs;
    }

    @ZAttr(id=94L)
    public int getPop3BindPort() {
        return this.getIntAttr("zimbraPop3BindPort", 7110);
    }

    @ZAttr(id=94L)
    public String getPop3BindPortAsString() {
        return this.getAttr("zimbraPop3BindPort", "7110");
    }

    @ZAttr(id=94L)
    public void setPop3BindPort(int zimbraPop3BindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3BindPort", Integer.toString(zimbraPop3BindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=94L)
    public Map<String, Object> setPop3BindPort(int zimbraPop3BindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindPort", Integer.toString(zimbraPop3BindPort));
        return attrs;
    }

    @ZAttr(id=94L)
    public void setPop3BindPortAsString(String zimbraPop3BindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3BindPort", zimbraPop3BindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=94L)
    public Map<String, Object> setPop3BindPortAsString(String zimbraPop3BindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindPort", zimbraPop3BindPort);
        return attrs;
    }

    @ZAttr(id=94L)
    public void unsetPop3BindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3BindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=94L)
    public Map<String, Object> unsetPop3BindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3BindPort", "");
        return attrs;
    }

    @ZAttr(id=189L)
    public boolean isPop3CleartextLoginEnabled() {
        return this.getBooleanAttr("zimbraPop3CleartextLoginEnabled", false);
    }

    @ZAttr(id=189L)
    public void setPop3CleartextLoginEnabled(boolean zimbraPop3CleartextLoginEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3CleartextLoginEnabled", zimbraPop3CleartextLoginEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=189L)
    public Map<String, Object> setPop3CleartextLoginEnabled(boolean zimbraPop3CleartextLoginEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3CleartextLoginEnabled", zimbraPop3CleartextLoginEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=189L)
    public void unsetPop3CleartextLoginEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3CleartextLoginEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=189L)
    public Map<String, Object> unsetPop3CleartextLoginEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3CleartextLoginEnabled", "");
        return attrs;
    }

    @ZAttr(id=692L)
    public boolean isPop3ExposeVersionOnBanner() {
        return this.getBooleanAttr("zimbraPop3ExposeVersionOnBanner", false);
    }

    @ZAttr(id=692L)
    public void setPop3ExposeVersionOnBanner(boolean zimbraPop3ExposeVersionOnBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ExposeVersionOnBanner", zimbraPop3ExposeVersionOnBanner ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=692L)
    public Map<String, Object> setPop3ExposeVersionOnBanner(boolean zimbraPop3ExposeVersionOnBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ExposeVersionOnBanner", zimbraPop3ExposeVersionOnBanner ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=692L)
    public void unsetPop3ExposeVersionOnBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ExposeVersionOnBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=692L)
    public Map<String, Object> unsetPop3ExposeVersionOnBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ExposeVersionOnBanner", "");
        return attrs;
    }

    @ZAttr(id=96L)
    public int getPop3NumThreads() {
        return this.getIntAttr("zimbraPop3NumThreads", 100);
    }

    @ZAttr(id=96L)
    public void setPop3NumThreads(int zimbraPop3NumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3NumThreads", Integer.toString(zimbraPop3NumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=96L)
    public Map<String, Object> setPop3NumThreads(int zimbraPop3NumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3NumThreads", Integer.toString(zimbraPop3NumThreads));
        return attrs;
    }

    @ZAttr(id=96L)
    public void unsetPop3NumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3NumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=96L)
    public Map<String, Object> unsetPop3NumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3NumThreads", "");
        return attrs;
    }

    @ZAttr(id=350L)
    public int getPop3ProxyBindPort() {
        return this.getIntAttr("zimbraPop3ProxyBindPort", 110);
    }

    @ZAttr(id=350L)
    public String getPop3ProxyBindPortAsString() {
        return this.getAttr("zimbraPop3ProxyBindPort", "110");
    }

    @ZAttr(id=350L)
    public void setPop3ProxyBindPort(int zimbraPop3ProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ProxyBindPort", Integer.toString(zimbraPop3ProxyBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=350L)
    public Map<String, Object> setPop3ProxyBindPort(int zimbraPop3ProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ProxyBindPort", Integer.toString(zimbraPop3ProxyBindPort));
        return attrs;
    }

    @ZAttr(id=350L)
    public void setPop3ProxyBindPortAsString(String zimbraPop3ProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ProxyBindPort", zimbraPop3ProxyBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=350L)
    public Map<String, Object> setPop3ProxyBindPortAsString(String zimbraPop3ProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ProxyBindPort", zimbraPop3ProxyBindPort);
        return attrs;
    }

    @ZAttr(id=350L)
    public void unsetPop3ProxyBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ProxyBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=350L)
    public Map<String, Object> unsetPop3ProxyBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ProxyBindPort", "");
        return attrs;
    }

    @ZAttr(id=272L)
    public boolean isPop3SSLBindOnStartup() {
        return this.getBooleanAttr("zimbraPop3SSLBindOnStartup", true);
    }

    @ZAttr(id=272L)
    public void setPop3SSLBindOnStartup(boolean zimbraPop3SSLBindOnStartup) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLBindOnStartup", zimbraPop3SSLBindOnStartup ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=272L)
    public Map<String, Object> setPop3SSLBindOnStartup(boolean zimbraPop3SSLBindOnStartup, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindOnStartup", zimbraPop3SSLBindOnStartup ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=272L)
    public void unsetPop3SSLBindOnStartup() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLBindOnStartup", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=272L)
    public Map<String, Object> unsetPop3SSLBindOnStartup(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindOnStartup", "");
        return attrs;
    }

    @ZAttr(id=187L)
    public int getPop3SSLBindPort() {
        return this.getIntAttr("zimbraPop3SSLBindPort", 7995);
    }

    @ZAttr(id=187L)
    public String getPop3SSLBindPortAsString() {
        return this.getAttr("zimbraPop3SSLBindPort", "7995");
    }

    @ZAttr(id=187L)
    public void setPop3SSLBindPort(int zimbraPop3SSLBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLBindPort", Integer.toString(zimbraPop3SSLBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=187L)
    public Map<String, Object> setPop3SSLBindPort(int zimbraPop3SSLBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindPort", Integer.toString(zimbraPop3SSLBindPort));
        return attrs;
    }

    @ZAttr(id=187L)
    public void setPop3SSLBindPortAsString(String zimbraPop3SSLBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLBindPort", zimbraPop3SSLBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=187L)
    public Map<String, Object> setPop3SSLBindPortAsString(String zimbraPop3SSLBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindPort", zimbraPop3SSLBindPort);
        return attrs;
    }

    @ZAttr(id=187L)
    public void unsetPop3SSLBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=187L)
    public Map<String, Object> unsetPop3SSLBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLBindPort", "");
        return attrs;
    }

    @ZAttr(id=351L)
    public int getPop3SSLProxyBindPort() {
        return this.getIntAttr("zimbraPop3SSLProxyBindPort", 995);
    }

    @ZAttr(id=351L)
    public String getPop3SSLProxyBindPortAsString() {
        return this.getAttr("zimbraPop3SSLProxyBindPort", "995");
    }

    @ZAttr(id=351L)
    public void setPop3SSLProxyBindPort(int zimbraPop3SSLProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLProxyBindPort", Integer.toString(zimbraPop3SSLProxyBindPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=351L)
    public Map<String, Object> setPop3SSLProxyBindPort(int zimbraPop3SSLProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLProxyBindPort", Integer.toString(zimbraPop3SSLProxyBindPort));
        return attrs;
    }

    @ZAttr(id=351L)
    public void setPop3SSLProxyBindPortAsString(String zimbraPop3SSLProxyBindPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLProxyBindPort", zimbraPop3SSLProxyBindPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=351L)
    public Map<String, Object> setPop3SSLProxyBindPortAsString(String zimbraPop3SSLProxyBindPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLProxyBindPort", zimbraPop3SSLProxyBindPort);
        return attrs;
    }

    @ZAttr(id=351L)
    public void unsetPop3SSLProxyBindPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLProxyBindPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=351L)
    public Map<String, Object> unsetPop3SSLProxyBindPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLProxyBindPort", "");
        return attrs;
    }

    @ZAttr(id=188L)
    public boolean isPop3SSLServerEnabled() {
        return this.getBooleanAttr("zimbraPop3SSLServerEnabled", true);
    }

    @ZAttr(id=188L)
    public void setPop3SSLServerEnabled(boolean zimbraPop3SSLServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLServerEnabled", zimbraPop3SSLServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=188L)
    public Map<String, Object> setPop3SSLServerEnabled(boolean zimbraPop3SSLServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLServerEnabled", zimbraPop3SSLServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=188L)
    public void unsetPop3SSLServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SSLServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=188L)
    public Map<String, Object> unsetPop3SSLServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SSLServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=554L)
    public boolean isPop3SaslGssapiEnabled() {
        return this.getBooleanAttr("zimbraPop3SaslGssapiEnabled", false);
    }

    @ZAttr(id=554L)
    public void setPop3SaslGssapiEnabled(boolean zimbraPop3SaslGssapiEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SaslGssapiEnabled", zimbraPop3SaslGssapiEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=554L)
    public Map<String, Object> setPop3SaslGssapiEnabled(boolean zimbraPop3SaslGssapiEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SaslGssapiEnabled", zimbraPop3SaslGssapiEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=554L)
    public void unsetPop3SaslGssapiEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3SaslGssapiEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=554L)
    public Map<String, Object> unsetPop3SaslGssapiEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3SaslGssapiEnabled", "");
        return attrs;
    }

    @ZAttr(id=177L)
    public boolean isPop3ServerEnabled() {
        return this.getBooleanAttr("zimbraPop3ServerEnabled", true);
    }

    @ZAttr(id=177L)
    public void setPop3ServerEnabled(boolean zimbraPop3ServerEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ServerEnabled", zimbraPop3ServerEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=177L)
    public Map<String, Object> setPop3ServerEnabled(boolean zimbraPop3ServerEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ServerEnabled", zimbraPop3ServerEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=177L)
    public void unsetPop3ServerEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPop3ServerEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=177L)
    public Map<String, Object> unsetPop3ServerEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPop3ServerEnabled", "");
        return attrs;
    }

    @ZAttr(id=377L)
    public String getPublicServiceHostname() {
        return this.getAttr("zimbraPublicServiceHostname", null);
    }

    @ZAttr(id=377L)
    public void setPublicServiceHostname(String zimbraPublicServiceHostname) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPublicServiceHostname", zimbraPublicServiceHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=377L)
    public Map<String, Object> setPublicServiceHostname(String zimbraPublicServiceHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPublicServiceHostname", zimbraPublicServiceHostname);
        return attrs;
    }

    @ZAttr(id=377L)
    public void unsetPublicServiceHostname() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPublicServiceHostname", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=377L)
    public Map<String, Object> unsetPublicServiceHostname(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPublicServiceHostname", "");
        return attrs;
    }

    @ZAttr(id=699L)
    public int getPublicServicePort() {
        return this.getIntAttr("zimbraPublicServicePort", -1);
    }

    @ZAttr(id=699L)
    public String getPublicServicePortAsString() {
        return this.getAttr("zimbraPublicServicePort", null);
    }

    @ZAttr(id=699L)
    public void setPublicServicePort(int zimbraPublicServicePort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPublicServicePort", Integer.toString(zimbraPublicServicePort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=699L)
    public Map<String, Object> setPublicServicePort(int zimbraPublicServicePort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPublicServicePort", Integer.toString(zimbraPublicServicePort));
        return attrs;
    }

    @ZAttr(id=699L)
    public void setPublicServicePortAsString(String zimbraPublicServicePort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPublicServicePort", zimbraPublicServicePort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=699L)
    public Map<String, Object> setPublicServicePortAsString(String zimbraPublicServicePort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPublicServicePort", zimbraPublicServicePort);
        return attrs;
    }

    @ZAttr(id=699L)
    public void unsetPublicServicePort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPublicServicePort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=699L)
    public Map<String, Object> unsetPublicServicePort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPublicServicePort", "");
        return attrs;
    }

    @ZAttr(id=698L)
    public String getPublicServiceProtocol() {
        return this.getAttr("zimbraPublicServiceProtocol", null);
    }

    @ZAttr(id=698L)
    public void setPublicServiceProtocol(String zimbraPublicServiceProtocol) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPublicServiceProtocol", zimbraPublicServiceProtocol);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=698L)
    public Map<String, Object> setPublicServiceProtocol(String zimbraPublicServiceProtocol, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPublicServiceProtocol", zimbraPublicServiceProtocol);
        return attrs;
    }

    @ZAttr(id=698L)
    public void unsetPublicServiceProtocol() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraPublicServiceProtocol", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=698L)
    public Map<String, Object> unsetPublicServiceProtocol(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraPublicServiceProtocol", "");
        return attrs;
    }

    @ZAttr(id=76L)
    public String getRedoLogArchiveDir() {
        return this.getAttr("zimbraRedoLogArchiveDir", "redolog/archive");
    }

    @ZAttr(id=76L)
    public void setRedoLogArchiveDir(String zimbraRedoLogArchiveDir) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogArchiveDir", zimbraRedoLogArchiveDir);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=76L)
    public Map<String, Object> setRedoLogArchiveDir(String zimbraRedoLogArchiveDir, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogArchiveDir", zimbraRedoLogArchiveDir);
        return attrs;
    }

    @ZAttr(id=76L)
    public void unsetRedoLogArchiveDir() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogArchiveDir", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=76L)
    public Map<String, Object> unsetRedoLogArchiveDir(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogArchiveDir", "");
        return attrs;
    }

    @ZAttr(id=1009L)
    public int getRedoLogCrashRecoveryLookbackSec() {
        return this.getIntAttr("zimbraRedoLogCrashRecoveryLookbackSec", 10);
    }

    @ZAttr(id=1009L)
    public void setRedoLogCrashRecoveryLookbackSec(int zimbraRedoLogCrashRecoveryLookbackSec) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogCrashRecoveryLookbackSec", Integer.toString(zimbraRedoLogCrashRecoveryLookbackSec));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1009L)
    public Map<String, Object> setRedoLogCrashRecoveryLookbackSec(int zimbraRedoLogCrashRecoveryLookbackSec, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogCrashRecoveryLookbackSec", Integer.toString(zimbraRedoLogCrashRecoveryLookbackSec));
        return attrs;
    }

    @ZAttr(id=1009L)
    public void unsetRedoLogCrashRecoveryLookbackSec() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogCrashRecoveryLookbackSec", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1009L)
    public Map<String, Object> unsetRedoLogCrashRecoveryLookbackSec(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogCrashRecoveryLookbackSec", "");
        return attrs;
    }

    @ZAttr(id=251L)
    public boolean isRedoLogDeleteOnRollover() {
        return this.getBooleanAttr("zimbraRedoLogDeleteOnRollover", true);
    }

    @ZAttr(id=251L)
    public void setRedoLogDeleteOnRollover(boolean zimbraRedoLogDeleteOnRollover) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogDeleteOnRollover", zimbraRedoLogDeleteOnRollover ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=251L)
    public Map<String, Object> setRedoLogDeleteOnRollover(boolean zimbraRedoLogDeleteOnRollover, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogDeleteOnRollover", zimbraRedoLogDeleteOnRollover ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=251L)
    public void unsetRedoLogDeleteOnRollover() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogDeleteOnRollover", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=251L)
    public Map<String, Object> unsetRedoLogDeleteOnRollover(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogDeleteOnRollover", "");
        return attrs;
    }

    @ZAttr(id=74L)
    public boolean isRedoLogEnabled() {
        return this.getBooleanAttr("zimbraRedoLogEnabled", true);
    }

    @ZAttr(id=74L)
    public void setRedoLogEnabled(boolean zimbraRedoLogEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogEnabled", zimbraRedoLogEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=74L)
    public Map<String, Object> setRedoLogEnabled(boolean zimbraRedoLogEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogEnabled", zimbraRedoLogEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=74L)
    public void unsetRedoLogEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=74L)
    public Map<String, Object> unsetRedoLogEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogEnabled", "");
        return attrs;
    }

    @ZAttr(id=79L)
    public int getRedoLogFsyncIntervalMS() {
        return this.getIntAttr("zimbraRedoLogFsyncIntervalMS", 10);
    }

    @ZAttr(id=79L)
    public void setRedoLogFsyncIntervalMS(int zimbraRedoLogFsyncIntervalMS) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogFsyncIntervalMS", Integer.toString(zimbraRedoLogFsyncIntervalMS));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=79L)
    public Map<String, Object> setRedoLogFsyncIntervalMS(int zimbraRedoLogFsyncIntervalMS, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogFsyncIntervalMS", Integer.toString(zimbraRedoLogFsyncIntervalMS));
        return attrs;
    }

    @ZAttr(id=79L)
    public void unsetRedoLogFsyncIntervalMS() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogFsyncIntervalMS", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=79L)
    public Map<String, Object> unsetRedoLogFsyncIntervalMS(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogFsyncIntervalMS", "");
        return attrs;
    }

    @ZAttr(id=75L)
    public String getRedoLogLogPath() {
        return this.getAttr("zimbraRedoLogLogPath", "redolog/redo.log");
    }

    @ZAttr(id=75L)
    public void setRedoLogLogPath(String zimbraRedoLogLogPath) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogLogPath", zimbraRedoLogLogPath);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=75L)
    public Map<String, Object> setRedoLogLogPath(String zimbraRedoLogLogPath, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogLogPath", zimbraRedoLogLogPath);
        return attrs;
    }

    @ZAttr(id=75L)
    public void unsetRedoLogLogPath() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogLogPath", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=75L)
    public Map<String, Object> unsetRedoLogLogPath(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogLogPath", "");
        return attrs;
    }

    @ZAttr(id=225L)
    public String[] getRedoLogProvider() {
        return this.getMultiAttr("zimbraRedoLogProvider");
    }

    @ZAttr(id=225L)
    public void setRedoLogProvider(String[] zimbraRedoLogProvider) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraRedoLogProvider", zimbraRedoLogProvider);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=225L)
    public Map<String, Object> setRedoLogProvider(String[] zimbraRedoLogProvider, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogProvider", zimbraRedoLogProvider);
        return attrs;
    }

    @ZAttr(id=225L)
    public void addRedoLogProvider(String zimbraRedoLogProvider) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraRedoLogProvider", zimbraRedoLogProvider);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=225L)
    public Map<String, Object> addRedoLogProvider(String zimbraRedoLogProvider, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraRedoLogProvider", zimbraRedoLogProvider);
        return attrs;
    }

    @ZAttr(id=225L)
    public void removeRedoLogProvider(String zimbraRedoLogProvider) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraRedoLogProvider", zimbraRedoLogProvider);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=225L)
    public Map<String, Object> removeRedoLogProvider(String zimbraRedoLogProvider, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraRedoLogProvider", zimbraRedoLogProvider);
        return attrs;
    }

    @ZAttr(id=225L)
    public void unsetRedoLogProvider() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogProvider", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=225L)
    public Map<String, Object> unsetRedoLogProvider(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogProvider", "");
        return attrs;
    }

    @ZAttr(id=78L)
    public int getRedoLogRolloverFileSizeKB() {
        return this.getIntAttr("zimbraRedoLogRolloverFileSizeKB", 0x100000);
    }

    @ZAttr(id=78L)
    public void setRedoLogRolloverFileSizeKB(int zimbraRedoLogRolloverFileSizeKB) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverFileSizeKB", Integer.toString(zimbraRedoLogRolloverFileSizeKB));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=78L)
    public Map<String, Object> setRedoLogRolloverFileSizeKB(int zimbraRedoLogRolloverFileSizeKB, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverFileSizeKB", Integer.toString(zimbraRedoLogRolloverFileSizeKB));
        return attrs;
    }

    @ZAttr(id=78L)
    public void unsetRedoLogRolloverFileSizeKB() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverFileSizeKB", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=78L)
    public Map<String, Object> unsetRedoLogRolloverFileSizeKB(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverFileSizeKB", "");
        return attrs;
    }

    @ZAttr(id=1021L)
    public int getRedoLogRolloverHardMaxFileSizeKB() {
        return this.getIntAttr("zimbraRedoLogRolloverHardMaxFileSizeKB", 0x400000);
    }

    @ZAttr(id=1021L)
    public void setRedoLogRolloverHardMaxFileSizeKB(int zimbraRedoLogRolloverHardMaxFileSizeKB) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverHardMaxFileSizeKB", Integer.toString(zimbraRedoLogRolloverHardMaxFileSizeKB));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1021L)
    public Map<String, Object> setRedoLogRolloverHardMaxFileSizeKB(int zimbraRedoLogRolloverHardMaxFileSizeKB, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverHardMaxFileSizeKB", Integer.toString(zimbraRedoLogRolloverHardMaxFileSizeKB));
        return attrs;
    }

    @ZAttr(id=1021L)
    public void unsetRedoLogRolloverHardMaxFileSizeKB() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverHardMaxFileSizeKB", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1021L)
    public Map<String, Object> unsetRedoLogRolloverHardMaxFileSizeKB(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverHardMaxFileSizeKB", "");
        return attrs;
    }

    @ZAttr(id=1020L)
    public int getRedoLogRolloverMinFileAge() {
        return this.getIntAttr("zimbraRedoLogRolloverMinFileAge", 60);
    }

    @ZAttr(id=1020L)
    public void setRedoLogRolloverMinFileAge(int zimbraRedoLogRolloverMinFileAge) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverMinFileAge", Integer.toString(zimbraRedoLogRolloverMinFileAge));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1020L)
    public Map<String, Object> setRedoLogRolloverMinFileAge(int zimbraRedoLogRolloverMinFileAge, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverMinFileAge", Integer.toString(zimbraRedoLogRolloverMinFileAge));
        return attrs;
    }

    @ZAttr(id=1020L)
    public void unsetRedoLogRolloverMinFileAge() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRedoLogRolloverMinFileAge", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1020L)
    public Map<String, Object> unsetRedoLogRolloverMinFileAge(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRedoLogRolloverMinFileAge", "");
        return attrs;
    }

    @ZAttr(id=336L)
    public String getRemoteManagementCommand() {
        return this.getAttr("zimbraRemoteManagementCommand", "/opt/zimbra/libexec/zmrcd");
    }

    @ZAttr(id=336L)
    public void setRemoteManagementCommand(String zimbraRemoteManagementCommand) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementCommand", zimbraRemoteManagementCommand);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=336L)
    public Map<String, Object> setRemoteManagementCommand(String zimbraRemoteManagementCommand, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementCommand", zimbraRemoteManagementCommand);
        return attrs;
    }

    @ZAttr(id=336L)
    public void unsetRemoteManagementCommand() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementCommand", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=336L)
    public Map<String, Object> unsetRemoteManagementCommand(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementCommand", "");
        return attrs;
    }

    @ZAttr(id=339L)
    public int getRemoteManagementPort() {
        return this.getIntAttr("zimbraRemoteManagementPort", 22);
    }

    @ZAttr(id=339L)
    public void setRemoteManagementPort(int zimbraRemoteManagementPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementPort", Integer.toString(zimbraRemoteManagementPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=339L)
    public Map<String, Object> setRemoteManagementPort(int zimbraRemoteManagementPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementPort", Integer.toString(zimbraRemoteManagementPort));
        return attrs;
    }

    @ZAttr(id=339L)
    public void unsetRemoteManagementPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=339L)
    public Map<String, Object> unsetRemoteManagementPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementPort", "");
        return attrs;
    }

    @ZAttr(id=338L)
    public String getRemoteManagementPrivateKeyPath() {
        return this.getAttr("zimbraRemoteManagementPrivateKeyPath", "/opt/zimbra/.ssh/zimbra_identity");
    }

    @ZAttr(id=338L)
    public void setRemoteManagementPrivateKeyPath(String zimbraRemoteManagementPrivateKeyPath) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementPrivateKeyPath", zimbraRemoteManagementPrivateKeyPath);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=338L)
    public Map<String, Object> setRemoteManagementPrivateKeyPath(String zimbraRemoteManagementPrivateKeyPath, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementPrivateKeyPath", zimbraRemoteManagementPrivateKeyPath);
        return attrs;
    }

    @ZAttr(id=338L)
    public void unsetRemoteManagementPrivateKeyPath() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementPrivateKeyPath", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=338L)
    public Map<String, Object> unsetRemoteManagementPrivateKeyPath(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementPrivateKeyPath", "");
        return attrs;
    }

    @ZAttr(id=337L)
    public String getRemoteManagementUser() {
        return this.getAttr("zimbraRemoteManagementUser", "zimbra");
    }

    @ZAttr(id=337L)
    public void setRemoteManagementUser(String zimbraRemoteManagementUser) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementUser", zimbraRemoteManagementUser);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=337L)
    public Map<String, Object> setRemoteManagementUser(String zimbraRemoteManagementUser, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementUser", zimbraRemoteManagementUser);
        return attrs;
    }

    @ZAttr(id=337L)
    public void unsetRemoteManagementUser() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraRemoteManagementUser", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=337L)
    public Map<String, Object> unsetRemoteManagementUser(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraRemoteManagementUser", "");
        return attrs;
    }

    @ZAttr(id=697L)
    public String[] getReverseProxyAdminIPAddress() {
        return this.getMultiAttr("zimbraReverseProxyAdminIPAddress");
    }

    @ZAttr(id=697L)
    public void setReverseProxyAdminIPAddress(String[] zimbraReverseProxyAdminIPAddress) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraReverseProxyAdminIPAddress", zimbraReverseProxyAdminIPAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=697L)
    public Map<String, Object> setReverseProxyAdminIPAddress(String[] zimbraReverseProxyAdminIPAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyAdminIPAddress", zimbraReverseProxyAdminIPAddress);
        return attrs;
    }

    @ZAttr(id=697L)
    public void addReverseProxyAdminIPAddress(String zimbraReverseProxyAdminIPAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraReverseProxyAdminIPAddress", zimbraReverseProxyAdminIPAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=697L)
    public Map<String, Object> addReverseProxyAdminIPAddress(String zimbraReverseProxyAdminIPAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraReverseProxyAdminIPAddress", zimbraReverseProxyAdminIPAddress);
        return attrs;
    }

    @ZAttr(id=697L)
    public void removeReverseProxyAdminIPAddress(String zimbraReverseProxyAdminIPAddress) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraReverseProxyAdminIPAddress", zimbraReverseProxyAdminIPAddress);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=697L)
    public Map<String, Object> removeReverseProxyAdminIPAddress(String zimbraReverseProxyAdminIPAddress, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraReverseProxyAdminIPAddress", zimbraReverseProxyAdminIPAddress);
        return attrs;
    }

    @ZAttr(id=697L)
    public void unsetReverseProxyAdminIPAddress() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyAdminIPAddress", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=697L)
    public Map<String, Object> unsetReverseProxyAdminIPAddress(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyAdminIPAddress", "");
        return attrs;
    }

    @ZAttr(id=700L)
    public String getReverseProxyAdminPortAttribute() {
        return this.getAttr("zimbraReverseProxyAdminPortAttribute", "zimbraAdminPort");
    }

    @ZAttr(id=700L)
    public void setReverseProxyAdminPortAttribute(String zimbraReverseProxyAdminPortAttribute) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyAdminPortAttribute", zimbraReverseProxyAdminPortAttribute);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=700L)
    public Map<String, Object> setReverseProxyAdminPortAttribute(String zimbraReverseProxyAdminPortAttribute, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyAdminPortAttribute", zimbraReverseProxyAdminPortAttribute);
        return attrs;
    }

    @ZAttr(id=700L)
    public void unsetReverseProxyAdminPortAttribute() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyAdminPortAttribute", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=700L)
    public Map<String, Object> unsetReverseProxyAdminPortAttribute(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyAdminPortAttribute", "");
        return attrs;
    }

    @ZAttr(id=569L)
    public long getReverseProxyAuthWaitInterval() {
        return this.getTimeInterval("zimbraReverseProxyAuthWaitInterval", 10000L);
    }

    @ZAttr(id=569L)
    public String getReverseProxyAuthWaitIntervalAsString() {
        return this.getAttr("zimbraReverseProxyAuthWaitInterval", "10s");
    }

    @ZAttr(id=569L)
    public void setReverseProxyAuthWaitInterval(String zimbraReverseProxyAuthWaitInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyAuthWaitInterval", zimbraReverseProxyAuthWaitInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=569L)
    public Map<String, Object> setReverseProxyAuthWaitInterval(String zimbraReverseProxyAuthWaitInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyAuthWaitInterval", zimbraReverseProxyAuthWaitInterval);
        return attrs;
    }

    @ZAttr(id=569L)
    public void unsetReverseProxyAuthWaitInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyAuthWaitInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=569L)
    public Map<String, Object> unsetReverseProxyAuthWaitInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyAuthWaitInterval", "");
        return attrs;
    }

    @ZAttr(id=732L)
    public long getReverseProxyCacheEntryTTL() {
        return this.getTimeInterval("zimbraReverseProxyCacheEntryTTL", 3600000L);
    }

    @ZAttr(id=732L)
    public String getReverseProxyCacheEntryTTLAsString() {
        return this.getAttr("zimbraReverseProxyCacheEntryTTL", "1h");
    }

    @ZAttr(id=732L)
    public void setReverseProxyCacheEntryTTL(String zimbraReverseProxyCacheEntryTTL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyCacheEntryTTL", zimbraReverseProxyCacheEntryTTL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=732L)
    public Map<String, Object> setReverseProxyCacheEntryTTL(String zimbraReverseProxyCacheEntryTTL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyCacheEntryTTL", zimbraReverseProxyCacheEntryTTL);
        return attrs;
    }

    @ZAttr(id=732L)
    public void unsetReverseProxyCacheEntryTTL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyCacheEntryTTL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=732L)
    public Map<String, Object> unsetReverseProxyCacheEntryTTL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyCacheEntryTTL", "");
        return attrs;
    }

    @ZAttr(id=731L)
    public long getReverseProxyCacheFetchTimeout() {
        return this.getTimeInterval("zimbraReverseProxyCacheFetchTimeout", 3000L);
    }

    @ZAttr(id=731L)
    public String getReverseProxyCacheFetchTimeoutAsString() {
        return this.getAttr("zimbraReverseProxyCacheFetchTimeout", "3s");
    }

    @ZAttr(id=731L)
    public void setReverseProxyCacheFetchTimeout(String zimbraReverseProxyCacheFetchTimeout) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyCacheFetchTimeout", zimbraReverseProxyCacheFetchTimeout);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=731L)
    public Map<String, Object> setReverseProxyCacheFetchTimeout(String zimbraReverseProxyCacheFetchTimeout, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyCacheFetchTimeout", zimbraReverseProxyCacheFetchTimeout);
        return attrs;
    }

    @ZAttr(id=731L)
    public void unsetReverseProxyCacheFetchTimeout() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyCacheFetchTimeout", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=731L)
    public Map<String, Object> unsetReverseProxyCacheFetchTimeout(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyCacheFetchTimeout", "");
        return attrs;
    }

    @ZAttr(id=730L)
    public long getReverseProxyCacheReconnectInterval() {
        return this.getTimeInterval("zimbraReverseProxyCacheReconnectInterval", 60000L);
    }

    @ZAttr(id=730L)
    public String getReverseProxyCacheReconnectIntervalAsString() {
        return this.getAttr("zimbraReverseProxyCacheReconnectInterval", "1m");
    }

    @ZAttr(id=730L)
    public void setReverseProxyCacheReconnectInterval(String zimbraReverseProxyCacheReconnectInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyCacheReconnectInterval", zimbraReverseProxyCacheReconnectInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=730L)
    public Map<String, Object> setReverseProxyCacheReconnectInterval(String zimbraReverseProxyCacheReconnectInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyCacheReconnectInterval", zimbraReverseProxyCacheReconnectInterval);
        return attrs;
    }

    @ZAttr(id=730L)
    public void unsetReverseProxyCacheReconnectInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyCacheReconnectInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=730L)
    public Map<String, Object> unsetReverseProxyCacheReconnectInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyCacheReconnectInterval", "");
        return attrs;
    }

    @ZAttr(id=797L)
    public long getReverseProxyConnectTimeout() {
        return this.getTimeInterval("zimbraReverseProxyConnectTimeout", 120000L);
    }

    @ZAttr(id=797L)
    public String getReverseProxyConnectTimeoutAsString() {
        return this.getAttr("zimbraReverseProxyConnectTimeout", "120000ms");
    }

    @ZAttr(id=797L)
    public void setReverseProxyConnectTimeout(String zimbraReverseProxyConnectTimeout) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyConnectTimeout", zimbraReverseProxyConnectTimeout);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=797L)
    public Map<String, Object> setReverseProxyConnectTimeout(String zimbraReverseProxyConnectTimeout, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyConnectTimeout", zimbraReverseProxyConnectTimeout);
        return attrs;
    }

    @ZAttr(id=797L)
    public void unsetReverseProxyConnectTimeout() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyConnectTimeout", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=797L)
    public Map<String, Object> unsetReverseProxyConnectTimeout(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyConnectTimeout", "");
        return attrs;
    }

    @ZAttr(id=703L)
    public String getReverseProxyDefaultRealm() {
        return this.getAttr("zimbraReverseProxyDefaultRealm", null);
    }

    @ZAttr(id=703L)
    public void setReverseProxyDefaultRealm(String zimbraReverseProxyDefaultRealm) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyDefaultRealm", zimbraReverseProxyDefaultRealm);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=703L)
    public Map<String, Object> setReverseProxyDefaultRealm(String zimbraReverseProxyDefaultRealm, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyDefaultRealm", zimbraReverseProxyDefaultRealm);
        return attrs;
    }

    @ZAttr(id=703L)
    public void unsetReverseProxyDefaultRealm() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyDefaultRealm", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=703L)
    public Map<String, Object> unsetReverseProxyDefaultRealm(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyDefaultRealm", "");
        return attrs;
    }

    @ZAttr(id=547L)
    public String getReverseProxyDomainNameAttribute() {
        return this.getAttr("zimbraReverseProxyDomainNameAttribute", "zimbraDomainName");
    }

    @ZAttr(id=547L)
    public void setReverseProxyDomainNameAttribute(String zimbraReverseProxyDomainNameAttribute) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyDomainNameAttribute", zimbraReverseProxyDomainNameAttribute);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=547L)
    public Map<String, Object> setReverseProxyDomainNameAttribute(String zimbraReverseProxyDomainNameAttribute, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyDomainNameAttribute", zimbraReverseProxyDomainNameAttribute);
        return attrs;
    }

    @ZAttr(id=547L)
    public void unsetReverseProxyDomainNameAttribute() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyDomainNameAttribute", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=547L)
    public Map<String, Object> unsetReverseProxyDomainNameAttribute(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyDomainNameAttribute", "");
        return attrs;
    }

    @ZAttr(id=545L)
    public String getReverseProxyDomainNameQuery() {
        return this.getAttr("zimbraReverseProxyDomainNameQuery", "(&(zimbraVirtualIPAddress=${IPADDR})(objectClass=zimbraDomain))");
    }

    @ZAttr(id=545L)
    public void setReverseProxyDomainNameQuery(String zimbraReverseProxyDomainNameQuery) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyDomainNameQuery", zimbraReverseProxyDomainNameQuery);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=545L)
    public Map<String, Object> setReverseProxyDomainNameQuery(String zimbraReverseProxyDomainNameQuery, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyDomainNameQuery", zimbraReverseProxyDomainNameQuery);
        return attrs;
    }

    @ZAttr(id=545L)
    public void unsetReverseProxyDomainNameQuery() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyDomainNameQuery", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=545L)
    public Map<String, Object> unsetReverseProxyDomainNameQuery(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyDomainNameQuery", "");
        return attrs;
    }

    @ZAttr(id=546L)
    public String getReverseProxyDomainNameSearchBase() {
        return this.getAttr("zimbraReverseProxyDomainNameSearchBase", null);
    }

    @ZAttr(id=546L)
    public void setReverseProxyDomainNameSearchBase(String zimbraReverseProxyDomainNameSearchBase) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyDomainNameSearchBase", zimbraReverseProxyDomainNameSearchBase);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=546L)
    public Map<String, Object> setReverseProxyDomainNameSearchBase(String zimbraReverseProxyDomainNameSearchBase, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyDomainNameSearchBase", zimbraReverseProxyDomainNameSearchBase);
        return attrs;
    }

    @ZAttr(id=546L)
    public void unsetReverseProxyDomainNameSearchBase() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyDomainNameSearchBase", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=546L)
    public Map<String, Object> unsetReverseProxyDomainNameSearchBase(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyDomainNameSearchBase", "");
        return attrs;
    }

    @ZAttr(id=628L)
    public boolean isReverseProxyHttpEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyHttpEnabled", false);
    }

    @ZAttr(id=628L)
    public void setReverseProxyHttpEnabled(boolean zimbraReverseProxyHttpEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyHttpEnabled", zimbraReverseProxyHttpEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=628L)
    public Map<String, Object> setReverseProxyHttpEnabled(boolean zimbraReverseProxyHttpEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyHttpEnabled", zimbraReverseProxyHttpEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=628L)
    public void unsetReverseProxyHttpEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyHttpEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=628L)
    public Map<String, Object> unsetReverseProxyHttpEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyHttpEnabled", "");
        return attrs;
    }

    @ZAttr(id=632L)
    public String getReverseProxyHttpPortAttribute() {
        return this.getAttr("zimbraReverseProxyHttpPortAttribute", "zimbraMailPort");
    }

    @ZAttr(id=632L)
    public void setReverseProxyHttpPortAttribute(String zimbraReverseProxyHttpPortAttribute) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyHttpPortAttribute", zimbraReverseProxyHttpPortAttribute);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=632L)
    public Map<String, Object> setReverseProxyHttpPortAttribute(String zimbraReverseProxyHttpPortAttribute, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyHttpPortAttribute", zimbraReverseProxyHttpPortAttribute);
        return attrs;
    }

    @ZAttr(id=632L)
    public void unsetReverseProxyHttpPortAttribute() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyHttpPortAttribute", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=632L)
    public Map<String, Object> unsetReverseProxyHttpPortAttribute(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyHttpPortAttribute", "");
        return attrs;
    }

    @ZAttr(id=622L)
    public int getReverseProxyIPLoginLimit() {
        return this.getIntAttr("zimbraReverseProxyIPLoginLimit", 0);
    }

    @ZAttr(id=622L)
    public void setReverseProxyIPLoginLimit(int zimbraReverseProxyIPLoginLimit) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyIPLoginLimit", Integer.toString(zimbraReverseProxyIPLoginLimit));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=622L)
    public Map<String, Object> setReverseProxyIPLoginLimit(int zimbraReverseProxyIPLoginLimit, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyIPLoginLimit", Integer.toString(zimbraReverseProxyIPLoginLimit));
        return attrs;
    }

    @ZAttr(id=622L)
    public void unsetReverseProxyIPLoginLimit() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyIPLoginLimit", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=622L)
    public Map<String, Object> unsetReverseProxyIPLoginLimit(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyIPLoginLimit", "");
        return attrs;
    }

    @ZAttr(id=623L)
    public int getReverseProxyIPLoginLimitTime() {
        return this.getIntAttr("zimbraReverseProxyIPLoginLimitTime", 3600);
    }

    @ZAttr(id=623L)
    public void setReverseProxyIPLoginLimitTime(int zimbraReverseProxyIPLoginLimitTime) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyIPLoginLimitTime", Integer.toString(zimbraReverseProxyIPLoginLimitTime));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=623L)
    public Map<String, Object> setReverseProxyIPLoginLimitTime(int zimbraReverseProxyIPLoginLimitTime, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyIPLoginLimitTime", Integer.toString(zimbraReverseProxyIPLoginLimitTime));
        return attrs;
    }

    @ZAttr(id=623L)
    public void unsetReverseProxyIPLoginLimitTime() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyIPLoginLimitTime", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=623L)
    public Map<String, Object> unsetReverseProxyIPLoginLimitTime(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyIPLoginLimitTime", "");
        return attrs;
    }

    @ZAttr(id=719L)
    public String[] getReverseProxyImapEnabledCapability() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraReverseProxyImapEnabledCapability");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[26];
            stringArray2[0] = "IMAP4rev1";
            stringArray2[1] = "ACL";
            stringArray2[2] = "BINARY";
            stringArray2[3] = "CATENATE";
            stringArray2[4] = "CHILDREN";
            stringArray2[5] = "CONDSTORE";
            stringArray2[6] = "ENABLE";
            stringArray2[7] = "ESEARCH";
            stringArray2[8] = "ESORT";
            stringArray2[9] = "I18NLEVEL=1";
            stringArray2[10] = "ID";
            stringArray2[11] = "IDLE";
            stringArray2[12] = "LIST-EXTENDED";
            stringArray2[13] = "LITERAL+";
            stringArray2[14] = "MULTIAPPEND";
            stringArray2[15] = "NAMESPACE";
            stringArray2[16] = "QRESYNC";
            stringArray2[17] = "QUOTA";
            stringArray2[18] = "RIGHTS=ektx";
            stringArray2[19] = "SASL-IR";
            stringArray2[20] = "SEARCHRES";
            stringArray2[21] = "SORT";
            stringArray2[22] = "THREAD=ORDEREDSUBJECT";
            stringArray2[23] = "UIDPLUS";
            stringArray2[24] = "UNSELECT";
            stringArray = stringArray2;
            stringArray2[25] = "WITHIN";
        }
        return stringArray;
    }

    @ZAttr(id=719L)
    public void setReverseProxyImapEnabledCapability(String[] zimbraReverseProxyImapEnabledCapability) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=719L)
    public Map<String, Object> setReverseProxyImapEnabledCapability(String[] zimbraReverseProxyImapEnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        return attrs;
    }

    @ZAttr(id=719L)
    public void addReverseProxyImapEnabledCapability(String zimbraReverseProxyImapEnabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=719L)
    public Map<String, Object> addReverseProxyImapEnabledCapability(String zimbraReverseProxyImapEnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        return attrs;
    }

    @ZAttr(id=719L)
    public void removeReverseProxyImapEnabledCapability(String zimbraReverseProxyImapEnabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=719L)
    public Map<String, Object> removeReverseProxyImapEnabledCapability(String zimbraReverseProxyImapEnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraReverseProxyImapEnabledCapability", zimbraReverseProxyImapEnabledCapability);
        return attrs;
    }

    @ZAttr(id=719L)
    public void unsetReverseProxyImapEnabledCapability() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapEnabledCapability", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=719L)
    public Map<String, Object> unsetReverseProxyImapEnabledCapability(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapEnabledCapability", "");
        return attrs;
    }

    @ZAttr(id=713L)
    public boolean isReverseProxyImapExposeVersionOnBanner() {
        return this.getBooleanAttr("zimbraReverseProxyImapExposeVersionOnBanner", false);
    }

    @ZAttr(id=713L)
    public void setReverseProxyImapExposeVersionOnBanner(boolean zimbraReverseProxyImapExposeVersionOnBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapExposeVersionOnBanner", zimbraReverseProxyImapExposeVersionOnBanner ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=713L)
    public Map<String, Object> setReverseProxyImapExposeVersionOnBanner(boolean zimbraReverseProxyImapExposeVersionOnBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapExposeVersionOnBanner", zimbraReverseProxyImapExposeVersionOnBanner ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=713L)
    public void unsetReverseProxyImapExposeVersionOnBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapExposeVersionOnBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=713L)
    public Map<String, Object> unsetReverseProxyImapExposeVersionOnBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapExposeVersionOnBanner", "");
        return attrs;
    }

    @ZAttr(id=479L)
    public String getReverseProxyImapPortAttribute() {
        return this.getAttr("zimbraReverseProxyImapPortAttribute", "zimbraImapBindPort");
    }

    @ZAttr(id=479L)
    public void setReverseProxyImapPortAttribute(String zimbraReverseProxyImapPortAttribute) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapPortAttribute", zimbraReverseProxyImapPortAttribute);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=479L)
    public Map<String, Object> setReverseProxyImapPortAttribute(String zimbraReverseProxyImapPortAttribute, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapPortAttribute", zimbraReverseProxyImapPortAttribute);
        return attrs;
    }

    @ZAttr(id=479L)
    public void unsetReverseProxyImapPortAttribute() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapPortAttribute", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=479L)
    public Map<String, Object> unsetReverseProxyImapPortAttribute(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapPortAttribute", "");
        return attrs;
    }

    @ZAttr(id=480L)
    public String getReverseProxyImapSSLPortAttribute() {
        return this.getAttr("zimbraReverseProxyImapSSLPortAttribute", "zimbraImapSSLBindPort");
    }

    @ZAttr(id=480L)
    public void setReverseProxyImapSSLPortAttribute(String zimbraReverseProxyImapSSLPortAttribute) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapSSLPortAttribute", zimbraReverseProxyImapSSLPortAttribute);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=480L)
    public Map<String, Object> setReverseProxyImapSSLPortAttribute(String zimbraReverseProxyImapSSLPortAttribute, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapSSLPortAttribute", zimbraReverseProxyImapSSLPortAttribute);
        return attrs;
    }

    @ZAttr(id=480L)
    public void unsetReverseProxyImapSSLPortAttribute() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapSSLPortAttribute", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=480L)
    public Map<String, Object> unsetReverseProxyImapSSLPortAttribute(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapSSLPortAttribute", "");
        return attrs;
    }

    @ZAttr(id=643L)
    public boolean isReverseProxyImapSaslGssapiEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyImapSaslGssapiEnabled", false);
    }

    @ZAttr(id=643L)
    public void setReverseProxyImapSaslGssapiEnabled(boolean zimbraReverseProxyImapSaslGssapiEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapSaslGssapiEnabled", zimbraReverseProxyImapSaslGssapiEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=643L)
    public Map<String, Object> setReverseProxyImapSaslGssapiEnabled(boolean zimbraReverseProxyImapSaslGssapiEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapSaslGssapiEnabled", zimbraReverseProxyImapSaslGssapiEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=643L)
    public void unsetReverseProxyImapSaslGssapiEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapSaslGssapiEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=643L)
    public Map<String, Object> unsetReverseProxyImapSaslGssapiEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapSaslGssapiEnabled", "");
        return attrs;
    }

    @ZAttr(id=728L)
    public boolean isReverseProxyImapSaslPlainEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyImapSaslPlainEnabled", true);
    }

    @ZAttr(id=728L)
    public void setReverseProxyImapSaslPlainEnabled(boolean zimbraReverseProxyImapSaslPlainEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapSaslPlainEnabled", zimbraReverseProxyImapSaslPlainEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=728L)
    public Map<String, Object> setReverseProxyImapSaslPlainEnabled(boolean zimbraReverseProxyImapSaslPlainEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapSaslPlainEnabled", zimbraReverseProxyImapSaslPlainEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=728L)
    public void unsetReverseProxyImapSaslPlainEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapSaslPlainEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=728L)
    public Map<String, Object> unsetReverseProxyImapSaslPlainEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapSaslPlainEnabled", "");
        return attrs;
    }

    @ZAttr(id=641L)
    public ZAttrProvisioning.ReverseProxyImapStartTlsMode getReverseProxyImapStartTlsMode() {
        try {
            String v = this.getAttr("zimbraReverseProxyImapStartTlsMode");
            return v == null ? ZAttrProvisioning.ReverseProxyImapStartTlsMode.only : ZAttrProvisioning.ReverseProxyImapStartTlsMode.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.ReverseProxyImapStartTlsMode.only;
        }
    }

    @ZAttr(id=641L)
    public String getReverseProxyImapStartTlsModeAsString() {
        return this.getAttr("zimbraReverseProxyImapStartTlsMode", "only");
    }

    @ZAttr(id=641L)
    public void setReverseProxyImapStartTlsMode(ZAttrProvisioning.ReverseProxyImapStartTlsMode zimbraReverseProxyImapStartTlsMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapStartTlsMode", zimbraReverseProxyImapStartTlsMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=641L)
    public Map<String, Object> setReverseProxyImapStartTlsMode(ZAttrProvisioning.ReverseProxyImapStartTlsMode zimbraReverseProxyImapStartTlsMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapStartTlsMode", zimbraReverseProxyImapStartTlsMode.toString());
        return attrs;
    }

    @ZAttr(id=641L)
    public void setReverseProxyImapStartTlsModeAsString(String zimbraReverseProxyImapStartTlsMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapStartTlsMode", zimbraReverseProxyImapStartTlsMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=641L)
    public Map<String, Object> setReverseProxyImapStartTlsModeAsString(String zimbraReverseProxyImapStartTlsMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapStartTlsMode", zimbraReverseProxyImapStartTlsMode);
        return attrs;
    }

    @ZAttr(id=641L)
    public void unsetReverseProxyImapStartTlsMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyImapStartTlsMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=641L)
    public Map<String, Object> unsetReverseProxyImapStartTlsMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyImapStartTlsMode", "");
        return attrs;
    }

    @ZAttr(id=735L)
    public long getReverseProxyInactivityTimeout() {
        return this.getTimeInterval("zimbraReverseProxyInactivityTimeout", 3600000L);
    }

    @ZAttr(id=735L)
    public String getReverseProxyInactivityTimeoutAsString() {
        return this.getAttr("zimbraReverseProxyInactivityTimeout", "1h");
    }

    @ZAttr(id=735L)
    public void setReverseProxyInactivityTimeout(String zimbraReverseProxyInactivityTimeout) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyInactivityTimeout", zimbraReverseProxyInactivityTimeout);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=735L)
    public Map<String, Object> setReverseProxyInactivityTimeout(String zimbraReverseProxyInactivityTimeout, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyInactivityTimeout", zimbraReverseProxyInactivityTimeout);
        return attrs;
    }

    @ZAttr(id=735L)
    public void unsetReverseProxyInactivityTimeout() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyInactivityTimeout", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=735L)
    public Map<String, Object> unsetReverseProxyInactivityTimeout(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyInactivityTimeout", "");
        return attrs;
    }

    @ZAttr(id=727L)
    public String getReverseProxyIpThrottleMsg() {
        return this.getAttr("zimbraReverseProxyIpThrottleMsg", "Login rejected from this IP");
    }

    @ZAttr(id=727L)
    public void setReverseProxyIpThrottleMsg(String zimbraReverseProxyIpThrottleMsg) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyIpThrottleMsg", zimbraReverseProxyIpThrottleMsg);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=727L)
    public Map<String, Object> setReverseProxyIpThrottleMsg(String zimbraReverseProxyIpThrottleMsg, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyIpThrottleMsg", zimbraReverseProxyIpThrottleMsg);
        return attrs;
    }

    @ZAttr(id=727L)
    public void unsetReverseProxyIpThrottleMsg() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyIpThrottleMsg", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=727L)
    public Map<String, Object> unsetReverseProxyIpThrottleMsg(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyIpThrottleMsg", "");
        return attrs;
    }

    @ZAttr(id=723L)
    public ZAttrProvisioning.ReverseProxyLogLevel getReverseProxyLogLevel() {
        try {
            String v = this.getAttr("zimbraReverseProxyLogLevel");
            return v == null ? ZAttrProvisioning.ReverseProxyLogLevel.info : ZAttrProvisioning.ReverseProxyLogLevel.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.ReverseProxyLogLevel.info;
        }
    }

    @ZAttr(id=723L)
    public String getReverseProxyLogLevelAsString() {
        return this.getAttr("zimbraReverseProxyLogLevel", "info");
    }

    @ZAttr(id=723L)
    public void setReverseProxyLogLevel(ZAttrProvisioning.ReverseProxyLogLevel zimbraReverseProxyLogLevel) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyLogLevel", zimbraReverseProxyLogLevel.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=723L)
    public Map<String, Object> setReverseProxyLogLevel(ZAttrProvisioning.ReverseProxyLogLevel zimbraReverseProxyLogLevel, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyLogLevel", zimbraReverseProxyLogLevel.toString());
        return attrs;
    }

    @ZAttr(id=723L)
    public void setReverseProxyLogLevelAsString(String zimbraReverseProxyLogLevel) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyLogLevel", zimbraReverseProxyLogLevel);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=723L)
    public Map<String, Object> setReverseProxyLogLevelAsString(String zimbraReverseProxyLogLevel, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyLogLevel", zimbraReverseProxyLogLevel);
        return attrs;
    }

    @ZAttr(id=723L)
    public void unsetReverseProxyLogLevel() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyLogLevel", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=723L)
    public Map<String, Object> unsetReverseProxyLogLevel(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyLogLevel", "");
        return attrs;
    }

    @ZAttr(id=504L)
    public boolean isReverseProxyLookupTarget() {
        return this.getBooleanAttr("zimbraReverseProxyLookupTarget", false);
    }

    @ZAttr(id=504L)
    public void setReverseProxyLookupTarget(boolean zimbraReverseProxyLookupTarget) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyLookupTarget", zimbraReverseProxyLookupTarget ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=504L)
    public Map<String, Object> setReverseProxyLookupTarget(boolean zimbraReverseProxyLookupTarget, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyLookupTarget", zimbraReverseProxyLookupTarget ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=504L)
    public void unsetReverseProxyLookupTarget() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyLookupTarget", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=504L)
    public Map<String, Object> unsetReverseProxyLookupTarget(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyLookupTarget", "");
        return attrs;
    }

    @ZAttr(id=629L)
    public boolean isReverseProxyMailEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyMailEnabled", true);
    }

    @ZAttr(id=629L)
    public void setReverseProxyMailEnabled(boolean zimbraReverseProxyMailEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailEnabled", zimbraReverseProxyMailEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=629L)
    public Map<String, Object> setReverseProxyMailEnabled(boolean zimbraReverseProxyMailEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailEnabled", zimbraReverseProxyMailEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=629L)
    public void unsetReverseProxyMailEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=629L)
    public Map<String, Object> unsetReverseProxyMailEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailEnabled", "");
        return attrs;
    }

    @ZAttr(id=474L)
    public String getReverseProxyMailHostAttribute() {
        return this.getAttr("zimbraReverseProxyMailHostAttribute", "zimbraMailHost");
    }

    @ZAttr(id=474L)
    public void setReverseProxyMailHostAttribute(String zimbraReverseProxyMailHostAttribute) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailHostAttribute", zimbraReverseProxyMailHostAttribute);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=474L)
    public Map<String, Object> setReverseProxyMailHostAttribute(String zimbraReverseProxyMailHostAttribute, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailHostAttribute", zimbraReverseProxyMailHostAttribute);
        return attrs;
    }

    @ZAttr(id=474L)
    public void unsetReverseProxyMailHostAttribute() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailHostAttribute", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=474L)
    public Map<String, Object> unsetReverseProxyMailHostAttribute(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailHostAttribute", "");
        return attrs;
    }

    @ZAttr(id=472L)
    public String getReverseProxyMailHostQuery() {
        return this.getAttr("zimbraReverseProxyMailHostQuery", "(|(zimbraMailDeliveryAddress=${USER})(zimbraMailAlias=${USER})(zimbraId=${USER}))");
    }

    @ZAttr(id=472L)
    public void setReverseProxyMailHostQuery(String zimbraReverseProxyMailHostQuery) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailHostQuery", zimbraReverseProxyMailHostQuery);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=472L)
    public Map<String, Object> setReverseProxyMailHostQuery(String zimbraReverseProxyMailHostQuery, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailHostQuery", zimbraReverseProxyMailHostQuery);
        return attrs;
    }

    @ZAttr(id=472L)
    public void unsetReverseProxyMailHostQuery() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailHostQuery", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=472L)
    public Map<String, Object> unsetReverseProxyMailHostQuery(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailHostQuery", "");
        return attrs;
    }

    @ZAttr(id=473L)
    public String getReverseProxyMailHostSearchBase() {
        return this.getAttr("zimbraReverseProxyMailHostSearchBase", null);
    }

    @ZAttr(id=473L)
    public void setReverseProxyMailHostSearchBase(String zimbraReverseProxyMailHostSearchBase) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailHostSearchBase", zimbraReverseProxyMailHostSearchBase);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=473L)
    public Map<String, Object> setReverseProxyMailHostSearchBase(String zimbraReverseProxyMailHostSearchBase, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailHostSearchBase", zimbraReverseProxyMailHostSearchBase);
        return attrs;
    }

    @ZAttr(id=473L)
    public void unsetReverseProxyMailHostSearchBase() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailHostSearchBase", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=473L)
    public Map<String, Object> unsetReverseProxyMailHostSearchBase(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailHostSearchBase", "");
        return attrs;
    }

    @ZAttr(id=685L)
    public ZAttrProvisioning.ReverseProxyMailMode getReverseProxyMailMode() {
        try {
            String v = this.getAttr("zimbraReverseProxyMailMode");
            return v == null ? null : ZAttrProvisioning.ReverseProxyMailMode.fromString(v);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @ZAttr(id=685L)
    public String getReverseProxyMailModeAsString() {
        return this.getAttr("zimbraReverseProxyMailMode", null);
    }

    @ZAttr(id=685L)
    public void setReverseProxyMailMode(ZAttrProvisioning.ReverseProxyMailMode zimbraReverseProxyMailMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailMode", zimbraReverseProxyMailMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=685L)
    public Map<String, Object> setReverseProxyMailMode(ZAttrProvisioning.ReverseProxyMailMode zimbraReverseProxyMailMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailMode", zimbraReverseProxyMailMode.toString());
        return attrs;
    }

    @ZAttr(id=685L)
    public void setReverseProxyMailModeAsString(String zimbraReverseProxyMailMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailMode", zimbraReverseProxyMailMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=685L)
    public Map<String, Object> setReverseProxyMailModeAsString(String zimbraReverseProxyMailMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailMode", zimbraReverseProxyMailMode);
        return attrs;
    }

    @ZAttr(id=685L)
    public void unsetReverseProxyMailMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyMailMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=685L)
    public Map<String, Object> unsetReverseProxyMailMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyMailMode", "");
        return attrs;
    }

    @ZAttr(id=736L)
    public boolean isReverseProxyPassErrors() {
        return this.getBooleanAttr("zimbraReverseProxyPassErrors", true);
    }

    @ZAttr(id=736L)
    public void setReverseProxyPassErrors(boolean zimbraReverseProxyPassErrors) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPassErrors", zimbraReverseProxyPassErrors ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=736L)
    public Map<String, Object> setReverseProxyPassErrors(boolean zimbraReverseProxyPassErrors, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPassErrors", zimbraReverseProxyPassErrors ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=736L)
    public void unsetReverseProxyPassErrors() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPassErrors", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=736L)
    public Map<String, Object> unsetReverseProxyPassErrors(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPassErrors", "");
        return attrs;
    }

    @ZAttr(id=721L)
    public String[] getReverseProxyPop3EnabledCapability() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraReverseProxyPop3EnabledCapability");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "TOP";
            stringArray2[1] = "USER";
            stringArray2[2] = "UIDL";
            stringArray2[3] = "EXPIRE 31 USER";
            stringArray = stringArray2;
            stringArray2[4] = "XOIP";
        }
        return stringArray;
    }

    @ZAttr(id=721L)
    public void setReverseProxyPop3EnabledCapability(String[] zimbraReverseProxyPop3EnabledCapability) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=721L)
    public Map<String, Object> setReverseProxyPop3EnabledCapability(String[] zimbraReverseProxyPop3EnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        return attrs;
    }

    @ZAttr(id=721L)
    public void addReverseProxyPop3EnabledCapability(String zimbraReverseProxyPop3EnabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=721L)
    public Map<String, Object> addReverseProxyPop3EnabledCapability(String zimbraReverseProxyPop3EnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        return attrs;
    }

    @ZAttr(id=721L)
    public void removeReverseProxyPop3EnabledCapability(String zimbraReverseProxyPop3EnabledCapability) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=721L)
    public Map<String, Object> removeReverseProxyPop3EnabledCapability(String zimbraReverseProxyPop3EnabledCapability, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraReverseProxyPop3EnabledCapability", zimbraReverseProxyPop3EnabledCapability);
        return attrs;
    }

    @ZAttr(id=721L)
    public void unsetReverseProxyPop3EnabledCapability() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3EnabledCapability", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=721L)
    public Map<String, Object> unsetReverseProxyPop3EnabledCapability(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3EnabledCapability", "");
        return attrs;
    }

    @ZAttr(id=712L)
    public boolean isReverseProxyPop3ExposeVersionOnBanner() {
        return this.getBooleanAttr("zimbraReverseProxyPop3ExposeVersionOnBanner", false);
    }

    @ZAttr(id=712L)
    public void setReverseProxyPop3ExposeVersionOnBanner(boolean zimbraReverseProxyPop3ExposeVersionOnBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3ExposeVersionOnBanner", zimbraReverseProxyPop3ExposeVersionOnBanner ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=712L)
    public Map<String, Object> setReverseProxyPop3ExposeVersionOnBanner(boolean zimbraReverseProxyPop3ExposeVersionOnBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3ExposeVersionOnBanner", zimbraReverseProxyPop3ExposeVersionOnBanner ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=712L)
    public void unsetReverseProxyPop3ExposeVersionOnBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3ExposeVersionOnBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=712L)
    public Map<String, Object> unsetReverseProxyPop3ExposeVersionOnBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3ExposeVersionOnBanner", "");
        return attrs;
    }

    @ZAttr(id=477L)
    public String getReverseProxyPop3PortAttribute() {
        return this.getAttr("zimbraReverseProxyPop3PortAttribute", "zimbraPop3BindPort");
    }

    @ZAttr(id=477L)
    public void setReverseProxyPop3PortAttribute(String zimbraReverseProxyPop3PortAttribute) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3PortAttribute", zimbraReverseProxyPop3PortAttribute);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=477L)
    public Map<String, Object> setReverseProxyPop3PortAttribute(String zimbraReverseProxyPop3PortAttribute, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3PortAttribute", zimbraReverseProxyPop3PortAttribute);
        return attrs;
    }

    @ZAttr(id=477L)
    public void unsetReverseProxyPop3PortAttribute() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3PortAttribute", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=477L)
    public Map<String, Object> unsetReverseProxyPop3PortAttribute(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3PortAttribute", "");
        return attrs;
    }

    @ZAttr(id=478L)
    public String getReverseProxyPop3SSLPortAttribute() {
        return this.getAttr("zimbraReverseProxyPop3SSLPortAttribute", "zimbraPop3SSLBindPort");
    }

    @ZAttr(id=478L)
    public void setReverseProxyPop3SSLPortAttribute(String zimbraReverseProxyPop3SSLPortAttribute) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3SSLPortAttribute", zimbraReverseProxyPop3SSLPortAttribute);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=478L)
    public Map<String, Object> setReverseProxyPop3SSLPortAttribute(String zimbraReverseProxyPop3SSLPortAttribute, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3SSLPortAttribute", zimbraReverseProxyPop3SSLPortAttribute);
        return attrs;
    }

    @ZAttr(id=478L)
    public void unsetReverseProxyPop3SSLPortAttribute() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3SSLPortAttribute", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=478L)
    public Map<String, Object> unsetReverseProxyPop3SSLPortAttribute(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3SSLPortAttribute", "");
        return attrs;
    }

    @ZAttr(id=644L)
    public boolean isReverseProxyPop3SaslGssapiEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyPop3SaslGssapiEnabled", false);
    }

    @ZAttr(id=644L)
    public void setReverseProxyPop3SaslGssapiEnabled(boolean zimbraReverseProxyPop3SaslGssapiEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3SaslGssapiEnabled", zimbraReverseProxyPop3SaslGssapiEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=644L)
    public Map<String, Object> setReverseProxyPop3SaslGssapiEnabled(boolean zimbraReverseProxyPop3SaslGssapiEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3SaslGssapiEnabled", zimbraReverseProxyPop3SaslGssapiEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=644L)
    public void unsetReverseProxyPop3SaslGssapiEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3SaslGssapiEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=644L)
    public Map<String, Object> unsetReverseProxyPop3SaslGssapiEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3SaslGssapiEnabled", "");
        return attrs;
    }

    @ZAttr(id=729L)
    public boolean isReverseProxyPop3SaslPlainEnabled() {
        return this.getBooleanAttr("zimbraReverseProxyPop3SaslPlainEnabled", true);
    }

    @ZAttr(id=729L)
    public void setReverseProxyPop3SaslPlainEnabled(boolean zimbraReverseProxyPop3SaslPlainEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3SaslPlainEnabled", zimbraReverseProxyPop3SaslPlainEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=729L)
    public Map<String, Object> setReverseProxyPop3SaslPlainEnabled(boolean zimbraReverseProxyPop3SaslPlainEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3SaslPlainEnabled", zimbraReverseProxyPop3SaslPlainEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=729L)
    public void unsetReverseProxyPop3SaslPlainEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3SaslPlainEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=729L)
    public Map<String, Object> unsetReverseProxyPop3SaslPlainEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3SaslPlainEnabled", "");
        return attrs;
    }

    @ZAttr(id=642L)
    public ZAttrProvisioning.ReverseProxyPop3StartTlsMode getReverseProxyPop3StartTlsMode() {
        try {
            String v = this.getAttr("zimbraReverseProxyPop3StartTlsMode");
            return v == null ? ZAttrProvisioning.ReverseProxyPop3StartTlsMode.only : ZAttrProvisioning.ReverseProxyPop3StartTlsMode.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.ReverseProxyPop3StartTlsMode.only;
        }
    }

    @ZAttr(id=642L)
    public String getReverseProxyPop3StartTlsModeAsString() {
        return this.getAttr("zimbraReverseProxyPop3StartTlsMode", "only");
    }

    @ZAttr(id=642L)
    public void setReverseProxyPop3StartTlsMode(ZAttrProvisioning.ReverseProxyPop3StartTlsMode zimbraReverseProxyPop3StartTlsMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3StartTlsMode", zimbraReverseProxyPop3StartTlsMode.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=642L)
    public Map<String, Object> setReverseProxyPop3StartTlsMode(ZAttrProvisioning.ReverseProxyPop3StartTlsMode zimbraReverseProxyPop3StartTlsMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3StartTlsMode", zimbraReverseProxyPop3StartTlsMode.toString());
        return attrs;
    }

    @ZAttr(id=642L)
    public void setReverseProxyPop3StartTlsModeAsString(String zimbraReverseProxyPop3StartTlsMode) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3StartTlsMode", zimbraReverseProxyPop3StartTlsMode);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=642L)
    public Map<String, Object> setReverseProxyPop3StartTlsModeAsString(String zimbraReverseProxyPop3StartTlsMode, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3StartTlsMode", zimbraReverseProxyPop3StartTlsMode);
        return attrs;
    }

    @ZAttr(id=642L)
    public void unsetReverseProxyPop3StartTlsMode() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPop3StartTlsMode", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=642L)
    public Map<String, Object> unsetReverseProxyPop3StartTlsMode(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPop3StartTlsMode", "");
        return attrs;
    }

    @ZAttr(id=475L)
    public String getReverseProxyPortQuery() {
        return this.getAttr("zimbraReverseProxyPortQuery", "(&(zimbraServiceHostname=${MAILHOST})(objectClass=zimbraServer))");
    }

    @ZAttr(id=475L)
    public void setReverseProxyPortQuery(String zimbraReverseProxyPortQuery) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPortQuery", zimbraReverseProxyPortQuery);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=475L)
    public Map<String, Object> setReverseProxyPortQuery(String zimbraReverseProxyPortQuery, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPortQuery", zimbraReverseProxyPortQuery);
        return attrs;
    }

    @ZAttr(id=475L)
    public void unsetReverseProxyPortQuery() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPortQuery", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=475L)
    public Map<String, Object> unsetReverseProxyPortQuery(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPortQuery", "");
        return attrs;
    }

    @ZAttr(id=476L)
    public String getReverseProxyPortSearchBase() {
        return this.getAttr("zimbraReverseProxyPortSearchBase", null);
    }

    @ZAttr(id=476L)
    public void setReverseProxyPortSearchBase(String zimbraReverseProxyPortSearchBase) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPortSearchBase", zimbraReverseProxyPortSearchBase);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=476L)
    public Map<String, Object> setReverseProxyPortSearchBase(String zimbraReverseProxyPortSearchBase, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPortSearchBase", zimbraReverseProxyPortSearchBase);
        return attrs;
    }

    @ZAttr(id=476L)
    public void unsetReverseProxyPortSearchBase() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyPortSearchBase", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=476L)
    public Map<String, Object> unsetReverseProxyPortSearchBase(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyPortSearchBase", "");
        return attrs;
    }

    @ZAttr(id=745L)
    public long getReverseProxyRouteLookupTimeout() {
        return this.getTimeInterval("zimbraReverseProxyRouteLookupTimeout", 15000L);
    }

    @ZAttr(id=745L)
    public String getReverseProxyRouteLookupTimeoutAsString() {
        return this.getAttr("zimbraReverseProxyRouteLookupTimeout", "15s");
    }

    @ZAttr(id=745L)
    public void setReverseProxyRouteLookupTimeout(String zimbraReverseProxyRouteLookupTimeout) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyRouteLookupTimeout", zimbraReverseProxyRouteLookupTimeout);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=745L)
    public Map<String, Object> setReverseProxyRouteLookupTimeout(String zimbraReverseProxyRouteLookupTimeout, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyRouteLookupTimeout", zimbraReverseProxyRouteLookupTimeout);
        return attrs;
    }

    @ZAttr(id=745L)
    public void unsetReverseProxyRouteLookupTimeout() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyRouteLookupTimeout", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=745L)
    public Map<String, Object> unsetReverseProxyRouteLookupTimeout(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyRouteLookupTimeout", "");
        return attrs;
    }

    @ZAttr(id=778L)
    public long getReverseProxyRouteLookupTimeoutCache() {
        return this.getTimeInterval("zimbraReverseProxyRouteLookupTimeoutCache", 60000L);
    }

    @ZAttr(id=778L)
    public String getReverseProxyRouteLookupTimeoutCacheAsString() {
        return this.getAttr("zimbraReverseProxyRouteLookupTimeoutCache", "60s");
    }

    @ZAttr(id=778L)
    public void setReverseProxyRouteLookupTimeoutCache(String zimbraReverseProxyRouteLookupTimeoutCache) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyRouteLookupTimeoutCache", zimbraReverseProxyRouteLookupTimeoutCache);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=778L)
    public Map<String, Object> setReverseProxyRouteLookupTimeoutCache(String zimbraReverseProxyRouteLookupTimeoutCache, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyRouteLookupTimeoutCache", zimbraReverseProxyRouteLookupTimeoutCache);
        return attrs;
    }

    @ZAttr(id=778L)
    public void unsetReverseProxyRouteLookupTimeoutCache() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyRouteLookupTimeoutCache", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=778L)
    public Map<String, Object> unsetReverseProxyRouteLookupTimeoutCache(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyRouteLookupTimeoutCache", "");
        return attrs;
    }

    @ZAttr(id=640L)
    public String getReverseProxySSLCiphers() {
        return this.getAttr("zimbraReverseProxySSLCiphers", "!SSLv2:!MD5:HIGH");
    }

    @ZAttr(id=640L)
    public void setReverseProxySSLCiphers(String zimbraReverseProxySSLCiphers) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxySSLCiphers", zimbraReverseProxySSLCiphers);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=640L)
    public Map<String, Object> setReverseProxySSLCiphers(String zimbraReverseProxySSLCiphers, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxySSLCiphers", zimbraReverseProxySSLCiphers);
        return attrs;
    }

    @ZAttr(id=640L)
    public void unsetReverseProxySSLCiphers() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxySSLCiphers", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=640L)
    public Map<String, Object> unsetReverseProxySSLCiphers(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxySSLCiphers", "");
        return attrs;
    }

    @ZAttr(id=588L)
    public boolean isReverseProxySendImapId() {
        return this.getBooleanAttr("zimbraReverseProxySendImapId", true);
    }

    @ZAttr(id=588L)
    public void setReverseProxySendImapId(boolean zimbraReverseProxySendImapId) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxySendImapId", zimbraReverseProxySendImapId ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=588L)
    public Map<String, Object> setReverseProxySendImapId(boolean zimbraReverseProxySendImapId, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxySendImapId", zimbraReverseProxySendImapId ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=588L)
    public void unsetReverseProxySendImapId() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxySendImapId", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=588L)
    public Map<String, Object> unsetReverseProxySendImapId(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxySendImapId", "");
        return attrs;
    }

    @ZAttr(id=587L)
    public boolean isReverseProxySendPop3Xoip() {
        return this.getBooleanAttr("zimbraReverseProxySendPop3Xoip", true);
    }

    @ZAttr(id=587L)
    public void setReverseProxySendPop3Xoip(boolean zimbraReverseProxySendPop3Xoip) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxySendPop3Xoip", zimbraReverseProxySendPop3Xoip ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=587L)
    public Map<String, Object> setReverseProxySendPop3Xoip(boolean zimbraReverseProxySendPop3Xoip, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxySendPop3Xoip", zimbraReverseProxySendPop3Xoip ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=587L)
    public void unsetReverseProxySendPop3Xoip() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxySendPop3Xoip", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=587L)
    public Map<String, Object> unsetReverseProxySendPop3Xoip(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxySendPop3Xoip", "");
        return attrs;
    }

    @ZAttr(id=624L)
    public int getReverseProxyUserLoginLimit() {
        return this.getIntAttr("zimbraReverseProxyUserLoginLimit", 0);
    }

    @ZAttr(id=624L)
    public void setReverseProxyUserLoginLimit(int zimbraReverseProxyUserLoginLimit) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyUserLoginLimit", Integer.toString(zimbraReverseProxyUserLoginLimit));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=624L)
    public Map<String, Object> setReverseProxyUserLoginLimit(int zimbraReverseProxyUserLoginLimit, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyUserLoginLimit", Integer.toString(zimbraReverseProxyUserLoginLimit));
        return attrs;
    }

    @ZAttr(id=624L)
    public void unsetReverseProxyUserLoginLimit() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyUserLoginLimit", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=624L)
    public Map<String, Object> unsetReverseProxyUserLoginLimit(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyUserLoginLimit", "");
        return attrs;
    }

    @ZAttr(id=625L)
    public int getReverseProxyUserLoginLimitTime() {
        return this.getIntAttr("zimbraReverseProxyUserLoginLimitTime", 3600);
    }

    @ZAttr(id=625L)
    public void setReverseProxyUserLoginLimitTime(int zimbraReverseProxyUserLoginLimitTime) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyUserLoginLimitTime", Integer.toString(zimbraReverseProxyUserLoginLimitTime));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=625L)
    public Map<String, Object> setReverseProxyUserLoginLimitTime(int zimbraReverseProxyUserLoginLimitTime, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyUserLoginLimitTime", Integer.toString(zimbraReverseProxyUserLoginLimitTime));
        return attrs;
    }

    @ZAttr(id=625L)
    public void unsetReverseProxyUserLoginLimitTime() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyUserLoginLimitTime", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=625L)
    public Map<String, Object> unsetReverseProxyUserLoginLimitTime(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyUserLoginLimitTime", "");
        return attrs;
    }

    @ZAttr(id=572L)
    public String getReverseProxyUserNameAttribute() {
        return this.getAttr("zimbraReverseProxyUserNameAttribute", null);
    }

    @ZAttr(id=572L)
    public void setReverseProxyUserNameAttribute(String zimbraReverseProxyUserNameAttribute) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyUserNameAttribute", zimbraReverseProxyUserNameAttribute);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=572L)
    public Map<String, Object> setReverseProxyUserNameAttribute(String zimbraReverseProxyUserNameAttribute, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyUserNameAttribute", zimbraReverseProxyUserNameAttribute);
        return attrs;
    }

    @ZAttr(id=572L)
    public void unsetReverseProxyUserNameAttribute() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyUserNameAttribute", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=572L)
    public Map<String, Object> unsetReverseProxyUserNameAttribute(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyUserNameAttribute", "");
        return attrs;
    }

    @ZAttr(id=726L)
    public String getReverseProxyUserThrottleMsg() {
        return this.getAttr("zimbraReverseProxyUserThrottleMsg", "Login rejected for this user");
    }

    @ZAttr(id=726L)
    public void setReverseProxyUserThrottleMsg(String zimbraReverseProxyUserThrottleMsg) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyUserThrottleMsg", zimbraReverseProxyUserThrottleMsg);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=726L)
    public Map<String, Object> setReverseProxyUserThrottleMsg(String zimbraReverseProxyUserThrottleMsg, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyUserThrottleMsg", zimbraReverseProxyUserThrottleMsg);
        return attrs;
    }

    @ZAttr(id=726L)
    public void unsetReverseProxyUserThrottleMsg() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyUserThrottleMsg", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=726L)
    public Map<String, Object> unsetReverseProxyUserThrottleMsg(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyUserThrottleMsg", "");
        return attrs;
    }

    @ZAttr(id=725L)
    public int getReverseProxyWorkerConnections() {
        return this.getIntAttr("zimbraReverseProxyWorkerConnections", 10240);
    }

    @ZAttr(id=725L)
    public void setReverseProxyWorkerConnections(int zimbraReverseProxyWorkerConnections) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyWorkerConnections", Integer.toString(zimbraReverseProxyWorkerConnections));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=725L)
    public Map<String, Object> setReverseProxyWorkerConnections(int zimbraReverseProxyWorkerConnections, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyWorkerConnections", Integer.toString(zimbraReverseProxyWorkerConnections));
        return attrs;
    }

    @ZAttr(id=725L)
    public void unsetReverseProxyWorkerConnections() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyWorkerConnections", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=725L)
    public Map<String, Object> unsetReverseProxyWorkerConnections(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyWorkerConnections", "");
        return attrs;
    }

    @ZAttr(id=724L)
    public int getReverseProxyWorkerProcesses() {
        return this.getIntAttr("zimbraReverseProxyWorkerProcesses", 4);
    }

    @ZAttr(id=724L)
    public void setReverseProxyWorkerProcesses(int zimbraReverseProxyWorkerProcesses) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyWorkerProcesses", Integer.toString(zimbraReverseProxyWorkerProcesses));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=724L)
    public Map<String, Object> setReverseProxyWorkerProcesses(int zimbraReverseProxyWorkerProcesses, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyWorkerProcesses", Integer.toString(zimbraReverseProxyWorkerProcesses));
        return attrs;
    }

    @ZAttr(id=724L)
    public void unsetReverseProxyWorkerProcesses() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraReverseProxyWorkerProcesses", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=724L)
    public Map<String, Object> unsetReverseProxyWorkerProcesses(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraReverseProxyWorkerProcesses", "");
        return attrs;
    }

    @ZAttr(id=563L)
    public String getSSLCertificate() {
        return this.getAttr("zimbraSSLCertificate", null);
    }

    @ZAttr(id=563L)
    public void setSSLCertificate(String zimbraSSLCertificate) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSSLCertificate", zimbraSSLCertificate);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=563L)
    public Map<String, Object> setSSLCertificate(String zimbraSSLCertificate, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSSLCertificate", zimbraSSLCertificate);
        return attrs;
    }

    @ZAttr(id=563L)
    public void unsetSSLCertificate() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSSLCertificate", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=563L)
    public Map<String, Object> unsetSSLCertificate(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSSLCertificate", "");
        return attrs;
    }

    @ZAttr(id=639L)
    public String[] getSSLExcludeCipherSuites() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraSSLExcludeCipherSuites");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[7];
            stringArray2[0] = "SSL_RSA_WITH_DES_CBC_SHA";
            stringArray2[1] = "SSL_DHE_RSA_WITH_DES_CBC_SHA";
            stringArray2[2] = "SSL_DHE_DSS_WITH_DES_CBC_SHA";
            stringArray2[3] = "SSL_RSA_EXPORT_WITH_RC4_40_MD5";
            stringArray2[4] = "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA";
            stringArray2[5] = "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA";
            stringArray = stringArray2;
            stringArray2[6] = "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA";
        }
        return stringArray;
    }

    @ZAttr(id=639L)
    public void setSSLExcludeCipherSuites(String[] zimbraSSLExcludeCipherSuites) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraSSLExcludeCipherSuites", zimbraSSLExcludeCipherSuites);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=639L)
    public Map<String, Object> setSSLExcludeCipherSuites(String[] zimbraSSLExcludeCipherSuites, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSSLExcludeCipherSuites", zimbraSSLExcludeCipherSuites);
        return attrs;
    }

    @ZAttr(id=639L)
    public void addSSLExcludeCipherSuites(String zimbraSSLExcludeCipherSuites) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraSSLExcludeCipherSuites", zimbraSSLExcludeCipherSuites);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=639L)
    public Map<String, Object> addSSLExcludeCipherSuites(String zimbraSSLExcludeCipherSuites, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraSSLExcludeCipherSuites", zimbraSSLExcludeCipherSuites);
        return attrs;
    }

    @ZAttr(id=639L)
    public void removeSSLExcludeCipherSuites(String zimbraSSLExcludeCipherSuites) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraSSLExcludeCipherSuites", zimbraSSLExcludeCipherSuites);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=639L)
    public Map<String, Object> removeSSLExcludeCipherSuites(String zimbraSSLExcludeCipherSuites, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraSSLExcludeCipherSuites", zimbraSSLExcludeCipherSuites);
        return attrs;
    }

    @ZAttr(id=639L)
    public void unsetSSLExcludeCipherSuites() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSSLExcludeCipherSuites", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=639L)
    public Map<String, Object> unsetSSLExcludeCipherSuites(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSSLExcludeCipherSuites", "");
        return attrs;
    }

    @ZAttr(id=564L)
    public String getSSLPrivateKey() {
        return this.getAttr("zimbraSSLPrivateKey", null);
    }

    @ZAttr(id=564L)
    public void setSSLPrivateKey(String zimbraSSLPrivateKey) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSSLPrivateKey", zimbraSSLPrivateKey);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=564L)
    public Map<String, Object> setSSLPrivateKey(String zimbraSSLPrivateKey, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSSLPrivateKey", zimbraSSLPrivateKey);
        return attrs;
    }

    @ZAttr(id=564L)
    public void unsetSSLPrivateKey() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSSLPrivateKey", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=564L)
    public Map<String, Object> unsetSSLPrivateKey(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSSLPrivateKey", "");
        return attrs;
    }

    @ZAttr(id=1068L)
    public boolean isSaslGssapiRequiresTls() {
        return this.getBooleanAttr("zimbraSaslGssapiRequiresTls", false);
    }

    @ZAttr(id=1068L)
    public void setSaslGssapiRequiresTls(boolean zimbraSaslGssapiRequiresTls) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSaslGssapiRequiresTls", zimbraSaslGssapiRequiresTls ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1068L)
    public Map<String, Object> setSaslGssapiRequiresTls(boolean zimbraSaslGssapiRequiresTls, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSaslGssapiRequiresTls", zimbraSaslGssapiRequiresTls ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1068L)
    public void unsetSaslGssapiRequiresTls() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSaslGssapiRequiresTls", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1068L)
    public Map<String, Object> unsetSaslGssapiRequiresTls(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSaslGssapiRequiresTls", "");
        return attrs;
    }

    @ZAttr(id=522L)
    public int getScheduledTaskNumThreads() {
        return this.getIntAttr("zimbraScheduledTaskNumThreads", 20);
    }

    @ZAttr(id=522L)
    public void setScheduledTaskNumThreads(int zimbraScheduledTaskNumThreads) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraScheduledTaskNumThreads", Integer.toString(zimbraScheduledTaskNumThreads));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=522L)
    public Map<String, Object> setScheduledTaskNumThreads(int zimbraScheduledTaskNumThreads, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraScheduledTaskNumThreads", Integer.toString(zimbraScheduledTaskNumThreads));
        return attrs;
    }

    @ZAttr(id=522L)
    public void unsetScheduledTaskNumThreads() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraScheduledTaskNumThreads", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=522L)
    public Map<String, Object> unsetScheduledTaskNumThreads(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraScheduledTaskNumThreads", "");
        return attrs;
    }

    @ZAttr(id=756L)
    public String[] getServerExtraObjectClass() {
        return this.getMultiAttr("zimbraServerExtraObjectClass");
    }

    @ZAttr(id=756L)
    public void setServerExtraObjectClass(String[] zimbraServerExtraObjectClass) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraServerExtraObjectClass", zimbraServerExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=756L)
    public Map<String, Object> setServerExtraObjectClass(String[] zimbraServerExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraServerExtraObjectClass", zimbraServerExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=756L)
    public void addServerExtraObjectClass(String zimbraServerExtraObjectClass) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraServerExtraObjectClass", zimbraServerExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=756L)
    public Map<String, Object> addServerExtraObjectClass(String zimbraServerExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraServerExtraObjectClass", zimbraServerExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=756L)
    public void removeServerExtraObjectClass(String zimbraServerExtraObjectClass) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraServerExtraObjectClass", zimbraServerExtraObjectClass);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=756L)
    public Map<String, Object> removeServerExtraObjectClass(String zimbraServerExtraObjectClass, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraServerExtraObjectClass", zimbraServerExtraObjectClass);
        return attrs;
    }

    @ZAttr(id=756L)
    public void unsetServerExtraObjectClass() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraServerExtraObjectClass", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=756L)
    public Map<String, Object> unsetServerExtraObjectClass(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraServerExtraObjectClass", "");
        return attrs;
    }

    @ZAttr(id=62L)
    public String[] getServerInheritedAttr() {
        return this.getMultiAttr("zimbraServerInheritedAttr");
    }

    @ZAttr(id=62L)
    public void setServerInheritedAttr(String[] zimbraServerInheritedAttr) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraServerInheritedAttr", zimbraServerInheritedAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=62L)
    public Map<String, Object> setServerInheritedAttr(String[] zimbraServerInheritedAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraServerInheritedAttr", zimbraServerInheritedAttr);
        return attrs;
    }

    @ZAttr(id=62L)
    public void addServerInheritedAttr(String zimbraServerInheritedAttr) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraServerInheritedAttr", zimbraServerInheritedAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=62L)
    public Map<String, Object> addServerInheritedAttr(String zimbraServerInheritedAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraServerInheritedAttr", zimbraServerInheritedAttr);
        return attrs;
    }

    @ZAttr(id=62L)
    public void removeServerInheritedAttr(String zimbraServerInheritedAttr) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraServerInheritedAttr", zimbraServerInheritedAttr);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=62L)
    public Map<String, Object> removeServerInheritedAttr(String zimbraServerInheritedAttr, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraServerInheritedAttr", zimbraServerInheritedAttr);
        return attrs;
    }

    @ZAttr(id=62L)
    public void unsetServerInheritedAttr() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraServerInheritedAttr", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=62L)
    public Map<String, Object> unsetServerInheritedAttr(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraServerInheritedAttr", "");
        return attrs;
    }

    @ZAttr(id=648L)
    public String getSkinBackgroundColor() {
        return this.getAttr("zimbraSkinBackgroundColor", null);
    }

    @ZAttr(id=648L)
    public void setSkinBackgroundColor(String zimbraSkinBackgroundColor) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinBackgroundColor", zimbraSkinBackgroundColor);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=648L)
    public Map<String, Object> setSkinBackgroundColor(String zimbraSkinBackgroundColor, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinBackgroundColor", zimbraSkinBackgroundColor);
        return attrs;
    }

    @ZAttr(id=648L)
    public void unsetSkinBackgroundColor() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinBackgroundColor", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=648L)
    public Map<String, Object> unsetSkinBackgroundColor(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinBackgroundColor", "");
        return attrs;
    }

    @ZAttr(id=800L)
    public String getSkinFavicon() {
        return this.getAttr("zimbraSkinFavicon", null);
    }

    @ZAttr(id=800L)
    public void setSkinFavicon(String zimbraSkinFavicon) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinFavicon", zimbraSkinFavicon);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=800L)
    public Map<String, Object> setSkinFavicon(String zimbraSkinFavicon, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinFavicon", zimbraSkinFavicon);
        return attrs;
    }

    @ZAttr(id=800L)
    public void unsetSkinFavicon() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinFavicon", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=800L)
    public Map<String, Object> unsetSkinFavicon(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinFavicon", "");
        return attrs;
    }

    @ZAttr(id=647L)
    public String getSkinForegroundColor() {
        return this.getAttr("zimbraSkinForegroundColor", null);
    }

    @ZAttr(id=647L)
    public void setSkinForegroundColor(String zimbraSkinForegroundColor) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinForegroundColor", zimbraSkinForegroundColor);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=647L)
    public Map<String, Object> setSkinForegroundColor(String zimbraSkinForegroundColor, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinForegroundColor", zimbraSkinForegroundColor);
        return attrs;
    }

    @ZAttr(id=647L)
    public void unsetSkinForegroundColor() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinForegroundColor", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=647L)
    public Map<String, Object> unsetSkinForegroundColor(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinForegroundColor", "");
        return attrs;
    }

    @ZAttr(id=671L)
    public String getSkinLogoAppBanner() {
        return this.getAttr("zimbraSkinLogoAppBanner", null);
    }

    @ZAttr(id=671L)
    public void setSkinLogoAppBanner(String zimbraSkinLogoAppBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinLogoAppBanner", zimbraSkinLogoAppBanner);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=671L)
    public Map<String, Object> setSkinLogoAppBanner(String zimbraSkinLogoAppBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinLogoAppBanner", zimbraSkinLogoAppBanner);
        return attrs;
    }

    @ZAttr(id=671L)
    public void unsetSkinLogoAppBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinLogoAppBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=671L)
    public Map<String, Object> unsetSkinLogoAppBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinLogoAppBanner", "");
        return attrs;
    }

    @ZAttr(id=670L)
    public String getSkinLogoLoginBanner() {
        return this.getAttr("zimbraSkinLogoLoginBanner", null);
    }

    @ZAttr(id=670L)
    public void setSkinLogoLoginBanner(String zimbraSkinLogoLoginBanner) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinLogoLoginBanner", zimbraSkinLogoLoginBanner);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=670L)
    public Map<String, Object> setSkinLogoLoginBanner(String zimbraSkinLogoLoginBanner, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinLogoLoginBanner", zimbraSkinLogoLoginBanner);
        return attrs;
    }

    @ZAttr(id=670L)
    public void unsetSkinLogoLoginBanner() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinLogoLoginBanner", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=670L)
    public Map<String, Object> unsetSkinLogoLoginBanner(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinLogoLoginBanner", "");
        return attrs;
    }

    @ZAttr(id=649L)
    public String getSkinLogoURL() {
        return this.getAttr("zimbraSkinLogoURL", null);
    }

    @ZAttr(id=649L)
    public void setSkinLogoURL(String zimbraSkinLogoURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinLogoURL", zimbraSkinLogoURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=649L)
    public Map<String, Object> setSkinLogoURL(String zimbraSkinLogoURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinLogoURL", zimbraSkinLogoURL);
        return attrs;
    }

    @ZAttr(id=649L)
    public void unsetSkinLogoURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinLogoURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=649L)
    public Map<String, Object> unsetSkinLogoURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinLogoURL", "");
        return attrs;
    }

    @ZAttr(id=668L)
    public String getSkinSecondaryColor() {
        return this.getAttr("zimbraSkinSecondaryColor", null);
    }

    @ZAttr(id=668L)
    public void setSkinSecondaryColor(String zimbraSkinSecondaryColor) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinSecondaryColor", zimbraSkinSecondaryColor);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=668L)
    public Map<String, Object> setSkinSecondaryColor(String zimbraSkinSecondaryColor, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinSecondaryColor", zimbraSkinSecondaryColor);
        return attrs;
    }

    @ZAttr(id=668L)
    public void unsetSkinSecondaryColor() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinSecondaryColor", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=668L)
    public Map<String, Object> unsetSkinSecondaryColor(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinSecondaryColor", "");
        return attrs;
    }

    @ZAttr(id=669L)
    public String getSkinSelectionColor() {
        return this.getAttr("zimbraSkinSelectionColor", null);
    }

    @ZAttr(id=669L)
    public void setSkinSelectionColor(String zimbraSkinSelectionColor) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinSelectionColor", zimbraSkinSelectionColor);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=669L)
    public Map<String, Object> setSkinSelectionColor(String zimbraSkinSelectionColor, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinSelectionColor", zimbraSkinSelectionColor);
        return attrs;
    }

    @ZAttr(id=669L)
    public void unsetSkinSelectionColor() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSkinSelectionColor", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=669L)
    public Map<String, Object> unsetSkinSelectionColor(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSkinSelectionColor", "");
        return attrs;
    }

    @ZAttr(id=97L)
    public String[] getSmtpHostname() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraSmtpHostname");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "localhost";
        }
        return stringArray;
    }

    @ZAttr(id=97L)
    public void setSmtpHostname(String[] zimbraSmtpHostname) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraSmtpHostname", zimbraSmtpHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=97L)
    public Map<String, Object> setSmtpHostname(String[] zimbraSmtpHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpHostname", zimbraSmtpHostname);
        return attrs;
    }

    @ZAttr(id=97L)
    public void addSmtpHostname(String zimbraSmtpHostname) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraSmtpHostname", zimbraSmtpHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=97L)
    public Map<String, Object> addSmtpHostname(String zimbraSmtpHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraSmtpHostname", zimbraSmtpHostname);
        return attrs;
    }

    @ZAttr(id=97L)
    public void removeSmtpHostname(String zimbraSmtpHostname) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraSmtpHostname", zimbraSmtpHostname);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=97L)
    public Map<String, Object> removeSmtpHostname(String zimbraSmtpHostname, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraSmtpHostname", zimbraSmtpHostname);
        return attrs;
    }

    @ZAttr(id=97L)
    public void unsetSmtpHostname() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpHostname", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=97L)
    public Map<String, Object> unsetSmtpHostname(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpHostname", "");
        return attrs;
    }

    @ZAttr(id=98L)
    public int getSmtpPort() {
        return this.getIntAttr("zimbraSmtpPort", 25);
    }

    @ZAttr(id=98L)
    public String getSmtpPortAsString() {
        return this.getAttr("zimbraSmtpPort", "25");
    }

    @ZAttr(id=98L)
    public void setSmtpPort(int zimbraSmtpPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpPort", Integer.toString(zimbraSmtpPort));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=98L)
    public Map<String, Object> setSmtpPort(int zimbraSmtpPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpPort", Integer.toString(zimbraSmtpPort));
        return attrs;
    }

    @ZAttr(id=98L)
    public void setSmtpPortAsString(String zimbraSmtpPort) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpPort", zimbraSmtpPort);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=98L)
    public Map<String, Object> setSmtpPortAsString(String zimbraSmtpPort, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpPort", zimbraSmtpPort);
        return attrs;
    }

    @ZAttr(id=98L)
    public void unsetSmtpPort() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpPort", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=98L)
    public Map<String, Object> unsetSmtpPort(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpPort", "");
        return attrs;
    }

    @ZAttr(id=747L)
    public boolean isSmtpSendAddAuthenticatedUser() {
        return this.getBooleanAttr("zimbraSmtpSendAddAuthenticatedUser", false);
    }

    @ZAttr(id=747L)
    public void setSmtpSendAddAuthenticatedUser(boolean zimbraSmtpSendAddAuthenticatedUser) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpSendAddAuthenticatedUser", zimbraSmtpSendAddAuthenticatedUser ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=747L)
    public Map<String, Object> setSmtpSendAddAuthenticatedUser(boolean zimbraSmtpSendAddAuthenticatedUser, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpSendAddAuthenticatedUser", zimbraSmtpSendAddAuthenticatedUser ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=747L)
    public void unsetSmtpSendAddAuthenticatedUser() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpSendAddAuthenticatedUser", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=747L)
    public Map<String, Object> unsetSmtpSendAddAuthenticatedUser(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpSendAddAuthenticatedUser", "");
        return attrs;
    }

    @ZAttr(id=636L)
    public boolean isSmtpSendAddMailer() {
        return this.getBooleanAttr("zimbraSmtpSendAddMailer", true);
    }

    @ZAttr(id=636L)
    public void setSmtpSendAddMailer(boolean zimbraSmtpSendAddMailer) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpSendAddMailer", zimbraSmtpSendAddMailer ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=636L)
    public Map<String, Object> setSmtpSendAddMailer(boolean zimbraSmtpSendAddMailer, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpSendAddMailer", zimbraSmtpSendAddMailer ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=636L)
    public void unsetSmtpSendAddMailer() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpSendAddMailer", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=636L)
    public Map<String, Object> unsetSmtpSendAddMailer(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpSendAddMailer", "");
        return attrs;
    }

    @ZAttr(id=435L)
    public boolean isSmtpSendAddOriginatingIP() {
        return this.getBooleanAttr("zimbraSmtpSendAddOriginatingIP", true);
    }

    @ZAttr(id=435L)
    public void setSmtpSendAddOriginatingIP(boolean zimbraSmtpSendAddOriginatingIP) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpSendAddOriginatingIP", zimbraSmtpSendAddOriginatingIP ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=435L)
    public Map<String, Object> setSmtpSendAddOriginatingIP(boolean zimbraSmtpSendAddOriginatingIP, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpSendAddOriginatingIP", zimbraSmtpSendAddOriginatingIP ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=435L)
    public void unsetSmtpSendAddOriginatingIP() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpSendAddOriginatingIP", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=435L)
    public Map<String, Object> unsetSmtpSendAddOriginatingIP(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpSendAddOriginatingIP", "");
        return attrs;
    }

    @ZAttr(id=249L)
    public boolean isSmtpSendPartial() {
        return this.getBooleanAttr("zimbraSmtpSendPartial", false);
    }

    @ZAttr(id=249L)
    public void setSmtpSendPartial(boolean zimbraSmtpSendPartial) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpSendPartial", zimbraSmtpSendPartial ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=249L)
    public Map<String, Object> setSmtpSendPartial(boolean zimbraSmtpSendPartial, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpSendPartial", zimbraSmtpSendPartial ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=249L)
    public void unsetSmtpSendPartial() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpSendPartial", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=249L)
    public Map<String, Object> unsetSmtpSendPartial(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpSendPartial", "");
        return attrs;
    }

    @ZAttr(id=99L)
    public int getSmtpTimeout() {
        return this.getIntAttr("zimbraSmtpTimeout", 60);
    }

    @ZAttr(id=99L)
    public void setSmtpTimeout(int zimbraSmtpTimeout) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpTimeout", Integer.toString(zimbraSmtpTimeout));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=99L)
    public Map<String, Object> setSmtpTimeout(int zimbraSmtpTimeout, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpTimeout", Integer.toString(zimbraSmtpTimeout));
        return attrs;
    }

    @ZAttr(id=99L)
    public void unsetSmtpTimeout() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSmtpTimeout", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=99L)
    public Map<String, Object> unsetSmtpTimeout(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSmtpTimeout", "");
        return attrs;
    }

    @ZAttr(id=708L)
    public boolean isSoapExposeVersion() {
        return this.getBooleanAttr("zimbraSoapExposeVersion", false);
    }

    @ZAttr(id=708L)
    public void setSoapExposeVersion(boolean zimbraSoapExposeVersion) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSoapExposeVersion", zimbraSoapExposeVersion ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=708L)
    public Map<String, Object> setSoapExposeVersion(boolean zimbraSoapExposeVersion, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSoapExposeVersion", zimbraSoapExposeVersion ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=708L)
    public void unsetSoapExposeVersion() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSoapExposeVersion", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=708L)
    public Map<String, Object> unsetSoapExposeVersion(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSoapExposeVersion", "");
        return attrs;
    }

    @ZAttr(id=557L)
    public int getSoapRequestMaxSize() {
        return this.getIntAttr("zimbraSoapRequestMaxSize", 15360000);
    }

    @ZAttr(id=557L)
    public void setSoapRequestMaxSize(int zimbraSoapRequestMaxSize) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSoapRequestMaxSize", Integer.toString(zimbraSoapRequestMaxSize));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=557L)
    public Map<String, Object> setSoapRequestMaxSize(int zimbraSoapRequestMaxSize, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSoapRequestMaxSize", Integer.toString(zimbraSoapRequestMaxSize));
        return attrs;
    }

    @ZAttr(id=557L)
    public void unsetSoapRequestMaxSize() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSoapRequestMaxSize", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=557L)
    public Map<String, Object> unsetSoapRequestMaxSize(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSoapRequestMaxSize", "");
        return attrs;
    }

    @ZAttr(id=201L)
    public boolean isSpamCheckEnabled() {
        return this.getBooleanAttr("zimbraSpamCheckEnabled", false);
    }

    @ZAttr(id=201L)
    public void setSpamCheckEnabled(boolean zimbraSpamCheckEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamCheckEnabled", zimbraSpamCheckEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=201L)
    public Map<String, Object> setSpamCheckEnabled(boolean zimbraSpamCheckEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamCheckEnabled", zimbraSpamCheckEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=201L)
    public void unsetSpamCheckEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamCheckEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=201L)
    public Map<String, Object> unsetSpamCheckEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamCheckEnabled", "");
        return attrs;
    }

    @ZAttr(id=210L)
    public String getSpamHeader() {
        return this.getAttr("zimbraSpamHeader", "X-Spam-Flag");
    }

    @ZAttr(id=210L)
    public void setSpamHeader(String zimbraSpamHeader) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamHeader", zimbraSpamHeader);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=210L)
    public Map<String, Object> setSpamHeader(String zimbraSpamHeader, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamHeader", zimbraSpamHeader);
        return attrs;
    }

    @ZAttr(id=210L)
    public void unsetSpamHeader() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamHeader", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=210L)
    public Map<String, Object> unsetSpamHeader(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamHeader", "");
        return attrs;
    }

    @ZAttr(id=211L)
    public String getSpamHeaderValue() {
        return this.getAttr("zimbraSpamHeaderValue", "YES");
    }

    @ZAttr(id=211L)
    public void setSpamHeaderValue(String zimbraSpamHeaderValue) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamHeaderValue", zimbraSpamHeaderValue);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=211L)
    public Map<String, Object> setSpamHeaderValue(String zimbraSpamHeaderValue, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamHeaderValue", zimbraSpamHeaderValue);
        return attrs;
    }

    @ZAttr(id=211L)
    public void unsetSpamHeaderValue() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamHeaderValue", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=211L)
    public Map<String, Object> unsetSpamHeaderValue(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamHeaderValue", "");
        return attrs;
    }

    @ZAttr(id=245L)
    public String getSpamIsNotSpamAccount() {
        return this.getAttr("zimbraSpamIsNotSpamAccount", null);
    }

    @ZAttr(id=245L)
    public void setSpamIsNotSpamAccount(String zimbraSpamIsNotSpamAccount) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamIsNotSpamAccount", zimbraSpamIsNotSpamAccount);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=245L)
    public Map<String, Object> setSpamIsNotSpamAccount(String zimbraSpamIsNotSpamAccount, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamIsNotSpamAccount", zimbraSpamIsNotSpamAccount);
        return attrs;
    }

    @ZAttr(id=245L)
    public void unsetSpamIsNotSpamAccount() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamIsNotSpamAccount", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=245L)
    public Map<String, Object> unsetSpamIsNotSpamAccount(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamIsNotSpamAccount", "");
        return attrs;
    }

    @ZAttr(id=244L)
    public String getSpamIsSpamAccount() {
        return this.getAttr("zimbraSpamIsSpamAccount", null);
    }

    @ZAttr(id=244L)
    public void setSpamIsSpamAccount(String zimbraSpamIsSpamAccount) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamIsSpamAccount", zimbraSpamIsSpamAccount);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=244L)
    public Map<String, Object> setSpamIsSpamAccount(String zimbraSpamIsSpamAccount, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamIsSpamAccount", zimbraSpamIsSpamAccount);
        return attrs;
    }

    @ZAttr(id=244L)
    public void unsetSpamIsSpamAccount() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamIsSpamAccount", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=244L)
    public Map<String, Object> unsetSpamIsSpamAccount(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamIsSpamAccount", "");
        return attrs;
    }

    @ZAttr(id=202L)
    public int getSpamKillPercent() {
        return this.getIntAttr("zimbraSpamKillPercent", 75);
    }

    @ZAttr(id=202L)
    public void setSpamKillPercent(int zimbraSpamKillPercent) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamKillPercent", Integer.toString(zimbraSpamKillPercent));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=202L)
    public Map<String, Object> setSpamKillPercent(int zimbraSpamKillPercent, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamKillPercent", Integer.toString(zimbraSpamKillPercent));
        return attrs;
    }

    @ZAttr(id=202L)
    public void unsetSpamKillPercent() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamKillPercent", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=202L)
    public Map<String, Object> unsetSpamKillPercent(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamKillPercent", "");
        return attrs;
    }

    @ZAttr(id=1049L)
    public String getSpamReportEnvelopeFrom() {
        return this.getAttr("zimbraSpamReportEnvelopeFrom", null);
    }

    @ZAttr(id=1049L)
    public void setSpamReportEnvelopeFrom(String zimbraSpamReportEnvelopeFrom) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamReportEnvelopeFrom", zimbraSpamReportEnvelopeFrom);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1049L)
    public Map<String, Object> setSpamReportEnvelopeFrom(String zimbraSpamReportEnvelopeFrom, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamReportEnvelopeFrom", zimbraSpamReportEnvelopeFrom);
        return attrs;
    }

    @ZAttr(id=1049L)
    public void unsetSpamReportEnvelopeFrom() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamReportEnvelopeFrom", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1049L)
    public Map<String, Object> unsetSpamReportEnvelopeFrom(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamReportEnvelopeFrom", "");
        return attrs;
    }

    @ZAttr(id=465L)
    public String getSpamReportSenderHeader() {
        return this.getAttr("zimbraSpamReportSenderHeader", "X-Zimbra-Spam-Report-Sender");
    }

    @ZAttr(id=465L)
    public void setSpamReportSenderHeader(String zimbraSpamReportSenderHeader) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamReportSenderHeader", zimbraSpamReportSenderHeader);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=465L)
    public Map<String, Object> setSpamReportSenderHeader(String zimbraSpamReportSenderHeader, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamReportSenderHeader", zimbraSpamReportSenderHeader);
        return attrs;
    }

    @ZAttr(id=465L)
    public void unsetSpamReportSenderHeader() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamReportSenderHeader", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=465L)
    public Map<String, Object> unsetSpamReportSenderHeader(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamReportSenderHeader", "");
        return attrs;
    }

    @ZAttr(id=468L)
    public String getSpamReportTypeHam() {
        return this.getAttr("zimbraSpamReportTypeHam", "ham");
    }

    @ZAttr(id=468L)
    public void setSpamReportTypeHam(String zimbraSpamReportTypeHam) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamReportTypeHam", zimbraSpamReportTypeHam);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=468L)
    public Map<String, Object> setSpamReportTypeHam(String zimbraSpamReportTypeHam, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamReportTypeHam", zimbraSpamReportTypeHam);
        return attrs;
    }

    @ZAttr(id=468L)
    public void unsetSpamReportTypeHam() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamReportTypeHam", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=468L)
    public Map<String, Object> unsetSpamReportTypeHam(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamReportTypeHam", "");
        return attrs;
    }

    @ZAttr(id=466L)
    public String getSpamReportTypeHeader() {
        return this.getAttr("zimbraSpamReportTypeHeader", "X-Zimbra-Spam-Report-Type");
    }

    @ZAttr(id=466L)
    public void setSpamReportTypeHeader(String zimbraSpamReportTypeHeader) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamReportTypeHeader", zimbraSpamReportTypeHeader);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=466L)
    public Map<String, Object> setSpamReportTypeHeader(String zimbraSpamReportTypeHeader, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamReportTypeHeader", zimbraSpamReportTypeHeader);
        return attrs;
    }

    @ZAttr(id=466L)
    public void unsetSpamReportTypeHeader() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamReportTypeHeader", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=466L)
    public Map<String, Object> unsetSpamReportTypeHeader(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamReportTypeHeader", "");
        return attrs;
    }

    @ZAttr(id=467L)
    public String getSpamReportTypeSpam() {
        return this.getAttr("zimbraSpamReportTypeSpam", "spam");
    }

    @ZAttr(id=467L)
    public void setSpamReportTypeSpam(String zimbraSpamReportTypeSpam) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamReportTypeSpam", zimbraSpamReportTypeSpam);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=467L)
    public Map<String, Object> setSpamReportTypeSpam(String zimbraSpamReportTypeSpam, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamReportTypeSpam", zimbraSpamReportTypeSpam);
        return attrs;
    }

    @ZAttr(id=467L)
    public void unsetSpamReportTypeSpam() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamReportTypeSpam", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=467L)
    public Map<String, Object> unsetSpamReportTypeSpam(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamReportTypeSpam", "");
        return attrs;
    }

    @ZAttr(id=203L)
    public String getSpamSubjectTag() {
        return this.getAttr("zimbraSpamSubjectTag", null);
    }

    @ZAttr(id=203L)
    public void setSpamSubjectTag(String zimbraSpamSubjectTag) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamSubjectTag", zimbraSpamSubjectTag);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=203L)
    public Map<String, Object> setSpamSubjectTag(String zimbraSpamSubjectTag, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamSubjectTag", zimbraSpamSubjectTag);
        return attrs;
    }

    @ZAttr(id=203L)
    public void unsetSpamSubjectTag() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamSubjectTag", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=203L)
    public Map<String, Object> unsetSpamSubjectTag(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamSubjectTag", "");
        return attrs;
    }

    @ZAttr(id=204L)
    public int getSpamTagPercent() {
        return this.getIntAttr("zimbraSpamTagPercent", 33);
    }

    @ZAttr(id=204L)
    public void setSpamTagPercent(int zimbraSpamTagPercent) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamTagPercent", Integer.toString(zimbraSpamTagPercent));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=204L)
    public Map<String, Object> setSpamTagPercent(int zimbraSpamTagPercent, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamTagPercent", Integer.toString(zimbraSpamTagPercent));
        return attrs;
    }

    @ZAttr(id=204L)
    public void unsetSpamTagPercent() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpamTagPercent", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=204L)
    public Map<String, Object> unsetSpamTagPercent(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpamTagPercent", "");
        return attrs;
    }

    @ZAttr(id=1042L)
    public String[] getSpellAvailableDictionary() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraSpellAvailableDictionary");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "en_US";
        }
        return stringArray;
    }

    @ZAttr(id=1042L)
    public void setSpellAvailableDictionary(String[] zimbraSpellAvailableDictionary) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1042L)
    public Map<String, Object> setSpellAvailableDictionary(String[] zimbraSpellAvailableDictionary, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        return attrs;
    }

    @ZAttr(id=1042L)
    public void addSpellAvailableDictionary(String zimbraSpellAvailableDictionary) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1042L)
    public Map<String, Object> addSpellAvailableDictionary(String zimbraSpellAvailableDictionary, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        return attrs;
    }

    @ZAttr(id=1042L)
    public void removeSpellAvailableDictionary(String zimbraSpellAvailableDictionary) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1042L)
    public Map<String, Object> removeSpellAvailableDictionary(String zimbraSpellAvailableDictionary, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraSpellAvailableDictionary", zimbraSpellAvailableDictionary);
        return attrs;
    }

    @ZAttr(id=1042L)
    public void unsetSpellAvailableDictionary() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpellAvailableDictionary", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1042L)
    public Map<String, Object> unsetSpellAvailableDictionary(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpellAvailableDictionary", "");
        return attrs;
    }

    @ZAttr(id=267L)
    public String[] getSpellCheckURL() {
        return this.getMultiAttr("zimbraSpellCheckURL");
    }

    @ZAttr(id=267L)
    public void setSpellCheckURL(String[] zimbraSpellCheckURL) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraSpellCheckURL", zimbraSpellCheckURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=267L)
    public Map<String, Object> setSpellCheckURL(String[] zimbraSpellCheckURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpellCheckURL", zimbraSpellCheckURL);
        return attrs;
    }

    @ZAttr(id=267L)
    public void addSpellCheckURL(String zimbraSpellCheckURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraSpellCheckURL", zimbraSpellCheckURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=267L)
    public Map<String, Object> addSpellCheckURL(String zimbraSpellCheckURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraSpellCheckURL", zimbraSpellCheckURL);
        return attrs;
    }

    @ZAttr(id=267L)
    public void removeSpellCheckURL(String zimbraSpellCheckURL) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraSpellCheckURL", zimbraSpellCheckURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=267L)
    public Map<String, Object> removeSpellCheckURL(String zimbraSpellCheckURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraSpellCheckURL", zimbraSpellCheckURL);
        return attrs;
    }

    @ZAttr(id=267L)
    public void unsetSpellCheckURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSpellCheckURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=267L)
    public Map<String, Object> unsetSpellCheckURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSpellCheckURL", "");
        return attrs;
    }

    @ZAttr(id=277L)
    public String getSslCaCert() {
        return this.getAttr("zimbraSslCaCert", null);
    }

    @ZAttr(id=277L)
    public void setSslCaCert(String zimbraSslCaCert) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSslCaCert", zimbraSslCaCert);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=277L)
    public Map<String, Object> setSslCaCert(String zimbraSslCaCert, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSslCaCert", zimbraSslCaCert);
        return attrs;
    }

    @ZAttr(id=277L)
    public void unsetSslCaCert() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSslCaCert", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=277L)
    public Map<String, Object> unsetSslCaCert(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSslCaCert", "");
        return attrs;
    }

    @ZAttr(id=278L)
    public String getSslCaKey() {
        return this.getAttr("zimbraSslCaKey", null);
    }

    @ZAttr(id=278L)
    public void setSslCaKey(String zimbraSslCaKey) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSslCaKey", zimbraSslCaKey);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=278L)
    public Map<String, Object> setSslCaKey(String zimbraSslCaKey, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSslCaKey", zimbraSslCaKey);
        return attrs;
    }

    @ZAttr(id=278L)
    public void unsetSslCaKey() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraSslCaKey", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=278L)
    public Map<String, Object> unsetSslCaKey(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraSslCaKey", "");
        return attrs;
    }

    @ZAttr(id=792L)
    public String[] getStatThreadNamePrefix() {
        String[] stringArray;
        String[] value = this.getMultiAttr("zimbraStatThreadNamePrefix");
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[14];
            stringArray2[0] = "btpool";
            stringArray2[1] = "pool";
            stringArray2[2] = "LmtpServer";
            stringArray2[3] = "ImapServer";
            stringArray2[4] = "ImapSSLServer";
            stringArray2[5] = "Pop3Server";
            stringArray2[6] = "Pop3SSLServer";
            stringArray2[7] = "ScheduledTask";
            stringArray2[8] = "Timer";
            stringArray2[9] = "AnonymousIoService";
            stringArray2[10] = "CloudRoutingReaderThread";
            stringArray2[11] = "GC";
            stringArray2[12] = "SocketAcceptor";
            stringArray = stringArray2;
            stringArray2[13] = "Thread";
        }
        return stringArray;
    }

    @ZAttr(id=792L)
    public void setStatThreadNamePrefix(String[] zimbraStatThreadNamePrefix) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=792L)
    public Map<String, Object> setStatThreadNamePrefix(String[] zimbraStatThreadNamePrefix, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        return attrs;
    }

    @ZAttr(id=792L)
    public void addStatThreadNamePrefix(String zimbraStatThreadNamePrefix) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=792L)
    public Map<String, Object> addStatThreadNamePrefix(String zimbraStatThreadNamePrefix, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        return attrs;
    }

    @ZAttr(id=792L)
    public void removeStatThreadNamePrefix(String zimbraStatThreadNamePrefix) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=792L)
    public Map<String, Object> removeStatThreadNamePrefix(String zimbraStatThreadNamePrefix, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraStatThreadNamePrefix", zimbraStatThreadNamePrefix);
        return attrs;
    }

    @ZAttr(id=792L)
    public void unsetStatThreadNamePrefix() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraStatThreadNamePrefix", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=792L)
    public Map<String, Object> unsetStatThreadNamePrefix(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraStatThreadNamePrefix", "");
        return attrs;
    }

    @ZAttr(id=171L)
    public int getTableMaintenanceGrowthFactor() {
        return this.getIntAttr("zimbraTableMaintenanceGrowthFactor", 10);
    }

    @ZAttr(id=171L)
    public void setTableMaintenanceGrowthFactor(int zimbraTableMaintenanceGrowthFactor) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceGrowthFactor", Integer.toString(zimbraTableMaintenanceGrowthFactor));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=171L)
    public Map<String, Object> setTableMaintenanceGrowthFactor(int zimbraTableMaintenanceGrowthFactor, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceGrowthFactor", Integer.toString(zimbraTableMaintenanceGrowthFactor));
        return attrs;
    }

    @ZAttr(id=171L)
    public void unsetTableMaintenanceGrowthFactor() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceGrowthFactor", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=171L)
    public Map<String, Object> unsetTableMaintenanceGrowthFactor(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceGrowthFactor", "");
        return attrs;
    }

    @ZAttr(id=169L)
    public int getTableMaintenanceMaxRows() {
        return this.getIntAttr("zimbraTableMaintenanceMaxRows", 1000000);
    }

    @ZAttr(id=169L)
    public void setTableMaintenanceMaxRows(int zimbraTableMaintenanceMaxRows) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceMaxRows", Integer.toString(zimbraTableMaintenanceMaxRows));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=169L)
    public Map<String, Object> setTableMaintenanceMaxRows(int zimbraTableMaintenanceMaxRows, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceMaxRows", Integer.toString(zimbraTableMaintenanceMaxRows));
        return attrs;
    }

    @ZAttr(id=169L)
    public void unsetTableMaintenanceMaxRows() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceMaxRows", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=169L)
    public Map<String, Object> unsetTableMaintenanceMaxRows(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceMaxRows", "");
        return attrs;
    }

    @ZAttr(id=168L)
    public int getTableMaintenanceMinRows() {
        return this.getIntAttr("zimbraTableMaintenanceMinRows", 10000);
    }

    @ZAttr(id=168L)
    public void setTableMaintenanceMinRows(int zimbraTableMaintenanceMinRows) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceMinRows", Integer.toString(zimbraTableMaintenanceMinRows));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=168L)
    public Map<String, Object> setTableMaintenanceMinRows(int zimbraTableMaintenanceMinRows, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceMinRows", Integer.toString(zimbraTableMaintenanceMinRows));
        return attrs;
    }

    @ZAttr(id=168L)
    public void unsetTableMaintenanceMinRows() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceMinRows", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=168L)
    public Map<String, Object> unsetTableMaintenanceMinRows(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceMinRows", "");
        return attrs;
    }

    @ZAttr(id=170L)
    public ZAttrProvisioning.TableMaintenanceOperation getTableMaintenanceOperation() {
        try {
            String v = this.getAttr("zimbraTableMaintenanceOperation");
            return v == null ? ZAttrProvisioning.TableMaintenanceOperation.ANALYZE : ZAttrProvisioning.TableMaintenanceOperation.fromString(v);
        }
        catch (ServiceException e) {
            return ZAttrProvisioning.TableMaintenanceOperation.ANALYZE;
        }
    }

    @ZAttr(id=170L)
    public String getTableMaintenanceOperationAsString() {
        return this.getAttr("zimbraTableMaintenanceOperation", "ANALYZE");
    }

    @ZAttr(id=170L)
    public void setTableMaintenanceOperation(ZAttrProvisioning.TableMaintenanceOperation zimbraTableMaintenanceOperation) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceOperation", zimbraTableMaintenanceOperation.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=170L)
    public Map<String, Object> setTableMaintenanceOperation(ZAttrProvisioning.TableMaintenanceOperation zimbraTableMaintenanceOperation, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceOperation", zimbraTableMaintenanceOperation.toString());
        return attrs;
    }

    @ZAttr(id=170L)
    public void setTableMaintenanceOperationAsString(String zimbraTableMaintenanceOperation) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceOperation", zimbraTableMaintenanceOperation);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=170L)
    public Map<String, Object> setTableMaintenanceOperationAsString(String zimbraTableMaintenanceOperation, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceOperation", zimbraTableMaintenanceOperation);
        return attrs;
    }

    @ZAttr(id=170L)
    public void unsetTableMaintenanceOperation() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraTableMaintenanceOperation", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=170L)
    public Map<String, Object> unsetTableMaintenanceOperation(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraTableMaintenanceOperation", "");
        return attrs;
    }

    @ZAttr(id=1059L)
    public long getVersionCheckInterval() {
        return this.getTimeInterval("zimbraVersionCheckInterval", 86400000L);
    }

    @ZAttr(id=1059L)
    public String getVersionCheckIntervalAsString() {
        return this.getAttr("zimbraVersionCheckInterval", "1d");
    }

    @ZAttr(id=1059L)
    public void setVersionCheckInterval(String zimbraVersionCheckInterval) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckInterval", zimbraVersionCheckInterval);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1059L)
    public Map<String, Object> setVersionCheckInterval(String zimbraVersionCheckInterval, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckInterval", zimbraVersionCheckInterval);
        return attrs;
    }

    @ZAttr(id=1059L)
    public void unsetVersionCheckInterval() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckInterval", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1059L)
    public Map<String, Object> unsetVersionCheckInterval(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckInterval", "");
        return attrs;
    }

    @ZAttr(id=1056L)
    public Date getVersionCheckLastAttempt() {
        return this.getGeneralizedTimeAttr("zimbraVersionCheckLastAttempt", null);
    }

    @ZAttr(id=1056L)
    public String getVersionCheckLastAttemptAsString() {
        return this.getAttr("zimbraVersionCheckLastAttempt", null);
    }

    @ZAttr(id=1056L)
    public void setVersionCheckLastAttempt(Date zimbraVersionCheckLastAttempt) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckLastAttempt", DateUtil.toGeneralizedTime(zimbraVersionCheckLastAttempt));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1056L)
    public Map<String, Object> setVersionCheckLastAttempt(Date zimbraVersionCheckLastAttempt, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckLastAttempt", DateUtil.toGeneralizedTime(zimbraVersionCheckLastAttempt));
        return attrs;
    }

    @ZAttr(id=1056L)
    public void setVersionCheckLastAttemptAsString(String zimbraVersionCheckLastAttempt) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckLastAttempt", zimbraVersionCheckLastAttempt);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1056L)
    public Map<String, Object> setVersionCheckLastAttemptAsString(String zimbraVersionCheckLastAttempt, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckLastAttempt", zimbraVersionCheckLastAttempt);
        return attrs;
    }

    @ZAttr(id=1056L)
    public void unsetVersionCheckLastAttempt() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckLastAttempt", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1056L)
    public Map<String, Object> unsetVersionCheckLastAttempt(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckLastAttempt", "");
        return attrs;
    }

    @ZAttr(id=1058L)
    public String getVersionCheckLastResponse() {
        return this.getAttr("zimbraVersionCheckLastResponse", null);
    }

    @ZAttr(id=1058L)
    public void setVersionCheckLastResponse(String zimbraVersionCheckLastResponse) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckLastResponse", zimbraVersionCheckLastResponse);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1058L)
    public Map<String, Object> setVersionCheckLastResponse(String zimbraVersionCheckLastResponse, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckLastResponse", zimbraVersionCheckLastResponse);
        return attrs;
    }

    @ZAttr(id=1058L)
    public void unsetVersionCheckLastResponse() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckLastResponse", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1058L)
    public Map<String, Object> unsetVersionCheckLastResponse(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckLastResponse", "");
        return attrs;
    }

    @ZAttr(id=1057L)
    public Date getVersionCheckLastSuccess() {
        return this.getGeneralizedTimeAttr("zimbraVersionCheckLastSuccess", null);
    }

    @ZAttr(id=1057L)
    public String getVersionCheckLastSuccessAsString() {
        return this.getAttr("zimbraVersionCheckLastSuccess", null);
    }

    @ZAttr(id=1057L)
    public void setVersionCheckLastSuccess(Date zimbraVersionCheckLastSuccess) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckLastSuccess", DateUtil.toGeneralizedTime(zimbraVersionCheckLastSuccess));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1057L)
    public Map<String, Object> setVersionCheckLastSuccess(Date zimbraVersionCheckLastSuccess, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckLastSuccess", DateUtil.toGeneralizedTime(zimbraVersionCheckLastSuccess));
        return attrs;
    }

    @ZAttr(id=1057L)
    public void setVersionCheckLastSuccessAsString(String zimbraVersionCheckLastSuccess) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckLastSuccess", zimbraVersionCheckLastSuccess);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1057L)
    public Map<String, Object> setVersionCheckLastSuccessAsString(String zimbraVersionCheckLastSuccess, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckLastSuccess", zimbraVersionCheckLastSuccess);
        return attrs;
    }

    @ZAttr(id=1057L)
    public void unsetVersionCheckLastSuccess() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckLastSuccess", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1057L)
    public Map<String, Object> unsetVersionCheckLastSuccess(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckLastSuccess", "");
        return attrs;
    }

    @ZAttr(id=1066L)
    public String getVersionCheckNotificationBody() {
        return this.getAttr("zimbraVersionCheckNotificationBody", "${BEGIN_PREFIX}The following updates were found:${NEWLINE}${NEWLINE}${END_PREFIX}${BEGIN_UPDATE}${UPDATE_COUNTER}.  ${IS_CRITICAL}.  Version: ${UPDATE_VERSION}, URL: ${UPDATE_URL}${NEWLINE}${NEWLINE}${END_UPDATE}${BEGIN_SIGNATURE}Zimbra Updater${NEWLINE}${END_SIGNATURE}");
    }

    @ZAttr(id=1066L)
    public void setVersionCheckNotificationBody(String zimbraVersionCheckNotificationBody) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckNotificationBody", zimbraVersionCheckNotificationBody);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1066L)
    public Map<String, Object> setVersionCheckNotificationBody(String zimbraVersionCheckNotificationBody, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckNotificationBody", zimbraVersionCheckNotificationBody);
        return attrs;
    }

    @ZAttr(id=1066L)
    public void unsetVersionCheckNotificationBody() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckNotificationBody", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1066L)
    public Map<String, Object> unsetVersionCheckNotificationBody(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckNotificationBody", "");
        return attrs;
    }

    @ZAttr(id=1063L)
    public String getVersionCheckNotificationEmail() {
        return this.getAttr("zimbraVersionCheckNotificationEmail", null);
    }

    @ZAttr(id=1063L)
    public void setVersionCheckNotificationEmail(String zimbraVersionCheckNotificationEmail) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckNotificationEmail", zimbraVersionCheckNotificationEmail);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1063L)
    public Map<String, Object> setVersionCheckNotificationEmail(String zimbraVersionCheckNotificationEmail, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckNotificationEmail", zimbraVersionCheckNotificationEmail);
        return attrs;
    }

    @ZAttr(id=1063L)
    public void unsetVersionCheckNotificationEmail() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckNotificationEmail", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1063L)
    public Map<String, Object> unsetVersionCheckNotificationEmail(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckNotificationEmail", "");
        return attrs;
    }

    @ZAttr(id=1064L)
    public String getVersionCheckNotificationEmailFrom() {
        return this.getAttr("zimbraVersionCheckNotificationEmailFrom", null);
    }

    @ZAttr(id=1064L)
    public void setVersionCheckNotificationEmailFrom(String zimbraVersionCheckNotificationEmailFrom) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckNotificationEmailFrom", zimbraVersionCheckNotificationEmailFrom);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1064L)
    public Map<String, Object> setVersionCheckNotificationEmailFrom(String zimbraVersionCheckNotificationEmailFrom, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckNotificationEmailFrom", zimbraVersionCheckNotificationEmailFrom);
        return attrs;
    }

    @ZAttr(id=1064L)
    public void unsetVersionCheckNotificationEmailFrom() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckNotificationEmailFrom", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1064L)
    public Map<String, Object> unsetVersionCheckNotificationEmailFrom(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckNotificationEmailFrom", "");
        return attrs;
    }

    @ZAttr(id=1065L)
    public String getVersionCheckNotificationSubject() {
        return this.getAttr("zimbraVersionCheckNotificationSubject", "${IS_CRITICAL} updates are available for your Zimbra server");
    }

    @ZAttr(id=1065L)
    public void setVersionCheckNotificationSubject(String zimbraVersionCheckNotificationSubject) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckNotificationSubject", zimbraVersionCheckNotificationSubject);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1065L)
    public Map<String, Object> setVersionCheckNotificationSubject(String zimbraVersionCheckNotificationSubject, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckNotificationSubject", zimbraVersionCheckNotificationSubject);
        return attrs;
    }

    @ZAttr(id=1065L)
    public void unsetVersionCheckNotificationSubject() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckNotificationSubject", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1065L)
    public Map<String, Object> unsetVersionCheckNotificationSubject(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckNotificationSubject", "");
        return attrs;
    }

    @ZAttr(id=1062L)
    public boolean isVersionCheckSendNotifications() {
        return this.getBooleanAttr("zimbraVersionCheckSendNotifications", true);
    }

    @ZAttr(id=1062L)
    public void setVersionCheckSendNotifications(boolean zimbraVersionCheckSendNotifications) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckSendNotifications", zimbraVersionCheckSendNotifications ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1062L)
    public Map<String, Object> setVersionCheckSendNotifications(boolean zimbraVersionCheckSendNotifications, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckSendNotifications", zimbraVersionCheckSendNotifications ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=1062L)
    public void unsetVersionCheckSendNotifications() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckSendNotifications", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1062L)
    public Map<String, Object> unsetVersionCheckSendNotifications(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckSendNotifications", "");
        return attrs;
    }

    @ZAttr(id=1060L)
    public String getVersionCheckServer() {
        return this.getAttr("zimbraVersionCheckServer", null);
    }

    @ZAttr(id=1060L)
    public void setVersionCheckServer(String zimbraVersionCheckServer) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckServer", zimbraVersionCheckServer);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1060L)
    public Map<String, Object> setVersionCheckServer(String zimbraVersionCheckServer, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckServer", zimbraVersionCheckServer);
        return attrs;
    }

    @ZAttr(id=1060L)
    public void unsetVersionCheckServer() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckServer", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1060L)
    public Map<String, Object> unsetVersionCheckServer(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckServer", "");
        return attrs;
    }

    @ZAttr(id=1061L)
    public String getVersionCheckURL() {
        return this.getAttr("zimbraVersionCheckURL", "http://www.zimbra.com/aus/admin/zimbraAdminVersionCheck.php");
    }

    @ZAttr(id=1061L)
    public void setVersionCheckURL(String zimbraVersionCheckURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckURL", zimbraVersionCheckURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1061L)
    public Map<String, Object> setVersionCheckURL(String zimbraVersionCheckURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckURL", zimbraVersionCheckURL);
        return attrs;
    }

    @ZAttr(id=1061L)
    public void unsetVersionCheckURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVersionCheckURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=1061L)
    public Map<String, Object> unsetVersionCheckURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVersionCheckURL", "");
        return attrs;
    }

    @ZAttr(id=205L)
    public boolean isVirusBlockEncryptedArchive() {
        return this.getBooleanAttr("zimbraVirusBlockEncryptedArchive", true);
    }

    @ZAttr(id=205L)
    public void setVirusBlockEncryptedArchive(boolean zimbraVirusBlockEncryptedArchive) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusBlockEncryptedArchive", zimbraVirusBlockEncryptedArchive ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=205L)
    public Map<String, Object> setVirusBlockEncryptedArchive(boolean zimbraVirusBlockEncryptedArchive, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusBlockEncryptedArchive", zimbraVirusBlockEncryptedArchive ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=205L)
    public void unsetVirusBlockEncryptedArchive() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusBlockEncryptedArchive", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=205L)
    public Map<String, Object> unsetVirusBlockEncryptedArchive(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusBlockEncryptedArchive", "");
        return attrs;
    }

    @ZAttr(id=206L)
    public boolean isVirusCheckEnabled() {
        return this.getBooleanAttr("zimbraVirusCheckEnabled", false);
    }

    @ZAttr(id=206L)
    public void setVirusCheckEnabled(boolean zimbraVirusCheckEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusCheckEnabled", zimbraVirusCheckEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=206L)
    public Map<String, Object> setVirusCheckEnabled(boolean zimbraVirusCheckEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusCheckEnabled", zimbraVirusCheckEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=206L)
    public void unsetVirusCheckEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusCheckEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=206L)
    public Map<String, Object> unsetVirusCheckEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusCheckEnabled", "");
        return attrs;
    }

    @ZAttr(id=191L)
    public long getVirusDefinitionsUpdateFrequency() {
        return this.getTimeInterval("zimbraVirusDefinitionsUpdateFrequency", 0x6DDD00L);
    }

    @ZAttr(id=191L)
    public String getVirusDefinitionsUpdateFrequencyAsString() {
        return this.getAttr("zimbraVirusDefinitionsUpdateFrequency", "2h");
    }

    @ZAttr(id=191L)
    public void setVirusDefinitionsUpdateFrequency(String zimbraVirusDefinitionsUpdateFrequency) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusDefinitionsUpdateFrequency", zimbraVirusDefinitionsUpdateFrequency);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=191L)
    public Map<String, Object> setVirusDefinitionsUpdateFrequency(String zimbraVirusDefinitionsUpdateFrequency, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusDefinitionsUpdateFrequency", zimbraVirusDefinitionsUpdateFrequency);
        return attrs;
    }

    @ZAttr(id=191L)
    public void unsetVirusDefinitionsUpdateFrequency() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusDefinitionsUpdateFrequency", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=191L)
    public Map<String, Object> unsetVirusDefinitionsUpdateFrequency(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusDefinitionsUpdateFrequency", "");
        return attrs;
    }

    @ZAttr(id=207L)
    public boolean isVirusWarnAdmin() {
        return this.getBooleanAttr("zimbraVirusWarnAdmin", true);
    }

    @ZAttr(id=207L)
    public void setVirusWarnAdmin(boolean zimbraVirusWarnAdmin) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusWarnAdmin", zimbraVirusWarnAdmin ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=207L)
    public Map<String, Object> setVirusWarnAdmin(boolean zimbraVirusWarnAdmin, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusWarnAdmin", zimbraVirusWarnAdmin ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=207L)
    public void unsetVirusWarnAdmin() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusWarnAdmin", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=207L)
    public Map<String, Object> unsetVirusWarnAdmin(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusWarnAdmin", "");
        return attrs;
    }

    @ZAttr(id=208L)
    public boolean isVirusWarnRecipient() {
        return this.getBooleanAttr("zimbraVirusWarnRecipient", true);
    }

    @ZAttr(id=208L)
    public void setVirusWarnRecipient(boolean zimbraVirusWarnRecipient) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusWarnRecipient", zimbraVirusWarnRecipient ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=208L)
    public Map<String, Object> setVirusWarnRecipient(boolean zimbraVirusWarnRecipient, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusWarnRecipient", zimbraVirusWarnRecipient ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=208L)
    public void unsetVirusWarnRecipient() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraVirusWarnRecipient", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=208L)
    public Map<String, Object> unsetVirusWarnRecipient(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraVirusWarnRecipient", "");
        return attrs;
    }

    @ZAttr(id=701L)
    public String getWebClientAdminReference() {
        return this.getAttr("zimbraWebClientAdminReference", null);
    }

    @ZAttr(id=701L)
    public void setWebClientAdminReference(String zimbraWebClientAdminReference) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraWebClientAdminReference", zimbraWebClientAdminReference);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=701L)
    public Map<String, Object> setWebClientAdminReference(String zimbraWebClientAdminReference, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraWebClientAdminReference", zimbraWebClientAdminReference);
        return attrs;
    }

    @ZAttr(id=701L)
    public void unsetWebClientAdminReference() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraWebClientAdminReference", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=701L)
    public Map<String, Object> unsetWebClientAdminReference(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraWebClientAdminReference", "");
        return attrs;
    }

    @ZAttr(id=506L)
    public String getWebClientLoginURL() {
        return this.getAttr("zimbraWebClientLoginURL", null);
    }

    @ZAttr(id=506L)
    public void setWebClientLoginURL(String zimbraWebClientLoginURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraWebClientLoginURL", zimbraWebClientLoginURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=506L)
    public Map<String, Object> setWebClientLoginURL(String zimbraWebClientLoginURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraWebClientLoginURL", zimbraWebClientLoginURL);
        return attrs;
    }

    @ZAttr(id=506L)
    public void unsetWebClientLoginURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraWebClientLoginURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=506L)
    public Map<String, Object> unsetWebClientLoginURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraWebClientLoginURL", "");
        return attrs;
    }

    @ZAttr(id=507L)
    public String getWebClientLogoutURL() {
        return this.getAttr("zimbraWebClientLogoutURL", null);
    }

    @ZAttr(id=507L)
    public void setWebClientLogoutURL(String zimbraWebClientLogoutURL) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraWebClientLogoutURL", zimbraWebClientLogoutURL);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=507L)
    public Map<String, Object> setWebClientLogoutURL(String zimbraWebClientLogoutURL, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraWebClientLogoutURL", zimbraWebClientLogoutURL);
        return attrs;
    }

    @ZAttr(id=507L)
    public void unsetWebClientLogoutURL() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraWebClientLogoutURL", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=507L)
    public Map<String, Object> unsetWebClientLogoutURL(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraWebClientLogoutURL", "");
        return attrs;
    }

    @ZAttr(id=397L)
    public boolean isXMPPEnabled() {
        return this.getBooleanAttr("zimbraXMPPEnabled", true);
    }

    @ZAttr(id=397L)
    public void setXMPPEnabled(boolean zimbraXMPPEnabled) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraXMPPEnabled", zimbraXMPPEnabled ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=397L)
    public Map<String, Object> setXMPPEnabled(boolean zimbraXMPPEnabled, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraXMPPEnabled", zimbraXMPPEnabled ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=397L)
    public void unsetXMPPEnabled() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraXMPPEnabled", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=397L)
    public Map<String, Object> unsetXMPPEnabled(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraXMPPEnabled", "");
        return attrs;
    }

    @ZAttr(id=695L)
    public String[] getXMPPServerDialbackKey() {
        return this.getMultiAttr("zimbraXMPPServerDialbackKey");
    }

    @ZAttr(id=695L)
    public void setXMPPServerDialbackKey(String[] zimbraXMPPServerDialbackKey) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraXMPPServerDialbackKey", zimbraXMPPServerDialbackKey);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=695L)
    public Map<String, Object> setXMPPServerDialbackKey(String[] zimbraXMPPServerDialbackKey, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraXMPPServerDialbackKey", zimbraXMPPServerDialbackKey);
        return attrs;
    }

    @ZAttr(id=695L)
    public void addXMPPServerDialbackKey(String zimbraXMPPServerDialbackKey) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraXMPPServerDialbackKey", zimbraXMPPServerDialbackKey);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=695L)
    public Map<String, Object> addXMPPServerDialbackKey(String zimbraXMPPServerDialbackKey, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraXMPPServerDialbackKey", zimbraXMPPServerDialbackKey);
        return attrs;
    }

    @ZAttr(id=695L)
    public void removeXMPPServerDialbackKey(String zimbraXMPPServerDialbackKey) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraXMPPServerDialbackKey", zimbraXMPPServerDialbackKey);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=695L)
    public Map<String, Object> removeXMPPServerDialbackKey(String zimbraXMPPServerDialbackKey, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraXMPPServerDialbackKey", zimbraXMPPServerDialbackKey);
        return attrs;
    }

    @ZAttr(id=695L)
    public void unsetXMPPServerDialbackKey() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraXMPPServerDialbackKey", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=695L)
    public Map<String, Object> unsetXMPPServerDialbackKey(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraXMPPServerDialbackKey", "");
        return attrs;
    }

    @ZAttr(id=710L)
    public String[] getZimletDomainAvailableZimlets() {
        return this.getMultiAttr("zimbraZimletDomainAvailableZimlets");
    }

    @ZAttr(id=710L)
    public void setZimletDomainAvailableZimlets(String[] zimbraZimletDomainAvailableZimlets) throws ServiceException {
        HashMap<String, String[]> attrs = new HashMap<String, String[]>();
        attrs.put("zimbraZimletDomainAvailableZimlets", zimbraZimletDomainAvailableZimlets);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=710L)
    public Map<String, Object> setZimletDomainAvailableZimlets(String[] zimbraZimletDomainAvailableZimlets, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraZimletDomainAvailableZimlets", zimbraZimletDomainAvailableZimlets);
        return attrs;
    }

    @ZAttr(id=710L)
    public void addZimletDomainAvailableZimlets(String zimbraZimletDomainAvailableZimlets) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "+zimbraZimletDomainAvailableZimlets", zimbraZimletDomainAvailableZimlets);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=710L)
    public Map<String, Object> addZimletDomainAvailableZimlets(String zimbraZimletDomainAvailableZimlets, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "+zimbraZimletDomainAvailableZimlets", zimbraZimletDomainAvailableZimlets);
        return attrs;
    }

    @ZAttr(id=710L)
    public void removeZimletDomainAvailableZimlets(String zimbraZimletDomainAvailableZimlets) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        StringUtil.addToMultiMap(attrs, "-zimbraZimletDomainAvailableZimlets", zimbraZimletDomainAvailableZimlets);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=710L)
    public Map<String, Object> removeZimletDomainAvailableZimlets(String zimbraZimletDomainAvailableZimlets, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        StringUtil.addToMultiMap(attrs, "-zimbraZimletDomainAvailableZimlets", zimbraZimletDomainAvailableZimlets);
        return attrs;
    }

    @ZAttr(id=710L)
    public void unsetZimletDomainAvailableZimlets() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraZimletDomainAvailableZimlets", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=710L)
    public Map<String, Object> unsetZimletDomainAvailableZimlets(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraZimletDomainAvailableZimlets", "");
        return attrs;
    }
}

