/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.DateUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ZAttr;
import com.zimbra.cs.account.ZAttrProvisioning;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZAttrCalendarResource
extends Account {
    public ZAttrCalendarResource(String name, String id, Map<String, Object> attrs, Map<String, Object> defaults, Provisioning prov) {
        super(name, id, attrs, defaults, prov);
    }

    @Override
    @ZAttr(id=-1L)
    public String getDisplayName() {
        return this.getAttr("displayName", null);
    }

    @Override
    @ZAttr(id=-1L)
    public void setDisplayName(String displayName) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("displayName", displayName);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=-1L)
    public Map<String, Object> setDisplayName(String displayName, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("displayName", displayName);
        return attrs;
    }

    @Override
    @ZAttr(id=-1L)
    public void unsetDisplayName() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("displayName", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=-1L)
    public Map<String, Object> unsetDisplayName(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("displayName", "");
        return attrs;
    }

    @Override
    @ZAttr(id=313L)
    public ZAttrProvisioning.AccountCalendarUserType getAccountCalendarUserType() {
        try {
            String v = this.getAttr("zimbraAccountCalendarUserType");
            return v == null ? null : ZAttrProvisioning.AccountCalendarUserType.fromString(v);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @Override
    @ZAttr(id=313L)
    public String getAccountCalendarUserTypeAsString() {
        return this.getAttr("zimbraAccountCalendarUserType", null);
    }

    @Override
    @ZAttr(id=313L)
    public void setAccountCalendarUserType(ZAttrProvisioning.AccountCalendarUserType zimbraAccountCalendarUserType) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAccountCalendarUserType", zimbraAccountCalendarUserType.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=313L)
    public Map<String, Object> setAccountCalendarUserType(ZAttrProvisioning.AccountCalendarUserType zimbraAccountCalendarUserType, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAccountCalendarUserType", zimbraAccountCalendarUserType.toString());
        return attrs;
    }

    @Override
    @ZAttr(id=313L)
    public void setAccountCalendarUserTypeAsString(String zimbraAccountCalendarUserType) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAccountCalendarUserType", zimbraAccountCalendarUserType);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=313L)
    public Map<String, Object> setAccountCalendarUserTypeAsString(String zimbraAccountCalendarUserType, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAccountCalendarUserType", zimbraAccountCalendarUserType);
        return attrs;
    }

    @Override
    @ZAttr(id=313L)
    public void unsetAccountCalendarUserType() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraAccountCalendarUserType", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=313L)
    public Map<String, Object> unsetAccountCalendarUserType(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraAccountCalendarUserType", "");
        return attrs;
    }

    @ZAttr(id=315L)
    public boolean isCalResAutoAcceptDecline() {
        return this.getBooleanAttr("zimbraCalResAutoAcceptDecline", false);
    }

    @ZAttr(id=315L)
    public void setCalResAutoAcceptDecline(boolean zimbraCalResAutoAcceptDecline) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResAutoAcceptDecline", zimbraCalResAutoAcceptDecline ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=315L)
    public Map<String, Object> setCalResAutoAcceptDecline(boolean zimbraCalResAutoAcceptDecline, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResAutoAcceptDecline", zimbraCalResAutoAcceptDecline ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=315L)
    public void unsetCalResAutoAcceptDecline() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResAutoAcceptDecline", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=315L)
    public Map<String, Object> unsetCalResAutoAcceptDecline(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResAutoAcceptDecline", "");
        return attrs;
    }

    @ZAttr(id=322L)
    public boolean isCalResAutoDeclineIfBusy() {
        return this.getBooleanAttr("zimbraCalResAutoDeclineIfBusy", false);
    }

    @ZAttr(id=322L)
    public void setCalResAutoDeclineIfBusy(boolean zimbraCalResAutoDeclineIfBusy) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResAutoDeclineIfBusy", zimbraCalResAutoDeclineIfBusy ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=322L)
    public Map<String, Object> setCalResAutoDeclineIfBusy(boolean zimbraCalResAutoDeclineIfBusy, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResAutoDeclineIfBusy", zimbraCalResAutoDeclineIfBusy ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=322L)
    public void unsetCalResAutoDeclineIfBusy() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResAutoDeclineIfBusy", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=322L)
    public Map<String, Object> unsetCalResAutoDeclineIfBusy(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResAutoDeclineIfBusy", "");
        return attrs;
    }

    @ZAttr(id=323L)
    public boolean isCalResAutoDeclineRecurring() {
        return this.getBooleanAttr("zimbraCalResAutoDeclineRecurring", false);
    }

    @ZAttr(id=323L)
    public void setCalResAutoDeclineRecurring(boolean zimbraCalResAutoDeclineRecurring) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResAutoDeclineRecurring", zimbraCalResAutoDeclineRecurring ? "TRUE" : "FALSE");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=323L)
    public Map<String, Object> setCalResAutoDeclineRecurring(boolean zimbraCalResAutoDeclineRecurring, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResAutoDeclineRecurring", zimbraCalResAutoDeclineRecurring ? "TRUE" : "FALSE");
        return attrs;
    }

    @ZAttr(id=323L)
    public void unsetCalResAutoDeclineRecurring() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResAutoDeclineRecurring", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=323L)
    public Map<String, Object> unsetCalResAutoDeclineRecurring(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResAutoDeclineRecurring", "");
        return attrs;
    }

    @ZAttr(id=327L)
    public String getCalResBuilding() {
        return this.getAttr("zimbraCalResBuilding", null);
    }

    @ZAttr(id=327L)
    public void setCalResBuilding(String zimbraCalResBuilding) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResBuilding", zimbraCalResBuilding);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=327L)
    public Map<String, Object> setCalResBuilding(String zimbraCalResBuilding, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResBuilding", zimbraCalResBuilding);
        return attrs;
    }

    @ZAttr(id=327L)
    public void unsetCalResBuilding() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResBuilding", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=327L)
    public Map<String, Object> unsetCalResBuilding(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResBuilding", "");
        return attrs;
    }

    @ZAttr(id=330L)
    public int getCalResCapacity() {
        return this.getIntAttr("zimbraCalResCapacity", -1);
    }

    @ZAttr(id=330L)
    public void setCalResCapacity(int zimbraCalResCapacity) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResCapacity", Integer.toString(zimbraCalResCapacity));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=330L)
    public Map<String, Object> setCalResCapacity(int zimbraCalResCapacity, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResCapacity", Integer.toString(zimbraCalResCapacity));
        return attrs;
    }

    @ZAttr(id=330L)
    public void unsetCalResCapacity() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResCapacity", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=330L)
    public Map<String, Object> unsetCalResCapacity(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResCapacity", "");
        return attrs;
    }

    @ZAttr(id=332L)
    public String getCalResContactEmail() {
        return this.getAttr("zimbraCalResContactEmail", null);
    }

    @ZAttr(id=332L)
    public void setCalResContactEmail(String zimbraCalResContactEmail) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResContactEmail", zimbraCalResContactEmail);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=332L)
    public Map<String, Object> setCalResContactEmail(String zimbraCalResContactEmail, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResContactEmail", zimbraCalResContactEmail);
        return attrs;
    }

    @ZAttr(id=332L)
    public void unsetCalResContactEmail() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResContactEmail", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=332L)
    public Map<String, Object> unsetCalResContactEmail(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResContactEmail", "");
        return attrs;
    }

    @ZAttr(id=331L)
    public String getCalResContactName() {
        return this.getAttr("zimbraCalResContactName", null);
    }

    @ZAttr(id=331L)
    public void setCalResContactName(String zimbraCalResContactName) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResContactName", zimbraCalResContactName);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=331L)
    public Map<String, Object> setCalResContactName(String zimbraCalResContactName, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResContactName", zimbraCalResContactName);
        return attrs;
    }

    @ZAttr(id=331L)
    public void unsetCalResContactName() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResContactName", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=331L)
    public Map<String, Object> unsetCalResContactName(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResContactName", "");
        return attrs;
    }

    @ZAttr(id=333L)
    public String getCalResContactPhone() {
        return this.getAttr("zimbraCalResContactPhone", null);
    }

    @ZAttr(id=333L)
    public void setCalResContactPhone(String zimbraCalResContactPhone) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResContactPhone", zimbraCalResContactPhone);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=333L)
    public Map<String, Object> setCalResContactPhone(String zimbraCalResContactPhone, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResContactPhone", zimbraCalResContactPhone);
        return attrs;
    }

    @ZAttr(id=333L)
    public void unsetCalResContactPhone() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResContactPhone", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=333L)
    public Map<String, Object> unsetCalResContactPhone(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResContactPhone", "");
        return attrs;
    }

    @ZAttr(id=328L)
    public String getCalResFloor() {
        return this.getAttr("zimbraCalResFloor", null);
    }

    @ZAttr(id=328L)
    public void setCalResFloor(String zimbraCalResFloor) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResFloor", zimbraCalResFloor);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=328L)
    public Map<String, Object> setCalResFloor(String zimbraCalResFloor, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResFloor", zimbraCalResFloor);
        return attrs;
    }

    @ZAttr(id=328L)
    public void unsetCalResFloor() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResFloor", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=328L)
    public Map<String, Object> unsetCalResFloor(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResFloor", "");
        return attrs;
    }

    @ZAttr(id=324L)
    public String getCalResLocationDisplayName() {
        return this.getAttr("zimbraCalResLocationDisplayName", null);
    }

    @ZAttr(id=324L)
    public void setCalResLocationDisplayName(String zimbraCalResLocationDisplayName) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResLocationDisplayName", zimbraCalResLocationDisplayName);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=324L)
    public Map<String, Object> setCalResLocationDisplayName(String zimbraCalResLocationDisplayName, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResLocationDisplayName", zimbraCalResLocationDisplayName);
        return attrs;
    }

    @ZAttr(id=324L)
    public void unsetCalResLocationDisplayName() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResLocationDisplayName", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=324L)
    public Map<String, Object> unsetCalResLocationDisplayName(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResLocationDisplayName", "");
        return attrs;
    }

    @ZAttr(id=808L)
    public int getCalResMaxNumConflictsAllowed() {
        return this.getIntAttr("zimbraCalResMaxNumConflictsAllowed", -1);
    }

    @ZAttr(id=808L)
    public void setCalResMaxNumConflictsAllowed(int zimbraCalResMaxNumConflictsAllowed) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResMaxNumConflictsAllowed", Integer.toString(zimbraCalResMaxNumConflictsAllowed));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=808L)
    public Map<String, Object> setCalResMaxNumConflictsAllowed(int zimbraCalResMaxNumConflictsAllowed, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResMaxNumConflictsAllowed", Integer.toString(zimbraCalResMaxNumConflictsAllowed));
        return attrs;
    }

    @ZAttr(id=808L)
    public void unsetCalResMaxNumConflictsAllowed() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResMaxNumConflictsAllowed", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=808L)
    public Map<String, Object> unsetCalResMaxNumConflictsAllowed(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResMaxNumConflictsAllowed", "");
        return attrs;
    }

    @ZAttr(id=809L)
    public int getCalResMaxPercentConflictsAllowed() {
        return this.getIntAttr("zimbraCalResMaxPercentConflictsAllowed", -1);
    }

    @ZAttr(id=809L)
    public void setCalResMaxPercentConflictsAllowed(int zimbraCalResMaxPercentConflictsAllowed) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResMaxPercentConflictsAllowed", Integer.toString(zimbraCalResMaxPercentConflictsAllowed));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=809L)
    public Map<String, Object> setCalResMaxPercentConflictsAllowed(int zimbraCalResMaxPercentConflictsAllowed, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResMaxPercentConflictsAllowed", Integer.toString(zimbraCalResMaxPercentConflictsAllowed));
        return attrs;
    }

    @ZAttr(id=809L)
    public void unsetCalResMaxPercentConflictsAllowed() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResMaxPercentConflictsAllowed", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=809L)
    public Map<String, Object> unsetCalResMaxPercentConflictsAllowed(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResMaxPercentConflictsAllowed", "");
        return attrs;
    }

    @ZAttr(id=329L)
    public String getCalResRoom() {
        return this.getAttr("zimbraCalResRoom", null);
    }

    @ZAttr(id=329L)
    public void setCalResRoom(String zimbraCalResRoom) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResRoom", zimbraCalResRoom);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=329L)
    public Map<String, Object> setCalResRoom(String zimbraCalResRoom, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResRoom", zimbraCalResRoom);
        return attrs;
    }

    @ZAttr(id=329L)
    public void unsetCalResRoom() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResRoom", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=329L)
    public Map<String, Object> unsetCalResRoom(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResRoom", "");
        return attrs;
    }

    @ZAttr(id=326L)
    public String getCalResSite() {
        return this.getAttr("zimbraCalResSite", null);
    }

    @ZAttr(id=326L)
    public void setCalResSite(String zimbraCalResSite) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResSite", zimbraCalResSite);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=326L)
    public Map<String, Object> setCalResSite(String zimbraCalResSite, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResSite", zimbraCalResSite);
        return attrs;
    }

    @ZAttr(id=326L)
    public void unsetCalResSite() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResSite", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=326L)
    public Map<String, Object> unsetCalResSite(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResSite", "");
        return attrs;
    }

    @ZAttr(id=314L)
    public ZAttrProvisioning.CalResType getCalResType() {
        try {
            String v = this.getAttr("zimbraCalResType");
            return v == null ? null : ZAttrProvisioning.CalResType.fromString(v);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @ZAttr(id=314L)
    public String getCalResTypeAsString() {
        return this.getAttr("zimbraCalResType", null);
    }

    @ZAttr(id=314L)
    public void setCalResType(ZAttrProvisioning.CalResType zimbraCalResType) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResType", zimbraCalResType.toString());
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=314L)
    public Map<String, Object> setCalResType(ZAttrProvisioning.CalResType zimbraCalResType, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResType", zimbraCalResType.toString());
        return attrs;
    }

    @ZAttr(id=314L)
    public void setCalResTypeAsString(String zimbraCalResType) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResType", zimbraCalResType);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=314L)
    public Map<String, Object> setCalResTypeAsString(String zimbraCalResType, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResType", zimbraCalResType);
        return attrs;
    }

    @ZAttr(id=314L)
    public void unsetCalResType() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCalResType", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @ZAttr(id=314L)
    public Map<String, Object> unsetCalResType(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCalResType", "");
        return attrs;
    }

    @Override
    @ZAttr(id=790L)
    public Date getCreateTimestamp() {
        return this.getGeneralizedTimeAttr("zimbraCreateTimestamp", null);
    }

    @Override
    @ZAttr(id=790L)
    public String getCreateTimestampAsString() {
        return this.getAttr("zimbraCreateTimestamp", null);
    }

    @Override
    @ZAttr(id=790L)
    public void setCreateTimestamp(Date zimbraCreateTimestamp) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(zimbraCreateTimestamp));
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=790L)
    public Map<String, Object> setCreateTimestamp(Date zimbraCreateTimestamp, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCreateTimestamp", DateUtil.toGeneralizedTime(zimbraCreateTimestamp));
        return attrs;
    }

    @Override
    @ZAttr(id=790L)
    public void setCreateTimestampAsString(String zimbraCreateTimestamp) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCreateTimestamp", zimbraCreateTimestamp);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=790L)
    public Map<String, Object> setCreateTimestampAsString(String zimbraCreateTimestamp, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCreateTimestamp", zimbraCreateTimestamp);
        return attrs;
    }

    @Override
    @ZAttr(id=790L)
    public void unsetCreateTimestamp() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraCreateTimestamp", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=790L)
    public Map<String, Object> unsetCreateTimestamp(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraCreateTimestamp", "");
        return attrs;
    }

    @Override
    @ZAttr(id=1L)
    public String getId() {
        return this.getAttr("zimbraId", null);
    }

    @Override
    @ZAttr(id=1L)
    public void setId(String zimbraId) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraId", zimbraId);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=1L)
    public Map<String, Object> setId(String zimbraId, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraId", zimbraId);
        return attrs;
    }

    @Override
    @ZAttr(id=1L)
    public void unsetId() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraId", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=1L)
    public Map<String, Object> unsetId(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraId", "");
        return attrs;
    }

    @Override
    @ZAttr(id=345L)
    public String getLocaleAsString() {
        return this.getAttr("zimbraLocale", null);
    }

    @Override
    @ZAttr(id=345L)
    public void setLocale(String zimbraLocale) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLocale", zimbraLocale);
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=345L)
    public Map<String, Object> setLocale(String zimbraLocale, Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLocale", zimbraLocale);
        return attrs;
    }

    @Override
    @ZAttr(id=345L)
    public void unsetLocale() throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraLocale", "");
        this.getProvisioning().modifyAttrs(this, attrs);
    }

    @Override
    @ZAttr(id=345L)
    public Map<String, Object> unsetLocale(Map<String, Object> attrs) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        attrs.put("zimbraLocale", "");
        return attrs;
    }
}

