/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPPComponent
extends NamedEntry
implements Comparable {
    private static final String SIMPLE_CLASS_NAME = StringUtil.getSimpleClassName(XMPPComponent.class.getName());

    public XMPPComponent(String name, String id, Map<String, Object> attrs, Provisioning prov) {
        super(name, id, attrs, null, prov);
    }

    public String getComponentCategory() {
        return this.getAttr("zimbraXMPPComponentCategory");
    }

    public String getComponentType() {
        return this.getAttr("zimbraXMPPComponentType");
    }

    public String getLongName() {
        return this.getAttr("zimbraXMPPComponentName");
    }

    public String getClassName() {
        return this.getAttr("zimbraXMPPComponentClassName");
    }

    public String getShortName() throws ServiceException {
        String name = this.getName();
        Domain d = this.getDomain();
        if (d == null) {
            throw ServiceException.FAILURE("Invalid configuration data: XMPPComponent name, \"" + name + "\" points to nonexistent domain: " + this.getDomainId(), null);
        }
        String domainName = d.getName();
        if (!name.endsWith(domainName)) {
            throw ServiceException.FAILURE("Invalid configuration data: XMPPComponent name, \"" + name + "\" must be a subdomain of domain \"" + domainName + "\"", null);
        }
        String toRet = name.substring(0, name.length() - domainName.length() - 1);
        return toRet;
    }

    public List<String> getComponentFeatures() {
        ArrayList<String> toRet = null;
        String[] features = this.getMultiAttr("zimbraXMPPComponentFeatures");
        if (features != null && features.length > 0) {
            toRet = new ArrayList(features.length);
            for (String s : features) {
                toRet.add(s);
            }
        } else {
            toRet = new ArrayList<String>();
        }
        return toRet;
    }

    public String getDomainId() {
        return this.getAttr("zimbraDomainId");
    }

    public Domain getDomain() throws ServiceException {
        return Provisioning.getInstance().get(Provisioning.DomainBy.id, this.getDomainId());
    }

    public String getServerId() {
        return this.getAttr("zimbraServerId");
    }

    public Server getServer() throws ServiceException {
        return Provisioning.getInstance().get(Provisioning.ServerBy.id, this.getServerId());
    }

    @Override
    public String toString() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("name=" + this.getName());
        parts.add("category=" + this.getComponentCategory());
        parts.add("type=" + this.getComponentType());
        parts.add("domainId=" + this.getDomainId());
        try {
            Domain domain = this.getDomain();
            if (domain != null) {
                parts.add("domainName=" + domain.getName());
            }
        }
        catch (ServiceException e) {
            // empty catch block
        }
        parts.add("serverId=" + this.getServerId());
        try {
            Server server = this.getServer();
            if (server != null) {
                parts.add("serverName=" + server.getName());
            }
        }
        catch (ServiceException e) {
            // empty catch block
        }
        StringBuilder featureStr = new StringBuilder();
        for (String s : this.getComponentFeatures()) {
            if (featureStr.length() > 0) {
                featureStr.append(',');
            }
            featureStr.append(s);
        }
        return String.format("%s: { %s }", SIMPLE_CLASS_NAME, StringUtil.join(", ", parts));
    }
}

