/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountProperty;
import com.zimbra.cs.account.Provisioning;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.bidimap.DualHashBidiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signature
extends AccountProperty
implements Comparable {
    private static final DualHashBidiMap sAttrTypeMap = new DualHashBidiMap();

    public Signature(Account acct, String name, String id, Map<String, Object> attrs, Provisioning prov) {
        super(acct, name, id, attrs, null, prov);
    }

    public void setId(String id) {
        this.mId = id;
        this.getRawAttrs().put("zimbraSignatureId", id);
    }

    public Set<SignatureContent> getContents() {
        HashSet<SignatureContent> contents = new HashSet<SignatureContent>();
        for (Map.Entry entry : sAttrTypeMap.entrySet()) {
            String content = this.getAttr((String)entry.getKey());
            if (content == null) continue;
            contents.add(new SignatureContent((String)entry.getValue(), content));
        }
        return contents;
    }

    public static String mimeTypeToAttrName(String mimeType) {
        return (String)sAttrTypeMap.getKey((Object)mimeType);
    }

    public static String attrNameToMimeType(String attrName) {
        return (String)sAttrTypeMap.get((Object)attrName);
    }

    static {
        sAttrTypeMap.put((Object)"zimbraPrefMailSignature", (Object)"text/plain");
        sAttrTypeMap.put((Object)"zimbraPrefMailSignatureHTML", (Object)"text/html");
    }

    public static class SignatureContent {
        private String mMimeType;
        private String mContent;

        public SignatureContent(String mimeType, String content) {
            this.mMimeType = mimeType;
            this.mContent = content;
        }

        public String getMimeType() {
            return this.mMimeType;
        }

        public String getContent() {
            return this.mContent;
        }
    }
}

