/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.MailItem;

public class ShareInfoData {
    private String mOwnerAcctId;
    private String mOwnerAcctEmail;
    private String mOwnerAcctDisplayName;
    private int mFolderId;
    private String mFolderPath;
    private byte mFolderDefaultView;
    private short mRights;
    private byte mGranteeType;
    private String mGranteeId;
    private String mGranteeName;
    private String mGranteeDisplayName;
    private String mUrl;
    private String mGuestPassword;
    private String mMountpointId_zmprov_only;

    public void setMountpointId_zmprov_only(String mptId) {
        this.mMountpointId_zmprov_only = mptId;
    }

    public String getMountpointId_zmprov_only() {
        if (this.mMountpointId_zmprov_only == null) {
            return "";
        }
        return this.mMountpointId_zmprov_only;
    }

    public void setOwnerAcctId(String ownerAcctId) {
        this.mOwnerAcctId = ownerAcctId;
    }

    public String getOwnerAcctId() {
        return this.mOwnerAcctId;
    }

    public void setOwnerAcctEmail(String ownerAcctEmail) {
        this.mOwnerAcctEmail = ownerAcctEmail;
    }

    public String getOwnerAcctEmail() {
        return this.mOwnerAcctEmail;
    }

    public void setOwnerAcctDisplayName(String ownerAcctDisplayName) {
        this.mOwnerAcctDisplayName = ownerAcctDisplayName;
    }

    public String getOwnerAcctDisplayName() {
        return this.mOwnerAcctDisplayName;
    }

    public void setFolderId(int folderId) {
        this.mFolderId = folderId;
    }

    public int getFolderId() {
        return this.mFolderId;
    }

    public void setFolderPath(String folderPath) {
        this.mFolderPath = folderPath;
    }

    public String getFolderPath() {
        return this.mFolderPath;
    }

    public String getFolderName() {
        String[] fn = this.mFolderPath.split("/");
        return fn[fn.length - 1];
    }

    public void setFolderDefaultView(byte folderDefaultView) {
        this.mFolderDefaultView = folderDefaultView;
    }

    public String getFolderDefaultView() {
        return MailItem.getNameForType(this.mFolderDefaultView);
    }

    public byte getFolderDefaultViewCode() {
        return this.mFolderDefaultView;
    }

    public void setRights(short rights) {
        this.mRights = rights;
    }

    public String getRights() {
        return ACL.rightsToString(this.mRights);
    }

    public short getRightsCode() {
        return this.mRights;
    }

    public void setGranteeType(byte granteeType) {
        this.mGranteeType = granteeType;
    }

    public byte getGranteeTypeCode() {
        return this.mGranteeType;
    }

    public String getGranteeType() {
        return ACL.typeToString(this.mGranteeType);
    }

    public void setGranteeId(String granteeId) {
        this.mGranteeId = granteeId;
    }

    public String getGranteeId() {
        return this.mGranteeId;
    }

    public void setGranteeName(String granteeName) {
        this.mGranteeName = granteeName;
    }

    public String getGranteeName() {
        return this.mGranteeName;
    }

    public void setGranteeDisplayName(String granteeDisplayName) {
        this.mGranteeDisplayName = granteeDisplayName;
    }

    public String getGranteeDisplayName() {
        return this.mGranteeDisplayName;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setGuestPassword(String guestPassword) {
        this.mGuestPassword = guestPassword;
    }

    public String getGuestPassword() {
        return this.mGuestPassword;
    }

    public String getOwnerNotifName() {
        String notifName = this.getOwnerAcctDisplayName();
        if (notifName != null) {
            return notifName;
        }
        return this.getOwnerAcctEmail();
    }

    public String getGranteeNotifName() {
        String notifName = this.getGranteeDisplayName();
        if (notifName != null) {
            return notifName;
        }
        return this.getGranteeName();
    }

    public static ShareInfoData fromXML(Element eShare) throws ServiceException {
        ShareInfoData sid = new ShareInfoData();
        sid.setOwnerAcctId(eShare.getAttribute("ownerId", null));
        sid.setOwnerAcctEmail(eShare.getAttribute("ownerEmail", null));
        sid.setOwnerAcctDisplayName(eShare.getAttribute("ownerName", null));
        sid.setFolderId(Integer.valueOf(eShare.getAttribute("folderId")));
        sid.setFolderPath(eShare.getAttribute("folderPath", null));
        sid.setFolderDefaultView(MailItem.getTypeForName(eShare.getAttribute("view", null)));
        sid.setRights(ACL.stringToRights(eShare.getAttribute("rights")));
        sid.setGranteeType(ACL.stringToType(eShare.getAttribute("granteeType")));
        sid.setGranteeId(eShare.getAttribute("granteeId", null));
        sid.setGranteeName(eShare.getAttribute("granteeName", null));
        sid.setGranteeDisplayName(eShare.getAttribute("granteeDisplayName", null));
        sid.setMountpointId_zmprov_only(eShare.getAttribute("mid", null));
        return sid;
    }

    public void toXML(Element eShare, Integer mptId) {
        eShare.addAttribute("ownerId", this.getOwnerAcctId());
        eShare.addAttribute("ownerEmail", this.getOwnerAcctEmail());
        eShare.addAttribute("ownerName", this.getOwnerAcctDisplayName());
        eShare.addAttribute("folderId", this.getFolderId());
        eShare.addAttribute("folderPath", this.getFolderPath());
        eShare.addAttribute("view", this.getFolderDefaultView());
        eShare.addAttribute("rights", this.getRights());
        eShare.addAttribute("granteeType", this.getGranteeType());
        eShare.addAttribute("granteeId", this.getGranteeId());
        eShare.addAttribute("granteeName", this.getGranteeName());
        eShare.addAttribute("granteeDisplayName", this.getGranteeDisplayName());
        if (mptId != null) {
            eShare.addAttribute("mid", mptId.toString());
        }
    }

    public void dump() {
        String format = "    %15s : %s\n";
        System.out.println();
        System.out.printf(format, "owner id", this.getOwnerAcctId());
        System.out.printf(format, "owner email", this.getOwnerAcctEmail());
        System.out.printf(format, "owner display", this.getOwnerAcctDisplayName());
        System.out.printf(format, "folder id", String.valueOf(this.getFolderId()));
        System.out.printf(format, "folder path", this.getFolderPath());
        System.out.printf(format, "view", this.getFolderDefaultView());
        System.out.printf(format, "rights", this.getRights());
        System.out.printf(format, "mountpoint id", this.getMountpointId_zmprov_only());
        System.out.printf(format, "grantee type", this.getGranteeType());
        System.out.printf(format, "grantee id", this.getGranteeId());
        System.out.printf(format, "grantee email", this.getGranteeName());
        System.out.printf(format, "grantee display", this.getGranteeDisplayName());
        System.out.println();
    }
}

