/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.sun.mail.smtp.SMTPMessage;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ShareInfoData;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.MetadataList;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.JMSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareInfo {
    private static String S_DELIMITER = ";";
    private static final String MD_OWNER_EMAIL = "e";
    private static final String MD_OWNER_DISPLAY_NAME = "d";
    private static final String MD_FOLDER_PATH = "f";
    private static final String MD_FOLDER_DEFAULT_VIEW = "v";
    private static final String MD_GRANTEE_NAME = "gn";
    private static final String MD_GRANTEE_DISPLAY_NAME = "gd";
    protected ShareInfoData mData;
    protected MetadataList mGrants;

    public ShareInfo() {
        this.mData = new ShareInfoData();
    }

    private ShareInfo(ShareInfoData shareInfoData) {
        this.mData = shareInfoData;
    }

    public boolean hasGrant() {
        return this.mGrants != null;
    }

    protected String serialize() throws ServiceException {
        if (this.mGrants == null) {
            throw ServiceException.FAILURE("internal error, no matching grants", null);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.serializeOwnerAndFolder());
        sb.append(S_DELIMITER);
        sb.append(this.mGrants.toString());
        return sb.toString();
    }

    protected String serializeOwnerAndFolder() throws ServiceException {
        if (this.mGrants == null) {
            throw ServiceException.FAILURE("internal error, no matching grants", null);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.mData.getOwnerAcctId());
        sb.append(S_DELIMITER);
        sb.append(this.mData.getFolderId());
        return sb.toString();
    }

    protected void deserialize(String encodedShareInfo) throws ServiceException {
        String[] parts = encodedShareInfo.split(S_DELIMITER);
        if (parts.length != 3) {
            throw ServiceException.FAILURE("malformed share info: " + encodedShareInfo, null);
        }
        this.mData.setOwnerAcctId(parts[0]);
        this.mData.setFolderId(Integer.valueOf(parts[1]));
        String encodedMetadata = parts[2];
        this.mGrants = new MetadataList(encodedMetadata);
    }

    private static boolean matchesGranteeType(byte onTheGrant, byte wanted) {
        return wanted == 0 || onTheGrant == wanted;
    }

    private static String granteeName(Provisioning prov, ACL.Grant grant) throws ServiceException {
        String granteeId = grant.getGranteeId();
        byte granteeType = grant.getGranteeType();
        String granteeName = "";
        if (granteeType == 1) {
            Account acct = prov.get(Provisioning.AccountBy.id, granteeId);
            if (acct != null) {
                granteeName = acct.getName();
            }
        } else if (granteeType == 2) {
            DistributionList dl = prov.get(Provisioning.DistributionListBy.id, granteeId);
            if (dl != null) {
                granteeName = dl.getName();
            }
        } else if (granteeType == 5) {
            Cos cos = prov.get(Provisioning.CosBy.id, granteeId);
            if (cos != null) {
                granteeName = cos.getName();
            }
        } else if (granteeType == 4) {
            Domain domain = prov.get(Provisioning.DomainBy.id, granteeId);
            if (domain != null) {
                granteeName = domain.getName();
            }
        } else {
            granteeName = ACL.typeToString(granteeType);
        }
        return granteeName;
    }

    private static String granteeDisplay(Provisioning prov, ACL.Grant grant) throws ServiceException {
        String granteeId = grant.getGranteeId();
        byte granteeType = grant.getGranteeType();
        String granteeDisplay = "";
        if (granteeType == 1) {
            Account acct = prov.get(Provisioning.AccountBy.id, granteeId);
            if (acct != null) {
                granteeDisplay = acct.getDisplayName();
            }
        } else if (granteeType == 2) {
            DistributionList dl = prov.get(Provisioning.DistributionListBy.id, granteeId);
            if (dl != null) {
                granteeDisplay = dl.getDisplayName();
            }
        } else if (granteeType == 5) {
            Cos cos = prov.get(Provisioning.CosBy.id, granteeId);
            if (cos != null) {
                granteeDisplay = cos.getName();
            }
        } else if (granteeType == 4) {
            Domain domain = prov.get(Provisioning.DomainBy.id, granteeId);
            if (domain != null) {
                granteeDisplay = domain.getName();
            }
        } else {
            granteeDisplay = ACL.typeToString(granteeType);
        }
        return granteeDisplay;
    }

    private static Set<Folder> getVisibleFolders(OperationContext octxt, Mailbox mbox) throws ServiceException {
        Set<Folder> folders = mbox.getVisibleFolders(octxt);
        if (folders == null) {
            Mailbox.FolderNode root = mbox.getFolderTree(octxt, null, false);
            folders = ShareInfo.flattenAndSortFolderTree(root);
        }
        return folders;
    }

    private static Set<Folder> flattenAndSortFolderTree(Mailbox.FolderNode root) {
        HashSet<Folder> folders = new HashSet<Folder>();
        ShareInfo.flattenAndSortFolderTree(root, folders);
        return folders;
    }

    private static void flattenAndSortFolderTree(Mailbox.FolderNode node, Set<Folder> flattened) {
        if (node.mFolder != null) {
            flattened.add(node.mFolder);
        }
        for (Mailbox.FolderNode subNode : node.mSubfolders) {
            ShareInfo.flattenAndSortFolderTree(subNode, flattened);
        }
    }

    public static class DumpShareInfoVisitor
    implements Provisioning.PublishedShareInfoVisitor {
        private static final String mFormat = "%-36.36s %-15.15s %-15.15s %-5.5s %-20.20s %-10.10s %-10.10s %-5.5s %-5.5s %-36.36s %-15.15s %-15.15s\n";

        public static void printHeadings() {
            System.out.printf(mFormat, "owner id", "owner email", "owner display", "fid", "folder path", "view", "rights", "mid", "gt", "grantee id", "grantee name", "grantee display");
            System.out.printf(mFormat, "------------------------------------", "---------------", "---------------", "-----", "--------------------", "----------", "----------", "-----", "-----", "------------------------------------", "---------------", "---------------");
        }

        public void visit(ShareInfoData shareInfoData) throws ServiceException {
            System.out.printf(mFormat, shareInfoData.getOwnerAcctId(), shareInfoData.getOwnerAcctEmail(), shareInfoData.getOwnerAcctDisplayName(), String.valueOf(shareInfoData.getFolderId()), shareInfoData.getFolderPath(), shareInfoData.getFolderDefaultView(), shareInfoData.getRights(), shareInfoData.getMountpointId_zmprov_only(), shareInfoData.getGranteeType(), shareInfoData.getGranteeId(), shareInfoData.getGranteeName(), shareInfoData.getGranteeDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotificationSender {
        private static final short ROLE_VIEW = 1;
        private static final short ROLE_ADMIN = 287;
        private static final short ROLE_MANAGER = 31;

        public static MimeMultipart genNotifBody(ShareInfoData sid, L10nUtil.MsgKey intro, String notes, Locale locale) throws MessagingException {
            MimeMultipart mmp = new MimeMultipart("alternative");
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(NotificationSender.genTextPart(sid, intro, notes, locale, null), "utf-8");
            mmp.addBodyPart((BodyPart)textPart);
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setDataHandler(new DataHandler(new HtmlPartDataSource(NotificationSender.genHtmlPart(sid, intro, notes, locale, null))));
            mmp.addBodyPart((BodyPart)htmlPart);
            MimeBodyPart xmlPart = new MimeBodyPart();
            xmlPart.setDataHandler(new DataHandler(new XmlPartDataSource(NotificationSender.genXmlPart(sid, notes, locale, null))));
            mmp.addBodyPart((BodyPart)xmlPart);
            return mmp;
        }

        private static String genTextPart(ShareInfoData sid, L10nUtil.MsgKey intro, String senderNotes, Locale locale, StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("\n");
            if (intro != null) {
                sb.append(L10nUtil.getMessage(intro, locale, new Object[0]));
                sb.append("\n\n");
            }
            sb.append(NotificationSender.formatTextShareInfo(L10nUtil.MsgKey.shareNotifBodySharedItem, sid.getFolderName(), locale, NotificationSender.formatFolderDesc(locale, sid)));
            sb.append(NotificationSender.formatTextShareInfo(L10nUtil.MsgKey.shareNotifBodyOwner, sid.getOwnerNotifName(), locale, null));
            sb.append("\n");
            sb.append(NotificationSender.formatTextShareInfo(L10nUtil.MsgKey.shareNotifBodyGrantee, sid.getGranteeNotifName(), locale, null));
            sb.append(NotificationSender.formatTextShareInfo(L10nUtil.MsgKey.shareNotifBodyRole, NotificationSender.getRoleFromRights(sid, locale), locale, null));
            sb.append(NotificationSender.formatTextShareInfo(L10nUtil.MsgKey.shareNotifBodyAllowedActions, NotificationSender.getRightsText(sid, locale), locale, null));
            sb.append("\n");
            String notes = null;
            if (sid.getGranteeTypeCode() == 7) {
                StringBuilder guestNotes = new StringBuilder();
                guestNotes.append("URL: " + sid.getUrl() + "\n");
                guestNotes.append("Username: " + sid.getGranteeName() + "\n");
                guestNotes.append("Password: " + sid.getGuestPassword() + "\n");
                guestNotes.append("\n");
                notes = guestNotes + (senderNotes == null ? "" : senderNotes) + "\n";
            } else {
                notes = senderNotes;
            }
            if (notes != null) {
                sb.append("*~*~*~*~*~*~*~*~*~*\n");
                sb.append(notes + "\n");
            }
            return sb.toString();
        }

        private static String genHtmlPart(ShareInfoData sid, L10nUtil.MsgKey intro, String senderNotes, Locale locale, StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (intro != null) {
                sb.append("<h3>" + L10nUtil.getMessage(intro, locale, new Object[0]) + "</h3>\n");
            }
            sb.append("<p>\n");
            sb.append("<table border=\"0\">\n");
            sb.append(NotificationSender.formatHtmlShareInfo(L10nUtil.MsgKey.shareNotifBodySharedItem, sid.getFolderName(), locale, NotificationSender.formatFolderDesc(locale, sid)));
            sb.append(NotificationSender.formatHtmlShareInfo(L10nUtil.MsgKey.shareNotifBodyOwner, sid.getOwnerNotifName(), locale, null));
            sb.append("</table>\n");
            sb.append("</p>\n");
            sb.append("<table border=\"0\">\n");
            sb.append(NotificationSender.formatHtmlShareInfo(L10nUtil.MsgKey.shareNotifBodyGrantee, sid.getGranteeNotifName(), locale, null));
            sb.append(NotificationSender.formatHtmlShareInfo(L10nUtil.MsgKey.shareNotifBodyRole, NotificationSender.getRoleFromRights(sid, locale), locale, null));
            sb.append(NotificationSender.formatHtmlShareInfo(L10nUtil.MsgKey.shareNotifBodyAllowedActions, NotificationSender.getRightsText(sid, locale), locale, null));
            sb.append("</table>\n");
            if (sid.getGranteeTypeCode() == 7) {
                sb.append("<p>\n");
                sb.append("<table border=\"0\">\n");
                sb.append("<tr valign=\"top\"><th align=\"left\">" + L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyNotes, new Object[0]) + ":" + "</th><td>" + "URL: " + sid.getUrl() + "<br>" + "Username: " + sid.getGranteeName() + "<br>" + "Password: " + sid.getGuestPassword() + "<br><br>");
                if (senderNotes != null) {
                    sb.append(senderNotes);
                }
                sb.append("</td></tr></table>\n");
                sb.append("</p>\n");
            } else if (senderNotes != null) {
                sb.append("<p>\n");
                sb.append("<table border=\"0\">\n");
                sb.append("<tr valign=\"top\"><th align=\"left\">" + L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyNotes, new Object[0]) + ":" + "</th><td>" + senderNotes + "</td></tr></table>\n");
                sb.append("</p>\n");
            }
            return sb.toString();
        }

        private static String genXmlPart(ShareInfoData sid, String senderNotes, Locale locale, StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            String URI2 = "urn:zimbraShare";
            String VERSION = "0.1";
            String notes = null;
            if (sid.getGranteeTypeCode() == 7) {
                StringBuilder guestNotes = new StringBuilder();
                guestNotes.append("URL: " + sid.getUrl() + "\n");
                guestNotes.append("Username: " + sid.getGranteeName() + "\n");
                guestNotes.append("Password: " + sid.getGuestPassword() + "\n");
                guestNotes.append("\n");
                notes = guestNotes + (senderNotes == null ? "" : senderNotes) + "\n";
            } else {
                notes = senderNotes;
            }
            sb.append("<share xmlns=\"urn:zimbraShare\" version=\"0.1\" action=\"new\">\n");
            sb.append("  <grantee id=\"" + sid.getGranteeId() + "\" email=\"" + sid.getGranteeName() + "\" name=\"" + sid.getGranteeNotifName() + "\"/>\n");
            sb.append("  <grantor id=\"" + sid.getOwnerAcctId() + "\" email=\"" + sid.getOwnerAcctEmail() + "\" name=\"" + sid.getOwnerNotifName() + "\"/>\n");
            sb.append("  <link id=\"" + sid.getFolderId() + "\" name=\"" + sid.getFolderName() + "\" view=\"" + sid.getFolderDefaultView() + "\" perm=\"" + ACL.rightsToString(sid.getRightsCode()) + "\"/>\n");
            sb.append("  <notes>" + (notes == null ? "" : notes) + "</notes>\n");
            sb.append("</share>\n");
            return sb.toString();
        }

        private static String formatTextShareInfo(L10nUtil.MsgKey key, String value, Locale locale, String extra) {
            return L10nUtil.getMessage(key, locale, new Object[0]) + ": " + value + (extra == null ? "" : " " + extra) + "\n";
        }

        private static String formatHtmlShareInfo(L10nUtil.MsgKey key, String value, Locale locale, String extra) {
            return "<tr><th align=\"left\">" + L10nUtil.getMessage(key, locale, new Object[0]) + ":" + "</th>" + "<td align=\"left\">" + value + (extra == null ? "" : " " + extra) + "</td>" + "</tr>\n";
        }

        private static void appendCommaSeparated(StringBuffer sb, String s) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }

        private static String getRoleFromRights(ShareInfoData sid, Locale locale) {
            short rights = sid.getRightsCode();
            if (1 == rights) {
                return L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyGranteeRoleViewer, locale, new Object[0]);
            }
            if (287 == rights) {
                return L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyGranteeRoleAdmin, locale, new Object[0]);
            }
            if (31 == rights) {
                return L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyGranteeRoleManager, locale, new Object[0]);
            }
            return "";
        }

        private static String getRightsText(ShareInfoData sid, Locale locale) {
            short rights = sid.getRightsCode();
            StringBuffer r = new StringBuffer();
            if ((rights & 1) != 0) {
                NotificationSender.appendCommaSeparated(r, L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyActionRead, locale, new Object[0]));
            }
            if ((rights & 2) != 0) {
                NotificationSender.appendCommaSeparated(r, L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyActionWrite, locale, new Object[0]));
            }
            if ((rights & 4) != 0) {
                NotificationSender.appendCommaSeparated(r, L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyActionInsert, locale, new Object[0]));
            }
            if ((rights & 8) != 0) {
                NotificationSender.appendCommaSeparated(r, L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyActionDelete, locale, new Object[0]));
            }
            if ((rights & 0x10) != 0) {
                NotificationSender.appendCommaSeparated(r, L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyActionAction, locale, new Object[0]));
            }
            if ((rights & 0x100) != 0) {
                NotificationSender.appendCommaSeparated(r, L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyActionAdmin, locale, new Object[0]));
            }
            if ((rights & 0x400) != 0) {
                NotificationSender.appendCommaSeparated(r, L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyActionPrivate, locale, new Object[0]));
            }
            if ((rights & 0x800) != 0) {
                NotificationSender.appendCommaSeparated(r, L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyActionFreebusy, locale, new Object[0]));
            }
            if ((rights & 0x200) != 0) {
                NotificationSender.appendCommaSeparated(r, L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyActionSubfolder, locale, new Object[0]));
            }
            return r.toString();
        }

        private static String formatFolderDesc(Locale locale, ShareInfoData sid) {
            byte view = sid.getFolderDefaultViewCode();
            String folderView = view == 5 ? "Mail" : (view == 11 ? "Calendar" : (view == 15 ? "Task" : (view == 6 ? "Addres" : (view == 14 ? "Notebook" : sid.getFolderDefaultView()))));
            return L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyFolderDesc, locale, folderView);
        }

        private static boolean sendOneMailPerShare() {
            return true;
        }

        public static void sendShareInfoMessage(OperationContext octxt, DistributionList dl, String[] members) {
            Provisioning prov = Provisioning.getInstance();
            Account authedAcct = octxt.getAuthenticatedUser();
            MailSenderVisitor visitor = new MailSenderVisitor();
            try {
                Published.getPublished(prov, dl, false, null, visitor);
            }
            catch (ServiceException e) {
                ZimbraLog.account.warn((Object)("failed to retrieve share info for dl: " + dl.getName()), e);
                return;
            }
            if (visitor.getNumShareInfo() == 0) {
                return;
            }
            try {
                for (String member : members) {
                    NotificationSender.sendMessage(prov, authedAcct, dl, member, visitor);
                }
            }
            catch (ServiceException e) {
                ZimbraLog.account.warn((Object)"failed to send share info message", e);
            }
        }

        private static Locale getLocale(Provisioning prov, Account fromAcct, String toAddr) throws ServiceException {
            Account rcptAcct = prov.get(Provisioning.AccountBy.name, toAddr);
            Locale locale = rcptAcct != null ? rcptAcct.getLocale() : (fromAcct != null ? fromAcct.getLocale() : prov.getConfig().getLocale());
            return locale;
        }

        private static Pair<Address, Address> getFromAndReplyToAddr(Provisioning prov, Account fromAcct, DistributionList dl) throws AddressException {
            InternetAddress addr;
            String dlssmfa = dl.getAttr("zimbraDistributionListSendShareMessageFromAddress");
            try {
                if (dlssmfa != null) {
                    InternetAddress addr2 = new InternetAddress(dlssmfa);
                    return new Pair<InternetAddress, InternetAddress>(addr2, addr2);
                }
            }
            catch (AddressException e) {
                ZimbraLog.account.warn((Object)("invalid address in zimbraDistributionListSendShareMessageFromAddress on distribution list entry " + dl.getName() + ", ignored"), e);
            }
            if (fromAcct != null) {
                addr = AccountUtil.getFriendlyEmailAddress(fromAcct);
                try {
                    addr.validate();
                    InternetAddress replyToAddr = addr;
                    String replyTo = fromAcct.getAttr("zimbraPrefReplyToAddress");
                    if (replyTo != null) {
                        replyToAddr = new InternetAddress(replyTo);
                    }
                    return new Pair<InternetAddress, InternetAddress>(addr, replyToAddr);
                }
                catch (AddressException e) {
                    // empty catch block
                }
            }
            addr = new InternetAddress(dl.getName());
            return new Pair<InternetAddress, InternetAddress>(addr, addr);
        }

        private static MimeMultipart buildMailContent(DistributionList dl, MailSenderVisitor visitor, Locale locale, Integer idx) throws MessagingException {
            String shareInfoText = visitor.genText(dl.getName(), locale, idx);
            String shareInfoHtml = visitor.genHtml(dl.getName(), locale, idx);
            String shareInfoXml = null;
            if (idx != null) {
                shareInfoXml = visitor.genXml(dl.getName(), locale, idx);
            }
            MimeMultipart mmp = new MimeMultipart("alternative");
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(shareInfoText, "utf-8");
            mmp.addBodyPart((BodyPart)textPart);
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setDataHandler(new DataHandler(new HtmlPartDataSource(shareInfoHtml)));
            mmp.addBodyPart((BodyPart)htmlPart);
            if (shareInfoXml != null) {
                MimeBodyPart xmlPart = new MimeBodyPart();
                xmlPart.setDataHandler(new DataHandler(new XmlPartDataSource(shareInfoXml)));
                mmp.addBodyPart((BodyPart)xmlPart);
            }
            return mmp;
        }

        private static void buildContentAndSend(SMTPMessage out, DistributionList dl, MailSenderVisitor visitor, Locale locale, Integer idx) throws MessagingException {
            MimeMultipart mmp = NotificationSender.buildMailContent(dl, visitor, locale, (int)idx);
            out.setContent((Multipart)mmp);
            Transport.send((Message)out);
            Address[] rcpts = out.getRecipients(Message.RecipientType.TO);
            StringBuilder rcptAddr = new StringBuilder();
            for (Address a : rcpts) {
                rcptAddr.append(a.toString());
            }
            ZimbraLog.account.info("share info notification sent rcpt='" + rcptAddr + "' Message-ID=" + out.getMessageID());
        }

        private static void sendMessage(Provisioning prov, Account fromAcct, DistributionList dl, String toAddr, MailSenderVisitor visitor) throws ServiceException {
            try {
                SMTPMessage out = new SMTPMessage(JMSession.getSession());
                Pair<Address, Address> senderAddrs = NotificationSender.getFromAndReplyToAddr(prov, fromAcct, dl);
                Address fromAddr = senderAddrs.getFirst();
                Address replyToAddr = senderAddrs.getSecond();
                out.setFrom(fromAddr);
                out.setReplyTo(new Address[]{replyToAddr});
                out.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddr));
                out.setSentDate(new Date());
                Locale locale = NotificationSender.getLocale(prov, fromAcct, toAddr);
                String subject = L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifSubject, locale, new Object[0]);
                out.setSubject(subject);
                if (NotificationSender.sendOneMailPerShare()) {
                    int numShareInfo = visitor.getNumShareInfo();
                    for (int idx = 0; idx < numShareInfo; ++idx) {
                        NotificationSender.buildContentAndSend(out, dl, visitor, locale, idx);
                    }
                } else {
                    NotificationSender.buildContentAndSend(out, dl, visitor, locale, null);
                }
            }
            catch (MessagingException e) {
                ZimbraLog.account.warn((Object)("send share info notification failed rcpt='" + toAddr + "'"), e);
            }
        }

        private static class XmlPartDataSource
        extends MimePartDataSource {
            private static final String CONTENT_TYPE = "xml/x-zimbra-share; charset=utf-8";
            private static final String NAME = "XmlDataSource";

            XmlPartDataSource(String text) {
                super(text);
            }

            public String getContentType() {
                return CONTENT_TYPE;
            }

            public String getName() {
                return NAME;
            }
        }

        private static class HtmlPartDataSource
        extends MimePartDataSource {
            private static final String CONTENT_TYPE = "text/html; charset=utf-8";
            private static final String NAME = "HtmlDataSource";

            HtmlPartDataSource(String text) {
                super(text);
            }

            public String getContentType() {
                return CONTENT_TYPE;
            }

            public String getName() {
                return NAME;
            }
        }

        private static abstract class MimePartDataSource
        implements DataSource {
            private String mText;
            private byte[] mBuf = null;

            public MimePartDataSource(String text) {
                this.mText = text;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public InputStream getInputStream() throws IOException {
                MimePartDataSource mimePartDataSource = this;
                synchronized (mimePartDataSource) {
                    if (this.mBuf == null) {
                        ByteArrayOutputStream buf = new ByteArrayOutputStream();
                        OutputStreamWriter wout = new OutputStreamWriter((OutputStream)buf, "utf-8");
                        String text = this.mText;
                        wout.write(text);
                        wout.flush();
                        this.mBuf = buf.toByteArray();
                    }
                }
                ByteArrayInputStream in = new ByteArrayInputStream(this.mBuf);
                return in;
            }

            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException();
            }
        }

        private static class MailSenderVisitor
        implements Provisioning.PublishedShareInfoVisitor {
            List<ShareInfoData> mShares = new ArrayList<ShareInfoData>();

            private MailSenderVisitor() {
            }

            public void visit(ShareInfoData sid) throws ServiceException {
                this.mShares.add(sid);
            }

            private int getNumShareInfo() {
                return this.mShares.size();
            }

            private String genText(String dlName, Locale locale, Integer idx) {
                StringBuilder sb = new StringBuilder();
                sb.append("\n");
                sb.append(L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyAddedToGroup1, locale, dlName));
                sb.append("\n\n");
                sb.append(L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyAddedToGroup2, locale, dlName));
                sb.append("\n\n");
                if (idx == null) {
                    for (ShareInfoData sid : this.mShares) {
                        NotificationSender.genTextPart(sid, null, null, locale, sb);
                    }
                } else {
                    NotificationSender.genTextPart(this.mShares.get(idx), null, null, locale, sb);
                }
                sb.append("\n\n");
                return sb.toString();
            }

            private String genHtml(String dlName, Locale locale, Integer idx) {
                StringBuilder sb = new StringBuilder();
                sb.append("<h4>\n");
                sb.append("<p>" + L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyAddedToGroup1, locale, dlName) + "</p>\n");
                sb.append("<p>" + L10nUtil.getMessage(L10nUtil.MsgKey.shareNotifBodyAddedToGroup2, locale, dlName) + "</p>\n");
                sb.append("</h4>\n");
                sb.append("\n");
                if (idx == null) {
                    for (ShareInfoData sid : this.mShares) {
                        NotificationSender.genHtmlPart(sid, null, null, locale, sb);
                    }
                } else {
                    NotificationSender.genHtmlPart(this.mShares.get(idx), null, null, locale, sb);
                }
                return sb.toString();
            }

            private String genXml(String dlName, Locale locale, Integer idx) {
                StringBuilder sb = new StringBuilder();
                if (idx == null) {
                    for (ShareInfoData sid : this.mShares) {
                        NotificationSender.genXmlPart(sid, null, locale, sb);
                    }
                } else {
                    NotificationSender.genXmlPart(this.mShares.get(idx), null, locale, sb);
                }
                return sb.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Published
    extends ShareInfo {
        private String mDigest;

        private static List<Published> decodeMetadata(String encoded) throws ServiceException {
            ArrayList<Published> siList = new ArrayList<Published>();
            Published si = new Published(encoded);
            String ownerAcctId = si.mData.getOwnerAcctId();
            int folderId = si.mData.getFolderId();
            Metadata metadata = si.mGrants.getMap(0);
            String ownerAcctEmail = metadata.get(ShareInfo.MD_OWNER_EMAIL);
            String ownerAcctDisplayName = metadata.get(ShareInfo.MD_OWNER_DISPLAY_NAME, null);
            String folderPath = metadata.get(ShareInfo.MD_FOLDER_PATH);
            byte folderDefaultView = (byte)metadata.getLong(ShareInfo.MD_FOLDER_DEFAULT_VIEW);
            for (int i = 1; i < si.mGrants.size(); ++i) {
                metadata = si.mGrants.getMap(i);
                ACL.Grant grant = new ACL.Grant(metadata);
                short rights = grant.getGrantedRights();
                byte granteeType = grant.getGranteeType();
                String granteeId = grant.getGranteeId();
                String granteeName = metadata.get(ShareInfo.MD_GRANTEE_NAME);
                String granteeDisplayName = metadata.get(ShareInfo.MD_GRANTEE_DISPLAY_NAME, null);
                Published p = new Published(ownerAcctId, ownerAcctEmail, ownerAcctDisplayName, folderId, folderPath, folderDefaultView, rights, granteeType, granteeId, granteeName, granteeDisplayName);
                siList.add(p);
            }
            return siList;
        }

        private Published(String encodedShareInfo) throws ServiceException {
            this.deserialize(encodedShareInfo);
        }

        private Published() {
        }

        private Published(String ownerAcctId, String ownerAcctEmail, String ownerAcctDisplayName, int folderId, String folderPath, byte folderDefaultView, short rights, byte granteeType, String granteeId, String granteeName, String granteeDisplayName) {
            this.mData.setOwnerAcctId(ownerAcctId);
            this.mData.setOwnerAcctEmail(ownerAcctEmail);
            this.mData.setOwnerAcctDisplayName(ownerAcctDisplayName);
            this.mData.setFolderId(folderId);
            this.mData.setFolderPath(folderPath);
            this.mData.setFolderDefaultView(folderDefaultView);
            this.mData.setRights(rights);
            this.mData.setGranteeType(granteeType);
            this.mData.setGranteeId(granteeId);
            this.mData.setGranteeName(granteeName);
            this.mData.setGranteeDisplayName(granteeDisplayName);
            this.mDigest = this.mData.getOwnerAcctEmail() + this.mData.getFolderPath() + this.mData.getRightsCode() + this.mData.getGranteeType() + this.mData.getGranteeId() + this.mData.getGranteeName();
        }

        private String getDigest() {
            return this.mDigest;
        }

        public static void get(Provisioning prov, Account acct, byte granteeType, Account owner, Provisioning.PublishedShareInfoVisitor visitor) throws ServiceException {
            HashSet<String> visited = new HashSet<String>();
            if (granteeType == 0) {
                Provisioning.AclGroups aclGroups = prov.getAclGroups(acct, false);
                Published.getSharesPublishedOnGroups(prov, visitor, aclGroups, owner, visited);
            } else if (granteeType != 1) {
                if (granteeType == 2) {
                    Provisioning.AclGroups aclGroups = prov.getAclGroups(acct, false);
                    Published.getSharesPublishedOnGroups(prov, visitor, aclGroups, owner, visited);
                } else {
                    throw ServiceException.INVALID_REQUEST("unsupported grantee type", null);
                }
            }
        }

        public static void getPublished(Provisioning prov, DistributionList dl, boolean directOnly, Account owner, Provisioning.PublishedShareInfoVisitor visitor) throws ServiceException {
            HashSet<String> visited = new HashSet<String>();
            Published.getPublishedShares(visitor, dl, owner, visited);
            if (!directOnly) {
                if (!dl.isAclGroup()) {
                    dl = prov.getAclGroup(Provisioning.DistributionListBy.id, dl.getId());
                }
                Provisioning.AclGroups aclGroups = prov.getAclGroups(dl, false);
                Published.getSharesPublishedOnGroups(prov, visitor, aclGroups, owner, visited);
            }
        }

        public static void unpublish(Provisioning prov, DistributionList dl, String ownerAcctId, String ownerAcctEmail, boolean allOwners, String folderId, String folderPath, boolean allFolders) throws ServiceException {
            Matcher matcher = new Matcher(ownerAcctId, ownerAcctEmail, allOwners, folderId, folderPath, allFolders);
            Set<String> publishedShareInfo = dl.getMultiAttrSet("zimbraShareInfo");
            String removeKey = "-zimbraShareInfo";
            HashSet<String> toRemove = new HashSet<String>();
            for (String psi : publishedShareInfo) {
                try {
                    List<Published> siList = Published.decodeMetadata(psi);
                    for (Published si : siList) {
                        if (!matcher.matches(si.mData)) continue;
                        toRemove.add(psi);
                    }
                }
                catch (ServiceException e) {
                    ZimbraLog.account.warn((Object)"unable to process share info", e);
                }
            }
            HashMap<String, HashSet<String>> attrs = new HashMap<String, HashSet<String>>();
            attrs.put(removeKey, toRemove);
            prov.modifyAttrs(dl, attrs);
        }

        private static void getSharesPublishedOnGroups(Provisioning prov, Provisioning.PublishedShareInfoVisitor visitor, Provisioning.AclGroups aclGroups, Account owner, Set<String> visited) throws ServiceException {
            for (String groupId : aclGroups.groupIds()) {
                DistributionList group = prov.get(Provisioning.DistributionListBy.id, groupId);
                Published.getPublishedShares(visitor, group, owner, visited);
            }
        }

        private static void getPublishedShares(Provisioning.PublishedShareInfoVisitor visitor, NamedEntry entry, Account owner, Set<String> visited) {
            Set<String> publishedShareInfo = entry.getMultiAttrSet("zimbraShareInfo");
            for (String psi : publishedShareInfo) {
                try {
                    List<Published> siList = Published.decodeMetadata(psi);
                    for (Published si : siList) {
                        if (owner != null && !owner.getId().equals(si.mData.getOwnerAcctId()) || visited.contains(si.getDigest())) continue;
                        visitor.visit(si.mData);
                        visited.add(si.getDigest());
                    }
                }
                catch (ServiceException e) {
                    ZimbraLog.account.warn((Object)"unable to process share info", e);
                }
            }
        }

        private static class Matcher {
            private String mOwnerAcctId;
            private String mOwnerAcctEmail;
            private boolean mAllOwners;
            private String mFolderId;
            private String mFolderPath;
            private boolean mAllFolders;

            private Matcher(String ownerAcctId, String ownerAcctEmail, boolean allOwners, String folderId, String folderPath, boolean allFolders) {
                this.mOwnerAcctId = ownerAcctId;
                this.mOwnerAcctEmail = ownerAcctEmail;
                this.mAllOwners = allOwners;
                this.mFolderId = folderId;
                this.mFolderPath = folderPath;
                this.mAllFolders = allFolders;
            }

            private boolean matches(ShareInfoData sid) {
                return this.matchOwner(sid) && this.matchFolder(sid);
            }

            private boolean matchOwner(ShareInfoData sid) {
                if (this.mAllOwners) {
                    return true;
                }
                if (this.mOwnerAcctId != null) {
                    return this.mOwnerAcctId.equals(sid.getOwnerAcctId());
                }
                if (this.mOwnerAcctEmail != null) {
                    return this.mOwnerAcctEmail.equals(sid.getOwnerAcctEmail());
                }
                return false;
            }

            private boolean matchFolder(ShareInfoData sid) {
                if (this.mAllFolders) {
                    return true;
                }
                if (this.mFolderId != null) {
                    return this.mFolderId.equals(String.valueOf(sid.getFolderId()));
                }
                if (this.mFolderPath != null) {
                    return this.mFolderPath.equals(sid.getFolderPath());
                }
                return false;
            }
        }
    }

    public static class Publishing
    extends ShareInfo {
        public static void publish(Provisioning prov, OperationContext octxt, NamedEntry publishingOnEntry, Account ownerAcct, Folder folder) throws ServiceException {
            if (folder == null) {
                Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(ownerAcct, false);
                if (mbox == null) {
                    throw ServiceException.FAILURE("mailbox not found for account " + ownerAcct.getId(), null);
                }
                Set folders = ShareInfo.getVisibleFolders(octxt, mbox);
                for (Folder f : folders) {
                    Publishing.doPublish(prov, publishingOnEntry, ownerAcct, f);
                }
            } else {
                Publishing.doPublish(prov, publishingOnEntry, ownerAcct, folder);
            }
        }

        private static void doPublish(Provisioning prov, NamedEntry publishingOnEntry, Account ownerAcct, Folder folder) throws ServiceException {
            Publishing si = new Publishing(ownerAcct, folder);
            si.discoverGrants(folder, publishingOnEntry);
            if (si.hasGrant()) {
                si.persist(prov, publishingOnEntry);
            }
        }

        private Publishing(Account ownerAcct, Folder folder) {
            this.mData.setOwnerAcctId(ownerAcct.getId());
            this.mData.setOwnerAcctEmail(ownerAcct.getName());
            this.mData.setOwnerAcctDisplayName(ownerAcct.getDisplayName());
            this.mData.setFolderId(folder.getId());
        }

        private void discoverGrants(Folder folder, NamedEntry publishingOnEntry) throws ServiceException {
            Provisioning prov = Provisioning.getInstance();
            ACL acl = folder.getEffectiveACL();
            if (acl == null) {
                return;
            }
            for (ACL.Grant grant : acl.getGrants()) {
                if (!this.matches(grant, publishingOnEntry)) continue;
                if (this.mGrants == null) {
                    this.mGrants = new MetadataList();
                    Metadata md = new Metadata();
                    md.put(ShareInfo.MD_OWNER_EMAIL, this.mData.getOwnerAcctEmail());
                    md.put(ShareInfo.MD_OWNER_DISPLAY_NAME, this.mData.getOwnerAcctDisplayName());
                    md.put(ShareInfo.MD_FOLDER_PATH, folder.getPath());
                    md.put(ShareInfo.MD_FOLDER_DEFAULT_VIEW, folder.getDefaultView());
                    this.mGrants.add(md);
                }
                Metadata metadata = grant.encode();
                metadata.put(ShareInfo.MD_GRANTEE_NAME, ShareInfo.granteeName(prov, grant));
                metadata.put(ShareInfo.MD_GRANTEE_DISPLAY_NAME, ShareInfo.granteeDisplay(prov, grant));
                this.mGrants.add(metadata);
            }
        }

        private boolean matches(ACL.Grant grant, NamedEntry publishingOnEntry) throws ServiceException {
            String granteeId = grant.getGranteeId();
            byte granteeType = grant.getGranteeType();
            if (publishingOnEntry instanceof DistributionList) {
                if (granteeType != 2 || granteeId == null) {
                    return false;
                }
                return granteeId.equals(publishingOnEntry.getId()) || Provisioning.getInstance().inDistributionList((DistributionList)publishingOnEntry, granteeId);
            }
            throw ServiceException.FAILURE("internal", null);
        }

        public void persist(Provisioning prov, NamedEntry publishingOnEntry) throws ServiceException {
            Set<String> curShareInfo = publishingOnEntry.getMultiAttrSet("zimbraShareInfo");
            String addKey = "+zimbraShareInfo";
            String removeKey = "-zimbraShareInfo";
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            String value = this.serialize();
            attrs.put(addKey, value);
            HashSet<String> toRemove = new HashSet<String>();
            String ownerAndFoler = this.serializeOwnerAndFolder();
            for (String curSi : curShareInfo) {
                if (!curSi.startsWith(ownerAndFoler) || curSi.equals(value)) continue;
                toRemove.add(curSi);
            }
            if (!toRemove.isEmpty()) {
                attrs.put(removeKey, toRemove);
            }
            prov.modifyAttrs(publishingOnEntry, attrs);
        }
    }

    public static class Discover
    extends ShareInfo {
        public static void discover(OperationContext octxt, Provisioning prov, Account targetAcct, byte granteeType, Account ownerAcct, Provisioning.PublishedShareInfoVisitor visitor) throws ServiceException {
            Mailbox ownerMbox = MailboxManager.getInstance().getMailboxByAccount(ownerAcct, false);
            if (ownerMbox == null) {
                throw ServiceException.FAILURE("mailbox not found for account " + ownerAcct.getId(), null);
            }
            Set folders = ShareInfo.getVisibleFolders(octxt, ownerMbox);
            for (Folder folder : folders) {
                Discover.doDiscover(prov, targetAcct, granteeType, ownerAcct, folder, visitor);
            }
        }

        private static void doDiscover(Provisioning prov, Account targetAcct, byte granteeType, Account ownerAcct, Folder folder, Provisioning.PublishedShareInfoVisitor visitor) throws ServiceException {
            ACL acl = folder.getEffectiveACL();
            if (acl == null) {
                return;
            }
            for (ACL.Grant grant : acl.getGrants()) {
                if (targetAcct != null && !grant.matches(targetAcct) || !ShareInfo.matchesGranteeType(grant.getGranteeType(), granteeType)) continue;
                ShareInfo si = new ShareInfo();
                si.mData.setOwnerAcctId(ownerAcct.getId());
                si.mData.setOwnerAcctEmail(ownerAcct.getName());
                si.mData.setOwnerAcctDisplayName(ownerAcct.getDisplayName());
                si.mData.setFolderId(folder.getId());
                si.mData.setFolderPath(folder.getPath());
                si.mData.setFolderDefaultView(folder.getDefaultView());
                si.mData.setRights(grant.getGrantedRights());
                si.mData.setGranteeType(grant.getGranteeType());
                si.mData.setGranteeId(grant.getGranteeId());
                si.mData.setGranteeName(ShareInfo.granteeName(prov, grant));
                si.mData.setGranteeDisplayName(ShareInfo.granteeDisplay(prov, grant));
                visitor.visit(si.mData);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MountedFolders {
        private Map<String, Integer> mMountedFolders;

        public MountedFolders(OperationContext octxt, Account acct) throws ServiceException {
            this.mMountedFolders = this.getLocalMountpoints(octxt, acct);
        }

        public Integer getLocalFolderId(String ownerAcctId, int remoteFolderId) {
            if (this.mMountedFolders == null) {
                return null;
            }
            String key = this.getKey(ownerAcctId, remoteFolderId);
            return this.mMountedFolders.get(key);
        }

        private String getKey(String ownerAcctId, int remoteFolderId) {
            return ownerAcctId + ":" + remoteFolderId;
        }

        private Map<String, Integer> getLocalMountpoints(OperationContext octxt, Account acct) throws ServiceException {
            if (octxt == null) {
                return null;
            }
            Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(acct, false);
            if (mbox == null) {
                throw ServiceException.FAILURE("mailbox not found for account " + acct.getId(), null);
            }
            return this.getLocalMountpoints(octxt, mbox);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Integer> getLocalMountpoints(OperationContext octxt, Mailbox mbox) throws ServiceException {
            HashMap<String, Integer> mountpoints = new HashMap<String, Integer>();
            Mailbox mailbox = mbox;
            synchronized (mailbox) {
                int folderId = 1;
                Folder folder = mbox.getFolderById(octxt, folderId);
                Set<Folder> visibleFolders = mbox.getVisibleFolders(octxt);
                this.getLocalMountpoints(folder, visibleFolders, mountpoints);
            }
            return mountpoints;
        }

        private void getLocalMountpoints(Folder folder, Set<Folder> visible, Map<String, Integer> mountpoints) throws ServiceException {
            boolean isVisible;
            boolean bl = isVisible = visible == null || visible.remove(folder);
            if (!isVisible) {
                return;
            }
            List<Folder> subfolders = folder.getSubfolders(null);
            if (!isVisible && subfolders.isEmpty()) {
                return;
            }
            if (folder instanceof Mountpoint) {
                Mountpoint mpt = (Mountpoint)folder;
                String mid = this.getKey(mpt.getOwnerId(), mpt.getRemoteId());
                mountpoints.put(mid, mpt.getId());
            }
            if (isVisible && visible != null && visible.isEmpty()) {
                return;
            }
            for (Folder subfolder : subfolders) {
                this.getLocalMountpoints(subfolder, visible, mountpoints);
            }
        }
    }
}

