/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.account;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Alias;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.EntrySearchFilter;
import com.zimbra.cs.account.GalContact;
import com.zimbra.cs.account.GlobalGrant;
import com.zimbra.cs.account.Identity;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.ShareInfoData;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.ZAttrProvisioning;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.RightModifier;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.account.ldap.LdapProvisioning;
import com.zimbra.cs.account.names.NameUtil;
import com.zimbra.cs.extension.ExtensionUtil;
import com.zimbra.cs.mime.MimeTypeInfo;
import com.zimbra.cs.util.AccountUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Provisioning
extends ZAttrProvisioning {
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static final String DEFAULT_COS_NAME = "default";
    public static final String SERVICE_MAILBOX = "mailbox";
    public static final String SERVICE_MEMCACHED = "memcached";
    public static final String CAL_MODE_EXCHANGE = "exchange";
    public static final String CAL_MODE_STANDARD = "standard";
    public static final String AM_ZIMBRA = "zimbra";
    public static final String AM_LDAP = "ldap";
    public static final String AM_AD = "ad";
    public static final String AM_KERBEROS5 = "kerberos5";
    public static final String AM_CUSTOM = "custom:";
    public static final String FP_PREFIX_KERBEROS5 = "kerberos5:";
    public static final String FP_PREFIX_AD = "ad:";
    public static final String ACCOUNT_STATUS_ACTIVE = "active";
    public static final String ACCOUNT_STATUS_MAINTENANCE = "maintenance";
    public static final String ACCOUNT_STATUS_LOCKED = "locked";
    public static final String ACCOUNT_STATUS_LOCKOUT = "lockout";
    public static final String ACCOUNT_STATUS_PENDING = "pending";
    public static final String ACCOUNT_STATUS_CLOSED = "closed";
    public static final String MAIL_STATUS_ENABLED = "enabled";
    public static final String MAIL_STATUS_DISABLED = "disabled";
    public static final String DOMAIN_STATUS_ACTIVE = "active";
    public static final String DOMAIN_STATUS_MAINTENANCE = "maintenance";
    public static final String DOMAIN_STATUS_LOCKED = "locked";
    public static final String DOMAIN_STATUS_CLOSED = "closed";
    public static final String DOMAIN_STATUS_SUSPENDED = "suspended";
    public static final String DOMAIN_STATUS_SHUTDOWN = "shutdown";
    public static final String DOMAIN_TYPE_ALIAS = "alias";
    public static final String DOMAIN_TYPE_LOCAL = "local";
    public static final String MAIL_FORMAT_TEXT = "text";
    public static final String MAIL_FORMAT_HTML = "html";
    public static final String MAIL_FORWARDREPLY_FORMAT_SAME = "same";
    public static final String MAIL_REFER_MODE_ALWAYS = "always";
    public static final String MAIL_REFER_MODE_WRONGHOST = "wronghost";
    public static final String MAIL_REFER_MODE_REVERSE_PROXIED = "reverse-proxied";
    public static final String A_dc = "dc";
    public static final String A_aliasedObjectName = "aliasedObjectName";
    public static final String LDAP_AM_NONE = "none";
    public static final String LDAP_AM_SIMPLE = "simple";
    public static final String LDAP_AM_KERBEROS5 = "kerberos5";
    public static final String DEFAULT_IDENTITY_NAME = "DEFAULT";
    public static final int MAX_ZIMBRA_ID_LEN = 127;
    private static Provisioning sProvisioning;
    private static final String DATA_COS = "COS";
    public static final int SA_ACCOUNT_FLAG = 1;
    public static final int SA_ALIAS_FLAG = 2;
    public static final int SA_DISTRIBUTION_LIST_FLAG = 4;
    public static final int SA_CALENDAR_RESOURCE_FLAG = 8;
    public static final int SA_DOMAIN_FLAG = 16;
    public static final int SD_COS_FLAG = 32;
    public static final int SO_NO_FIXUP_OBJECTCLASS = 64;
    public static final int SO_NO_FIXUP_RETURNATTRS = 128;
    public static final int SO_NO_ACCOUNT_DEFAULTS = 256;
    public static final int SO_NO_ACCOUNT_SECONDARY_DEFAULTS = 512;

    public static synchronized Provisioning getInstance() {
        if (sProvisioning == null) {
            String className = LC.zimbra_class_provisioning.value();
            if (className != null && !className.equals("")) {
                try {
                    try {
                        sProvisioning = (Provisioning)Class.forName(className).newInstance();
                    }
                    catch (ClassNotFoundException cnfe) {
                        sProvisioning = (Provisioning)ExtensionUtil.findClass(className).newInstance();
                    }
                }
                catch (Exception e) {
                    ZimbraLog.account.error((Object)("could not instantiate Provisioning interface of class '" + className + "'; defaulting to LdapProvisioning"), e);
                }
            }
            if (sProvisioning == null) {
                sProvisioning = new LdapProvisioning();
            }
        }
        return sProvisioning;
    }

    public static synchronized void setInstance(Provisioning prov) {
        if (sProvisioning != null) {
            ZimbraLog.account.warn("duplicate call to Provisioning.setInstance()");
        }
        sProvisioning = prov;
    }

    public boolean idIsUUID() {
        return true;
    }

    public void modifyAttrs(Entry e, Map<String, ? extends Object> attrs) throws ServiceException {
        this.modifyAttrs(e, attrs, false);
    }

    public abstract void modifyAttrs(Entry var1, Map<String, ? extends Object> var2, boolean var3) throws ServiceException;

    public void modifyAttrs(Entry e, Map<String, ? extends Object> attrs, boolean checkImmutable, AuthToken authToken) throws ServiceException {
        this.modifyAttrs(e, attrs, checkImmutable);
    }

    public abstract void modifyAttrs(Entry var1, Map<String, ? extends Object> var2, boolean var3, boolean var4) throws ServiceException;

    public abstract void reload(Entry var1) throws ServiceException;

    public Domain getDomain(Account acct) throws ServiceException {
        String dname = acct.getDomainName();
        return dname == null ? null : this.get(DomainBy.name, dname);
    }

    public Server getServer(Account acct) throws ServiceException {
        String serverId = acct.getAttr("zimbraMailHost");
        return serverId == null ? null : this.get(ServerBy.name, serverId);
    }

    public Cos getCOS(Account acct) throws ServiceException {
        Cos cos = (Cos)acct.getCachedData(DATA_COS);
        if (cos == null) {
            String id = acct.getCOSId();
            if (id != null) {
                cos = this.get(CosBy.id, id);
            }
            if (cos == null) {
                String domainCosId;
                Domain domain = this.getDomain(acct);
                String string = domainCosId = domain != null ? domain.getAttr("zimbraDomainDefaultCOSId", null) : null;
                if (domainCosId != null) {
                    cos = this.get(CosBy.id, domainCosId);
                }
            }
            if (cos == null) {
                cos = this.get(CosBy.name, DEFAULT_COS_NAME);
            }
            if (cos != null) {
                acct.setCachedData(DATA_COS, cos);
            }
        }
        return cos;
    }

    public String getEmailAddrByDomainAlias(String emailAddress) throws ServiceException {
        String targetDomainId;
        String domainType;
        Domain domain;
        String addr = null;
        String[] parts = emailAddress.split("@");
        if (parts.length == 2 && (domain = this.get(DomainBy.name, parts[1])) != null && DOMAIN_TYPE_ALIAS.equals(domainType = domain.getAttr("zimbraDomainType")) && (targetDomainId = domain.getAttr("zimbraDomainAliasTargetId")) != null && (domain = this.getDomainById(targetDomainId)) != null) {
            addr = parts[0] + "@" + domain.getName();
        }
        return addr;
    }

    public abstract boolean inDistributionList(Account var1, String var2) throws ServiceException;

    public boolean inDistributionList(DistributionList list, String zimbraId) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public abstract Set<String> getDistributionLists(Account var1) throws ServiceException;

    public abstract List<DistributionList> getDistributionLists(Account var1, boolean var2, Map<String, String> var3) throws ServiceException;

    public abstract List<DistributionList> getDistributionLists(DistributionList var1, boolean var2, Map<String, String> var3) throws ServiceException;

    public DistributionList getAclGroup(DistributionListBy keyType, String key) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public AclGroups getAclGroups(Account acct, boolean adminGroupsOnly) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public AclGroups getAclGroups(DistributionList list, boolean adminGroupsOnly) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public Domain getDomain(DistributionList dl) throws ServiceException {
        String dname = dl.getDomainName();
        return dname == null ? null : this.get(DomainBy.name, dname);
    }

    public abstract boolean healthCheck() throws ServiceException;

    public abstract Config getConfig() throws ServiceException;

    public abstract GlobalGrant getGlobalGrant() throws ServiceException;

    public abstract List<MimeTypeInfo> getMimeTypes(String var1) throws ServiceException;

    public abstract List<MimeTypeInfo> getAllMimeTypes() throws ServiceException;

    public abstract List<Zimlet> getObjectTypes() throws ServiceException;

    public abstract Account createAccount(String var1, String var2, Map<String, Object> var3) throws ServiceException;

    public abstract Account restoreAccount(String var1, String var2, Map<String, Object> var3, Map<String, Object> var4) throws ServiceException;

    public abstract void deleteAccount(String var1) throws ServiceException;

    public abstract void renameAccount(String var1, String var2) throws ServiceException;

    public abstract Account get(AccountBy var1, String var2) throws ServiceException;

    public Account getAccountByName(String name) throws ServiceException {
        return this.get(AccountBy.name, name);
    }

    public Account getAccountById(String id) throws ServiceException {
        return this.get(AccountBy.id, id);
    }

    public Account getAccountByAppAdminName(String name) throws ServiceException {
        return this.get(AccountBy.appAdminName, name);
    }

    public Account getAccountByForeignPrincipal(String name) throws ServiceException {
        return this.get(AccountBy.foreignPrincipal, name);
    }

    public Account getAccountByKrb5Principal(String name) throws ServiceException {
        return this.get(AccountBy.krb5Principal, name);
    }

    public Account get(AccountBy keyType, String key, boolean loadFromMaster) throws ServiceException {
        return this.get(keyType, key);
    }

    public Account get(AccountBy keyType, String key, AuthToken authToken) throws ServiceException {
        return this.get(keyType, key);
    }

    public Account get(AccountBy keyType, String key, boolean loadFromMaster, AuthToken authToken) throws ServiceException {
        return this.get(keyType, key, loadFromMaster);
    }

    public Account getAccount(String key) throws ServiceException {
        Account acct = null;
        if (Provisioning.isUUID(key)) {
            acct = this.get(AccountBy.id, key);
        } else {
            acct = this.get(AccountBy.name, key);
            if (acct == null) {
                acct = this.get(AccountBy.id, key);
            }
        }
        return acct;
    }

    public static int searchAccountStringToMask(String types) {
        int flags = 0;
        if (types.indexOf("accounts") != -1) {
            flags |= 1;
        }
        if (types.indexOf("aliases") != -1) {
            flags |= 2;
        }
        if (types.indexOf("distributionlists") != -1) {
            flags |= 4;
        }
        if (types.indexOf("resources") != -1) {
            flags |= 8;
        }
        if (types.indexOf("domains") != -1) {
            flags |= 0x10;
        }
        return flags;
    }

    public static String searchAccountMaskToString(int mask) {
        StringBuilder sb = new StringBuilder();
        if ((mask & 1) != 0) {
            sb.append("accounts");
        }
        if ((mask & 2) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("aliases");
        }
        if ((mask & 4) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("distributionlists");
        }
        if ((mask & 8) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("resources");
        }
        if ((mask & 0x10) != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("domains");
        }
        return sb.toString();
    }

    public abstract List<NamedEntry> searchAccounts(String var1, String[] var2, String var3, boolean var4, int var5) throws ServiceException;

    public abstract List<Account> getAllAdminAccounts() throws ServiceException;

    public abstract void setCOS(Account var1, Cos var2) throws ServiceException;

    public abstract void modifyAccountStatus(Account var1, String var2) throws ServiceException;

    public abstract void authAccount(Account var1, String var2, AuthContext.Protocol var3) throws ServiceException;

    public abstract void authAccount(Account var1, String var2, AuthContext.Protocol var3, Map<String, Object> var4) throws ServiceException;

    public void accountAuthed(Account acct) throws ServiceException {
    }

    public void preAuthAccount(Account acct, String accountName, String accountBy, long timestamp, long expires, String preAuth, boolean admin, Map<String, Object> authCtxt) throws ServiceException {
        if (admin) {
            throw ServiceException.FAILURE("preAuthAccount unimplemented", null);
        }
        this.preAuthAccount(acct, accountName, accountBy, timestamp, expires, preAuth, authCtxt);
    }

    public abstract void preAuthAccount(Account var1, String var2, String var3, long var4, long var6, String var8, Map<String, Object> var9) throws ServiceException;

    public abstract void changePassword(Account var1, String var2, String var3) throws ServiceException;

    public abstract void setPassword(Account var1, String var2) throws ServiceException;

    public abstract void checkPasswordStrength(Account var1, String var2) throws ServiceException;

    public abstract void addAlias(Account var1, String var2) throws ServiceException;

    public abstract void removeAlias(Account var1, String var2) throws ServiceException;

    public NamedEntry searchAliasTarget(Alias alias, boolean mustFind) throws ServiceException {
        String targetId = alias.getAttr("zimbraAliasTargetId");
        SearchOptions options = new SearchOptions();
        int flags = 0;
        flags |= 1;
        flags |= 8;
        String query = "(zimbraId=" + targetId + ")";
        options.setFlags(flags |= 4);
        options.setQuery(query);
        List<NamedEntry> entries = this.searchDirectory(options);
        if (mustFind && entries.size() == 0) {
            throw ServiceException.FAILURE("target " + targetId + " of alias " + alias.getName() + " not found " + query, null);
        }
        if (entries.size() > 1) {
            throw AccountServiceException.TOO_MANY_SEARCH_RESULTS("too many results for search " + query, null);
        }
        if (entries.size() == 0) {
            return null;
        }
        return entries.get(0);
    }

    public abstract Domain createDomain(String var1, Map<String, Object> var2) throws ServiceException;

    public abstract Domain get(DomainBy var1, String var2) throws ServiceException;

    public Domain getDomainByName(String name) throws ServiceException {
        return this.get(DomainBy.name, name);
    }

    public Domain getDomainById(String id) throws ServiceException {
        return this.get(DomainBy.id, id);
    }

    public Domain getDomainByVirtualHostname(String host) throws ServiceException {
        return this.get(DomainBy.virtualHostname, host);
    }

    public Domain getDomainByKrb5Realm(String realm) throws ServiceException {
        return this.get(DomainBy.krb5Realm, realm);
    }

    public abstract List<Domain> getAllDomains() throws ServiceException;

    public void getAllDomains(NamedEntry.Visitor visitor, String[] retAttrs) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public abstract void deleteDomain(String var1) throws ServiceException;

    public abstract Cos createCos(String var1, Map<String, Object> var2) throws ServiceException;

    public abstract Cos copyCos(String var1, String var2) throws ServiceException;

    public abstract void renameCos(String var1, String var2) throws ServiceException;

    public abstract Cos get(CosBy var1, String var2) throws ServiceException;

    public Cos getCosByName(String name) throws ServiceException {
        return this.get(CosBy.name, name);
    }

    public Cos getCosById(String id) throws ServiceException {
        return this.get(CosBy.id, id);
    }

    public abstract List<Cos> getAllCos() throws ServiceException;

    public abstract void deleteCos(String var1) throws ServiceException;

    public abstract Server getLocalServer() throws ServiceException;

    public static boolean onLocalServer(Account account) throws ServiceException {
        String target = account.getAttr("zimbraMailHost");
        String localhost = Provisioning.getInstance().getLocalServer().getAttr("zimbraServiceHostname");
        return target != null && target.equalsIgnoreCase(localhost);
    }

    public abstract Server createServer(String var1, Map<String, Object> var2) throws ServiceException;

    public abstract Server get(ServerBy var1, String var2) throws ServiceException;

    public Server getServerByName(String name) throws ServiceException {
        return this.get(ServerBy.name, name);
    }

    public Server getServerById(String id) throws ServiceException {
        return this.get(ServerBy.id, id);
    }

    public Server getServerByServiceHostname(String name) throws ServiceException {
        return this.get(ServerBy.serviceHostname, name);
    }

    public abstract List<Server> getAllServers() throws ServiceException;

    public abstract List<Server> getAllServers(String var1) throws ServiceException;

    public abstract void deleteServer(String var1) throws ServiceException;

    public abstract DistributionList createDistributionList(String var1, Map<String, Object> var2) throws ServiceException;

    public abstract DistributionList get(DistributionListBy var1, String var2) throws ServiceException;

    public DistributionList getDistributionListByName(String name) throws ServiceException {
        return this.get(DistributionListBy.name, name);
    }

    public DistributionList getDistributionListById(String id) throws ServiceException {
        return this.get(DistributionListBy.id, id);
    }

    public abstract void deleteDistributionList(String var1) throws ServiceException;

    public abstract void addAlias(DistributionList var1, String var2) throws ServiceException;

    public abstract void removeAlias(DistributionList var1, String var2) throws ServiceException;

    public abstract void renameDistributionList(String var1, String var2) throws ServiceException;

    public abstract Zimlet getZimlet(String var1) throws ServiceException;

    public abstract List<Zimlet> listAllZimlets() throws ServiceException;

    public abstract Zimlet createZimlet(String var1, Map<String, Object> var2) throws ServiceException;

    public abstract void deleteZimlet(String var1) throws ServiceException;

    public abstract CalendarResource createCalendarResource(String var1, String var2, Map<String, Object> var3) throws ServiceException;

    public abstract void deleteCalendarResource(String var1) throws ServiceException;

    public abstract void renameCalendarResource(String var1, String var2) throws ServiceException;

    public abstract CalendarResource get(CalendarResourceBy var1, String var2) throws ServiceException;

    public CalendarResource getCalendarResourceByName(String name) throws ServiceException {
        return this.get(CalendarResourceBy.name, name);
    }

    public CalendarResource getCalendarResourceById(String id) throws ServiceException {
        return this.get(CalendarResourceBy.id, id);
    }

    public CalendarResource get(CalendarResourceBy keyType, String key, boolean loadFromMaster) throws ServiceException {
        return this.get(keyType, key);
    }

    public abstract List<NamedEntry> searchCalendarResources(EntrySearchFilter var1, String[] var2, String var3, boolean var4) throws ServiceException;

    private static Locale getEntryLocale(Entry entry, String attr) {
        String lcName;
        Locale lc = null;
        if (entry != null && (lcName = entry.getAttr(attr)) != null) {
            lc = L10nUtil.lookupLocale(lcName);
        }
        return lc;
    }

    private static Locale getEntryLocale(Entry entry) {
        return Provisioning.getEntryLocale(entry, "zimbraLocale");
    }

    public Locale getLocale(Entry entry) throws ServiceException {
        if (entry instanceof Account) {
            Account account = (Account)entry;
            Locale lc = Provisioning.getEntryLocale(account, "zimbraPrefLocale");
            if (lc != null) {
                return lc;
            }
            Cos cos = this.getCOS(account);
            lc = Provisioning.getEntryLocale(cos, "zimbraPrefLocale");
            if (lc != null) {
                return lc;
            }
            lc = Provisioning.getEntryLocale(account);
            if (lc != null) {
                return lc;
            }
            lc = Provisioning.getEntryLocale(cos);
            if (lc != null) {
                return lc;
            }
            lc = Provisioning.getEntryLocale(this.getDomain(account));
            if (lc != null) {
                return lc;
            }
            return this.getLocale(this.getServer(account));
        }
        if (entry instanceof Server) {
            Locale lc = Provisioning.getEntryLocale(entry);
            if (lc != null) {
                return lc;
            }
            return this.getLocale(Provisioning.getInstance().getConfig());
        }
        if (entry instanceof Config) {
            Locale lc = Provisioning.getEntryLocale(entry);
            if (lc != null) {
                return lc;
            }
            return Locale.getDefault();
        }
        Locale lc = Provisioning.getEntryLocale(entry);
        if (lc != null) {
            return lc;
        }
        return this.getLocale(Provisioning.getInstance().getLocalServer());
    }

    public abstract List getAllAccounts(Domain var1) throws ServiceException;

    public abstract void getAllAccounts(Domain var1, NamedEntry.Visitor var2) throws ServiceException;

    public abstract void getAllAccounts(Domain var1, Server var2, NamedEntry.Visitor var3) throws ServiceException;

    public abstract List getAllCalendarResources(Domain var1) throws ServiceException;

    public abstract void getAllCalendarResources(Domain var1, NamedEntry.Visitor var2) throws ServiceException;

    public abstract void getAllCalendarResources(Domain var1, Server var2, NamedEntry.Visitor var3) throws ServiceException;

    public abstract List getAllDistributionLists(Domain var1) throws ServiceException;

    public abstract List<NamedEntry> searchAccounts(Domain var1, String var2, String[] var3, String var4, boolean var5, int var6) throws ServiceException;

    public abstract List<NamedEntry> searchDirectory(SearchOptions var1) throws ServiceException;

    public List<NamedEntry> searchDirectory(SearchOptions options, boolean useConnPool) throws ServiceException {
        return this.searchDirectory(options);
    }

    public abstract SearchGalResult searchGal(Domain var1, String var2, GAL_SEARCH_TYPE var3, String var4) throws ServiceException;

    public SearchGalResult searchGal(Domain d, String query, GAL_SEARCH_TYPE type, String token, GalContact.Visitor visitor) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public SearchGalResult searchGal(Domain d, String query, GAL_SEARCH_TYPE type, GalMode mode, String token) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public abstract SearchGalResult autoCompleteGal(Domain var1, String var2, GAL_SEARCH_TYPE var3, int var4) throws ServiceException;

    public abstract List<NamedEntry> searchCalendarResources(Domain var1, EntrySearchFilter var2, String[] var3, String var4, boolean var5) throws ServiceException;

    public abstract void addMembers(DistributionList var1, String[] var2) throws ServiceException;

    public abstract void removeMembers(DistributionList var1, String[] var2) throws ServiceException;

    public Identity getDefaultIdentity(Account account) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Set<String> identityAttrs = AttributeManager.getInstance().getAttrsInClass(AttributeClass.identity);
        for (String name : identityAttrs) {
            String value = account.getAttr(name, null);
            if (value == null) continue;
            attrs.put(name, value);
        }
        if (attrs.get("zimbraPrefIdentityName") == null) {
            attrs.put("zimbraPrefIdentityName", DEFAULT_IDENTITY_NAME);
        }
        String fromAddress = (String)attrs.get("zimbraPrefFromAddress");
        String fromDisplay = (String)attrs.get("zimbraPrefFromDisplay");
        if (fromAddress == null || fromDisplay == null) {
            InternetAddress ia = AccountUtil.getFriendlyEmailAddress(account);
            if (fromAddress == null) {
                attrs.put("zimbraPrefFromAddress", ia.getAddress());
            }
            if (fromDisplay == null) {
                attrs.put("zimbraPrefFromDisplay", ia.getPersonal());
            }
        }
        attrs.put("zimbraPrefIdentityId", account.getId());
        if (attrs.get("zimbraPrefForwardReplyFormat") == null) {
            boolean forwardReplyInOriginalFormat = account.getBooleanAttr("zimbraPrefForwardReplyInOriginalFormat", false);
            if (forwardReplyInOriginalFormat) {
                attrs.put("zimbraPrefForwardReplyFormat", MAIL_FORWARDREPLY_FORMAT_SAME);
            } else {
                String composeFormat = account.getAttr("zimbraPrefComposeFormat", null);
                if (composeFormat == null) {
                    attrs.put("zimbraPrefForwardReplyFormat", MAIL_FORMAT_TEXT);
                } else {
                    attrs.put("zimbraPrefForwardReplyFormat", composeFormat);
                }
            }
        }
        return new Identity(account, DEFAULT_IDENTITY_NAME, account.getId(), attrs, this);
    }

    public abstract Identity createIdentity(Account var1, String var2, Map<String, Object> var3) throws ServiceException;

    public abstract Identity restoreIdentity(Account var1, String var2, Map<String, Object> var3) throws ServiceException;

    public abstract void modifyIdentity(Account var1, String var2, Map<String, Object> var3) throws ServiceException;

    public abstract void deleteIdentity(Account var1, String var2) throws ServiceException;

    public abstract List<Identity> getAllIdentities(Account var1) throws ServiceException;

    public abstract Identity get(Account var1, IdentityBy var2, String var3) throws ServiceException;

    public abstract Signature createSignature(Account var1, String var2, Map<String, Object> var3) throws ServiceException;

    public abstract Signature restoreSignature(Account var1, String var2, Map<String, Object> var3) throws ServiceException;

    public abstract void modifySignature(Account var1, String var2, Map<String, Object> var3) throws ServiceException;

    public abstract void deleteSignature(Account var1, String var2) throws ServiceException;

    public abstract List<Signature> getAllSignatures(Account var1) throws ServiceException;

    public abstract Signature get(Account var1, SignatureBy var2, String var3) throws ServiceException;

    public abstract DataSource createDataSource(Account var1, DataSource.Type var2, String var3, Map<String, Object> var4) throws ServiceException;

    public abstract DataSource createDataSource(Account var1, DataSource.Type var2, String var3, Map<String, Object> var4, boolean var5) throws ServiceException;

    public abstract DataSource restoreDataSource(Account var1, DataSource.Type var2, String var3, Map<String, Object> var4) throws ServiceException;

    public abstract void modifyDataSource(Account var1, String var2, Map<String, Object> var3) throws ServiceException;

    public abstract void deleteDataSource(Account var1, String var2) throws ServiceException;

    public abstract List<DataSource> getAllDataSources(Account var1) throws ServiceException;

    public abstract DataSource get(Account var1, DataSourceBy var2, String var3) throws ServiceException;

    public abstract XMPPComponent createXMPPComponent(String var1, Domain var2, Server var3, Map<String, Object> var4) throws ServiceException;

    public abstract XMPPComponent get(XMPPComponentBy var1, String var2) throws ServiceException;

    public abstract List<XMPPComponent> getAllXMPPComponents() throws ServiceException;

    public abstract void deleteXMPPComponent(XMPPComponent var1) throws ServiceException;

    public Map<String, List<RightsDoc>> getRightsDoc(String[] pkgs) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public Right getRight(String rightName, boolean expandAllAttrs) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public List<Right> getAllRights(String targetType, boolean expandAllAttrs) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public boolean checkRight(String targetType, TargetBy targetBy, String target, GranteeBy granteeBy, String grantee, String right, Map<String, Object> attrs, AccessManager.ViaGrant via) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public RightCommand.AllEffectiveRights getAllEffectiveRights(String granteeType, GranteeBy granteeBy, String grantee, boolean expandSetAttrs, boolean expandGetAttrs) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public RightCommand.EffectiveRights getEffectiveRights(String targetType, TargetBy targetBy, String target, GranteeBy granteeBy, String grantee, boolean expandSetAttrs, boolean expandGetAttrs) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public RightCommand.EffectiveRights getCreateObjectAttrs(String targetType, DomainBy domainBy, String domainStr, CosBy cosBy, String cosStr, GranteeBy granteeBy, String grantee) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public RightCommand.Grants getGrants(String targetType, TargetBy targetBy, String target, String granteeType, GranteeBy granteeBy, String grantee, boolean granteeIncludeGroupsGranteeBelongs) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public void grantRight(String targetType, TargetBy targetBy, String target, String granteeType, GranteeBy granteeBy, String grantee, String right, RightModifier rightModifier) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public void revokeRight(String targetType, TargetBy targetBy, String target, String granteeType, GranteeBy granteeBy, String grantee, String right, RightModifier rightModifier) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public abstract void flushCache(CacheEntryType var1, CacheEntry[] var2) throws ServiceException;

    public CountAccountResult countAccount(Domain domain) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public static void validEmailAddress(String addr) throws ServiceException {
        NameUtil.validEmailAddress(addr);
    }

    public static boolean isUUID(String value) {
        return value.length() == 36 && value.charAt(8) == '-' && value.charAt(13) == '-' && value.charAt(18) == '-' && value.charAt(23) == '-';
    }

    public String getProxyAuthToken(String acctId) throws ServiceException {
        return null;
    }

    public boolean isOfflineProxyServer(Server server) {
        return false;
    }

    public boolean allowsPingRemote() {
        return true;
    }

    public void purgeAccountCalendarCache(String accountId) throws ServiceException {
    }

    public void reloadMemcachedClientConfig() throws ServiceException {
    }

    public void publishShareInfo(DistributionList dl, PublishShareInfoAction action, Account ownerAcct, String folderIdOrPath) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public void getPublishedShareInfo(DistributionList dl, Account ownerAcct, PublishedShareInfoVisitor visitor) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public void getShareInfo(Account ownerAcct, PublishedShareInfoVisitor visitor) throws ServiceException {
        throw ServiceException.FAILURE("unsupported", null);
    }

    public Map<String, String> getNamesForIds(Set<String> ids, EntryType type) throws ServiceException {
        return new HashMap<String, String>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntryType {
        account,
        group,
        config,
        cos,
        domain,
        server,
        zimlet;

    }

    public static interface PublishedShareInfoVisitor {
        public void visit(ShareInfoData var1) throws ServiceException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PublishShareInfoAction {
        add,
        remove;


        public static PublishShareInfoAction fromString(String action) throws ServiceException {
            try {
                return PublishShareInfoAction.valueOf(action);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown ShareInfo action: " + action, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CountAccountResult {
        private List<CountAccountByCos> mCountAccountByCos = new ArrayList<CountAccountByCos>();

        public void addCountAccountByCosResult(String cosId, String cosName, long count) {
            CountAccountByCos r = new CountAccountByCos(cosId, cosName, count);
            this.mCountAccountByCos.add(r);
        }

        public List<CountAccountByCos> getCountAccountByCos() {
            return this.mCountAccountByCos;
        }

        public static class CountAccountByCos {
            private String mCosId;
            private String mCosName;
            private long mCount;

            CountAccountByCos(String cosId, String cosName, long count) {
                this.mCosId = cosId;
                this.mCosName = cosName;
                this.mCount = count;
            }

            public String getCosId() {
                return this.mCosId;
            }

            public String getCosName() {
                return this.mCosName;
            }

            public long getCount() {
                return this.mCount;
            }
        }
    }

    public static class CacheEntry {
        public CacheEntryBy mEntryBy;
        public String mEntryIdentity;

        public CacheEntry(CacheEntryBy entryBy, String entryIdentity) {
            this.mEntryBy = entryBy;
            this.mEntryIdentity = entryIdentity;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheEntryBy {
        id,
        name;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheEntryType {
        locale,
        skin,
        license,
        account,
        group,
        config,
        cos,
        domain,
        server,
        zimlet;


        public static CacheEntryType fromString(String s) throws ServiceException {
            try {
                return CacheEntryType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown cache type: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RightsDoc {
        String mCmd;
        List<String> mRights;
        List<String> mNotes;

        public RightsDoc(String cmd) {
            this.mCmd = cmd;
            this.mRights = new ArrayList<String>();
            this.mNotes = new ArrayList<String>();
        }

        public void addRight(String right) {
            this.mRights.add(right);
        }

        public void addNote(String note) {
            this.mNotes.add(note);
        }

        public String getCmd() {
            return this.mCmd;
        }

        public List<String> getRights() {
            return this.mRights;
        }

        public List<String> getNotes() {
            return this.mNotes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GranteeBy {
        id,
        name;


        public static GranteeBy fromString(String s) throws ServiceException {
            try {
                return GranteeBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TargetBy {
        id,
        name;


        public static TargetBy fromString(String s) throws ServiceException {
            try {
                return TargetBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XMPPComponentBy {
        id,
        name,
        serviceHostname;


        public static XMPPComponentBy fromString(String s) throws ServiceException {
            try {
                return XMPPComponentBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataSourceBy {
        id,
        name;


        public static DataSourceBy fromString(String s) throws ServiceException {
            try {
                return DataSourceBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SignatureBy {
        id,
        name;


        public static SignatureBy fromString(String s) throws ServiceException {
            try {
                return SignatureBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IdentityBy {
        id,
        name;


        public static IdentityBy fromString(String s) throws ServiceException {
            try {
                return IdentityBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VisitorSearchGalResult
    extends SearchGalResult {
        private GalContact.Visitor mVisitor;
        private int mNumMatches;

        private VisitorSearchGalResult(GalContact.Visitor visitor) {
            this.mVisitor = visitor;
        }

        @Override
        public List<GalContact> getMatches() throws ServiceException {
            throw ServiceException.FAILURE("getMatches not supported for VisitorSearchGalResult", null);
        }

        @Override
        public int getNumMatches() {
            return this.mNumMatches;
        }

        @Override
        public void addMatch(GalContact gc) throws ServiceException {
            this.mVisitor.visit(gc);
            ++this.mNumMatches;
        }

        @Override
        public void addMatches(SearchGalResult result) throws ServiceException {
            if (!(result instanceof VisitorSearchGalResult)) {
                throw ServiceException.FAILURE("cannot addMatches with non VisitorSearchGalResult", null);
            }
            this.mNumMatches += result.getNumMatches();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchGalResult {
        private String mToken;
        private boolean mHadMore;
        private List<GalContact> mMatches = new ArrayList<GalContact>();
        private String mTokenizeKey;

        public static SearchGalResult newSearchGalResult(GalContact.Visitor visitor) {
            if (visitor == null) {
                return new SearchGalResult();
            }
            return new VisitorSearchGalResult(visitor);
        }

        private SearchGalResult() {
        }

        public String getToken() {
            return this.mToken;
        }

        public void setToken(String token) {
            this.mToken = token;
        }

        public boolean getHadMore() {
            return this.mHadMore;
        }

        public void setHadMore(boolean hadMore) {
            this.mHadMore = hadMore;
        }

        public String getTokenizeKey() {
            return this.mTokenizeKey;
        }

        public void setTokenizeKey(String tokenizeKey) {
            this.mTokenizeKey = tokenizeKey;
        }

        public List<GalContact> getMatches() throws ServiceException {
            return this.mMatches;
        }

        public int getNumMatches() {
            return this.mMatches.size();
        }

        public void addMatch(GalContact gc) throws ServiceException {
            this.mMatches.add(gc);
        }

        public void addMatches(SearchGalResult result) throws ServiceException {
            this.mMatches.addAll(result.getMatches());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GalMode {
        zimbra,
        ldap,
        both;


        public static GalMode fromString(String s) throws ServiceException {
            try {
                if (s == null) {
                    return null;
                }
                return GalMode.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown gal mode: " + s, e);
            }
        }
    }

    public static class SearchOptions {
        public static final String SORT_BY_TARGET_NAME = "targetName";
        private Domain mDomain;
        private String mBase;
        private String mQuery;
        private String[] mReturnAttrs;
        private String mSortAttr;
        private boolean mSortAscending;
        private int mFlags;
        private int mMaxResults;
        private boolean mConvertIDNToAscii;
        private boolean mOnMaster;

        public Domain getDomain() {
            return this.mDomain;
        }

        public void setDomain(Domain domain) {
            this.mDomain = domain;
        }

        public String getBase() {
            return this.mBase;
        }

        public void setBase(String base) {
            this.mBase = base;
        }

        public String getQuery() {
            return this.mQuery;
        }

        public void setQuery(String query) {
            this.mQuery = query;
        }

        public String[] getReturnAttrs() {
            return this.mReturnAttrs;
        }

        public void setReturnAttrs(String[] returnAttrs) {
            this.mReturnAttrs = returnAttrs;
        }

        public String getSortAttr() {
            return this.mSortAttr;
        }

        public void setSortAttr(String sortAttr) {
            this.mSortAttr = sortAttr;
        }

        public boolean isSortAscending() {
            return this.mSortAscending;
        }

        public void setSortAscending(boolean sortAscending) {
            this.mSortAscending = sortAscending;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public void setFlags(int flags) {
            this.mFlags = flags;
        }

        public int getMaxResults() {
            return this.mMaxResults;
        }

        public void setMaxResults(int maxResults) {
            this.mMaxResults = maxResults;
        }

        public boolean getConvertIDNToAscii() {
            return this.mConvertIDNToAscii;
        }

        public void setConvertIDNToAscii(boolean convertIDNToAscii) {
            this.mConvertIDNToAscii = convertIDNToAscii;
        }

        public boolean getOnMaster() {
            return this.mOnMaster;
        }

        public void setOnMaster(boolean onMaster) {
            this.mOnMaster = onMaster;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CalendarResourceBy {
        id,
        foreignPrincipal,
        name;


        public static CalendarResourceBy fromString(String s) throws ServiceException {
            try {
                return CalendarResourceBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZimletBy {
        id,
        name;


        public static ZimletBy fromString(String s) throws ServiceException {
            try {
                return ZimletBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DistributionListBy {
        id,
        name;


        public static DistributionListBy fromString(String s) throws ServiceException {
            try {
                return DistributionListBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerBy {
        id,
        name,
        serviceHostname;


        public static ServerBy fromString(String s) throws ServiceException {
            try {
                return ServerBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CosBy {
        id,
        name;


        public static CosBy fromString(String s) throws ServiceException {
            try {
                return CosBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DomainBy {
        id,
        name,
        virtualHostname,
        krb5Realm;


        public static DomainBy fromString(String s) throws ServiceException {
            try {
                return DomainBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GAL_SEARCH_TYPE {
        ALL,
        USER_ACCOUNT,
        CALENDAR_RESOURCE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccountBy {
        adminName,
        appAdminName,
        id,
        foreignPrincipal,
        name,
        krb5Principal;


        public static AccountBy fromString(String s) throws ServiceException {
            try {
                return AccountBy.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown key: " + s, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AclGroups {
        List<MemberOf> mMemberOf;
        List<String> mGroupIds;

        public AclGroups(List<MemberOf> memberOf, List<String> groupIds) {
            this.mMemberOf = memberOf;
            this.mGroupIds = groupIds;
        }

        public AclGroups() {
            this(new ArrayList<MemberOf>(), new ArrayList<String>());
        }

        public List<MemberOf> memberOf() {
            return this.mMemberOf;
        }

        public List<String> groupIds() {
            return this.mGroupIds;
        }
    }

    public static class MemberOf {
        private String mId;
        private boolean mIsAdminGroup;

        public MemberOf(String id, boolean isAdminGroup) {
            this.mId = id;
            this.mIsAdminGroup = isAdminGroup;
        }

        public String getId() {
            return this.mId;
        }

        public boolean isAdminGroup() {
            return this.mIsAdminGroup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MailMode {
        http,
        https,
        mixed,
        both,
        redirect;


        public static MailMode fromString(String s) throws ServiceException {
            try {
                return MailMode.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ServiceException.INVALID_REQUEST("unknown mail mode: " + s, e);
            }
        }
    }
}

